/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.emp.app.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.query.server.PagingHelper;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.emp.PersonPhotoCollection;
import com.kingdee.eas.hr.emp.PersonPhotoFactory;
import com.kingdee.eas.hr.emp.PersonPhotoInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.base.syssetting.util.SHRCheck;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.sql.Blob;
import java.sql.SQLException;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PersonPhotoUtil {
    private static Pattern pattern = Pattern.compile("[\u4e00-\u9fa5]");
    public static final String EAS_HOME = System.getProperty("EAS_HOME");
    public static final String SHR_WEB_WAR_NAME = "shr_web.war";
    public static final String EAS_EAR_ROOT = EAS_HOME + File.separator + "server" + File.separator + "deploy" + File.separator + "easweb.ear";
    public static final String photoPath = EAS_EAR_ROOT + File.separator + "shr_web.war" + File.separator + "personPhoto";
    private static final String[] hexDigits = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "a", "b", "c", "d", "e", "f"};

    public static String string2String(String str) {
        MessageDigest messageDigest = null;
        byte[] resultByteArray = null;
        try {
            messageDigest = MessageDigest.getInstance("MD5");
            byte[] inputByteArray = str.getBytes();
            messageDigest.update(inputByteArray);
            resultByteArray = messageDigest.digest();
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        return PersonPhotoUtil.byteArrayToHexString(resultByteArray);
    }

    public static Map getPersonPhotoPath(String personId, Context ctx) throws EASBizException, BOSException {
        HashMap<String, String> map = new HashMap<String, String>();
        String fileName = PersonPhotoUtil.string2String(personId);
        String AIS = ctx.getAIS();
        String AISpath = null;
        AISpath = PersonPhotoUtil.isContainChinese(AIS) ? PersonPhotoUtil.string2String(AIS) : AIS;
        String filePath = photoPath + File.separator + AISpath + File.separator + Integer.parseInt(fileName.substring(0, 5), 16) % 19 + File.separator + fileName + ".jpg";
        File file = new File(SHRCheck.checkFilePath((String)filePath));
        PersonPhotoCollection personPhotoCollection = PersonPhotoFactory.getLocalInstance(ctx).getPersonPhotoCollection("select imageData,lastUpdateTime where person = '" + personId + "'");
        PersonPhotoInfo personPhoto = null;
        if (personPhotoCollection.size() > 0) {
            personPhoto = personPhotoCollection.get(0);
            try {
                if (!file.exists()) {
                    File parentFile = file.getParentFile();
                    if (!parentFile.exists()) {
                        parentFile.mkdirs();
                    }
                    file.createNewFile();
                    if (null != personPhoto.getImageData()) {
                        PersonPhotoUtil.uploadFile(filePath, personPhoto.getImageData());
                        DbUtil.execute((Context)ctx, (String)("update t_hr_personphoto set fisInFile = 1 where fpersonid = '" + personId + "'"));
                    }
                } else {
                    Calendar cal = Calendar.getInstance();
                    long fileTime = file.lastModified();
                    cal.setTimeInMillis(fileTime);
                    Date fileDate = cal.getTime();
                    if (personPhoto.getImageData() != null && personPhoto.getLastUpdateTime().after(fileDate)) {
                        file.delete();
                        PersonPhotoUtil.uploadFile(filePath, personPhoto.getImageData());
                    }
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new BOSException((Throwable)e);
            }
        }
        map.put("server", filePath);
        map.put("web", "/shr/personPhoto/" + AISpath + "/" + Integer.parseInt(fileName.substring(0, 5), 16) % 19 + "/" + fileName + ".jpg?v=" + System.currentTimeMillis());
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void uploadFile(String filePath, byte[] imageData) throws IOException {
        for (int i = 0; i < imageData.length; ++i) {
            if (imageData[i] >= 0) continue;
            int n = i;
            imageData[n] = (byte)(imageData[n] + 256);
        }
        try (OutputStream out = null;){
            File file = new File(SHRCheck.checkFilePath((String)filePath));
            out = new FileOutputStream(file);
            out.write(imageData);
            out.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void personPhoto2File(Context ctx, String personId, byte[] imageData) {
        OutputStream out = null;
        try {
            String AISString = ctx.getAIS();
            String AISpath = null;
            AISpath = PersonPhotoUtil.isContainChinese(AISString) ? PersonPhotoUtil.string2String(AISString) : AISString;
            PersonPhotoInfo personPhotoInfo = null;
            if (!PersonPhotoFactory.getLocalInstance(ctx).exists("select isInFile where person = '" + personId + "'")) {
                return;
            }
            personPhotoInfo = PersonPhotoFactory.getLocalInstance(ctx).getPersonPhotoInfo("select isInFile where person = '" + personId + "'");
            String fileName = PersonPhotoUtil.string2String(personId);
            String filePath = photoPath + File.separator + AISpath + File.separator + Integer.parseInt(fileName.substring(0, 5), 16) % 19;
            File dir = new File(SHRCheck.checkFilePath((String)filePath));
            if (dir.exists()) {
                if (dir.isDirectory()) {
                    System.out.println("dir exists");
                } else {
                    System.out.println("the same name file exists, can not create dir");
                }
            } else {
                dir.mkdirs();
            }
            File file = new File(SHRCheck.checkFilePath((String)(filePath + File.separator + fileName + ".jpg")));
            if (file.exists() && file.isFile()) {
                file.delete();
            }
            for (int i = 0; i < imageData.length; ++i) {
                if (imageData[i] >= 0) continue;
                int n = i;
                imageData[n] = (byte)(imageData[n] + 256);
            }
            out = new FileOutputStream(new File(SHRCheck.checkFilePath((String)(filePath + File.separator + fileName + ".jpg"))));
            out.write(imageData);
            out.flush();
            DbUtil.execute((Context)ctx, (String)("update t_hr_personphoto set fisInFile = 1 where fpersonid = '" + personId + "'"));
            return;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static void deletePhoto(Context ctx, String personId) {
        String AISString = ctx.getAIS();
        String AISpath = null;
        AISpath = PersonPhotoUtil.isContainChinese(AISString) ? PersonPhotoUtil.string2String(AISString) : AISString;
        String fileName = PersonPhotoUtil.string2String(personId);
        String filePath = photoPath + File.separator + AISpath + File.separator + Integer.parseInt(fileName.substring(0, 5), 16) % 19;
        File file = new File(SHRCheck.checkFilePath((String)(filePath + File.separator + fileName + ".jpg")));
        if (file.exists() && file.isFile()) {
            file.delete();
        }
    }

    public static void updatePersonid(Context ctx, String oldPersonid, String newPersonid) {
        String AISString = ctx.getAIS();
        String AISpath = null;
        AISpath = PersonPhotoUtil.isContainChinese(AISString) ? PersonPhotoUtil.string2String(AISString) : AISString;
        String newFileName = PersonPhotoUtil.string2String(newPersonid);
        String newFilePath = photoPath + File.separator + AISpath + File.separator + Integer.parseInt(newFileName.substring(0, 5), 16) % 19;
        String oldFileName = PersonPhotoUtil.string2String(oldPersonid);
        String oldFilePath = photoPath + File.separator + AISpath + File.separator + Integer.parseInt(oldFileName.substring(0, 5), 16) % 19;
        File file = new File(SHRCheck.checkFilePath((String)(oldFilePath + File.separator + oldFileName + ".jpg")));
        if (file.exists() && file.isFile()) {
            file.delete();
        }
        try {
            PersonPhotoInfo ppInfo = null;
            if (!PersonPhotoFactory.getLocalInstance(ctx).exists("where person = '" + newPersonid + "'")) {
                return;
            }
            ppInfo = PersonPhotoFactory.getLocalInstance(ctx).getPersonPhotoInfo("where person = '" + newPersonid + "'");
            byte[] imageData = ppInfo.getImageData();
            PersonPhotoUtil.personPhoto2File(ctx, newPersonid, imageData);
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
    }

    public static void photo2File(Context ctx, String personId) {
        if (personId == null) {
            return;
        }
        try {
            PersonPhotoInfo ppInfo = null;
            if (PersonPhotoFactory.getLocalInstance(ctx).exists("where person = '" + personId + "'")) {
                ppInfo = PersonPhotoFactory.getLocalInstance(ctx).getPersonPhotoInfo("where person = '" + personId + "'");
                if (ppInfo.isIsInFile()) {
                    return;
                }
            } else {
                return;
            }
            byte[] imageData = ppInfo.getImageData();
            PersonPhotoUtil.personPhoto2File(ctx, personId, imageData);
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
    }

    public static void photos2File(Context ctx, String[] personIds) {
        for (int i = 0; i < personIds.length; ++i) {
            PersonPhotoUtil.photo2File(ctx, personIds[i]);
        }
    }

    public static void allPhoto2File(Context ctx) {
        try {
            String AISString = ctx.getAIS();
            String AISpath = null;
            AISpath = PersonPhotoUtil.isContainChinese(AISString) ? PersonPhotoUtil.string2String(AISString) : AISString;
            boolean hasDir = false;
            hasDir = new File(SHRCheck.checkFilePath((String)(photoPath + "/" + AISpath))).exists();
            int selectNum = 30;
            PagingHelper pageHelper = new PagingHelper();
            int personCount = 0;
            String photoCountSql = null;
            photoCountSql = hasDir ? "select count(fid) count from t_hr_personphoto where fisInFile = 0" : "select count(fid) count from t_hr_personphoto";
            IRowSet photoCountRowSet = DbUtil.executeQuery((Context)ctx, (String)photoCountSql);
            while (photoCountRowSet.next()) {
                personCount = photoCountRowSet.getInt("count");
            }
            String photoIdSql = null;
            photoIdSql = hasDir ? "select fid from t_hr_personphoto where fisInFile = 0 order by fid" : "select fid from t_hr_personphoto order by fid";
            if (personCount > 0) {
                int pages = (int)Math.ceil((double)personCount / (double)selectNum);
                for (int i = 0; i < pages; ++i) {
                    String pagingSql = pageHelper.getPagingSqlNoOptmize(ctx, photoIdSql, i * selectNum, selectNum);
                    String realPagingSql = pagingSql.substring(pagingSql.toUpperCase().split("FROM")[0].length());
                    String photoImageSql = "/*dialect*/select fpersonid,fimageData from t_hr_personphoto where fid in ( select fid " + realPagingSql + ")";
                    IRowSet photoImageRowSet = DbUtil.executeQuery((Context)ctx, (String)photoImageSql);
                    while (photoImageRowSet.next()) {
                        String personid = photoImageRowSet.getString("fpersonid");
                        if (hasDir) {
                            PersonPhotoUtil.photo2File(ctx, personid);
                            continue;
                        }
                        Blob blob = photoImageRowSet.getBlob("fimageData");
                        if (blob != null) {
                            byte[] imageData = blob.getBytes(1L, (int)blob.length());
                            PersonPhotoUtil.personPhoto2File(ctx, personid, imageData);
                            imageData = null;
                        }
                        blob = null;
                    }
                    photoImageRowSet = null;
                }
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    private static String byteArrayToHexString(byte[] b) {
        StringBuffer resultSb = new StringBuffer();
        if (b != null) {
            for (int i = 0; i < b.length; ++i) {
                resultSb.append(PersonPhotoUtil.byteToHexString(b[i]));
            }
        }
        return resultSb.toString();
    }

    private static String byteToHexString(byte b) {
        int n = b;
        if (n < 0) {
            n = 256 + n;
        }
        int d1 = n / 16;
        int d2 = n % 16;
        return hexDigits[d1] + hexDigits[d2];
    }

    public static boolean isContainChinese(String str) {
        Matcher m = pattern.matcher(str);
        return m.find();
    }

    public static void cleanPersonPhotoInDB(Context ctx) throws BOSException {
        StringBuilder sql = new StringBuilder("delete from T_HR_PersonPhoto ").append(" where Fpersonid not in ( select FpersonId as Fpersonid from T_HR_PreEntryPerson where Fpersonid is not null ").append(" union select Fid as Fpersonid from T_BD_Person where Fid is not null ").append(" union select FTempPersonId as Fpersonid from T_HR_tempPersonPhoto where FTempPersonId is not null ").append(" union select FPersonId as Fpersonid from T_HR_tempPersonPhoto where FPersonId is not null) ");
        DbUtil.execute((Context)ctx, (String)sql.toString());
    }
}

