/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.emp.app.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.basedata.org.HROrgUnitInfo;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonHisCollection;
import com.kingdee.eas.basedata.person.PersonHisFactory;
import com.kingdee.eas.basedata.person.PersonHisInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.base.EmpHRORelationHisInfo;
import com.kingdee.eas.hr.emp.EmployeeBizException;
import com.kingdee.eas.hr.emp.EmployeeBosBizException;
import com.kingdee.eas.hr.emp.PersonOtherInfoFactory;
import com.kingdee.eas.hr.emp.PersonOtherInfoHISCollection;
import com.kingdee.eas.hr.emp.PersonOtherInfoHISFactory;
import com.kingdee.eas.hr.emp.PersonOtherInfoHISInfo;
import com.kingdee.eas.hr.emp.app.util.SHREmpOptBizManageTool;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.base.permission.api.auth.SHRUserOrgPermissionApi;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Set;
import org.apache.log4j.Logger;

public class SHREmpOptPersonTool {
    private static Logger logger = Logger.getLogger((String)SHREmpOptPersonTool.class.getName());

    public static boolean checkPersonIsInOrgRange(Context ctx, String personId, String permItemId, String currentUserId) throws BOSException {
        Set orgSet = SHRUserOrgPermissionApi.getUserAdminRangeIdSet((Context)ctx, (String)currentUserId, (String)permItemId);
        Set hrOrgSet = SHRUserOrgPermissionApi.getUserHROrgRangeIdSet((Context)ctx, (String)currentUserId, (String)permItemId);
        EmpHRORelationHisInfo empRelationInfo = SHREmpOptBizManageTool.getEmpHRORelationHisInfo(ctx, personId);
        if (empRelationInfo != null) {
            boolean buAndDu;
            boolean isUseDefault = empRelationInfo.isUseDefault();
            String hrOrgId = empRelationInfo.getHrOrgUnit().getId().toString();
            String adminOrgId = empRelationInfo.getEmpOrgRelation().getAdminOrg().getId().toString();
            boolean ouAndBu = orgSet.contains(adminOrgId) && hrOrgSet.contains(hrOrgId);
            boolean bl = buAndDu = hrOrgSet.contains(hrOrgId) && !isUseDefault;
            if (ouAndBu || buAndDu) {
                return true;
            }
        } else {
            try {
                if (PersonOtherInfoFactory.getLocalInstance(ctx).exists("where person.id= '" + personId + "' and hasBURelation = 1")) {
                    EmployeeBosBizException bizException = new EmployeeBosBizException(EmployeeBosBizException.SYS_UPDATE_EMP);
                    throw new BOSException(bizException.getMessage());
                }
                EmployeeBosBizException bizException = new EmployeeBosBizException(EmployeeBosBizException.EMP_INIT_OPRTION);
                throw new BOSException(bizException.getMessage());
            }
            catch (EASBizException e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    public static boolean checkPersonIsInPositionLeaderRange(Context ctx, String personId, String permItemId, String currentUserId) throws BOSException {
        Set orgSet = SHRUserOrgPermissionApi.getUserAdminRangeIdSet((Context)ctx, (String)currentUserId, (String)permItemId);
        Set hrOrgSet = SHRUserOrgPermissionApi.getUserHROrgRangeIdSet((Context)ctx, (String)currentUserId, (String)permItemId);
        EmpHRORelationHisInfo empRelationInfo = SHREmpOptBizManageTool.getEmpHRORelationHisInfo(ctx, personId);
        if (empRelationInfo != null) {
            boolean buAndDu;
            boolean isUseDefault = empRelationInfo.isUseDefault();
            String hrOrgId = empRelationInfo.getHrOrgUnit().getId().toString();
            String adminOrgId = empRelationInfo.getEmpOrgRelation().getAdminOrg().getId().toString();
            boolean ouAndBu = orgSet.contains(adminOrgId) && hrOrgSet.contains(hrOrgId);
            boolean bl = buAndDu = hrOrgSet.contains(hrOrgId) && !isUseDefault;
            if (ouAndBu || buAndDu) {
                return true;
            }
        } else {
            try {
                if (PersonOtherInfoFactory.getLocalInstance(ctx).exists("where person.id= '" + personId + "' and hasBURelation = 1")) {
                    throw new BOSException((Throwable)((Object)new EmployeeBosBizException(EmployeeBosBizException.SYS_UPDATE_EMP)));
                }
                throw new BOSException((Throwable)((Object)new EmployeeBosBizException(EmployeeBosBizException.EMP_INIT_OPRTION)));
            }
            catch (EASBizException e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    public static boolean checkAdminOrgIsInRange(Context ctx, String permItemId, String adminOrgId, String currentUserId) throws EASBizException, BOSException {
        Set hrOrgSet = SHRUserOrgPermissionApi.getUserHROrgRangeIdSet((Context)ctx, (String)currentUserId, (String)permItemId);
        HROrgUnitInfo hrOrgUnit = SHREmpOptBizManageTool.getManageHROByAdminOrg(ctx, adminOrgId);
        Set orgSet = SHRUserOrgPermissionApi.getUserAdminRangeIdSet((Context)ctx, (String)currentUserId, (String)permItemId);
        return hrOrgSet.contains(hrOrgUnit.getId().toString()) && orgSet.contains(adminOrgId);
    }

    public static PersonInfo getPersonDetailInfo(Context ctx, String personID) {
        PersonInfo personInfo = null;
        if (StringUtils.isEmpty((String)personID)) {
            return null;
        }
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("employeeType.id"));
        sic.add(new SelectorItemInfo("employeeType.name"));
        sic.add(new SelectorItemInfo("employeeType.number"));
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("cell"));
        sic.add(new SelectorItemInfo("birthday"));
        try {
            ObjectUuidPK personPk = new ObjectUuidPK(personID);
            if (!PersonFactory.getLocalInstance((Context)ctx).exists((IObjectPK)personPk)) {
                throw new BOSException((Throwable)((Object)new EmployeeBosBizException(EmployeeBosBizException.THIS_EMP_NOT_EXIST, new Object[]{personID})));
            }
            personInfo = PersonFactory.getLocalInstance((Context)ctx).getPersonInfo((IObjectPK)personPk, sic);
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return personInfo;
    }

    public static void updatePersonEFFDT(Context ctx, String personId, Date newEFFDT, Date lastUpdateTime) throws BOSException, EASBizException {
        if (newEFFDT != null) {
            PersonHisCollection phColl = PersonHisFactory.getLocalInstance((Context)ctx).getPersonHisCollection("select id,EFFDT where historyRelateID = '" + personId + "' order by EFFDT ASC");
            PersonOtherInfoHISCollection poColl = PersonOtherInfoHISFactory.getLocalInstance(ctx).getPersonOtherInfoHISCollection("select id,EFFDT where person = '" + personId + "' order by EFFDT ASC");
            if (phColl.size() > 0) {
                PersonHisInfo personHis = phColl.get(0);
                SelectorItemCollection sics = new SelectorItemCollection();
                boolean isNeedUpdatePersonEFFDT = false;
                if (DateTimeUtils.dayBefore((Date)newEFFDT, (Date)personHis.getEFFDT())) {
                    isNeedUpdatePersonEFFDT = true;
                }
                if (isNeedUpdatePersonEFFDT) {
                    if (lastUpdateTime == null) {
                        lastUpdateTime = new Date();
                    }
                    personHis.setEFFDT(newEFFDT);
                    personHis.setLastUpdateUser(ContextUtil.getCurrentUserInfo((Context)ctx));
                    personHis.setLastUpdateTime(new Timestamp(lastUpdateTime.getTime()));
                    sics.add("EFFDT");
                    sics.add("lastUpdateUser");
                    sics.add("lastUpdateTime");
                    PersonHisFactory.getLocalInstance((Context)ctx).updatePartial((CoreBaseInfo)personHis, sics);
                    StringBuilder sql = new StringBuilder("select top 1 FEFFDT,FLastUpdateUserId,FLastUpdateTime from T_BD_PersonHis where FHistoryRelateId='").append(personId).append("' order by FEFFDT DESC");
                    IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
                    try {
                        if (rs.next()) {
                            sql = new StringBuilder("update T_BD_Person set FEFFDT = ?,FLastUpdateUserId = ?,FLastUpdateTime = ? where Fid = '").append(personId).append("'");
                            DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new Object[]{rs.getDate("FEFFDT"), rs.getString("FLastUpdateUserId"), rs.getDate("FLastUpdateTime")});
                        }
                    }
                    catch (SQLException e) {
                        e.printStackTrace();
                        throw new BOSException((Throwable)e);
                    }
                    if (poColl.size() > 0) {
                        SelectorItemCollection posics = new SelectorItemCollection();
                        PersonOtherInfoHISInfo poInfo = poColl.get(0);
                        poInfo.setEFFDT(newEFFDT);
                        posics.add("EFFDT");
                        PersonOtherInfoHISFactory.getLocalInstance(ctx).updatePartial(poInfo, posics);
                        StringBuilder othersql = new StringBuilder("select top 1 FEFFDT  from T_HR_PersonOtherInfoHIS where FpersonId='").append(personId).append("' order by FEFFDT DESC");
                        IRowSet otherrs = DbUtil.executeQuery((Context)ctx, (String)othersql.toString());
                        try {
                            if (otherrs.next()) {
                                sql = new StringBuilder("update T_HR_PersonOtherInfo set FEFFDT = ? where FpersonId = '").append(personId).append("'");
                                DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new Object[]{rs.getDate("FEFFDT")});
                            }
                        }
                        catch (SQLException e) {
                            e.printStackTrace();
                            throw new BOSException((Throwable)e);
                        }
                    }
                }
            }
        }
    }

    public static void checkPersonIsInHrOrgRange(Context ctx, String personId, String permItemId, String currentUserId) throws BOSException, EmployeeBizException {
        Set hrOrgSet = SHRUserOrgPermissionApi.getUserHROrgRangeIdSet((Context)ctx, (String)currentUserId, (String)permItemId);
        EmpHRORelationHisInfo empRelationInfo = SHREmpOptBizManageTool.getEmpHRORelationHisInfo(ctx, personId);
        if (empRelationInfo != null) {
            boolean buAndDu;
            boolean isUseDefault = empRelationInfo.isUseDefault();
            String hrOrgId = empRelationInfo.getHrOrgUnit().getId().toString();
            String hrOrgName = empRelationInfo.getHrOrgUnit().getName();
            String hrOrgNumber = empRelationInfo.getHrOrgUnit().getNumber();
            boolean ouAndBu = hrOrgSet.contains(hrOrgId);
            boolean bl = buAndDu = hrOrgSet.contains(hrOrgId) && !isUseDefault;
            if (!ouAndBu && !buAndDu) {
                throw new EmployeeBizException(EmployeeBizException.YOU_NO_CURRENT_EMP_HRO_PERM, new Object[]{hrOrgName, hrOrgNumber});
            }
        }
    }

    public static void checkPersonIsInAdminAndHrOrgRange(Context ctx, String personId, String permItemId, String currentUserId) throws BOSException, EASBizException {
        Set orgSet = SHRUserOrgPermissionApi.getUserAdminRangeIdSet((Context)ctx, (String)currentUserId, (String)permItemId);
        Set hrOrgSet = SHRUserOrgPermissionApi.getUserHROrgRangeIdSet((Context)ctx, (String)currentUserId, (String)permItemId);
        EmpHRORelationHisInfo empRelationInfo = SHREmpOptBizManageTool.getEmpHRORelationHisInfo(ctx, personId);
        if (empRelationInfo != null) {
            boolean buAndDu;
            boolean isUseDefault = empRelationInfo.isUseDefault();
            String hrOrgId = empRelationInfo.getHrOrgUnit().getId().toString();
            String hrOrgName = empRelationInfo.getHrOrgUnit().getName();
            String hrOrgNumber = empRelationInfo.getHrOrgUnit().getNumber();
            String adminOrgId = empRelationInfo.getEmpOrgRelation().getAdminOrg().getId().toString();
            String adminOrgName = empRelationInfo.getEmpOrgRelation().getAdminOrg().getName();
            String adminOrgNumber = empRelationInfo.getEmpOrgRelation().getAdminOrg().getNumber();
            boolean ouAndBu = hrOrgSet.contains(hrOrgId);
            boolean bl = buAndDu = hrOrgSet.contains(hrOrgId) && !isUseDefault;
            if (!ouAndBu && !buAndDu) {
                throw new EmployeeBizException(EmployeeBizException.YOU_NO_CURRENT_EMP_HRO_PERM, new Object[]{hrOrgName, hrOrgNumber});
            }
            boolean adminRange = orgSet.contains(adminOrgId);
            if (!adminRange && isUseDefault) {
                throw new EmployeeBizException(EmployeeBizException.YOU_NO_CURRENT_EMP_ADMIN_PERM, new Object[]{adminOrgName, adminOrgNumber});
            }
        } else {
            try {
                if (PersonOtherInfoFactory.getLocalInstance(ctx).exists("where person.id= '" + personId + "' and hasBURelation = 1")) {
                    throw new EmployeeBosBizException(EmployeeBosBizException.SYS_UPDATE_EMP);
                }
                throw new EmployeeBosBizException(EmployeeBosBizException.EMP_INIT_OPRTION);
            }
            catch (EASBizException e) {
                e.printStackTrace();
                throw e;
            }
        }
    }
}

