/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.emp.probation.service;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.HROrgUnitInfo;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.emp.PersonOtherInfoFactory;
import com.kingdee.eas.hr.emp.PersonOtherInfoInfo;
import com.kingdee.eas.hr.emp.probation.IPersonProbationTrainPlan;
import com.kingdee.eas.hr.emp.probation.PersonProbationTrainPlanCollection;
import com.kingdee.eas.hr.emp.probation.PersonProbationTrainPlanFactory;
import com.kingdee.eas.hr.emp.probation.PersonProbationTrainPlanInfo;
import com.kingdee.eas.hr.emp.probation.app.ProbationPermanIntentionEnum;
import com.kingdee.eas.hr.emp.probation.app.ProbationTrainStateEnum;
import com.kingdee.eas.hr.emp.probation.util.ProbationTrainPlanUtil;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.shr.ml.util.SHRServerResource;
import com.kingdee.shr.shareservice.strategy.impl.CommonBillActivitySolutionOperation;
import com.kingdee.shr.shareservice.util.JobUtils;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProbationTrainActivitySolutionOperationImpl
extends CommonBillActivitySolutionOperation {
    private static final String PROBATION_TRAIN_PLAN_BOSTYPE = "5FC68A86";
    private static Logger logger = LoggerFactory.getLogger(ProbationTrainActivitySolutionOperationImpl.class);

    public Map<String, Object> getOrgAndPerson(Context ctx, String billId, Map params) throws BOSException, EASBizException {
        logger.error("ProbationTrainActivitySolutionOperationImpl.getOrgAndPerson: " + billId);
        HashMap<String, Object> map = new HashMap<String, Object>();
        String billBosType = BOSUuid.read((String)billId).getType().toString();
        if (PROBATION_TRAIN_PLAN_BOSTYPE.equals(billBosType)) {
            PersonProbationTrainPlanInfo info = ProbationTrainPlanUtil.getPersonProbationTrainPlanInfoByBillId(ctx, billId);
            HROrgUnitInfo hrOrgUnit = info.getHrOrgUnit();
            AdminOrgUnitInfo adminOrgUnit = info.getAdminOrg();
            PersonInfo person = info.getPerson();
            if (person != null) {
                person = PersonFactory.getLocalInstance((Context)ctx).getPersonInfo((IObjectPK)new ObjectUuidPK(person.getId()));
            }
            map.put("hrOrgUnit", hrOrgUnit);
            map.put("adminOrgUnit", adminOrgUnit);
            map.put("personId", person.getId());
            map.put("personName", person.getName());
        }
        return map;
    }

    public Map<String, Object> getCommonParams(Context ctx, String billId, Map params) throws BOSException, EASBizException {
        HashMap<String, Object> createdMap = new HashMap<String, Object>();
        PersonProbationTrainPlanInfo billInfo = (PersonProbationTrainPlanInfo)params.get("model");
        if (null != billInfo) {
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("createTime"));
            sic.add(new SelectorItemInfo("creator.number"));
            sic.add(new SelectorItemInfo("person.name"));
            PersonProbationTrainPlanInfo billActure = PersonProbationTrainPlanFactory.getLocalInstance(ctx).getPersonProbationTrainPlanInfo((IObjectPK)new ObjectUuidPK(billInfo.getId()), sic);
            createdMap.put("creator.number", billActure.getCreator().getNumber());
            createdMap.put("personId.name", billActure.getPerson().getName());
            createdMap.put("MultiApprove.createTime", billActure.getCreateTime());
        }
        return createdMap;
    }

    public void afterPass(Context ctx, String solutionId, String billId, Map params) throws BOSException, EASBizException {
        String billBosType = BOSUuid.read((String)billId).getType().toString();
        logger.error("activity solution end." + billId);
        if (PROBATION_TRAIN_PLAN_BOSTYPE.equals(billBosType)) {
            PersonProbationTrainPlanInfo info = ProbationTrainPlanUtil.getPersonProbationTrainPlanInfoByBillId(ctx, billId);
            IPersonProbationTrainPlan trainPlanInstance = PersonProbationTrainPlanFactory.getLocalInstance(ctx);
            info.setPlanState(ProbationTrainStateEnum.PLANSTATE_END.getAlias());
            info.setLastUpdateTime(new Timestamp(System.currentTimeMillis()));
            info.setLastUpdateUser(ContextUtil.getCurrentUserInfo((Context)ctx));
            SelectorItemCollection sicoll = new SelectorItemCollection();
            sicoll.add(new SelectorItemInfo("planState"));
            sicoll.add(new SelectorItemInfo("lastUpdateTime"));
            sicoll.add(new SelectorItemInfo("lastUpdateUser"));
            trainPlanInstance.updatePartial(info, sicoll);
            this.dealPeronOtherTrainPlan(ctx, info);
        }
    }

    public void dealPeronOtherTrainPlan(Context ctx, PersonProbationTrainPlanInfo info) throws BOSException, EASBizException {
        String personId = info.getPerson().getId().toString();
        ProbationPermanIntentionEnum intenTion = info.getPermanIntention();
        logger.error("ProbationTrainActivitySolutionOperationImpl.intenTion: " + (Object)((Object)intenTion));
        if (ProbationPermanIntentionEnum.HIRE.equals((Object)intenTion) || ProbationPermanIntentionEnum.STOP.equals((Object)intenTion)) {
            boolean isAbortAll = info.isIsAbortAll();
            logger.error("ProbationTrainActivitySolutionOperationImpl.isAbortAll: " + isAbortAll);
            if (isAbortAll) {
                String oql = " select person.name, * where person = '" + personId + "' and planState <> '" + ProbationTrainStateEnum.PLANSTATE_END.getAlias() + "' and planState <> '" + ProbationTrainStateEnum.PLANSTATE_ABORT.getAlias() + "'";
                PersonProbationTrainPlanCollection coll = PersonProbationTrainPlanFactory.getLocalInstance(ctx).getPersonProbationTrainPlanCollection(oql);
                String abortReason = SHRServerResource.getString((String)"com.kingdee.eas.hr.emp.probation.ProbationEmpBizResource", (String)"HIRE_ABORT", (Context)ctx);
                if (ProbationPermanIntentionEnum.STOP.equals((Object)intenTion)) {
                    abortReason = SHRServerResource.getString((String)"com.kingdee.eas.hr.emp.probation.ProbationEmpBizResource", (String)"NORT_HIRE_ABORT", (Context)ctx);
                }
                for (int i = 0; i < coll.size(); ++i) {
                    PersonProbationTrainPlanInfo trainPlanInfo = coll.get(i);
                    ProbationTrainPlanUtil.abortPersonTrainPeriod(ctx, trainPlanInfo, abortReason, ProbationTrainStateEnum.PLANSTATE_ABORT.toString());
                    Set receiver = JobUtils.getExecutor((Context)ctx, (String)trainPlanInfo.getId().toString(), (int)3);
                    ProbationTrainPlanUtil.abortActivity(ctx, trainPlanInfo, abortReason);
                    ProbationTrainPlanUtil.sendActivityAbortNotice(ctx, trainPlanInfo, receiver, 1);
                }
            }
        }
        String otherSql = "where person = '" + personId + "'";
        PersonOtherInfoInfo otherInfo = PersonOtherInfoFactory.getLocalInstance(ctx).getPersonOtherInfoInfo(otherSql);
        otherInfo.setProbationIntention(intenTion);
        SelectorItemCollection sicoll = new SelectorItemCollection();
        sicoll.add(new SelectorItemInfo("probationIntention"));
        PersonOtherInfoFactory.getLocalInstance(ctx).updatePartial(otherInfo, sicoll);
    }
}

