/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.competmodel.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectListener;
import com.kingdee.bos.ctrl.swing.util.CtrlFormatUtilities;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.resource.BizEnumValueInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.hr.affair.ApproveStateEnum;
import com.kingdee.eas.hr.affair.HRAffairState;
import com.kingdee.eas.hr.competmodel.AbstractCapacityCompetInfo;
import com.kingdee.eas.hr.competmodel.CapacityCompetFactory;
import com.kingdee.eas.hr.competmodel.CapacityCompetInfo;
import com.kingdee.eas.hr.competmodel.ICapacityCompet;
import com.kingdee.eas.hr.competmodel.client.AbstractCapacityCompetListUI;
import com.kingdee.eas.hr.competmodel.client.CapacityCompetEditUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.KDTableUtil;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import org.apache.log4j.Logger;

public class CapacityCompetListUI
extends AbstractCapacityCompetListUI {
    private static final Logger logger = CoreUIObject.getLogger(CapacityCompetListUI.class);
    private final String Audit_Complete = "com.kingdee.eas.hr.competmodel.CapComGenyResource.Audit_Complete";
    private final String PLEASE_SELECT_ROW = "com.kingdee.eas.hr.competmodel.CapComGenyResource.PLEASE_SELECT_ROW";
    private final String Can_Not_Delete = "com.kingdee.eas.hr.competmodel.CapComGenyResource.Can_Not_Delete";
    private final String Have_Error = "com.kingdee.eas.hr.competmodel.CapComGenyResource.Have_Error";

    protected ICoreBase getBizInterface() throws Exception {
        return CapacityCompetFactory.getRemoteInstance();
    }

    protected String getEditUIName() {
        return CapacityCompetEditUI.class.getName();
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.getEnum((String)"HRO");
    }

    private void initButton() {
        this.btnLocate.setVisible(false);
        this.btnQuery.setVisible(false);
        this.btnPrint.setVisible(false);
        this.btnPrintPreview.setVisible(false);
        this.btnUnAudit.setVisible(false);
        this.btnTraceUp.setVisible(false);
        this.btnTraceDown.setVisible(false);
        this.btnWorkFlowList.setVisible(false);
        this.btnCreateTo.setVisible(false);
        this.btnAuditResult.setVisible(false);
        this.btnAttachment.setVisible(false);
        this.btnWorkFlowG.setVisible(false);
        this.btnAudit.setEnabled(false);
        this.btnCopyTo.setVisible(false);
        this.menuItemTraceUp.setVisible(false);
        this.menuItemTraceDown.setVisible(false);
    }

    public void onLoad() throws Exception {
        super.onLoad();
        UserInfo info = this.getUserInfo();
        if (info.getPerson() == null) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.hr.base.BASEAutoGenerateResource", (String)"141_USER_NO_MATCH_PERSON"));
            SysUtil.abort();
        }
        this.tblMain.getSelectManager().setSelectMode(2);
        this.btnAudit.setText(EASResource.getString((String)"com.kingdee.eas.hr.org.ORGAutoGenerateResource", (String)"5_CapacityCompetListUI"));
        this.initButton();
        this.tblMain.addKDTSelectListener(new KDTSelectListener(){

            public void tableSelectChanged(KDTSelectEvent e) {
                CapacityCompetListUI.this.setButtonStatus(e);
            }
        });
        this.setButtonStatus(null);
        this.menuWorkFlow.setVisible(false);
        String dtFormat = CtrlFormatUtilities.getDateFormatString();
        this.tblMain.getColumn("bizDate").getStyleAttributes().setNumberFormat(dtFormat);
    }

    private void setButtonStatus(KDTSelectEvent e) {
        IRow row = null;
        int[] rows = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
        for (int j = rows.length - 1; j >= 0; --j) {
            row = this.tblMain.getRow(rows[j]);
            if (row == null || row.getCell("auditState") == null || row.getCell("auditState").getValue() == null) continue;
            int auditState = ((BizEnumValueInfo)row.getCell("auditState").getValue()).getInt();
            if (auditState == HRAffairState.APPROVE.getValue() || auditState == HRAffairState.COMPLETE.getValue()) {
                this.MenuItemAudit.setEnabled(false);
            } else {
                this.MenuItemAudit.setEnabled(true);
            }
            if (auditState == HRAffairState.APPROVE.getValue() || auditState == HRAffairState.COMPLETE.getValue() || auditState == HRAffairState.EDIT.getValue()) {
                this.btnEdit.setEnabled(false);
                this.btnRemove.setEnabled(false);
                this.menuItemEdit.setEnabled(false);
                this.menuItemRemove.setEnabled(false);
            } else {
                this.btnEdit.setEnabled(true);
                this.btnRemove.setEnabled(true);
                this.menuItemEdit.setEnabled(true);
                this.menuItemRemove.setEnabled(true);
            }
            if (auditState != HRAffairState.TEMP.getValue()) continue;
            this.MenuItemAudit.setEnabled(false);
        }
    }

    @Override
    public void actionAudit_actionPerformed(ActionEvent e) throws Exception {
        super.actionAudit_actionPerformed(e);
        if (this.tblMain.getSelectManager().get() == null) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.hr.competmodel.CapComGenyResource.PLEASE_SELECT_ROW"));
        } else {
            int size = this.tblMain.getSelectManager().size();
            ICapacityCompet capacityCompet = CapacityCompetFactory.getRemoteInstance();
            boolean haveError = false;
            for (int i = 0; i < size; ++i) {
                KDTSelectBlock block = this.tblMain.getSelectManager().get(i);
                for (int j = block.getTop(); j <= block.getBottom(); ++j) {
                    IRow row = this.tblMain.getRow(j);
                    if (row.getCell("id") == null || row.getCell("id").getValue() == null) continue;
                    String id = row.getCell("id").getValue().toString();
                    CapacityCompetInfo info = capacityCompet.getCapacityCompetInfo((IObjectPK)new ObjectUuidPK(id));
                    if (info.getApproveState().equals((Object)ApproveStateEnum.DIRECT) && info.getAuditState().equals((Object)HRAffairState.EDIT)) {
                        capacityCompet.setAuditPass(BOSUuid.read((String)id));
                        continue;
                    }
                    haveError = true;
                }
            }
            this.refreshList();
            if (haveError) {
                MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.hr.competmodel.CapComGenyResource.Have_Error"));
            } else {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.hr.competmodel.CapComGenyResource.Audit_Complete"));
            }
        }
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        if (this.tblMain.getSelectManager().get() == null) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.hr.competmodel.CapComGenyResource.PLEASE_SELECT_ROW"));
        } else {
            int size = this.tblMain.getSelectManager().size();
            ICapacityCompet capacityCompet = CapacityCompetFactory.getRemoteInstance();
            for (int i = 0; i < size; ++i) {
                KDTSelectBlock block = this.tblMain.getSelectManager().get(i);
                for (int j = block.getTop(); j <= block.getBottom(); ++j) {
                    IRow row = this.tblMain.getRow(j);
                    if (row.getCell("id") == null || row.getCell("id").getValue() == null) continue;
                    String id = row.getCell("id").getValue().toString();
                    CapacityCompetInfo info = capacityCompet.getCapacityCompetInfo((IObjectPK)new ObjectUuidPK(id));
                    if (info.getAuditState().equals((Object)HRAffairState.TEMP) || info.getAuditState().equals((Object)HRAffairState.STOP) || info.getAuditState().equals((Object)HRAffairState.EDIT)) {
                        super.actionRemove_actionPerformed(e);
                        continue;
                    }
                    MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.hr.competmodel.CapComGenyResource.Can_Not_Delete"));
                }
            }
        }
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        super.tblMain_tableClicked(e);
        if (e.getRowIndex() != -1) {
            IRow row = this.tblMain.getRow(e.getRowIndex());
            String id = "";
            if (row != null && row.getCell("id").getValue() != null) {
                id = row.getCell("id").getValue().toString();
            }
            ICapacityCompet capacityCompet = CapacityCompetFactory.getRemoteInstance();
            AbstractCapacityCompetInfo info = null;
            if (id != null && !"".equals(id)) {
                info = capacityCompet.getCapacityCompetInfo((IObjectPK)new ObjectUuidPK(id));
            }
            if (info != null) {
                if (info.getAuditState().equals((Object)HRAffairState.APPROVE) || info.getAuditState().equals((Object)HRAffairState.COMPLETE) || info.getAuditState().equals((Object)HRAffairState.EDIT)) {
                    this.btnEdit.setEnabled(false);
                    this.btnRemove.setEnabled(false);
                    this.menuItemEdit.setEnabled(false);
                    this.menuItemRemove.setEnabled(false);
                } else {
                    this.btnEdit.setEnabled(true);
                    this.btnRemove.setEnabled(true);
                    this.menuItemEdit.setEnabled(true);
                    this.menuItemRemove.setEnabled(true);
                }
                if (info.getApproveState().equals((Object)ApproveStateEnum.WORKFLOW) || info.getAuditState().equals((Object)HRAffairState.COMPLETE) || info.getAuditState().equals((Object)HRAffairState.TEMP)) {
                    this.btnAudit.setEnabled(false);
                } else {
                    this.btnAudit.setEnabled(true);
                }
            }
        }
    }
}

