/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.competmodel.client;

import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.geom.Ellipse2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;

public class CompetMatchPanel
extends JComponent {
    private String resClass = "com.kingdee.eas.hr.competmodel.client.CompetModelResource.";
    private int maxLevel = 0;
    private HashMap competNames = null;
    private List posiList = null;
    private List perList = null;
    private List competList = null;
    private HashMap perCompetLevel = null;
    private HashMap posiCompetLevel = null;

    public CompetMatchPanel(String positionId, String personId) throws Exception {
        this.createDateModel(positionId, personId);
    }

    public void updateModel(String positionId, String personId) throws Exception {
        this.createDateModel(positionId, personId);
        super.repaint();
    }

    private void createDateModel(String positionId, String personId) throws Exception {
        MetaDataPK queryPK = new MetaDataPK("com.kingdee.eas.hr.competmodel.app.PositionCompetQuery");
        IQueryExecutor queryExcu = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)queryPK);
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("id", (Object)positionId));
        viewInfo.setFilter(fi);
        queryExcu.setObjectView(viewInfo);
        IRowSet rows1 = queryExcu.executeQuery();
        queryPK = new MetaDataPK("com.kingdee.eas.hr.competmodel.app.PersonCompetQuery");
        queryExcu = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)queryPK);
        viewInfo = new EntityViewInfo();
        fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("id", (Object)personId));
        viewInfo.setFilter(fi);
        queryExcu.setObjectView(viewInfo);
        IRowSet rows2 = queryExcu.executeQuery();
        this.setMaxLevel(rows1, rows2);
        this.setCompetNames(rows1, rows2);
        this.sortCompet(rows1, rows2);
    }

    private void sortCompet(IRowSet rows1, IRowSet rows2) throws Exception {
        this.posiList = new ArrayList();
        this.perList = new ArrayList();
        this.competList = new ArrayList();
        this.perCompetLevel = new HashMap();
        this.posiCompetLevel = new HashMap();
        Set keys = this.competNames.keySet();
        Iterator iter = keys.iterator();
        Object key = null;
        while (iter.hasNext()) {
            key = iter.next();
            this.competList.add(key);
            if (rows1 != null) {
                rows1.beforeFirst();
                while (rows1.next()) {
                    if (!key.toString().equals(rows1.getString("Compet.id"))) continue;
                    this.posiList.add(rows1.getString("Compet.id") + rows1.getString("IndexGrade.index"));
                    this.posiCompetLevel.put(rows1.getString("Compet.id"), rows1.getString("IndexGrade.index"));
                }
            }
            if (rows2 == null) continue;
            rows2.beforeFirst();
            while (rows2.next()) {
                if (!key.toString().equals(rows2.getString("Compet.id"))) continue;
                this.perList.add(rows2.getString("Compet.id") + rows2.getString("IndexGrade.index"));
                this.perCompetLevel.put(rows2.getString("Compet.id"), rows2.getString("IndexGrade.index"));
            }
            if (this.perCompetLevel.get(key) != null) continue;
            this.perList.add(key + "0");
            this.perCompetLevel.put(key, "0");
        }
    }

    private void setCompetNames(IRowSet rows1, IRowSet rows2) throws Exception {
        this.competNames = new HashMap();
        if (rows1 != null) {
            rows1.beforeFirst();
            while (rows1.next()) {
                this.competNames.put(rows1.getString("Compet.id"), rows1.getString("Compet.name"));
            }
        }
    }

    private void setMaxLevel(IRowSet rows1, IRowSet rows2) throws Exception {
        int level1 = 0;
        int level2 = 0;
        if (rows1 != null && rows1.next()) {
            level1 = rows1.getInt("IndexGrade.index");
        }
        if (rows2 != null && rows2.next()) {
            level2 = rows2.getInt("IndexGrade.index");
        }
        this.maxLevel = StrictMath.max(level1, level2);
    }

    private boolean isWarnning(String key) {
        int level1 = 0;
        int level2 = 0;
        if (this.perCompetLevel.get(key) != null) {
            level1 = Integer.parseInt((String)this.perCompetLevel.get(key));
        }
        if (this.posiCompetLevel.get(key) != null) {
            level2 = Integer.parseInt((String)this.posiCompetLevel.get(key));
        }
        return level1 < level2;
    }

    private void drawPolygon(Graphics2D g2D, HashMap nodeMap, List map) {
        Point p = null;
        Point lastP = null;
        Point firstP = null;
        g2D.setStroke(new BasicStroke(2.0f));
        int length = map.size();
        for (int index = 0; index < length; ++index) {
            p = (Point)nodeMap.get(map.get(index));
            g2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            if (index == 0) {
                firstP = p;
            } else if (index == length - 1) {
                g2D.drawLine(lastP.x, lastP.y, p.x, p.y);
                g2D.drawLine(p.x, p.y, firstP.x, firstP.y);
            } else {
                g2D.drawLine(lastP.x, lastP.y, p.x, p.y);
            }
            g2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            lastP = p;
        }
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        HashMap<String, Point> nodeMap = new HashMap<String, Point>();
        HashMap<Integer, Integer> readiusMap = new HashMap<Integer, Integer>();
        Graphics2D g2D = (Graphics2D)g;
        g2D.setStroke(new BasicStroke(0.5f));
        g2D.setColor(Color.GRAY);
        int centerX = this.getWidth() / 2;
        int centerY = this.getHeight() / 2 - 30;
        int readius = centerY - 25;
        int interval = 0;
        if (this.competNames.size() == 0) {
            g2D.setColor(Color.RED);
            g2D.drawString(EASResource.getString((String)(this.resClass + "COMPETCHART_NOT_SET_COMPET")), 100, 100);
            return;
        }
        g2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        for (int i = 0; i < this.maxLevel; ++i) {
            interval = readius / this.maxLevel * i;
            g2D.draw(new Ellipse2D.Double(centerX - readius + interval, centerY - readius + interval, readius * 2 - interval * 2, readius * 2 - interval * 2));
            readiusMap.put(this.maxLevel - i, readius - interval);
        }
        int angle = 360 / this.competNames.size();
        int dx = 0;
        int dy = 0;
        int angle2 = 0;
        FontMetrics fm = g2D.getFontMetrics();
        int strWidth = 0;
        String competName = null;
        int size = this.competList.size();
        for (int i = 0; i < size; ++i) {
            angle2 = angle * (i + 1);
            nodeMap.put(this.competList.get(i).toString() + "0", new Point(centerX, centerY));
            for (int t = 1; t <= this.maxLevel; ++t) {
                dx = (int)(Math.cos((double)angle2 * Math.PI / 180.0) * (double)Integer.parseInt(readiusMap.get(t).toString()));
                dy = (int)(Math.sin((double)angle2 * Math.PI / 180.0) * (double)Integer.parseInt(readiusMap.get(t).toString()));
                nodeMap.put(this.competList.get(i).toString() + t, new Point(centerX + dx, centerY - dy));
            }
            g2D.setColor(Color.GRAY);
            g2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2D.drawLine(centerX, centerY, centerX + dx, centerY - dy);
            g2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            competName = this.competNames.get(this.competList.get(i)).toString();
            if (this.isWarnning(this.competList.get(i).toString())) {
                g2D.setColor(new Color(15146240));
            } else {
                g2D.setColor(Color.BLACK);
            }
            if (angle2 <= 90) {
                g2D.drawString(competName, centerX + dx, centerY - dy - 5);
                continue;
            }
            if (angle2 >= 270) {
                g2D.drawString(competName, centerX + dx, centerY - dy + 12);
                continue;
            }
            if (angle2 <= 180) {
                strWidth = fm.stringWidth(competName);
                g2D.drawString(competName, centerX + dx - strWidth - 5, centerY - dy - 3);
                continue;
            }
            if (angle2 <= 180) continue;
            strWidth = fm.stringWidth(competName);
            g2D.drawString(competName, centerX + dx - strWidth - 5, centerY - dy + 10);
        }
        g2D.setColor(new Color(3642457));
        g2D.drawLine(this.getWidth() - 120, this.getHeight() - 65, this.getWidth() - 90, this.getHeight() - 65);
        g2D.setColor(Color.BLACK);
        g2D.drawString(EASResource.getString((String)(this.resClass + "COMPETMATCH_POSITION_LABEL")), this.getWidth() - 85, this.getHeight() - 60);
        g2D.setColor(new Color(3642457));
        this.drawPolygon(g2D, nodeMap, this.posiList);
        g2D.setColor(new Color(20899));
        g2D.drawLine(this.getWidth() - 120, this.getHeight() - 45, this.getWidth() - 90, this.getHeight() - 45);
        g2D.setColor(Color.BLACK);
        g2D.drawString(EASResource.getString((String)(this.resClass + "COMPETMATCH_PERSON_LABEL")), this.getWidth() - 85, this.getHeight() - 40);
        g2D.setColor(new Color(20899));
        this.drawPolygon(g2D, nodeMap, this.perList);
    }
}

