/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.org.client;

import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditAdapter;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.PreChangeEvent;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.ctrl.swing.util.CtrlFormatUtilities;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.ISQLExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.dao.query.SQLExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.IUIFactory;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.JobInfo;
import com.kingdee.eas.basedata.org.OrgF7InnerUtils;
import com.kingdee.eas.basedata.org.PositionInfo;
import com.kingdee.eas.basedata.org.client.tree.NewOrgTreeHelper;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.hr.compensation.util.HRSchemeUtils;
import com.kingdee.eas.hr.org.IPersonPlan;
import com.kingdee.eas.hr.org.IPersonPlanScheme;
import com.kingdee.eas.hr.org.Period;
import com.kingdee.eas.hr.org.PersonPlanException;
import com.kingdee.eas.hr.org.PersonPlanFactory;
import com.kingdee.eas.hr.org.PersonPlanInfo;
import com.kingdee.eas.hr.org.PersonPlanSchemeFactory;
import com.kingdee.eas.hr.org.PersonPlanSchemeInfo;
import com.kingdee.eas.hr.org.PersonPlanType;
import com.kingdee.eas.hr.org.client.AbstractPersonPlanMainListUI;
import com.kingdee.eas.hr.org.client.ImportDataPersonPlanUI;
import com.kingdee.eas.hr.org.client.PersonPlanMainEditUI;
import com.kingdee.eas.hr.org.client.PersonPlanSchemePromptBox;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Color;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JTextField;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class PersonPlanMainListUI
extends AbstractPersonPlanMainListUI {
    private static final String RES = "com.kingdee.eas.hr.org.ImportDataPersonPlanResource";
    private String resClass = "com.kingdee.eas.hr.org.client.PersonPlanResource.";
    private AdminOrgUnitInfo adminInfo = null;
    private int startYear = 0;
    private int endYear = 0;
    private int startMonth = 0;
    private int endMonth = 0;
    private int colmnLength = 0;
    private IColumn col = null;
    private IRow row = null;
    private Period period = null;
    private PersonPlanType ppType = null;
    private IRowSet rows = null;
    private PersonPlanSchemeInfo schemeInfo = null;
    private int nextYearPoint = 0;
    private final String positionStr = EASResource.getString((String)(this.resClass + "POSITION_NAME"));
    private final String jobStr = EASResource.getString((String)(this.resClass + "JOB_NAME"));
    private final String adminStr = EASResource.getString((String)(this.resClass + "ADMIN_ORG"));
    private final String firstHalfYearStr = EASResource.getString((String)(this.resClass + "FIRST_HALFYEAR"));
    private final String secondHalfYearStr = EASResource.getString((String)(this.resClass + "SECOND_HALF_YEAR"));
    private final String yearStr = EASResource.getString((String)(this.resClass + "YEAR"));
    private final String monthStr = EASResource.getString((String)(this.resClass + "MONTH"));
    private final String quarterStr = EASResource.getString((String)(this.resClass + "QUARTER"));
    private final String sumStr = EASResource.getString((String)(this.resClass + "SUM"));
    private final String allowOverStr = EASResource.getString((String)(this.resClass + "ALLOW_OVER"));
    private DefaultKingdeeTreeNode selectNode = null;
    private HashMap dataMap = null;
    private boolean isModify = false;
    private String systemParam = null;

    @Override
    public void initUIContentLayout() {
        super.initUIContentLayout();
        this.planContainer.getContentPane().putClientProperty("OriginalBounds", new Rectangle(0, 0, 748, 565));
    }

    protected SystemEnum getSystemEnumForOA() {
        return SystemEnum.PEOPLE_ORGANIZATION;
    }

    public void onLoad() throws Exception {
        super.onLoad();
        HRSchemeUtils.checkInit();
        this.btnSubmit.setIcon(EASResource.getIcon((String)"imgTbtn_save"));
        this.menuItemSubmit.setIcon(EASResource.getIcon((String)"imgTbtn_save"));
        this.btnView.setIcon(EASResource.getIcon((String)"imgTbtn_view"));
        this.tblMain.checkParsed();
        this.btnView.setEnabled(true);
        this.setButtonDefaultStyl(this.btnSubmit);
        this.tblMain.getSelectManager().setSelectPaintMode(1);
        this.treeMain.setShowsRootHandles(true);
        this.tblMain.getViewManager().freeze(this.tblMain.getRowCount(), 1);
        this.initSchemeF7();
        DefaultKingdeeTreeNode rootNode = NewOrgTreeHelper.createAdminTreeNodeByHRO(null, (boolean)true, (boolean)false, (boolean)false, (boolean)this.chkShowVirtualOrg.isSelected());
        if (rootNode != null) {
            DefaultTreeModel treeModel = new DefaultTreeModel((TreeNode)rootNode);
            this.treeMain.setModel((TreeModel)treeModel);
            if (!OrgF7InnerUtils.isTreeNodeDisable((DefaultKingdeeTreeNode)rootNode) || rootNode.getChildCount() == 0) {
                TreePath path = new TreePath(rootNode);
                this.treeMain.expandPath(path);
                this.treeMain.setSelectionPath(path);
            } else {
                DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)rootNode.getChildAt(0);
                TreePath path = new TreePath(node.getPath());
                this.treeMain.expandPath(path);
                this.treeMain.setSelectionPath(path);
            }
        } else {
            this.treeMain.setModel(null);
        }
        if (this.adminInfo != null) {
            this.txtAdminOrgName.setText(this.adminInfo.getName());
        }
        this.setCanCopyPaste(false);
        this.checkTableCommonMenu(this.tblMain);
        this.tHelper.getDisabledTables().add(this.tblMain);
        try {
            IPermission permission = PermissionFactory.getRemoteInstance();
            ObjectUuidPK userPk = new ObjectUuidPK(SysContext.getSysContext().getCurrentUserInfo().getId());
            ObjectUuidPK orgPk = new ObjectUuidPK(SysContext.getSysContext().getCurrentOrgUnit().getId());
            permission.checkFunctionPermission((IObjectPK)userPk, (IObjectPK)orgPk, "PersonPlan_Submit");
        }
        catch (Exception ex) {
            this.tblMain.getStyleAttributes().setLocked(true);
        }
    }

    protected KDTable getTableForCommon() {
        return this.tblMain;
    }

    private void initSchemeF7() throws Exception {
        this.bizPPScheme.setDisplayFormat("$name$");
        this.bizPPScheme.setEditFormat("$number$");
        this.bizPPScheme.setCommitFormat("$number$");
        this.bizPPScheme.setQueryInfo("com.kingdee.eas.hr.org.app.PersonPlanSchemaQuery");
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        if (SysContext.getSysContext().getCurrentHRUnit() == null) {
            return;
        }
        filter.getFilterItems().add(new FilterItemInfo("hrOrgUnit.id", (Object)SysContext.getSysContext().getCurrentHRUnit().getId().toString(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("schemeType", (Object)1));
        filter.getFilterItems().add(new FilterItemInfo("status", (Object)1));
        filter.getFilterItems().add(new FilterItemInfo("status", (Object)2));
        if (this.getUIContext().get("INCLUDE_INVALID") != null) {
            filter.getFilterItems().add(new FilterItemInfo("status", (Object)3));
            filter.setMaskString("(#0 or #1) and (#2 or #3 or #4)");
        } else {
            filter.setMaskString("(#0 or #1) and (#2 or #3)");
        }
        viewInfo.setFilter(filter);
        this.bizPPScheme.setEntityViewInfo(viewInfo);
        this.bizPPScheme.setEditable(true);
        this.bizPPScheme.setSelector((KDPromptSelector)new PersonPlanSchemePromptBox((IUIObject)this));
        IPersonPlanScheme iPPScheme = PersonPlanSchemeFactory.getRemoteInstance();
        PersonPlanSchemeInfo ppsInfo = iPPScheme.getDefaultScheme();
        this.bizPPScheme.setData((Object)ppsInfo);
        if (ppsInfo != null) {
            this.startYear = ppsInfo.getStartYear();
            this.startMonth = ppsInfo.getStartMonth();
            this.endYear = ppsInfo.getEndYear();
            this.endMonth = ppsInfo.getEndMonth();
            this.period = ppsInfo.getPeriod();
            this.ppType = ppsInfo.getPlanType();
            this.schemeInfo = ppsInfo;
        }
        this.initIsShowDisableJob();
    }

    private AdminOrgUnitInfo getSelectAdminOrg() throws Exception {
        TreePath path = this.treeMain.getSelectionPath();
        this.selectNode = null;
        if (path != null) {
            Object obj = path.getLastPathComponent();
            if (obj instanceof DefaultKingdeeTreeNode) {
                DefaultKingdeeTreeNode treenode = (DefaultKingdeeTreeNode)obj;
                if (OrgF7InnerUtils.isTreeNodeDisable((DefaultKingdeeTreeNode)treenode)) {
                    return null;
                }
                if (treenode.getUserObject() instanceof AdminOrgUnitInfo) {
                    this.selectNode = treenode;
                    return (AdminOrgUnitInfo)treenode.getUserObject();
                }
                return null;
            }
            return null;
        }
        return null;
    }

    @Override
    public void treeMain_valueChanged(TreeSelectionEvent e) throws Exception {
        this.adminInfo = this.getSelectAdminOrg();
        if (this.adminInfo == null || this.bizPPScheme.getData() == null) {
            this.tblMain.removeRows();
            return;
        }
        IQueryExecutor queryExcu = null;
        MetaDataPK queryPK = null;
        queryPK = this.ppType == PersonPlanType.POSITION ? new MetaDataPK("com.kingdee.eas.basedata.org.app.PositionsByAdminOrg") : new MetaDataPK("com.kingdee.eas.hr.org.app.PositionJobList");
        if (queryPK != null) {
            queryExcu = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)queryPK);
            EntityViewInfo viewInfo = new EntityViewInfo();
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("AdminUnit.id", (Object)this.adminInfo.getId(), CompareType.EQUALS));
            if (this.ppType == PersonPlanType.POSITION) {
                filterInfo.getFilterItems().add(new FilterItemInfo("deletedStatus", (Object)2, CompareType.NOTEQUALS));
                filterInfo.setMaskString("#0 and #1");
            }
            if (this.ppType == PersonPlanType.JOB && !this.isShowDisableJob.isSelected()) {
                filterInfo.getFilterItems().add(new FilterItemInfo("state", (Object)2, CompareType.NOTEQUALS));
                filterInfo.setMaskString("#0 and #1");
            }
            viewInfo.setFilter(filterInfo);
            queryExcu.setObjectView(viewInfo);
            this.rows = queryExcu.executeQuery();
        }
        this.txtAdminOrgName.setText(this.adminInfo.getName());
        this.createTable();
    }

    @Override
    protected void bizPPScheme_preChange(PreChangeEvent e) throws Exception {
        super.bizPPScheme_preChange(e);
        PersonPlanSchemeInfo newInfo = null;
        if (e.getData() != null && e.getData() instanceof PersonPlanSchemeInfo) {
            newInfo = (PersonPlanSchemeInfo)e.getData();
        }
        PersonPlanSchemeInfo oldInfo = null;
        if (e.getOldData() instanceof PersonPlanSchemeInfo) {
            oldInfo = (PersonPlanSchemeInfo)e.getOldData();
        } else if (e.getOldData() != null) {
            oldInfo = (PersonPlanSchemeInfo)((Object[])e.getOldData())[0];
        }
        if (newInfo != null && oldInfo != null && newInfo.getId().toString().equals(oldInfo.getId().toString())) {
            return;
        }
        if (newInfo != null) {
            this.startYear = newInfo.getStartYear();
            this.startMonth = newInfo.getStartMonth();
            this.endYear = newInfo.getEndYear();
            this.endMonth = newInfo.getEndMonth();
            this.period = newInfo.getPeriod();
            this.ppType = newInfo.getPlanType();
            this.schemeInfo = newInfo;
        }
        this.initIsShowDisableJob();
        this.treeMain_valueChanged(null);
    }

    private void createTable() throws Exception {
        this.tblMain.removeRows();
        this.tblMain.removeHeadRows();
        this.tblMain.removeColumns();
        this.enableExportExcel(this.tblMain);
        this.col = this.tblMain.addColumn();
        this.col.setWidth(150);
        this.col.getStyleAttributes().setBackground(new Color(217, 217, 210));
        this.col.getStyleAttributes().setLocked(true);
        this.col = this.tblMain.addColumn();
        this.col.setWidth(100);
        this.getDataMap();
        if (this.period == Period.MONTH) {
            this.createHeadByMonth();
            this.loadTableDataByMonth();
            this.nextYearPoint = 11;
        } else if (this.period == Period.QUARTER) {
            this.createHeadByQuarter();
            this.loadTableDataByQuarter();
            this.nextYearPoint = 3;
        } else if (this.period == Period.HALF_YEAR) {
            this.createHeadByHalfYear();
            this.loadTableDataByHalfYear();
            this.nextYearPoint = 1;
        } else if (this.period == Period.YEAR) {
            this.createHeadByYear();
            this.loadTableDataByYear();
            this.nextYearPoint = 0;
        }
        this.tblMain.getViewManager().freeze(this.tblMain.getRowCount(), 1);
        this.tblMain.addKDTEditListener((KDTEditListener)new KDTEditAdapter(){

            public void editStopped(KDTEditEvent e) {
                if (e.getValue() != null && !e.getValue().equals(e.getOldValue())) {
                    PersonPlanMainListUI.this.isModify = true;
                }
                int col = e.getColIndex();
                int row = e.getRowIndex();
                if (col == 1) {
                    return;
                }
                int rowCount = PersonPlanMainListUI.this.tblMain.getRowCount() - 1;
                int sum = 0;
                for (int j = 0; j < rowCount; ++j) {
                    if (!(PersonPlanMainListUI.this.tblMain.getRow(j).getCell(col).getValue() instanceof Integer)) continue;
                    sum += Integer.parseInt(PersonPlanMainListUI.this.tblMain.getRow(j).getCell(col).getValue().toString());
                }
                if (sum < 0) {
                    MsgBox.showError((Component)((Object)PersonPlanMainListUI.this), (String)EASResource.getString((String)"com.kingdee.eas.hr.org.ORGAutoGenerateResource", (String)"43_PersonPlanMainListUI"));
                    PersonPlanMainListUI.this.tblMain.getRow(row).getCell(col).setValue(e.getOldValue());
                } else {
                    PersonPlanMainListUI.this.tblMain.getRow(rowCount).getCell(col).setValue((Object)Integer.toString(sum));
                }
            }
        });
    }

    private void getDataMap() {
        if (this.schemeInfo.getId() != null && this.adminInfo.getId() != null) {
            StringBuffer sql = new StringBuffer("");
            sql.append("SELECT FAdminOrgID,FPositionID,FJobID,fyear,FPlan1,FPlan2,FPlan3,FPlan4,FPlan5,FPlan6,FPlan7,FPlan8,FPlan9,FPlan10,FPlan11,FPlan12,fisallowover ");
            sql.append(" FROM T_HR_PersonPlan WHERE FSchemeID='");
            sql.append(this.schemeInfo.getId());
            if (this.ppType != PersonPlanType.PERSON) {
                sql.append("' AND FAdminOrgID='");
                sql.append(this.adminInfo.getId());
                sql.append("'");
            } else if (this.selectNode != null) {
                sql.append("' AND FAdminOrgID in ('");
                sql.append(this.adminInfo.getId()).append("'");
                DefaultKingdeeTreeNode childNode = null;
                AdminOrgUnitInfo childAdminInfo = null;
                int size = this.selectNode.getChildCount();
                for (int i = 0; i < size; ++i) {
                    childNode = (DefaultKingdeeTreeNode)this.selectNode.getChildAt(i);
                    childAdminInfo = (AdminOrgUnitInfo)childNode.getUserObject();
                    sql.append(", '").append(childAdminInfo.getId().toString()).append("'");
                }
                sql.append(")");
            }
            ISQLExecutor isql = SQLExecutorFactory.getRemoteInstance((String)sql.toString());
            IRowSet rs = null;
            try {
                rs = isql.executeSQL();
                this.dataMap = new HashMap();
                ArrayList<Object> listData = null;
                String fplan = "FPlan";
                while (rs.next()) {
                    listData = new ArrayList<Object>();
                    if (this.ppType == PersonPlanType.POSITION) {
                        this.dataMap.put(rs.getString("FPositionID") + "-@@-" + rs.getInt("fyear"), listData);
                    } else if (this.ppType == PersonPlanType.JOB) {
                        this.dataMap.put(rs.getString("FJobID") + "-@@-" + rs.getInt("fyear"), listData);
                    } else {
                        this.dataMap.put(rs.getString("FAdminOrgID") + "-@@-" + rs.getInt("fyear"), listData);
                    }
                    listData.add(rs.getObject("fisallowover"));
                    int j = 12;
                    for (int i = 1; i <= j; ++i) {
                        if (rs.getString(fplan + i) != null) {
                            listData.add(new Integer(rs.getInt(fplan + i)));
                            continue;
                        }
                        listData.add(null);
                    }
                }
            }
            catch (Exception e) {
                ExceptionHandler.handle((Throwable)e);
            }
        }
    }

    @Override
    public void actionInputData_actionPerformed(ActionEvent e) throws Exception {
        if (this.schemeInfo == null) {
            MsgBox.showWarning((String)EASResource.getString((String)RES, (String)"please_select_scheme"));
            return;
        }
        UIContext context = new UIContext((Object)this);
        ArrayList<Object> lstPersonPlanItem = new ArrayList<Object>();
        for (int i = 0; i < this.tblMain.getColumnCount(); ++i) {
            if (this.ppType == PersonPlanType.PERSON && i == 0) {
                lstPersonPlanItem.add(EASResource.getString((String)"com.kingdee.eas.hr.org.ORGAutoGenerateResource", (String)"9_PersonPlanControllerBean"));
                continue;
            }
            Object colName = this.tblMain.getHeadRow(0).getCell(i).getValue();
            if (this.allowOverStr.equals(colName)) continue;
            lstPersonPlanItem.add(colName);
        }
        context.put((Object)"lstPersonPlanItem", lstPersonPlanItem);
        context.put((Object)"schemeInfo", (Object)this.schemeInfo);
        context.put((Object)"isShowVirtualOrg", (Object)this.chkShowVirtualOrg.isSelected());
        context.put((Object)"mode", (Object)0);
        context.put((Object)"Owner", (Object)this);
        IUIFactory uiFactory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory");
        IUIWindow curDialog = uiFactory.create(ImportDataPersonPlanUI.class.getName(), (Map)context, null, OprtState.ADDNEW);
        curDialog.show();
        curDialog.close();
        this.treeMain_valueChanged(null);
        this.tblMain.setRefresh(true);
        this.tblMain.repaint();
    }

    private void createHeadByMonth() throws Exception {
        int startMonthCount = this.startYear * 12 + this.startMonth + 1;
        int endMonthCount = this.endYear * 12 + this.endMonth + 1;
        this.colmnLength = endMonthCount - startMonthCount + 3;
        KDFormattedTextField integerField = new KDFormattedTextField(0);
        integerField.setHorizontalAlignment(4);
        integerField.putClientProperty((Object)"OriginValue", (Object)Boolean.TRUE);
        integerField.setMinimumValue((Comparable)Integer.valueOf(0));
        integerField.setDataVerifierType(12);
        integerField.setSupportedEmpty(true);
        KDTDefaultCellEditor cellEditor = new KDTDefaultCellEditor((JTextField)integerField);
        int i = 2;
        int j = 1;
        while (i < this.colmnLength) {
            this.col = this.tblMain.addColumn();
            this.col.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
            this.col.setEditor((ICellEditor)cellEditor);
            this.setColumnDecimalFormat(this.col);
            ++i;
            ++j;
        }
        this.row = this.tblMain.addHeadRow();
        if (this.ppType == PersonPlanType.POSITION) {
            this.row.getCell(0).setValue((Object)this.positionStr);
        } else if (this.ppType == PersonPlanType.JOB) {
            this.row.getCell(0).setValue((Object)this.jobStr);
        } else if (this.ppType == PersonPlanType.PERSON) {
            this.row.getCell(0).setValue((Object)this.adminStr);
        }
        this.row.getCell(1).setValue((Object)this.allowOverStr);
        int tempYear = this.startYear;
        int j2 = this.startMonth;
        for (int i2 = 2; i2 < this.colmnLength; ++i2) {
            this.row.getCell(i2).setValue((Object)(tempYear + this.yearStr + (j2 + 1) + this.monthStr));
            if (j2 == 11) {
                j2 = 0;
                ++tempYear;
                continue;
            }
            ++j2;
        }
    }

    private void createHeadByQuarter() throws Exception {
        int startMonthCount = this.startYear * 4 + this.startMonth + 1;
        int endMonthCount = this.endYear * 4 + this.endMonth + 1;
        this.colmnLength = endMonthCount - startMonthCount + 3;
        KDFormattedTextField integerField = new KDFormattedTextField(0);
        integerField.setHorizontalAlignment(4);
        integerField.putClientProperty((Object)"OriginValue", (Object)Boolean.TRUE);
        integerField.setMinimumValue((Comparable)Integer.valueOf(0));
        integerField.setDataVerifierType(12);
        integerField.setSupportedEmpty(true);
        KDTDefaultCellEditor cellEditor = new KDTDefaultCellEditor((JTextField)integerField);
        int i = 2;
        int j = 1;
        while (i < this.colmnLength) {
            this.col = this.tblMain.addColumn();
            this.col.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
            this.col.setEditor((ICellEditor)cellEditor);
            this.setColumnDecimalFormat(this.col);
            ++i;
            ++j;
        }
        this.row = this.tblMain.addHeadRow();
        if (this.ppType == PersonPlanType.POSITION) {
            this.row.getCell(0).setValue((Object)this.positionStr);
        } else if (this.ppType == PersonPlanType.JOB) {
            this.row.getCell(0).setValue((Object)this.jobStr);
        } else if (this.ppType == PersonPlanType.PERSON) {
            this.row.getCell(0).setValue((Object)this.adminStr);
        }
        this.row.getCell(1).setValue((Object)this.allowOverStr);
        int tempYear = this.startYear;
        int j2 = this.startMonth;
        for (int i2 = 2; i2 < this.colmnLength; ++i2) {
            this.row.getCell(i2).setValue((Object)(tempYear + this.yearStr + (j2 + 1) + this.quarterStr));
            if (j2 == 3) {
                j2 = 0;
                ++tempYear;
                continue;
            }
            ++j2;
        }
    }

    private void createHeadByHalfYear() throws Exception {
        int startMonthCount = this.startYear * 2 + this.startMonth + 1;
        int endMonthCount = this.endYear * 2 + this.endMonth + 1;
        this.colmnLength = endMonthCount - startMonthCount + 3;
        KDFormattedTextField integerField = new KDFormattedTextField(0);
        integerField.setHorizontalAlignment(4);
        integerField.putClientProperty((Object)"OriginValue", (Object)Boolean.TRUE);
        integerField.setMinimumValue((Comparable)Integer.valueOf(0));
        integerField.setDataVerifierType(12);
        integerField.setSupportedEmpty(true);
        KDTDefaultCellEditor cellEditor = new KDTDefaultCellEditor((JTextField)integerField);
        int i = 2;
        int j = 1;
        while (i < this.colmnLength) {
            this.col = this.tblMain.addColumn();
            this.col.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
            this.col.setEditor((ICellEditor)cellEditor);
            this.setColumnDecimalFormat(this.col);
            ++i;
            ++j;
        }
        this.row = this.tblMain.addHeadRow();
        if (this.ppType == PersonPlanType.POSITION) {
            this.row.getCell(0).setValue((Object)this.positionStr);
        } else if (this.ppType == PersonPlanType.JOB) {
            this.row.getCell(0).setValue((Object)this.jobStr);
        } else if (this.ppType == PersonPlanType.PERSON) {
            this.row.getCell(0).setValue((Object)this.adminStr);
        }
        this.row.getCell(1).setValue((Object)this.allowOverStr);
        int tempYear = this.startYear;
        String tempStr = null;
        int j2 = this.startMonth;
        for (int i2 = 2; i2 < this.colmnLength; ++i2) {
            tempStr = tempYear + this.yearStr;
            tempStr = j2 == 0 ? tempStr + this.firstHalfYearStr : tempStr + this.secondHalfYearStr;
            this.row.getCell(i2).setValue((Object)tempStr);
            if (j2 == 0) {
                j2 = 1;
                continue;
            }
            ++tempYear;
            j2 = 0;
        }
    }

    private void createHeadByYear() throws Exception {
        this.colmnLength = this.endYear - this.startYear + 3;
        KDFormattedTextField integerField = new KDFormattedTextField(0);
        integerField.setHorizontalAlignment(4);
        integerField.putClientProperty((Object)"OriginValue", (Object)Boolean.TRUE);
        integerField.setMinimumValue((Comparable)Integer.valueOf(0));
        integerField.setDataVerifierType(12);
        integerField.setSupportedEmpty(true);
        KDTDefaultCellEditor cellEditor = new KDTDefaultCellEditor((JTextField)integerField);
        int i = 2;
        int j = 1;
        while (i < this.colmnLength) {
            this.col = this.tblMain.addColumn();
            this.col.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
            this.col.setEditor((ICellEditor)cellEditor);
            this.setColumnDecimalFormat(this.col);
            ++i;
            ++j;
        }
        this.row = this.tblMain.addHeadRow();
        if (this.ppType == PersonPlanType.POSITION) {
            this.row.getCell(0).setValue((Object)this.positionStr);
        } else if (this.ppType == PersonPlanType.JOB) {
            this.row.getCell(0).setValue((Object)this.jobStr);
        } else if (this.ppType == PersonPlanType.PERSON) {
            this.row.getCell(0).setValue((Object)this.adminStr);
        }
        this.row.getCell(1).setValue((Object)this.allowOverStr);
        int tempYear = this.startYear;
        for (int i2 = 2; i2 < this.colmnLength; ++i2) {
            this.row.getCell(i2).setValue((Object)(tempYear + this.yearStr));
            ++tempYear;
        }
    }

    private void loadAdminDataByPerson(IPersonPlan iPPlan, String objId, ArrayList monthList) throws Exception {
        this.row = this.tblMain.addRow();
        this.row.getCell(0).setValue((Object)this.adminInfo);
        this.setAllowOverRow(this.row, iPPlan, this.adminInfo.getId().toString(), this.adminInfo.getId().toString());
        ArrayList list = this.getHistoryData(this.ppType, this.adminInfo.getId().toString(), monthList);
        int size = this.colmnLength;
        for (int i = 2; i < size; ++i) {
            if (list.get(i - 2) != null) {
                this.row.getCell(i).setValue((Object)((Integer)list.get(i - 2)));
                continue;
            }
            this.row.getCell(i).setValue((Object)"--");
        }
        if (this.selectNode != null) {
            DefaultKingdeeTreeNode childNode = null;
            AdminOrgUnitInfo childAdminInfo = null;
            int size2 = this.selectNode.getChildCount();
            for (int i = 0; i < size2; ++i) {
                this.row = this.tblMain.addRow();
                childNode = (DefaultKingdeeTreeNode)this.selectNode.getChildAt(i);
                childAdminInfo = (AdminOrgUnitInfo)childNode.getUserObject();
                this.setAllowOverRow(this.row, iPPlan, childAdminInfo.getId().toString(), childAdminInfo.getId().toString());
                this.row.getCell(0).setValue((Object)childAdminInfo);
                list = this.getHistoryData(this.ppType, childAdminInfo.getId().toString(), monthList);
                int length = this.colmnLength;
                for (int t = 2; t < length; ++t) {
                    if (list.get(t - 2) != null) {
                        this.row.getCell(t).setValue((Object)((Integer)list.get(t - 2)));
                        continue;
                    }
                    this.row.getCell(t).setValue((Object)"--");
                }
            }
        }
    }

    private void setAllowOverRow(IRow row, IPersonPlan iPPlan, String objId, String childAdminInfo) {
        if (this.systemParam == null) {
            try {
                this.systemParam = ParamManager.getParamValue(null, (IObjectPK)new ObjectUuidPK(SysContext.getSysContext().getCurrentHRUnit().getId()), (String)"IS_ALLOW_OVER");
            }
            catch (Exception e) {
                ExceptionHandler.handle((Throwable)e);
            }
        }
        if ("0".equals(this.systemParam)) {
            row.getCell(1).setValue((Object)true);
            row.getCell(1).getStyleAttributes().setLocked(true);
            row.getCell(1).getStyleAttributes().setBackground(new Color(217, 217, 210));
        } else if ("1".equals(this.systemParam)) {
            row.getCell(1).setValue((Object)false);
            row.getCell(1).getStyleAttributes().setLocked(true);
            row.getCell(1).getStyleAttributes().setBackground(new Color(217, 217, 210));
        } else if ("2".equals(this.systemParam)) {
            ArrayList listData = null;
            if (this.dataMap != null && this.dataMap.size() > 0) {
                listData = (ArrayList)this.dataMap.get(objId + "-@@-" + this.startYear);
                if (listData != null) {
                    if (listData.get(0) != null) {
                        int ii = Integer.parseInt(listData.get(0).toString());
                        if (ii == 1) {
                            row.getCell(1).setValue((Object)true);
                        } else {
                            row.getCell(1).setValue((Object)false);
                        }
                    }
                } else {
                    row.getCell(1).setValue((Object)true);
                }
            } else {
                row.getCell(1).setValue((Object)true);
            }
        }
    }

    private void loadTableDataByMonth() throws Exception {
        IPersonPlan iPPlan = PersonPlanFactory.getRemoteInstance();
        int tempYear = this.startYear;
        String objId = null;
        ArrayList list = null;
        ArrayList<String> monthList = new ArrayList<String>();
        if (this.ppType != PersonPlanType.PERSON) {
            int i;
            this.rows.beforeFirst();
            PositionInfo posiInfo = null;
            JobInfo jobInfo = null;
            tempYear = this.startYear;
            int j = this.startMonth;
            int size = this.colmnLength;
            for (i = 2; i < size; ++i) {
                monthList.add(tempYear + "-@@-" + (j + 1));
                if (j == 11) {
                    j = 0;
                    ++tempYear;
                    continue;
                }
                ++j;
            }
            while (this.rows.next()) {
                this.row = this.tblMain.addRow();
                objId = this.rows.getString("id");
                if (this.ppType == PersonPlanType.POSITION) {
                    posiInfo = new PositionInfo();
                    posiInfo.setId(BOSUuid.read((String)objId));
                    posiInfo.setName(this.rows.getString("name"));
                    jobInfo = new JobInfo();
                    if (this.rows.getString("Job.id") != null) {
                        jobInfo.setId(BOSUuid.read((String)this.rows.getString("Job.id")));
                    }
                    posiInfo.setJob(jobInfo);
                    this.row.getCell(0).setValue((Object)posiInfo);
                    this.setAllowOverRow(this.row, iPPlan, objId, null);
                } else if (this.ppType == PersonPlanType.JOB) {
                    JobInfo info = new JobInfo();
                    info.setId(BOSUuid.read((String)objId));
                    info.setName(this.rows.getString("name"));
                    this.row.getCell(0).setValue((Object)info);
                    this.setAllowOverRow(this.row, iPPlan, objId, null);
                }
                list = this.getHistoryData(this.ppType, objId, monthList);
                int size2 = this.colmnLength;
                for (i = 2; i < size2; ++i) {
                    if (list.get(i - 2) != null) {
                        this.row.getCell(i).setValue((Object)((Integer)list.get(i - 2)));
                        continue;
                    }
                    this.row.getCell(i).setValue((Object)"--");
                }
            }
        } else {
            int j = this.startMonth;
            int size = this.colmnLength;
            for (int i = 2; i < size; ++i) {
                monthList.add(tempYear + "-@@-" + (j + 1));
                if (j == 11) {
                    j = 0;
                    ++tempYear;
                    continue;
                }
                ++j;
            }
            this.loadAdminDataByPerson(iPPlan, objId, monthList);
        }
        this.createSumRow();
    }

    private ArrayList getHistoryData(PersonPlanType planType, String objId, ArrayList month) {
        ArrayList list = new ArrayList();
        String[] strList = null;
        ArrayList listData = null;
        int size = month.size();
        for (int i = 0; i < size; ++i) {
            if (this.dataMap != null && this.dataMap.size() > 0) {
                strList = month.get(i).toString().split("-@@-");
                listData = (ArrayList)this.dataMap.get(objId + "-@@-" + Integer.parseInt(strList[0]));
                if (listData != null) {
                    list.add(listData.get(Integer.parseInt(strList[1])));
                    continue;
                }
                list.add(new Integer(0));
                continue;
            }
            list.add(new Integer(0));
        }
        return list;
    }

    private void loadTableDataByQuarter() throws Exception {
        IPersonPlan iPPlan = PersonPlanFactory.getRemoteInstance();
        int tempYear = this.startYear;
        String objId = null;
        ArrayList list = null;
        ArrayList<String> monthList = new ArrayList<String>();
        if (this.ppType != PersonPlanType.PERSON) {
            int i;
            this.rows.beforeFirst();
            PositionInfo posiInfo = null;
            JobInfo jobInfo = null;
            tempYear = this.startYear;
            int j = this.startMonth;
            int size = this.colmnLength;
            for (i = 2; i < size; ++i) {
                monthList.add(tempYear + "-@@-" + (j + 1) * 3);
                if (j == 3) {
                    j = 0;
                    ++tempYear;
                    continue;
                }
                ++j;
            }
            while (this.rows.next()) {
                this.row = this.tblMain.addRow();
                objId = this.rows.getString("id");
                if (this.ppType == PersonPlanType.POSITION) {
                    posiInfo = new PositionInfo();
                    posiInfo.setId(BOSUuid.read((String)objId));
                    posiInfo.setName(this.rows.getString("name"));
                    jobInfo = new JobInfo();
                    if (this.rows.getString("Job.id") != null) {
                        jobInfo.setId(BOSUuid.read((String)this.rows.getString("Job.id")));
                    }
                    posiInfo.setJob(jobInfo);
                    this.row.getCell(0).setValue((Object)posiInfo);
                    this.setAllowOverRow(this.row, iPPlan, objId, null);
                } else if (this.ppType == PersonPlanType.JOB) {
                    JobInfo info = new JobInfo();
                    info.setId(BOSUuid.read((String)objId));
                    info.setName(this.rows.getString("name"));
                    this.row.getCell(0).setValue((Object)info);
                    this.setAllowOverRow(this.row, iPPlan, objId, null);
                }
                list = this.getHistoryData(this.ppType, objId, monthList);
                int size2 = this.colmnLength;
                for (i = 2; i < size2; ++i) {
                    if (list.get(i - 2) != null) {
                        this.row.getCell(i).setValue((Object)((Integer)list.get(i - 2)));
                        continue;
                    }
                    this.row.getCell(i).setValue((Object)"--");
                }
            }
        } else {
            int j = this.startMonth;
            int size = this.colmnLength;
            for (int i = 2; i < size; ++i) {
                monthList.add(tempYear + "-@@-" + (j + 1) * 3);
                if (j == 3) {
                    j = 0;
                    ++tempYear;
                    continue;
                }
                ++j;
            }
            this.loadAdminDataByPerson(iPPlan, objId, monthList);
        }
        this.createSumRow();
    }

    private void loadTableDataByHalfYear() throws Exception {
        IPersonPlan iPPlan = PersonPlanFactory.getRemoteInstance();
        int tempYear = this.startYear;
        String objId = null;
        ArrayList list = null;
        ArrayList<String> monthList = new ArrayList<String>();
        if (this.ppType != PersonPlanType.PERSON) {
            int i;
            this.rows.beforeFirst();
            PositionInfo posiInfo = null;
            JobInfo jobInfo = null;
            tempYear = this.startYear;
            int j = this.startMonth;
            int size = this.colmnLength;
            for (i = 2; i < size; ++i) {
                monthList.add(tempYear + "-@@-" + (j + 1) * 6);
                if (j == 0) {
                    j = 1;
                    continue;
                }
                ++tempYear;
                j = 0;
            }
            while (this.rows.next()) {
                this.row = this.tblMain.addRow();
                objId = this.rows.getString("id");
                if (this.ppType == PersonPlanType.POSITION) {
                    posiInfo = new PositionInfo();
                    posiInfo.setId(BOSUuid.read((String)objId));
                    posiInfo.setName(this.rows.getString("name"));
                    jobInfo = new JobInfo();
                    if (this.rows.getString("Job.id") != null) {
                        jobInfo.setId(BOSUuid.read((String)this.rows.getString("Job.id")));
                    }
                    posiInfo.setJob(jobInfo);
                    this.row.getCell(0).setValue((Object)posiInfo);
                    this.setAllowOverRow(this.row, iPPlan, objId, null);
                } else if (this.ppType == PersonPlanType.JOB) {
                    JobInfo info = new JobInfo();
                    info.setId(BOSUuid.read((String)objId));
                    info.setName(this.rows.getString("name"));
                    this.row.getCell(0).setValue((Object)info);
                    this.setAllowOverRow(this.row, iPPlan, objId, null);
                }
                list = this.getHistoryData(this.ppType, objId, monthList);
                int size2 = this.colmnLength;
                for (i = 2; i < size2; ++i) {
                    if (list.get(i - 2) != null) {
                        this.row.getCell(i).setValue((Object)((Integer)list.get(i - 2)));
                        continue;
                    }
                    this.row.getCell(i).setValue((Object)"--");
                }
            }
        } else {
            int j = this.startMonth;
            int size = this.colmnLength;
            for (int i = 2; i < size; ++i) {
                monthList.add(tempYear + "-@@-" + (j + 1) * 6);
                if (j == 0) {
                    j = 1;
                    continue;
                }
                ++tempYear;
                j = 0;
            }
            this.loadAdminDataByPerson(iPPlan, objId, monthList);
        }
        this.createSumRow();
    }

    private void loadTableDataByYear() throws Exception {
        IPersonPlan iPPlan = PersonPlanFactory.getRemoteInstance();
        int tempYear = this.startYear;
        String objId = null;
        ArrayList list = null;
        ArrayList<String> monthList = new ArrayList<String>();
        if (this.ppType != PersonPlanType.PERSON) {
            int i;
            this.rows.beforeFirst();
            PositionInfo posiInfo = null;
            JobInfo jobInfo = null;
            tempYear = this.startYear;
            int size = this.colmnLength;
            for (i = 2; i < size; ++i) {
                monthList.add(tempYear + "-@@-" + 12);
                ++tempYear;
            }
            while (this.rows.next()) {
                this.row = this.tblMain.addRow();
                objId = this.rows.getString("id");
                if (this.ppType == PersonPlanType.POSITION) {
                    posiInfo = new PositionInfo();
                    posiInfo.setId(BOSUuid.read((String)objId));
                    posiInfo.setName(this.rows.getString("name"));
                    jobInfo = new JobInfo();
                    if (this.rows.getString("Job.id") != null) {
                        jobInfo.setId(BOSUuid.read((String)this.rows.getString("Job.id")));
                    }
                    posiInfo.setJob(jobInfo);
                    this.row.getCell(0).setValue((Object)posiInfo);
                    this.setAllowOverRow(this.row, iPPlan, objId, null);
                } else if (this.ppType == PersonPlanType.JOB) {
                    JobInfo info = new JobInfo();
                    info.setId(BOSUuid.read((String)objId));
                    info.setName(this.rows.getString("name"));
                    this.row.getCell(0).setValue((Object)info);
                    this.setAllowOverRow(this.row, iPPlan, objId, null);
                }
                list = this.getHistoryData(this.ppType, objId, monthList);
                size = this.colmnLength;
                for (i = 2; i < size; ++i) {
                    if (list.get(i - 2) != null) {
                        this.row.getCell(i).setValue((Object)((Integer)list.get(i - 2)));
                        continue;
                    }
                    this.row.getCell(i).setValue((Object)"--");
                }
            }
        } else {
            int size = this.colmnLength;
            for (int i = 2; i < size; ++i) {
                monthList.add(tempYear + "-@@-" + 12);
                ++tempYear;
            }
            this.loadAdminDataByPerson(iPPlan, objId, monthList);
        }
        this.createSumRow();
    }

    private void createSumRow() {
        int rowCount = this.tblMain.getRowCount();
        int sum = 0;
        if (rowCount > 0) {
            this.row = this.tblMain.addRow();
            this.row.getStyleAttributes().setBackground(new Color(246, 246, 191));
            this.row.getStyleAttributes().setLocked(true);
            this.row.getCell(0).setValue((Object)this.sumStr);
            for (int i = 2; i < this.colmnLength; ++i) {
                sum = 0;
                for (int j = 0; j < rowCount; ++j) {
                    if (!(this.tblMain.getRow(j).getCell(i).getValue() instanceof Integer)) continue;
                    sum += ((Integer)this.tblMain.getRow(j).getCell(i).getValue()).intValue();
                }
                this.row.getCell(i).setValue((Object)new Integer(sum));
            }
        }
    }

    @Override
    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        IPermission permission = PermissionFactory.getRemoteInstance();
        ObjectUuidPK userPk = new ObjectUuidPK(SysContext.getSysContext().getCurrentUserInfo().getId());
        ObjectUuidPK orgPk = new ObjectUuidPK(SysContext.getSysContext().getCurrentOrgUnit().getId());
        permission.checkFunctionPermission((IObjectPK)userPk, (IObjectPK)orgPk, "PersonPlan_Submit");
        if (this.adminInfo == null || this.bizPPScheme.getData() == null) {
            return;
        }
        IPersonPlan iPPlan = PersonPlanFactory.getRemoteInstance();
        PersonPlanInfo ppInfo = new PersonPlanInfo();
        ppInfo.setAdminOrg(this.adminInfo);
        ppInfo.setType(this.ppType);
        ppInfo.setPeriod(this.period);
        ppInfo.setScheme(this.schemeInfo);
        int rowCount = this.tblMain.getRowCount() - 1;
        IRow curRow = null;
        String cellValue = null;
        int tempYear = this.startYear;
        PositionInfo positionInfo = null;
        for (int t = 0; t < rowCount; ++t) {
            curRow = this.tblMain.getRow(t);
            if (this.ppType == PersonPlanType.POSITION) {
                positionInfo = (PositionInfo)curRow.getCell(0).getValue();
                ppInfo.setPosition(positionInfo);
                ppInfo.setJob(positionInfo.getJob());
            } else if (this.ppType == PersonPlanType.JOB) {
                ppInfo.setJob((JobInfo)curRow.getCell(0).getValue());
            } else {
                ppInfo.setAdminOrg((AdminOrgUnitInfo)curRow.getCell(0).getValue());
            }
            tempYear = this.startYear;
            int j = this.startMonth;
            for (int i = 2; i < this.colmnLength; ++i) {
                if (curRow.getCell(i).getValue() instanceof Integer) {
                    cellValue = curRow.getCell(i).getValue().toString();
                    this.setPlanData(ppInfo, j + 1, Integer.parseInt(cellValue));
                } else {
                    this.setPlanData(ppInfo, j + 1, -1);
                }
                if (j == this.nextYearPoint) {
                    j = 0;
                    if (i + 1 >= this.colmnLength) continue;
                    ppInfo.setYear(tempYear);
                    if (curRow.getCell(1).getValue() != null) {
                        ppInfo.setIsAllowOver((Boolean)curRow.getCell(1).getValue());
                    }
                    iPPlan.addnew((CoreBaseInfo)ppInfo);
                    ++tempYear;
                    continue;
                }
                ++j;
            }
            ppInfo.setYear(tempYear);
            if (curRow.getCell(1).getValue() != null) {
                ppInfo.setIsAllowOver((Boolean)curRow.getCell(1).getValue());
            }
            iPPlan.addnew((CoreBaseInfo)ppInfo);
        }
        if (rowCount > 0) {
            StringBuffer retValue = new StringBuffer();
            if (ppInfo.getAdminOrg() != null && ppInfo.getAdminOrg().getName() != null) {
                retValue.append(ppInfo.getAdminOrg().getName() + "   ");
            }
            if (ppInfo.getScheme() != null && ppInfo.getScheme().getName() != null) {
                retValue.append(ppInfo.getScheme().getName());
            }
            this.dealLogInfo(iPPlan, retValue.toString(), "PersonPlan_Submit");
        }
        this.isModify = false;
        String res = EASResource.getString((String)"com.kingdee.eas.hr.org.ORGAutoGenerateResource", (String)"Msg_Save_OK_New");
        MsgBox.showInfo((String)res);
        this.treeMain_valueChanged(null);
    }

    private void dealLogInfo(IPersonPlan iPPlan, String loggerInfo, String LogItem) throws Exception {
        IObjectPK logPK = LogUtil.beginLog(null, (String)"", (BOSObjectType)iPPlan.getType(), null, (String)loggerInfo, (String)LogItem);
        LogUtil.afterLog(null, (IObjectPK)logPK);
    }

    private void setPlanData(PersonPlanInfo ppInfo, int month, int count) {
        if (count >= 0) {
            if (this.period == Period.QUARTER) {
                if (month == 1) {
                    ppInfo.setPlan1(count);
                    ppInfo.setPlan2(count);
                    ppInfo.setPlan3(count);
                } else if (month == 2) {
                    ppInfo.setPlan4(count);
                    ppInfo.setPlan5(count);
                    ppInfo.setPlan6(count);
                } else if (month == 3) {
                    ppInfo.setPlan7(count);
                    ppInfo.setPlan8(count);
                    ppInfo.setPlan9(count);
                } else if (month == 4) {
                    ppInfo.setPlan10(count);
                    ppInfo.setPlan11(count);
                    ppInfo.setPlan12(count);
                }
            } else if (this.period == Period.HALF_YEAR) {
                if (month == 1) {
                    ppInfo.setPlan1(count);
                    ppInfo.setPlan2(count);
                    ppInfo.setPlan3(count);
                    ppInfo.setPlan4(count);
                    ppInfo.setPlan5(count);
                    ppInfo.setPlan6(count);
                } else {
                    ppInfo.setPlan7(count);
                    ppInfo.setPlan8(count);
                    ppInfo.setPlan9(count);
                    ppInfo.setPlan10(count);
                    ppInfo.setPlan11(count);
                    ppInfo.setPlan12(count);
                }
            } else if (this.period == Period.YEAR) {
                ppInfo.setPlan1(count);
                ppInfo.setPlan2(count);
                ppInfo.setPlan3(count);
                ppInfo.setPlan4(count);
                ppInfo.setPlan5(count);
                ppInfo.setPlan6(count);
                ppInfo.setPlan7(count);
                ppInfo.setPlan8(count);
                ppInfo.setPlan9(count);
                ppInfo.setPlan10(count);
                ppInfo.setPlan11(count);
                ppInfo.setPlan12(count);
            } else if (month == 1) {
                ppInfo.setPlan1(count);
            } else if (month == 2) {
                ppInfo.setPlan2(count);
            } else if (month == 3) {
                ppInfo.setPlan3(count);
            } else if (month == 4) {
                ppInfo.setPlan4(count);
            } else if (month == 5) {
                ppInfo.setPlan5(count);
            } else if (month == 6) {
                ppInfo.setPlan6(count);
            } else if (month == 7) {
                ppInfo.setPlan7(count);
            } else if (month == 8) {
                ppInfo.setPlan8(count);
            } else if (month == 9) {
                ppInfo.setPlan9(count);
            } else if (month == 10) {
                ppInfo.setPlan10(count);
            } else if (month == 11) {
                ppInfo.setPlan11(count);
            } else if (month == 12) {
                ppInfo.setPlan12(count);
            }
        } else if (this.period == Period.QUARTER) {
            if (month == 1) {
                ppInfo.put("plan1", null);
                ppInfo.put("plan2", null);
                ppInfo.put("plan3", null);
            } else if (month == 2) {
                ppInfo.put("plan4", null);
                ppInfo.put("plan5", null);
                ppInfo.put("plan6", null);
            } else if (month == 3) {
                ppInfo.put("plan7", null);
                ppInfo.put("plan8", null);
                ppInfo.put("plan9", null);
            } else if (month == 4) {
                ppInfo.put("plan10", null);
                ppInfo.put("plan11", null);
                ppInfo.put("plan12", null);
            }
        } else if (this.period == Period.HALF_YEAR) {
            if (month == 1) {
                ppInfo.put("plan1", null);
                ppInfo.put("plan2", null);
                ppInfo.put("plan3", null);
                ppInfo.put("plan4", null);
                ppInfo.put("plan5", null);
                ppInfo.put("plan6", null);
            } else {
                ppInfo.put("plan7", null);
                ppInfo.put("plan8", null);
                ppInfo.put("plan9", null);
                ppInfo.put("plan10", null);
                ppInfo.put("plan11", null);
                ppInfo.put("plan12", null);
            }
        } else if (this.period == Period.YEAR) {
            ppInfo.put("plan1", null);
            ppInfo.put("plan2", null);
            ppInfo.put("plan3", null);
            ppInfo.put("plan4", null);
            ppInfo.put("plan5", null);
            ppInfo.put("plan6", null);
            ppInfo.put("plan7", null);
            ppInfo.put("plan8", null);
            ppInfo.put("plan9", null);
            ppInfo.put("plan10", null);
            ppInfo.put("plan11", null);
            ppInfo.put("plan12", null);
        } else if (month == 1) {
            ppInfo.put("plan1", null);
        } else if (month == 2) {
            ppInfo.put("plan2", null);
        } else if (month == 3) {
            ppInfo.put("plan3", null);
        } else if (month == 4) {
            ppInfo.put("plan4", null);
        } else if (month == 5) {
            ppInfo.put("plan5", null);
        } else if (month == 6) {
            ppInfo.put("plan6", null);
        } else if (month == 7) {
            ppInfo.put("plan7", null);
        } else if (month == 8) {
            ppInfo.put("plan8", null);
        } else if (month == 9) {
            ppInfo.put("plan9", null);
        } else if (month == 10) {
            ppInfo.put("plan10", null);
        } else if (month == 11) {
            ppInfo.put("plan11", null);
        } else if (month == 12) {
            ppInfo.put("plan12", null);
        }
    }

    public boolean checkBeforeWindowClosing() {
        boolean b = super.checkBeforeWindowClosing();
        if (!b) {
            return b;
        }
        if (this.isModify) {
            int result = MsgBox.showConfirm3((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Confirm_Save_Exit"));
            if (result == 0) {
                this.actionSubmit.setDaemonRun(false);
                ActionEvent event = new ActionEvent(this.btnSubmit, 1001, this.btnSubmit.getActionCommand());
                this.actionSubmit.actionPerformed(event);
                return !this.actionSubmit.isInvokeFailed();
            }
            return result == 1;
        }
        return true;
    }

    @Override
    protected void chkShowVirtualOrg_itemStateChanged(ItemEvent e) throws Exception {
        this.treeMain.setShowsRootHandles(true);
        DefaultKingdeeTreeNode rootNode = NewOrgTreeHelper.createAdminTreeNodeByHRO(null, (boolean)true, (boolean)false, (boolean)false, (boolean)this.chkShowVirtualOrg.isSelected());
        if (rootNode != null) {
            DefaultTreeModel treeModel = new DefaultTreeModel((TreeNode)rootNode);
            this.treeMain.setModel((TreeModel)treeModel);
            if (!OrgF7InnerUtils.isTreeNodeDisable((DefaultKingdeeTreeNode)rootNode) || rootNode.getChildCount() == 0) {
                TreePath path = new TreePath(rootNode);
                this.treeMain.expandPath(path);
                this.treeMain.setSelectionPath(path);
            } else {
                DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)rootNode.getChildAt(0);
                TreePath path = new TreePath(node.getPath());
                this.treeMain.expandPath(path);
                this.treeMain.setSelectionPath(path);
            }
        } else {
            this.treeMain.setModel(null);
        }
    }

    @Override
    public void actionPlanView_actionPerformed(ActionEvent e) throws Exception {
        if (this.isModify) {
            throw new PersonPlanException(PersonPlanException.NOT_SATE_SCHEME);
        }
        if (this.schemeInfo == null) {
            return;
        }
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"planScheme", (Object)this.schemeInfo);
        uiContext.put((Object)"IsShowVirtual", (Object)this.chkShowVirtualOrg.isSelected());
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory").create(PersonPlanMainEditUI.class.getName(), (Map)uiContext);
        uiWindow.show();
    }

    @Override
    protected void isShowDisableJob_itemStateChanged(ItemEvent e) throws Exception {
        if (this.ppType != PersonPlanType.JOB) {
            return;
        }
        this.adminInfo = this.getSelectAdminOrg();
        if (this.adminInfo == null || this.bizPPScheme.getData() == null) {
            this.tblMain.removeRows();
            return;
        }
        IQueryExecutor queryExcu = null;
        MetaDataPK queryPK = new MetaDataPK("com.kingdee.eas.hr.org.app.PositionJobList");
        queryExcu = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)queryPK);
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("AdminUnit.id", (Object)this.adminInfo.getId(), CompareType.EQUALS));
        if (!this.isShowDisableJob.isSelected()) {
            filterInfo.getFilterItems().add(new FilterItemInfo("state", (Object)2, CompareType.NOTEQUALS));
            filterInfo.setMaskString("#0 and #1");
        }
        viewInfo.setFilter(filterInfo);
        queryExcu.setObjectView(viewInfo);
        this.rows = queryExcu.executeQuery();
        this.createTable();
    }

    private void initIsShowDisableJob() {
        if (this.ppType == PersonPlanType.JOB) {
            this.isShowDisableJob.setVisible(true);
        } else {
            this.isShowDisableJob.setVisible(false);
        }
    }

    private void setColumnDecimalFormat(IColumn col) {
        col.getStyleAttributes().setNumberFormat(CtrlFormatUtilities.getDecimalFormatString());
    }
}

