/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.org.client;

import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.base.util.OrgStringUtil;
import com.kingdee.eas.hr.emp.client.EmployeeClientUtils;
import com.kingdee.eas.hr.org.Period;
import com.kingdee.eas.hr.org.PersonPlanSchemeFactory;
import com.kingdee.eas.hr.org.PersonPlanSchemeInfo;
import com.kingdee.eas.hr.org.PersonPlanSchemeTypeEnum;
import com.kingdee.eas.hr.org.PersonPlanType;
import com.kingdee.eas.hr.org.client.AbstractPersonPlanReportFilterUI;
import com.kingdee.eas.hr.org.client.AdminByOrgRangePromptBox;
import com.kingdee.eas.hr.org.client.PersonPlanSchemePromptBox;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import java.util.HashSet;

public class PersonPlanReportFilterUI
extends AbstractPersonPlanReportFilterUI {
    private static final String resClass = "com.kingdee.eas.hr.org.client.PersonPlanResource.";

    private void initF7() throws Exception {
        this.bizScheme.setDisplayFormat("$name$");
        this.bizScheme.setEditFormat("$number$");
        this.bizScheme.setCommitFormat("$number$");
        this.bizScheme.setQueryInfo("com.kingdee.eas.hr.org.app.PersonPlanSchemaQuery");
        this.bizScheme.setEditable(true);
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        if (SysContext.getSysContext().getCurrentHRUnit() == null) {
            return;
        }
        filter.getFilterItems().add(new FilterItemInfo("hrOrgUnit.id", (Object)SysContext.getSysContext().getCurrentHRUnit().getId().toString(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("schemeType", (Object)1));
        filter.getFilterItems().add(new FilterItemInfo("status", (Object)1));
        filter.getFilterItems().add(new FilterItemInfo("status", (Object)2));
        filter.getFilterItems().add(new FilterItemInfo("status", (Object)3));
        filter.setMaskString("(#0 or #1) and (#2 or #3 or #4)");
        viewInfo.setFilter(filter);
        this.bizScheme.setEntityViewInfo(viewInfo);
        HashMap<String, Boolean> map = new HashMap<String, Boolean>();
        map.put("INCLUDE_INVALID", Boolean.TRUE);
        this.bizScheme.setSelector((KDPromptSelector)new PersonPlanSchemePromptBox((IUIObject)this, map));
        if (this.getUIContext().get("SelectScheme") != null) {
            this.bizScheme.setValue((Object)((PersonPlanSchemeInfo)this.getUIContext().get("SelectScheme")));
        }
        this.bizScheme.setRequired(true);
        this.initOrgF7(true);
        this.bizAdminOrg.setRequired(true);
        this.cboLevel.setRequired(true);
        this.bizScheme.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent e) {
                try {
                    if (e.getNewValue() != null) {
                        Object obj = e.getNewValue();
                        PersonPlanSchemeInfo info = (PersonPlanSchemeInfo)obj;
                        if (PersonPlanSchemeTypeEnum.Group.equals((Object)info.getSchemeType())) {
                            PersonPlanReportFilterUI.this.initOrgF7(false);
                        } else {
                            PersonPlanReportFilterUI.this.initOrgF7(true);
                        }
                    }
                }
                catch (Exception e1) {
                    PersonPlanReportFilterUI.this.handUIException(e1);
                }
            }
        });
    }

    private void initOrgF7(boolean isHroFilter) {
        AdminByOrgRangePromptBox adminMultPrmt = new AdminByOrgRangePromptBox();
        adminMultPrmt.setIsSingleSelect(false);
        adminMultPrmt.setIncludeSealUp(false);
        adminMultPrmt.showChkSealUp(true);
        AdminByOrgRangePromptBox adminPrmt = new AdminByOrgRangePromptBox();
        adminPrmt.showChkSealUp(true);
        String hroid = SysContext.getSysContext().getCurrentHRUnit().getId().toString();
        HashSet<String> hroSet = new HashSet<String>();
        hroSet.add(hroid);
        if (!isHroFilter) {
            adminMultPrmt.setHROFilter(null);
            adminPrmt.setHROFilter(null);
        } else {
            adminMultPrmt.setHROFilter(hroSet);
            adminPrmt.setHROFilter(hroSet);
        }
        this.bizAdminOrg.setSelector((KDPromptSelector)adminPrmt);
        this.bizAdminOrgMult.setSelector((KDPromptSelector)adminMultPrmt);
        this.bizAdminOrg.setEditable(false);
        this.bizAdminOrgMult.setEditable(false);
        this.bizScheme.setEditable(false);
    }

    private void setOrgCommentEnabled() {
        boolean isRdOrgSelected = this.rdOrg.isSelected();
        boolean isRdOrgMultSelected = this.rdOrgMult.isSelected();
        this.bizAdminOrg.setEnabled(isRdOrgSelected);
        this.bizAdminOrgMult.setEnabled(isRdOrgMultSelected);
        this.chkShowVirtualOrg.setEnabled(true);
        this.chkShowSealUpOrg.setEnabled(true);
        boolean isAdminOrgEnable = this.bizAdminOrg.isEnabled();
        this.rdDisplayAll.setEnabled(isAdminOrgEnable);
        this.rdDisplaySelf.setEnabled(isAdminOrgEnable);
        this.rdDisplaySub.setEnabled(isAdminOrgEnable);
        this.comboOrgLevel.setEnabled(isAdminOrgEnable);
        if (isRdOrgSelected) {
            this.bizAdminOrgMult.setData(null);
        } else {
            this.bizAdminOrg.setData(null);
        }
    }

    public void clear() {
        super.clear();
        this.rdOrg.setSelected(true);
        this.bizAdminOrg.setData(null);
        this.bizAdminOrgMult.setData(null);
        this.bizScheme.setData(null);
        this.cboLevel.removeAllItems();
        this.chkShowInvalidPosition.setSelected(false);
        this.chkShowVirtualOrg.setSelected(false);
        this.chkShowSealUpOrg.setSelected(false);
        this.chkShowDisableJob.setSelected(false);
        this.rdDisplayAll.setSelected(true);
        this.comboOrgLevel.removeAllItems();
        this.setOrgCommentEnabled();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.initF7();
        this.labDisplay.setVisible(false);
        this.labOrg.setVisible(false);
    }

    public boolean verify() {
        if (this.rdOrg.isSelected() && this.bizAdminOrg.getData() == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.hr.org.client.PersonPlanResource.NO_SELECT_ADMINORG"));
            return false;
        }
        if (this.rdOrgMult.isSelected() && this.bizAdminOrgMult.getData() == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.hr.org.client.PersonPlanResource.NO_SELECT_ADMINORG"));
            return false;
        }
        if (this.bizScheme.getData() == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.hr.org.client.PersonPlanResource.NO_SELECT_SCHEME"));
            return false;
        }
        int startYear = (Integer)this.txtStartYear.getSelectedItem();
        int endYear = (Integer)this.txtEndYear.getSelectedItem();
        if (startYear * 100 + this.txtStartMonth.getSelectedIndex() > endYear * 100 + this.txtEndMonth.getSelectedIndex()) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.hr.org.client.PersonPlanResource.SCHEME_TIME_ERROR"));
            return false;
        }
        return true;
    }

    public void setCustomerParams(CustomerParams param) {
        String orgIds;
        this.clear();
        super.setCustomerParams(param);
        if (param == null) {
            return;
        }
        if (param.getBoolean(this.rdOrg.getName())) {
            this.rdOrg.setSelected(true);
        }
        if (param.getBoolean(this.rdOrgMult.getName())) {
            this.rdOrgMult.setSelected(true);
        }
        ObjectUuidPK pk = null;
        if (param.getCustomerParam("SelectOrg") != null) {
            pk = new ObjectUuidPK(BOSUuid.read((String)param.getCustomerParam("SelectOrg")));
            AdminOrgUnitInfo adminInfo = null;
            try {
                adminInfo = AdminOrgUnitFactory.getRemoteInstance().getAdminOrgUnitInfo((IObjectPK)pk);
                this.bizAdminOrg.setData((Object)adminInfo);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if ((orgIds = param.getCustomerParam(this.bizAdminOrgMult.getName())) != null) {
            Object[] orgs = OrgStringUtil.string2OrgInfoArr((String)orgIds);
            this.bizAdminOrgMult.setData((Object)orgs);
        }
        if (param.getCustomerParam("SelectScheme") != null) {
            pk = new ObjectUuidPK(BOSUuid.read((String)param.getCustomerParam("SelectScheme")));
            PersonPlanSchemeInfo info = null;
            try {
                info = PersonPlanSchemeFactory.getRemoteInstance().getPersonPlanSchemeInfo((IObjectPK)pk);
            }
            catch (Exception e) {
                return;
            }
            this.bizScheme.setData((Object)info);
        }
        this.rdDisplaySelf.setSelected(param.getBoolean(this.rdDisplaySelf.getName()));
        this.rdDisplaySub.setSelected(param.getBoolean(this.rdDisplaySub.getName()));
        this.rdDisplayAll.setSelected(param.getBoolean(this.rdDisplayAll.getName()));
        int level = param.getInt(this.comboOrgLevel.getName());
        this.setComboOrgLevel();
        if (level != 100 && this.comboOrgLevel.getItemCount() > level) {
            this.comboOrgLevel.setSelectedIndex(level);
        }
        this.chkShowInvalidPosition.setSelected(param.getBoolean("isShowInvalidPosition"));
        this.chkShowVirtualOrg.setSelected(param.getBoolean("ShowVirtualOrg"));
        this.chkShowSealUpOrg.setSelected(param.getBoolean("showSealUpOrg"));
        this.chkShowDisableJob.setSelected(param.getBoolean("showDisableJob"));
        this.setOrgCommentEnabled();
    }

    private void setComboOrgLevel() {
        AdminOrgUnitInfo adminOrgUnit = (AdminOrgUnitInfo)this.bizAdminOrg.getValue();
        if (adminOrgUnit == null) {
            this.comboOrgLevel.removeAllItems();
        } else {
            try {
                EmployeeClientUtils.setComboBoxLevel((CoreBaseInfo)adminOrgUnit, (KDComboBox)this.comboOrgLevel);
            }
            catch (Exception e) {
                this.handUIException(e);
            }
        }
    }

    public CustomerParams getCustomerParams() {
        CustomerParams params = new CustomerParams();
        PersonPlanSchemeInfo psInfo = null;
        if (this.rdOrgMult.isSelected()) {
            if (this.bizAdminOrgMult.getData() != null) {
                params.addCustomerParam(this.bizAdminOrgMult.getName(), OrgStringUtil.orgInfoArr2String((Object[])((Object[])this.bizAdminOrgMult.getData())));
            }
            params.putBoolean("ShowVirtualOrg", true);
            params.putBoolean("ShowVirtualOrg", this.chkShowVirtualOrg.isSelected());
            params.putBoolean("showSealUpOrg", this.chkShowSealUpOrg.isSelected());
        } else {
            params.putBoolean(this.rdDisplaySelf.getName(), this.rdDisplaySelf.isSelected());
            params.putBoolean(this.rdDisplaySub.getName(), this.rdDisplaySub.isSelected());
            params.putBoolean(this.rdDisplayAll.getName(), this.rdDisplayAll.isSelected());
            if (this.rdDisplaySub.isSelected()) {
                params.putInt(this.comboOrgLevel.getName(), this.comboOrgLevel.getSelectedIndex());
            } else if (this.rdDisplaySelf.isSelected()) {
                params.putInt(this.comboOrgLevel.getName(), 0);
            } else {
                params.putInt(this.comboOrgLevel.getName(), 100);
            }
            params.addCustomerParam("SelectOrg", ((AdminOrgUnitInfo)this.bizAdminOrg.getData()).getId().toString());
            params.putBoolean("ShowVirtualOrg", this.chkShowVirtualOrg.isSelected());
            params.putBoolean("showSealUpOrg", this.chkShowSealUpOrg.isSelected());
        }
        params.putBoolean(this.rdOrg.getName(), this.rdOrg.isSelected());
        params.putBoolean(this.rdOrgMult.getName(), this.rdOrgMult.isSelected());
        if (this.bizScheme.getData() instanceof PersonPlanSchemeInfo) {
            params.addCustomerParam("SelectScheme", ((PersonPlanSchemeInfo)this.bizScheme.getData()).getId().toString());
        } else if (this.bizScheme.getData() != null) {
            Object[] obj = (Object[])this.bizScheme.getData();
            psInfo = (PersonPlanSchemeInfo)obj[0];
            params.addCustomerParam("SelectScheme", psInfo.getId().toString());
        }
        params.putInt("level", 100);
        params.putBoolean("isShowInvalidPosition", this.chkShowInvalidPosition.isSelected());
        params.putBoolean("showDisableJob", this.chkShowDisableJob.isSelected());
        if (this.txtStartYear.getSelectedItem() instanceof Integer) {
            params.putInt("startYear", ((Integer)this.txtStartYear.getSelectedItem()).intValue());
        }
        if (this.txtEndYear.getSelectedItem() instanceof Integer) {
            params.putInt("endYear", ((Integer)this.txtEndYear.getSelectedItem()).intValue());
        }
        if (this.txtStartMonth.getSelectedItem() instanceof Integer) {
            params.putInt("startMonth", ((Integer)this.txtStartMonth.getSelectedItem()).intValue());
        }
        if (this.txtEndMonth.getSelectedItem() instanceof Integer) {
            params.putInt("endMonth", ((Integer)this.txtEndMonth.getSelectedItem()).intValue());
        }
        if (this.txtStartMonth.getSelectedItem() instanceof String) {
            if (EASResource.getString((String)"com.kingdee.eas.hr.org.client.PersonPlanResource.FIRST_HALFYEAR").equals(this.txtStartMonth.getSelectedItem())) {
                params.putInt("startMonth", 0);
            } else {
                params.putInt("startMonth", 1);
            }
        }
        if (this.txtEndMonth.getSelectedItem() instanceof String) {
            if (EASResource.getString((String)"com.kingdee.eas.hr.org.client.PersonPlanResource.FIRST_HALFYEAR").equals(this.txtEndMonth.getSelectedItem())) {
                params.putInt("endMonth", 0);
            } else {
                params.putInt("endMonth", 1);
            }
        }
        return params;
    }

    @Override
    protected void bizScheme_dataChanged(DataChangeEvent e) throws Exception {
        super.bizScheme_dataChanged(e);
        Object obj = this.bizScheme.getValue();
        if (obj instanceof PersonPlanSchemeInfo && PersonPlanType.POSITION.equals((Object)((PersonPlanSchemeInfo)obj).getPlanType())) {
            this.chkShowInvalidPosition.setEnabled(true);
            this.chkShowDisableJob.setSelected(false);
            this.chkShowDisableJob.setEnabled(false);
        } else if (obj instanceof PersonPlanSchemeInfo && PersonPlanType.JOB.equals((Object)((PersonPlanSchemeInfo)obj).getPlanType())) {
            this.chkShowDisableJob.setEnabled(true);
            this.chkShowInvalidPosition.setSelected(false);
            this.chkShowInvalidPosition.setEnabled(false);
        } else {
            this.chkShowInvalidPosition.setSelected(false);
            this.chkShowInvalidPosition.setEnabled(false);
            this.chkShowDisableJob.setSelected(false);
            this.chkShowDisableJob.setEnabled(false);
        }
        if (obj instanceof PersonPlanSchemeInfo) {
            PersonPlanSchemeInfo ppsInfo = (PersonPlanSchemeInfo)obj;
            Period period = ppsInfo.getPeriod();
            this.txtStartYear.removeAllItems();
            this.txtEndYear.removeAllItems();
            this.txtStartMonth.removeAllItems();
            this.txtEndMonth.removeAllItems();
            switch (period.getValue()) {
                case 0: {
                    this.createYearCombox(ppsInfo);
                    break;
                }
                case 1: {
                    this.createHalfYearCombox(ppsInfo);
                    break;
                }
                case 2: {
                    this.createQuarterCombox(ppsInfo);
                    break;
                }
                default: {
                    this.createMonthCombox(ppsInfo);
                }
            }
        }
    }

    private void createYearCombox(PersonPlanSchemeInfo ppsInfo) {
        this.labMonth.setVisible(false);
        this.labMonth2.setVisible(false);
        this.txtStartMonth.setVisible(false);
        this.txtEndMonth.setVisible(false);
        this.setSelectedYearAndMonth(ppsInfo);
    }

    private void createHalfYearCombox(PersonPlanSchemeInfo ppsInfo) {
        this.txtStartMonth.setVisible(true);
        this.txtEndMonth.setVisible(true);
        this.labMonth.setVisible(false);
        this.labMonth2.setVisible(false);
        this.txtStartMonth.addItem((Object)EASResource.getString((String)"com.kingdee.eas.hr.org.client.PersonPlanResource.FIRST_HALFYEAR"));
        this.txtStartMonth.addItem((Object)EASResource.getString((String)"com.kingdee.eas.hr.org.client.PersonPlanResource.SECOND_HALF_YEAR"));
        this.txtEndMonth.addItem((Object)EASResource.getString((String)"com.kingdee.eas.hr.org.client.PersonPlanResource.FIRST_HALFYEAR"));
        this.txtEndMonth.addItem((Object)EASResource.getString((String)"com.kingdee.eas.hr.org.client.PersonPlanResource.SECOND_HALF_YEAR"));
        this.setSelectedYearAndMonth(ppsInfo);
        this.txtStartMonth.setSelectedIndex(0);
        this.txtEndMonth.setSelectedIndex(1);
    }

    private void createQuarterCombox(PersonPlanSchemeInfo ppsInfo) {
        this.labMonth.setVisible(true);
        this.labMonth2.setVisible(true);
        this.txtStartMonth.setVisible(true);
        this.txtEndMonth.setVisible(true);
        this.labMonth.setBoundLabelText(EASResource.getString((String)"com.kingdee.eas.hr.org.client.PersonPlanResource.QUARTER"));
        this.labMonth2.setBoundLabelText(EASResource.getString((String)"com.kingdee.eas.hr.org.client.PersonPlanResource.QUARTER"));
        this.setSelectedYearAndMonth(ppsInfo);
        for (int i = 1; i < 5; ++i) {
            this.txtStartMonth.addItem((Object)i);
            this.txtEndMonth.addItem((Object)i);
        }
        this.txtStartMonth.setSelectedIndex(0);
        this.txtEndMonth.setSelectedIndex(3);
    }

    private void createMonthCombox(PersonPlanSchemeInfo ppsInfo) {
        this.labMonth.setVisible(true);
        this.labMonth2.setVisible(true);
        this.txtStartMonth.setVisible(true);
        this.txtEndMonth.setVisible(true);
        this.labMonth.setBoundLabelText(EASResource.getString((String)"com.kingdee.eas.hr.org.client.PersonPlanResource.MONTH"));
        this.labMonth2.setBoundLabelText(EASResource.getString((String)"com.kingdee.eas.hr.org.client.PersonPlanResource.MONTH"));
        this.setSelectedYearAndMonth(ppsInfo);
        for (int i = 1; i < 13; ++i) {
            this.txtStartMonth.addItem((Object)i);
            this.txtEndMonth.addItem((Object)i);
        }
        this.txtStartMonth.setSelectedIndex(0);
        this.txtEndMonth.setSelectedIndex(11);
    }

    private void setSelectedYearAndMonth(PersonPlanSchemeInfo ppsInfo) {
        int beginYearTemp = ppsInfo.getStartYear();
        int endYearTemp = ppsInfo.getEndYear();
        int size = endYearTemp;
        for (int i = beginYearTemp; i <= size; ++i) {
            this.txtStartYear.addItem((Object)i);
            this.txtEndYear.addItem((Object)i);
        }
        this.txtStartYear.setSelectedItem((Object)beginYearTemp);
        this.txtEndYear.setSelectedItem((Object)endYearTemp);
    }

    @Override
    protected void rdOrg_actionPerformed(ActionEvent e) throws Exception {
        this.setOrgCommentEnabled();
    }

    @Override
    protected void rdOrgMult_actionPerformed(ActionEvent e) throws Exception {
        this.setOrgCommentEnabled();
    }

    @Override
    protected void bizAdminOrg_dataChanged(DataChangeEvent e) throws Exception {
        this.setComboOrgLevel();
        this.rdDisplayAll.setSelected(true);
    }
}

