/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.org.client;

import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.util.IUIActionPostman;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.client.PositionPromptBox2;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.batchHandler.RequestContext;
import com.kingdee.eas.framework.batchHandler.client.UIActionPostman;
import com.kingdee.eas.hr.base.util.OrgStringUtil;
import com.kingdee.eas.hr.emp.client.EmployeeClientUtils;
import com.kingdee.eas.hr.org.client.AbstractPositionAnalysisFilterUI;
import com.kingdee.eas.hr.org.client.AdminByOrgRangePromptBox;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import org.apache.log4j.Logger;

public class PositionAnalysisFilterUI
extends AbstractPositionAnalysisFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(PositionAnalysisFilterUI.class);
    public static final String ADMIN_ITEM = "Admin_Item";
    public static final String POSITION_ITEM = "Position_Item";
    public static final String LEVEL_ITEM = "Level_Item";
    private String resClass = "com.kingdee.eas.hr.org.client.PositionResource.";
    private boolean firstLoad = true;

    public void onLoad() throws Exception {
        super.onLoad();
        if (this.firstLoad) {
            this.rdbOrg.setSelected(true);
        }
    }

    public boolean verify() {
        if (this.rdbOrg.isSelected()) {
            if (this.rdOrg.isSelected() && this.bizAdminOrg.getData() == null) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)(this.resClass + "NOT_SELECT_ORG")));
                return false;
            }
            if (this.rdOrgMult.isSelected() && this.bizAdminOrgMult.getData() == null) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)(this.resClass + "NOT_SELECT_ORG")));
                return false;
            }
        }
        if (this.rdbPosition.isSelected() && this.bizPosition.getData() == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)(this.resClass + "NOT_SELECT_POSITION")));
            return false;
        }
        return true;
    }

    public CustomerParams getCustomerParams() {
        CustomerParams params = new CustomerParams();
        if (this.rdbOrg.isSelected()) {
            if (this.rdOrgMult.isSelected()) {
                if (this.bizAdminOrgMult.getData() != null) {
                    params.addCustomerParam(this.bizAdminOrgMult.getName(), OrgStringUtil.orgInfoArr2String((Object[])((Object[])this.bizAdminOrgMult.getData())));
                }
                params.putBoolean("ShowVirtualOrg", this.chkShowVirtualOrg.isSelected());
            } else {
                params.addCustomerParam(ADMIN_ITEM, ((AdminOrgUnitInfo)this.bizAdminOrg.getData()).getId().toString());
                params.putInt(LEVEL_ITEM, 100);
                params.putBoolean("ShowVirtualOrg", this.chkShowVirtualOrg.isSelected());
                params.putBoolean(this.rdDisplaySelf.getName(), this.rdDisplaySelf.isSelected());
                params.putBoolean(this.rdDisplaySub.getName(), this.rdDisplaySub.isSelected());
                params.putBoolean(this.rdDisplayAll.getName(), this.rdDisplayAll.isSelected());
                if (this.rdDisplaySub.isSelected()) {
                    params.putInt(this.comboOrgLevel.getName(), this.comboOrgLevel.getSelectedIndex());
                } else if (this.rdDisplaySelf.isSelected()) {
                    params.putInt(this.comboOrgLevel.getName(), 0);
                } else {
                    params.putInt(this.comboOrgLevel.getName(), 100);
                }
            }
        } else {
            params.addCustomerParam(POSITION_ITEM, OrgStringUtil.positionInfoArr2String((Object[])((Object[])this.bizPosition.getData())));
            params.addCustomerParam(this.bizPosition.getName(), OrgStringUtil.positionInfoArr2String((Object[])((Object[])this.bizPosition.getData())));
            params.putBoolean("ShowVirtualOrg", true);
        }
        params.putBoolean(this.rdOrg.getName(), this.rdOrg.isSelected());
        params.putBoolean(this.rdOrgMult.getName(), this.rdOrgMult.isSelected());
        params.putBoolean("isShowInvalidPosition", this.chkShowInvalidPosition.isSelected());
        return params;
    }

    public void setCustomerParams(CustomerParams param) {
        this.clear();
        super.setCustomerParams(param);
        if (param == null) {
            return;
        }
        if (param.getBoolean(this.rdOrg.getName())) {
            this.rdOrg.setSelected(true);
        }
        if (param.getBoolean(this.rdOrgMult.getName())) {
            this.rdOrgMult.setSelected(true);
        }
        this.firstLoad = false;
        ObjectUuidPK pk = null;
        if (this.isPrepareExecQuery()) {
            try {
                this.prepareExecQuery(param).callHandler();
            }
            catch (Exception e) {
                ExceptionHandler.handle((Throwable)e);
            }
        }
        String orgIds = param.getCustomerParam(this.bizAdminOrgMult.getName());
        String positionIds = param.getCustomerParam(this.bizPosition.getName());
        if (param.getCustomerParam(ADMIN_ITEM) != null) {
            this.rdbOrg.setSelected(true);
            pk = new ObjectUuidPK(BOSUuid.read((String)param.getCustomerParam(ADMIN_ITEM)));
            AdminOrgUnitInfo adminInfo = null;
            try {
                adminInfo = AdminOrgUnitFactory.getRemoteInstance().getAdminOrgUnitInfo((IObjectPK)pk);
            }
            catch (Exception e) {
                ExceptionHandler.handle((Throwable)e);
            }
            this.bizAdminOrg.setData((Object)adminInfo);
        } else if (orgIds != null) {
            this.rdbOrg.setSelected(true);
            Object[] orgs = OrgStringUtil.string2OrgInfoArr((String)orgIds);
            this.bizAdminOrgMult.setData((Object)orgs);
        } else if (param.getCustomerParam(this.bizPosition.getName()) != null) {
            this.rdbPosition.setSelected(true);
            Object[] positions = OrgStringUtil.string2PositionInfoArr((String)positionIds);
            this.bizPosition.setData((Object)positions);
        }
        this.chkShowInvalidPosition.setSelected(param.getBoolean("isShowInvalidPosition"));
        this.chkShowVirtualOrg.setSelected(param.getBoolean("ShowVirtualOrg"));
        this.rdDisplaySelf.setSelected(param.getBoolean(this.rdDisplaySelf.getName()));
        this.rdDisplaySub.setSelected(param.getBoolean(this.rdDisplaySub.getName()));
        this.rdDisplayAll.setSelected(param.getBoolean(this.rdDisplayAll.getName()));
        int level = param.getInt(this.comboOrgLevel.getName());
        this.setComboOrgLevel();
        if (level != 100 && this.comboOrgLevel.getItemCount() > level) {
            this.comboOrgLevel.setSelectedIndex(level);
        }
        this.setOrgCommentEnabled();
    }

    public void clear() {
        super.clear();
        this.rdOrg.setSelected(true);
        this.bizAdminOrg.setData(null);
        this.bizAdminOrgMult.setData(null);
        this.bizPosition.setData(null);
        this.rdbOrg.setSelected(true);
        this.chkShowInvalidPosition.setSelected(false);
        this.chkShowVirtualOrg.setSelected(false);
        this.rdDisplayAll.setSelected(true);
        this.comboOrgLevel.removeAllItems();
        this.setOrgCommentEnabled();
    }

    private void setComboOrgLevel() {
        AdminOrgUnitInfo adminOrgUnit = (AdminOrgUnitInfo)this.bizAdminOrg.getValue();
        if (adminOrgUnit == null) {
            this.comboOrgLevel.removeAllItems();
        } else {
            try {
                EmployeeClientUtils.setComboBoxLevel((CoreBaseInfo)adminOrgUnit, (KDComboBox)this.comboOrgLevel);
            }
            catch (Exception e) {
                this.handUIException(e);
            }
        }
    }

    @Override
    public void initUIContentLayout() {
        super.initUIContentLayout();
        HashSet<String> hroSet = new HashSet<String>();
        String hroid = SysContext.getSysContext().getCurrentHRUnit().getId().toString();
        hroSet.add(hroid);
        this.bizAdminOrg.setCommitFormat("$number$");
        this.bizAdminOrg.setEditFormat("$number$");
        this.bizAdminOrg.setDisplayFormat("$name$");
        AdminByOrgRangePromptBox adminSelect = new AdminByOrgRangePromptBox((IUIObject)this);
        adminSelect.setHROFilter(hroSet);
        this.bizAdminOrg.setSelector((KDPromptSelector)adminSelect);
        this.bizAdminOrgMult.setEditable(false);
        AdminByOrgRangePromptBox aSelMult = new AdminByOrgRangePromptBox();
        aSelMult.setIsSingleSelect(false);
        aSelMult.setHROFilter(hroSet);
        aSelMult.setIncludeSealUp("FALSE");
        this.bizAdminOrgMult.setSelector((KDPromptSelector)aSelMult);
        Frame frame = (Frame)this.getUIContext().get("OwnerWindow");
        HashMap<String, Boolean> map = new HashMap<String, Boolean>();
        map.put("MULTI_SELECT", Boolean.TRUE);
        PositionPromptBox2 positionf7 = new PositionPromptBox2(frame, map);
        positionf7.setEnabledMultiSelection(true);
        positionf7.setHROFilter(true);
        positionf7.setUserAdminFilter("ADMIN_ORGRANGE");
        positionf7.setOnlyHRFilter(false);
        this.bizPosition.setSelector((KDPromptSelector)positionf7);
        this.bizPosition.setEnabledMultiSelection(true);
        this.bizPosition.setQueryInfo("com.kingdee.eas.basedata.org.app.PositionQuery");
        this.bizPosition.setCommitFormat("$number$");
        this.bizPosition.setEditFormat("$number$");
        this.bizPosition.setDisplayFormat("$name$");
        this.bizAdminOrg.setRequired(true);
        this.bizPosition.setRequired(true);
    }

    @Override
    protected void rdbOrg_itemStateChanged(ItemEvent e) throws Exception {
        this.bizAdminOrg.setEditable(false);
        this.bizPosition.setEnabled(false);
        this.bizPosition.setData(null);
        this.chkShowInvalidPosition.setEnabled(true);
        this.chkShowVirtualOrg.setEnabled(true);
        this.setOrgCommentEnabled();
    }

    @Override
    protected void rdbPosition_itemStateChanged(ItemEvent e) throws Exception {
        this.bizAdminOrg.setData(null);
        this.bizAdminOrgMult.setData(null);
        this.bizPosition.setEnabled(true);
        this.bizPosition.setEditable(false);
        this.setOrgCommentEnabled();
        this.chkShowInvalidPosition.setEnabled(false);
        this.chkShowVirtualOrg.setEnabled(false);
    }

    public IUIActionPostman prepareExecQuery(CustomerParams param) {
        IUIActionPostman handler = UIActionPostman.getInstance((IUIObject)this);
        RequestContext request = new RequestContext();
        request.setClassName(this.getUIHandlerClassName());
        request.setMethodName("_handleExecQuery");
        ObjectUuidPK adminItemPk = null;
        Object positionItemPk = null;
        if (param.getCustomerParam(ADMIN_ITEM) != null) {
            adminItemPk = new ObjectUuidPK(BOSUuid.read((String)param.getCustomerParam(ADMIN_ITEM)));
            request.put("adminItemPk", (Object)adminItemPk);
        }
        handler.setRequestContext((Serializable)request);
        return handler;
    }

    public boolean isPrepareExecQuery() {
        return true;
    }

    private void setOrgCommentEnabled() {
        boolean isRdOrgSelected = this.rdOrg.isSelected();
        boolean isRdOrgMultSelected = this.rdOrgMult.isSelected();
        boolean isRdbOrgSelected = this.rdbOrg.isSelected();
        this.bizAdminOrg.setEnabled(isRdbOrgSelected && isRdOrgSelected);
        this.bizAdminOrgMult.setEnabled(isRdbOrgSelected && isRdOrgMultSelected);
        this.rdOrg.setEnabled(isRdbOrgSelected);
        this.rdOrgMult.setEnabled(isRdbOrgSelected);
        boolean isAdminOrgEnable = this.bizAdminOrg.isEnabled();
        this.rdDisplayAll.setEnabled(isAdminOrgEnable);
        this.rdDisplaySelf.setEnabled(isAdminOrgEnable);
        this.rdDisplaySub.setEnabled(isAdminOrgEnable);
        this.comboOrgLevel.setEnabled(isAdminOrgEnable);
    }

    @Override
    protected void rdOrg_actionPerformed(ActionEvent e) throws Exception {
        this.setOrgCommentEnabled();
    }

    @Override
    protected void rdOrgMult_actionPerformed(ActionEvent e) throws Exception {
        this.setOrgCommentEnabled();
    }

    @Override
    protected void bizAdminOrg_dataChanged(DataChangeEvent e) throws Exception {
        this.setComboOrgLevel();
        this.rdDisplayAll.setSelected(true);
    }
}

