/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.openapi.common.mq;

import com.kingdee.bos.openapi.common.mq.ConnectionEntity;
import com.kingdee.bos.openapi.third.utils.OpenApiTools;
import com.rabbitmq.client.Connection;
import com.rabbitmq.client.ConnectionFactory;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import kd.isc.rabbitmq.thread.ThreadLifeCycleManager;
import org.apache.log4j.Logger;

public class RabbitMqConnectionFactory {
    private static Logger logger = Logger.getLogger((String)RabbitMqConnectionFactory.class.getName());
    private static Map<String, Connection> poolMap = new ConcurrentHashMap<String, Connection>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Connection getConnection(ConnectionEntity entity) {
        if (entity == null) {
            return null;
        }
        String serverKey = entity.toString();
        if (poolMap.containsKey(serverKey)) {
            return poolMap.get(serverKey);
        }
        Connection client = null;
        Class<RabbitMqConnectionFactory> clazz = RabbitMqConnectionFactory.class;
        synchronized (RabbitMqConnectionFactory.class) {
            if (poolMap.containsKey(serverKey)) {
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return poolMap.get(serverKey);
            }
            try {
                client = RabbitMqConnectionFactory.createConnection(entity);
                poolMap.put(serverKey, client);
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage());
                throw new RuntimeException(e);
            }
            return client;
        }
    }

    private static Connection createConnection(ConnectionEntity entity) {
        Connection connection = null;
        try {
            ConnectionFactory factory = new ConnectionFactory();
            factory.setUsername(entity.getUserName());
            factory.setPassword(entity.getPassword());
            factory.setHost(entity.getHost());
            factory.setPort(entity.getPort() == 0 ? 5672 : entity.getPort());
            if (!OpenApiTools.isEmpty(entity.getVhost())) {
                factory.setVirtualHost(entity.getVhost());
            }
            factory.setAutomaticRecoveryEnabled(true);
            factory.setConnectionTimeout(10000);
            factory.setTopologyRecoveryEnabled(true);
            ExecutorService es = RabbitMqConnectionFactory.getExecutorService();
            connection = factory.newConnection(es);
        }
        catch (Exception e) {
            logger.error((Object)"openapi mq error ", (Throwable)e);
            throw new RuntimeException(e.getMessage());
        }
        return connection;
    }

    private static ExecutorService getExecutorService() {
        ExecutorService es = Executors.newFixedThreadPool(10, new ThreadFactory(){
            private AtomicInteger atomicInteger = new AtomicInteger(0);

            @Override
            public Thread newThread(Runnable r) {
                return new Thread(r, "Openapi-MQ-rabbit-pool-" + this.atomicInteger.incrementAndGet());
            }
        });
        return ThreadLifeCycleManager.wrapExecutorService((ExecutorService)es);
    }
}

