/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.openapi.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.data.ColumnInfo;
import com.kingdee.bos.metadata.data.DataTableInfo;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.LogicalKeyInfo;
import com.kingdee.bos.metadata.entity.OwnPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.openapi.PrivacySyncData;
import com.kingdee.bos.openapi.app.AbstractPrivacyMappingControllerBean;
import com.kingdee.bos.openapi.app.PrivacyAsyncJobHandler;
import com.kingdee.bos.openapi.app.PrivacyMappingFactory;
import com.kingdee.bos.openapi.app.PrivacyMappingInfo;
import com.kingdee.bos.privacy.IPrivacyService;
import com.kingdee.bos.privacy.ParamData;
import com.kingdee.bos.privacy.PrivacyData;
import com.kingdee.bos.privacy.PrivacyPropertyInfo;
import com.kingdee.bos.privacy.PrivacyPropertyManager;
import com.kingdee.bos.service.job.IJobService;
import com.kingdee.bos.service.job.JobServiceFactory;
import com.kingdee.bos.service.job.core.IJobHandler;
import com.kingdee.bos.service.job.core.Job;
import com.kingdee.bos.service.job.core.JobInstanceConfig;
import com.kingdee.bos.service.job.core.JobManager;
import com.kingdee.bos.service.job.core.JobState;
import com.kingdee.bos.service.job.util.Ctx;
import com.kingdee.bos.sql.KSqlUtil;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class PrivacyMappingControllerBean
extends AbstractPrivacyMappingControllerBean {
    private static final int batchCount = 500;
    private static final Map<String, Integer> dbtypeCache = new ConcurrentHashMap<String, Integer>();

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void _execute(Context ctx, IObjectValue value) throws BOSException, EASBizException {
        boolean reverse;
        PrivacyMappingInfo info;
        block20: {
            List<Object> columns;
            info = (PrivacyMappingInfo)value;
            reverse = !info.isIsEncrypt();
            String bosType = info.getBosType();
            String field = info.getField();
            String tableName = info.getTableName();
            if ("NO_TYPE_".equals(bosType)) {
                columns = new ArrayList<String>();
                columns.add(field);
            } else {
                columns = this.getColumns(ctx, bosType, field);
            }
            String alertAddSql = "";
            String checkSql = "";
            String columnType = " clob ";
            if (info.isIsSimple()) {
                columnType = " varchar(4000) ";
            }
            for (int i = 0; i < columns.size(); ++i) {
                String column = (String)columns.get(i);
                String privacyField = ParamData.getPrivacyFieldSQLName((String)column);
                String hashField = ParamData.getHashFieldSQLName((String)column);
                alertAddSql = alertAddSql + "if not exists (select * from ksql_usercolumns where ksql_col_tabname='" + tableName + "' and ksql_col_name='" + privacyField + "')  alter table " + tableName + " add " + privacyField + columnType + ";";
                alertAddSql = alertAddSql + "if not exists (select * from ksql_usercolumns where ksql_col_tabname='" + tableName + "' and ksql_col_name='" + hashField + "')  alter table " + tableName + " add " + hashField + " varchar(50);";
                if (i != 0) continue;
                checkSql = "select count(*) from ksql_usercolumns where ksql_col_tabname='" + tableName + "' and ksql_col_name='" + privacyField + "'";
            }
            if (reverse) {
                IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)checkSql);
                try {
                    if (rs.next() && rs.getInt(1) == 0) {
                        return;
                    }
                    break block20;
                }
                catch (SQLException e) {
                    throw new BOSException((Throwable)e);
                }
            }
            DbUtil.execute((Context)ctx, (String)alertAddSql);
        }
        String privacyMappingId = info.getId().toString();
        String jobInstId = null;
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)"select top 1 FJobInstId from T_Privacy_JobInst where FPrivacyMappingId=? order by FCreateTime desc", (Object[])new Object[]{privacyMappingId});
        try {
            if (rs.next()) {
                jobInstId = rs.getString(1);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        boolean createNew = false;
        if (!StringUtils.isEmpty((String)jobInstId)) {
            IJobService jobService = JobServiceFactory.getLocalInstance((Context)ctx);
            JobState jobState = jobService.getState(jobInstId);
            if (JobState.Failed == jobState || JobState.Suspended == jobState) {
                DbUtil.execute((Context)ctx, (String)"update t_job_inst set ftitle=? where fjobinstid=?", (Object[])new Object[]{(reverse ? "\u89e3\u5bc6" : "\u52a0\u5bc6") + "[" + info.getName() + "][" + info.getFieldName() + "]\u5386\u53f2\u6570\u636e", jobInstId});
                if (JobState.Failed == jobState) {
                    jobService.restart(new String[]{jobInstId});
                } else {
                    jobService.resume(new String[]{jobInstId});
                }
            } else {
                if (null != jobState && JobState.Complete != jobState) throw new BOSException("\u52a0\u5bc6\u4efb\u52a1\u5df2\u7ecf\u5728\u961f\u5217\u4e2d\uff0c\u5f53\u524d\u72b6\u6001\u4e3a" + jobState + ",\u53bb\u540e\u53f0\u4e8b\u52a1\u76d1\u63a7\u754c\u9762\u67e5\u770b");
                createNew = true;
            }
        } else {
            createNew = true;
        }
        Timestamp now = new Timestamp(System.currentTimeMillis());
        if (createNew) {
            JobInstanceConfig dyn = new JobInstanceConfig((IJobHandler)new PrivacyAsyncJobHandler(privacyMappingId, reverse), true, true, 3);
            Job job = new Job(Ctx.toDispatchShadowContext((Context)ctx), (reverse ? "\u89e3\u5bc6" : "\u52a0\u5bc6") + "[" + info.getName() + "][" + info.getFieldName() + "]\u5386\u53f2\u6570\u636e", dyn, null);
            try {
                JobManager.instance().add(job);
            }
            catch (Exception e) {
                throw new BOSException("\u52a0\u5bc6\u4efb\u52a1\u5165\u961f\u5931\u8d25\uff0c", (Throwable)e);
            }
            DbUtil.execute((Context)ctx, (String)"insert into T_Privacy_JobInst (FJOBINSTID,FPRIVACYMAPPINGID,FISENCRYPT,FCREATETIME) values(?,?,?,?)", (Object[])new Object[]{job.getId(), privacyMappingId, reverse ? 0 : 1, now});
        }
        DbUtil.execute((Context)ctx, (String)"update T_Privacy_Mapping set fstate=?,fLastUpdateTime=? where fid=?", (Object[])new Object[]{reverse ? 2 : 5, now, privacyMappingId});
    }

    @Override
    protected void _syncHistory(Context ctx, String privacyMappingId) throws BOSException {
        try {
            String sql = " select fbostype,ffield,fsolutionId,fIsEncrypt,fIsSimple,ftableName,ffieldType from T_Privacy_Mapping where fid=? ";
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{privacyMappingId});
            if (rowSet.next()) {
                IRowSet rowSet2;
                String bosType = rowSet.getString("fbostype");
                String field = rowSet.getString("ffield");
                String solutionId = rowSet.getString("fsolutionId");
                String tableName = rowSet.getString("ftableName");
                boolean reverse = rowSet.getInt("fIsEncrypt") == 0;
                boolean isSimple = rowSet.getInt("fIsSimple") == 1;
                String ffieldType = rowSet.getString("ffieldType");
                PrivacySyncData privacySyncData = this.buildPrivacySyncData(ctx, bosType, tableName, field, isSimple, ffieldType, solutionId, reverse);
                List<String> columns = privacySyncData.getColumns();
                tableName = privacySyncData.getTableName();
                String alertAddSql = "";
                String columnType = " clob ";
                if (isSimple) {
                    columnType = " varchar(4000) ";
                }
                for (int i = 0; i < columns.size(); ++i) {
                    String column = columns.get(i);
                    String privacyField = ParamData.getPrivacyFieldSQLName((String)column);
                    String hashField = ParamData.getHashFieldSQLName((String)column);
                    alertAddSql = alertAddSql + "if not exists (select * from ksql_usercolumns where ksql_col_tabname='" + tableName + "' and ksql_col_name='" + privacyField + "')  alter table " + tableName + " add " + privacyField + columnType + ";";
                    alertAddSql = alertAddSql + "if not exists (select * from ksql_usercolumns where ksql_col_tabname='" + tableName + "' and ksql_col_name='" + hashField + "')  alter table " + tableName + " add " + hashField + " varchar(50);";
                }
                if (!reverse) {
                    DbUtil.execute((Context)ctx, (String)alertAddSql);
                }
                boolean continueSync = true;
                PrivacyMappingInfo info = new PrivacyMappingInfo();
                info.put("_data_", privacySyncData);
                while (continueSync) {
                    continueSync = PrivacyMappingFactory.getLocalInstance(ctx).syncData((IObjectValue)info);
                }
                sql = " update T_Privacy_Mapping set fstate=?,FLastUpdateTime=? where fid=? ";
                DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{reverse ? 1 : 4, new Timestamp(System.currentTimeMillis()), privacyMappingId});
                if (reverse && (rowSet2 = DbUtil.executeQuery((Context)ctx, (String)(sql = " select count(*) from T_Privacy_Mapping where fsolutionId=? and fstate<>?"), (Object[])new Object[]{solutionId, 1})).next() && rowSet2.getInt(1) == 0) {
                    this.clearEncryptKeyHis(ctx, solutionId);
                }
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    private void clearEncryptKeyHis(Context ctx, String solutionId) {
        try {
            String sql = " select Top 1 fCreateTime from T_Privacy_EncryptKeyHis where fsolutionId=? order by fCreateTime desc ";
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{solutionId});
            if (rs.next()) {
                Timestamp lastCreateTime = rs.getTimestamp(1);
                sql = " delete from T_Privacy_EncryptKeyHis where fsolutionId=? and fCreateTime<? ";
                DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{solutionId, lastCreateTime});
            }
        }
        catch (BOSException | SQLException e) {
            e.printStackTrace();
        }
    }

    @Override
    protected boolean _syncData(Context ctx, IObjectValue value) throws BOSException {
        boolean isNeedEmptyStringFilter;
        boolean needContinue;
        IPrivacyService ps;
        PrivacyPropertyInfo privacyPropertyInfo;
        List<String> columns;
        boolean reverse;
        String tableName;
        String pkColumn;
        HashSet<String> ignoreColumnSet;
        block21: {
            IRowSet rowSet;
            int dbType;
            PrivacySyncData privacySyncData = (PrivacySyncData)value.get("_data_");
            ignoreColumnSet = (HashSet<String>)value.get("_ignoreColumnSet_");
            if (ignoreColumnSet == null) {
                ignoreColumnSet = new HashSet<String>();
                value.put("_ignoreColumnSet_", ignoreColumnSet);
            }
            pkColumn = privacySyncData.getPkColumn();
            tableName = privacySyncData.getTableName();
            reverse = privacySyncData.isReverse();
            columns = privacySyncData.getColumns();
            privacyPropertyInfo = privacySyncData.getPrivacyPropertyInfo();
            ps = PrivacyPropertyManager.getPrivacyService((Context)ctx);
            needContinue = false;
            try {
                dbType = PrivacyMappingControllerBean.getDbType(ctx);
            }
            catch (SQLException e1) {
                throw new BOSException((Throwable)e1);
            }
            isNeedEmptyStringFilter = false;
            if (3 == dbType || 12 == dbType) {
                isNeedEmptyStringFilter = true;
            } else if (5 == dbType) {
                try {
                    rowSet = PrivacyMappingFactory.getLocalInstance(ctx).executeQueryNewTx("/*dialect*/select setting from pg_settings where name = 'empty_is_null'");
                    if (rowSet != null && rowSet.next()) {
                        isNeedEmptyStringFilter = "off".equals(rowSet.getString(1));
                        break block21;
                    }
                    isNeedEmptyStringFilter = true;
                }
                catch (Exception e) {
                    isNeedEmptyStringFilter = true;
                }
            } else if (11 == dbType) {
                try {
                    rowSet = PrivacyMappingFactory.getLocalInstance(ctx).executeQueryNewTx("/*dialect*/select t.VALUE from v$parameter t where t.NAME='COMPATIBLE_MODE'");
                    isNeedEmptyStringFilter = rowSet != null && rowSet.next() ? !"2".equals(rowSet.getString(1)) : true;
                }
                catch (Exception e) {
                    isNeedEmptyStringFilter = true;
                }
            }
        }
        for (int i = 0; i < columns.size(); ++i) {
            String column = columns.get(i);
            if (ignoreColumnSet.contains(column)) continue;
            StringBuilder selectsql = new StringBuilder();
            String privacyField = ParamData.getPrivacyFieldSQLName((String)column);
            String hashField = ParamData.getHashFieldSQLName((String)column);
            selectsql.append(" select top ").append(500).append(" ").append(pkColumn).append(",").append(reverse ? privacyField : column).append(" from ").append(tableName).append(" where ");
            if (privacyPropertyInfo.isString() && !reverse && isNeedEmptyStringFilter) {
                selectsql.append(column).append("!='' and ");
            }
            selectsql.append(reverse ? privacyField : column).append(" is not null ");
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)selectsql.toString());
            ArrayList<Object[]> paramsList = new ArrayList<Object[]>();
            try {
                while (rowSet.next()) {
                    Object[] params = new Object[4];
                    PrivacyData privacyData = new PrivacyData(privacyPropertyInfo);
                    if (reverse) {
                        String cipherText = rowSet.getString(2);
                        privacyData.setCipherText(cipherText);
                        ps.decrypt(ctx, privacyData);
                        params[0] = privacyData.getOriginalValue();
                        params[1] = null;
                        params[2] = null;
                    } else {
                        Object obj = rowSet.getObject(2);
                        privacyData.setOriginalValue(obj);
                        ps.encrypt(ctx, privacyData);
                        params[0] = privacyPropertyInfo.isString() ? "" : null;
                        params[1] = privacyData.getCipherText();
                        params[2] = privacyData.getHashCode();
                    }
                    String pkValue = rowSet.getString(1);
                    params[3] = pkValue;
                    paramsList.add(params);
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
            if (paramsList.size() > 0) {
                StringBuilder updateSql = new StringBuilder();
                updateSql.append("update ").append(tableName).append(" set ");
                updateSql.append(column).append("=?,").append(privacyField).append("=?,").append(hashField).append("=?").append(" where ").append(pkColumn).append("=?");
                DbUtil.executeBatch((Context)ctx, (String)updateSql.toString(), paramsList);
                needContinue = true;
                continue;
            }
            ignoreColumnSet.add(column);
        }
        return needContinue;
    }

    private static int getDbType(Context ctx) throws SQLException {
        Integer dbType;
        if (dbtypeCache.containsKey(ctx.getAIS())) {
            dbType = dbtypeCache.get(ctx.getAIS());
        } else {
            try (Connection conn = EJBFactory.getConnection((Context)ctx);){
                dbType = KSqlUtil.getDbType((Connection)conn);
            }
            dbtypeCache.put(ctx.getAIS(), dbType);
        }
        return dbType;
    }

    private PrivacySyncData buildPrivacySyncData(Context ctx, String bosType, String tableName, String field, boolean isSimple, String dataType, String solutionId, boolean reverse) throws BOSException {
        PrivacySyncData privacySyncData = new PrivacySyncData();
        privacySyncData.setReverse(reverse);
        ArrayList<String> columns = new ArrayList<String>();
        if ("NO_TYPE_".equals(bosType)) {
            privacySyncData.setTableName(tableName);
            columns.add(field);
            privacySyncData.setPkColumn("fid");
            privacySyncData.setPrivacyPropertyInfo(new PrivacyPropertyInfo(solutionId, null, isSimple, dataType));
        } else {
            ColumnInfo columnInfo;
            PropertyInfo prop;
            PropertyCollection props;
            IMetaDataLoader loader = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
            EntityObjectInfo entity = loader.getEntity(BOSObjectType.create((String)bosType));
            PropertyInfo propInfo = entity.getPropertyByNameRuntime(field);
            if (propInfo == null) {
                propInfo = entity.getInheritedPropertyByColName(field);
            }
            PrivacyPropertyInfo privacyPropertyInfo = null;
            if (propInfo instanceof OwnPropertyInfo) {
                OwnPropertyInfo ownProp = (OwnPropertyInfo)propInfo;
                privacyPropertyInfo = new PrivacyPropertyInfo(solutionId, ownProp, isSimple, dataType);
                privacySyncData.setPrivacyPropertyInfo(privacyPropertyInfo);
                DataTableInfo table = entity.getTable();
                if (table != null) {
                    privacySyncData.setTableName(table.getName());
                }
            } else {
                throw new BOSException("\u5b9e\u4f53[" + bosType + "]\u7684\u5b57\u6bb5[" + field + "]privacyPropertyInfo\u4e3a\u7a7a");
            }
            OwnPropertyInfo propertyInfo = privacyPropertyInfo.getPropertyInfo();
            String column = propertyInfo.getMappingField().getName();
            if (propertyInfo.isMultilingual()) {
                String[] postfix = PrivacyPropertyManager.getLanguagePostfix((Context)ctx);
                for (int j = 0; j < postfix.length; ++j) {
                    columns.add(column + postfix[j]);
                }
            } else {
                columns.add(column);
            }
            if (columns.size() == 0) {
                throw new BOSException("\u5b9e\u4f53[" + bosType + "]\u7684\u5b57\u6bb5[" + field + "]\u5bf9\u5e94Table\u5143\u6570\u636e\u7684\u5217\u4e3a\u7a7a");
            }
            LogicalKeyInfo logicalKey = entity.getLogicalKey();
            if (logicalKey != null && (props = logicalKey.getKeyPropertys()) != null && props.size() > 0 && (prop = props.get(0)) != null && prop instanceof OwnPropertyInfo && (columnInfo = ((OwnPropertyInfo)prop).getMappingField()) != null) {
                privacySyncData.setPkColumn(columnInfo.getName());
            }
        }
        privacySyncData.setColumns(columns);
        if (privacySyncData.getPkColumn() == null) {
            throw new BOSException("\u52a0\u5bc6\u5b57\u6bb5\u8868\u5fc5\u987b\u5305\u542b\u4e3b\u952e\uff0c\u5426\u8005\u540c\u6b65\u5386\u53f2\u6570\u636e\u65e0\u6cd5\u8fdb\u884c");
        }
        return privacySyncData;
    }

    private List<String> getColumns(Context ctx, String bosType, String field) throws BOSException {
        ArrayList<String> columns = new ArrayList<String>();
        IMetaDataLoader loader = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
        EntityObjectInfo entity = loader.getEntity(BOSObjectType.create((String)bosType));
        PropertyInfo propInfo = entity.getPropertyByNameRuntime(field);
        if (propInfo == null) {
            propInfo = entity.getInheritedPropertyByColName(field);
        }
        if (propInfo instanceof OwnPropertyInfo) {
            OwnPropertyInfo propertyInfo = (OwnPropertyInfo)propInfo;
            String column = propertyInfo.getMappingField().getName();
            if (propertyInfo.isMultilingual()) {
                String[] postfix = PrivacyPropertyManager.getLanguagePostfix((Context)ctx);
                for (int j = 0; j < postfix.length; ++j) {
                    columns.add(column + postfix[j]);
                }
            } else {
                columns.add(column);
            }
        }
        if (columns.size() == 0) {
            throw new BOSException("\u5b9e\u4f53[" + bosType + "]\u7684\u5b57\u6bb5[" + field + "]\u5bf9\u5e94Table\u5143\u6570\u636e\u7684\u5217\u4e3a\u7a7a");
        }
        return columns;
    }

    @Override
    protected IRowSet _executeQueryNewTx(Context ctx, String sql) throws BOSException {
        try {
            return DbUtil.executeQuery((Context)ctx, (String)sql);
        }
        catch (Throwable t) {
            return null;
        }
    }
}

