/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.openapi.app;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.openapi.IPrivacySolution;
import com.kingdee.bos.openapi.PrivacySolutionFactory;
import com.kingdee.bos.openapi.PrivacySolutionInfo;
import com.kingdee.bos.openapi.app.AbstractPrivacySolutionControllerBean;
import com.kingdee.bos.openapi.app.PrivacyCacheSynchronizer;
import com.kingdee.bos.openapi.app.PrivacyItem;
import com.kingdee.bos.openapi.app.PrivacyMappingCollection;
import com.kingdee.bos.openapi.app.PrivacyMappingFactory;
import com.kingdee.bos.openapi.app.PrivacyMappingInfo;
import com.kingdee.bos.openapi.app.PrivacyOperateUtils;
import com.kingdee.bos.privacy.encrypt.ComposeEncryptor;
import com.kingdee.bos.privacy.encrypt.EncryptUtils;
import com.kingdee.bos.privacy.encrypt.EncryptorType;
import com.kingdee.bos.privacy.encrypt.ICustomEncryptor;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class PrivacySolutionControllerBean
extends AbstractPrivacySolutionControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.bos.openapi.app.PrivacySolutionControllerBean");
    private static final String temp = "559da6692dee986703ec2c617803edcb21b456fd8c861470aa1ca2ae5459d82c";
    private static final String temp2 = "8b83e617c6018da39f9ebd68dd63dea3";

    /*
     * WARNING - void declaration
     */
    @Override
    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        IObjectPK appLogId;
        String data = (String)model.get("_data_");
        IObjectPK pk = null;
        JSONObject jsonObject = JSON.parseObject((String)data);
        Timestamp now = new Timestamp(System.currentTimeMillis());
        CtrlUnitInfo cu = ContextUtil.getCurrentCtrlUnit((Context)ctx);
        UserInfo curUser = ContextUtil.getCurrentUserInfo((Context)ctx);
        String id = jsonObject.getString("id");
        PrivacySolutionInfo info = new PrivacySolutionInfo();
        String name = jsonObject.getString("name");
        String number = jsonObject.getString("number");
        String description = jsonObject.getString("description");
        boolean isDefault = jsonObject.getBooleanValue("isDefault");
        if (!isDefault) {
            info.setName(name);
            info.setNumber(number);
            info.setDescription(description);
        }
        info.setLastUpdateUser(curUser);
        info.setLastUpdateTime(now);
        JSONArray entry = jsonObject.getJSONArray("entry");
        HashMap<String, PrivacyItem> newData = new HashMap<String, PrivacyItem>();
        for (int i = 0; i < entry.size(); ++i) {
            JSONObject item = entry.getJSONObject(i);
            String privacyMappingId = item.getString("id");
            String obj = item.getString("isEncrypt");
            String fieldName = item.getString("fieldName");
            String billName = item.getString("name");
            int n = 0;
            if ("true".equalsIgnoreCase(obj) || "1".equalsIgnoreCase(obj)) {
                n = 1;
            }
            newData.put(privacyMappingId, new PrivacyItem(billName, privacyMappingId, fieldName, n));
        }
        IPrivacySolution privacySolution = PrivacySolutionFactory.getLocalInstance(ctx);
        FilterInfo filterInfo = new FilterInfo();
        StringBuilder logStr = new StringBuilder();
        if (StringUtils.isEmpty((String)id)) {
            filterInfo.getFilterItems().add(new FilterItemInfo("number", (Object)number));
            if (!isDefault && privacySolution.exists(filterInfo)) {
                throw new BOSException("\u7f16\u7801\u5df2\u5b58\u5728");
            }
            logStr.append("\u65b9\u6848\u540d\u79f0\uff1a").append(name).append("\n");
            info.setCreator(curUser);
            info.setCreateTime(now);
            info.setCU(cu);
            pk = super._addnew(ctx, (IObjectValue)info);
            String solutionId = pk.toString();
            ArrayList<Object[]> paramsList = new ArrayList<Object[]>();
            for (Map.Entry entry2 : newData.entrySet()) {
                PrivacyItem item = (PrivacyItem)entry2.getValue();
                paramsList.add(new Object[]{item.isEncrypt, solutionId, now, item.id});
                logStr.append("\u6dfb\u52a0").append(item.billName).append("\u7684").append(item.name).append("\u5b57\u6bb5\u4e3a").append(item.isEncrypt == 1 ? "\u52a0\u5bc6" : "\u672a\u52a0\u5bc6").append("\n");
            }
            appLogId = PrivacyOperateUtils.beginAdd(ctx, logStr.toString());
            if (paramsList.size() > 0) {
                String sql = " update T_Privacy_Mapping set fisEncrypt=?,fsolutionId=?,FLastUpdateTime=? where fid=? ";
                DbUtil.executeBatch((Context)ctx, (String)sql, paramsList);
            }
        } else {
            void var24_29;
            filterInfo.getFilterItems().add(new FilterItemInfo("number", (Object)number));
            filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)id, CompareType.NOTEQUALS));
            filterInfo.setMaskString("#0 and #1");
            if (!isDefault && privacySolution.exists(filterInfo)) {
                throw new BOSException("\u7f16\u7801\u5df2\u5b58\u5728");
            }
            SelectorItemCollection selectors = new SelectorItemCollection();
            selectors.add("id");
            selectors.add("name");
            selectors.add("number");
            selectors.add("description");
            PrivacySolutionInfo privacySolutionInfo = privacySolution.getPrivacySolutionInfo((IObjectPK)new ObjectUuidPK(id), selectors);
            String label1 = "\u65b9\u6848\u540d\u79f0\uff1a" + name;
            String string = "";
            String label3 = "";
            if (!isDefault) {
                if (!privacySolutionInfo.getName().equals(name)) {
                    label1 = "\u4fee\u6539\u65b9\u6848" + privacySolutionInfo.getName() + "\u4e3a" + name;
                }
                if (!privacySolutionInfo.getNumber().equals(number)) {
                    String string2 = "\uff0c\u4fee\u6539\u65b9\u6848\u7f16\u7801\u4e3a" + number;
                }
                if (privacySolutionInfo.getDescription() != null && !privacySolutionInfo.getDescription().equals(description)) {
                    label3 = "\uff0c\u4fee\u6539\u65b9\u6848\u63cf\u8ff0\u4e3a" + description;
                }
            }
            logStr.append(label1).append((String)var24_29).append(label3).append("\n");
            pk = new ObjectUuidPK(id);
            info.setId(BOSUuid.read((String)id));
            String sql = " select fid,fname,fisEncrypt,ffieldName,fstate from T_Privacy_Mapping where fsolutionId=?";
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{id});
            HashMap<String, PrivacyItem> srcData = new HashMap<String, PrivacyItem>();
            try {
                while (rs.next()) {
                    String privacyMappingId = rs.getString("fid");
                    String billName = rs.getString("fname");
                    int isEncrypt = rs.getInt("fisEncrypt");
                    String fieldName = rs.getString("ffieldName");
                    int state = rs.getInt("fstate");
                    srcData.put(privacyMappingId, new PrivacyItem(billName, privacyMappingId, fieldName, isEncrypt, state));
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
            ArrayList<Object[]> deleteList = new ArrayList<Object[]>();
            ArrayList<Object[]> updateList = new ArrayList<Object[]>();
            for (Map.Entry entrySet : newData.entrySet()) {
                PrivacyItem newItem = (PrivacyItem)entrySet.getValue();
                PrivacyItem srcItem = (PrivacyItem)srcData.get(newItem.id);
                if (srcItem == null) {
                    logStr.append("\u6dfb\u52a0").append(newItem.billName).append("\u7684").append(newItem.name).append("\u5b57\u6bb5\u4e3a").append(newItem.isEncrypt == 1 ? "\u52a0\u5bc6" : "\u672a\u52a0\u5bc6").append("\n");
                    updateList.add(new Object[]{newItem.isEncrypt, id, now, newItem.id});
                    continue;
                }
                if (newItem.isEncrypt != srcItem.isEncrypt) {
                    logStr.append("\u4fee\u6539").append(newItem.billName).append("\u7684").append(newItem.name).append("\u5b57\u6bb5\u4e3a").append(newItem.isEncrypt == 1 ? "\u52a0\u5bc6" : "\u672a\u52a0\u5bc6").append("\n");
                    updateList.add(new Object[]{newItem.isEncrypt, id, now, newItem.id});
                }
                srcData.remove(newItem.id);
            }
            for (Map.Entry entrySet : srcData.entrySet()) {
                PrivacyItem srcItem = (PrivacyItem)entrySet.getValue();
                if (srcItem.state != 1) continue;
                logStr.append("\u5220\u9664").append(srcItem.billName).append("\u7684").append(srcItem.name).append("\u5b57\u6bb5\n");
                deleteList.add(new Object[]{null, now, srcItem.id});
            }
            appLogId = PrivacyOperateUtils.beginModify(ctx, logStr.toString());
            this.update(ctx, pk, info);
            if (updateList.size() > 0) {
                sql = " update T_Privacy_Mapping set fisEncrypt=?,fsolutionId=?,FLastUpdateTime=? where fid=? ";
                DbUtil.executeBatch((Context)ctx, (String)sql, updateList);
            }
            if (deleteList.size() > 0) {
                sql = " update T_Privacy_Mapping set fsolutionId=?,FLastUpdateTime=? where fid=? ";
                DbUtil.executeBatch((Context)ctx, (String)sql, deleteList);
            }
        }
        this.checkEncryptKey(ctx, pk.toString());
        PrivacyOperateUtils.end(ctx, appLogId);
        return pk;
    }

    @Override
    protected void _updateEncryptKey(Context ctx, String solutionIds) throws BOSException {
        this.updateEncryptKeyInner(ctx, solutionIds, true);
    }

    @Override
    protected void _updateEncryptor(Context ctx, int encryptType, String implClazz) throws BOSException {
        if (encryptType == EncryptorType.CUSTOM.getType()) {
            ComposeEncryptor.checkCustomEncryptorImpl((String)implClazz);
        } else {
            implClazz = null;
            EncryptUtils.generateKey((Context)ctx, (EncryptorType)EncryptorType.getEncryptorType((int)encryptType));
        }
        String sql = "insert into T_Privacy_Encryptor(FType,FName,FImplClazz,FCreateTime) values(?,?,?,?)";
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{encryptType, EncryptorType.getEncryptorType((int)encryptType).name(), implClazz, new Timestamp(System.currentTimeMillis())});
        sql = "select distinct(FSOLUTIONID) from T_Privacy_EncryptKeyHis where FENCRYPTTYPE=?";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{encryptType});
        StringBuilder solutionIds = new StringBuilder();
        try {
            while (rs.next()) {
                String solutionId = rs.getString(1);
                solutionIds.append(solutionId).append(";");
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        this.updateEncryptKeyInner(ctx, solutionIds.toString(), false);
    }

    @Override
    protected void _execute(Context ctx, String solutionId) throws BOSException {
        if (!StringUtils.isEmpty((String)solutionId)) {
            this.checkEncryptKey(ctx, solutionId);
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("solutionId", (Object)solutionId));
            this._execute(ctx, filterInfo);
        }
    }

    @Override
    protected void _execute(Context ctx, FilterInfo filter) throws BOSException {
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        SelectorItemCollection selectors = new SelectorItemCollection();
        selectors.add("id");
        selectors.add("name");
        selectors.add("tableName");
        selectors.add("bosType");
        selectors.add("field");
        selectors.add("fieldName");
        selectors.add("state");
        selectors.add("isEncrypt");
        selectors.add("isSimple");
        selectors.add("solutionId");
        entityViewInfo.setSelector(selectors);
        entityViewInfo.setFilter(filter);
        PrivacyMappingCollection collection = PrivacyMappingFactory.getLocalInstance(ctx).getPrivacyMappingCollection(entityViewInfo);
        int successNum = 0;
        StringBuilder errorMessage = new StringBuilder();
        for (int i = 0; i < collection.size(); ++i) {
            PrivacyMappingInfo privacyMappingInfo = collection.get(i);
            try {
                PrivacyMappingFactory.getLocalInstance(ctx).execute((IObjectValue)privacyMappingInfo);
                ++successNum;
                continue;
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                errorMessage.append(privacyMappingInfo.getName() + "\u7684" + privacyMappingInfo.getFieldName()).append("\u5b57\u6bb5\u6570\u636e\u5904\u7406\u6267\u884c\u5931\u8d25\n");
            }
        }
        if (successNum > 0) {
            PrivacyCacheSynchronizer.clearAllServerCache(ctx);
        }
        if (errorMessage.length() > 0) {
            throw new BOSException(errorMessage.toString());
        }
    }

    @Override
    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        try {
            String solutionId = pk.toString();
            String sql = " select count(*) from T_Privacy_Solution where FId=? and FIsDefault=?";
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{solutionId, 1});
            if (rs.next() && rs.getInt(1) > 0) {
                Locale locale = ctx.getLocale();
                if (locale == null || locale.toString().equals("l2")) {
                    throw new BOSException("\u6807\u51c6\u65b9\u6848\u4e0d\u80fd\u5220\u9664");
                }
                if (locale.toString().equals("l1")) {
                    throw new BOSException("cannot delete the tandard scheme");
                }
                throw new BOSException("\u6a19\u51c6\u65b9\u6848\u4e0d\u80fd\u522a\u9664");
            }
            sql = " select count(*) from T_Privacy_Mapping where FSolutionId=? and FState !=? ";
            rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{solutionId, 1});
            if (rs.next()) {
                if (rs.getInt(1) > 0) {
                    Locale locale = ctx.getLocale();
                    if (locale == null || locale.toString().equals("l2")) {
                        throw new BOSException("\u65b9\u6848\u4e2d\u5b58\u5728\u5df2\u52a0\u5bc6\u7684\u5b57\u6bb5\u4e0d\u80fd\u5220\u9664");
                    }
                    if (locale.toString().equals("l1")) {
                        throw new BOSException("Encrypted fields that exist in the schema cannot be deleted");
                    }
                    throw new BOSException("\u65b9\u6848\u4e2d\u5b58\u5728\u5df2\u52a0\u5bc6\u7684\u5b57\u6bb5\u4e0d\u80fd\u522a\u9664");
                }
                sql = " update T_Privacy_Mapping set FSolutionId=? where FSolutionId=? ";
                DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{null, solutionId});
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        super._delete(ctx, pk);
    }

    private void checkEncryptKey(Context ctx, String solutionId) throws BOSException {
        try {
            int count;
            String sql = "select count(*) from  T_Privacy_EncryptKeyHis where FSolutionId=? ";
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{solutionId});
            if (rs.next() && (count = rs.getInt(1)) == 0) {
                this.updateEncryptKeyInner(ctx, solutionId, false);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    private void updateEncryptKeyInner(Context ctx, String solutionIds, boolean check) throws BOSException {
        try {
            String[] arr;
            if (StringUtils.isEmpty((String)solutionIds)) {
                ArrayList<String> list = new ArrayList<String>();
                IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)"select fid from T_Privacy_Solution ");
                while (rs.next()) {
                    String solutionId = rs.getString("fid");
                    list.add(solutionId);
                }
                arr = list.toArray(new String[0]);
            } else {
                arr = solutionIds.split(";");
            }
            if (arr.length > 0) {
                String sql;
                ArrayList<Object[]> paramList = new ArrayList<Object[]>();
                ArrayList<Object[]> paramList2 = new ArrayList<Object[]>();
                Timestamp now = new Timestamp(System.currentTimeMillis());
                EncryptorType encryptorType = EncryptUtils.getRecentEncryptorType((Context)ctx);
                int month = 3;
                for (String solutionId : arr) {
                    Timestamp temp;
                    IRowSet rs;
                    if (check && (rs = DbUtil.executeQuery((Context)ctx, (String)(sql = " select count(*) from T_Privacy_Solution where FLastUpdateKeyTime>? and fid=?"), (Object[])new Object[]{temp = new Timestamp(now.getTime() - (long)(month * 30 * 24) * 3600000L), solutionId})).next() && rs.getInt(1) > 0) {
                        Locale locale = ctx.getLocale();
                        if (locale == null || locale.toString().equals("l2")) {
                            throw new BOSException("\u5bc6\u94a5\u66f4\u65b0\u5468\u671f\u81f3\u5c11\u4e3a" + month + "\u4e2a\u6708");
                        }
                        if (locale.toString().equals("l1")) {
                            throw new BOSException("The key renewal cycle is at least " + month + " months");
                        }
                        throw new BOSException("\u5bc6\u9470\u66f4\u65b0\u5468\u671f\u81f3\u5c11\u7232" + month + "\u500b\u6708");
                    }
                    String encryptKey = EncryptUtils.generateKey((Context)ctx, (EncryptorType)encryptorType);
                    if (encryptorType == EncryptorType.CUSTOM) {
                        ICustomEncryptor customEncryptor = ComposeEncryptor.getCustomEncryptor((Context)ctx);
                        customEncryptor.saveKey(ctx, solutionId, encryptKey);
                        encryptKey = "custom";
                    }
                    Object[] params = new Object[]{solutionId, encryptorType.getType(), encryptKey, now};
                    paramList.add(params);
                    params = new Object[]{now, solutionId};
                    paramList2.add(params);
                }
                sql = "insert into T_Privacy_EncryptKeyHis(FSolutionId,FEncryptType,FEncryptKey,FCreateTime) values(?,?,?,?)";
                DbUtil.executeBatch((Context)ctx, (String)sql, paramList);
                sql = "update T_Privacy_Solution set FLastUpdateKeyTime=? where fid=?";
                DbUtil.executeBatch((Context)ctx, (String)sql, paramList2);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }
}

