/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.openapi.app.core.cache.impl;

import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.RemoteBOSObjectFactory;
import com.kingdee.bos.framework.session.ILoginModule;
import com.kingdee.bos.framework.session.LoginContext;
import com.kingdee.bos.framework.session.LoginModuleFactory;
import com.kingdee.bos.framework.session.LoginType;
import com.kingdee.bos.framework.session.SessionInfo;
import com.kingdee.bos.framework.session.SessionManager;
import com.kingdee.bos.openapi.app.core.OpenApiConstant;
import com.kingdee.bos.openapi.app.core.cache.IORMRPCSessionCache;
import com.kingdee.bos.openapi.app.core.limit.AbstractLimitInterceptor;
import com.kingdee.bos.openapi.app.core.limit.LimitInterceptorFactory;
import com.kingdee.bos.openapi.common.bo.ResultInfo;
import com.kingdee.bos.openapi.util.AES;
import com.kingdee.bos.openapi.util.MD5;
import com.kingdee.bos.orm.IORMModel;
import com.kingdee.bos.orm.ORMCoreException;
import com.kingdee.bos.orm.impl.server.ORMRPConfig;
import com.kingdee.bos.rpc.ce.RPCConnectException;
import com.kingdee.util.StringUtils;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.log4j.Logger;

public class ORMRPCSessionCache
implements IORMRPCSessionCache {
    private static final Logger logger = Logger.getLogger(ORMRPCSessionCache.class);
    private static Map<String, String> cache = new ConcurrentHashMap<String, String>();
    public static ThreadLocal<Context> currentContext = new ThreadLocal();
    public static final String PREFIX_SESSIONID_APPID = "%jjz%";

    public static Context getContext() {
        return currentContext.get();
    }

    public static void setContext(Context ctx) {
        currentContext.set(ctx);
    }

    @Override
    public String _getTokenId(String user, String password, String dataCenter, String language, String solution, String userAuthPattern, String clientIp, String appid, String isolation) throws BOSException {
        String sessionId = this.innerLogin(user, password, dataCenter, language, solution, userAuthPattern, clientIp, appid, isolation);
        return ORMRPCSessionCache.getToken(sessionId, appid);
    }

    @Override
    public Context _getContextBySession(String sessionId) throws BOSException {
        Context context = null;
        SessionInfo sessionInfo = SessionManager.getInstance().getSession(sessionId);
        if (sessionInfo == null || sessionInfo.getContext() == null) {
            return null;
        }
        context = sessionInfo.getContext();
        if (StringUtils.isEmpty((String)context.getClientHostIP())) {
            context.setClientHostIP("127.0.0.1");
        }
        return context;
    }

    @Override
    public Context _getContextByToken(String tokenId) throws BOSException {
        String sessionId = ORMRPCSessionCache.getSessionId(tokenId);
        return this._getContextBySession(sessionId);
    }

    @Override
    public Context _login(String user, String password, String dataCenter, String language, String solution, String userAuthPattern, String clientIp, String appid, String isolation) throws BOSException {
        String sessionId = this.innerLogin(user, password, dataCenter, language, solution, userAuthPattern, clientIp, appid, isolation);
        return this._getContextBySession(sessionId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String innerLogin(String user, String password, String dataCenter, String language, String solution, String userAuthPattern, String clientIp, String appid, String isolation) throws BOSException {
        String user_key;
        String sessionId = null;
        if (StringUtils.isEmpty((String)solution)) {
            solution = "eas";
        }
        if (StringUtils.isEmpty((String)(sessionId = cache.get(user_key = ORMRPCSessionCache.getUserkey(user, password, dataCenter, language, solution, userAuthPattern, appid, isolation)))) || SessionManager.getInstance().getSession(sessionId) == null || SessionManager.getInstance().getSession(sessionId).getContext() == null) {
            Map<String, String> map = cache;
            synchronized (map) {
                sessionId = cache.get(user_key);
                if (StringUtils.isEmpty((String)sessionId) || SessionManager.getInstance().getSession(sessionId) == null || SessionManager.getInstance().getSession(sessionId).getContext() == null) {
                    sessionId = this.relogin(user, password, dataCenter, language, solution, userAuthPattern, clientIp, appid, isolation);
                }
            }
        }
        return sessionId;
    }

    private String relogin(String user, String password, String dataCenter, String language, String solution, String userAuthPattern, String clientIp, String appid, String isolation) throws BOSException {
        SessionInfo sessionInfo;
        String user_key = null;
        user_key = "BaseTrdLtpaToken".equals(userAuthPattern) ? ORMRPCSessionCache.getUserkey(user, userAuthPattern, dataCenter, language, solution, userAuthPattern, appid, isolation) : ORMRPCSessionCache.getUserkey(user, password, dataCenter, language, solution, userAuthPattern, appid, isolation);
        if (clientIp == null) {
            clientIp = "127.0.0.1";
        }
        String sessionId = cache.get(user_key);
        String loginUrl = ORMRPConfig.getRPCListeningURL((boolean)false);
        if (!StringUtils.isEmpty((String)sessionId) && (sessionInfo = SessionManager.getInstance().getSession(sessionId)) != null && sessionInfo.getContext() != null) {
            return sessionId;
        }
        try {
            ILoginModule loginModule = LoginModuleFactory.getLocalInstance(null);
            Locale locale = new Locale(language);
            LoginContext ctx = new LoginContext(user, password, solution, dataCenter, locale, clientIp, null);
            ctx.setLoginType(LoginType.OPENAPI);
            ctx.put("SwitchToNewLoginFlow", (Object)"true");
            ctx.put("ClientIP", (Object)clientIp);
            if (userAuthPattern == null) {
                userAuthPattern = "BaseDB";
            }
            ctx.put("UserAuthPattern", (Object)userAuthPattern);
            try {
                Context cttc = loginModule.fullLogin(ctx);
                sessionId = cttc.getContextID();
            }
            catch (RPCConnectException rpce) {
                logger.error((Object)rpce);
                RemoteBOSObjectFactory.getInstance((String)loginUrl).clearSession();
                sessionId = loginModule.login(ctx);
            }
            cache.put(user_key, sessionId);
        }
        catch (Exception e) {
            JSONObject obj = new JSONObject();
            obj.put("user", (Object)user);
            obj.put("password", (Object)password);
            obj.put("dataCenter", (Object)dataCenter);
            obj.put("solution", (Object)solution);
            logger.error((Object)"openapi login error.", (Throwable)e);
            logger.error((Object)obj.toJSONString());
            throw new BOSException((Throwable)e);
        }
        return sessionId;
    }

    private static String getToken(String sessionId, String appid) {
        if (appid == null) {
            appid = "";
        }
        String str = sessionId + PREFIX_SESSIONID_APPID + appid;
        String token = null;
        try {
            token = AES.encryptToString(str, OpenApiConstant.getEntryKey(null));
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        return token;
    }

    private static String getSessionId(String token) {
        String sessionId = null;
        if (!StringUtils.isEmpty((String)token)) {
            try {
                String str = AES.decryptToString(token, OpenApiConstant.getEntryKey(null));
                if (!StringUtils.isEmpty((String)str)) {
                    String[] strs = str.split(PREFIX_SESSIONID_APPID);
                    sessionId = strs[0];
                }
                return sessionId;
            }
            catch (Exception e) {
                logger.error((Object)e);
                return "";
            }
        }
        return "";
    }

    @Override
    public String getAppidByToken(String token) throws BOSException {
        String sessionId = null;
        if (!StringUtils.isEmpty((String)token)) {
            try {
                String[] strs;
                String str = AES.decryptToString(token, OpenApiConstant.getEntryKey(null));
                if (!StringUtils.isEmpty((String)str) && (strs = str.split(PREFIX_SESSIONID_APPID)).length == 2) {
                    sessionId = strs[1];
                }
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
        }
        return sessionId;
    }

    private static String getUserkey(String user, String password, String dataCenter, String language, String solution, String userAuthPattern, String appid, String isolation) {
        String user_key = "";
        try {
            user_key = MD5.code(user + password + dataCenter + language + solution + userAuthPattern + appid + isolation);
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        return user_key;
    }

    @Override
    public ResultInfo limit(String key, double limiterQPS) throws BOSException {
        AbstractLimitInterceptor interceptor = LimitInterceptorFactory.getInterceptor(key, limiterQPS);
        return interceptor.process();
    }

    public IORMModel queryInterface(Class type) throws ORMCoreException {
        return null;
    }
}

