/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.ats.bizmanage.MessageConfirm.Util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.HROrgUnitInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.hr.ats.AtsHolidayFileHisInfo;
import com.kingdee.eas.hr.ats.AttendanceFileFactory;
import com.kingdee.eas.hr.ats.AttendanceFileHISInfo;
import com.kingdee.eas.hr.ats.AttendanceFileInfo;
import com.kingdee.eas.hr.ats.bizmanage.MessageConfirm.impl.AtsPosAddMsgDeal;
import com.kingdee.eas.hr.ats.lightapp.util.NumberCodeRule;
import com.kingdee.eas.hr.ats.util.AtsDateUtils;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.base.bizmanage.AdminOrgBURelationCollection;
import com.kingdee.shr.base.bizmanage.AdminOrgBURelationFactory;
import com.kingdee.shr.base.bizmanage.AdminOrgBURelationInfo;
import com.kingdee.shr.base.bizmanage.BizManageState;
import com.kingdee.shr.base.bizmanage.HRBizDefineTypeEnum;
import com.kingdee.shr.base.bizmanage.PersonBURelaConfirmFactory;
import com.kingdee.shr.base.bizmanage.PersonBURelaConfirmInfo;
import com.kingdee.shr.base.bizmanage.PersonBURelationFactory;
import com.kingdee.shr.base.bizmanage.PersonBURelationInfo;
import com.kingdee.shr.base.syssetting.util.BaseMetaDataUtil;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.commons.lang3.StringUtils;

public class AtsDealMsgConfirmTool {
    public static final ExecutorService executorService = Executors.newFixedThreadPool(1);

    public static List<String> splitLongNumber(String longNumber) {
        ArrayList<String> longList = new ArrayList<String>();
        longList.add(longNumber);
        while (longNumber.indexOf("!") > 0) {
            int index = longNumber.lastIndexOf("!");
            longNumber = longNumber.substring(0, index);
            longList.add(longNumber);
        }
        return longList;
    }

    public static Timestamp getNowTimestamp() {
        Date nowDate = new Date();
        Timestamp nowTimestamp = new Timestamp(nowDate.getTime());
        return nowTimestamp;
    }

    public static void dealOneDayMultiChange(Context ctx, PersonBURelaConfirmInfo personBURelaConfirmInfo) throws EASBizException, BOSException {
        PersonBURelaConfirmInfo info = PersonBURelaConfirmFactory.getLocalInstance((Context)ctx).getPersonBURelaConfirmInfo("select newEmpOrgRelation.*,* where id in ('" + personBURelaConfirmInfo.getId().toString() + "')");
        String personid = info.getPerson().getId().toString();
        if (info.getNewEmpOrgRelation() == null) {
            return;
        }
        if (info.getNewEmpOrgRelation().getStartDateTime() == null) {
            return;
        }
        String startDateTime = AtsDateUtils.dateLongToString(info.getNewEmpOrgRelation().getStartDateTime());
        String bizManageType = info.getBizManageType().getId().toString();
        String changeDate = AtsDateUtils.dateShortToString(info.getChangeDate());
        if (StringUtils.isEmpty((CharSequence)startDateTime)) {
            return;
        }
        String sql = "select fid from T_HR_PersonBURelaConfirm fc  WHERE exists ( select 1 from T_HR_EmpOrgRelation WHERE FStartDateTime < ? and fc.FNewEmpOrgRelationID = fid ) and fc.fpersonid = ? AND fc.FDealState = 0 AND fc.FBizManageTypeID = ? AND fc.FChangeDate = ?";
        Object[] params = new Object[]{AtsDateUtils.stringToTimestamp(startDateTime), personid, bizManageType, AtsDateUtils.stringToTimestamp(changeDate)};
        IRowSet oneDayMultiChangeRes = DbUtil.executeQuery((Context)ctx, (String)"select fid from T_HR_PersonBURelaConfirm fc  WHERE exists ( select 1 from T_HR_EmpOrgRelation WHERE FStartDateTime < ? and fc.FNewEmpOrgRelationID = fid ) and fc.fpersonid = ? AND fc.FDealState = 0 AND fc.FBizManageTypeID = ? AND fc.FChangeDate = ?", (Object[])params);
        try {
            while (oneDayMultiChangeRes.next()) {
                String updateSql = "update T_HR_PersonBURelaConfirm set FdealState = 1 where FID ='" + oneDayMultiChangeRes.getString("fid") + "'";
                DbUtil.execute((Context)ctx, (String)updateSql);
            }
        }
        catch (SQLException throwables) {
            throwables.printStackTrace();
        }
    }

    public static void insertPersonBURelation(Context ctx, AttendanceFileHISInfo inserHISInfo, PersonBURelaConfirmInfo personBURelaConfirmInfo) throws EASBizException, BOSException {
        AtsPosAddMsgDeal atsPosAddMsgDeal = new AtsPosAddMsgDeal();
        PersonBURelationInfo insertPersonBURelationInfo = AtsPosAddMsgDeal.assembleOnePersonBURelationInfo(ctx, personBURelaConfirmInfo);
        insertPersonBURelationInfo.setState(BizManageState.Disable);
        insertPersonBURelationInfo.setBeginDate(inserHISInfo.getEFFDT());
        insertPersonBURelationInfo.setEndDate(inserHISInfo.getLEFFDT());
        IObjectPK iObjectPK = PersonBURelationFactory.getLocalInstance((Context)ctx).addnew(insertPersonBURelationInfo);
        insertPersonBURelationInfo.setId(BOSUuid.read((String)iObjectPK.toString()));
        inserHISInfo.setManageRelation(insertPersonBURelationInfo);
        inserHISInfo.setIsDefaultManage(insertPersonBURelationInfo.isUseDefault());
    }

    public static void insertPersonBURelation(Context ctx, AtsHolidayFileHisInfo inserHISInfo, PersonBURelaConfirmInfo personBURelaConfirmInfo) throws EASBizException, BOSException {
        AtsPosAddMsgDeal atsPosAddMsgDeal = new AtsPosAddMsgDeal();
        PersonBURelationInfo insertPersonBURelationInfo = AtsPosAddMsgDeal.assembleOnePersonBURelationInfo(ctx, personBURelaConfirmInfo);
        insertPersonBURelationInfo.setState(BizManageState.Disable);
        insertPersonBURelationInfo.setBeginDate(inserHISInfo.getEFFDT());
        insertPersonBURelationInfo.setEndDate(inserHISInfo.getLEFFDT());
        IObjectPK iObjectPK = PersonBURelationFactory.getLocalInstance((Context)ctx).addnew(insertPersonBURelationInfo);
        insertPersonBURelationInfo.setId(BOSUuid.read((String)iObjectPK.toString()));
        inserHISInfo.setManageRelation(insertPersonBURelationInfo);
        inserHISInfo.setIsDefaultManage(insertPersonBURelationInfo.isUseDefault());
    }

    public static HROrgUnitInfo getDefaultManageOrg(Context ctx, String adminOrgUnitId, String bizManageTypeId) throws BOSException, EASBizException {
        HROrgUnitInfo info = null;
        AdminOrgBURelationCollection relationColl = AdminOrgBURelationFactory.getLocalInstance((Context)ctx).getAdminOrgBURelationCollection("select manageHrOrg.* where adminOrg='" + adminOrgUnitId + "' and bizManageType = '" + bizManageTypeId.trim() + "' and state = " + 1);
        if (relationColl.size() < 1) {
            return info;
        }
        AdminOrgBURelationInfo relationInfo = relationColl.get(0);
        return relationInfo.getManageHrOrg();
    }

    public static String getAttendanceFileRuleNumber(Context ctx, String personId) {
        String billNumber = null;
        try {
            AttendanceFileInfo info = new AttendanceFileInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("proposer.id", (Object)personId, CompareType.EQUALS));
            ICoreBase iCoreBase = BaseMetaDataUtil.getBizInterface((Context)ctx, (BOSObjectType)info.getBOSType());
            if (iCoreBase.exists(filter)) {
                info = AttendanceFileFactory.getLocalInstance(ctx).getAttendanceFileCollection("where proposer.id = '" + personId + "'").get(0);
                return info.getAttendanceNum();
            }
            PersonInfo personInfo = new PersonInfo();
            personInfo.setId(BOSUuid.read((String)personId));
            info.setProposer(personInfo);
            billNumber = NumberCodeRule.readCodeRuleNumber((IObjectValue)info, NumberCodeRule.getMainOrgByCu(ctx), ctx);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return billNumber;
    }

    public static boolean isDealExistedData(PersonBURelaConfirmInfo personBURelaConfirmInfo) {
        return HRBizDefineTypeEnum.ENROLLADJUST.equals((Object)personBURelaConfirmInfo.getBizDefineType()) || HRBizDefineTypeEnum.UNDO.equals((Object)personBURelaConfirmInfo.getBizDefineType()) || HRBizDefineTypeEnum.OTHER.equals((Object)personBURelaConfirmInfo.getBizDefineType()) || HRBizDefineTypeEnum.ADMINORGCHANGE.equals((Object)personBURelaConfirmInfo.getBizDefineType()) || HRBizDefineTypeEnum.ADMINMANAGERELATIONCHANGE.equals((Object)personBURelaConfirmInfo.getBizDefineType()) || HRBizDefineTypeEnum.REINVITE.equals((Object)personBURelaConfirmInfo.getBizDefineType()) || HRBizDefineTypeEnum.LOAN.equals((Object)personBURelaConfirmInfo.getBizDefineType()) || HRBizDefineTypeEnum.PLURALITY.equals((Object)personBURelaConfirmInfo.getBizDefineType()) || HRBizDefineTypeEnum.LOANBACK.equals((Object)personBURelaConfirmInfo.getBizDefineType()) || HRBizDefineTypeEnum.LOANINOUT.equals((Object)personBURelaConfirmInfo.getBizDefineType()) || HRBizDefineTypeEnum.FLUCTUACTION.equals((Object)personBURelaConfirmInfo.getBizDefineType()) || HRBizDefineTypeEnum.FLUCINOUT.equals((Object)personBURelaConfirmInfo.getBizDefineType());
    }

    public static boolean isReturnMainJobFile(PersonBURelaConfirmInfo personBURelaConfirmInfo) {
        return HRBizDefineTypeEnum.REINVITE.equals((Object)personBURelaConfirmInfo.getBizDefineType()) || HRBizDefineTypeEnum.LOAN.equals((Object)personBURelaConfirmInfo.getBizDefineType()) || HRBizDefineTypeEnum.PLURALITY.equals((Object)personBURelaConfirmInfo.getBizDefineType()) || HRBizDefineTypeEnum.LOANBACK.equals((Object)personBURelaConfirmInfo.getBizDefineType()) || HRBizDefineTypeEnum.LOANINOUT.equals((Object)personBURelaConfirmInfo.getBizDefineType());
    }
}

