/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.ats.calculate.time.util;

import com.kingdee.eas.hr.ats.calculate.time.model.TimeLabelModel;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;

public class TimeRangeIntersect {
    public static TimeLabelModel intersection(TimeLabelModel timeIntervalModelA, TimeLabelModel timeIntervalModelB) {
        Timestamp minEnd;
        Timestamp maxBegin = timeIntervalModelA.getBeginTime().after(timeIntervalModelB.getBeginTime()) ? timeIntervalModelA.getBeginTime() : timeIntervalModelB.getBeginTime();
        Timestamp timestamp = minEnd = timeIntervalModelA.getEndTime().before(timeIntervalModelB.getEndTime()) ? timeIntervalModelA.getEndTime() : timeIntervalModelB.getEndTime();
        if (maxBegin.before(minEnd)) {
            return new TimeLabelModel(maxBegin, minEnd, timeIntervalModelA.getLabel());
        }
        return null;
    }

    public static TimeLabelModel intersection(List<TimeLabelModel> TimeLabelModels) {
        if (TimeLabelModels == null || TimeLabelModels.size() < 2) {
            return null;
        }
        Timestamp maxBegin = TimeLabelModels.get(0).getBeginTime();
        Timestamp minEnd = TimeLabelModels.get(0).getEndTime();
        for (TimeLabelModel period : TimeLabelModels) {
            if (period.getBeginTime().after(maxBegin)) {
                maxBegin = period.getBeginTime();
            }
            if (!period.getEndTime().before(minEnd)) continue;
            minEnd = period.getEndTime();
        }
        if (maxBegin.before(minEnd) || maxBegin.equals(minEnd)) {
            return new TimeLabelModel(maxBegin, minEnd, TimeLabelModels.get(0).getLabel());
        }
        return null;
    }

    public static List<TimeLabelModel> intersection(TimeLabelModel interval, List<TimeLabelModel> intervals) {
        ArrayList<TimeLabelModel> result = new ArrayList<TimeLabelModel>();
        for (TimeLabelModel otherInterval : intervals) {
            Timestamp minEnd;
            Timestamp maxBegin = interval.getBeginTime().after(otherInterval.getBeginTime()) ? interval.getBeginTime() : otherInterval.getBeginTime();
            if (!maxBegin.before(minEnd = interval.getEndTime().before(otherInterval.getEndTime()) ? interval.getEndTime() : otherInterval.getEndTime())) continue;
            result.add(new TimeLabelModel(maxBegin, minEnd, otherInterval.getLabel()));
        }
        return result;
    }
}

