/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.ats.function;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.ats.AbstractAttencePolicyInfo;
import com.kingdee.eas.hr.ats.AbstractAttendanceFileInfo;
import com.kingdee.eas.hr.ats.AbstractAttendancePeriodInfo;
import com.kingdee.eas.hr.ats.AbstractScheduleShiftInfo;
import com.kingdee.eas.hr.ats.AtsAttenceResEnum;
import com.kingdee.eas.hr.ats.AtsLeaveBillDetailInfo;
import com.kingdee.eas.hr.ats.AtsOverTimeBillEntryCollection;
import com.kingdee.eas.hr.ats.AtsOverTimeBillEntryInfo;
import com.kingdee.eas.hr.ats.AtsOverTimeBillInfo;
import com.kingdee.eas.hr.ats.AtsShiftInfo;
import com.kingdee.eas.hr.ats.AtsTripBillEntryInfo;
import com.kingdee.eas.hr.ats.AtsUtil;
import com.kingdee.eas.hr.ats.AttencePolicyCollection;
import com.kingdee.eas.hr.ats.AttencePolicyExtInfo;
import com.kingdee.eas.hr.ats.AttencePolicyFactory;
import com.kingdee.eas.hr.ats.AttencePolicyInfo;
import com.kingdee.eas.hr.ats.AttendanceFileCollection;
import com.kingdee.eas.hr.ats.AttendanceFileFactory;
import com.kingdee.eas.hr.ats.AttendanceFileInfo;
import com.kingdee.eas.hr.ats.AttendancePeriodInfo;
import com.kingdee.eas.hr.ats.AttendanceProjectInfo;
import com.kingdee.eas.hr.ats.CardRuleCollection;
import com.kingdee.eas.hr.ats.CardRuleFactory;
import com.kingdee.eas.hr.ats.CardRuleInfo;
import com.kingdee.eas.hr.ats.FillSignCardEntryInfo;
import com.kingdee.eas.hr.ats.FillSignCardInfo;
import com.kingdee.eas.hr.ats.FillSignReasonCollection;
import com.kingdee.eas.hr.ats.FillSignReasonFactory;
import com.kingdee.eas.hr.ats.FillSignReasonInfo;
import com.kingdee.eas.hr.ats.HolidayLimitCollection;
import com.kingdee.eas.hr.ats.HolidayLimitFactory;
import com.kingdee.eas.hr.ats.HolidayLimitInfo;
import com.kingdee.eas.hr.ats.OverTimeCompensInfo;
import com.kingdee.eas.hr.ats.OverTimeReasonCollection;
import com.kingdee.eas.hr.ats.OverTimeReasonFactory;
import com.kingdee.eas.hr.ats.OverTimeReasonInfo;
import com.kingdee.eas.hr.ats.OverTimeTypeInfo;
import com.kingdee.eas.hr.ats.ResourceEnum;
import com.kingdee.eas.hr.ats.ScheduleShiftCollection;
import com.kingdee.eas.hr.ats.ScheduleShiftFactory;
import com.kingdee.eas.hr.ats.ScheduleShiftInfo;
import com.kingdee.eas.hr.ats.ScheduleShiftItemCollection;
import com.kingdee.eas.hr.ats.ScheduleShiftItemInfo;
import com.kingdee.eas.hr.ats.WorkCalendarFactory;
import com.kingdee.eas.hr.ats.WorkCalendarInfo;
import com.kingdee.eas.hr.ats.WorkCalendarItemCollection;
import com.kingdee.eas.hr.ats.WorkCalendarItemFactory;
import com.kingdee.eas.hr.ats.WorkCalendarItemInfo;
import com.kingdee.eas.hr.ats.app.formula.calculate.data.Tools;
import com.kingdee.eas.hr.ats.biz.util.AtsLeaveBillUtil;
import com.kingdee.eas.hr.ats.calculate.AtsCalculateTimeUtil;
import com.kingdee.eas.hr.ats.calculate.time.dataPrepare.impl.DataPrepareServiceImpl;
import com.kingdee.eas.hr.ats.calculate.time.dataProcess.TimeDataProcess;
import com.kingdee.eas.hr.ats.calculate.time.factory.DataProcessFactory;
import com.kingdee.eas.hr.ats.calculate.time.model.TimeLabelModel;
import com.kingdee.eas.hr.ats.calculate.time.strategy.context.AtsCalculatorContext;
import com.kingdee.eas.hr.ats.calculate.time.strategy.impl.BaseCalculatorStrategy;
import com.kingdee.eas.hr.ats.calculate.time.vo.TimeDataVO;
import com.kingdee.eas.hr.ats.calcutePrepareData.AtsPrepareDataHelper;
import com.kingdee.eas.hr.ats.common.AttendanceConstants;
import com.kingdee.eas.hr.ats.decimalPlace.util.DecimalPlaceUtil;
import com.kingdee.eas.hr.ats.function.AtsCalFunctionUtil;
import com.kingdee.eas.hr.ats.function.DataFuncUtils;
import com.kingdee.eas.hr.ats.function.OTCalculate;
import com.kingdee.eas.hr.ats.lightapp.util.HRTimeWebUtils;
import com.kingdee.eas.hr.ats.result.AttendanceDynamicResInfo;
import com.kingdee.eas.hr.ats.util.AtsDateUtils;
import com.kingdee.eas.hr.ats.util.AtsServerCalUtils;
import com.kingdee.eas.hr.ats.util.AtsServerUtils;
import com.kingdee.eas.hr.ats.util.common.AtsCollectionUtile;
import com.kingdee.eas.hr.ats.util.common.MLUtile;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.base.syssetting.util.LocaleUtils;
import com.kingdee.util.UuidException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.apache.log4j.Logger;

public class AtsCalFunctionService {
    private static Logger logger = Logger.getLogger(AtsCalFunctionService.class);
    public static final String STANDARDLIMIT = "standardLimit";
    public static final String USEDLIMIT = "usedLimit";
    public static final String FREEZELIMIT = "freezeLimit";
    public static final String REMAINLIMIT = "remainLimit";
    public static final String SHIFTTOTALREMAINLIMIT = "shiftTotalRemainLimit";
    public static final String PREOVERDRAFTLIMIT = "preOverdraftLimit";
    private Context ctx = Tools.getInstance().getCtx();
    private SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
    public static final String T_HR_ATS_ATTENDANCERESULT_FPROPOSERID = "T_HR_ATS_ATTENDANCERESULT_FPROPOSERID";
    public static final String T_HR_ATS_ATTENDANCERESULT_FATTENCEDATE = "T_HR_ATS_ATTENDANCERESULT_FATTENCEDATE";
    public static final String T_HR_SCMPCALTABLE_FPERSONID = "T_HR_SCMPCALTABLE_FPERSONID";
    public static final String GLOBALMAPKEY = "globalMapKey";
    public static final String PERIODBEGINDATE = "periodBeginDate";
    public static final String PERIODENDDATE = "periodEndDate";
    public static final String DAYTYPE = "DAYTYPE";
    public static final String T_HR_ATS_ATTENDANCERESULTSUM_FPROPOSERID = "T_HR_ATS_ATTENDANCERESULTSUM_FPROPOSERID";

    public Context getCtx() {
        return this.ctx;
    }

    public void setCtx(Context ctx) {
        this.ctx = ctx;
    }

    public String getAttendanceFileAttributeValue(String attributeName, Map paramMap) {
        try {
            AttendanceFileInfo attFilefo;
            Map globalMap = (Map)paramMap.get(GLOBALMAPKEY);
            String currDateStr = (String)paramMap.get(T_HR_ATS_ATTENDANCERESULT_FATTENCEDATE);
            String personId = (String)paramMap.get(T_HR_ATS_ATTENDANCERESULT_FPROPOSERID);
            Map attendanceFileInfoMap = (Map)globalMap.get("T_HR_ATS_AttendanceFile");
            String key = personId + "_" + currDateStr;
            int decimalPlace = DecimalPlaceUtil.getDecimalPlace(this.ctx, globalMap);
            if (attendanceFileInfoMap != null && (attFilefo = (AttendanceFileInfo)attendanceFileInfoMap.get(key)) != null) {
                String value = this.getAttributeValueFormAttendanceFileInfo(attFilefo, attributeName, decimalPlace);
                if (!StringUtils.isEmpty((String)value)) {
                    return value;
                }
                String attributeName2 = this.getAttributeByAliasFromMetaDataWithAttendanceFileInfo(attributeName);
                if (!StringUtils.isEmpty((String)attributeName2)) {
                    return this.getAttributeValueFormAttendanceFileInfo(attFilefo, attributeName2, decimalPlace);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return "";
    }

    private String getAttributeByAliasFromMetaDataWithAttendanceFileInfo(String alias) {
        if (StringUtils.isEmpty((String)alias)) {
            return "";
        }
        PropertyCollection inheritedProperties = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)this.ctx).getEntity(BOSObjectType.create((String)"A8C97BB3")).getInheritedProperties();
        ArrayList<Locale> locales = new ArrayList<Locale>();
        locales.add(LocaleUtils.locale_L1);
        locales.add(LocaleUtils.locale_L2);
        locales.add(LocaleUtils.locale_L3);
        String attributeName = null;
        for (int index = 0; index < inheritedProperties.size(); ++index) {
            attributeName = this.getAttributeName(inheritedProperties.get(index), alias, locales);
            if (attributeName == null) continue;
            return attributeName;
        }
        return "";
    }

    private String getAttributeName(PropertyInfo propertyInfo, String alias, ArrayList<Locale> locales) {
        String aliasFromPro = null;
        for (Locale locale : locales) {
            aliasFromPro = propertyInfo.getAlias(locale);
            if (aliasFromPro == null || aliasFromPro == "" || !alias.equalsIgnoreCase(aliasFromPro)) continue;
            return propertyInfo.getName();
        }
        return null;
    }

    private String getAttributeValueFormAttendanceFileInfo(AttendanceFileInfo poInfo, String attributeName, int decimalPlace) {
        Object obj = poInfo.get(attributeName);
        if (obj != null) {
            try {
                CoreBaseInfo itemInfo = (CoreBaseInfo)obj;
                if (null != itemInfo.get("number") && !StringUtils.isEmpty((String)itemInfo.get("number").toString())) {
                    return itemInfo.get("number").toString();
                }
                BOSUuid id = itemInfo.getId();
                return id.toString();
            }
            catch (Exception e) {
                e.printStackTrace();
                if (obj instanceof BigDecimal) {
                    BigDecimal value = (BigDecimal)obj;
                    value = DecimalPlaceUtil.decimalPlaceCtrl(this.ctx, value, decimalPlace);
                    return value.toString();
                }
                if (obj instanceof Date) {
                    Date value = (Date)obj;
                    String returnVal = AtsDateUtils.dateLongToString(value);
                    return returnVal;
                }
                if (obj instanceof Boolean) {
                    Boolean value = (Boolean)obj;
                    return value != false ? "1" : "0";
                }
                return String.valueOf(obj);
            }
        }
        return "";
    }

    public double getScheduleDayType(Map paramMap, double dayValue) throws EASBizException, BOSException {
        int day = BigDecimal.valueOf(dayValue).intValue();
        String personId = (String)paramMap.get(T_HR_ATS_ATTENDANCERESULT_FPROPOSERID);
        String currDateStr = (String)paramMap.get(T_HR_ATS_ATTENDANCERESULT_FATTENCEDATE);
        Map globalMap = (Map)paramMap.get(GLOBALMAPKEY);
        String calDateStr = "";
        Date currentDate = AtsDateUtils.stringToShortDate(currDateStr);
        Date preDate = null;
        String preDateStr = "";
        Date nextDate = null;
        String nextDateStr = "";
        double dayType = -1.0;
        if (-1 == day) {
            preDate = AtsDateUtils.getPreDay(currentDate);
            calDateStr = preDateStr = AtsDateUtils.dateShortToString(preDate);
        } else if (1 == day) {
            nextDate = AtsDateUtils.getNextDay(currentDate);
            calDateStr = nextDateStr = AtsDateUtils.dateShortToString(nextDate);
        } else {
            calDateStr = currDateStr;
        }
        String key = personId + "_" + calDateStr;
        dayType = AtsCalFunctionUtil.getAtsShiftDayType(calDateStr, globalMap, key);
        return dayType;
    }

    public double getCurrScheduleDayType(Map paramMap) throws EASBizException, BOSException {
        String personId = (String)paramMap.get(T_HR_ATS_ATTENDANCERESULT_FPROPOSERID);
        String currDateStr = (String)paramMap.get(T_HR_ATS_ATTENDANCERESULT_FATTENCEDATE);
        Map globalMap = (Map)paramMap.get(GLOBALMAPKEY);
        double dayType = -1.0;
        if (globalMap != null && !globalMap.isEmpty()) {
            String key = personId + "_" + currDateStr;
            dayType = AtsCalFunctionUtil.getAtsShiftDayType(currDateStr, globalMap, key);
        }
        return dayType;
    }

    public String getCycleBeginOrEnd(Map paramMap, String cycletag) throws EASBizException, BOSException {
        Date currentDate;
        Date endDate;
        Date startDate;
        String attenceCycleID;
        Map<String, AttendanceFileInfo> attendanceFileInfoMap;
        String key;
        int tag = new BigDecimal(cycletag).intValue();
        String personId = (String)paramMap.get(T_HR_ATS_ATTENDANCERESULT_FPROPOSERID);
        String currDateStr = (String)paramMap.get(T_HR_ATS_ATTENDANCERESULT_FATTENCEDATE);
        Map globalMap = (Map)paramMap.get(GLOBALMAPKEY);
        String resValue = "";
        resValue = tag == 0 ? (String)globalMap.get(PERIODBEGINDATE) : (String)globalMap.get(PERIODENDDATE);
        if (globalMap.get("personId") != null && StringUtils.isEmpty((String)resValue)) {
            AttendanceFileInfo attFilefo;
            personId = globalMap.get("personId").toString();
            key = personId.substring(1, personId.length() - 1);
            attendanceFileInfoMap = null;
            try {
                attendanceFileInfoMap = AtsPrepareDataHelper.getAttendanceFileInfosByPersonIds(this.ctx, personId);
            }
            catch (UuidException e1) {
                e1.printStackTrace();
            }
            catch (SQLException e1) {
                e1.printStackTrace();
            }
            Map<String, List<AttendancePeriodInfo>> attendancePeriodInfoListMap = AtsServerCalUtils.getAttendancePeriodInfos(this.ctx);
            HashMap<String, AttencePolicyInfo> policyInfoMap = new HashMap<String, AttencePolicyInfo>();
            try {
                AttencePolicyCollection coll = AttencePolicyFactory.getLocalInstance(this.ctx).getAttencePolicyCollection();
                int size = coll.size();
                for (int i = 0; i < size; ++i) {
                    String key1 = coll.get(i).getId().toString();
                    policyInfoMap.put(key1, coll.get(i));
                }
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
            attenceCycleID = "";
            if (attendanceFileInfoMap != null && (attFilefo = attendanceFileInfoMap.get(key)) != null && attFilefo.getAttencePolicy() != null && attFilefo.getAttencePolicy().getId() != null && policyInfoMap != null) {
                AttencePolicyInfo poInfo = (AttencePolicyInfo)policyInfoMap.get(attFilefo.getAttencePolicy().getId().toString());
                String string = attenceCycleID = poInfo.getAttenceCycle() == null ? "" : poInfo.getAttenceCycle().getId().toString();
            }
            if (attendancePeriodInfoListMap != null && StringUtils.isNotBlank((String)attenceCycleID)) {
                List<AttendancePeriodInfo> periodInfoList = attendancePeriodInfoListMap.get(attenceCycleID);
                int size = periodInfoList.size();
                for (int i = 0; i < size; ++i) {
                    startDate = periodInfoList.get(i).getStartDate();
                    endDate = periodInfoList.get(i).getEndDate();
                    currentDate = AtsDateUtils.stringToShortDate(currDateStr);
                    if (currentDate.getTime() < startDate.getTime() || currentDate.getTime() > endDate.getTime()) continue;
                    if (tag == 0) {
                        resValue = AtsDateUtils.dateShortToString(startDate);
                        return resValue;
                    }
                    if (tag == 1) {
                        resValue = AtsDateUtils.dateShortToString(endDate);
                        return resValue;
                    }
                    resValue = currDateStr;
                    return resValue;
                }
            }
        }
        if (!globalMap.isEmpty()) {
            AttendanceFileInfo attFilefo;
            key = personId + "_" + currDateStr;
            attendanceFileInfoMap = (Map<String, AttendanceFileInfo>)globalMap.get("T_HR_ATS_AttendanceFile");
            Map attendancePolicyInfoMap = (Map)globalMap.get("T_HR_ATS_AttencePolicy");
            Map attendancePeriodInfoMap = (Map)globalMap.get("attendancePeriodInfoListMap");
            attenceCycleID = "";
            if (attendanceFileInfoMap != null && (attFilefo = attendanceFileInfoMap.get(key)) != null && attFilefo.getAttencePolicy() != null && attFilefo.getAttencePolicy().getId() != null && attendancePolicyInfoMap != null) {
                AttencePolicyInfo poInfo = (AttencePolicyInfo)attendancePolicyInfoMap.get(attFilefo.getAttencePolicy().getId().toString());
                String string = attenceCycleID = poInfo.getAttenceCycle() == null ? "" : poInfo.getAttenceCycle().getId().toString();
            }
            if (attendancePeriodInfoMap != null && StringUtils.isNotBlank((String)attenceCycleID)) {
                List periodInfoList = (List)attendancePeriodInfoMap.get(attenceCycleID);
                int size = periodInfoList.size();
                for (int i = 0; i < size; ++i) {
                    startDate = ((AttendancePeriodInfo)periodInfoList.get(i)).getStartDate();
                    endDate = ((AttendancePeriodInfo)periodInfoList.get(i)).getEndDate();
                    currentDate = AtsDateUtils.stringToShortDate(currDateStr);
                    if (currentDate.getTime() < startDate.getTime() || currentDate.getTime() > endDate.getTime()) continue;
                    if (tag == 0) {
                        resValue = AtsDateUtils.dateShortToString(startDate);
                        return resValue;
                    }
                    if (tag == 1) {
                        resValue = AtsDateUtils.dateShortToString(endDate);
                        return resValue;
                    }
                    resValue = currDateStr;
                    return resValue;
                }
            }
        }
        return resValue;
    }

    public double getCurrentOverTimeHour(String otCompensNumber, double otType, Map paramMap) throws EASBizException, BOSException, UuidException, SQLException {
        Map atsOverTimeBillObject;
        double returnValue = 0.0;
        OTCalculate oTCalculate = new OTCalculate();
        String attendPolicyId = Tools.getInstance().getAttendPolicyid();
        int ottype = BigDecimal.valueOf(otType).intValue();
        String personId = (String)paramMap.get(T_HR_ATS_ATTENDANCERESULT_FPROPOSERID);
        String currDateStr = (String)paramMap.get(T_HR_ATS_ATTENDANCERESULT_FATTENCEDATE);
        Map globalMap = (Map)paramMap.get(GLOBALMAPKEY);
        int decimalPlace = DecimalPlaceUtil.getDecimalPlace(this.ctx, globalMap);
        Map calResultInfoMap = (Map)globalMap.get("calResultInfoMap");
        Map shiftMap = (Map)globalMap.get("T_HR_ATS_ScheduleShift");
        List schedulelList = shiftMap != null && shiftMap.size() > 0 ? (List)shiftMap.get(personId + "_" + currDateStr) : null;
        Map attencePolicyInfoMap = (Map)globalMap.get("T_HR_ATS_AttencePolicy");
        AttencePolicyInfo attencePolicyInfo = (AttencePolicyInfo)attencePolicyInfoMap.get(attendPolicyId);
        BigDecimal afterAllowOT = attencePolicyInfo.getAfterAllowOT();
        boolean isGenOverTime = attencePolicyInfo.isIsGenOverTime();
        Map overTimeTypeInfoMap = (Map)globalMap.get("T_HR_ATS_OverTimeType");
        Map overTimeCompensMap = (Map)globalMap.get("T_HR_ATS_OverTimeCompens");
        String billOtCompensNumber = "";
        OverTimeTypeInfo overTimeTypeInfo = null;
        OverTimeCompensInfo overTimeCompensInfo = null;
        String overTimeTypeId = "";
        String overTimeCompensId = "";
        int billOtType = 0;
        String S6 = null;
        String S5 = null;
        String S4 = null;
        String S3 = null;
        String S2 = null;
        String S1 = null;
        String resultInfoKey = MessageFormat.format("{0}{1}{2}", personId, "_", currDateStr);
        if (null != calResultInfoMap && null != calResultInfoMap.get(resultInfoKey)) {
            Map resultInfo = (Map)calResultInfoMap.get(resultInfoKey);
            S6 = resultInfo.get("S6") != null ? resultInfo.get("S6").toString() : "";
            S5 = resultInfo.get("S5") != null ? resultInfo.get("S5").toString() : "";
            S4 = resultInfo.get("S4") != null ? resultInfo.get("S4").toString() : "";
            S3 = resultInfo.get("S3") != null ? resultInfo.get("S3").toString() : "";
            S2 = resultInfo.get("S2") != null ? resultInfo.get("S2").toString() : "";
            S1 = resultInfo.get("S1") != null ? resultInfo.get("S1").toString() : "";
            S6 = S6.contains(".0") ? S6.substring(0, S6.indexOf(".0")) : S6;
            S5 = S5.contains(".0") ? S5.substring(0, S5.indexOf(".0")) : S5;
            S4 = S4.contains(".0") ? S4.substring(0, S4.indexOf(".0")) : S4;
            S3 = S3.contains(".0") ? S3.substring(0, S3.indexOf(".0")) : S3;
            S2 = S2.contains(".0") ? S2.substring(0, S2.indexOf(".0")) : S2;
            String string = S1 = S1.contains(".0") ? S1.substring(0, S1.indexOf(".0")) : S1;
        }
        if ((atsOverTimeBillObject = (Map)globalMap.get("T_HR_ATS_OverTimeBillEntry")) != null && atsOverTimeBillObject.size() > 0) {
            List list = (List)atsOverTimeBillObject.get(personId + "_" + currDateStr);
            AtsOverTimeBillEntryInfo atsBillEntryInfo = null;
            int listSize = list != null ? list.size() : 0;
            for (int i = 0; i < listSize; ++i) {
                atsBillEntryInfo = (AtsOverTimeBillEntryInfo)list.get(i);
                overTimeTypeId = atsBillEntryInfo != null && atsBillEntryInfo.getOtType() != null && atsBillEntryInfo.getOtType().getId() != null ? atsBillEntryInfo.getOtType().getId().toString() : "";
                overTimeCompensId = atsBillEntryInfo != null && atsBillEntryInfo.getOtCompens() != null && atsBillEntryInfo.getOtCompens().getId() != null ? atsBillEntryInfo.getOtCompens().getId().toString() : "";
                overTimeTypeInfo = (OverTimeTypeInfo)overTimeTypeInfoMap.get(overTimeTypeId);
                overTimeCompensInfo = (OverTimeCompensInfo)overTimeCompensMap.get(overTimeCompensId);
                billOtCompensNumber = overTimeCompensInfo.getNumber();
                billOtType = Integer.parseInt(overTimeTypeInfo.getNumber());
                if (atsBillEntryInfo == null || atsBillEntryInfo.getRealOTTime() == null) continue;
                if (StringUtils.isNotEmpty((String)otCompensNumber) && ottype != 0 && otCompensNumber.equals(billOtCompensNumber) && ottype == billOtType) {
                    returnValue += atsBillEntryInfo.getRealOTTime().doubleValue();
                    continue;
                }
                if (StringUtils.isNotEmpty((String)otCompensNumber) && ottype == 0 && otCompensNumber.equals(billOtCompensNumber)) {
                    returnValue += atsBillEntryInfo.getRealOTTime().doubleValue();
                    continue;
                }
                if (!StringUtils.isNotEmpty((String)otCompensNumber) && ottype != 0 && ottype == billOtType) {
                    returnValue += atsBillEntryInfo.getRealOTTime().doubleValue();
                    continue;
                }
                if (StringUtils.isNotEmpty((String)otCompensNumber) || ottype != 0) continue;
                returnValue += atsBillEntryInfo.getRealOTTime().doubleValue();
            }
        }
        if (!isGenOverTime) {
            int shiftSize;
            int dayType = -1;
            ScheduleShiftItemCollection scheduleShiftItemCollection = null;
            int shiftItemSize = 0;
            String onScheduleTime = "";
            String offScheduleTime = "";
            String onTimeDynamicResult = "";
            String offTimeDynamicResult = "";
            String startTime = "";
            String endTime = "";
            BigDecimal segmentInRest = new BigDecimal("0");
            String shiftOtCompensNum = "";
            int dayTypeToOtType = 0;
            ScheduleShiftInfo scheduleShiftInfo = null;
            int n = shiftSize = schedulelList != null ? schedulelList.size() : 0;
            for (int i = 0; i < shiftSize; ++i) {
                scheduleShiftInfo = (ScheduleShiftInfo)schedulelList.get(i);
                if (scheduleShiftInfo == null) continue;
                scheduleShiftItemCollection = scheduleShiftInfo.getItems();
                shiftItemSize = scheduleShiftItemCollection.size();
                dayType = scheduleShiftInfo.getDayType().getValue();
                dayTypeToOtType = dayType + 1;
                overTimeCompensId = scheduleShiftInfo.getOtCompens() != null && scheduleShiftInfo.getOtCompens().getId() != null ? scheduleShiftInfo.getOtCompens().getId().toString() : "";
                overTimeCompensInfo = (OverTimeCompensInfo)overTimeCompensMap.get(overTimeCompensId);
                shiftOtCompensNum = overTimeCompensInfo.getNumber();
                ScheduleShiftItemInfo scheduleShiftItemInfo = null;
                String attendanceType = "";
                switch (shiftItemSize) {
                    case 1: {
                        onTimeDynamicResult = S1;
                        offTimeDynamicResult = S2;
                        break;
                    }
                    case 2: {
                        onTimeDynamicResult = S3;
                        offTimeDynamicResult = S4;
                        break;
                    }
                    case 3: {
                        onTimeDynamicResult = S5;
                        offTimeDynamicResult = S6;
                        break;
                    }
                    default: {
                        onTimeDynamicResult = "";
                        offTimeDynamicResult = "";
                    }
                }
                for (int j = 0; j < shiftItemSize; ++j) {
                    scheduleShiftItemInfo = scheduleShiftItemCollection.get(j);
                    if (scheduleShiftItemInfo == null) continue;
                    attendanceType = scheduleShiftItemInfo.getAttendanceType().getValue();
                    segmentInRest = scheduleShiftItemInfo.getSegmentInRest();
                    onScheduleTime = this.sdf.format(scheduleShiftItemInfo.getPreDateTime());
                    offScheduleTime = this.sdf.format(scheduleShiftItemInfo.getNextDateTime());
                    if (!"2".equals(attendanceType) && !"4".equals(attendanceType)) continue;
                    if (StringUtils.isNotEmpty((String)otCompensNumber) && ottype != 0 && otCompensNumber.equals(shiftOtCompensNum) && ottype == dayTypeToOtType) {
                        returnValue += oTCalculate.calculateFixOverTime(onScheduleTime, offScheduleTime, onTimeDynamicResult, offTimeDynamicResult, segmentInRest, attencePolicyInfo, decimalPlace);
                        continue;
                    }
                    if (StringUtils.isNotEmpty((String)otCompensNumber) && ottype == 0 && otCompensNumber.equals(shiftOtCompensNum)) {
                        returnValue += oTCalculate.calculateFixOverTime(onScheduleTime, offScheduleTime, onTimeDynamicResult, offTimeDynamicResult, segmentInRest, attencePolicyInfo, decimalPlace);
                        continue;
                    }
                    if (!StringUtils.isNotEmpty((String)otCompensNumber) && ottype != 0 && ottype == dayTypeToOtType) {
                        returnValue += oTCalculate.calculateFixOverTime(onScheduleTime, offScheduleTime, onTimeDynamicResult, offTimeDynamicResult, segmentInRest, attencePolicyInfo, decimalPlace);
                        continue;
                    }
                    if (StringUtils.isNotEmpty((String)otCompensNumber) || ottype == 0) continue;
                    returnValue += oTCalculate.calculateFixOverTime(onScheduleTime, offScheduleTime, onTimeDynamicResult, offTimeDynamicResult, segmentInRest, attencePolicyInfo, decimalPlace);
                }
                if (attencePolicyInfo.isPreNotBill()) {
                    startTime = S1;
                    if (scheduleShiftItemInfo != null) {
                        endTime = AtsDateUtils.dateLongFormatToString(scheduleShiftItemInfo.getPreDateTime());
                        if (StringUtils.isNotEmpty((String)otCompensNumber) && ottype != 0 && otCompensNumber.equals(shiftOtCompensNum) && ottype == dayTypeToOtType) {
                            returnValue += oTCalculate.getPreAndAftOTBillLength(startTime, endTime, attencePolicyInfo, decimalPlace);
                        } else if (StringUtils.isNotEmpty((String)otCompensNumber) && ottype == 0 && otCompensNumber.equals(shiftOtCompensNum)) {
                            returnValue += oTCalculate.getPreAndAftOTBillLength(startTime, endTime, attencePolicyInfo, decimalPlace);
                        } else if (!StringUtils.isNotEmpty((String)otCompensNumber) && ottype != 0 && ottype == dayTypeToOtType) {
                            returnValue += oTCalculate.getPreAndAftOTBillLength(startTime, endTime, attencePolicyInfo, decimalPlace);
                        } else if (!StringUtils.isNotEmpty((String)otCompensNumber) && ottype != 0) {
                            returnValue += oTCalculate.getPreAndAftOTBillLength(startTime, endTime, attencePolicyInfo, decimalPlace);
                        }
                    }
                }
                if (!attencePolicyInfo.isAfterNotBill()) continue;
                switch (shiftItemSize) {
                    case 1: {
                        scheduleShiftItemInfo = scheduleShiftItemCollection.get(0);
                        startTime = AtsDateUtils.timestampToString(scheduleShiftItemInfo.getNextDateTime());
                        startTime = DataFuncUtils.getAllowOTTime(startTime, afterAllowOT);
                        endTime = S2;
                        break;
                    }
                    case 2: {
                        scheduleShiftItemInfo = scheduleShiftItemCollection.get(1);
                        startTime = AtsDateUtils.timestampToString(scheduleShiftItemInfo.getNextDateTime());
                        startTime = DataFuncUtils.getAllowOTTime(startTime, afterAllowOT);
                        endTime = S4;
                        break;
                    }
                    case 3: {
                        scheduleShiftItemInfo = scheduleShiftItemCollection.get(2);
                        startTime = AtsDateUtils.timestampToString(scheduleShiftItemInfo.getNextDateTime());
                        startTime = DataFuncUtils.getAllowOTTime(startTime, afterAllowOT);
                        endTime = S6;
                        break;
                    }
                    default: {
                        startTime = "";
                        endTime = "";
                    }
                }
                if (StringUtils.isNotEmpty((String)otCompensNumber) && ottype != 0 && otCompensNumber.equals(shiftOtCompensNum) && ottype == dayTypeToOtType) {
                    returnValue += oTCalculate.getPreAndAftOTBillLength(startTime, endTime, attencePolicyInfo, decimalPlace);
                    continue;
                }
                if (StringUtils.isNotEmpty((String)otCompensNumber) && ottype == 0 && otCompensNumber.equals(shiftOtCompensNum)) {
                    returnValue += oTCalculate.getPreAndAftOTBillLength(startTime, endTime, attencePolicyInfo, decimalPlace);
                    continue;
                }
                if (!StringUtils.isNotEmpty((String)otCompensNumber) && ottype != 0 && ottype == dayTypeToOtType) {
                    returnValue += oTCalculate.getPreAndAftOTBillLength(startTime, endTime, attencePolicyInfo, decimalPlace);
                    continue;
                }
                if (StringUtils.isNotEmpty((String)otCompensNumber) || ottype == 0) continue;
                returnValue += oTCalculate.getPreAndAftOTBillLength(startTime, endTime, attencePolicyInfo, decimalPlace);
            }
        }
        return returnValue;
    }

    public double getCurrentLeaveDay(String holidayTypeNumber, double unitVal, Map paramMap) throws EASBizException, BOSException, UuidException, SQLException {
        Map globalMap = (Map)paramMap.get(GLOBALMAPKEY);
        int decimalPlace = DecimalPlaceUtil.getDecimalPlace(this.ctx, globalMap);
        String personId = (String)paramMap.get(T_HR_ATS_ATTENDANCERESULT_FPROPOSERID);
        String currDateStr = (String)paramMap.get(T_HR_ATS_ATTENDANCERESULT_FATTENCEDATE);
        int unitval = BigDecimal.valueOf(unitVal).intValue();
        Map<String, Object> info = this.getLeaveBillDetailInfo(personId, currDateStr, holidayTypeNumber, unitval, paramMap);
        BigDecimal leaveDay = BigDecimal.valueOf(0L);
        if (info != null) {
            leaveDay = (BigDecimal)info.get("fleavelength");
        }
        double leaveValue = DecimalPlaceUtil.decimalPlaceCtrl(this.ctx, leaveDay, decimalPlace).doubleValue();
        return leaveValue;
    }

    public String getCurrentHolidayTypes(Map paramMap) throws EASBizException, BOSException, UuidException, SQLException {
        Map globalMap = (Map)paramMap.get(GLOBALMAPKEY);
        String personId = (String)paramMap.get(T_HR_ATS_ATTENDANCERESULT_FPROPOSERID);
        String currDateStr = (String)paramMap.get(T_HR_ATS_ATTENDANCERESULT_FATTENCEDATE);
        String holidayTypes = this.getLeaveBillDetailInfo(personId, currDateStr, paramMap);
        return holidayTypes;
    }

    public String getLeaveBillDetailInfo(String personId, String currDay, Map paramMap) throws EASBizException, BOSException, UuidException, SQLException {
        ArrayList infoList = null;
        String holidayTypes = "";
        if (AttendanceConstants.isUseNew) {
            int leaveDetailListSize;
            Map globalMap = (Map)paramMap.get(GLOBALMAPKEY);
            infoList = new ArrayList();
            Map leaveBillDetailInfoMap = (Map)globalMap.get("atsLeaveBillDetailInfosMap");
            List leaveDetailList = leaveBillDetailInfoMap != null && leaveBillDetailInfoMap.size() > 0 ? (List)leaveBillDetailInfoMap.get(personId + "_" + currDay) : null;
            int n = leaveDetailListSize = leaveDetailList != null ? leaveDetailList.size() : 0;
            if (leaveDetailListSize > 0) {
                for (int i = 0; i < leaveDetailListSize; ++i) {
                    AtsLeaveBillDetailInfo atsLeaveBillDetailInfo = (AtsLeaveBillDetailInfo)leaveDetailList.get(i);
                    if (null == atsLeaveBillDetailInfo || null == atsLeaveBillDetailInfo.getPolicy() || null == atsLeaveBillDetailInfo.getPolicy().getHolidayType() || null == atsLeaveBillDetailInfo.getPolicy().getHolidayType().getName()) continue;
                    holidayTypes = holidayTypes + atsLeaveBillDetailInfo.getPolicy().getHolidayType().getName() + "/";
                }
            }
        } else {
            holidayTypes = this.getLeaveBillDetailInfoList(personId, currDay);
        }
        return holidayTypes;
    }

    public String getLeaveBillDetailInfoList(String personId, String currentDay) throws EASBizException, BOSException, UuidException, SQLException {
        String holidayTypes = "";
        StringBuffer sb = new StringBuffer();
        sb.append(" select detail.FLeaveLength, type.fnumber,type.fname" + MLUtile.getMlFlag(this.ctx) + ",detail.fproposerid, detail.* from T_HR_ATS_LeaveBillDetail detail ");
        sb.append(" left join T_HR_ATS_LeaveBill bill on ");
        sb.append(" bill.fid = detail.fleavebillid ");
        sb.append(" left join T_HR_ATS_HolidayPolicy policy ");
        sb.append(" on policy.fid = detail.FPolicyID ");
        sb.append(" left join T_HR_ATS_HolidayType type ");
        sb.append(" on type.fid = policy.FHolidayTypeID ");
        sb.append(" where  detail.fproposerid='" + personId + "' ");
        sb.append(" and FLeaveDate = {ts '" + currentDay + "'} ");
        IRowSet row = DbUtil.executeQuery((Context)this.ctx, (String)sb.toString());
        ArrayList list = new ArrayList();
        while (row.next()) {
            HashMap resMap = new HashMap();
            BigDecimal FLeaveLength = new BigDecimal(row.getString("FLeaveLength"));
            String fnumber = row.getString("fnumber");
            String fname = row.getString("name");
            String fproposerid = row.getString("fproposerid");
            PersonInfo personInfo = new PersonInfo();
            personInfo.setId(BOSUuid.read((String)row.getString("fproposerid")));
            holidayTypes = holidayTypes + fname + "/";
        }
        return holidayTypes;
    }

    public Map<String, Object> getLeaveBillDetailInfo(String personId, String currDay, String holidayTypeNumber, int unit, Map paramMap) throws EASBizException, BOSException, UuidException, SQLException {
        List<Map<String, Object>> infoList = null;
        if (AttendanceConstants.isUseNew) {
            int leaveDetailListSize;
            Map globalMap = (Map)paramMap.get(GLOBALMAPKEY);
            infoList = new ArrayList<Map<String, Object>>();
            Map leaveBillDetailInfoMap = (Map)globalMap.get("atsLeaveBillDetailInfosMap");
            List leaveDetailList = leaveBillDetailInfoMap != null && leaveBillDetailInfoMap.size() > 0 ? (List)leaveBillDetailInfoMap.get(personId + "_" + currDay) : null;
            int n = leaveDetailListSize = leaveDetailList != null ? leaveDetailList.size() : 0;
            if (leaveDetailListSize > 0) {
                BigDecimal standardHour = this.getStandardHour(personId, currDay, globalMap);
                for (int i = 0; i < leaveDetailListSize; ++i) {
                    AtsLeaveBillDetailInfo atsLeaveBillDetailInfo = (AtsLeaveBillDetailInfo)leaveDetailList.get(i);
                    if (!holidayTypeNumber.equals(atsLeaveBillDetailInfo.getPolicy().getHolidayType().getNumber())) continue;
                    HashMap<String, BigDecimal> m = new HashMap<String, BigDecimal>();
                    if (unit == atsLeaveBillDetailInfo.getLeaveUnit().getValue()) {
                        m.put("fleavelength", atsLeaveBillDetailInfo.getLeaveLength());
                    } else if (unit == 1) {
                        m.put("fleavelength", atsLeaveBillDetailInfo.getLeaveLength().divide(standardHour, DecimalPlaceUtil.getDefaultDecimalPlacesCal(), RoundingMode.HALF_UP));
                    } else if (unit == 2) {
                        m.put("fleavelength", atsLeaveBillDetailInfo.getLeaveLength().multiply(standardHour));
                    }
                    infoList.add(m);
                }
            }
        } else {
            infoList = this.getLeaveBillDetailInfoList(personId, currDay, holidayTypeNumber, unit);
        }
        Map<String, Object> map = null;
        if (infoList.size() == 1) {
            map = infoList.get(0);
        }
        if (infoList.size() > 1) {
            BigDecimal totalLeaveLength = new BigDecimal(0);
            for (int i = 0; i < infoList.size(); ++i) {
                Map<String, Object> map_i = infoList.get(i);
                totalLeaveLength = totalLeaveLength.add((BigDecimal)map_i.get("fleavelength"));
            }
            map = infoList.get(0);
            map.put("fleavelength", totalLeaveLength);
        }
        return map;
    }

    private BigDecimal getStandardHour(String personId, String currDay, Map<String, Object> globalMap) {
        BigDecimal standardHour = BigDecimal.ZERO;
        Map attendanceFileInfoMap = (Map)globalMap.get("T_HR_ATS_AttendanceFile");
        AttendanceFileInfo attendanceFileInfo = (AttendanceFileInfo)attendanceFileInfoMap.get(personId + "_" + currDay);
        if (null != attendanceFileInfo) {
            if (attendanceFileInfo.getIsAttendance().getValue() == "1") {
                List schedulelList;
                Map shiftMap = (Map)globalMap.get("T_HR_ATS_ScheduleShift");
                List list = schedulelList = shiftMap != null && shiftMap.size() > 0 ? (List)shiftMap.get(personId + "_" + currDay) : null;
                if (null != schedulelList && schedulelList.size() > 0) {
                    standardHour = ((ScheduleShiftInfo)schedulelList.get(0)).getStandardHour();
                }
            } else {
                Map attendancePolicyInfoMap = (Map)globalMap.get("T_HR_ATS_AttencePolicy");
                AttencePolicyInfo poInfo = (AttencePolicyInfo)attendancePolicyInfoMap.get(attendanceFileInfo.getAttencePolicy().getId().toString());
                standardHour = new BigDecimal(24);
                AtsShiftInfo atsShiftInfo = null;
                if (attendanceFileInfo.getAtsShift() != null) {
                    String atsShiftId = attendanceFileInfo.getAtsShift().getId().toString();
                    Map shiftInfoMap = (Map)globalMap.get("T_HR_ATS_Shift");
                    atsShiftInfo = (AtsShiftInfo)shiftInfoMap.get(atsShiftId);
                    standardHour = atsShiftInfo.getStandardHour();
                } else {
                    standardHour = poInfo.getDayHour();
                }
            }
        }
        return standardHour;
    }

    public List<Map<String, Object>> getLeaveBillDetailInfoList(String personId, String currentDay, String holidayTypeNumber, int unitVal) throws EASBizException, BOSException, UuidException, SQLException {
        StringBuffer sb = new StringBuffer();
        sb.append(" select detail.FLeaveLength, type.fnumber,type.fname" + MLUtile.getMlFlag(this.ctx) + ",detail.fproposerid, detail.* from T_HR_ATS_LeaveBillDetail detail ");
        sb.append(" left join T_HR_ATS_LeaveBill bill on ");
        sb.append(" bill.fid = detail.fleavebillid ");
        sb.append(" left join T_HR_ATS_HolidayPolicy policy ");
        sb.append(" on policy.fid = detail.FPolicyID ");
        sb.append(" left join T_HR_ATS_HolidayType type ");
        sb.append(" on type.fid = policy.FHolidayTypeID ");
        sb.append(" where type.fnumber ='" + holidayTypeNumber + "' and detail.fproposerid='" + personId + "' ");
        sb.append(" and FLeaveDate = {ts '" + currentDay + "'} ");
        sb.append(" and FLeaveUnit='" + unitVal + "' ");
        IRowSet row = DbUtil.executeQuery((Context)this.ctx, (String)sb.toString());
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        while (row.next()) {
            HashMap<String, Object> resMap = new HashMap<String, Object>();
            BigDecimal FLeaveLength = new BigDecimal(row.getString("FLeaveLength"));
            String fnumber = row.getString("fnumber");
            String fname = row.getString("name");
            String fproposerid = row.getString("fproposerid");
            PersonInfo personInfo = new PersonInfo();
            personInfo.setId(BOSUuid.read((String)row.getString("fproposerid")));
            resMap.put("fleavelength", FLeaveLength);
            resMap.put("fnumber", fnumber);
            resMap.put("fname", fname);
            resMap.put("fproposerid", fproposerid);
            list.add(resMap);
        }
        return list;
    }

    public double getCurrentWorkDayType(Map paramMap) throws EASBizException, BOSException {
        String personId = (String)paramMap.get(T_HR_ATS_ATTENDANCERESULT_FPROPOSERID);
        String currDateStr = (String)paramMap.get(T_HR_ATS_ATTENDANCERESULT_FATTENCEDATE);
        Map globalMap = (Map)paramMap.get(GLOBALMAPKEY);
        double value = -1.0;
        AbstractAttendanceFileInfo fileInfo = null;
        if (AttendanceConstants.isUseNew) {
            Map fileInfoObject = (Map)globalMap.get("T_HR_ATS_AttendanceFile");
            if (fileInfoObject != null) {
                fileInfo = (AttendanceFileInfo)fileInfoObject.get(personId + "_" + currDateStr);
            }
            Map policyInfoMap = null;
            AbstractAttencePolicyInfo policy = null;
            if (fileInfo != null && fileInfo.getAttencePolicy() != null && fileInfo.getAttencePolicy().getId() != null && (policyInfoMap = (Map)globalMap.get("T_HR_ATS_AttencePolicy")) != null && policyInfoMap.size() > 0) {
                policy = (AttencePolicyInfo)policyInfoMap.get(fileInfo.getAttencePolicy().getId().toString());
            }
            String workCalendarId = policy != null && policy.getWorkCalendar() != null && policy.getWorkCalendar().getId() != null ? policy.getWorkCalendar().getId().toString() : "";
            Map workCalendarItemInfoMap = null;
            workCalendarItemInfoMap = (Map)globalMap.get("workItemMap");
            if (workCalendarItemInfoMap != null && workCalendarItemInfoMap.size() > 0) {
                WorkCalendarItemInfo workCalendarItemInfo = (WorkCalendarItemInfo)workCalendarItemInfoMap.get(workCalendarId + "_" + currDateStr);
                value = workCalendarItemInfo != null && workCalendarItemInfo.getDayType() != null ? (double)workCalendarItemInfo.getDayType().getValue() : -1.0;
            }
        } else {
            String oql = " select *, attencePolicy.workCalendar\t where proposer ='" + personId + "' ";
            fileInfo = AttendanceFileFactory.getLocalInstance(this.ctx).getAttendanceFileInfo(oql);
            WorkCalendarItemCollection itemsCollection = new WorkCalendarItemCollection();
            if (fileInfo.getAttencePolicy() != null) {
                String workCalendarId = fileInfo.getAttencePolicy().getWorkCalendar().getId().toString();
                WorkCalendarInfo workCalendarInfo = WorkCalendarFactory.getLocalInstance(this.ctx).getWorkCalendarInfo(" where id = '" + workCalendarId + "' ");
                itemsCollection = WorkCalendarItemFactory.getLocalInstance(this.ctx).getWorkCalendarItemCollection(" where calendarGroup = '" + workCalendarInfo.getId() + "' and date='" + currDateStr + "'  ");
            }
            if (itemsCollection.size() > 0) {
                value = itemsCollection.get(0).getDayType().getValue();
            }
            if (itemsCollection.size() == 0) {
                WorkCalendarInfo workInfo = WorkCalendarFactory.getLocalInstance(this.ctx).getWorkCalendarInfo(" where isDefault = 1 ");
                WorkCalendarItemCollection itemsColl = WorkCalendarItemFactory.getLocalInstance(this.ctx).getWorkCalendarItemCollection(" where calendarGroup = '" + workInfo.getId() + "' and date='" + currDateStr + "'  ");
                if (itemsColl.size() > 0) {
                    value = itemsColl.get(0).getDayType().getValue();
                }
            }
        }
        return value;
    }

    public double getTripDay(double unitValue, Map paramMap) throws EASBizException, BOSException, UuidException, SQLException {
        Object[] tripResult;
        AttendanceDynamicResInfo dynamicResInfo;
        String personId = (String)paramMap.get(T_HR_ATS_ATTENDANCERESULT_FPROPOSERID);
        String attendDate = (String)paramMap.get(T_HR_ATS_ATTENDANCERESULT_FATTENCEDATE);
        int unitvalue = BigDecimal.valueOf(unitValue).intValue();
        Map globalMap = (Map)paramMap.get(GLOBALMAPKEY);
        int decimalPlaces = DecimalPlaceUtil.getDecimalPlace(this.ctx, globalMap);
        double tripDay = 0.0;
        AttencePolicyExtInfo attencePolicyExtInfo = AtsCalFunctionUtil.getAttencePolicyExtInfoByResultCal(globalMap, personId, attendDate);
        if (null != attencePolicyExtInfo) {
            globalMap.put("tripLengthCalType", attencePolicyExtInfo.getTripLengthCalType());
        }
        if (null != (dynamicResInfo = AtsCalFunctionUtil.getAttendanceDynamicResInfo(globalMap, personId, attendDate))) {
            globalMap.put("AttendanceDynamicResInfo", dynamicResInfo);
        }
        if (null != (tripResult = AtsCalculateTimeUtil.calTripTime(this.ctx, personId, attendDate, globalMap, false))) {
            double tripTime = (Double)tripResult[0];
            BigDecimal standardHour = (BigDecimal)tripResult[2];
            if (null == standardHour) {
                standardHour = BigDecimal.ZERO;
            }
            if (unitvalue == 1 && standardHour.compareTo(BigDecimal.ZERO) > 0) {
                tripDay = DecimalPlaceUtil.decimalPlaceCtrl(this.ctx, AtsDateUtils.divide(BigDecimal.valueOf(tripTime), standardHour, DecimalPlaceUtil.getDefaultDecimalPlacesCal()), decimalPlaces).doubleValue();
            }
            if (unitvalue == 2) {
                tripDay = DecimalPlaceUtil.decimalPlaceCtrl(this.ctx, BigDecimal.valueOf(tripTime), decimalPlaces).doubleValue();
            }
        }
        return tripDay;
    }

    public double getCurrOTHoursNoCard(String otCompensNumber, double otType, Map paramMap) throws EASBizException, BOSException, UuidException, SQLException {
        double returnValue = 0.0;
        String attendPolicyId = Tools.getInstance().getAttendPolicyid();
        int ottype = BigDecimal.valueOf(otType).intValue();
        String personId = (String)paramMap.get(T_HR_ATS_ATTENDANCERESULT_FPROPOSERID);
        String currDateStr = (String)paramMap.get(T_HR_ATS_ATTENDANCERESULT_FATTENCEDATE);
        Map globalMap = (Map)paramMap.get(GLOBALMAPKEY);
        Map attendanceFileInfoMap = (Map)globalMap.get("T_HR_ATS_AttendanceFile");
        AttendanceFileInfo attendanceFileInfo = attendanceFileInfoMap != null && attendanceFileInfoMap.size() > 0 ? (AttendanceFileInfo)attendanceFileInfoMap.get(personId + "_" + currDateStr) : null;
        Map overTimeTypeInfoMap = (Map)globalMap.get("T_HR_ATS_OverTimeType");
        Map overTimeCompensMap = (Map)globalMap.get("T_HR_ATS_OverTimeCompens");
        Map attencePolicyInfoMap = (Map)globalMap.get("T_HR_ATS_AttencePolicy");
        AttencePolicyInfo attencePolicyInfo = (AttencePolicyInfo)attencePolicyInfoMap.get(attendPolicyId);
        String billOtCompensNumber = "";
        OverTimeTypeInfo overTimeTypeInfo = null;
        OverTimeCompensInfo overTimeCompensInfo = null;
        String overTimeTypeId = "";
        String overTimeCompensId = "";
        int billOtType = 0;
        Map atsOverTimeBillObject = (Map)globalMap.get("T_HR_ATS_OverTimeBillEntry");
        if (atsOverTimeBillObject != null && atsOverTimeBillObject.size() > 0) {
            List list = (List)atsOverTimeBillObject.get(personId + "_" + currDateStr);
            AtsOverTimeBillEntryInfo atsBillEntryInfo = null;
            int listSize = list != null ? list.size() : 0;
            for (int i = 0; i < listSize; ++i) {
                atsBillEntryInfo = (AtsOverTimeBillEntryInfo)list.get(i);
                overTimeTypeId = atsBillEntryInfo != null && atsBillEntryInfo.getOtType() != null && atsBillEntryInfo.getOtType().getId() != null ? atsBillEntryInfo.getOtType().getId().toString() : "";
                overTimeCompensId = atsBillEntryInfo != null && atsBillEntryInfo.getOtCompens() != null && atsBillEntryInfo.getOtCompens().getId() != null ? atsBillEntryInfo.getOtCompens().getId().toString() : "";
                overTimeTypeInfo = (OverTimeTypeInfo)overTimeTypeInfoMap.get(overTimeTypeId);
                overTimeCompensInfo = (OverTimeCompensInfo)overTimeCompensMap.get(overTimeCompensId);
                billOtCompensNumber = overTimeCompensInfo.getNumber();
                billOtType = Integer.parseInt(overTimeTypeInfo.getNumber());
                if (atsBillEntryInfo == null || atsBillEntryInfo.getApplyOTTime() == null) continue;
                if (StringUtils.isNotEmpty((String)otCompensNumber) && ottype != 0 && otCompensNumber.equals(billOtCompensNumber) && ottype == billOtType) {
                    returnValue += atsBillEntryInfo.getApplyOTTime().doubleValue();
                    continue;
                }
                if (StringUtils.isNotEmpty((String)otCompensNumber) && ottype == 0 && otCompensNumber.equals(billOtCompensNumber)) {
                    returnValue += atsBillEntryInfo.getApplyOTTime().doubleValue();
                    continue;
                }
                if (!StringUtils.isNotEmpty((String)otCompensNumber) && ottype != 0 && ottype == billOtType) {
                    returnValue += atsBillEntryInfo.getApplyOTTime().doubleValue();
                    continue;
                }
                if (StringUtils.isNotEmpty((String)otCompensNumber) || ottype != 0) continue;
                returnValue += atsBillEntryInfo.getApplyOTTime().doubleValue();
            }
        }
        if (attendanceFileInfo != null && "1".equals(attendanceFileInfo.getIsAttendance().getValue())) {
            int decimalPlace = DecimalPlaceUtil.getDecimalPlace(this.ctx, globalMap);
            double otStart = attencePolicyInfo.getOtStart();
            otStart = AtsDateUtils.divide(otStart, 60.0, decimalPlace);
            if (returnValue < 0.0 || returnValue < otStart) {
                returnValue = 0.0;
            }
        }
        return returnValue;
    }

    public List find(Context ctx, String sql) throws BOSException, SQLException {
        ArrayList<Object> list = new ArrayList<Object>();
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        ResultSetMetaData mt = rs.getMetaData();
        Object[] cols = null;
        while (rs.next()) {
            if (mt.getColumnCount() == 1) {
                list.add(rs.getObject(1));
                continue;
            }
            cols = new Object[mt.getColumnCount()];
            for (int column = 1; column <= mt.getColumnCount(); ++column) {
                cols[column - 1] = rs.getObject(column);
            }
            list.add(cols);
        }
        return list;
    }

    public double getDateTimeDiff(String beforeDateTime, String afterDateTime, Map paramMap) throws EASBizException, BOSException, UuidException, SQLException {
        List list;
        String sql;
        Object obj;
        String fieldSuff;
        String personId = (String)paramMap.get(T_HR_ATS_ATTENDANCERESULT_FPROPOSERID);
        String currDateStr = (String)paramMap.get(T_HR_ATS_ATTENDANCERESULT_FATTENCEDATE);
        Map globalMap = (Map)paramMap.get(GLOBALMAPKEY);
        Map calResultInfoMap = (Map)globalMap.get("calResultInfoMap");
        String resultInfoKey = MessageFormat.format("{0}{1}{2}", personId, "_", currDateStr);
        boolean resultNotNull = null != calResultInfoMap && null != calResultInfoMap.get(resultInfoKey);
        ArrayList<String> timeList = new ArrayList<String>();
        for (int i = 0; i <= 6; ++i) {
            timeList.add("T_HR_ATS_AttendanceResult_S" + i);
        }
        String beforeTime = null;
        String afterTime = null;
        if (timeList.contains(beforeDateTime) && !timeList.contains(afterDateTime)) {
            fieldSuff = beforeDateTime.substring(beforeDateTime.lastIndexOf("_") + 1, beforeDateTime.length());
            if (AttendanceConstants.isUseNew && resultNotNull) {
                obj = ((Map)calResultInfoMap.get(resultInfoKey)).get(fieldSuff.toUpperCase());
                beforeTime = obj != null ? obj.toString() : null;
            } else {
                sql = "select " + fieldSuff + " from T_HR_ATS_AttendanceResult where FProposerID='" + personId + "'  and  FAttenceDate = {ts '" + currDateStr + "'} ";
                list = this.find(this.ctx, sql.toString());
                if (!list.isEmpty() && list.get(0) != null) {
                    beforeTime = AtsDateUtils.timestampToString((Timestamp)list.get(0));
                }
            }
            if (beforeTime != null) {
                afterTime = AtsDateUtils.getDateFromLongString(beforeTime) + " " + afterDateTime;
            }
        }
        if (timeList.contains(afterDateTime) && !timeList.contains(beforeDateTime)) {
            fieldSuff = afterDateTime.substring(afterDateTime.lastIndexOf("_") + 1, afterDateTime.length());
            if (AttendanceConstants.isUseNew && resultNotNull) {
                obj = ((Map)calResultInfoMap.get(resultInfoKey)).get(fieldSuff.toUpperCase());
                afterTime = obj != null ? obj.toString() : null;
            } else {
                sql = "select " + fieldSuff + " from T_HR_ATS_AttendanceResult where FProposerID='" + personId + "'  and  FAttenceDate = {ts '" + currDateStr + "'} ";
                list = this.find(this.ctx, sql.toString());
                if (!list.isEmpty() && list.get(0) != null) {
                    afterTime = AtsDateUtils.timestampToString((Timestamp)list.get(0));
                }
            }
            if (afterTime != null) {
                beforeTime = AtsDateUtils.getDateFromLongString(afterTime) + " " + beforeDateTime;
            }
        }
        if (timeList.contains(beforeDateTime) && timeList.contains(afterDateTime)) {
            String fieldSuffBef = beforeDateTime.substring(beforeDateTime.lastIndexOf("_") + 1, beforeDateTime.length());
            String fieldSuffAft = afterDateTime.substring(afterDateTime.lastIndexOf("_") + 1, afterDateTime.length());
            if (AttendanceConstants.isUseNew && resultNotNull) {
                Object beforeTimeObj = ((Map)calResultInfoMap.get(resultInfoKey)).get(fieldSuffBef.toUpperCase());
                Object afterTimeObj = ((Map)calResultInfoMap.get(resultInfoKey)).get(fieldSuffAft.toUpperCase());
                beforeTime = beforeTimeObj != null ? beforeTimeObj.toString() : null;
                afterTime = afterTimeObj != null ? afterTimeObj.toString() : null;
            } else {
                Object[] objects;
                String sql2 = "select " + fieldSuffBef + " , " + fieldSuffAft + " from T_HR_ATS_AttendanceResult where FProposerID='" + personId + "'  and  FAttenceDate = {ts '" + currDateStr + "'} ";
                List list2 = this.find(this.ctx, sql2.toString());
                if (!list2.isEmpty() && list2.get(0) != null && (objects = (Object[])list2.get(0)).length > 1) {
                    if (objects[0] != null) {
                        beforeTime = AtsDateUtils.timestampToString((Timestamp)objects[0]);
                    }
                    if (objects[1] != null) {
                        afterTime = AtsDateUtils.timestampToString((Timestamp)objects[1]);
                    }
                }
            }
        }
        if (!timeList.contains(beforeDateTime) && !timeList.contains(afterDateTime)) {
            String beforeTimestr = null;
            String afterTimestr = null;
            beforeTimestr = beforeDateTime.contains(".0") ? beforeDateTime.replaceAll("\\.0", "") : beforeDateTime;
            afterTimestr = afterDateTime.contains(".0") ? afterDateTime.replaceAll("\\.0", "") : afterDateTime;
            if (StringUtils.isNotBlank((String)currDateStr) && beforeTimestr != null && afterTimestr != null) {
                beforeTime = beforeTimestr.length() < 10 ? currDateStr + " " + beforeTimestr : beforeTimestr;
                afterTime = afterTimestr.length() < 10 ? currDateStr + " " + afterTimestr : afterTimestr;
            }
        }
        BigDecimal resValue = BigDecimal.valueOf(0L);
        if (beforeTime != null && afterTime != null) {
            if (beforeTime.length() == 16) {
                beforeTime = beforeTime + ":00";
            }
            if (afterTime.length() == 16) {
                afterTime = afterTime + ":00";
            }
            Timestamp t1 = AtsDateUtils.stringToTimestamp(beforeTime);
            Timestamp t2 = AtsDateUtils.stringToTimestamp(afterTime);
            long diff = t2.getTime() - t1.getTime();
            BigDecimal baseDecimal = BigDecimal.valueOf(60000L);
            BigDecimal diffDecimal = BigDecimal.valueOf(diff);
            int decimalPlace = DecimalPlaceUtil.getDecimalPlace(this.ctx, globalMap);
            resValue = AtsDateUtils.divide(diffDecimal, baseDecimal, decimalPlace);
        }
        return resValue.doubleValue();
    }

    public List getLeaveBillInfo(Map paramMap) throws EASBizException, BOSException {
        ArrayList list = new ArrayList();
        String personId = (String)paramMap.get(T_HR_ATS_ATTENDANCERESULT_FPROPOSERID);
        String currDateStr = (String)paramMap.get(T_HR_ATS_ATTENDANCERESULT_FATTENCEDATE);
        ScheduleShiftCollection scheduleShiftColl = ScheduleShiftFactory.getLocalInstance(this.ctx).getScheduleShiftCollection("where proposer = '" + personId + "' and attendDate = '" + currDateStr + "'");
        return list;
    }

    public String getCustomerOTType(String number, Map paramMap) throws EASBizException, BOSException, UuidException, SQLException {
        String returnValue = "";
        if (AttendanceConstants.isUseNew) {
            Map globalMap = (Map)paramMap.get(GLOBALMAPKEY);
            Map otReasonMap = (Map)globalMap.get("T_HR_ATS_OverTimeReason");
            HashSet idSet = otReasonMap != null && otReasonMap.size() > 0 ? otReasonMap.keySet() : new HashSet();
            OverTimeReasonInfo overReasonInfo = null;
            for (String id : idSet) {
                overReasonInfo = otReasonMap != null ? (OverTimeReasonInfo)otReasonMap.get(id) : null;
                if (overReasonInfo == null || number == null || !number.equals(overReasonInfo.getNumber())) continue;
                returnValue = overReasonInfo.getName();
                break;
            }
        } else {
            OverTimeReasonInfo reasonInfo = this.getOTReasonInfo(number);
            if (reasonInfo != null) {
                returnValue = reasonInfo.getName();
            }
        }
        return returnValue;
    }

    public String getPreviousDayLastCard(Map paramMap, String cycletag) throws ParseException {
        String currDateStr = (String)paramMap.get(T_HR_ATS_ATTENDANCERESULT_FATTENCEDATE);
        String strPreDay = AtsDateUtils.dateShortToString(AtsDateUtils.getPreDay(this.df.parse(currDateStr)));
        return this.getPreviousDayLastCard(strPreDay, paramMap, cycletag);
    }

    public String getPreviousDayLastCard(String strData, Map paramMap, String cycletag) throws ParseException {
        java.sql.Date sqlDate = new java.sql.Date(this.df.parse(strData).getTime());
        String personId = (String)paramMap.get(T_HR_ATS_ATTENDANCERESULT_FPROPOSERID);
        Map globalMap = (Map)paramMap.get(GLOBALMAPKEY);
        Map calResultInfoMap = (Map)globalMap.get("calResultInfoMap");
        String result = "";
        Timestamp timestamp = null;
        String resultInfoKey = MessageFormat.format("{0}{1}{2}", personId, "_", strData);
        if (AttendanceConstants.isUseNew) {
            Object S6 = null;
            Object S5 = null;
            Object S4 = null;
            Object S3 = null;
            Object S2 = null;
            Object S1 = null;
            if (!AtsCollectionUtile.isEmpty(calResultInfoMap) && null != calResultInfoMap.get(resultInfoKey)) {
                Map resultInfo = (Map)calResultInfoMap.get(resultInfoKey);
                S6 = resultInfo.get("S6");
                S5 = resultInfo.get("S5");
                S4 = resultInfo.get("S4");
                S3 = resultInfo.get("S3");
                S2 = resultInfo.get("S2");
                S1 = resultInfo.get("S1");
            }
            if (S1 != null && !StringUtils.isEmpty((String)S1.toString())) {
                if (S1.toString().contains(".0")) {
                    S1 = S1.toString().substring(0, S1.toString().indexOf(".0"));
                }
                Date S1Date = this.sdf.parse(S1.toString());
                timestamp = new Timestamp(S1Date.getTime());
            }
            if (S2 != null && !StringUtils.isEmpty((String)S2.toString())) {
                if (S2.toString().contains(".0")) {
                    S2 = S2.toString().substring(0, S2.toString().indexOf(".0"));
                }
                Date S2Date = this.sdf.parse(S2.toString());
                timestamp = new Timestamp(S2Date.getTime());
            }
            if (S3 != null && !StringUtils.isEmpty((String)S3.toString())) {
                if (S3.toString().contains(".0")) {
                    S3 = S3.toString().substring(0, S3.toString().indexOf(".0"));
                }
                Date S3Date = this.sdf.parse(S3.toString());
                timestamp = new Timestamp(S3Date.getTime());
            }
            if (S4 != null && !StringUtils.isEmpty((String)S4.toString())) {
                if (S4.toString().contains(".0")) {
                    S4 = S4.toString().substring(0, S4.toString().indexOf(".0"));
                }
                Date S4Date = this.sdf.parse(S4.toString());
                timestamp = new Timestamp(S4Date.getTime());
            }
            if (S5 != null && !StringUtils.isEmpty((String)S5.toString())) {
                if (S5.toString().contains(".0")) {
                    S5 = S5.toString().substring(0, S5.toString().indexOf(".0"));
                }
                Date S5Date = this.sdf.parse(S5.toString());
                timestamp = new Timestamp(S5Date.getTime());
            }
            if (S6 != null && !StringUtils.isEmpty((String)S6.toString())) {
                if (S6.toString().contains(".0")) {
                    S6 = S6.toString().substring(0, S6.toString().indexOf(".0"));
                }
                Date S6Date = this.sdf.parse(S6.toString());
                timestamp = new Timestamp(S6Date.getTime());
            }
        } else {
            Object[] params = new Object[]{personId, sqlDate};
            String sql = "select S1,S2,S3,S4,S5,S6 from t_hr_ats_attendanceresult where fproposerid = ? and fattencedate = ?";
            try {
                IRowSet row = DbUtil.executeQuery((Context)this.ctx, (String)sql, (Object[])params);
                while (row.next()) {
                    if (row.getTimestamp("S6") != null) {
                        timestamp = row.getTimestamp("S6");
                        continue;
                    }
                    if (row.getTimestamp("S5") != null) {
                        timestamp = row.getTimestamp("S5");
                        continue;
                    }
                    if (row.getTimestamp("S4") != null) {
                        timestamp = row.getTimestamp("S4");
                        continue;
                    }
                    if (row.getTimestamp("S3") != null) {
                        timestamp = row.getTimestamp("S3");
                        continue;
                    }
                    if (row.getTimestamp("S2") != null) {
                        timestamp = row.getTimestamp("S2");
                        continue;
                    }
                    if (row.getTimestamp("S1") == null) continue;
                    timestamp = row.getTimestamp("S1");
                }
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        if (timestamp != null) {
            int tag = 0;
            if (!StringUtils.isEmpty((String)cycletag)) {
                tag = new BigDecimal(cycletag).intValue();
            }
            result = tag == 0 ? AtsDateUtils.getHourMinFromString(AtsDateUtils.timestampToString(timestamp)) : (tag == 1 ? AtsDateUtils.timestampToString(timestamp) : "-1");
        }
        return result;
    }

    public double getCustomerOTHours(String number, Map paramMap) throws EASBizException, BOSException, UuidException, SQLException {
        double returnValue;
        block6: {
            int decimalPlaces;
            String currDateStr;
            String personId;
            block5: {
                List list;
                Map atsOverTimeBillObject;
                returnValue = 0.0;
                personId = (String)paramMap.get(T_HR_ATS_ATTENDANCERESULT_FPROPOSERID);
                currDateStr = (String)paramMap.get(T_HR_ATS_ATTENDANCERESULT_FATTENCEDATE);
                Map globalMap = (Map)paramMap.get(GLOBALMAPKEY);
                decimalPlaces = DecimalPlaceUtil.getDecimalPlace(this.ctx, globalMap);
                if (!AttendanceConstants.isUseNew) break block5;
                Map overTimeReasonMap = (Map)globalMap.get("T_HR_ATS_OverTimeReason");
                HashSet set = overTimeReasonMap != null && overTimeReasonMap.size() > 0 ? overTimeReasonMap.keySet() : new HashSet();
                OverTimeReasonInfo overReasonInfo = null;
                String reasonId = "";
                for (String id : set) {
                    overReasonInfo = (OverTimeReasonInfo)overTimeReasonMap.get(id);
                    if (!number.equals(overReasonInfo.getNumber())) continue;
                    reasonId = overReasonInfo.getId().toString();
                    break;
                }
                if ((atsOverTimeBillObject = (Map)globalMap.get("T_HR_ATS_OverTimeBillEntry")) == null || atsOverTimeBillObject.size() <= 0 || (list = (List)atsOverTimeBillObject.get(personId + "_" + currDateStr)) == null) break block6;
                int listSize = list.size();
                OverTimeReasonInfo innerInfo = null;
                for (int j = 0; j < listSize; ++j) {
                    BigDecimal applyOTTime = ((AtsOverTimeBillEntryInfo)list.get(j)).getApplyOTTime();
                    applyOTTime = DecimalPlaceUtil.decimalPlaceCtrl(this.ctx, applyOTTime, decimalPlaces);
                    OverTimeReasonInfo overTimeReasonInfo = innerInfo = list.get(j) != null ? ((AtsOverTimeBillEntryInfo)list.get(j)).getOtReason() : null;
                    if (innerInfo == null || innerInfo.getId() == null || !innerInfo.getId().toString().equals(reasonId)) continue;
                    returnValue += applyOTTime.doubleValue();
                }
                break block6;
            }
            List<AtsOverTimeBillInfo> ovetTimeList = AtsServerUtils.getOverTimeBillInfosByOTDate(this.ctx, personId, currDateStr, 0);
            OverTimeReasonInfo reasonInfo = this.getOTReasonInfo(number);
            String reasonId = "";
            if (reasonInfo != null) {
                reasonId = reasonInfo.getId().toString();
            }
            for (int i = 0; i < ovetTimeList.size(); ++i) {
                AtsOverTimeBillInfo billInfo = ovetTimeList.get(i);
                AtsOverTimeBillEntryCollection entryColl = billInfo.getEntries();
                for (int j = 0; j < entryColl.size(); ++j) {
                    BigDecimal applyOTTime = entryColl.get(j).getApplyOTTime();
                    applyOTTime = DecimalPlaceUtil.decimalPlaceCtrl(this.ctx, applyOTTime, decimalPlaces);
                    OverTimeReasonInfo innerInfo = entryColl.get(j).getOtReason();
                    if (innerInfo == null || innerInfo.getId() == null || !innerInfo.getId().toString().equals(reasonId)) continue;
                    returnValue += applyOTTime.doubleValue();
                }
            }
        }
        return returnValue;
    }

    public OverTimeReasonInfo getOTReasonInfo(String number) throws EASBizException, BOSException, UuidException, SQLException {
        OverTimeReasonInfo info = null;
        String oql = " where  number = '" + number + "' ";
        OverTimeReasonCollection resonColl = OverTimeReasonFactory.getLocalInstance(this.ctx).getOverTimeReasonCollection(oql);
        if (resonColl.size() > 0) {
            info = resonColl.get(0);
        }
        return info;
    }

    public String getCurrentCalDate(Map paramMap) {
        String currDateStr = (String)paramMap.get(T_HR_ATS_ATTENDANCERESULT_FATTENCEDATE);
        return currDateStr;
    }

    public String getCurrentCalWeekday(Map paramMap) {
        String currDateStr = (String)paramMap.get(T_HR_ATS_ATTENDANCERESULT_FATTENCEDATE);
        if (StringUtils.isEmpty((String)currDateStr)) {
            return "";
        }
        return AtsDateUtils.getWeekOfDate(this.ctx, currDateStr);
    }

    public double getFillSignCardTimesByScheduleShift(String reasonNumber, Map paramMap) {
        AttendanceFileInfo attendanceFileInfo;
        int resvalue = 0;
        long dayMs = 86400000L;
        long hourMs = 3600000L;
        String personId = (String)paramMap.get(T_HR_ATS_ATTENDANCERESULT_FPROPOSERID);
        String currDateStr = (String)paramMap.get(T_HR_ATS_ATTENDANCERESULT_FATTENCEDATE);
        String key = personId + "_" + currDateStr;
        String keyPre = personId + "_" + AtsDateUtils.getPreDay(currDateStr);
        String keyNext = personId + "_" + AtsDateUtils.getNextDay(currDateStr);
        Map globalMap = (Map)paramMap.get(GLOBALMAPKEY);
        Map scheduleShiftItemMap = (Map)globalMap.get("T_HR_ATS_ScheduleShift");
        Map cardRuleSingleInfoMap = (Map)globalMap.get("T_HR_ATS_CardRule");
        Map attendanceFileInfoMap = (Map)globalMap.get("T_HR_ATS_AttendanceFile");
        Map allShiftInfoMap = (Map)globalMap.get("T_HR_ATS_Shift");
        Map fillSignCardInfosMap = (Map)globalMap.get("fillSignCardInfosMap");
        List scheduleShiftList = (List)scheduleShiftItemMap.get(key);
        AtsShiftInfo atsShiftInfo = null;
        CardRuleInfo cardRuleInfo = null;
        Timestamp shiftBeginTime = null;
        Timestamp shiftEndTime = null;
        if (scheduleShiftList != null) {
            if (((ScheduleShiftInfo)scheduleShiftList.get(0)).getCardRule() != null) {
                cardRuleInfo = (CardRuleInfo)cardRuleSingleInfoMap.get(((ScheduleShiftInfo)scheduleShiftList.get(0)).getCardRule().getId().toString());
            }
            if (((ScheduleShiftInfo)scheduleShiftList.get(0)).getItems().size() > 0) {
                shiftBeginTime = ((ScheduleShiftInfo)scheduleShiftList.get(0)).getItems().get(0).getPreDateTime();
                shiftEndTime = ((ScheduleShiftInfo)scheduleShiftList.get(0)).getItems().get(((ScheduleShiftInfo)scheduleShiftList.get(0)).getItems().size() - 1).getNextDateTime();
                if (shiftBeginTime == null || shiftEndTime == null) {
                    attendanceFileInfo = (AttendanceFileInfo)attendanceFileInfoMap.get(key);
                    atsShiftInfo = (AtsShiftInfo)allShiftInfoMap.get(attendanceFileInfo.getAtsShift().getId().toString());
                    cardRuleInfo = ((ScheduleShiftInfo)scheduleShiftList.get(0)).getCardRule() != null ? (CardRuleInfo)cardRuleSingleInfoMap.get(((ScheduleShiftInfo)scheduleShiftList.get(0)).getCardRule().getId().toString()) : (CardRuleInfo)cardRuleSingleInfoMap.get(atsShiftInfo.getCardRule().getId().toString());
                }
            } else if (((ScheduleShiftInfo)scheduleShiftList.get(0)).getDefaultShift() != null) {
                atsShiftInfo = (AtsShiftInfo)allShiftInfoMap.get(((ScheduleShiftInfo)scheduleShiftList.get(0)).getDefaultShift().getId().toString());
            } else {
                attendanceFileInfo = (AttendanceFileInfo)attendanceFileInfoMap.get(key);
                atsShiftInfo = (AtsShiftInfo)allShiftInfoMap.get(attendanceFileInfo.getAtsShift().getId().toString());
                cardRuleInfo = ((ScheduleShiftInfo)scheduleShiftList.get(0)).getCardRule() != null ? (CardRuleInfo)cardRuleSingleInfoMap.get(((ScheduleShiftInfo)scheduleShiftList.get(0)).getCardRule().getId().toString()) : (CardRuleInfo)cardRuleSingleInfoMap.get(atsShiftInfo.getCardRule().getId().toString());
            }
        } else {
            attendanceFileInfo = (AttendanceFileInfo)attendanceFileInfoMap.get(key);
            atsShiftInfo = (AtsShiftInfo)allShiftInfoMap.get(attendanceFileInfo.getAtsShift().getId().toString());
            cardRuleInfo = (CardRuleInfo)cardRuleSingleInfoMap.get(atsShiftInfo.getCardRule().getId().toString());
        }
        if (atsShiftInfo != null) {
            String preTime = null;
            String nextTime = null;
            int preTimeDayType = 1;
            int nextTimeDayType = 1;
            Date tempDate = AtsDateUtils.stringToShortDate(currDateStr);
            int size = atsShiftInfo.getItems().size();
            if (size > 0) {
                for (int i = 0; i < size; ++i) {
                    if (atsShiftInfo.getItems().get(i).getSegment().getValue().equals("1")) {
                        preTime = atsShiftInfo.getItems().get(i).getPreTime();
                        preTimeDayType = atsShiftInfo.getItems().get(i).getPreTimeDayType().getValue();
                    }
                    if (!atsShiftInfo.getItems().get(i).getSegment().getValue().equals("" + size + "")) continue;
                    nextTime = atsShiftInfo.getItems().get(i).getNextTime();
                    nextTimeDayType = atsShiftInfo.getItems().get(i).getNextTimeDayType().getValue();
                }
                if (preTimeDayType == 0) {
                    shiftBeginTime = AtsDateUtils.stringToTimestamp(AtsDateUtils.dateShortToString(new Date(tempDate.getTime() - dayMs)) + " " + preTime + ":00.0");
                } else if (preTimeDayType == 1) {
                    shiftBeginTime = AtsDateUtils.stringToTimestamp(currDateStr + " " + preTime + ":00.0");
                } else if (preTimeDayType == 2) {
                    shiftBeginTime = AtsDateUtils.stringToTimestamp(AtsDateUtils.dateShortToString(new Date(tempDate.getTime() + dayMs)) + " " + preTime + ":00.0");
                }
                if (nextTimeDayType == 0) {
                    shiftEndTime = AtsDateUtils.stringToTimestamp(AtsDateUtils.dateShortToString(new Date(tempDate.getTime() - dayMs)) + " " + nextTime + ":00.0");
                } else if (nextTimeDayType == 1) {
                    shiftEndTime = AtsDateUtils.stringToTimestamp(currDateStr + " " + nextTime + ":00.0");
                } else if (nextTimeDayType == 2) {
                    shiftEndTime = AtsDateUtils.stringToTimestamp(AtsDateUtils.dateShortToString(new Date(tempDate.getTime() + dayMs)) + " " + nextTime + ":00.0");
                }
            } else {
                return resvalue;
            }
        }
        Timestamp compareBeginTime = null;
        Timestamp compareEndTime = null;
        if (shiftBeginTime != null && shiftEndTime != null && cardRuleInfo != null) {
            int i;
            int size;
            compareBeginTime = new Timestamp(shiftBeginTime.getTime() - cardRuleInfo.getStartNum().multiply(BigDecimal.valueOf(hourMs)).longValue());
            compareEndTime = new Timestamp(shiftEndTime.getTime() + cardRuleInfo.getEndNum().multiply(BigDecimal.valueOf(hourMs)).longValue());
            ArrayList<Timestamp> timeList = new ArrayList<Timestamp>(100);
            ArrayList<FillSignCardInfo> fillSignCardList = new ArrayList<FillSignCardInfo>(100);
            FillSignCardInfo fillSignCardInfo = null;
            if (fillSignCardInfosMap.get(key) != null) {
                size = ((List)fillSignCardInfosMap.get(key)).size();
                for (i = 0; i < size; ++i) {
                    fillSignCardInfo = (FillSignCardInfo)((List)fillSignCardInfosMap.get(key)).get(i);
                    if (timeList.contains(fillSignCardInfo.getEntries().get(0).getFillCardTime())) continue;
                    fillSignCardList.add(fillSignCardInfo);
                    timeList.add(fillSignCardInfo.getEntries().get(0).getFillCardTime());
                }
            }
            if (fillSignCardInfosMap.get(keyPre) != null) {
                size = ((List)fillSignCardInfosMap.get(keyPre)).size();
                for (i = 0; i < size; ++i) {
                    fillSignCardInfo = (FillSignCardInfo)((List)fillSignCardInfosMap.get(keyPre)).get(i);
                    if (timeList.contains(fillSignCardInfo.getEntries().get(0).getFillCardTime())) continue;
                    fillSignCardList.add(fillSignCardInfo);
                    timeList.add(fillSignCardInfo.getEntries().get(0).getFillCardTime());
                }
            }
            if (fillSignCardInfosMap.get(keyNext) != null) {
                size = ((List)fillSignCardInfosMap.get(keyNext)).size();
                for (i = 0; i < size; ++i) {
                    fillSignCardInfo = (FillSignCardInfo)((List)fillSignCardInfosMap.get(keyNext)).get(i);
                    if (timeList.contains(fillSignCardInfo.getEntries().get(0).getFillCardTime())) continue;
                    fillSignCardList.add(fillSignCardInfo);
                    timeList.add(fillSignCardInfo.getEntries().get(0).getFillCardTime());
                }
            }
            if (fillSignCardList != null && fillSignCardList.size() > 0) {
                for (i = 0; i < fillSignCardList.size(); ++i) {
                    for (int j = 0; j < ((FillSignCardInfo)fillSignCardList.get(i)).getEntries().size(); ++j) {
                        if (((FillSignCardInfo)fillSignCardList.get(i)).getEntries().get(j).getFillCardTime().getTime() < compareBeginTime.getTime() || ((FillSignCardInfo)fillSignCardList.get(i)).getEntries().get(j).getFillCardTime().getTime() > compareEndTime.getTime()) continue;
                        if (StringUtils.isBlank((String)reasonNumber)) {
                            ++resvalue;
                            continue;
                        }
                        if (!((FillSignCardInfo)fillSignCardList.get(i)).getEntries().get(j).getReason().getNumber().equals(reasonNumber)) continue;
                        ++resvalue;
                    }
                }
            }
        } else {
            return resvalue;
        }
        return resvalue;
    }

    public double getFillSignCardTimes(String reasonNumber, Map paramMap) throws EASBizException, BOSException, UuidException, SQLException {
        String personId = (String)paramMap.get(T_HR_ATS_ATTENDANCERESULT_FPROPOSERID);
        String currDateStr = (String)paramMap.get(T_HR_ATS_ATTENDANCERESULT_FATTENCEDATE);
        int resvalue = 0;
        if (AttendanceConstants.isUseNew) {
            Map globalMap = (Map)paramMap.get(GLOBALMAPKEY);
            Map fillSignObject = (Map)globalMap.get("fillSignCardInfosMap");
            List list = fillSignObject != null && fillSignObject.size() > 0 ? (List)fillSignObject.get(personId + "_" + currDateStr) : null;
            int listSize = list != null ? list.size() : 0;
            FillSignCardEntryInfo fillCardEntryInfo = null;
            for (int i = 0; i < listSize; ++i) {
                if (list.get(i) == null || ((FillSignCardInfo)list.get(i)).getEntries() == null) continue;
                int entrySize = ((FillSignCardInfo)list.get(i)).getEntries().size();
                for (int j = 0; j < entrySize; ++j) {
                    fillCardEntryInfo = ((FillSignCardInfo)list.get(i)).getEntries().get(j);
                    if (fillCardEntryInfo == null || fillCardEntryInfo.getReason() == null || fillCardEntryInfo.getReason().getId() == null || !fillCardEntryInfo.getReason().getNumber().equals(reasonNumber)) continue;
                    ++resvalue;
                }
            }
        } else {
            FillSignReasonInfo info = null;
            String oql = " where  number = '" + reasonNumber + "' ";
            FillSignReasonCollection coll = FillSignReasonFactory.getLocalInstance(this.ctx).getFillSignReasonCollection(oql);
            if (coll.size() > 0) {
                info = coll.get(0);
            }
            String reasonid = "";
            if (info != null) {
                reasonid = info.getId().toString();
            }
            StringBuffer sb = new StringBuffer();
            sb.append(" select count(1) as sumcount from t_hr_ats_fillsigncardentry entry ");
            sb.append(" inner join t_hr_ats_fillsigncard  bill on bill.FID = entry.FBillID ");
            sb.append(" where entry.fpersonid='" + personId + "' ");
            sb.append(" and entry.fattenddate = {ts '" + currDateStr + "'} ");
            sb.append(" and  entry.freasonid='" + reasonid + "' ");
            sb.append(" and  bill.FBillState='3' ");
            IRowSet row = DbUtil.executeQuery((Context)this.ctx, (String)sb.toString());
            while (row.next()) {
                resvalue = row.getInt("sumcount");
            }
        }
        return resvalue;
    }

    public double getWorkCalendarWorkDays(String name, String beginDate, String endDate, Map paramMap) throws EASBizException, BOSException {
        String personId = (String)paramMap.get(T_HR_ATS_ATTENDANCERESULT_FPROPOSERID);
        if (StringUtils.isEmpty((String)personId)) {
            personId = (String)paramMap.get(T_HR_SCMPCALTABLE_FPERSONID);
        }
        String currDateStr = (String)paramMap.get(T_HR_ATS_ATTENDANCERESULT_FATTENCEDATE);
        String dayType = "0";
        if (paramMap.get(DAYTYPE) != null) {
            dayType = (String)paramMap.get(DAYTYPE);
        }
        if (StringUtils.isEmpty((String)currDateStr)) {
            currDateStr = endDate;
        }
        beginDate = AtsDateUtils.getDateFromLongString(beginDate);
        endDate = AtsDateUtils.getDateFromLongString(endDate);
        double workdays = -1.0;
        IRowSet rs = null;
        try {
            StringBuffer sb;
            if ("3".equals(dayType)) {
                sb = new StringBuffer();
                sb.append(" SELECT COUNT(1) CNT FROM T_HR_ATS_WorkCalendar A ").append(" INNER JOIN T_HR_ATS_WorkCalendarITEM B  ").append(" ON A.FID = B.FCALENDARGROUPID ").append(" WHERE A.FNUMBER = ? AND B.FDATE >= ? AND B.FDATE <= ? ");
                rs = DbUtil.executeQuery((Context)this.ctx, (String)sb.toString(), (Object[])new Object[]{name, new Timestamp(AtsDateUtils.stringToShortDate(beginDate).getTime()), new Timestamp(AtsDateUtils.stringToShortDate(beginDate).getTime())});
                if (rs == null) {
                    sb = new StringBuffer();
                    sb.append(" SELECT COUNT(1) CNT FROM T_HR_ATS_WorkCalendar A ").append(" INNER JOIN T_HR_ATS_WorkCalendarITEM B  ").append(" ON A.FID = B.FCALENDARGROUPID ").append(" WHERE ( A.FName_").append(LocaleUtils.locale_l1.getDisplayName()).append(" = ? ").append(" or A.FName_").append(LocaleUtils.locale_l2.getDisplayName()).append(" = ? ").append(" or A.FName_").append(LocaleUtils.locale_l3.getDisplayName()).append(" = ?) ").append(" AND B.FDATE >= ? AND B.FDATE <= ? ");
                    rs = DbUtil.executeQuery((Context)this.ctx, (String)sb.toString(), (Object[])new Object[]{name, name, name, new Timestamp(AtsDateUtils.stringToShortDate(beginDate).getTime()), new Timestamp(AtsDateUtils.stringToShortDate(beginDate).getTime())});
                }
            } else {
                sb = new StringBuffer();
                sb.append(" SELECT COUNT(1) CNT FROM T_HR_ATS_WorkCalendar A ").append(" INNER JOIN T_HR_ATS_WorkCalendarITEM B  ").append(" ON A.FID = B.FCALENDARGROUPID ").append(" WHERE A.FNUMBER = ? AND B.FdayType = ? AND B.FDATE >= ? AND B.FDATE <= ? ");
                rs = DbUtil.executeQuery((Context)this.ctx, (String)sb.toString(), (Object[])new Object[]{name, dayType, new Timestamp(AtsDateUtils.stringToShortDate(beginDate).getTime()), new Timestamp(AtsDateUtils.stringToShortDate(beginDate).getTime())});
                if (rs == null) {
                    sb = new StringBuffer();
                    sb.append(" SELECT COUNT(1) CNT FROM T_HR_ATS_WorkCalendar A ").append(" INNER JOIN T_HR_ATS_WorkCalendarITEM B  ").append(" ON A.FID = B.FCALENDARGROUPID ").append(" WHERE ( A.FName_").append(LocaleUtils.locale_l1.getDisplayName()).append(" = ? ").append(" or A.FName_").append(LocaleUtils.locale_l2.getDisplayName()).append(" = ? ").append(" or A.FName_").append(LocaleUtils.locale_l3.getDisplayName()).append(" = ?) ").append(" AND B.FdayType = ? AND B.FDATE >= ? AND B.FDATE <= ? ");
                    rs = DbUtil.executeQuery((Context)this.ctx, (String)sb.toString(), (Object[])new Object[]{name, name, name, dayType, new Timestamp(AtsDateUtils.stringToShortDate(beginDate).getTime()), new Timestamp(AtsDateUtils.stringToShortDate(beginDate).getTime())});
                }
            }
            if (rs != null && rs.next()) {
                workdays = rs.getInt("CNT");
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        if (workdays == -1.0) {
            String workCalid = "";
            String ooql = "select id,attendPolicy.workCalendar.id  where proposer ='" + personId + "'  and attendDate = {ts '" + currDateStr + "' }";
            ScheduleShiftCollection scheduleColl = ScheduleShiftFactory.getLocalInstance(this.ctx).getScheduleShiftCollection(ooql);
            if (scheduleColl.size() > 0) {
                workCalid = scheduleColl.get(0).getAttendPolicy().getWorkCalendar().getId().toString();
            }
            if (scheduleColl.size() == 0) {
                String fileoql = " select id,attendPolicy.workCalendar.id where proposer ='" + personId + "' and fileType <> '2' and attendFileState='1'  ";
                AttendanceFileCollection fileColl = AttendanceFileFactory.getLocalInstance(this.ctx).getAttendanceFileCollection(fileoql);
                if (fileColl.size() > 0 && fileColl.get(0).getAttencePolicy().getWorkCalendar() != null) {
                    workCalid = fileColl.get(0).getAttencePolicy().getWorkCalendar().getId().toString();
                }
            }
            if (StringUtils.isNotBlank((String)workCalid)) {
                try {
                    StringBuffer sb;
                    if ("3".equals(dayType)) {
                        sb = new StringBuffer();
                        sb.append(" SELECT COUNT(1) CNT FROM T_HR_ATS_WorkCalendarITEM B  ").append(" WHERE B.FCALENDARGROUPID = ? AND B.FDATE >= ? AND B.FDATE <= ? ");
                        rs = DbUtil.executeQuery((Context)this.ctx, (String)sb.toString(), (Object[])new Object[]{workCalid, new Timestamp(AtsDateUtils.stringToShortDate(beginDate).getTime()), new Timestamp(AtsDateUtils.stringToShortDate(beginDate).getTime())});
                    } else {
                        sb = new StringBuffer();
                        sb.append(" SELECT COUNT(1) CNT FROM T_HR_ATS_WorkCalendarITEM B  ").append(" WHERE B.FCALENDARGROUPID = ? AND B.FdayType = ? AND B.FDATE >= ? AND B.FDATE <= ? ");
                        rs = DbUtil.executeQuery((Context)this.ctx, (String)sb.toString(), (Object[])new Object[]{workCalid, dayType, new Timestamp(AtsDateUtils.stringToShortDate(beginDate).getTime()), new Timestamp(AtsDateUtils.stringToShortDate(beginDate).getTime())});
                    }
                    if (rs != null && rs.next()) {
                        workdays = rs.getInt("CNT");
                    }
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
        return workdays;
    }

    public static Map<String, BigDecimal> getTripBillDaysAndTimes(Context ctx, String personid, String attendDate, Map<String, String> scheduleResultMap, AtsShiftInfo shiftInfo, Map<String, Object> globalMap) throws BOSException, UuidException, SQLException {
        HashMap<String, BigDecimal> resMap = new HashMap<String, BigDecimal>();
        int decimalPlaces = DecimalPlaceUtil.getDecimalPlace(ctx, globalMap);
        int shiftTimeTag = Integer.parseInt(scheduleResultMap.get("shiftTimeTag"));
        Map atsTripBillObject = (Map)globalMap.get("T_HR_ATS_TripBillEntry");
        List list = (List)atsTripBillObject.get(personid + "_" + attendDate);
        BigDecimal tripBillHoursres = BigDecimal.valueOf(0L);
        AtsTripBillEntryInfo row = null;
        ArrayList tripbillList = new ArrayList();
        BigDecimal standardHour = new BigDecimal(scheduleResultMap.get("standardHour"));
        int listSize = list != null ? list.size() : 0;
        for (int i = 0; i < listSize; ++i) {
            double two;
            row = (AtsTripBillEntryInfo)list.get(i);
            Timestamp beginTime = row.getTripStartTime();
            Timestamp endTime = row.getTripEndTime();
            String oneOnScheTime = scheduleResultMap.get("oneOnTimeSchedule");
            String oneOffScheTime = scheduleResultMap.get("oneOffTimeSchedule");
            Timestamp oneOnScheduleTime = AtsDateUtils.stringToTimestamp(oneOnScheTime);
            Timestamp oneOffScheduleTime = AtsDateUtils.stringToTimestamp(oneOffScheTime);
            String twoOnScheTime = scheduleResultMap.get("twoOnTimeSchedule");
            String twoOffScheTime = scheduleResultMap.get("twoOffTimeSchedule");
            Timestamp twoOnScheduleTime = AtsDateUtils.stringToTimestamp(twoOnScheTime);
            Timestamp twoOffScheduleTime = AtsDateUtils.stringToTimestamp(twoOffScheTime);
            String threeOnScheTime = scheduleResultMap.get("threeOnTimeSchedule");
            String threeOffScheTime = scheduleResultMap.get("threeOffTimeSchedule");
            Timestamp threeOnScheduleTime = AtsDateUtils.stringToTimestamp(threeOnScheTime);
            Timestamp threeOffScheduleTime = AtsDateUtils.stringToTimestamp(threeOffScheTime);
            Timestamp calbeginDate = null;
            Timestamp calendDate = null;
            double mixedValue = 0.0;
            int shiftSize = Integer.parseInt(scheduleResultMap.get("shiftSize"));
            if (shiftTimeTag == 1) {
                shiftSize = -1;
            }
            if (shiftSize == -1) {
                double tripDays = row.getTripDays().doubleValue();
                if (tripDays > 1.0) {
                    tripDays = 1.0;
                }
                mixedValue = tripDays * standardHour.doubleValue();
            }
            if (shiftSize == 1) {
                if (beginTime.getTime() <= oneOnScheduleTime.getTime() && endTime.getTime() >= oneOffScheduleTime.getTime()) {
                    mixedValue = standardHour.doubleValue();
                    BigDecimal minuteBig = BigDecimal.valueOf(mixedValue).multiply(BigDecimal.valueOf(60L));
                    mixedValue = AtsDateUtils.divide(minuteBig.doubleValue(), 60.0, decimalPlaces);
                } else {
                    double one;
                    if (beginTime.getTime() <= oneOnScheduleTime.getTime() && endTime.getTime() <= oneOnScheduleTime.getTime()) {
                        calbeginDate = null;
                        calendDate = null;
                        mixedValue = 0.0;
                    }
                    if (beginTime.getTime() <= oneOnScheduleTime.getTime() && oneOnScheduleTime.getTime() < endTime.getTime() && endTime.getTime() <= oneOffScheduleTime.getTime()) {
                        calbeginDate = oneOnScheduleTime;
                        calendDate = endTime;
                        mixedValue = one = AtsDateUtils.getTwoTimeDiffMinutes(AtsDateUtils.dateLongToString(oneOnScheduleTime), AtsDateUtils.dateLongToString(endTime));
                    }
                    if (beginTime.getTime() <= oneOnScheduleTime.getTime() && oneOffScheduleTime.getTime() < endTime.getTime()) {
                        mixedValue = one = AtsDateUtils.getTwoTimeDiffMinutes(AtsDateUtils.dateLongToString(oneOnScheduleTime), AtsDateUtils.dateLongToString(oneOffScheduleTime));
                    }
                    if (oneOnScheduleTime.getTime() < beginTime.getTime() && beginTime.getTime() <= oneOffScheduleTime.getTime() && endTime.getTime() <= oneOffScheduleTime.getTime()) {
                        mixedValue = one = AtsDateUtils.getTwoTimeDiffMinutes(AtsDateUtils.dateLongToString(beginTime), AtsDateUtils.dateLongToString(endTime));
                    }
                    if (oneOnScheduleTime.getTime() < beginTime.getTime() && beginTime.getTime() <= oneOffScheduleTime.getTime() && oneOffScheduleTime.getTime() < endTime.getTime()) {
                        mixedValue = one = AtsDateUtils.getTwoTimeDiffMinutes(AtsDateUtils.dateLongToString(beginTime), AtsDateUtils.dateLongToString(oneOffScheduleTime));
                    }
                    if (oneOffScheduleTime.getTime() < beginTime.getTime() && endTime.getTime() > oneOffScheduleTime.getTime()) {
                        mixedValue = 0.0;
                    }
                    mixedValue = AtsDateUtils.divide(mixedValue, 60.0, decimalPlaces);
                }
            }
            if (shiftSize == 2) {
                if (beginTime.getTime() <= oneOnScheduleTime.getTime() && endTime.getTime() >= twoOffScheduleTime.getTime()) {
                    mixedValue = standardHour.doubleValue();
                    BigDecimal minuteBig = BigDecimal.valueOf(mixedValue).multiply(BigDecimal.valueOf(60L));
                    mixedValue = AtsDateUtils.divide(minuteBig.doubleValue(), 60.0, decimalPlaces);
                } else {
                    if (beginTime.getTime() <= oneOnScheduleTime.getTime() && endTime.getTime() <= oneOnScheduleTime.getTime()) {
                        calbeginDate = null;
                        calendDate = null;
                        mixedValue = 0.0;
                    }
                    if (beginTime.getTime() <= oneOnScheduleTime.getTime() && oneOnScheduleTime.getTime() < endTime.getTime() && endTime.getTime() <= oneOffScheduleTime.getTime()) {
                        double one;
                        calbeginDate = oneOnScheduleTime;
                        calendDate = endTime;
                        mixedValue = one = AtsDateUtils.getTwoTimeDiffMinutes(AtsDateUtils.dateLongToString(oneOnScheduleTime), AtsDateUtils.dateLongToString(endTime));
                    }
                    if (beginTime.getTime() <= oneOnScheduleTime.getTime() && oneOffScheduleTime.getTime() < endTime.getTime() && endTime.getTime() <= twoOnScheduleTime.getTime()) {
                        double one;
                        calbeginDate = oneOnScheduleTime;
                        calendDate = oneOffScheduleTime;
                        mixedValue = one = AtsDateUtils.getTwoTimeDiffMinutes(AtsDateUtils.dateLongToString(oneOnScheduleTime), AtsDateUtils.dateLongToString(oneOffScheduleTime));
                    }
                    if (beginTime.getTime() <= oneOnScheduleTime.getTime() && twoOnScheduleTime.getTime() < endTime.getTime() && endTime.getTime() <= twoOffScheduleTime.getTime()) {
                        double one = AtsDateUtils.getTwoTimeDiffMinutes(AtsDateUtils.dateLongToString(oneOnScheduleTime), AtsDateUtils.dateLongToString(oneOffScheduleTime));
                        two = AtsDateUtils.getTwoTimeDiffMinutes(AtsDateUtils.dateLongToString(twoOnScheduleTime), AtsDateUtils.dateLongToString(endTime));
                        mixedValue = one + two;
                    }
                    if (beginTime.getTime() <= oneOnScheduleTime.getTime() && twoOffScheduleTime.getTime() < endTime.getTime()) {
                        double one = AtsDateUtils.getTwoTimeDiffMinutes(AtsDateUtils.dateLongToString(oneOnScheduleTime), AtsDateUtils.dateLongToString(oneOffScheduleTime));
                        two = AtsDateUtils.getTwoTimeDiffMinutes(AtsDateUtils.dateLongToString(twoOnScheduleTime), AtsDateUtils.dateLongToString(twoOffScheduleTime));
                        mixedValue = one + two;
                    }
                    if (oneOnScheduleTime.getTime() < beginTime.getTime() && beginTime.getTime() <= oneOffScheduleTime.getTime() && endTime.getTime() <= oneOffScheduleTime.getTime()) {
                        double one;
                        mixedValue = one = AtsDateUtils.getTwoTimeDiffMinutes(AtsDateUtils.dateLongToString(beginTime), AtsDateUtils.dateLongToString(endTime));
                    }
                    if (oneOnScheduleTime.getTime() < beginTime.getTime() && beginTime.getTime() <= oneOffScheduleTime.getTime() && oneOffScheduleTime.getTime() < endTime.getTime() && endTime.getTime() <= twoOnScheduleTime.getTime()) {
                        double one;
                        mixedValue = one = AtsDateUtils.getTwoTimeDiffMinutes(AtsDateUtils.dateLongToString(beginTime), AtsDateUtils.dateLongToString(oneOffScheduleTime));
                    }
                    if (oneOnScheduleTime.getTime() < beginTime.getTime() && beginTime.getTime() <= oneOffScheduleTime.getTime() && twoOnScheduleTime.getTime() < endTime.getTime() && endTime.getTime() <= twoOffScheduleTime.getTime()) {
                        double one = AtsDateUtils.getTwoTimeDiffMinutes(AtsDateUtils.dateLongToString(beginTime), AtsDateUtils.dateLongToString(oneOffScheduleTime));
                        two = AtsDateUtils.getTwoTimeDiffMinutes(AtsDateUtils.dateLongToString(twoOnScheduleTime), AtsDateUtils.dateLongToString(endTime));
                        mixedValue = one + two;
                    }
                    if (oneOnScheduleTime.getTime() < beginTime.getTime() && beginTime.getTime() <= oneOffScheduleTime.getTime() && twoOffScheduleTime.getTime() < endTime.getTime()) {
                        double one = AtsDateUtils.getTwoTimeDiffMinutes(AtsDateUtils.dateLongToString(beginTime), AtsDateUtils.dateLongToString(oneOffScheduleTime));
                        two = AtsDateUtils.getTwoTimeDiffMinutes(AtsDateUtils.dateLongToString(twoOnScheduleTime), AtsDateUtils.dateLongToString(twoOffScheduleTime));
                        mixedValue = one + two;
                    }
                    if (oneOffScheduleTime.getTime() < beginTime.getTime() && beginTime.getTime() <= twoOnScheduleTime.getTime() && endTime.getTime() <= twoOnScheduleTime.getTime()) {
                        mixedValue = 0.0;
                    }
                    if (oneOffScheduleTime.getTime() < beginTime.getTime() && beginTime.getTime() <= twoOnScheduleTime.getTime() && twoOnScheduleTime.getTime() < endTime.getTime() && endTime.getTime() <= twoOffScheduleTime.getTime()) {
                        double one;
                        mixedValue = one = AtsDateUtils.getTwoTimeDiffMinutes(AtsDateUtils.dateLongToString(twoOnScheduleTime), AtsDateUtils.dateLongToString(endTime));
                    }
                    if (oneOffScheduleTime.getTime() < beginTime.getTime() && beginTime.getTime() <= twoOnScheduleTime.getTime() && twoOffScheduleTime.getTime() < endTime.getTime()) {
                        double one;
                        mixedValue = one = AtsDateUtils.getTwoTimeDiffMinutes(AtsDateUtils.dateLongToString(twoOnScheduleTime), AtsDateUtils.dateLongToString(twoOffScheduleTime));
                    }
                    if (twoOnScheduleTime.getTime() < beginTime.getTime() && beginTime.getTime() <= twoOffScheduleTime.getTime() && endTime.getTime() <= twoOffScheduleTime.getTime()) {
                        double one;
                        mixedValue = one = AtsDateUtils.getTwoTimeDiffMinutes(AtsDateUtils.dateLongToString(beginTime), AtsDateUtils.dateLongToString(endTime));
                    }
                    if (twoOnScheduleTime.getTime() < beginTime.getTime() && beginTime.getTime() <= twoOffScheduleTime.getTime() && twoOffScheduleTime.getTime() < endTime.getTime()) {
                        double one;
                        mixedValue = one = AtsDateUtils.getTwoTimeDiffMinutes(AtsDateUtils.dateLongToString(beginTime), AtsDateUtils.dateLongToString(twoOffScheduleTime));
                    }
                    if (twoOffScheduleTime.getTime() < beginTime.getTime() && endTime.getTime() > twoOffScheduleTime.getTime()) {
                        mixedValue = 0.0;
                    }
                    mixedValue = AtsDateUtils.divide(mixedValue, 60.0, decimalPlaces);
                }
            }
            if (shiftSize == 3) {
                if (beginTime.getTime() <= oneOnScheduleTime.getTime() && endTime.getTime() >= threeOffScheduleTime.getTime()) {
                    mixedValue = standardHour.doubleValue();
                    BigDecimal minuteBig = BigDecimal.valueOf(mixedValue).multiply(BigDecimal.valueOf(60L));
                    mixedValue = AtsDateUtils.divide(minuteBig.doubleValue(), 60.0, decimalPlaces);
                } else {
                    double three;
                    if (beginTime.getTime() <= oneOnScheduleTime.getTime() && endTime.getTime() <= oneOnScheduleTime.getTime()) {
                        calbeginDate = null;
                        calendDate = null;
                        mixedValue = 0.0;
                    }
                    if (beginTime.getTime() <= oneOnScheduleTime.getTime() && oneOnScheduleTime.getTime() < endTime.getTime() && endTime.getTime() <= oneOffScheduleTime.getTime()) {
                        double one;
                        calbeginDate = oneOnScheduleTime;
                        calendDate = endTime;
                        mixedValue = one = AtsDateUtils.getTwoTimeDiffMinutes(AtsDateUtils.dateLongToString(oneOnScheduleTime), AtsDateUtils.dateLongToString(endTime));
                    }
                    if (beginTime.getTime() <= oneOnScheduleTime.getTime() && oneOffScheduleTime.getTime() < endTime.getTime() && endTime.getTime() <= twoOnScheduleTime.getTime()) {
                        double one;
                        calbeginDate = oneOnScheduleTime;
                        calendDate = oneOffScheduleTime;
                        mixedValue = one = AtsDateUtils.getTwoTimeDiffMinutes(AtsDateUtils.dateLongToString(oneOnScheduleTime), AtsDateUtils.dateLongToString(oneOffScheduleTime));
                    }
                    if (beginTime.getTime() <= oneOnScheduleTime.getTime() && twoOnScheduleTime.getTime() < endTime.getTime() && endTime.getTime() <= twoOffScheduleTime.getTime()) {
                        double one = AtsDateUtils.getTwoTimeDiffMinutes(AtsDateUtils.dateLongToString(oneOnScheduleTime), AtsDateUtils.dateLongToString(oneOffScheduleTime));
                        two = AtsDateUtils.getTwoTimeDiffMinutes(AtsDateUtils.dateLongToString(twoOnScheduleTime), AtsDateUtils.dateLongToString(endTime));
                        mixedValue = one + two;
                    }
                    if (beginTime.getTime() <= oneOnScheduleTime.getTime() && twoOffScheduleTime.getTime() < endTime.getTime() && endTime.getTime() <= threeOnScheduleTime.getTime()) {
                        double one = AtsDateUtils.getTwoTimeDiffMinutes(AtsDateUtils.dateLongToString(oneOnScheduleTime), AtsDateUtils.dateLongToString(oneOffScheduleTime));
                        two = AtsDateUtils.getTwoTimeDiffMinutes(AtsDateUtils.dateLongToString(twoOnScheduleTime), AtsDateUtils.dateLongToString(twoOffScheduleTime));
                        mixedValue = one + two;
                    }
                    if (beginTime.getTime() <= oneOnScheduleTime.getTime() && threeOnScheduleTime.getTime() < endTime.getTime() && endTime.getTime() <= threeOffScheduleTime.getTime()) {
                        double one = AtsDateUtils.getTwoTimeDiffMinutes(AtsDateUtils.dateLongToString(oneOnScheduleTime), AtsDateUtils.dateLongToString(oneOffScheduleTime));
                        two = AtsDateUtils.getTwoTimeDiffMinutes(AtsDateUtils.dateLongToString(twoOnScheduleTime), AtsDateUtils.dateLongToString(twoOffScheduleTime));
                        three = AtsDateUtils.getTwoTimeDiffMinutes(AtsDateUtils.dateLongToString(threeOnScheduleTime), AtsDateUtils.dateLongToString(endTime));
                        mixedValue = one + two + three;
                    }
                    if (beginTime.getTime() <= oneOnScheduleTime.getTime() && threeOffScheduleTime.getTime() < endTime.getTime()) {
                        double one = AtsDateUtils.getTwoTimeDiffMinutes(AtsDateUtils.dateLongToString(oneOnScheduleTime), AtsDateUtils.dateLongToString(oneOffScheduleTime));
                        two = AtsDateUtils.getTwoTimeDiffMinutes(AtsDateUtils.dateLongToString(twoOnScheduleTime), AtsDateUtils.dateLongToString(twoOffScheduleTime));
                        three = AtsDateUtils.getTwoTimeDiffMinutes(AtsDateUtils.dateLongToString(threeOnScheduleTime), AtsDateUtils.dateLongToString(threeOffScheduleTime));
                        mixedValue = one + two + three;
                    }
                    if (oneOnScheduleTime.getTime() < beginTime.getTime() && beginTime.getTime() <= oneOffScheduleTime.getTime() && endTime.getTime() <= oneOffScheduleTime.getTime()) {
                        double one;
                        mixedValue = one = AtsDateUtils.getTwoTimeDiffMinutes(AtsDateUtils.dateLongToString(beginTime), AtsDateUtils.dateLongToString(endTime));
                    }
                    if (oneOnScheduleTime.getTime() < beginTime.getTime() && beginTime.getTime() <= oneOffScheduleTime.getTime() && oneOffScheduleTime.getTime() < endTime.getTime() && endTime.getTime() <= twoOnScheduleTime.getTime()) {
                        double one;
                        mixedValue = one = AtsDateUtils.getTwoTimeDiffMinutes(AtsDateUtils.dateLongToString(beginTime), AtsDateUtils.dateLongToString(oneOffScheduleTime));
                    }
                    if (oneOnScheduleTime.getTime() < beginTime.getTime() && beginTime.getTime() <= oneOffScheduleTime.getTime() && twoOnScheduleTime.getTime() < endTime.getTime() && endTime.getTime() <= twoOffScheduleTime.getTime()) {
                        double one = AtsDateUtils.getTwoTimeDiffMinutes(AtsDateUtils.dateLongToString(beginTime), AtsDateUtils.dateLongToString(oneOffScheduleTime));
                        two = AtsDateUtils.getTwoTimeDiffMinutes(AtsDateUtils.dateLongToString(twoOnScheduleTime), AtsDateUtils.dateLongToString(endTime));
                        mixedValue = one + two;
                    }
                    if (oneOnScheduleTime.getTime() < beginTime.getTime() && beginTime.getTime() <= oneOffScheduleTime.getTime() && twoOffScheduleTime.getTime() < endTime.getTime() && endTime.getTime() <= threeOnScheduleTime.getTime()) {
                        double one = AtsDateUtils.getTwoTimeDiffMinutes(AtsDateUtils.dateLongToString(beginTime), AtsDateUtils.dateLongToString(oneOffScheduleTime));
                        two = AtsDateUtils.getTwoTimeDiffMinutes(AtsDateUtils.dateLongToString(twoOnScheduleTime), AtsDateUtils.dateLongToString(twoOffScheduleTime));
                        mixedValue = one + two;
                    }
                    if (oneOnScheduleTime.getTime() < beginTime.getTime() && beginTime.getTime() <= oneOffScheduleTime.getTime() && threeOnScheduleTime.getTime() < endTime.getTime() && endTime.getTime() <= threeOffScheduleTime.getTime()) {
                        double one = AtsDateUtils.getTwoTimeDiffMinutes(AtsDateUtils.dateLongToString(beginTime), AtsDateUtils.dateLongToString(oneOffScheduleTime));
                        two = AtsDateUtils.getTwoTimeDiffMinutes(AtsDateUtils.dateLongToString(twoOnScheduleTime), AtsDateUtils.dateLongToString(twoOffScheduleTime));
                        three = AtsDateUtils.getTwoTimeDiffMinutes(AtsDateUtils.dateLongToString(threeOnScheduleTime), AtsDateUtils.dateLongToString(endTime));
                        mixedValue = one + two + three;
                    }
                    if (oneOnScheduleTime.getTime() < beginTime.getTime() && beginTime.getTime() <= oneOffScheduleTime.getTime() && threeOffScheduleTime.getTime() < endTime.getTime()) {
                        double one = AtsDateUtils.getTwoTimeDiffMinutes(AtsDateUtils.dateLongToString(beginTime), AtsDateUtils.dateLongToString(oneOffScheduleTime));
                        two = AtsDateUtils.getTwoTimeDiffMinutes(AtsDateUtils.dateLongToString(twoOnScheduleTime), AtsDateUtils.dateLongToString(twoOffScheduleTime));
                        three = AtsDateUtils.getTwoTimeDiffMinutes(AtsDateUtils.dateLongToString(threeOnScheduleTime), AtsDateUtils.dateLongToString(threeOffScheduleTime));
                        mixedValue = one + two + three;
                    }
                    if (oneOffScheduleTime.getTime() < beginTime.getTime() && beginTime.getTime() <= twoOnScheduleTime.getTime() && endTime.getTime() <= twoOnScheduleTime.getTime()) {
                        mixedValue = 0.0;
                    }
                    if (oneOffScheduleTime.getTime() < beginTime.getTime() && beginTime.getTime() <= twoOnScheduleTime.getTime() && twoOnScheduleTime.getTime() < endTime.getTime() && endTime.getTime() <= twoOffScheduleTime.getTime()) {
                        double one;
                        mixedValue = one = AtsDateUtils.getTwoTimeDiffMinutes(AtsDateUtils.dateLongToString(twoOnScheduleTime), AtsDateUtils.dateLongToString(endTime));
                    }
                    if (oneOffScheduleTime.getTime() < beginTime.getTime() && beginTime.getTime() <= twoOnScheduleTime.getTime() && twoOffScheduleTime.getTime() < endTime.getTime() && endTime.getTime() <= threeOnScheduleTime.getTime()) {
                        double one;
                        mixedValue = one = AtsDateUtils.getTwoTimeDiffMinutes(AtsDateUtils.dateLongToString(twoOnScheduleTime), AtsDateUtils.dateLongToString(twoOffScheduleTime));
                    }
                    if (oneOffScheduleTime.getTime() < beginTime.getTime() && beginTime.getTime() <= twoOnScheduleTime.getTime() && threeOnScheduleTime.getTime() < endTime.getTime() && endTime.getTime() <= threeOffScheduleTime.getTime()) {
                        double one = AtsDateUtils.getTwoTimeDiffMinutes(AtsDateUtils.dateLongToString(twoOnScheduleTime), AtsDateUtils.dateLongToString(twoOffScheduleTime));
                        two = AtsDateUtils.getTwoTimeDiffMinutes(AtsDateUtils.dateLongToString(threeOnScheduleTime), AtsDateUtils.dateLongToString(endTime));
                        mixedValue = one + two;
                    }
                    if (oneOffScheduleTime.getTime() < beginTime.getTime() && beginTime.getTime() <= twoOnScheduleTime.getTime() && threeOffScheduleTime.getTime() < endTime.getTime()) {
                        double one = AtsDateUtils.getTwoTimeDiffMinutes(AtsDateUtils.dateLongToString(twoOnScheduleTime), AtsDateUtils.dateLongToString(twoOffScheduleTime));
                        two = AtsDateUtils.getTwoTimeDiffMinutes(AtsDateUtils.dateLongToString(threeOnScheduleTime), AtsDateUtils.dateLongToString(threeOffScheduleTime));
                        mixedValue = one + two;
                    }
                    if (twoOnScheduleTime.getTime() < beginTime.getTime() && beginTime.getTime() <= twoOffScheduleTime.getTime() && endTime.getTime() <= twoOffScheduleTime.getTime()) {
                        double one;
                        mixedValue = one = AtsDateUtils.getTwoTimeDiffMinutes(AtsDateUtils.dateLongToString(beginTime), AtsDateUtils.dateLongToString(endTime));
                    }
                    if (twoOnScheduleTime.getTime() < beginTime.getTime() && beginTime.getTime() <= twoOffScheduleTime.getTime() && twoOffScheduleTime.getTime() < endTime.getTime() && endTime.getTime() <= threeOnScheduleTime.getTime()) {
                        double one;
                        mixedValue = one = AtsDateUtils.getTwoTimeDiffMinutes(AtsDateUtils.dateLongToString(beginTime), AtsDateUtils.dateLongToString(twoOffScheduleTime));
                    }
                    if (twoOnScheduleTime.getTime() < beginTime.getTime() && beginTime.getTime() <= twoOffScheduleTime.getTime() && threeOnScheduleTime.getTime() < endTime.getTime() && endTime.getTime() <= threeOffScheduleTime.getTime()) {
                        double one = AtsDateUtils.getTwoTimeDiffMinutes(AtsDateUtils.dateLongToString(beginTime), AtsDateUtils.dateLongToString(twoOffScheduleTime));
                        two = AtsDateUtils.getTwoTimeDiffMinutes(AtsDateUtils.dateLongToString(threeOnScheduleTime), AtsDateUtils.dateLongToString(endTime));
                        mixedValue = one + two;
                    }
                    if (twoOnScheduleTime.getTime() < beginTime.getTime() && beginTime.getTime() <= twoOffScheduleTime.getTime() && threeOffScheduleTime.getTime() < endTime.getTime()) {
                        double one = AtsDateUtils.getTwoTimeDiffMinutes(AtsDateUtils.dateLongToString(beginTime), AtsDateUtils.dateLongToString(twoOffScheduleTime));
                        two = AtsDateUtils.getTwoTimeDiffMinutes(AtsDateUtils.dateLongToString(threeOnScheduleTime), AtsDateUtils.dateLongToString(threeOffScheduleTime));
                        mixedValue = one + two;
                    }
                    if (twoOffScheduleTime.getTime() < beginTime.getTime() && beginTime.getTime() <= threeOnScheduleTime.getTime() && endTime.getTime() <= threeOnScheduleTime.getTime()) {
                        double one;
                        mixedValue = one = 0.0;
                    }
                    if (twoOffScheduleTime.getTime() < beginTime.getTime() && beginTime.getTime() <= threeOnScheduleTime.getTime() && threeOnScheduleTime.getTime() < endTime.getTime() && endTime.getTime() <= threeOffScheduleTime.getTime()) {
                        double one;
                        mixedValue = one = AtsDateUtils.getTwoTimeDiffMinutes(AtsDateUtils.dateLongToString(threeOnScheduleTime), AtsDateUtils.dateLongToString(endTime));
                    }
                    if (twoOffScheduleTime.getTime() < beginTime.getTime() && beginTime.getTime() <= threeOnScheduleTime.getTime() && threeOffScheduleTime.getTime() < endTime.getTime()) {
                        double one;
                        mixedValue = one = AtsDateUtils.getTwoTimeDiffMinutes(AtsDateUtils.dateLongToString(threeOnScheduleTime), AtsDateUtils.dateLongToString(threeOnScheduleTime));
                    }
                    if (threeOnScheduleTime.getTime() < beginTime.getTime() && beginTime.getTime() <= threeOffScheduleTime.getTime() && endTime.getTime() <= threeOffScheduleTime.getTime()) {
                        double one;
                        mixedValue = one = AtsDateUtils.getTwoTimeDiffMinutes(AtsDateUtils.dateLongToString(beginTime), AtsDateUtils.dateLongToString(endTime));
                    }
                    if (threeOnScheduleTime.getTime() < beginTime.getTime() && beginTime.getTime() <= threeOffScheduleTime.getTime() && threeOffScheduleTime.getTime() < endTime.getTime()) {
                        double one;
                        mixedValue = one = AtsDateUtils.getTwoTimeDiffMinutes(AtsDateUtils.dateLongToString(beginTime), AtsDateUtils.dateLongToString(threeOffScheduleTime));
                    }
                    if (threeOffScheduleTime.getTime() < beginTime.getTime() && endTime.getTime() > threeOffScheduleTime.getTime()) {
                        mixedValue = 0.0;
                    }
                    mixedValue = AtsDateUtils.divide(mixedValue, 60.0, decimalPlaces);
                }
            }
            tripBillHoursres = tripBillHoursres.add(BigDecimal.valueOf(mixedValue));
        }
        tripBillHoursres = DecimalPlaceUtil.decimalPlaceCtrl(ctx, tripBillHoursres, decimalPlaces);
        BigDecimal tripBillDays = BigDecimal.valueOf(0L);
        BigDecimal tripBillHours = BigDecimal.valueOf(0L);
        if (standardHour.doubleValue() != 0.0) {
            tripBillDays = AtsDateUtils.divide(tripBillHoursres, standardHour, decimalPlaces);
            tripBillHours = tripBillHoursres;
        }
        resMap.put("tripBillDays", tripBillDays);
        resMap.put("tripBillHours", tripBillHours);
        return resMap;
    }

    public Map<String, String> getScheduleShiftInfoParameters(Context ctx, String personid, String attenceDate, List<ScheduleShiftInfo> scheduleShiftList, AtsShiftInfo defaultShiftInfo, int decimalPlaces) throws BOSException, UuidException, SQLException, EASBizException {
        int segmentValue;
        ScheduleShiftItemInfo scheduleShiftItemInfo;
        int shiftItemSize;
        BigDecimal standardHour = BigDecimal.valueOf(8L);
        String oneOnTimeSchedule = "";
        String oneOffTimeSchedule = "";
        String twoOnTimeSchedule = "";
        String twoOffTimeSchedule = "";
        String threeOnTimeSchedule = "";
        String threeOffTimeSchedule = "";
        BigDecimal oneSegmentInRest = BigDecimal.valueOf(0L);
        BigDecimal twoSegmentInRest = BigDecimal.valueOf(0L);
        BigDecimal threeSegmentInRest = BigDecimal.valueOf(0L);
        HashMap<String, String> scheduleParameMap = new HashMap<String, String>();
        String attdatestr = attenceDate;
        int scheduleShiftTag = 0;
        int Size = scheduleShiftList != null ? scheduleShiftList.size() : 0;
        AbstractScheduleShiftInfo scheduleShiftInfo = scheduleShiftList != null && scheduleShiftList.size() > 0 && scheduleShiftList.get(0) != null ? scheduleShiftList.get(0) : null;
        ScheduleShiftItemCollection scheduleShiftItemCollection = scheduleShiftInfo != null ? scheduleShiftInfo.getItems() : null;
        int n = shiftItemSize = scheduleShiftItemCollection != null ? scheduleShiftItemCollection.size() : 0;
        if (Size > 0 && scheduleShiftInfo != null) {
            if (shiftItemSize == 0) {
                String cardRuleId = scheduleShiftInfo.getCardRule().getId().toString();
                CardRuleCollection coll = CardRuleFactory.getLocalInstance(ctx).getCardRuleCollection(" where id ='" + cardRuleId + "' ");
                if (coll.size() > 0) {
                    scheduleShiftTag = coll.get(0).getStartSegmentNum().getValue();
                }
            } else {
                scheduleShiftTag = scheduleShiftInfo.getItems() != null ? scheduleShiftInfo.getItems().size() : 0;
            }
        }
        int shiftTimeTag = 0;
        if (scheduleShiftTag == 1) {
            if (scheduleShiftInfo.getStandardHour() != null && scheduleShiftInfo != null) {
                standardHour = scheduleShiftInfo.getStandardHour();
                standardHour = DecimalPlaceUtil.decimalPlaceCtrl(ctx, standardHour, decimalPlaces);
            }
            if (shiftItemSize == 0 && defaultShiftInfo != null) {
                oneOnTimeSchedule = attdatestr + " " + AtsServerUtils.getShiftStartTimeAndEndTime(defaultShiftInfo).get("firstOnTime");
                oneOffTimeSchedule = attdatestr + " " + AtsServerUtils.getShiftStartTimeAndEndTime(defaultShiftInfo).get("firstOffTime");
                shiftTimeTag = 1;
            }
            if (shiftItemSize > 0 && scheduleShiftItemCollection != null) {
                if (scheduleShiftItemCollection.get(0).getSegmentInRest() != null) {
                    oneSegmentInRest = scheduleShiftItemCollection.get(0).getSegmentInRest();
                }
                if (scheduleShiftItemCollection.get(0).getPreDateTime() != null) {
                    oneOnTimeSchedule = AtsDateUtils.timestampToString(scheduleShiftItemCollection.get(0).getPreDateTime());
                } else if (defaultShiftInfo != null) {
                    oneOnTimeSchedule = attdatestr + " " + AtsServerUtils.getShiftStartTimeAndEndTime(defaultShiftInfo).get("firstOnTime");
                }
                if (scheduleShiftItemCollection.get(0).getNextDateTime() != null) {
                    oneOffTimeSchedule = AtsDateUtils.timestampToString(scheduleShiftItemCollection.get(0).getNextDateTime());
                } else if (defaultShiftInfo != null) {
                    oneOffTimeSchedule = attdatestr + " " + AtsServerUtils.getShiftStartTimeAndEndTime(defaultShiftInfo).get("firstOffTime");
                }
            }
        }
        if (scheduleShiftTag == 2) {
            if (scheduleShiftInfo != null && scheduleShiftInfo.getStandardHour() != null) {
                standardHour = scheduleShiftInfo.getStandardHour();
                standardHour = DecimalPlaceUtil.decimalPlaceCtrl(ctx, standardHour, decimalPlaces);
            }
            if (shiftItemSize == 0 && defaultShiftInfo != null) {
                oneOnTimeSchedule = attdatestr + " " + AtsServerUtils.getShiftStartTimeAndEndTime(defaultShiftInfo).get("firstOnTime");
                oneOffTimeSchedule = attdatestr + " " + AtsServerUtils.getShiftStartTimeAndEndTime(defaultShiftInfo).get("firstOffTime");
                twoOnTimeSchedule = attdatestr + " " + AtsServerUtils.getShiftStartTimeAndEndTime(defaultShiftInfo).get("secondOnTime");
                twoOffTimeSchedule = attdatestr + " " + AtsServerUtils.getShiftStartTimeAndEndTime(defaultShiftInfo).get("secondOffTime");
                shiftTimeTag = 1;
            }
            if (shiftItemSize > 0 && !AtsCollectionUtile.isEmpty((IObjectCollection)scheduleShiftItemCollection)) {
                for (int j = 0; j < scheduleShiftItemCollection.size(); ++j) {
                    scheduleShiftItemInfo = scheduleShiftItemCollection.get(j);
                    segmentValue = Integer.valueOf(scheduleShiftItemInfo.getSegment().getValue());
                    if (segmentValue == 1) {
                        if (scheduleShiftItemInfo.getSegmentInRest() != null) {
                            oneSegmentInRest = scheduleShiftItemInfo.getSegmentInRest();
                        }
                        if (scheduleShiftItemInfo.getPreDateTime() != null) {
                            oneOnTimeSchedule = AtsDateUtils.timestampToString(scheduleShiftItemInfo.getPreDateTime());
                        } else if (defaultShiftInfo != null) {
                            oneOnTimeSchedule = attdatestr + " " + AtsServerUtils.getShiftStartTimeAndEndTime(defaultShiftInfo).get("firstOnTime");
                        }
                        if (scheduleShiftItemInfo.getNextDateTime() != null) {
                            oneOffTimeSchedule = AtsDateUtils.timestampToString(scheduleShiftItemInfo.getNextDateTime());
                        } else if (defaultShiftInfo != null) {
                            oneOffTimeSchedule = attdatestr + " " + AtsServerUtils.getShiftStartTimeAndEndTime(defaultShiftInfo).get("firstOffTime");
                        }
                    }
                    if (segmentValue != 2) continue;
                    if (scheduleShiftItemInfo.getSegmentInRest() != null) {
                        twoSegmentInRest = scheduleShiftItemInfo.getSegmentInRest();
                    }
                    if (scheduleShiftItemInfo.getPreDateTime() != null) {
                        twoOnTimeSchedule = AtsDateUtils.timestampToString(scheduleShiftItemInfo.getPreDateTime());
                    } else if (defaultShiftInfo != null) {
                        twoOnTimeSchedule = attdatestr + " " + AtsServerUtils.getShiftStartTimeAndEndTime(defaultShiftInfo).get("secondOnTime");
                    }
                    if (scheduleShiftItemInfo.getNextDateTime() != null) {
                        twoOffTimeSchedule = AtsDateUtils.timestampToString(scheduleShiftItemInfo.getNextDateTime());
                        continue;
                    }
                    if (defaultShiftInfo == null) continue;
                    twoOffTimeSchedule = attdatestr + " " + AtsServerUtils.getShiftStartTimeAndEndTime(defaultShiftInfo).get("secondOffTime");
                }
            }
        }
        if (scheduleShiftTag == 3) {
            if (scheduleShiftInfo != null && scheduleShiftInfo.getStandardHour() != null) {
                standardHour = scheduleShiftInfo.getStandardHour();
                standardHour = DecimalPlaceUtil.decimalPlaceCtrl(ctx, standardHour, decimalPlaces);
            }
            if (shiftItemSize == 0 && defaultShiftInfo != null) {
                oneOnTimeSchedule = attdatestr + " " + AtsServerUtils.getShiftStartTimeAndEndTime(defaultShiftInfo).get("firstOnTime");
                oneOffTimeSchedule = attdatestr + " " + AtsServerUtils.getShiftStartTimeAndEndTime(defaultShiftInfo).get("firstOffTime");
                twoOnTimeSchedule = attdatestr + " " + AtsServerUtils.getShiftStartTimeAndEndTime(defaultShiftInfo).get("secondOnTime");
                twoOffTimeSchedule = attdatestr + " " + AtsServerUtils.getShiftStartTimeAndEndTime(defaultShiftInfo).get("secondOffTime");
                threeOnTimeSchedule = attdatestr + " " + AtsServerUtils.getShiftStartTimeAndEndTime(defaultShiftInfo).get("thirdOnTime");
                threeOffTimeSchedule = attdatestr + " " + AtsServerUtils.getShiftStartTimeAndEndTime(defaultShiftInfo).get("thirdOffTime");
                shiftTimeTag = 1;
            }
            if (shiftItemSize > 0 && !AtsCollectionUtile.isEmpty((IObjectCollection)scheduleShiftItemCollection)) {
                for (int j = 0; j < scheduleShiftItemCollection.size(); ++j) {
                    scheduleShiftItemInfo = scheduleShiftItemCollection.get(j);
                    segmentValue = Integer.valueOf(scheduleShiftItemInfo.getSegment().getValue());
                    if (segmentValue == 1) {
                        if (scheduleShiftItemInfo.getSegmentInRest() != null) {
                            oneSegmentInRest = scheduleShiftItemInfo.getSegmentInRest();
                        }
                        if (scheduleShiftItemInfo.getPreDateTime() != null) {
                            oneOnTimeSchedule = AtsDateUtils.timestampToString(scheduleShiftItemInfo.getPreDateTime());
                        } else if (defaultShiftInfo != null) {
                            oneOnTimeSchedule = attdatestr + " " + AtsServerUtils.getShiftStartTimeAndEndTime(defaultShiftInfo).get("firstOnTime");
                        }
                        if (scheduleShiftList.get(j).getItems().get(0).getNextDateTime() != null) {
                            oneOffTimeSchedule = AtsDateUtils.timestampToString(scheduleShiftItemInfo.getNextDateTime());
                        } else if (defaultShiftInfo != null) {
                            oneOffTimeSchedule = attdatestr + " " + AtsServerUtils.getShiftStartTimeAndEndTime(defaultShiftInfo).get("firstOffTime");
                        }
                    }
                    if (segmentValue == 2) {
                        if (scheduleShiftItemInfo.getSegmentInRest() != null) {
                            twoSegmentInRest = scheduleShiftItemInfo.getSegmentInRest();
                        }
                        if (scheduleShiftItemInfo.getPreDateTime() != null) {
                            twoOnTimeSchedule = AtsDateUtils.timestampToString(scheduleShiftItemInfo.getPreDateTime());
                        } else if (defaultShiftInfo != null) {
                            twoOnTimeSchedule = attdatestr + " " + AtsServerUtils.getShiftStartTimeAndEndTime(defaultShiftInfo).get("secondOnTime");
                        }
                        if (scheduleShiftItemInfo.getNextDateTime() != null) {
                            twoOffTimeSchedule = AtsDateUtils.timestampToString(scheduleShiftItemInfo.getNextDateTime());
                        } else if (defaultShiftInfo != null) {
                            twoOffTimeSchedule = attdatestr + " " + AtsServerUtils.getShiftStartTimeAndEndTime(defaultShiftInfo).get("secondOffTime");
                        }
                    }
                    if (segmentValue != 3) continue;
                    if (scheduleShiftItemInfo.getSegmentInRest() != null) {
                        threeSegmentInRest = scheduleShiftItemInfo.getSegmentInRest();
                    }
                    if (scheduleShiftItemInfo.getPreDateTime() != null) {
                        threeOnTimeSchedule = AtsDateUtils.timestampToString(scheduleShiftItemInfo.getPreDateTime());
                    } else if (defaultShiftInfo != null) {
                        threeOnTimeSchedule = attdatestr + " " + AtsServerUtils.getShiftStartTimeAndEndTime(defaultShiftInfo).get("thirdOnTime");
                    }
                    if (scheduleShiftItemInfo.getNextDateTime() != null) {
                        threeOffTimeSchedule = AtsDateUtils.timestampToString(scheduleShiftItemInfo.getNextDateTime());
                        continue;
                    }
                    if (defaultShiftInfo == null) continue;
                    threeOffTimeSchedule = attdatestr + " " + AtsServerUtils.getShiftStartTimeAndEndTime(defaultShiftInfo).get("thirdOffTime");
                }
            }
        }
        scheduleParameMap.put("personid", personid);
        scheduleParameMap.put("attendDate", attenceDate);
        scheduleParameMap.put("standardHour", standardHour.toString());
        scheduleParameMap.put("oneSegmentInRest", oneSegmentInRest.toString());
        scheduleParameMap.put("twoSegmentInRest", twoSegmentInRest.toString());
        scheduleParameMap.put("threeSegmentInRest", threeSegmentInRest.toString());
        scheduleParameMap.put("oneOnTimeSchedule", oneOnTimeSchedule);
        scheduleParameMap.put("oneOffTimeSchedule", oneOffTimeSchedule);
        scheduleParameMap.put("twoOnTimeSchedule", twoOnTimeSchedule);
        scheduleParameMap.put("twoOffTimeSchedule", twoOffTimeSchedule);
        scheduleParameMap.put("threeOnTimeSchedule", threeOnTimeSchedule);
        scheduleParameMap.put("threeOffTimeSchedule", threeOffTimeSchedule);
        scheduleParameMap.put("shiftSize", String.valueOf(scheduleShiftInfo != null && scheduleShiftInfo.getItems() != null ? scheduleShiftInfo.getItems().size() : 0));
        scheduleParameMap.put("shiftTimeTag", String.valueOf(shiftTimeTag));
        return scheduleParameMap;
    }

    public double getLeaveBillCount(double countType, Map paramMap) throws Exception {
        Map<String, Object> leaveBillCountType2TempDataMap;
        List<String> personIds;
        int ctType = BigDecimal.valueOf(countType).intValue();
        if (ctType != 1 && ctType != 2) {
            return -1.0;
        }
        String personId = (String)paramMap.get(T_HR_ATS_ATTENDANCERESULTSUM_FPROPOSERID);
        Map globalMap = (Map)paramMap.get(GLOBALMAPKEY);
        String beginDate = (String)globalMap.get(PERIODBEGINDATE);
        String endDate = (String)globalMap.get(PERIODENDDATE);
        String personIdsString = null;
        if (globalMap.get("personIdsForSumResult") != null) {
            personIds = (List)globalMap.get("personIdsForSumResult");
            personIdsString = AtsServerCalUtils.getPersonIds(personIds);
        } else {
            personIds = new ArrayList();
            personIds.add(personId);
            personIdsString = AtsServerCalUtils.getPersonIds(personIds);
        }
        if (ctType == 1) {
            Map<String, Object> leaveBillCountType1TempDataMap;
            if (globalMap.get("LeaveBillCountType1TempDataMap") != null) {
                leaveBillCountType1TempDataMap = (Map<String, Object>)globalMap.get("LeaveBillCountType1TempDataMap");
                if (String.valueOf(leaveBillCountType1TempDataMap.get("personIdsString")).equals(personIdsString)) {
                    if (leaveBillCountType1TempDataMap.get(personId) != null) {
                        return (Double)leaveBillCountType1TempDataMap.get(personId);
                    }
                    return 0.0;
                }
                leaveBillCountType1TempDataMap = this.getLeaveBillCountType1TempDataMap(personIdsString, beginDate, endDate);
                globalMap.put("LeaveBillCountType1TempDataMap", leaveBillCountType1TempDataMap);
                if (leaveBillCountType1TempDataMap.get(personId) != null) {
                    return (Double)leaveBillCountType1TempDataMap.get(personId);
                }
                return 0.0;
            }
            leaveBillCountType1TempDataMap = this.getLeaveBillCountType1TempDataMap(personIdsString, beginDate, endDate);
            globalMap.put("LeaveBillCountType1TempDataMap", leaveBillCountType1TempDataMap);
            if (leaveBillCountType1TempDataMap.get(personId) != null) {
                return (Double)leaveBillCountType1TempDataMap.get(personId);
            }
            return 0.0;
        }
        if (globalMap.get("LeaveBillCountType2TempDataMap") != null) {
            leaveBillCountType2TempDataMap = (Map<String, Object>)globalMap.get("LeaveBillCountType2TempDataMap");
            if (String.valueOf(leaveBillCountType2TempDataMap.get("personIdsString")).equals(personIdsString)) {
                if (leaveBillCountType2TempDataMap.get(personId) != null) {
                    return (Double)leaveBillCountType2TempDataMap.get(personId);
                }
                return 0.0;
            }
            leaveBillCountType2TempDataMap = this.getLeaveBillCountType2TempDataMap(personIdsString, beginDate, endDate);
            globalMap.put("LeaveBillCountType2TempDataMap", leaveBillCountType2TempDataMap);
            if (leaveBillCountType2TempDataMap.get(personId) != null) {
                return (Double)leaveBillCountType2TempDataMap.get(personId);
            }
            return 0.0;
        }
        leaveBillCountType2TempDataMap = this.getLeaveBillCountType2TempDataMap(personIdsString, beginDate, endDate);
        globalMap.put("LeaveBillCountType2TempDataMap", leaveBillCountType2TempDataMap);
        if (leaveBillCountType2TempDataMap.get(personId) != null) {
            return (Double)leaveBillCountType2TempDataMap.get(personId);
        }
        return 0.0;
    }

    public Map<String, Object> getLeaveBillCountType1TempDataMap(String personIdsString, String beginDate, String endDate) throws Exception {
        HashMap<String, Object> leaveBillCountType1TempDataMap = new HashMap<String, Object>();
        leaveBillCountType1TempDataMap.put("personIdsString", personIdsString);
        StringBuffer sb = new StringBuffer();
        sb.append(" SELECT  entry.FPERSONID,COUNT(*) FROM ");
        sb.append(" T_HR_ATS_LEAVEBILLENTRY entry ");
        sb.append(" INNER JOIN T_HR_ATS_LEAVEBILL bill ");
        sb.append(" ON entry.FBILLID=bill.FID ");
        sb.append(" WHERE entry.FPERSONID IN (" + personIdsString + ") ");
        sb.append(" AND entry.FREALBEGINTIME >={ts '" + beginDate + " 00:00:00'} ");
        sb.append(" AND entry.FREALBEGINTIME <={ts '" + endDate + " 23:59:59'} ");
        sb.append(" AND bill.FBILLSTATE =3 ");
        sb.append(" GROUP BY entry.FPERSONID");
        IRowSet rowSet = DbUtil.executeQuery((Context)this.ctx, (String)sb.toString());
        while (rowSet.next()) {
            String personId = rowSet.getString(1);
            Double leaveBillCount = rowSet.getDouble(2);
            leaveBillCountType1TempDataMap.put(personId, leaveBillCount);
        }
        return leaveBillCountType1TempDataMap;
    }

    public Map<String, Object> getLeaveBillCountType2TempDataMap(String personIdsString, String beginDate, String endDate) throws Exception {
        HashMap<String, Object> leaveBillCountType2TempDataMap = new HashMap<String, Object>();
        leaveBillCountType2TempDataMap.put("personIdsString", personIdsString);
        StringBuffer sb = new StringBuffer();
        sb.append(" SELECT  entry.FPERSONID,COUNT(*) FROM ");
        sb.append(" T_HR_ATS_LEAVEBILLENTRY entry ");
        sb.append(" INNER JOIN T_HR_ATS_LEAVEBILL bill ");
        sb.append(" ON entry.FBILLID=bill.FID ");
        sb.append(" WHERE entry.FPERSONID IN (" + personIdsString + ") ");
        sb.append(" AND ");
        sb.append("( ");
        sb.append("(entry.FREALBEGINTIME >= {ts '" + beginDate + " 00:00:00'} and entry.FREALBEGINTIME <= {ts '" + endDate + " 23:59:59'} ) ");
        sb.append("or ");
        sb.append("(entry.FREALENDTIME >= {ts '" + beginDate + " 00:00:00'} and entry.FREALENDTIME <= {ts '" + endDate + " 23:59:59'} ) ");
        sb.append("or ");
        sb.append("(entry.FREALBEGINTIME <= {ts '" + beginDate + " 00:00:00'} and entry.FREALENDTIME >= {ts '" + endDate + " 23:59:59'} ) ");
        sb.append(") ");
        sb.append(" AND bill.FBILLSTATE =3 ");
        sb.append(" GROUP BY entry.FPERSONID");
        IRowSet rowSet = DbUtil.executeQuery((Context)this.ctx, (String)sb.toString());
        while (rowSet.next()) {
            String personId = rowSet.getString(1);
            Double leaveBillCount = rowSet.getDouble(2);
            leaveBillCountType2TempDataMap.put(personId, leaveBillCount);
        }
        return leaveBillCountType2TempDataMap;
    }

    public Map<String, Object> getLeaveBillTimeLengthTempDataMap(String personIdsString, String beginDate, String endDate, String holidayType) throws Exception {
        HashMap<String, Object> leaveBillCountType2TempDataMap = new HashMap<String, Object>();
        leaveBillCountType2TempDataMap.put("personIdsString", personIdsString);
        StringBuffer sb = new StringBuffer();
        sb.append(" SELECT  entry.FPERSONID,SUM(entry.FREALLEAVELENGTH) FROM ");
        sb.append(" T_HR_ATS_LEAVEBILLENTRY entry ");
        sb.append(" INNER JOIN T_HR_ATS_LEAVEBILL bill ");
        sb.append(" ON entry.FBILLID=bill.FID ");
        sb.append(" WHERE entry.FPERSONID IN (" + personIdsString + ") ");
        sb.append(" AND ");
        sb.append("( ");
        sb.append("(entry.FREALBEGINTIME >= {ts '" + beginDate + " 00:00:00'} and entry.FREALBEGINTIME <= {ts '" + endDate + " 23:59:59'} ) ");
        sb.append("or ");
        sb.append("(entry.FREALENDTIME >= {ts '" + beginDate + " 00:00:00'} and entry.FREALENDTIME <= {ts '" + endDate + " 23:59:59'} ) ");
        sb.append("or ");
        sb.append("(entry.FREALBEGINTIME <= {ts '" + beginDate + " 00:00:00'} and entry.FREALENDTIME >= {ts '" + endDate + " 23:59:59'} ) ");
        sb.append(") ");
        sb.append(" AND bill.FBILLSTATE =3 ");
        sb.append(" AND entry.FPOLICYID =" + holidayType + " ");
        sb.append(" GROUP BY entry.FPERSONID");
        IRowSet rowSet = DbUtil.executeQuery((Context)this.ctx, (String)sb.toString());
        while (rowSet.next()) {
            String personId = rowSet.getString(1);
            Double leaveBillCount = rowSet.getDouble(2);
            leaveBillCountType2TempDataMap.put(personId, leaveBillCount);
        }
        return leaveBillCountType2TempDataMap;
    }

    public double getWorkCalendarDaysCount(double countType, Map paramMap) throws Exception {
        try {
            int ctType = BigDecimal.valueOf(countType).intValue();
            if (ctType != 0 && ctType != 1 && ctType != 2 && ctType != 3) {
                return -1.0;
            }
            Double countResult = new Double(0.0);
            Map globalMap = (Map)paramMap.get(GLOBALMAPKEY);
            Map fileInfoObject = (Map)globalMap.get("T_HR_ATS_AttendanceFile");
            String beginDate = (String)globalMap.get(PERIODBEGINDATE);
            String endDate = (String)globalMap.get(PERIODENDDATE);
            String personId = (String)paramMap.get(T_HR_ATS_ATTENDANCERESULTSUM_FPROPOSERID);
            AttendanceFileInfo attenceFile = (AttendanceFileInfo)fileInfoObject.get(personId + "_" + endDate);
            if (attenceFile == null) {
                attenceFile = (AttendanceFileInfo)fileInfoObject.get(personId + "_" + beginDate);
            }
            if (attenceFile == null) {
                attenceFile = (AttendanceFileInfo)fileInfoObject.get(personId + "_" + HRTimeWebUtils.dateShortToString(new Date()));
            }
            if (attenceFile == null) {
                List<String> datelist = AtsDateUtils.getDateList(beginDate, endDate);
                for (int i = 0; i < datelist.size() && (attenceFile = (AttendanceFileInfo)fileInfoObject.get(personId + "_" + datelist.get(i))) == null; ++i) {
                }
            }
            if (attenceFile != null && attenceFile.getAttencePolicy() != null) {
                String attencePolicyId = attenceFile.getAttencePolicy().getId().toString();
                Map policyInfoMap = (Map)globalMap.get("T_HR_ATS_AttencePolicy");
                AttencePolicyInfo attencePolicy = (AttencePolicyInfo)policyInfoMap.get(attencePolicyId);
                if (attencePolicy != null && attencePolicy.getWorkCalendar() != null) {
                    String workCalendarId = attencePolicy.getWorkCalendar().getId().toString();
                    long oneDayTime = 86400000L;
                    HashSet<String> timeOriginalSets = new HashSet<String>();
                    SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                    Date beginTime = sdf.parse(beginDate);
                    Date endTime = sdf.parse(endDate);
                    while (beginTime.getTime() <= endTime.getTime()) {
                        timeOriginalSets.add(sdf.format(beginTime));
                        beginTime.setTime(beginTime.getTime() + oneDayTime);
                    }
                    Map workItemMap = (Map)globalMap.get("workItemMap");
                    Iterator iter = timeOriginalSets.iterator();
                    while (iter.hasNext()) {
                        String key = workCalendarId + "_" + (String)iter.next();
                        WorkCalendarItemInfo itemInfo = (WorkCalendarItemInfo)workItemMap.get(key);
                        if (itemInfo != null) {
                            switch (ctType) {
                                case 0: {
                                    if (0 != itemInfo.getDayType().getValue()) break;
                                    countResult = countResult + 1.0;
                                    break;
                                }
                                case 1: {
                                    if (1 != itemInfo.getDayType().getValue()) break;
                                    countResult = countResult + 1.0;
                                    break;
                                }
                                case 2: {
                                    if (2 != itemInfo.getDayType().getValue()) break;
                                    countResult = countResult + 1.0;
                                    break;
                                }
                                case 3: {
                                    countResult = countResult + 1.0;
                                }
                            }
                            continue;
                        }
                        if (ctType != 3) continue;
                        countResult = countResult + 1.0;
                    }
                    return countResult;
                }
            }
            return -1.0;
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1.0;
        }
    }

    public double getScheduleShiftDaysCount(double countType, Map paramMap) throws Exception {
        try {
            int ctType = BigDecimal.valueOf(countType).intValue();
            if (ctType != 0 && ctType != 1 && ctType != 2 && ctType != 3) {
                return -1.0;
            }
            Double countResult = new Double(0.0);
            Map globalMap = (Map)paramMap.get(GLOBALMAPKEY);
            String beginDate = (String)globalMap.get(PERIODBEGINDATE);
            String endDate = (String)globalMap.get(PERIODENDDATE);
            String personId = (String)paramMap.get(T_HR_ATS_ATTENDANCERESULTSUM_FPROPOSERID);
            Map shiftItemMap = (Map)globalMap.get("T_HR_ATS_ScheduleShift");
            long oneDayTime = 86400000L;
            HashSet<String> timeOriginalSets = new HashSet<String>();
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            Date beginTime = sdf.parse(beginDate);
            Date endTime = sdf.parse(endDate);
            while (beginTime.getTime() <= endTime.getTime()) {
                timeOriginalSets.add(sdf.format(beginTime));
                beginTime.setTime(beginTime.getTime() + oneDayTime);
            }
            for (String dateStr : timeOriginalSets) {
                String workCalendarId;
                String shiftKey = personId + "_" + dateStr;
                List scheduleInfoList = (List)shiftItemMap.get(shiftKey);
                Map attendanceFileInfoMap = (Map)globalMap.get("T_HR_ATS_AttendanceFile");
                AttendanceFileInfo attendanceFileInfo = null;
                if (null != attendanceFileInfoMap) {
                    attendanceFileInfo = (AttendanceFileInfo)attendanceFileInfoMap.get(shiftKey);
                }
                int dayType = 0;
                if (scheduleInfoList != null && scheduleInfoList.size() > 0) {
                    ScheduleShiftInfo info = (ScheduleShiftInfo)scheduleInfoList.get(0);
                    if (info.getDayType() == null) {
                        if (ctType != 3) continue;
                        countResult = countResult + 1.0;
                        continue;
                    }
                    dayType = info.getDayType().getValue();
                    countResult = this.getDayTypeCount(ctType, countResult, dayType);
                    continue;
                }
                if (null == attendanceFileInfo || attendanceFileInfo.getIsAttendance().getValue() != "0") continue;
                Map attendancePolicyInfoMap = (Map)globalMap.get("T_HR_ATS_AttencePolicy");
                AttencePolicyInfo policy = (AttencePolicyInfo)attendancePolicyInfoMap.get(attendanceFileInfo.getAttencePolicy().getId().toString());
                String string = workCalendarId = policy != null && policy.getWorkCalendar() != null && policy.getWorkCalendar().getId() != null ? policy.getWorkCalendar().getId().toString() : "";
                Map workCalendarItemInfoMap = (Map)globalMap.get("workItemMap");
                if (workCalendarItemInfoMap == null || workCalendarItemInfoMap.size() <= 0 || StringUtils.isEmpty((String)workCalendarId)) continue;
                WorkCalendarItemInfo workCalendarItemInfo = (WorkCalendarItemInfo)workCalendarItemInfoMap.get(workCalendarId + "_" + dateStr);
                dayType = workCalendarItemInfo.getDayType().getValue();
                countResult = this.getDayTypeCount(ctType, countResult, dayType);
            }
            return countResult;
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1.0;
        }
    }

    private Double getDayTypeCount(int ctType, Double countResult, int dayType) {
        switch (ctType) {
            case 0: {
                if (0 != dayType) break;
                countResult = countResult + 1.0;
                break;
            }
            case 1: {
                if (1 != dayType) break;
                countResult = countResult + 1.0;
                break;
            }
            case 2: {
                if (2 != dayType) break;
                countResult = countResult + 1.0;
                break;
            }
            case 3: {
                countResult = countResult + 1.0;
            }
        }
        return countResult;
    }

    public double getHolidayLimitCount(double countType, String holidayType, String field, Map paramMap) throws Exception {
        try {
            Map<String, Object> holidayLimitCountType23TempDataMap;
            String lastEndDateStr;
            Date periodSEndDate;
            Date periodStartDate;
            int i;
            List<String> personIds;
            int ctType = BigDecimal.valueOf(countType).intValue();
            if (ctType != 0 && ctType != 1 && ctType != 2 && ctType != 3 && ctType != 4) {
                return -1.0;
            }
            BigDecimal countResult = new BigDecimal(0);
            String personId = (String)paramMap.get(T_HR_ATS_ATTENDANCERESULTSUM_FPROPOSERID);
            Map globalMap = (Map)paramMap.get(GLOBALMAPKEY);
            String beginDate = (String)globalMap.get(PERIODBEGINDATE);
            String endDate = (String)globalMap.get(PERIODENDDATE);
            String attendPolicyId = (String)globalMap.get("attendPolicyId");
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
            Calendar c = Calendar.getInstance();
            if (null == beginDate) {
                beginDate = df.format(c.getTime());
            }
            if (null == endDate) {
                endDate = df.format(c.getTime());
            }
            String personIdsString = null;
            if (globalMap.get("personIdsForSumResult") != null) {
                personIds = (List)globalMap.get("personIdsForSumResult");
                personIdsString = AtsServerCalUtils.getPersonIds(personIds);
            } else {
                personIds = new ArrayList();
                personIds.add(personId);
                personIdsString = AtsServerCalUtils.getPersonIds(personIds);
            }
            if (ctType == 1 || ctType == 0) {
                Map<String, Object> holidayLimitCountType01TempDataMap;
                if (globalMap.get("holidayLimitCountType01TempDataMap") != null) {
                    holidayLimitCountType01TempDataMap = (Map<String, Object>)globalMap.get("holidayLimitCountType01TempDataMap");
                    if (String.valueOf(holidayLimitCountType01TempDataMap.get("personIdsString")).equals(personIdsString)) {
                        if (holidayLimitCountType01TempDataMap.get(personId) != null) {
                            countResult = this.getHolidayLimitCountTypeValue(ctType, holidayType, personId, field, holidayLimitCountType01TempDataMap);
                            return countResult.doubleValue();
                        }
                        return 0.0;
                    }
                    holidayLimitCountType01TempDataMap = this.getHolidayLimitCountType01TempDataMap(personIdsString, beginDate, endDate);
                    globalMap.put("holidayLimitCountType01TempDataMap", holidayLimitCountType01TempDataMap);
                    if (holidayLimitCountType01TempDataMap.get(personId) != null) {
                        countResult = this.getHolidayLimitCountTypeValue(ctType, holidayType, personId, field, holidayLimitCountType01TempDataMap);
                        return countResult.doubleValue();
                    }
                    return 0.0;
                }
                holidayLimitCountType01TempDataMap = this.getHolidayLimitCountType01TempDataMap(personIdsString, beginDate, endDate);
                globalMap.put("holidayLimitCountType01TempDataMap", holidayLimitCountType01TempDataMap);
                if (holidayLimitCountType01TempDataMap.get(personId) != null) {
                    countResult = this.getHolidayLimitCountTypeValue(ctType, holidayType, personId, field, holidayLimitCountType01TempDataMap);
                    return countResult.doubleValue();
                }
                return 0.0;
            }
            if (StringUtils.isEmpty((String)attendPolicyId)) {
                return 0.0;
            }
            Map policyInfoMap = (Map)globalMap.get("T_HR_ATS_AttencePolicy");
            AttencePolicyInfo attencePolicy = (AttencePolicyInfo)policyInfoMap.get(attendPolicyId);
            Map attendancePeriodInfoListMap = (Map)globalMap.get("attendancePeriodInfoListMap");
            String attenceCycleId = attencePolicy.getAttenceCycle().getId().toString();
            List acttencePeriodInfos = (List)attendancePeriodInfoListMap.get(attenceCycleId);
            AbstractAttendancePeriodInfo lastInfo = null;
            Date beginDateCal = df.parse(beginDate);
            if (ctType == 4) {
                for (i = 0; i < acttencePeriodInfos.size(); ++i) {
                    periodStartDate = DateUtils.truncate((Date)((AttendancePeriodInfo)acttencePeriodInfos.get(i)).getStartDate(), (int)5);
                    periodSEndDate = DateUtils.truncate((Date)((AttendancePeriodInfo)acttencePeriodInfos.get(i)).getEndDate(), (int)5);
                    if (beginDateCal.getTime() < periodStartDate.getTime() || beginDateCal.getTime() > periodSEndDate.getTime()) continue;
                    if (i == 0) {
                        return 0.0;
                    }
                    lastInfo = (AttendancePeriodInfo)acttencePeriodInfos.get(i);
                    break;
                }
            } else {
                for (i = 0; i < acttencePeriodInfos.size(); ++i) {
                    periodStartDate = DateUtils.truncate((Date)((AttendancePeriodInfo)acttencePeriodInfos.get(i)).getStartDate(), (int)5);
                    periodSEndDate = DateUtils.truncate((Date)((AttendancePeriodInfo)acttencePeriodInfos.get(i)).getEndDate(), (int)5);
                    if (beginDateCal.getTime() < periodStartDate.getTime() || beginDateCal.getTime() > periodSEndDate.getTime()) continue;
                    if (i == 0) {
                        return 0.0;
                    }
                    lastInfo = (AttendancePeriodInfo)acttencePeriodInfos.get(i - 1);
                    break;
                }
            }
            String lastBeginDateStr = lastInfo != null && lastInfo.getStartDate() != null ? df.format(lastInfo.getStartDate()) : null;
            String string = lastEndDateStr = lastInfo != null && lastInfo.getEndDate() != null ? df.format(lastInfo.getEndDate()) : null;
            if (globalMap.get("holidayLimitCountType23TempDataMap") != null) {
                holidayLimitCountType23TempDataMap = (Map<String, Object>)globalMap.get("holidayLimitCountType23TempDataMap");
                if (String.valueOf(holidayLimitCountType23TempDataMap.get("personIdsString")).equals(personIdsString)) {
                    if (holidayLimitCountType23TempDataMap.get(personId) != null) {
                        countResult = this.getHolidayLimitCountTypeValue(ctType, holidayType, personId, field, holidayLimitCountType23TempDataMap);
                        return countResult.doubleValue();
                    }
                    return 0.0;
                }
                holidayLimitCountType23TempDataMap = this.getHolidayLimitCountType23TempDataMap(personIdsString, lastBeginDateStr, lastEndDateStr);
                globalMap.put("holidayLimitCountType23TempDataMap", holidayLimitCountType23TempDataMap);
                if (holidayLimitCountType23TempDataMap.get(personId) != null) {
                    countResult = this.getHolidayLimitCountTypeValue(ctType, holidayType, personId, field, holidayLimitCountType23TempDataMap);
                    return countResult.doubleValue();
                }
                return 0.0;
            }
            holidayLimitCountType23TempDataMap = this.getHolidayLimitCountType23TempDataMap(personIdsString, lastBeginDateStr, lastEndDateStr);
            globalMap.put("holidayLimitCountType23TempDataMap", holidayLimitCountType23TempDataMap);
            if (holidayLimitCountType23TempDataMap.get(personId) != null) {
                countResult = this.getHolidayLimitCountTypeValue(ctType, holidayType, personId, field, holidayLimitCountType23TempDataMap);
                return countResult.doubleValue();
            }
            return 0.0;
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1.0;
        }
    }

    public double getHolidayTimeCount(Map<String, Object> globalMap, String personId, String holidayType) throws Exception {
        Map<String, Object> leaveBillTimeLengthTempDataMap;
        List<String> personIds;
        String personIdsString = null;
        String beginDate = (String)globalMap.get(PERIODBEGINDATE);
        String endDate = (String)globalMap.get(PERIODENDDATE);
        if (globalMap.get("personIdsForSumResult") != null) {
            personIds = (List)globalMap.get("personIdsForSumResult");
            personIdsString = AtsServerCalUtils.getPersonIds(personIds);
        } else {
            personIds = new ArrayList();
            personIds.add(personId);
            personIdsString = AtsServerCalUtils.getPersonIds(personIds);
        }
        if (globalMap.get("leaveBillTimeLengthTempDataMap") != null) {
            leaveBillTimeLengthTempDataMap = (Map<String, Object>)globalMap.get("LeaveBillTimeLengthTempDataMap");
            if (String.valueOf(leaveBillTimeLengthTempDataMap.get("personIdsString")).equals(personIdsString)) {
                if (leaveBillTimeLengthTempDataMap.get(personId) != null) {
                    return (Double)leaveBillTimeLengthTempDataMap.get(personId);
                }
                return 0.0;
            }
            leaveBillTimeLengthTempDataMap = this.getLeaveBillTimeLengthTempDataMap(personIdsString, beginDate, endDate, holidayType);
            globalMap.put("leaveBillTimeLengthTempDataMap", leaveBillTimeLengthTempDataMap);
            if (leaveBillTimeLengthTempDataMap.get(personId) != null) {
                return (Double)leaveBillTimeLengthTempDataMap.get(personId);
            }
            return 0.0;
        }
        leaveBillTimeLengthTempDataMap = this.getLeaveBillTimeLengthTempDataMap(personIdsString, beginDate, endDate, holidayType);
        globalMap.put("leaveBillTimeLengthTempDataMap", leaveBillTimeLengthTempDataMap);
        if (leaveBillTimeLengthTempDataMap.get(personId) != null) {
            return (Double)leaveBillTimeLengthTempDataMap.get(personId);
        }
        return 0.0;
    }

    public BigDecimal getHolidayLimitCountTypeValue(int ctType, String holidayType, String personId, String field, Map<String, Object> holidayLimitCountTypeTempDataMap) throws Exception {
        BigDecimal countResult = new BigDecimal(0);
        HolidayLimitCollection coll = (HolidayLimitCollection)((Object)holidayLimitCountTypeTempDataMap.get(personId));
        if (ctType == 0 || ctType == 2) {
            for (int i = 0; i < coll.size(); ++i) {
                HolidayLimitInfo limitInfo = coll.get(i);
                if (!holidayType.equals(limitInfo.getHolidayPolicy().getHolidayType().getNumber())) continue;
                BigDecimal result = null;
                result = REMAINLIMIT.equalsIgnoreCase(StringUtils.trim((String)field)) || MLUtile.getRes(AtsAttenceResEnum.remainLimit, this.ctx).equalsIgnoreCase(StringUtils.trim((String)field)) || MLUtile.getRes((ResourceEnum)AtsAttenceResEnum.remainLimit, Locale.CHINESE, new Object[0]).equalsIgnoreCase(StringUtils.trim((String)field)) ? (null == limitInfo.getRemainLimit() || i != 0 && limitInfo.getRemainLimit().compareTo(BigDecimal.ZERO) <= 0 ? BigDecimal.ZERO : limitInfo.getRemainLimit()) : this.getLimitValue(field, limitInfo);
                if (result == null) continue;
                countResult = countResult.add(result);
            }
            return countResult;
        }
        for (int i = 0; i < coll.size(); ++i) {
            HolidayLimitInfo limitInfo = coll.get(i);
            if (!holidayType.equals(limitInfo.getHolidayPolicy().getHolidayType().getNumber())) continue;
            BigDecimal result = this.getLimitValue(field, limitInfo);
            if (result == null) break;
            countResult = result;
            break;
        }
        return countResult;
    }

    private BigDecimal getLimitValue(String field, HolidayLimitInfo limitInfo) {
        BigDecimal result = null;
        if (STANDARDLIMIT.equalsIgnoreCase(StringUtils.trim((String)field)) || MLUtile.getRes(AtsAttenceResEnum.standardLimit, this.ctx).equalsIgnoreCase(StringUtils.trim((String)field)) || MLUtile.getRes((ResourceEnum)AtsAttenceResEnum.standardLimit, Locale.CHINESE, new Object[0]).equalsIgnoreCase(StringUtils.trim((String)field))) {
            result = limitInfo.getStandardLimit();
        }
        if (USEDLIMIT.equalsIgnoreCase(StringUtils.trim((String)field)) || MLUtile.getRes(AtsAttenceResEnum.usedLimit, this.ctx).equalsIgnoreCase(StringUtils.trim((String)field)) || MLUtile.getRes((ResourceEnum)AtsAttenceResEnum.usedLimit, Locale.CHINESE, new Object[0]).equalsIgnoreCase(StringUtils.trim((String)field))) {
            result = limitInfo.getUsedLimit();
        }
        if (FREEZELIMIT.equalsIgnoreCase(StringUtils.trim((String)field)) || MLUtile.getRes(AtsAttenceResEnum.freezeLimit, this.ctx).equalsIgnoreCase(StringUtils.trim((String)field)) || MLUtile.getRes((ResourceEnum)AtsAttenceResEnum.freezeLimit, Locale.CHINESE, new Object[0]).equalsIgnoreCase(StringUtils.trim((String)field))) {
            result = limitInfo.getFreezeLimit();
        }
        if (REMAINLIMIT.equalsIgnoreCase(StringUtils.trim((String)field)) || MLUtile.getRes(AtsAttenceResEnum.remainLimit, this.ctx).equalsIgnoreCase(StringUtils.trim((String)field)) || MLUtile.getRes((ResourceEnum)AtsAttenceResEnum.remainLimit, Locale.CHINESE, new Object[0]).equalsIgnoreCase(StringUtils.trim((String)field))) {
            result = limitInfo.getRemainLimit();
        }
        if (SHIFTTOTALREMAINLIMIT.equalsIgnoreCase(StringUtils.trim((String)field)) || MLUtile.getRes(AtsAttenceResEnum.shiftTotalRemainLimit, this.ctx).equalsIgnoreCase(StringUtils.trim((String)field)) || MLUtile.getRes((ResourceEnum)AtsAttenceResEnum.shiftTotalRemainLimit, Locale.CHINESE, new Object[0]).equalsIgnoreCase(StringUtils.trim((String)field))) {
            result = limitInfo.getShiftTotalRemainLimit();
        }
        if (PREOVERDRAFTLIMIT.equalsIgnoreCase(StringUtils.trim((String)field)) || MLUtile.getRes(AtsAttenceResEnum.preOverdraftLimit, this.ctx).equalsIgnoreCase(StringUtils.trim((String)field)) || MLUtile.getRes((ResourceEnum)AtsAttenceResEnum.preOverdraftLimit, Locale.CHINESE, new Object[0]).equalsIgnoreCase(StringUtils.trim((String)field))) {
            result = limitInfo.getPreOverdraftLimit();
        }
        return result;
    }

    public Map<String, Object> getHolidayLimitCountType01TempDataMap(String personIdsString, String beginDate, String endDate) throws Exception {
        HashMap<String, Object> personIdHolidayLimitCollMap = new HashMap<String, Object>();
        personIdHolidayLimitCollMap.put("personIdsString", personIdsString);
        StringBuffer sb = new StringBuffer();
        sb.append(" select * ,holidayPolicy.holidayType.* where  proposer.id in (" + personIdsString + ") ");
        sb.append(" AND ( ");
        sb.append("(effectDate >= {ts '" + beginDate + " 00:00:00'} and effectDate <= {ts '" + endDate + " 23:59:59'} ) ");
        sb.append("or ");
        sb.append("(delayDate >= {ts '" + beginDate + " 00:00:00'} and delayDate <= {ts '" + endDate + " 23:59:59'} ) ");
        sb.append("or ");
        sb.append("(effectDate <= {ts '" + beginDate + " 00:00:00'} and delayDate >= {ts '" + endDate + " 23:59:59'} ) ");
        sb.append(") ");
        sb.append(" order by cycleBeginDate desc");
        HolidayLimitCollection coll = HolidayLimitFactory.getLocalInstance(this.ctx).getHolidayLimitCollection(sb.toString());
        if (coll != null && coll.size() > 0) {
            for (int i = 0; i < coll.size(); ++i) {
                HolidayLimitCollection detailColl;
                HolidayLimitInfo info = coll.get(i);
                String proposerId = info.getProposer().getId().toString();
                if (personIdHolidayLimitCollMap.get(proposerId) != null) {
                    detailColl = (HolidayLimitCollection)((Object)personIdHolidayLimitCollMap.get(proposerId));
                    detailColl.add(info);
                    continue;
                }
                detailColl = new HolidayLimitCollection();
                detailColl.add(info);
                personIdHolidayLimitCollMap.put(proposerId, (Object)detailColl);
            }
        }
        return personIdHolidayLimitCollMap;
    }

    public Map<String, Object> getHolidayLimitCountType23TempDataMap(String personIdsString, String beginDate, String endDate) throws Exception {
        HashMap<String, Object> personIdHolidayLimitCollMap = new HashMap<String, Object>();
        personIdHolidayLimitCollMap.put("personIdsString", personIdsString);
        String oql = " select * ,holidayPolicy.holidayType.* where delayDate >= {ts '" + beginDate + " 00:00:00'}  and delayDate <= {ts '" + endDate + " 23:59:59'} and proposer.id in (" + personIdsString + ")  order by cycleBeginDate desc ";
        HolidayLimitCollection coll = HolidayLimitFactory.getLocalInstance(this.ctx).getHolidayLimitCollection(oql);
        if (coll != null && coll.size() > 0) {
            for (int i = 0; i < coll.size(); ++i) {
                HolidayLimitCollection detailColl;
                HolidayLimitInfo info = coll.get(i);
                String proposerId = info.getProposer().getId().toString();
                if (personIdHolidayLimitCollMap.get(proposerId) != null) {
                    detailColl = (HolidayLimitCollection)((Object)personIdHolidayLimitCollMap.get(proposerId));
                    detailColl.add(info);
                    continue;
                }
                detailColl = new HolidayLimitCollection();
                detailColl.add(info);
                personIdHolidayLimitCollMap.put(proposerId, (Object)detailColl);
            }
        }
        return personIdHolidayLimitCollMap;
    }

    public double getAtsProjectResult(String periodName, String projectNum, Map paramMap) throws EASBizException, BOSException {
        String personId = (String)paramMap.get(T_HR_ATS_ATTENDANCERESULTSUM_FPROPOSERID);
        double result = 0.0;
        try {
            String columnNo = null;
            IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)"select fcolumnno from T_HR_ATS_AttendanceProject where fnumber=?", (Object[])new Object[]{projectNum});
            while (rs.next()) {
                columnNo = rs.getString("fcolumnno");
            }
            if (null != columnNo) {
                StringBuffer sb = new StringBuffer();
                sb.append(" select SUM(S" + columnNo + ") SNO from T_HR_ATS_ATTENDANCERESULTSUM A ").append(" INNER JOIN T_HR_ATS_AttendancePeriod B ON A.FATTENDANCEPERIODID = B.FID ").append("WHERE B.fname").append(MLUtile.getMlFlag(this.ctx)).append(" = ?  and a.fproposerid = ? ");
                rs = DbUtil.executeQuery((Context)this.ctx, (String)sb.toString(), (Object[])new Object[]{periodName, personId});
                while (rs.next()) {
                    BigDecimal sno = rs.getBigDecimal("SNO");
                    if (null == sno) continue;
                    result = sno.doubleValue();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public double getAtsProjectResultPreDay(String projectNum, Map paramMap) throws EASBizException, BOSException {
        String personId = (String)paramMap.get(T_HR_ATS_ATTENDANCERESULT_FPROPOSERID);
        String currDateStr = (String)paramMap.get(T_HR_ATS_ATTENDANCERESULT_FATTENCEDATE);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        Map globalMap = (Map)paramMap.get(GLOBALMAPKEY);
        Map calResultInfoMap = (Map)globalMap.get("calResultInfoMap");
        double result = 0.0;
        int columnNo = AtsCalFunctionUtil.getAtsProjectColumnNo(this.ctx, projectNum, paramMap);
        if (0 == columnNo) {
            return result;
        }
        String preDay = AtsDateUtils.getPreDay(currDateStr);
        String resultInfoKey = MessageFormat.format("{0}{1}{2}", personId, "_", preDay);
        if (AtsCollectionUtile.isEmpty(calResultInfoMap)) {
            return result;
        }
        Map resultInfo = (Map)calResultInfoMap.get(resultInfoKey);
        if (AtsCollectionUtile.isEmpty(resultInfo)) {
            return result;
        }
        String columnName = MessageFormat.format("{0}{1}", "S", columnNo);
        result = null == resultInfo.get(columnName) ? BigDecimal.ZERO.doubleValue() : new BigDecimal(resultInfo.get(columnName).toString()).doubleValue();
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int getAtsProjectColumnNo(String projectName, Map paramMap) {
        int columnNo = 0;
        String[] projectNumArr = projectName.toUpperCase().split("S");
        String projectNameClone = "";
        if (projectNumArr.length > 0) {
            projectNameClone = projectNumArr[projectNumArr.length - 1];
        }
        try {
            return Integer.parseInt(projectNameClone);
        }
        catch (Exception e) {
            AttendanceProjectInfo atsProject;
            Map attendanceProjectMap = (Map)((Map)paramMap.get(GLOBALMAPKEY)).get("T_HR_ATS_AttendanceProject");
            Collection atsProjects = attendanceProjectMap.values();
            Iterator iter = atsProjects.iterator();
            do {
                if (!iter.hasNext()) return columnNo;
            } while (!(atsProject = (AttendanceProjectInfo)iter.next()).getName().equals(projectName));
            return atsProject.getColumnNO();
        }
    }

    public double getProjectPreSumResult(String projectNum, Map paramMap) throws EASBizException, BOSException {
        String personId = (String)paramMap.get(T_HR_ATS_ATTENDANCERESULT_FPROPOSERID);
        String currDateStr = (String)paramMap.get(T_HR_ATS_ATTENDANCERESULT_FATTENCEDATE);
        Map globalMap = (Map)paramMap.get(GLOBALMAPKEY);
        Map calResultInfoMap = (Map)globalMap.get("calResultInfoMap");
        String cycleBeginDate = this.getCycleBeginOrEnd(paramMap, "0");
        String cycleEndDate = this.getCycleBeginOrEnd(paramMap, "1");
        String personids = (String)globalMap.get("resultCal_personids");
        double result = 0.0;
        try {
            String currDatePreDateStr = AtsDateUtils.getPreDay(currDateStr);
            if (currDatePreDateStr.compareTo(cycleBeginDate) < 0) {
                return result;
            }
            if (AtsCollectionUtile.isEmpty(calResultInfoMap)) {
                return result;
            }
            BigDecimal resultDecimal = BigDecimal.ZERO;
            int columnNo = AtsCalFunctionUtil.getAtsProjectColumnNo(this.ctx, projectNum, paramMap);
            if (0 == columnNo) {
                return result;
            }
            String tableColumnNo = new StringBuffer("S").append(columnNo).toString();
            Map<String, BigDecimal> personDateAndDetail = null;
            String cycleBeginDt = cycleBeginDate;
            while (currDatePreDateStr.compareTo(cycleBeginDate) >= 0) {
                String personAndDate = new StringBuffer(personId).append("_").append(cycleBeginDate).toString();
                Map resultInfo = (Map)calResultInfoMap.get(personAndDate);
                cycleBeginDate = AtsDateUtils.getNextDay(cycleBeginDate);
                if (null == resultInfo || null == resultInfo.get(tableColumnNo)) {
                    if (null == personDateAndDetail) {
                        personDateAndDetail = this.getResultDataByPeriod(tableColumnNo, personids, cycleBeginDt, cycleEndDate, globalMap);
                    }
                    if (null == personDateAndDetail || null == personDateAndDetail.get(personAndDate)) continue;
                    BigDecimal snoVal = personDateAndDetail.get(personAndDate);
                    resultDecimal = resultDecimal.add(snoVal);
                    continue;
                }
                resultDecimal = resultDecimal.add(new BigDecimal(resultInfo.get(tableColumnNo).toString()));
            }
            result = resultDecimal.doubleValue();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public Map<String, BigDecimal> getResultDataByPeriod(String columnNo, String personids, String cycleBeginDate, String cycleEndDate, Map<String, Object> globalMap) throws EASBizException, BOSException {
        String attenceSumFunKey = MessageFormat.format("{0}_{1}_{2}", personids, "attenceSumFunKey", columnNo);
        HashMap<String, BigDecimal> personDateAndDetail = (HashMap<String, BigDecimal>)globalMap.get(attenceSumFunKey);
        if (null != personDateAndDetail) {
            return personDateAndDetail;
        }
        personDateAndDetail = new HashMap<String, BigDecimal>();
        try {
            StringBuffer sb = new StringBuffer();
            sb.append(" select ").append(columnNo).append(" SNO , fproposerid , FATTENCEDATE   from T_HR_ATS_ATTENDANCERESULT  ").append(" WHERE  fproposerid in ( ").append(personids).append(") and FATTENCEDATE >= {ts '").append(cycleBeginDate).append(" 00:00:00'} and FATTENCEDATE <={ts '").append(cycleEndDate).append(" 23:59:59'}");
            IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)sb.toString());
            while (rs.next()) {
                BigDecimal sno = null == rs.getBigDecimal("SNO") ? BigDecimal.ZERO : rs.getBigDecimal("SNO");
                String personId = rs.getString("fproposerid");
                String attenceDate = null == rs.getTimestamp("FATTENCEDATE") ? "" : AtsDateUtils.timestampToShortString(rs.getTimestamp("FATTENCEDATE"));
                personDateAndDetail.put(MessageFormat.format("{0}_{1}", personId, attenceDate), sno);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (personDateAndDetail.size() > 0) {
            globalMap.put(attenceSumFunKey, personDateAndDetail);
        }
        return personDateAndDetail;
    }

    public double getProjectPreCountResult(String projectNum, double projectValue, Map paramMap) throws EASBizException, BOSException {
        String personId = (String)paramMap.get(T_HR_ATS_ATTENDANCERESULT_FPROPOSERID);
        String currDateStr = (String)paramMap.get(T_HR_ATS_ATTENDANCERESULT_FATTENCEDATE);
        Map globalMap = (Map)paramMap.get(GLOBALMAPKEY);
        Map calResultInfoMap = (Map)globalMap.get("calResultInfoMap");
        String cycleBeginDate = this.getCycleBeginOrEnd(paramMap, "0");
        BigDecimal projectValueDec = BigDecimal.valueOf(projectValue);
        String cycleEndDate = this.getCycleBeginOrEnd(paramMap, "1");
        String personids = (String)globalMap.get("resultCal_personids");
        double result = 0.0;
        try {
            String currDatePreDateStr = AtsDateUtils.getPreDay(currDateStr);
            if (currDatePreDateStr.compareTo(cycleBeginDate) < 0) {
                return result;
            }
            if (AtsCollectionUtile.isEmpty(calResultInfoMap)) {
                return result;
            }
            int columnNo = AtsCalFunctionUtil.getAtsProjectColumnNo(this.ctx, projectNum, paramMap);
            if (0 == columnNo) {
                return result;
            }
            String tableColumnNo = new StringBuffer("S").append(columnNo).toString();
            Map<String, BigDecimal> personDateAndDetail = null;
            while (currDatePreDateStr.compareTo(cycleBeginDate) >= 0) {
                BigDecimal resultValue;
                String personAndDate = new StringBuffer(personId).append("_").append(cycleBeginDate).toString();
                Map resultInfo = (Map)calResultInfoMap.get(personAndDate);
                cycleBeginDate = AtsDateUtils.getNextDay(cycleBeginDate);
                if (null == resultInfo || null == resultInfo.get(tableColumnNo)) {
                    if (null == personDateAndDetail) {
                        personDateAndDetail = this.getResultDataByPeriod(tableColumnNo, personids, cycleBeginDate, cycleEndDate, globalMap);
                    }
                    if (null == personDateAndDetail || null == personDateAndDetail.get(personAndDate) || (resultValue = personDateAndDetail.get(personAndDate)).compareTo(BigDecimal.ZERO) < 0 || resultValue.compareTo(projectValueDec) >= 0) continue;
                    result += 1.0;
                    continue;
                }
                resultValue = new BigDecimal(resultInfo.get(tableColumnNo).toString());
                if (resultValue.compareTo(BigDecimal.ZERO) < 0 || resultValue.compareTo(projectValueDec) >= 0) continue;
                result += 1.0;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public double getFillSignTimesByResult(String reasonNumber, Map paramMap) throws EASBizException, BOSException {
        return AtsCalFunctionUtil.getFillSignTimesByResult(this.ctx, reasonNumber, paramMap);
    }

    public double getIntersectTimeForLeaveBill(Map paramMap) throws EASBizException, BOSException {
        return AtsCalFunctionUtil.getIntersectTimeForLeaveBill(this.ctx, paramMap);
    }

    public double getIntersectTimeForTripBill(Map paramMap) throws EASBizException, BOSException {
        return AtsCalFunctionUtil.getIntersectTimeForTripBill(this.ctx, paramMap);
    }

    public double getAtsfileHisCalendarDayType(Map paramMap) throws EASBizException, BOSException {
        return AtsCalFunctionUtil.getAtsFileHisCalendarDayType(this.ctx, paramMap);
    }

    public double getAtsfileHisCalendarDayCount(double countType, Map paramMap) throws Exception {
        return AtsCalFunctionUtil.getAtsFileHisCalendarDayCount(this.ctx, countType, paramMap);
    }

    public String getMonthlyStatementData(Map paramMap) {
        try {
            String currDateStr = (String)paramMap.get(T_HR_ATS_ATTENDANCERESULT_FATTENCEDATE);
            String personId = (String)paramMap.get(T_HR_ATS_ATTENDANCERESULT_FPROPOSERID);
            if (!StringUtils.isEmpty((String)personId) && !StringUtils.isEmpty((String)currDateStr)) {
                return AtsCalFunctionUtil.getMonthlyStatementDataByDate(paramMap);
            }
            return AtsCalFunctionUtil.getMonthlyStatementDataByPeriod(paramMap);
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    public double getTripBillOutShiftTime(double unitValue, Map paramMap) throws EASBizException, BOSException, UuidException, SQLException {
        Object[] tripResult;
        AttendanceDynamicResInfo dynamicResInfo;
        String personId = (String)paramMap.get(T_HR_ATS_ATTENDANCERESULT_FPROPOSERID);
        String attendDate = (String)paramMap.get(T_HR_ATS_ATTENDANCERESULT_FATTENCEDATE);
        int unitvalue = BigDecimal.valueOf(unitValue).intValue();
        Map globalMap = (Map)paramMap.get(GLOBALMAPKEY);
        int decimalPlaces = DecimalPlaceUtil.getDecimalPlace(this.ctx, globalMap);
        double tripDay = 0.0;
        AttencePolicyInfo attencePolicyInfo = AtsCalFunctionUtil.getAttencePolicyInfoByResultCal(globalMap, personId, attendDate);
        if (null != attencePolicyInfo && null != attencePolicyInfo.getAtencePolicyExt()) {
            globalMap.put("tripLengthCalType", attencePolicyInfo.getAtencePolicyExt().getTripLengthCalType());
        }
        if (null != (dynamicResInfo = AtsCalFunctionUtil.getAttendanceDynamicResInfo(globalMap, personId, attendDate))) {
            globalMap.put("AttendanceDynamicResInfo", dynamicResInfo);
        }
        if (null != (tripResult = AtsCalculateTimeUtil.calTripTime(this.ctx, personId, attendDate, globalMap, true))) {
            double tripTime = (Double)tripResult[0];
            BigDecimal standardHour = (BigDecimal)tripResult[2];
            if (null == standardHour) {
                standardHour = BigDecimal.ZERO;
            }
            if (unitvalue == 1 && standardHour.compareTo(BigDecimal.ZERO) > 0) {
                tripDay = DecimalPlaceUtil.decimalPlaceCtrl(this.ctx, AtsDateUtils.divide(BigDecimal.valueOf(tripTime), standardHour, DecimalPlaceUtil.getDefaultDecimalPlacesCal()), decimalPlaces).doubleValue();
            }
            if (unitvalue == 2) {
                tripDay = DecimalPlaceUtil.decimalPlaceCtrl(this.ctx, BigDecimal.valueOf(tripTime), decimalPlaces).doubleValue();
            }
        }
        return tripDay;
    }

    public double getIntersectTimeForTrip(Map paramMap) throws EASBizException, BOSException {
        return AtsCalFunctionUtil.getIntersectTimeForTrip(this.ctx, paramMap);
    }

    public double getScheduleShiftDaysAllCount(double countType, Map paramMap) throws Exception {
        try {
            int ctType = BigDecimal.valueOf(countType).intValue();
            if (ctType != 0 && ctType != 1 && ctType != 2 && ctType != 3) {
                return -1.0;
            }
            Map globalMap = (Map)paramMap.get(GLOBALMAPKEY);
            String beginDate = (String)globalMap.get(PERIODBEGINDATE);
            String endDate = (String)globalMap.get(PERIODENDDATE);
            String personId = (String)paramMap.get(T_HR_ATS_ATTENDANCERESULTSUM_FPROPOSERID);
            if (StringUtils.isEmpty((String)beginDate)) {
                beginDate = this.getCycleBeginOrEnd(paramMap, "0");
            }
            if (StringUtils.isEmpty((String)endDate)) {
                endDate = this.getCycleBeginOrEnd(paramMap, "1");
            }
            Map shiftItemMap = (Map)globalMap.get("ALL_T_HR_ATS_ScheduleShift");
            Double countResult = AtsCalFunctionUtil.getShiftDaysCount(ctType, beginDate, endDate, personId, shiftItemMap);
            return countResult;
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1.0;
        }
    }

    public double getAttendanceTimeBySpecifiedDate(String beginTime, String endTime, double isSubtractRestTime, double isSubtractLeaveTime, double isSubtractTripTime, Map paramMap) throws Exception {
        return AtsCalFunctionUtil.getAttendanceTimeBySpecifiedDate(this.ctx, beginTime, endTime, isSubtractRestTime, isSubtractLeaveTime, isSubtractTripTime, paramMap);
    }

    public double getProjectValueByTypeAndOffset(double cycleType, double offset, String projectNum, Map paramMap) throws EASBizException, BOSException {
        int _cycleType = BigDecimal.valueOf(cycleType).intValue();
        if (_cycleType != 0 && _cycleType != 1 && _cycleType != 2 && _cycleType != 3) {
            return -9.99999999E8;
        }
        int _offset = BigDecimal.valueOf(offset).intValue();
        Map globalMap = (Map)paramMap.get(GLOBALMAPKEY);
        String cycleBeginDate = (String)globalMap.get(PERIODBEGINDATE);
        String cycleEndDate = (String)globalMap.get(PERIODENDDATE);
        if (StringUtils.isEmpty((String)cycleBeginDate)) {
            cycleBeginDate = this.getCycleBeginOrEnd(paramMap, "0");
        }
        if (StringUtils.isEmpty((String)cycleEndDate)) {
            cycleEndDate = this.getCycleBeginOrEnd(paramMap, "1");
        }
        return AtsCalFunctionUtil.getProjectValueByTypeAndOffset(this.ctx, paramMap, _cycleType, _offset, projectNum, cycleBeginDate, cycleEndDate);
    }

    public static AttendanceFileInfo getAttendancePolicyBySumCal(Map globalMap, String personId) {
        Map fileInfoObject = (Map)globalMap.get("T_HR_ATS_AttendanceFile");
        String beginDate = (String)globalMap.get(PERIODBEGINDATE);
        String endDate = (String)globalMap.get(PERIODENDDATE);
        AttendanceFileInfo attenceFile = (AttendanceFileInfo)fileInfoObject.get(personId + "_" + endDate);
        if (attenceFile == null) {
            attenceFile = (AttendanceFileInfo)fileInfoObject.get(personId + "_" + beginDate);
        }
        if (attenceFile == null) {
            attenceFile = (AttendanceFileInfo)fileInfoObject.get(personId + "_" + AtsDateUtils.dateShortFormatToStr(new Date()));
        }
        if (attenceFile == null) {
            List<String> datelist = AtsDateUtils.getDateList(beginDate, endDate);
            for (int i = 0; i < datelist.size() && (attenceFile = (AttendanceFileInfo)fileInfoObject.get(personId + "_" + datelist.get(i))) == null; ++i) {
            }
        }
        return attenceFile;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String getEmpLaborRelationType(String baseDate, Map paramMap) throws Exception {
        try {
            String calDate = null;
            if (StringUtils.isNotBlank((String)baseDate)) {
                if (!AtsDateUtils.isValidShortDate(baseDate).booleanValue()) return null;
                calDate = baseDate;
            } else {
                calDate = AtsDateUtils.dateShortToString(new Date());
            }
            String personId = (String)paramMap.get(T_HR_ATS_ATTENDANCERESULTSUM_FPROPOSERID);
            if (StringUtils.isBlank((String)personId)) {
                personId = (String)paramMap.get(T_HR_ATS_ATTENDANCERESULT_FPROPOSERID);
            }
            String lan = "L2";
            AttendanceFileInfo attendanceFileInfo = AtsLeaveBillUtil.getAttendanceFileInfo(this.ctx, personId);
            if (attendanceFileInfo == null || attendanceFileInfo.getAttencePolicy() == null || attendanceFileInfo.getAttencePolicy().getMultiLanLocale() != null) {
                lan = attendanceFileInfo.getAttencePolicy().getMultiLanLocale().getValue();
            }
            String sql = "SELECT BDEmployeeType.FName_" + lan + " name FROM T_HR_EmpLaborRelationHis EmpLaborRelationHis INNER JOIN T_HR_BDEmployeeType BDEmployeeType ON EmpLaborRelationHis.FLaborRelationStateID = BDEmployeeType.FId WHERE EmpLaborRelationHis.FEFFDT <= {ts '" + calDate + "'} AND EmpLaborRelationHis.FLEFFDT >= {ts '" + calDate + "'} AND EmpLaborRelationHis.FPersonID= '" + personId + "'";
            String name = null;
            IRowSet rowSet = DbUtil.executeQuery((Context)this.ctx, (String)sql.toString());
            while (rowSet.next()) {
                name = rowSet.getString("name");
            }
            return name;
        }
        catch (Exception e) {
            logger.error((Object)"catch exception", (Throwable)e);
            throw e;
        }
    }

    public double getIntersectTimeForAll(String labels, String excludeLabel, Map paramMap) throws EASBizException, BOSException {
        Map globalMap = (Map)paramMap.get(GLOBALMAPKEY);
        if (StringUtils.isNotEmpty((String)labels)) {
            String personId = (String)paramMap.get(T_HR_ATS_ATTENDANCERESULT_FPROPOSERID);
            String attendDate = (String)paramMap.get(T_HR_ATS_ATTENDANCERESULT_FATTENCEDATE);
            List<String> labelList = AtsUtil.getListFromStringArr(labels.split("_"));
            List<Object> excludeLabels = new ArrayList();
            if (StringUtils.isNotEmpty((String)excludeLabel)) {
                excludeLabels = AtsUtil.getListFromStringArr(excludeLabel.split("_"));
            } else {
                excludeLabels = new ArrayList();
                excludeLabels.add("otRest");
                excludeLabels.add("rest");
            }
            ArrayList<Object> allLabelList = new ArrayList<Object>();
            allLabelList.addAll(labelList);
            allLabelList.addAll(excludeLabels);
            Iterator iter = allLabelList.iterator();
            DataPrepareServiceImpl dataPrepareServiceImpl = new DataPrepareServiceImpl();
            TimeDataProcess dataProcess = null;
            ArrayList<TimeLabelModel> timeLabelModels = new ArrayList<TimeLabelModel>();
            while (iter.hasNext()) {
                String label = (String)iter.next();
                TimeDataVO dataVO = dataPrepareServiceImpl.getTimeDataVO(paramMap, personId, attendDate, label);
                dataProcess = DataProcessFactory.getInstance().createTimeDataProcess(label);
                List<TimeLabelModel> timeLabelModelList = dataProcess.process(dataVO);
                timeLabelModels.addAll(timeLabelModelList);
            }
            AtsCalculatorContext atsCtx = new AtsCalculatorContext(new BaseCalculatorStrategy());
            return atsCtx.executeStrategy(timeLabelModels, labelList, excludeLabels);
        }
        return 0.0;
    }
}

