/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.ats.function;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.hr.ats.HolidayTypeUnitEnum;
import com.kingdee.eas.hr.ats.app.formula.calculate.data.Tools;
import com.kingdee.eas.hr.ats.util.AtsDateUtils;
import com.kingdee.eas.hr.ats.util.common.MLUtile;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.text.ParseException;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class AtsLeaveBillEntryDataFunc {
    private final long oneDayTime = 86400000L;

    public Object getCurrentLeaveEntryData(Map paramMap) throws ParseException, BOSException, SQLException {
        Context ctx = Tools.getInstance().getCtx();
        String personId = (String)paramMap.get("T_HR_ATS_ATTENDANCERESULT_FPROPOSERID");
        String currDateStr = (String)paramMap.get("T_HR_ATS_ATTENDANCERESULT_FATTENCEDATE");
        return this.getLeaveEntryData(ctx, personId, currDateStr, currDateStr);
    }

    public Object getLeaveEntryData(Context ctx, String personIds, String strBeginDate, String strEndDate) throws BOSException, SQLException {
        HashMap resultMap = new HashMap();
        if (StringUtils.isEmpty((String)personIds)) {
            return resultMap;
        }
        String personsWhere = "(";
        for (String personId : personIds.split(",")) {
            personsWhere = personsWhere + "'" + personId + "',";
        }
        personsWhere = personsWhere + "'')";
        String sql = "select leaveBill.fnumber as billNum,leaveBill.Fleavedate,entry.fbillId,entry.fbeginTime,entry.fendTime,entry.fleaveLength,entry.freason,entry.fremark,entry.frealBeginTime,entry.frealEndTime,entry.frealLeaveLength,entry.frealUnit,entry.fpersonId,policy.fid as policyId,policy.fname" + MLUtile.getMlFlag(ctx) + " policyName,policy.fnumber  from t_hr_ats_leavebilldetail leaveBill  inner join t_hr_ats_leavebillentry entry on leaveBill.fid = entry.fbillid left join T_HR_ATS_HolidayPolicy policy on entry.FPolicyID = policy.fid where entry.fpersonId in " + personsWhere + "   and entry.frealEndTime <= {ts '" + strBeginDate + "'}   and entry.frealBeginTime >= {ts '" + strEndDate + "'} ";
        IRowSet iRow = DbUtil.executeQuery((Context)ctx, (String)sql, null);
        if (iRow != null) {
            while (iRow.next()) {
                String personId;
                HashMap<String, Object> tempMap = new HashMap<String, Object>();
                personId = iRow.getString("fpersonId");
                String realBeginDate = AtsDateUtils.dateShortToString(iRow.getTimestamp("frealBeginTime"));
                String realEndDate = AtsDateUtils.dateShortToString(iRow.getTimestamp("frealBeginTime"));
                tempMap.put("leaveDate", AtsDateUtils.dateShortToString(iRow.getDate("fleaveDate")));
                tempMap.put("billId", iRow.getString("fbillId"));
                tempMap.put("billId.number", iRow.getString("billNum"));
                tempMap.put("beginTime", AtsDateUtils.dateLongToString(iRow.getDate("fbeginTime")));
                tempMap.put("endTime", AtsDateUtils.dateLongToString(iRow.getDate("fendTime")));
                BigDecimal leaveLength = iRow.getBigDecimal("frealLeaveLength");
                tempMap.put("leaveLength", leaveLength == null ? "" : Double.valueOf(leaveLength.doubleValue()));
                tempMap.put("policy.id", iRow.getString("policyId"));
                tempMap.put("policy.name", iRow.getString("policyName"));
                tempMap.put("policy.number", iRow.getString("fnumber"));
                tempMap.put("reason", iRow.getString("freason"));
                tempMap.put("remark", iRow.getString("fremark"));
                tempMap.put("realBeginTime", realBeginDate);
                tempMap.put("realBeginDate", realEndDate);
                BigDecimal realLeaveLength = iRow.getBigDecimal("realLeaveLength");
                tempMap.put("realLeaveLength", realLeaveLength == null ? "" : Double.valueOf(realLeaveLength.doubleValue()));
                HolidayTypeUnitEnum unitEnum = HolidayTypeUnitEnum.getEnum(iRow.getInt("frealUnit"));
                tempMap.put("realUnit.value", unitEnum.getValue());
                tempMap.put("realUnit.alias", unitEnum.getAlias());
                Date beginDate = AtsDateUtils.stringToShortDate(realBeginDate);
                Date endDate = AtsDateUtils.stringToShortDate(realEndDate);
                HashMap dataMap = (HashMap)resultMap.get(personId);
                while (beginDate.getTime() <= endDate.getTime()) {
                    HashSet<HashMap<String, Object>> set;
                    String dateKey = AtsDateUtils.dateShortToString(beginDate);
                    if (dataMap != null) {
                        if (dataMap.containsKey(dateKey)) {
                            ((HashSet)dataMap.get(dateKey)).add(tempMap);
                        } else {
                            set = new HashSet<HashMap<String, Object>>();
                            set.add(tempMap);
                            dataMap.put(dateKey, set);
                        }
                    } else {
                        dataMap = new HashMap();
                        set = new HashSet();
                        set.add(tempMap);
                        dataMap.put(dateKey, set);
                        resultMap.put(personId, dataMap);
                    }
                    beginDate.setTime(beginDate.getTime() + 86400000L);
                }
            }
        }
        return resultMap;
    }
}

