/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.ats.function;

import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.data.ColumnInfo;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.eas.hr.ats.ComprehensiveType;
import com.kingdee.eas.hr.ats.PunchCardRecordInfo;
import com.kingdee.eas.hr.ats.app.formula.calculate.data.Tools;
import com.kingdee.eas.hr.ats.util.AtsDateUtils;
import com.kingdee.shr.ml.util.BOSConfigUtil;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class CardDataDetailFunc {
    private static final String NO_CARD_RESULT = "-1";
    private static final String RESULT_DATE = "datas";
    private static final String CARD_FLAG_NAME = "S";
    private static final String ENTITY_NAME = "com.kingdee.eas.hr.ats.PunchCardRecord";
    private Context ctx = Tools.getInstance().getCtx();

    public Context getCtx() {
        return this.ctx;
    }

    public void setCtx(Context ctx) {
        this.ctx = ctx;
    }

    public String getCardData(Map paramMap, String carditem, String filed) {
        String cardTime;
        Map calResultInfoMap;
        String personId = (String)paramMap.get("T_HR_ATS_ATTENDANCERESULT_FPROPOSERID");
        String currDateStr = (String)paramMap.get("T_HR_ATS_ATTENDANCERESULT_FATTENCEDATE");
        Map globalMap = (Map)paramMap.get("globalMapKey");
        Map punchCardRecordMap = (Map)globalMap.get("punchCardInfoMap");
        String key = personId + "_" + currDateStr;
        String preDayKey = personId + "_" + AtsDateUtils.getPreDay(currDateStr);
        String nextDayKey = personId + "_" + AtsDateUtils.getNextDay(currDateStr);
        ArrayList<PunchCardRecordInfo> punchCordRecordList = new ArrayList<PunchCardRecordInfo>();
        if (null != punchCardRecordMap.get(key)) {
            punchCordRecordList.addAll((Collection)punchCardRecordMap.get(key));
        }
        if (null != punchCardRecordMap.get(preDayKey)) {
            punchCordRecordList.addAll((Collection)punchCardRecordMap.get(preDayKey));
        }
        if (null != punchCardRecordMap.get(nextDayKey)) {
            punchCordRecordList.addAll((Collection)punchCardRecordMap.get(nextDayKey));
        }
        if (null == (calResultInfoMap = (Map)globalMap.get("calResultInfoMap"))) {
            return NO_CARD_RESULT;
        }
        if (null == punchCardRecordMap || null == punchCordRecordList) {
            return NO_CARD_RESULT;
        }
        String resultInfoKey = MessageFormat.format("{0}{1}{2}", personId, "_", currDateStr);
        if (null == calResultInfoMap || null == calResultInfoMap.get(resultInfoKey)) {
            return NO_CARD_RESULT;
        }
        Map resultInfo = (Map)calResultInfoMap.get(resultInfoKey);
        String string = cardTime = null == resultInfo.get(CARD_FLAG_NAME + carditem) ? null : resultInfo.get(CARD_FLAG_NAME + carditem).toString();
        if (null == cardTime) {
            return NO_CARD_RESULT;
        }
        cardTime = cardTime.contains(".0") ? cardTime.substring(0, cardTime.indexOf(".0")) : cardTime;
        return this.detailDataByFiled(punchCordRecordList, cardTime, filed);
    }

    private String detailDataByFiled(List<PunchCardRecordInfo> punchCordRecordList, String cardTime, String filed) {
        Iterator<PunchCardRecordInfo> iterator = punchCordRecordList.iterator();
        while (iterator.hasNext()) {
            SimpleDateFormat time = new SimpleDateFormat("yyyy-MM-dd HH:mm");
            PunchCardRecordInfo punchCardRecordInfo = iterator.next();
            String punchCardRecordTimeStr = time.format(AtsDateUtils.timestampToDate(punchCardRecordInfo.getPunchCardTime())) + ":00";
            if (StringUtils.isEmpty((CharSequence)punchCardRecordTimeStr) || !punchCardRecordTimeStr.equals(cardTime)) continue;
            return this.getCardData(punchCardRecordInfo, filed);
        }
        return NO_CARD_RESULT;
    }

    private String getCardData(PunchCardRecordInfo punchCardRecordInfo, String filed) {
        if (StringUtils.isEmpty((CharSequence)filed)) {
            return NO_CARD_RESULT;
        }
        if ("punchCardSource".equals(filed)) {
            return null == punchCardRecordInfo.get("punchcardsource") ? NO_CARD_RESULT : (String)punchCardRecordInfo.get("punchcardsource");
        }
        if ("punchCardPlace".equals(filed)) {
            return null == punchCardRecordInfo.getPunchCardPlace() ? NO_CARD_RESULT : punchCardRecordInfo.getPunchCardPlace();
        }
        if ("comprehensiveType".equals(filed)) {
            return null == punchCardRecordInfo.get("comprehensiveType") ? NO_CARD_RESULT : ComprehensiveType.getEnum(Integer.parseInt(punchCardRecordInfo.get("comprehensiveType").toString())).toString();
        }
        if ("punchCardState".equals(filed)) {
            return null == punchCardRecordInfo.getPunchCardState() ? NO_CARD_RESULT : punchCardRecordInfo.getPunchCardState().toString();
        }
        return this.getCardDataEx(filed, punchCardRecordInfo);
    }

    private String getCardDataEx(String filed, PunchCardRecordInfo punchCardRecordInfo) {
        return NO_CARD_RESULT;
    }

    public static Map<String, PropertyInfo> getProperties(Context ctx, String entityName) {
        EntityObjectInfo entityInfo = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx).getEntity((IMetaDataPK)MetaDataPK.create((String)entityName));
        PropertyCollection collection = entityInfo.getInheritedNoDuplicatedProperties();
        LinkedHashMap<String, PropertyInfo> map = new LinkedHashMap<String, PropertyInfo>();
        ColumnInfo column = null;
        PropertyInfo propertyInfo = null;
        List langList = BOSConfigUtil.getLanguageMapingList();
        String lang = null;
        int size = collection.size();
        for (int i = 0; i < size; ++i) {
            propertyInfo = collection.get(i);
            column = propertyInfo.getMappingField();
            if (column == null || !propertyInfo.isConfigured()) continue;
            String name = column.getName();
            if (column.getBoolean("isMultilingual")) {
                if (null == langList || langList.size() <= 0) continue;
                for (int j = 0; j < langList.size(); ++j) {
                    lang = (String)((Map)langList.get(j)).get("lang");
                    if (StringUtils.isEmpty((CharSequence)lang)) continue;
                    map.put(name + "_" + lang, propertyInfo);
                }
                continue;
            }
            map.put(name, propertyInfo);
        }
        return map;
    }
}

