/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.ats.function;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.hr.ats.AtsShiftInfo;
import com.kingdee.eas.hr.ats.AtsShiftTypeInfo;
import com.kingdee.eas.hr.ats.AttencePolicyInfo;
import com.kingdee.eas.hr.ats.CardRuleInfo;
import com.kingdee.eas.hr.ats.HolidayPolicySetInfo;
import com.kingdee.eas.hr.ats.IScheduleShift;
import com.kingdee.eas.hr.ats.OverTimeCompensInfo;
import com.kingdee.eas.hr.ats.ScheduleShiftCollection;
import com.kingdee.eas.hr.ats.ScheduleShiftFactory;
import com.kingdee.eas.hr.ats.ScheduleShiftInfo;
import com.kingdee.eas.hr.ats.ScheduleShiftItemCollection;
import com.kingdee.eas.hr.ats.ScheduleShiftItemInfo;
import com.kingdee.eas.hr.ats.app.formula.calculate.data.Tools;
import com.kingdee.eas.hr.ats.util.AtsDateUtils;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public class ScheduleShiftDataFunc {
    public Object getPersonsShift(Map paramMap) throws ParseException, BOSException {
        Context ctx = Tools.getInstance().getCtx();
        String personId = (String)paramMap.get("T_HR_ATS_ATTENDANCERESULT_FPROPOSERID");
        String strDate = (String)paramMap.get("T_HR_ATS_ATTENDANCERESULT_FATTENCEDATE");
        return this.getPersonsScheduleShift(ctx, personId, strDate, strDate);
    }

    public Object getPersonsScheduleShift(Context ctx, String proposerIds, String strBeginDate, String strEndDate) throws BOSException {
        Date beginDate = AtsDateUtils.stringToShortDate(strBeginDate);
        Date endDate = AtsDateUtils.stringToShortDate(strEndDate);
        EntityViewInfo evi = new EntityViewInfo();
        evi.getSelector().add(new SelectorItemInfo("id"));
        evi.getSelector().add(new SelectorItemInfo("proposer.id"));
        evi.getSelector().add(new SelectorItemInfo("proposer.number"));
        evi.getSelector().add(new SelectorItemInfo("proposer.name"));
        evi.getSelector().add(new SelectorItemInfo("attendDate"));
        evi.getSelector().add(new SelectorItemInfo("dayType"));
        evi.getSelector().add(new SelectorItemInfo("defaultShift.id"));
        evi.getSelector().add(new SelectorItemInfo("defaultShift.name"));
        evi.getSelector().add(new SelectorItemInfo("defaultShift.number"));
        evi.getSelector().add(new SelectorItemInfo("attendFile.id"));
        evi.getSelector().add(new SelectorItemInfo("attendFile.attendanceNum"));
        evi.getSelector().add(new SelectorItemInfo("attendPolicy.id"));
        evi.getSelector().add(new SelectorItemInfo("attendPolicy.name"));
        evi.getSelector().add(new SelectorItemInfo("attendPolicy.number"));
        evi.getSelector().add(new SelectorItemInfo("cardRule.id"));
        evi.getSelector().add(new SelectorItemInfo("cardRule.name"));
        evi.getSelector().add(new SelectorItemInfo("standardHour"));
        evi.getSelector().add(new SelectorItemInfo("hldPlcSet.id"));
        evi.getSelector().add(new SelectorItemInfo("hldPlcSet.name"));
        evi.getSelector().add(new SelectorItemInfo("hldPlcSet.number"));
        evi.getSelector().add(new SelectorItemInfo("shiftType.id"));
        evi.getSelector().add(new SelectorItemInfo("shiftType.name"));
        evi.getSelector().add(new SelectorItemInfo("shiftType.number"));
        evi.getSelector().add(new SelectorItemInfo("otCompens.id"));
        evi.getSelector().add(new SelectorItemInfo("otCompens.name"));
        evi.getSelector().add(new SelectorItemInfo("otCompens.number"));
        FilterInfo dateFilter = new FilterInfo();
        dateFilter.getFilterItems().add(new FilterItemInfo("attendDate", (Object)beginDate, CompareType.GREATER_EQUALS));
        dateFilter.getFilterItems().add(new FilterItemInfo("attendDate", (Object)endDate, CompareType.LESS_EQUALS));
        HashSet<String> personSet = new HashSet<String>();
        for (String personId : proposerIds.split(",")) {
            personSet.add(personId);
        }
        FilterInfo personFilter = new FilterInfo();
        personFilter.getFilterItems().add(new FilterItemInfo("proposer.id", personSet, CompareType.INCLUDE));
        personFilter.mergeFilter(dateFilter, "AND");
        evi.setFilter(personFilter);
        IScheduleShift iScheduleShift = ScheduleShiftFactory.getLocalInstance(ctx);
        ScheduleShiftCollection shiftColleciton = iScheduleShift.getScheduleShiftCollection(evi);
        HashMap resultMap = new HashMap();
        if (shiftColleciton != null && !shiftColleciton.isEmpty()) {
            int totalRecords = shiftColleciton.size();
            for (int i = 0; i < totalRecords; ++i) {
                HashMap<String, Object> tempMap = new HashMap<String, Object>();
                ScheduleShiftInfo tempShift = shiftColleciton.get(i);
                tempMap.put("id", tempShift.getId().toString());
                tempMap.put("proposer.id", tempShift.getProposer().getId().toString());
                tempMap.put("proposer.number", tempShift.getProposer().getNumber().toString());
                tempMap.put("proposer.name", tempShift.getProposer().getName().toString());
                tempMap.put("attendDate", tempShift.getAttendDate());
                tempMap.put("dayType.alias", tempShift.getDayType().getAlias());
                tempMap.put("dayType.value", tempShift.getDayType().getValue());
                AtsShiftInfo atsShiftInfo = tempShift.getDefaultShift();
                tempMap.put("defaultShift.id", atsShiftInfo != null ? atsShiftInfo.getId().toString() : null);
                tempMap.put("defaultShift.name", atsShiftInfo != null ? atsShiftInfo.getName() : null);
                tempMap.put("defaultShift.number", atsShiftInfo != null ? atsShiftInfo.getNumber() : null);
                tempMap.put("attendFile.id", tempShift.getAttendFile().getId().toString());
                tempMap.put("attendFile.attendanceNum", tempShift.getAttendFile().getAttendanceNum());
                AttencePolicyInfo policyInfo = tempShift.getAttendPolicy();
                tempMap.put("attendPolicy.id", policyInfo != null ? policyInfo.getId().toString() : null);
                tempMap.put("attendPolicy.name", policyInfo != null ? policyInfo.getName() : null);
                tempMap.put("attendPolicy.number", policyInfo != null ? policyInfo.getNumber() : null);
                CardRuleInfo cardRuleInfo = tempShift.getCardRule();
                tempMap.put("cardRule.id", cardRuleInfo != null ? cardRuleInfo.getId().toString() : null);
                tempMap.put("cardRule.name", cardRuleInfo != null ? cardRuleInfo.getName() : null);
                tempMap.put("cardRule.number", cardRuleInfo != null ? cardRuleInfo.getNumber() : null);
                tempMap.put("standardHour", tempShift.getStandardHour() == null ? "" : Double.valueOf(tempShift.getStandardHour().doubleValue()));
                HolidayPolicySetInfo holidayPolicyInfo = tempShift.getHldPlcSet();
                tempMap.put("hldPlcSet.id", holidayPolicyInfo != null ? holidayPolicyInfo.getId().toString() : null);
                AtsShiftTypeInfo shiftType = tempShift.getShiftType();
                tempMap.put("shiftType.id", shiftType != null ? shiftType.getId().toString() : null);
                tempMap.put("shiftType.name", shiftType != null ? shiftType.getName() : null);
                tempMap.put("shiftType.number", shiftType != null ? shiftType.getNumber() : null);
                OverTimeCompensInfo compensInfo = tempShift.getOtCompens();
                tempMap.put("otCompens.id", compensInfo != null ? compensInfo.getId().toString() : null);
                tempMap.put("otCompens.name", compensInfo != null ? compensInfo.getName() : null);
                tempMap.put("otCompens.number", compensInfo != null ? compensInfo.getNumber() : null);
                resultMap.put(tempShift.getProposer().getId().toString() + AtsDateUtils.dateShortToString(tempShift.getAttendDate()), tempMap);
            }
        }
        return resultMap;
    }

    public Object getShiftItem(Map paramMap) throws ParseException, BOSException {
        Context ctx = Tools.getInstance().getCtx();
        String personId = (String)paramMap.get("T_HR_ATS_ATTENDANCERESULT_FPROPOSERID");
        String strDate = AtsDateUtils.dateShortToString(new Date());
        return this.getShiftItem(ctx, personId, strDate, strDate);
    }

    public Object getShiftItem(Context ctx, String proposerIds, String strBeginDate, String strEndDate) throws BOSException {
        Date beginDate = AtsDateUtils.stringToShortDate(strBeginDate);
        Date endDate = AtsDateUtils.stringToShortDate(strEndDate);
        EntityViewInfo evi = new EntityViewInfo();
        evi.getSelector().add(new SelectorItemInfo("id"));
        evi.getSelector().add(new SelectorItemInfo("attendDate"));
        evi.getSelector().add(new SelectorItemInfo("items.id"));
        evi.getSelector().add(new SelectorItemInfo("items.segment"));
        evi.getSelector().add(new SelectorItemInfo("items.preTime"));
        evi.getSelector().add(new SelectorItemInfo("items.preDateTime"));
        evi.getSelector().add(new SelectorItemInfo("items.preTimeDayType"));
        evi.getSelector().add(new SelectorItemInfo("items.preFloatAdjusted"));
        evi.getSelector().add(new SelectorItemInfo("items.preUnit"));
        evi.getSelector().add(new SelectorItemInfo("items.preIsPunchCard"));
        evi.getSelector().add(new SelectorItemInfo("items.nextTime"));
        evi.getSelector().add(new SelectorItemInfo("items.nextDateTime"));
        evi.getSelector().add(new SelectorItemInfo("items.nextTimeDayType"));
        evi.getSelector().add(new SelectorItemInfo("items.nextFloatAdjusted"));
        evi.getSelector().add(new SelectorItemInfo("items.nextUnit"));
        evi.getSelector().add(new SelectorItemInfo("items.nextIsPunchCard"));
        evi.getSelector().add(new SelectorItemInfo("items.segmentInRest"));
        evi.getSelector().add(new SelectorItemInfo("items.attendanceType"));
        evi.getSelector().add(new SelectorItemInfo("proposer.id"));
        FilterInfo dateFilter = new FilterInfo();
        dateFilter.getFilterItems().add(new FilterItemInfo("attendDate", (Object)beginDate, CompareType.GREATER_EQUALS));
        dateFilter.getFilterItems().add(new FilterItemInfo("attendDate", (Object)endDate, CompareType.LESS_EQUALS));
        HashSet<String> personSet = new HashSet<String>();
        for (String personId : proposerIds.split(",")) {
            personSet.add(personId);
        }
        FilterInfo personFilter = new FilterInfo();
        personFilter.getFilterItems().add(new FilterItemInfo("proposer.id", personSet, CompareType.INCLUDE));
        personFilter.mergeFilter(dateFilter, "AND");
        evi.setFilter(personFilter);
        HashMap resultMap = new HashMap();
        IScheduleShift iScheduleShift = ScheduleShiftFactory.getLocalInstance(ctx);
        ScheduleShiftCollection shiftColleciton = iScheduleShift.getScheduleShiftCollection(evi);
        if (shiftColleciton != null && !shiftColleciton.isEmpty()) {
            for (int i = 0; i < shiftColleciton.size(); ++i) {
                ScheduleShiftInfo schduleShift = shiftColleciton.get(i);
                ScheduleShiftItemCollection shiftItemCollection = schduleShift.getItems();
                shiftItemCollection.sort("segment");
                ArrayList rowList = new ArrayList();
                String personId = schduleShift.getProposer().getId().toString();
                for (int j = 0; j < shiftItemCollection.size(); ++j) {
                    HashMap<String, Object> tempMap = new HashMap<String, Object>();
                    ScheduleShiftItemInfo tempItem = shiftItemCollection.get(i);
                    tempMap.put("items.id", tempItem.getId().toString());
                    tempMap.put("items.segment", tempItem.getSegment().getValue());
                    tempMap.put("items.segment.alias", tempItem.getSegment().getAlias());
                    tempMap.put("items.preTime", tempItem.getPreTime());
                    tempMap.put("items.preDateTime", AtsDateUtils.timestampToString(tempItem.getPreDateTime()));
                    tempMap.put("items.preTimeDayType.value", tempItem.getPreTimeDayType().getValue());
                    tempMap.put("items.preTimeDayType.alias", tempItem.getPreTimeDayType().getAlias());
                    tempMap.put("items.preFloatAdjusted", tempItem.getPreFloatAdjusted() == null ? "" : Double.valueOf(tempItem.getPreFloatAdjusted().doubleValue()));
                    tempMap.put("items.preIsPunchCard.value", tempItem.getPreIsPunchCard().getValue());
                    tempMap.put("items.preIsPunchCard.alias", tempItem.getPreIsPunchCard().getAlias());
                    tempMap.put("items.nextTime", tempItem.getNextTime());
                    tempMap.put("items.nextDateTime", AtsDateUtils.timestampToString(tempItem.getNextDateTime()));
                    tempMap.put("items.nextTimeDayType.value", tempItem.getNextTimeDayType().getValue());
                    tempMap.put("items.nextTimeDayType.alias", tempItem.getNextTimeDayType().getAlias());
                    tempMap.put("items.nextFloatAdjusted", tempItem.getNextFloatAdjusted() == null ? "" : Double.valueOf(tempItem.getNextFloatAdjusted().doubleValue()));
                    tempMap.put("items.nextUnit.value", tempItem.getNextUnit().getValue());
                    tempMap.put("items.nextUnit.alias", tempItem.getNextUnit().getAlias());
                    tempMap.put("items.nextIsPunchCard.value", tempItem.getNextIsPunchCard().getValue());
                    tempMap.put("items.nextIsPunchCard.alias", tempItem.getNextIsPunchCard().getAlias());
                    tempMap.put("items.segmentInRest", tempItem.getSegmentInRest() == null ? "" : Double.valueOf(tempItem.getSegmentInRest().doubleValue()));
                    tempMap.put("items.attendanceType.value", tempItem.getAttendanceType().getValue());
                    tempMap.put("items.attendanceType.alias", tempItem.getAttendanceType().getAlias());
                    rowList.add(tempMap);
                }
                resultMap.put(personId + AtsDateUtils.dateShortToString(schduleShift.getAttendDate()), rowList);
            }
        }
        return resultMap;
    }
}

