/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.ats.helper;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.ats.AtsScheduleShiftEntryCollection;
import com.kingdee.eas.hr.ats.AtsScheduleShiftEntryFactory;
import com.kingdee.eas.hr.ats.AtsScheduleShiftEntryInfo;
import com.kingdee.eas.hr.ats.AtsShiftInfo;
import com.kingdee.eas.hr.ats.AtsShiftItemCollection;
import com.kingdee.eas.hr.ats.AtsShiftItemInfo;
import com.kingdee.eas.hr.ats.AttendanceFileHISCollection;
import com.kingdee.eas.hr.ats.AttendanceFileHISInfo;
import com.kingdee.eas.hr.ats.AttendanceFileInfo;
import com.kingdee.eas.hr.ats.ScheduleShiftCollection;
import com.kingdee.eas.hr.ats.ScheduleShiftFactory;
import com.kingdee.eas.hr.ats.ScheduleShiftInfo;
import com.kingdee.eas.hr.ats.ScheduleShiftItemCollection;
import com.kingdee.eas.hr.ats.ScheduleShiftItemInfo;
import com.kingdee.eas.hr.ats.SchlShiftSrcTypeEnum;
import com.kingdee.eas.hr.ats.helper.ScheduleShiftItemHelper;
import com.kingdee.eas.hr.ats.util.AtsDateUtils;
import com.kingdee.eas.hr.ats.util.AtsStoreToPlaceUtil;
import com.kingdee.eas.hr.ats.util.common.AtsCollectionUtile;
import com.kingdee.eas.hr.ats.util.common.AtsCommonUtile;
import com.kingdee.eas.hr.ats.util.common.CoreBaseUtile;
import com.kingdee.eas.hr.ats.workShift.WorkShiftUtile;
import com.kingdee.eas.hr.ats.workShiftGroup.save.SaveShiftUtile;
import java.sql.Date;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;

public class AtsScheduleShiftHelper {
    public static AtsScheduleShiftEntryCollection getAtsScheduleShiftEntryCollection(Context ctx, String billId) {
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("attendDateBefore"));
        sic.add(new SelectorItemInfo("attendDateAfter"));
        sic.add(new SelectorItemInfo("dayTypeBefore"));
        sic.add(new SelectorItemInfo("dayTypeAfter"));
        sic.add(new SelectorItemInfo("defaultShiftBefore.name"));
        sic.add(new SelectorItemInfo("defaultShiftBefore.number"));
        sic.add(new SelectorItemInfo("defaultShiftBefore.otCompens"));
        sic.add(new SelectorItemInfo("defaultShiftBefore.standardHour"));
        sic.add(new SelectorItemInfo("defaultShiftBefore.shiftType"));
        sic.add(new SelectorItemInfo("defaultShiftBefore.relateOrgUnit"));
        sic.add(new SelectorItemInfo("defaultShiftBefore.cardRule"));
        sic.add(new SelectorItemInfo("defaultShiftBefore.isHalfDay"));
        sic.add(new SelectorItemInfo("defaultShiftBefore.items.segment"));
        sic.add(new SelectorItemInfo("defaultShiftBefore.items.preTime"));
        sic.add(new SelectorItemInfo("defaultShiftBefore.items.preTimeDayType"));
        sic.add(new SelectorItemInfo("defaultShiftBefore.items.preFloatAdjusted"));
        sic.add(new SelectorItemInfo("defaultShiftBefore.items.preUnit"));
        sic.add(new SelectorItemInfo("defaultShiftBefore.items.preIsPunchCard"));
        sic.add(new SelectorItemInfo("defaultShiftBefore.items.restPreTime"));
        sic.add(new SelectorItemInfo("defaultShiftBefore.items.nextTime"));
        sic.add(new SelectorItemInfo("defaultShiftBefore.items.nextTimeDayType"));
        sic.add(new SelectorItemInfo("defaultShiftBefore.items.nextFloatAdjusted"));
        sic.add(new SelectorItemInfo("defaultShiftBefore.items.nextUnit"));
        sic.add(new SelectorItemInfo("defaultShiftBefore.items.nextIsPunchCard"));
        sic.add(new SelectorItemInfo("defaultShiftBefore.items.restNextTime"));
        sic.add(new SelectorItemInfo("defaultShiftBefore.items.segmentInRest"));
        sic.add(new SelectorItemInfo("defaultShiftBefore.items.attendanceType"));
        sic.add(new SelectorItemInfo("defaultShiftBefore.id"));
        sic.add(new SelectorItemInfo("proposerBefore.name"));
        sic.add(new SelectorItemInfo("proposerBefore.number"));
        sic.add(new SelectorItemInfo("proposerBefore.id"));
        sic.add(new SelectorItemInfo("defaultShiftAfter.name"));
        sic.add(new SelectorItemInfo("defaultShiftAfter.number"));
        sic.add(new SelectorItemInfo("defaultShiftAfter.otCompens"));
        sic.add(new SelectorItemInfo("defaultShiftAfter.standardHour"));
        sic.add(new SelectorItemInfo("defaultShiftAfter.shiftType"));
        sic.add(new SelectorItemInfo("defaultShiftAfter.relateOrgUnit"));
        sic.add(new SelectorItemInfo("defaultShiftAfter.cardRule"));
        sic.add(new SelectorItemInfo("defaultShiftAfter.isElastic"));
        sic.add(new SelectorItemInfo("defaultShiftAfter.elasticType"));
        sic.add(new SelectorItemInfo("defaultShiftAfter.elasticDirection"));
        sic.add(new SelectorItemInfo("defaultShiftAfter.elasticValue"));
        sic.add(new SelectorItemInfo("defaultShiftAfter.isHalfDay"));
        sic.add(new SelectorItemInfo("defaultShiftAfter.items.segment"));
        sic.add(new SelectorItemInfo("defaultShiftAfter.items.preTime"));
        sic.add(new SelectorItemInfo("defaultShiftAfter.items.preTimeDayType"));
        sic.add(new SelectorItemInfo("defaultShiftAfter.items.preFloatAdjusted"));
        sic.add(new SelectorItemInfo("defaultShiftAfter.items.preUnit"));
        sic.add(new SelectorItemInfo("defaultShiftAfter.items.preIsPunchCard"));
        sic.add(new SelectorItemInfo("defaultShiftAfter.items.restPreTime"));
        sic.add(new SelectorItemInfo("defaultShiftAfter.items.nextTime"));
        sic.add(new SelectorItemInfo("defaultShiftAfter.items.nextTimeDayType"));
        sic.add(new SelectorItemInfo("defaultShiftAfter.items.nextFloatAdjusted"));
        sic.add(new SelectorItemInfo("defaultShiftAfter.items.nextUnit"));
        sic.add(new SelectorItemInfo("defaultShiftAfter.items.nextIsPunchCard"));
        sic.add(new SelectorItemInfo("defaultShiftAfter.items.restNextTime"));
        sic.add(new SelectorItemInfo("defaultShiftAfter.items.segmentInRest"));
        sic.add(new SelectorItemInfo("defaultShiftAfter.items.attendanceType"));
        sic.add(new SelectorItemInfo("defaultShiftAfter.id"));
        sic.add(new SelectorItemInfo("proposerAfter.name"));
        sic.add(new SelectorItemInfo("proposerAfter.number"));
        sic.add(new SelectorItemInfo("proposerAfter.id"));
        entityViewInfo.setSelector(sic);
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("bill.id", (Object)billId, CompareType.EQUALS));
        entityViewInfo.setFilter(filterInfo);
        AtsScheduleShiftEntryCollection coll = new AtsScheduleShiftEntryCollection();
        try {
            coll = AtsScheduleShiftEntryFactory.getLocalInstance(ctx).getAtsScheduleShiftEntryCollection(entityViewInfo);
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return coll;
    }

    public static void updateScheduleShiftInfo(Context ctx, String billId) throws BOSException, EASBizException {
        AtsScheduleShiftEntryCollection scheduleShiftEntrys = AtsScheduleShiftHelper.getAtsScheduleShiftEntryCollection(ctx, billId);
        Iterator itr = scheduleShiftEntrys.iterator();
        while (itr.hasNext()) {
            AtsScheduleShiftEntryInfo info = (AtsScheduleShiftEntryInfo)itr.next();
            ScheduleShiftInfo scheduleShiftInfo = AtsScheduleShiftHelper.getScheduleoByAtsScheduleItem(ctx, info);
            ScheduleShiftFactory.getLocalInstance(ctx).save((CoreBaseInfo)scheduleShiftInfo);
            if (scheduleShiftInfo.getId() == null) continue;
            AtsStoreToPlaceUtil.dealScheduleToPlace(ctx, Collections.singletonList(CoreBaseUtile.getId(scheduleShiftInfo)));
        }
    }

    public static ScheduleShiftInfo getScheduleoByAtsScheduleItem(Context ctx, AtsScheduleShiftEntryInfo info) throws BOSException {
        Date attendDate = new Date(info.getAttendDateBefore().getTime());
        String id = info.getProposerBefore().getId().toString();
        String oql = "where attendDate='" + attendDate.toString() + "' and proposer.id = '" + id + "'";
        ScheduleShiftCollection scheduleShifts = ScheduleShiftFactory.getLocalInstance(ctx).getScheduleShiftCollection(oql);
        ScheduleShiftInfo scheduleShiftInfo = null;
        if (scheduleShifts.size() > 0 && null != scheduleShifts) {
            scheduleShiftInfo = scheduleShifts.get(0);
        } else {
            scheduleShiftInfo = new ScheduleShiftInfo();
            String number = info.getProposerBefore().getNumber().toString();
            HashSet<String> numbers = new HashSet<String>();
            numbers.add(number);
            AttendanceFileHISCollection attFileHISColleciton = SaveShiftUtile.getAttendanceFileHisShift(ctx, numbers, AtsCommonUtile.formateDate(attendDate), AtsCommonUtile.formateDate(attendDate), null);
            if (!AtsCollectionUtile.isEmpty((IObjectCollection)attFileHISColleciton)) {
                AttendanceFileHISInfo hisFile = attFileHISColleciton.get(0);
                scheduleShiftInfo.setProposer(hisFile.getProposer());
                scheduleShiftInfo.setAdminOrgUnit(hisFile.getAttAdminOrgUnit());
                scheduleShiftInfo.setPosition(hisFile.getPosition());
                scheduleShiftInfo.setHrOrgUnit(hisFile.getHrOrgUnit());
                scheduleShiftInfo.setAttendPolicy(hisFile.getAttencePolicy());
                scheduleShiftInfo.setHldPlcSet(hisFile.getHolidayPolicySet());
                AtsShiftInfo atsShift = hisFile.getAtsShift();
                scheduleShiftInfo.setDefaultShift(atsShift);
                scheduleShiftInfo.setCardRule(atsShift == null ? null : atsShift.getCardRule());
                scheduleShiftInfo.setOtCompens(atsShift == null ? null : atsShift.getOtCompens());
                scheduleShiftInfo.setStandardHour(atsShift == null ? null : atsShift.getStandardHour());
                Map<String, BOSUuid> personNumToAttendanceFileId = SaveShiftUtile.getAttendanceFileId(ctx, numbers);
                String personNum = hisFile.getProposer().getNumber();
                BOSUuid uuid = personNumToAttendanceFileId.get(personNum);
                if (null != uuid) {
                    AttendanceFileInfo file = AtsCommonUtile.convertHis2File(hisFile);
                    file.setId(uuid);
                    scheduleShiftInfo.setAttendFile(file);
                }
            }
            scheduleShiftInfo.setAttendDate(attendDate);
        }
        if (info.getDefaultShiftAfter() != null) {
            ScheduleShiftItemCollection scheduleShiftItems = scheduleShiftInfo.getItems();
            scheduleShiftItems.clear();
            AtsShiftItemCollection shiftItems = info.getDefaultShiftAfter().getItems();
            Iterator shiftItemsItr = shiftItems.iterator();
            String atdtString = AtsDateUtils.dateShortToString(attendDate);
            String atdtPreDayString = AtsDateUtils.getPreDay(atdtString);
            String atdtNextDayString = AtsDateUtils.getNextDay(atdtString);
            while (shiftItemsItr.hasNext()) {
                AtsShiftItemInfo shiftItemInfo = (AtsShiftItemInfo)shiftItemsItr.next();
                ScheduleShiftItemInfo scheduleShiftItemInfo = new ScheduleShiftItemInfo();
                scheduleShiftItemInfo.setGroup(scheduleShiftInfo);
                scheduleShiftItemInfo.setShiftItem(shiftItemInfo);
                scheduleShiftItemInfo.setSegment(shiftItemInfo.getSegment());
                scheduleShiftItemInfo.setPreTime(shiftItemInfo.getPreTime());
                scheduleShiftItemInfo.setPreTimeDayType(shiftItemInfo.getPreTimeDayType());
                scheduleShiftItemInfo.setPreFloatAdjusted(shiftItemInfo.getPreFloatAdjusted());
                scheduleShiftItemInfo.setPreUnit(shiftItemInfo.getPreUnit());
                scheduleShiftItemInfo.setPreIsPunchCard(shiftItemInfo.getPreIsPunchCard());
                scheduleShiftItemInfo.setRestPreTime(shiftItemInfo.getRestPreTime());
                scheduleShiftItemInfo.setRestNextTime(shiftItemInfo.getRestNextTime());
                scheduleShiftItemInfo.setNextTime(shiftItemInfo.getNextTime());
                scheduleShiftItemInfo.setNextTimeDayType(shiftItemInfo.getNextTimeDayType());
                scheduleShiftItemInfo.setNextFloatAdjusted(shiftItemInfo.getNextFloatAdjusted());
                scheduleShiftItemInfo.setNextUnit(shiftItemInfo.getNextUnit());
                scheduleShiftItemInfo.setNextIsPunchCard(shiftItemInfo.getNextIsPunchCard());
                scheduleShiftItemInfo.setSegmentInRest(shiftItemInfo.getSegmentInRest());
                scheduleShiftItemInfo.setAttendanceType(shiftItemInfo.getAttendanceType());
                int preTimeValue = scheduleShiftItemInfo.getPreTimeDayType().getValue();
                String preTimeStr = scheduleShiftItemInfo.getPreTime();
                String preDateTimeStr = ScheduleShiftItemHelper.getRealTimeByType(preTimeValue, atdtString, atdtPreDayString, atdtNextDayString, preTimeStr);
                scheduleShiftItemInfo.setPreDateTime(AtsDateUtils.stringToTimestamp(preDateTimeStr));
                int nextTimeValue = scheduleShiftItemInfo.getNextTimeDayType().getValue();
                String nextTimeStr = scheduleShiftItemInfo.getNextTime();
                String nextDateTimeStr = ScheduleShiftItemHelper.getRealTimeByType(nextTimeValue, atdtString, atdtPreDayString, atdtNextDayString, nextTimeStr);
                scheduleShiftItemInfo.setNextDateTime(AtsDateUtils.stringToTimestamp(nextDateTimeStr));
                scheduleShiftItems.add(scheduleShiftItemInfo);
            }
        }
        scheduleShiftInfo.setDayType(info.getDayTypeAfter());
        scheduleShiftInfo.setSrcType(SchlShiftSrcTypeEnum.manSchlShift);
        if (info.getDefaultShiftAfter() != null) {
            scheduleShiftInfo.setDefaultShift(info.getDefaultShiftAfter());
            scheduleShiftInfo.setCardRule(info.getDefaultShiftAfter().getCardRule());
            scheduleShiftInfo.setStandardHour(info.getDefaultShiftAfter().getStandardHour());
            scheduleShiftInfo.setShiftType(info.getDefaultShiftAfter().getShiftType());
            scheduleShiftInfo.setOtCompens(info.getDefaultShiftAfter().getOtCompens());
            scheduleShiftInfo.setIsElastic(info.getDefaultShiftAfter().isIsElastic());
            scheduleShiftInfo.setElasticType(info.getDefaultShiftAfter().getElasticType());
            scheduleShiftInfo.setElasticDirection(info.getDefaultShiftAfter().getElasticDirection());
            scheduleShiftInfo.setElasticValue(info.getDefaultShiftAfter().getElasticValue());
            scheduleShiftInfo.setIsHalfDay(info.getDefaultShiftAfter().isIsHalfDay());
        } else {
            scheduleShiftInfo.setDefaultShift(null);
            scheduleShiftInfo.setShiftType(null);
            if (scheduleShiftInfo.getItems() != null) {
                scheduleShiftInfo.getItems().clear();
            }
        }
        WorkShiftUtile.combineMultiAttAdminFields(scheduleShiftInfo);
        return scheduleShiftInfo;
    }
}

