/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.ats.holidayLimit.generate.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.workflow.engine.core.Mutex;
import com.kingdee.bos.workflow.exception.AlreadyInProcessQueueException;
import com.kingdee.eas.hr.ats.util.common.ConfigAts;
import java.text.MessageFormat;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class AtsLockUtil {
    private static Logger logger = Logger.getLogger(AtsLockUtil.class);
    private static final int RETRY_LOCK_TIMES = 40;
    private static final String LOCK_PREFIX = "ats:lock:{0}";

    /*
     * Loose catch block
     */
    public static void executeWithNotBlock(Context ctx, String key, Runnable runnable) throws BOSException {
        String newKey;
        block12: {
            if (runnable == null || StringUtils.isBlank((CharSequence)key)) {
                return;
            }
            if (AtsLockUtil.isCloseLock()) {
                try {
                    runnable.run();
                }
                catch (Exception e) {
                    logger.error((Object)"catch a exception", (Throwable)e);
                    throw new BOSException(e.getMessage());
                }
                return;
            }
            newKey = MessageFormat.format(LOCK_PREFIX, key);
            try {
                if (!AtsLockUtil.lock(ctx, newKey)) break block12;
                try {
                    runnable.run();
                }
                catch (Exception e) {
                    logger.error((Object)"catch a exception", (Throwable)e);
                    throw new BOSException(e.getMessage());
                }
            }
            catch (AlreadyInProcessQueueException e) {
                logger.error((Object)"catch a exception", (Throwable)e);
                AtsLockUtil.unlock(ctx, newKey);
                return;
            }
            catch (Exception e2) {
                logger.error((Object)"catch a exception", (Throwable)e2);
                throw new RuntimeException(e2.getMessage());
                {
                    catch (Throwable throwable) {
                        AtsLockUtil.unlock(ctx, newKey);
                        throw throwable;
                    }
                }
            }
        }
        AtsLockUtil.unlock(ctx, newKey);
    }

    public static void executeWithBlock(Context ctx, String key, Runnable runnable) throws BOSException {
        String newKey;
        block11: {
            if (runnable == null || StringUtils.isBlank((CharSequence)key)) {
                return;
            }
            if (AtsLockUtil.isCloseLock()) {
                try {
                    runnable.run();
                }
                catch (Exception e) {
                    logger.error((Object)"catch a exception", (Throwable)e);
                    throw new BOSException(e.getMessage());
                }
                return;
            }
            newKey = MessageFormat.format(LOCK_PREFIX, key);
            try {
                if (AtsLockUtil.lockBlock(ctx, newKey)) {
                    try {
                        runnable.run();
                        break block11;
                    }
                    catch (Exception e) {
                        logger.error((Object)"catch a exception", (Throwable)e);
                        throw new BOSException(e.getMessage());
                    }
                }
                logger.error((Object)MessageFormat.format("get lock exception.key={0}", key));
                throw new RuntimeException(MessageFormat.format("get lock exception.key={0}", key));
            }
            catch (Exception e) {
                try {
                    logger.error((Object)"catch a exception", (Throwable)e);
                    throw new RuntimeException(e.getMessage());
                }
                catch (Throwable throwable) {
                    AtsLockUtil.unlock(ctx, newKey);
                    throw throwable;
                }
            }
        }
        AtsLockUtil.unlock(ctx, newKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean lockBlock(Context ctx, String key) {
        int retry = 0;
        do {
            try {
                boolean isSucLock = AtsLockUtil.lock(ctx, key);
                if (isSucLock) {
                    boolean bl = true;
                    return bl;
                }
            }
            catch (AlreadyInProcessQueueException e) {
                logger.error((Object)MessageFormat.format("catch a exception.key={0}", key), (Throwable)e);
            }
            finally {
                ++retry;
            }
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                logger.error((Object)"catch a eception", (Throwable)e);
            }
        } while (retry <= 40);
        logger.error((Object)MessageFormat.format("retry lock beyond max times.key={0}", key));
        return false;
    }

    private static boolean lock(Context ctx, String ... keys) throws AlreadyInProcessQueueException {
        if (keys == null || keys.length == 0) {
            return false;
        }
        for (String key : keys) {
            if (Mutex.lock((Context)ctx, (String)key)) continue;
            return false;
        }
        return true;
    }

    private static void unlock(Context ctx, String ... keys) {
        if (keys == null || keys.length == 0) {
            return;
        }
        for (String key : keys) {
            Mutex.unlock((Context)ctx, (String)key);
        }
    }

    private static boolean isCloseLock() {
        String isOpenLock = ConfigAts.getPropertyFromConfig("ats.distributed.lock.isopen");
        return !StringUtils.isNotBlank((CharSequence)isOpenLock) || !"true".equals(isOpenLock);
    }
}

