/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.ats.lightapp.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.basedata.person.PersonCollection;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.hr.ats.AtsAttenceResEnum;
import com.kingdee.eas.hr.ats.AtsBillResEnum;
import com.kingdee.eas.hr.ats.AtsFileResEnum;
import com.kingdee.eas.hr.ats.AtsFillSignCardResEnum;
import com.kingdee.eas.hr.ats.AttencePolicyInfo;
import com.kingdee.eas.hr.ats.AttendanceFileInfo;
import com.kingdee.eas.hr.ats.FillAmountUnitEnum;
import com.kingdee.eas.hr.ats.FillSignCardEntryCollection;
import com.kingdee.eas.hr.ats.FillSignCardEntryInfo;
import com.kingdee.eas.hr.ats.FillSignCardFactory;
import com.kingdee.eas.hr.ats.FillSignCardInfo;
import com.kingdee.eas.hr.ats.ResourceEnum;
import com.kingdee.eas.hr.ats.lightapp.util.AtsWebUtils;
import com.kingdee.eas.hr.ats.lightapp.util.AttencePolicyFillHelper;
import com.kingdee.eas.hr.ats.lightapp.util.AttencePolicyFillUtil;
import com.kingdee.eas.hr.ats.util.common.MLUtile;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import org.apache.log4j.Logger;

public class AtsFillCardBillUtils {
    Logger logger = Logger.getLogger(this.getClass());

    public String validData(Context ctx, String personId, String attendDateStr, String fillCardTime, String fillCardType) throws BOSException {
        String response;
        block9: {
            this.logger.info((Object)("personId,attendDateStr,fillCardTime,fillCardType......" + personId + "," + attendDateStr + "," + fillCardTime + "," + fillCardType));
            response = "";
            if (StringUtils.isEmpty((String)personId)) {
                response = MLUtile.getRes(AtsFileResEnum.NotExistsPersonNum, ctx) + "!";
            }
            if (StringUtils.isEmpty((String)attendDateStr) || StringUtils.isEmpty((String)fillCardTime)) {
                response = MLUtile.getRes(AtsFillSignCardResEnum.NullFillCardTime, ctx) + "!";
            }
            Date attendDate = new Date();
            FillSignCardEntryInfo fillSignCardEntry = new FillSignCardEntryInfo();
            FillSignCardInfo fillSignCard = new FillSignCardInfo();
            StringBuilder sql = new StringBuilder();
            sql.append("select * from  T_BD_Person where fid ='" + personId + "'");
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            try {
                if (!rowSet.next()) {
                    response = MLUtile.getRes((ResourceEnum)AtsFileResEnum.NotExistsPersonNum, ctx, personId) + "!";
                    break block9;
                }
                PersonCollection personColl = PersonFactory.getLocalInstance((Context)ctx).getPersonCollection(" where id = '" + personId + "'");
                if (personColl == null || personColl.isEmpty() || personColl.size() <= 0 || personColl.get(0) == null || personColl.get(0).getId() == null) break block9;
                personId = personColl.get(0).getId().toString();
                fillSignCardEntry.setPerson(personColl.get(0));
                try {
                    attendDate = new SimpleDateFormat("yyyy-MM-dd").parse(attendDateStr);
                }
                catch (ParseException e1) {
                    e1.printStackTrace();
                }
                fillSignCardEntry.setAttendDate(attendDate);
                fillSignCardEntry.setFillCardTimeStr(fillCardTime);
                fillSignCard.getEntries().add(fillSignCardEntry);
                try {
                    response = this.validateIsFillSignCard(ctx, fillSignCard);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        this.logger.info((Object)("response......" + response));
        return response;
    }

    public String validateIsFillSignCard(Context ctx, FillSignCardInfo signCardInfo, AttendanceFileInfo attendanceFile) throws Exception {
        String errorString = "";
        if (signCardInfo == null) {
            errorString = MLUtile.getRes(AtsBillResEnum.NullBillInfo, ctx);
            return errorString;
        }
        FillSignCardEntryCollection signCardEntryCollection = signCardInfo.getEntries();
        Calendar applyCal = Calendar.getInstance();
        if (signCardInfo.getId() != null && AtsWebUtils.isInWorkFlow(ctx, signCardInfo.getId().toString())) {
            FillSignCardInfo signCardInfoDB = signCardInfo;
            if (signCardInfo.getApplyDate() == null) {
                signCardInfoDB = FillSignCardFactory.getLocalInstance(ctx).getFillSignCardInfo((IObjectPK)new ObjectUuidPK(signCardInfo.getId().toString()));
            }
            applyCal.setTime(signCardInfoDB.getApplyDate());
        }
        applyCal.setTime(AttencePolicyFillUtil.formatCalendar(applyCal));
        Date applyDate = applyCal.getTime();
        if (signCardEntryCollection == null) {
            errorString = MLUtile.getRes(AtsBillResEnum.NullBillInfo, ctx);
            return errorString;
        }
        Iterator itr = signCardEntryCollection.iterator();
        FillSignCardEntryInfo signCardEntryInfo = null;
        while (itr.hasNext()) {
            String personId;
            signCardEntryInfo = (FillSignCardEntryInfo)itr.next();
            String string = personId = signCardEntryInfo != null && signCardEntryInfo.getPerson() != null && signCardEntryInfo.getPerson().getId() != null ? signCardEntryInfo.getPerson().getId().toString() : "";
            if (signCardEntryInfo != null && signCardEntryInfo.getAttendDate() == null && StringUtils.isEmpty((String)signCardEntryInfo.getFillCardTimeStr())) {
                errorString = MLUtile.getRes(AtsFillSignCardResEnum.NullFillCardTime, ctx) + "!";
                return errorString;
            }
            SimpleDateFormat df1 = new SimpleDateFormat("yyyy-MM-dd");
            SimpleDateFormat df2 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            String dtStr = "";
            if (signCardEntryInfo != null && signCardEntryInfo.getAttendDate() != null && signCardEntryInfo.getFillCardTimeStr() != null) {
                dtStr = df1.format(signCardEntryInfo.getAttendDate()) + " " + signCardEntryInfo.getFillCardTimeStr().trim();
            }
            Date attendDate = signCardEntryInfo != null ? signCardEntryInfo.getAttendDate() : null;
            Timestamp ts = null;
            try {
                ts = new Timestamp(df2.parse(dtStr).getTime());
                long time = ts.getTime();
                AttencePolicyInfo attencePolicyInfo = AttencePolicyFillHelper.getAttencePolicyInfo(ctx, personId, attendanceFile);
                boolean isFillSignCard = false;
                if (attencePolicyInfo == null) {
                    errorString = MLUtile.getRes(AtsAttenceResEnum.LeakPolicyInfoToCompleteCheck, ctx);
                } else {
                    isFillSignCard = attencePolicyInfo.isIsFillSignCard();
                }
                if (!isFillSignCard) continue;
                boolean isFillSignCardByTimeCtl = attencePolicyInfo.isFillSignCardByTimeCtl();
                boolean isFillSignCardByCycleCtrl = attencePolicyInfo.isFillSignCardByCycleCtl();
                if (isFillSignCardByTimeCtl) {
                    BigDecimal amount = attencePolicyInfo.getFillSignCardAmount();
                    FillAmountUnitEnum unit = attencePolicyInfo.getFillSignCardAmountUnit();
                    errorString = AttencePolicyFillHelper.validateByTimeControl(ctx, amount, unit, applyDate, 2, attencePolicyInfo, attendDate);
                }
                if (isFillSignCardByCycleCtrl && StringUtils.isEmpty((String)errorString)) {
                    if (attencePolicyInfo.getFillSignCardCycleType() == null) {
                        errorString = MLUtile.getRes(AtsAttenceResEnum.LeakPolicyInfoToCompleteCheck, ctx);
                    } else {
                        int fillSignCardCycleType = attencePolicyInfo.getFillSignCardCycleType().getValue();
                        BigDecimal afterDay = attencePolicyInfo.getFillSignCardAfterDay();
                        errorString = AttencePolicyFillHelper.validateByCycleControle(ctx, personId, attencePolicyInfo, time, fillSignCardCycleType, afterDay, 2);
                    }
                }
                if (StringUtils.isEmpty((String)errorString)) continue;
                return errorString;
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        }
        return errorString;
    }

    public String validateIsFillSignCard(Context ctx, FillSignCardInfo signCardInfo) throws Exception {
        return this.validateIsFillSignCard(ctx, signCardInfo, null);
    }
}

