/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.ats.lightapp.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.person.PersonCollection;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.ats.AtsAttenceResEnum;
import com.kingdee.eas.hr.ats.AtsBillResEnum;
import com.kingdee.eas.hr.ats.AtsFileResEnum;
import com.kingdee.eas.hr.ats.AtsShiftFactory;
import com.kingdee.eas.hr.ats.AtsShiftInfo;
import com.kingdee.eas.hr.ats.AtsTripBillCollection;
import com.kingdee.eas.hr.ats.AtsTripBillEntryCollection;
import com.kingdee.eas.hr.ats.AtsTripBillEntryInfo;
import com.kingdee.eas.hr.ats.AtsTripBillFactory;
import com.kingdee.eas.hr.ats.AtsTripBillInfo;
import com.kingdee.eas.hr.ats.AtsTripBillResEnum;
import com.kingdee.eas.hr.ats.AttencePolicyInfo;
import com.kingdee.eas.hr.ats.AttendanceFileHISInfo;
import com.kingdee.eas.hr.ats.AttendanceFileInfo;
import com.kingdee.eas.hr.ats.FillAmountUnitEnum;
import com.kingdee.eas.hr.ats.IsAttendanceEnum;
import com.kingdee.eas.hr.ats.ResourceEnum;
import com.kingdee.eas.hr.ats.ScheduleShiftInfo;
import com.kingdee.eas.hr.ats.biz.util.AtsLeaveBillUtil;
import com.kingdee.eas.hr.ats.lightapp.util.AtsWebUtils;
import com.kingdee.eas.hr.ats.lightapp.util.AttencePolicyFillHelper;
import com.kingdee.eas.hr.ats.lightapp.util.AttencePolicyFillUtil;
import com.kingdee.eas.hr.ats.lightapp.util.DateInterVal;
import com.kingdee.eas.hr.ats.lightapp.util.HRTimeWebUtils;
import com.kingdee.eas.hr.ats.lightapp.util.SHRBillUtil;
import com.kingdee.eas.hr.ats.util.AtsDateUtils;
import com.kingdee.eas.hr.ats.util.AtsScheduleShiftUtil;
import com.kingdee.eas.hr.ats.util.FetchCardUtil;
import com.kingdee.eas.hr.ats.util.common.MLUtile;
import com.kingdee.eas.hr.emp.PersonPositionInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.UuidException;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class AtsTripBillUtils {
    Logger logger = Logger.getLogger(this.getClass());

    public Map<String, Object> getDateOverlappingData(Context ctx, String personId, String beginTime, String endTime, String billId, boolean isAllDay) throws BOSException, UuidException, SQLException, EASBizException {
        HashMap<String, Object> res = new HashMap<String, Object>();
        String split = " ";
        String begintime = AtsDateUtils.getFullTime(AtsDateUtils.getTimeFromLongString(beginTime));
        String begin_Time = AtsDateUtils.getDateFromLongString(beginTime) + split + begintime;
        String endtime = AtsDateUtils.getFullTime(AtsDateUtils.getTimeFromLongString(endTime));
        String end_Time = AtsDateUtils.getDateFromLongString(endTime) + split + endtime;
        String sql = "";
        if (org.apache.commons.lang.StringUtils.isBlank((String)billId)) {
            sql = " select bill.fid,bill.fapplydate,bill.fbillstate,bill.fproposer,bill.fnumber,entry.FTripStartTime,entry.FRealTripStartTime,entry.FRealTripEndTime,entry.FTripEndTime,entry.fpersonid,entry.fIsAllDay  from T_HR_ATS_TripBill  bill left join T_HR_ATS_TripBillEntry entry  on  bill.fid = entry.fbillid  where   entry.fpersonid='" + personId + "'  and  bill.fbillstate != 4  and  bill.fbillstate != 0  order  by bill.fapplydate desc ";
        }
        if (org.apache.commons.lang.StringUtils.isNotBlank((String)billId)) {
            sql = " select bill.fid,bill.fapplydate,bill.fbillstate,bill.fproposer,bill.fnumber,entry.FTripStartTime,entry.FTripEndTime,entry.FRealTripStartTime,entry.FRealTripEndTime,entry.fpersonid,entry.fIsAllDay   from T_HR_ATS_TripBill  bill left join T_HR_ATS_TripBillEntry entry  on  bill.fid = entry.fbillid  where   entry.fpersonid='" + personId + "'  and   bill.fid !='" + billId + "'  and   bill.fbillstate != 4  and  bill.fbillstate != 0  order  by bill.fapplydate desc ";
        }
        IRowSet row = null;
        row = DbUtil.executeQuery((Context)ctx, (String)sql);
        AtsTripBillCollection atsTripBillCollection = new AtsTripBillCollection();
        boolean a = false;
        while (row.next()) {
            AtsTripBillInfo billInfo = new AtsTripBillInfo();
            PersonInfo pInfo = new PersonInfo();
            pInfo.setId(BOSUuid.read((String)row.getString("FPROPOSER")));
            billInfo.setProposer(pInfo);
            billInfo.setApplyDate(row.getDate("FAPPLYDATE"));
            billInfo.setNumber(row.getString("FNumber"));
            AtsTripBillEntryInfo entryInfo = new AtsTripBillEntryInfo();
            entryInfo.setRealTripStartTime(row.getTimestamp("FRealTripStartTime"));
            entryInfo.setRealTripEndTime(row.getTimestamp("FRealTripEndTime"));
            entryInfo.setTripStartTime(row.getTimestamp("FTripStartTime"));
            entryInfo.setTripEndTime(row.getTimestamp("FTripEndTime"));
            entryInfo.setIsAllDay(row.getBoolean("FIsAllDay"));
            PersonInfo info = new PersonInfo();
            info.setId(BOSUuid.read((String)row.getString("FPersonID")));
            entryInfo.setPerson(info);
            billInfo.getEntries().add(entryInfo);
            atsTripBillCollection.add(billInfo);
        }
        int sum = 0;
        String billNo = "";
        String personName = "";
        String tripBeginDate = "";
        String tripEndDate = "";
        if (atsTripBillCollection.size() == 0) {
            // empty if block
        }
        if (atsTripBillCollection.size() > 0) {
            String resValue = "0";
            int size = atsTripBillCollection.size();
            for (int i = 0; i < size; ++i) {
                Iterator item = atsTripBillCollection.get(i).getEntries().iterator();
                while (item.hasNext()) {
                    AtsTripBillEntryInfo entryInfo = (AtsTripBillEntryInfo)item.next();
                    Date beginDate_DB = new Date();
                    if (entryInfo.getTripStartTime() != null) {
                        beginDate_DB = HRTimeWebUtils.timestampToDate(entryInfo.getRealTripStartTime());
                    }
                    Date endDate_DB = new Date();
                    if (entryInfo.getTripEndTime() != null) {
                        endDate_DB = HRTimeWebUtils.timestampToDate(entryInfo.getRealTripEndTime());
                    }
                    if (Double.parseDouble(resValue = HRTimeWebUtils.getTimeCoincidence(HRTimeWebUtils.stringToLongDate(begin_Time), HRTimeWebUtils.stringToLongDate(end_Time), beginDate_DB, endDate_DB)) > 0.0) {
                        if (ctx == null || !this.isOutOfAllDay(ctx, HRTimeWebUtils.stringToLongDate(begin_Time), HRTimeWebUtils.stringToLongDate(end_Time), beginDate_DB, endDate_DB, entryInfo.isIsAllDay(), personId) && !this.isOutOfAllDay(ctx, beginDate_DB, endDate_DB, HRTimeWebUtils.stringToLongDate(begin_Time), HRTimeWebUtils.stringToLongDate(end_Time), isAllDay, personId)) {
                            ++sum;
                            billNo = atsTripBillCollection.get(i).getNumber();
                            String personid = atsTripBillCollection.get(i).getEntries().get(0).getPerson().getId().toString();
                            PersonPositionInfo positionInfo = SHRBillUtil.getAdminOrgUnit(personid, ctx);
                            personName = positionInfo.getPerson().getName();
                            tripBeginDate = HRTimeWebUtils.dateLongToString(beginDate_DB);
                            tripEndDate = HRTimeWebUtils.dateLongToString(endDate_DB);
                        }
                    } else {
                        sum = Long.parseLong(resValue) == 0L ? (sum += 0) : -1;
                    }
                    if (sum <= 0) continue;
                    break;
                }
                if (sum > 0) break;
            }
        }
        res.put("addFlag", sum);
        res.put("billNo", billNo);
        res.put("personName", personName);
        res.put("tripBeginDate", tripBeginDate);
        res.put("tripEndDate", tripEndDate);
        res.put("collSize", atsTripBillCollection.size());
        return res;
    }

    public boolean isOutOfAllDay(Context ctx, Date beginTime1, Date endTime1, Date beginTime2, Date endTime2, boolean isAllDay, String personId) throws EASBizException, BOSException {
        AttendanceFileHISInfo fileHisInfo;
        if (!isAllDay) {
            return false;
        }
        List dateList = HRTimeWebUtils.getLeaveBeforeAndAfterDateColl(beginTime2, endTime2);
        if (dateList.size() >= 3) {
            dateList.remove(dateList.size() - 1);
            dateList.remove(0);
        }
        if ((fileHisInfo = AtsLeaveBillUtil.getAttendanceFileHisInfo(ctx, AtsDateUtils.dateToTimestamp(beginTime2), AtsDateUtils.dateToTimestamp(beginTime2), personId, null)) == null) {
            return false;
        }
        IsAttendanceEnum isAttendance = fileHisInfo.getIsAttendance();
        AtsShiftInfo atsShift = fileHisInfo.getAtsShift();
        if (isAttendance.getValue().equalsIgnoreCase("0")) {
            if (atsShift == null) {
                return false;
            }
            for (int indext = 0; indext < dateList.size(); ++indext) {
                if (!this.hasIntersectionByAtsShiftInfo(ctx, atsShift, AtsDateUtils.dateShortToString((Date)dateList.get(indext)), beginTime1, endTime1)) continue;
                return false;
            }
            return true;
        }
        ScheduleShiftInfo scheduleShiftInfo = null;
        for (int indext = 0; indext < dateList.size(); ++indext) {
            scheduleShiftInfo = AtsScheduleShiftUtil.getScheduleShiftByPriority(ctx, personId, AtsDateUtils.dateShortToString((Date)dateList.get(indext)));
            if (!(scheduleShiftInfo == null || scheduleShiftInfo.getItems() == null || scheduleShiftInfo.getItems().size() == 0 ? atsShift != null && this.hasIntersectionByAtsShiftInfo(ctx, atsShift, AtsDateUtils.dateShortToString((Date)dateList.get(indext)), beginTime1, endTime1) : this.hasIntersectionByScheduleShiftInfo(scheduleShiftInfo, beginTime1, endTime1))) continue;
            return false;
        }
        return true;
    }

    private boolean hasIntersectionByAtsShiftInfo(Context ctx, AtsShiftInfo atsShift, String date, Date beginTime1, Date endTime1) throws BOSException, EASBizException {
        AtsShiftInfo info = AtsShiftFactory.getLocalInstance(ctx).getAtsShiftInfo("where id = '" + atsShift.getId().toString() + "'");
        if (info == null || info.getItems() == null || info.getItems().size() == 0) {
            return false;
        }
        DateInterVal startAndEndTimeBy = this.getStartAndEndTimeByAtsShiftInfo(info, date);
        return this.hasIntersection(beginTime1, endTime1, startAndEndTimeBy.getBeginDate(), startAndEndTimeBy.getEndDate());
    }

    public boolean hasIntersection(Date beginTime, Date lateTime, Date startTime, Date endTime) {
        if (startTime == null || endTime == null || startTime.getTime() >= endTime.getTime()) {
            return false;
        }
        if (beginTime == null || lateTime == null || beginTime.getTime() >= lateTime.getTime()) {
            return false;
        }
        return beginTime.getTime() < endTime.getTime() && startTime.getTime() < lateTime.getTime();
    }

    private boolean hasIntersectionByScheduleShiftInfo(ScheduleShiftInfo info, Date beginTime1, Date endTime1) throws BOSException, EASBizException {
        DateInterVal startAndEndTimeByScheduleShiftInfo = this.getStartAndEndTimeByScheduleShiftInfo(info);
        return this.hasIntersection(beginTime1, endTime1, startAndEndTimeByScheduleShiftInfo.getBeginDate(), startAndEndTimeByScheduleShiftInfo.getEndDate());
    }

    private DateInterVal getStartAndEndTimeByScheduleShiftInfo(ScheduleShiftInfo info) {
        Timestamp preTime = null;
        Timestamp nextTime = null;
        for (int sta = 0; sta < info.getItems().size(); ++sta) {
            int segmentValue = Integer.parseInt(info.getItems().get(sta).getSegment().getValue());
            if (segmentValue == 1) {
                preTime = info.getItems().get(sta).getPreDateTime();
            }
            if (segmentValue != info.getItems().size()) continue;
            nextTime = info.getItems().get(sta).getNextDateTime();
        }
        DateInterVal dateInterVal = new DateInterVal();
        dateInterVal.setBeginDate(preTime);
        dateInterVal.setEndDate(nextTime);
        return dateInterVal;
    }

    private DateInterVal getStartAndEndTimeByAtsShiftInfo(AtsShiftInfo info, String date) {
        Map<String, String> map = FetchCardUtil.getShiftEarlyTimeAndLateTime(info);
        String earlyDate = FetchCardUtil.timeToDateByDayType(map.get("earlyTime"), map.get("earlyTimeDayType"), date);
        String lateDate = FetchCardUtil.timeToDateByDayType(map.get("lateTime"), map.get("lateTimeDayType"), date);
        DateInterVal dateInterVal = new DateInterVal();
        dateInterVal.setBeginDate(AtsDateUtils.stringToLongDate(earlyDate));
        dateInterVal.setEndDate(AtsDateUtils.stringToLongDate(lateDate));
        return dateInterVal;
    }

    public String validData(Context ctx, String personId, String beginTime, String endTime, String tripType) throws Exception {
        this.logger.error((Object)("personId,beginTime,endTime,tripType......" + personId + "," + beginTime + "," + endTime + "," + tripType));
        String response = "";
        if (StringUtils.isEmpty((String)personId)) {
            response = MLUtile.getRes(AtsFileResEnum.NotExistsPersonNum, ctx) + "!";
        }
        if (StringUtils.isEmpty((String)tripType)) {
            response = MLUtile.getRes(AtsTripBillResEnum.NotExistsTheTripType, ctx);
        }
        if (StringUtils.isEmpty((String)beginTime) || StringUtils.isEmpty((String)endTime)) {
            response = MLUtile.getRes(AtsTripBillResEnum.NullTripTime, ctx) + "!";
        }
        Timestamp beginTimestamp = HRTimeWebUtils.stringToTimestamp(beginTime);
        Timestamp endTimestamp = HRTimeWebUtils.stringToTimestamp(endTime);
        AtsTripBillInfo tripBillInfo = new AtsTripBillInfo();
        AtsTripBillEntryInfo tripBillEntryInfo = new AtsTripBillEntryInfo();
        StringBuilder sql = new StringBuilder();
        sql.append("select * from  T_BD_Person where fid ='" + personId + "'");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            if (!rowSet.next()) {
                response = MLUtile.getRes((ResourceEnum)AtsFileResEnum.NotExistsPersonNum, ctx, personId) + "!";
            } else {
                PersonCollection personColl = PersonFactory.getLocalInstance((Context)ctx).getPersonCollection(" where id = '" + personId + "'");
                if (personColl != null && !personColl.isEmpty() && personColl.size() > 0 && personColl.get(0) != null && personColl.get(0).getId() != null) {
                    personId = personColl.get(0).getId().toString();
                    tripBillEntryInfo.setPerson(personColl.get(0));
                    tripBillEntryInfo.setTripEndTime(endTimestamp);
                    tripBillEntryInfo.setTripStartTime(beginTimestamp);
                    tripBillInfo.getEntries().add(tripBillEntryInfo);
                    response = this.validateIsFillTrip(ctx, tripBillInfo);
                }
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        this.logger.info((Object)response);
        return response;
    }

    public String validateIsFillTrip(Context ctx, AtsTripBillInfo tripBillInfo, AttendanceFileInfo attendanceFile) throws Exception {
        String errorString = "";
        if (tripBillInfo == null) {
            errorString = MLUtile.getRes(AtsBillResEnum.NullBillInfo, ctx);
            return errorString;
        }
        AtsTripBillEntryCollection tripBillEntryCollection = tripBillInfo.getEntries();
        Calendar applyCal = Calendar.getInstance();
        if (tripBillInfo.getId() != null && AtsWebUtils.isInWorkFlow(ctx, tripBillInfo.getId().toString())) {
            AtsTripBillInfo tripBillInfoDB = tripBillInfo;
            if (tripBillInfo.getApplyDate() == null) {
                tripBillInfoDB = AtsTripBillFactory.getLocalInstance(ctx).getAtsTripBillInfo((IObjectPK)new ObjectUuidPK(tripBillInfo.getId().toString()));
            }
            applyCal.setTime(tripBillInfoDB.getApplyDate());
        }
        applyCal.setTime(AttencePolicyFillUtil.formatCalendar(applyCal));
        Date applyDate = applyCal.getTime();
        if (tripBillEntryCollection == null) {
            errorString = MLUtile.getRes(AtsBillResEnum.NullBillInfo, ctx);
            return errorString;
        }
        Iterator itr = tripBillEntryCollection.iterator();
        AtsTripBillEntryInfo tripBillEntryInfo = null;
        while (itr.hasNext()) {
            String personId;
            tripBillEntryInfo = (AtsTripBillEntryInfo)itr.next();
            String string = personId = tripBillEntryInfo != null && tripBillEntryInfo.getPerson() != null && tripBillEntryInfo.getPerson().getId() != null ? tripBillEntryInfo.getPerson().getId().toString() : "";
            if (tripBillEntryInfo == null || tripBillEntryInfo.getTripEndTime() == null || tripBillEntryInfo.getTripStartTime() == null) {
                errorString = MLUtile.getRes(AtsTripBillResEnum.NullTripTime, ctx) + "!";
                return errorString;
            }
            long endTimeLong = tripBillEntryInfo.getTripEndTime().getTime();
            Timestamp endTimeTimestamp = tripBillEntryInfo.getTripEndTime();
            Date endTimeDate = HRTimeWebUtils.timestampToDate(endTimeTimestamp);
            AttencePolicyInfo attencePolicyInfo = AttencePolicyFillHelper.getAttencePolicyInfo(ctx, personId, attendanceFile);
            boolean isFillTrip = false;
            if (attencePolicyInfo == null) {
                errorString = MLUtile.getRes(AtsAttenceResEnum.LeakPolicyInfoToCompleteCheck, ctx);
            } else {
                isFillTrip = attencePolicyInfo.isIsFillTrip();
            }
            if (!isFillTrip) continue;
            boolean isFillTripByTimeCtl = attencePolicyInfo.isFillTripByTimeCtl();
            boolean isFillTripByCycleCtrl = attencePolicyInfo.isFillTripByCycleCtl();
            if (isFillTripByTimeCtl) {
                BigDecimal amount = attencePolicyInfo.getFillTripAmount();
                FillAmountUnitEnum unit = attencePolicyInfo.getFillTripAmountUnit();
                errorString = AttencePolicyFillHelper.validateByTimeControl(ctx, amount, unit, applyDate, 1, attencePolicyInfo, endTimeDate);
            }
            if (isFillTripByCycleCtrl && StringUtils.isEmpty((String)errorString)) {
                int fillTripCycleType = attencePolicyInfo.getFillTripCycleType().getValue();
                BigDecimal afterDay = attencePolicyInfo.getFillTripAfterDay();
                errorString = AttencePolicyFillHelper.validateByCycleControle(ctx, personId, attencePolicyInfo, endTimeLong, fillTripCycleType, afterDay, 1);
            }
            if (StringUtils.isEmpty((String)errorString)) continue;
            return errorString;
        }
        return errorString;
    }

    public String validateIsFillTrip(Context ctx, AtsTripBillInfo tripBillInfo) throws Exception {
        return this.validateIsFillTrip(ctx, tripBillInfo, null);
    }
}

