/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.ats.lightapp.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.workflow.ProcessInstInfo;
import com.kingdee.bos.workflow.metas.ProcInstBizObjCollection;
import com.kingdee.bos.workflow.metas.ProcInstBizObjFactory;
import com.kingdee.bos.workflow.service.ormrpc.EnactmentServiceFactory;
import com.kingdee.bos.workflow.service.ormrpc.IEnactmentService;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.ats.AtsFileBizException;
import com.kingdee.eas.hr.ats.AtsHolidayFileCollection;
import com.kingdee.eas.hr.ats.AtsHolidayFileFactory;
import com.kingdee.eas.hr.ats.AtsHolidayFileHisCollection;
import com.kingdee.eas.hr.ats.AtsHolidayFileHisFactory;
import com.kingdee.eas.hr.ats.AttendanceFileCollection;
import com.kingdee.eas.hr.ats.AttendanceFileFactory;
import com.kingdee.eas.hr.ats.HolidayLimitCollection;
import com.kingdee.eas.hr.ats.HolidayLimitFactory;
import com.kingdee.eas.hr.ats.HolidayLimitInfo;
import com.kingdee.eas.hr.ats.HolidayPolicyCollection;
import com.kingdee.eas.hr.ats.HolidayPolicyFactory;
import com.kingdee.eas.hr.ats.HolidayPolicyInfo;
import com.kingdee.eas.hr.ats.HolidayPolicySetFactory;
import com.kingdee.eas.hr.ats.HolidayPolicySetInfo;
import com.kingdee.eas.hr.ats.util.AtsDateUtils;
import com.kingdee.eas.hr.ats.util.common.MLUtile;
import com.kingdee.eas.hr.base.HRCommonException;
import com.kingdee.util.NumericException;
import java.math.BigDecimal;
import java.sql.Timestamp;
import org.apache.commons.lang3.StringUtils;

public class AtsWebUtils {
    public static final String ATS_HOLIDAYTYPE_YEAR_ID = "3T54RtSQRIqAL6cffMh60P0tUpg=";

    public static HolidayLimitCollection getHolidayLimitCollectionByPersonIdAndStartOrEndTime(Context ctx, String personId, String holidayType, Timestamp startTime, Timestamp endTime) throws BOSException, EASBizException {
        AtsHolidayFileCollection attendanceFileColl = AtsHolidayFileFactory.getLocalInstance(ctx).getAtsHolidayFileCollection(" where proposer.id='" + personId + "' and attendFileState='1' ");
        if (attendanceFileColl.size() == 0) {
            // empty if block
        }
        if (attendanceFileColl.get(0).getHolidayPolicySet() == null) {
            // empty if block
        }
        HolidayPolicySetInfo holidayPolicySetInfo = HolidayPolicySetFactory.getLocalInstance(ctx).getHolidayPolicySetInfo(" where id='" + attendanceFileColl.get(0).getHolidayPolicySet().getId().toString() + "' ");
        HolidayPolicyCollection policyColl = HolidayPolicyFactory.getLocalInstance(ctx).getHolidayPolicyCollection("  where holidayPolicySet.id='" + holidayPolicySetInfo.getId().toString() + "' ");
        HolidayPolicyInfo holidayPolicyInfo = null;
        int size = policyColl.size();
        for (int i = 0; i < size; ++i) {
            if (!holidayType.equals(policyColl.get(i).getHolidayType().getId().toString())) continue;
            holidayPolicyInfo = policyColl.get(i);
            break;
        }
        if (holidayPolicyInfo == null) {
            return null;
        }
        long leaveBillStartTime = startTime.getTime();
        long leaveBillEndTime = endTime.getTime();
        boolean tempVal = false;
        long b1 = 0L;
        long e1 = 0L;
        long b2 = 0L;
        long e2 = 0L;
        HolidayLimitCollection holidayLimitCollection = AtsWebUtils.getHolidayLimitCollectionByPersonIdAndHolidayType(ctx, personId, holidayType);
        HolidayLimitCollection holidayLimitCollectionReturn = new HolidayLimitCollection();
        HolidayLimitInfo holidayLimitInfo = new HolidayLimitInfo();
        for (int i = 0; i < holidayLimitCollection.size(); ++i) {
            b1 = leaveBillStartTime;
            e1 = leaveBillEndTime;
            b2 = holidayLimitCollection.get(i).getEffectDate().getTime();
            e2 = holidayLimitCollection.get(i).getDelayDate().getTime() + 86400000L;
            if ((b1 > e2 || b1 < b2) && (e1 > e2 || e1 < b2)) continue;
            holidayLimitInfo = holidayLimitCollection.get(i);
            holidayLimitCollectionReturn.add(holidayLimitInfo);
            tempVal = true;
        }
        if (!tempVal) {
            return null;
        }
        return holidayLimitCollectionReturn;
    }

    public static HolidayLimitCollection getHolidayLimitCollectionByPersonIdAndHolidayType(Context ctx, String personId, String holidayType) throws BOSException, HRCommonException {
        HolidayPolicySetInfo holidayPolicySetInfo = new HolidayPolicySetInfo();
        HolidayPolicyCollection policyColl = new HolidayPolicyCollection();
        AtsHolidayFileCollection atsHolidayFillColl = AtsHolidayFileFactory.getLocalInstance(ctx).getAtsHolidayFileCollection(" where proposer.id='" + personId + "' and attendFileState='1' ");
        if (atsHolidayFillColl.size() == 0) {
            throw new BOSException((Throwable)((Object)new AtsFileBizException(AtsFileBizException.NOTEXISTEFFECTFILE)));
        }
        if (atsHolidayFillColl.get(0).getHolidayPolicySet() == null) {
            throw new BOSException(MLUtile.getRes((NumericException)new AtsFileBizException(AtsFileBizException.NOTEXISTEFFECTPOLICYINHFILE)));
        }
        try {
            holidayPolicySetInfo = HolidayPolicySetFactory.getLocalInstance(ctx).getHolidayPolicySetInfo(" where id='" + atsHolidayFillColl.get(0).getHolidayPolicySet().getId().toString() + "' ");
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        policyColl = HolidayPolicyFactory.getLocalInstance(ctx).getHolidayPolicyCollection(" where holidayPolicySet='" + holidayPolicySetInfo.getId().toString() + "' ");
        HolidayPolicyInfo holidayPolicy = new HolidayPolicyInfo();
        if (policyColl.size() == 0) {
            throw new BOSException(MLUtile.getRes((NumericException)new AtsFileBizException(AtsFileBizException.NOTEXISTEFFECTPOLICYINHFILE)));
        }
        for (int i = 0; i < policyColl.size(); ++i) {
            if (!holidayType.equals(policyColl.get(i).getHolidayType().getId().toString())) continue;
            holidayPolicy = policyColl.get(i);
            break;
        }
        HolidayLimitCollection holidayLimitCollection = HolidayLimitFactory.getLocalInstance(ctx).getHolidayLimitCollection(" where proposer='" + personId + "' and   holidayPolicy.holidayType='" + holidayPolicy.getHolidayType().getId().toString() + "'    ");
        return holidayLimitCollection;
    }

    public static HolidayLimitCollection getHolidayLimitCollectionByPersonIdAndStartOrEndTimeAll(Context ctx, String personId, String holidayType, Timestamp startTime, Timestamp endTime) throws BOSException, EASBizException {
        if (AtsWebUtils.checkAttendanceFileIsNull(ctx, personId).booleanValue()) {
            return null;
        }
        if (AtsWebUtils.checkHolidayPolicyIsNull(ctx, personId).booleanValue()) {
            return null;
        }
        HolidayLimitCollection holidayLimitCollection = HolidayLimitFactory.getLocalInstance(ctx).getHolidayLimitCollection(" where  proposer='" + personId + "' and   holidayPolicy.holidayType='" + holidayType + "' and cycleBeginDate <= '" + startTime + "' and cycleEndDate >= '" + endTime + "'");
        if (holidayLimitCollection.size() == 0) {
            return null;
        }
        return holidayLimitCollection;
    }

    public static Boolean checkAttendanceFileIsNull(Context ctx, String personId) throws BOSException {
        AttendanceFileCollection attendanceFileColl = AttendanceFileFactory.getLocalInstance(ctx).getAttendanceFileCollection(" select id  where proposer.id='" + personId + "' and attendFileState='1' ");
        if (attendanceFileColl.size() == 0) {
            return true;
        }
        return false;
    }

    public static Boolean checkHolidayPolicyIsNull(Context ctx, String personId) throws BOSException, EASBizException {
        AtsHolidayFileCollection atsHolidayFileCollection = AtsHolidayFileFactory.getLocalInstance(ctx).getAtsHolidayFileCollection(" select holidaypolicyset where proposer.id='" + personId + "' and attendFileState='1' ");
        if (atsHolidayFileCollection.size() == 0) {
            return true;
        }
        if (atsHolidayFileCollection.get(0).getHolidayPolicySet() == null) {
            return true;
        }
        HolidayPolicySetInfo holidayPolicySetInfo = HolidayPolicySetFactory.getLocalInstance(ctx).getHolidayPolicySetInfo(" select id where id='" + atsHolidayFileCollection.get(0).getHolidayPolicySet().getId().toString() + "' ");
        HolidayPolicyCollection policyColl = HolidayPolicyFactory.getLocalInstance(ctx).getHolidayPolicyCollection(" select id  where holidayPolicySet.id='" + holidayPolicySetInfo.getId().toString() + "' ");
        if (policyColl.size() == 0) {
            return true;
        }
        return false;
    }

    public static HolidayLimitCollection getHolidayLimitCollectionByPersonIdAndStartEndTime(Context ctx, String personId, String holidayType, Timestamp startTime, Timestamp endTime) throws BOSException, EASBizException {
        AtsHolidayFileHisCollection atsHolidayFileHisColl = null;
        String strStartTime = AtsDateUtils.timestampToShortString(startTime);
        String strEndTime = AtsDateUtils.timestampToShortString(endTime);
        atsHolidayFileHisColl = AtsHolidayFileHisFactory.getLocalInstance(ctx).getAtsHolidayFileHisCollection(" where proposer.id='" + personId + "' and EFFDT <='" + strEndTime + "' and LEFFDT >='" + strStartTime + "' and attendFileState='1' order by effdt desc ");
        if (atsHolidayFileHisColl.size() == 0) {
            return null;
        }
        if (atsHolidayFileHisColl.get(0).getHolidayPolicySet() == null) {
            return null;
        }
        String hrOrgUnitId = atsHolidayFileHisColl.get(0).getHrOrgUnit().getId().toString();
        String holidayPolicySetId = atsHolidayFileHisColl.get(0) != null && atsHolidayFileHisColl.get(0).getHolidayPolicySet() != null && atsHolidayFileHisColl.get(0).getHolidayPolicySet().getId() != null ? atsHolidayFileHisColl.get(0).getHolidayPolicySet().getId().toString() : "";
        HolidayPolicyCollection policyColl = HolidayPolicyFactory.getLocalInstance(ctx).getHolidayPolicyCollection("  where holidayPolicySet.id='" + holidayPolicySetId + "' ");
        HolidayPolicyInfo holidayPolicyInfo = new HolidayPolicyInfo();
        int size = policyColl.size();
        for (int i = 0; i < size; ++i) {
            if (!holidayType.equals(policyColl.get(i).getHolidayType().getId().toString())) continue;
            holidayPolicyInfo = policyColl.get(i);
        }
        if (holidayPolicyInfo == null) {
            return null;
        }
        long leaveBillStartTime = startTime.getTime();
        long leaveBillEndTime = endTime.getTime();
        boolean tempVal = false;
        long b1 = 0L;
        long e1 = 0L;
        long b2 = 0L;
        long e2 = 0L;
        HolidayLimitCollection holidayLimitCollection = AtsWebUtils.getHolidayLimitCollectionByPersonIdAndHolidayTypeId(ctx, personId, holidayType, hrOrgUnitId);
        HolidayLimitCollection holidayLimitCollectionReturn = new HolidayLimitCollection();
        HolidayLimitInfo holidayLimitInfo = new HolidayLimitInfo();
        for (int i = 0; i < holidayLimitCollection.size(); ++i) {
            b1 = leaveBillStartTime;
            e1 = leaveBillEndTime;
            b2 = holidayLimitCollection.get(i).getEffectDate().getTime();
            e2 = holidayLimitCollection.get(i).getDelayDate().getTime() + 86399000L;
            if (b1 > e2 || e1 < b2) continue;
            holidayLimitInfo = holidayLimitCollection.get(i);
            holidayLimitCollectionReturn.add(holidayLimitInfo);
            tempVal = true;
        }
        if (!tempVal) {
            return null;
        }
        return holidayLimitCollectionReturn;
    }

    public static HolidayLimitCollection getHolidayLimitCollectionByPersonIdAndHolidayTypeId(Context ctx, String personId, String holidayTypeId, String hrOrgUnitId) throws BOSException {
        HolidayLimitCollection holidayLimitCollection = HolidayLimitFactory.getLocalInstance(ctx).getHolidayLimitCollection(" where proposer='" + personId + "' and  holidayPolicy.holidayType='" + holidayTypeId + "' and hrOrgUnit.id='" + hrOrgUnitId + "'  ");
        return holidayLimitCollection;
    }

    public static HolidayPolicyInfo getHolidayPolicyInfoById(Context ctx, String holidayPolicyId) {
        HolidayPolicyInfo holidayPolicyInfo = null;
        try {
            holidayPolicyInfo = HolidayPolicyFactory.getLocalInstance(ctx).getHolidayPolicyInfo(" where id='" + holidayPolicyId + "'  ");
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        return holidayPolicyInfo;
    }

    public static BigDecimal setBigDecimalScale(BigDecimal bigDecimal) {
        return bigDecimal.setScale(2, 4);
    }

    public static HolidayLimitCollection getHolidayLimitCollectionByPersonId(Context ctx, String personId) throws BOSException {
        HolidayPolicySetInfo holidayPolicySetInfo = new HolidayPolicySetInfo();
        HolidayPolicyCollection policyColl = new HolidayPolicyCollection();
        AtsHolidayFileCollection holidayFileColl = AtsHolidayFileFactory.getLocalInstance(ctx).getAtsHolidayFileCollection(" where proposer.id='" + personId + "' and attendFileState='1' ");
        if (holidayFileColl.size() == 0) {
            // empty if block
        }
        if (holidayFileColl.get(0).getHolidayPolicySet() == null) {
            // empty if block
        }
        try {
            holidayPolicySetInfo = HolidayPolicySetFactory.getLocalInstance(ctx).getHolidayPolicySetInfo(" where id='" + holidayFileColl.get(0).getHolidayPolicySet().getId().toString() + "' ");
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        policyColl = HolidayPolicyFactory.getLocalInstance(ctx).getHolidayPolicyCollection(" where holidayPolicySet='" + holidayPolicySetInfo.getId().toString() + "' ");
        HolidayPolicyInfo holidayPolicy = new HolidayPolicyInfo();
        if (policyColl.size() == 0) {
            // empty if block
        }
        for (int i = 0; i < policyColl.size(); ++i) {
            if (!ATS_HOLIDAYTYPE_YEAR_ID.equals(policyColl.get(i).getHolidayType().getId().toString())) continue;
            holidayPolicy = policyColl.get(i);
        }
        HolidayLimitCollection holidayLimitCollection = HolidayLimitFactory.getLocalInstance(ctx).getHolidayLimitCollection(" where proposer='" + personId + "'    ");
        return holidayLimitCollection;
    }

    public static HolidayPolicyInfo getHolidayPolicyInfoByPersonIdAndHolidayType(Context ctx, String personId, String holidayType) throws BOSException, EASBizException {
        AtsHolidayFileCollection atsHolidayFileColl = AtsHolidayFileFactory.getLocalInstance(ctx).getAtsHolidayFileCollection(" where proposer.id='" + personId + "' and attendFileState='1' ");
        if (atsHolidayFileColl.size() == 0) {
            // empty if block
        }
        if (atsHolidayFileColl.get(0).getHolidayPolicySet() == null) {
            // empty if block
        }
        HolidayPolicySetInfo holidayPolicySetInfo = HolidayPolicySetFactory.getLocalInstance(ctx).getHolidayPolicySetInfo(" select id  where id='" + atsHolidayFileColl.get(0).getHolidayPolicySet().getId().toString() + "' ");
        HolidayPolicyCollection policyColl = HolidayPolicyFactory.getLocalInstance(ctx).getHolidayPolicyCollection(" select id ,holidayType.id,holidayType.name where holidayPolicySet.id='" + holidayPolicySetInfo.getId().toString() + "' ");
        String holidayPolicyId = new String();
        int size = policyColl.size();
        for (int i = 0; i < size; ++i) {
            if (!holidayType.equals(policyColl.get(i).getHolidayType().getId().toString())) continue;
            holidayPolicyId = policyColl.get(i).getId().toString();
            break;
        }
        if (holidayPolicyId.equals("") || holidayPolicyId == null) {
            return null;
        }
        HolidayPolicyCollection holidayPolicyColl = HolidayPolicyFactory.getLocalInstance(ctx).getHolidayPolicyCollection(" where id = '" + holidayPolicyId + "' ");
        if (holidayPolicyColl.size() == 0) {
            return null;
        }
        return holidayPolicyColl.get(0);
    }

    public static AttendanceFileCollection getAttendanceFileByPersonId(Context ctx, String personId) {
        AttendanceFileCollection attendanceFileColl = new AttendanceFileCollection();
        try {
            attendanceFileColl = AttendanceFileFactory.getLocalInstance(ctx).getAttendanceFileCollection(" where proposer.id='" + personId + "' and attendFileState='1' ");
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return attendanceFileColl;
    }

    public static boolean isInWorkFlow(Context ctx, String bizObjId) throws BOSException {
        if (StringUtils.isEmpty((CharSequence)bizObjId)) {
            return false;
        }
        boolean boo = false;
        String cndtn = null;
        if (bizObjId.indexOf(",") > 0) {
            String[] ids = StringUtils.split((String)bizObjId, (String)",");
            int n = ids.length;
            for (int i = 0; i < n; ++i) {
                cndtn = i == 0 ? "(bizObjID = '" + ids[i] + "' " : cndtn + "or bizObjID = '" + ids[i] + "' ";
            }
            cndtn = cndtn + ")";
        } else {
            cndtn = "(bizObjID = '" + bizObjId + "')";
        }
        String oql = "where " + cndtn;
        ProcInstBizObjCollection piboc = ProcInstBizObjFactory.getLocalInstance((Context)ctx).getCollection(oql);
        if (piboc != null && piboc.size() > 0) {
            boo = true;
        }
        return boo;
    }

    public static void abortWorkFlow(Context ctx, String billId) throws BOSException {
        IEnactmentService service = EnactmentServiceFactory.createEnactService((Context)ctx);
        ProcessInstInfo[] procInsts = service.getProcessInstanceByHoldedObjectId(billId);
        if (procInsts == null || procInsts.length <= 0) {
            return;
        }
        ProcessInstInfo processInstInfo = null;
        int length = procInsts.length;
        for (int i = 0; i < length; ++i) {
            if (!procInsts[i].getState().startsWith("open")) continue;
            processInstInfo = procInsts[i];
        }
        if (null != processInstInfo) {
            service.terminateProcessInst(processInstInfo.getProcInstId().toString());
        }
    }

    public static String getRootAdminlongNumber(String longNumber) {
        StringBuffer allLongNumber = new StringBuffer();
        allLongNumber.append("'" + longNumber + "'");
        while (longNumber.lastIndexOf(33) != -1) {
            longNumber = longNumber.substring(0, longNumber.lastIndexOf(33));
            allLongNumber.append(",'" + longNumber + "'");
        }
        return allLongNumber.toString();
    }
}

