/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.ats.lightapp.util;

import com.kingdee.bos.BOSException;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.ats.util.AtsDateUtils;
import com.kingdee.eas.hr.ats.util.common.AtsCommonUtile;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;

public class HRTimeWebUtils {
    public static String timestampToString(Timestamp timestamp) {
        String tsStr = "";
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            tsStr = sdf.format(timestamp);
        }
        catch (Exception e) {
            AtsCommonUtile.logFirstStack(e);
        }
        return tsStr;
    }

    public static Timestamp dateToTimestamp(Date date) {
        Timestamp ts = new Timestamp(date.getTime());
        return ts;
    }

    public static Timestamp stringToTimestamp(String tsStr) {
        Timestamp ts = new Timestamp(System.currentTimeMillis());
        try {
            ts = Timestamp.valueOf(tsStr);
        }
        catch (Exception e) {
            AtsCommonUtile.logFirstStack(e);
        }
        return ts;
    }

    public static Timestamp stringShortToTimestamp(String tsStr) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        format.setLenient(false);
        Timestamp ts = new Timestamp(System.currentTimeMillis());
        try {
            ts = new Timestamp(format.parse(tsStr).getTime());
        }
        catch (ParseException e) {
            AtsCommonUtile.logFirstStack(e);
        }
        return ts;
    }

    public static Date timestampToDate(Timestamp temTimestamp) {
        Date date = new Date();
        try {
            date = temTimestamp;
        }
        catch (Exception e) {
            AtsCommonUtile.logFirstStack(e);
        }
        return date;
    }

    public static String dateLongToString(Date date) {
        String dateStr = "";
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            dateStr = sdf.format(date);
        }
        catch (Exception e) {
            AtsCommonUtile.logFirstStack(e);
        }
        return dateStr;
    }

    public static String getTimeCoincidence(Date beginTime1, Date endTime1, Date beginTime2, Date endTime2) {
        String coincidenceTime;
        long b1 = beginTime1.getTime();
        long e1 = endTime1.getTime();
        long b2 = beginTime2.getTime();
        long e2 = endTime2.getTime();
        if (b1 <= b2 && e1 >= e2) {
            coincidenceTime = HRTimeWebUtils.getTimeDifference(endTime2, beginTime2);
        } else if (b1 >= b2 && e1 <= e2) {
            coincidenceTime = HRTimeWebUtils.getTimeDifference(endTime1, beginTime1);
        } else if (b1 >= b2 && b1 < e2 && e2 <= e1) {
            coincidenceTime = HRTimeWebUtils.getTimeDifference(endTime2, beginTime1);
        } else if (b1 <= b2 && e1 <= e2 && e1 > b2) {
            coincidenceTime = HRTimeWebUtils.getTimeDifference(endTime1, beginTime2);
        } else if (e1 <= b2 || b1 >= e2) {
            coincidenceTime = "0";
        } else {
            coincidenceTime = "-1";
            System.out.println("Unexpected date combination,Could not calculate coincidence.");
        }
        return coincidenceTime;
    }

    public static String getTimeDifference(Date date1, Date date2) {
        StringBuffer df = new StringBuffer();
        try {
            long num = (date1.getTime() - date2.getTime()) / 60000L;
            if (num > 0L) {
                df.append(num);
            } else if (num == 0L) {
                df.append(1);
            } else {
                df.append(-1);
            }
        }
        catch (Exception e) {
            AtsCommonUtile.logFirstStack(e);
        }
        return df.toString();
    }

    public static Date stringToLongDate(String str) {
        Date date = new Date();
        if (str.indexOf("/") != -1) {
            str = str.replaceAll("/", "-");
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            date = sdf.parse(str);
        }
        catch (Exception e) {
            AtsCommonUtile.logFirstStack(e);
        }
        return date;
    }

    public static Date stringToShortDate(String str) {
        Date date = new Date();
        if (str.indexOf("/") != -1) {
            str = str.replaceAll("/", "-");
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        try {
            date = sdf.parse(str);
        }
        catch (Exception e) {
            AtsCommonUtile.logFirstStack(e);
        }
        return date;
    }

    public static Date stringToLongDate(String str, boolean errorToNull) {
        Date date = new Date();
        if (errorToNull) {
            date = null;
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            date = sdf.parse(str);
        }
        catch (Exception e) {
            AtsCommonUtile.logFirstStack(e);
        }
        return date;
    }

    public static String dateShortToString(Date date) {
        String dateStr = "";
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        try {
            dateStr = sdf.format(date);
        }
        catch (Exception e) {
            AtsCommonUtile.logFirstStack(e);
        }
        return dateStr;
    }

    public static Date formatCalendar(Calendar cal) {
        int year = cal.get(1);
        int month = cal.get(2);
        int day = cal.get(5);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        Date date = null;
        try {
            date = sdf.parse(year + "-" + (month + 1) + "-" + day);
        }
        catch (ParseException e) {
            AtsCommonUtile.logFirstStack(e);
        }
        return date;
    }

    public static List getLeaveBeforeAndAfterDateColl(Date beginTime, Date endTime) throws EASBizException, BOSException {
        ArrayList<Date> dateList = new ArrayList<Date>();
        beginTime = AtsDateUtils.getPreDay(beginTime);
        endTime = AtsDateUtils.getNextDay(endTime);
        beginTime = HRTimeWebUtils.stringToShortDate(HRTimeWebUtils.dateLongToString(beginTime));
        endTime = HRTimeWebUtils.stringToShortDate(HRTimeWebUtils.dateLongToString(endTime));
        Calendar beginCal = Calendar.getInstance();
        beginCal.setTime(beginTime);
        Calendar endCal = Calendar.getInstance();
        endCal.setTime(endTime);
        int temp = (int)((endTime.getTime() - beginTime.getTime()) / 86400000L + 1L);
        for (int i = 0; i < temp; ++i) {
            int year = beginCal.get(1);
            int month = beginCal.get(2);
            int day = beginCal.get(5);
            Date tempDate = new Date(year - 1900, month, day);
            dateList.add(tempDate);
            beginCal.add(5, 1);
        }
        return dateList;
    }
}

