/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.ats.sum.backCal.service.impl;

import com.kingdee.bos.Context;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.eas.hr.ats.AtsFormulaResEnum;
import com.kingdee.eas.hr.ats.AtsUtil;
import com.kingdee.eas.hr.ats.app.formula.calculate.ResultCal;
import com.kingdee.eas.hr.ats.common.AtsTempTableUtil;
import com.kingdee.eas.hr.ats.sum.backCal.manager.AtsSumBackCalThread;
import com.kingdee.eas.hr.ats.sum.backCal.service.AtsSumBackCal;
import com.kingdee.eas.hr.ats.sum.backCal.service.AtsSumBackCalService;
import com.kingdee.eas.hr.ats.sum.backCal.util.AtsSumBackCalHelper;
import com.kingdee.eas.hr.ats.sum.backCal.vo.AtsSumBackCalVO;
import com.kingdee.eas.hr.ats.sum.factory.AtsSumFactory;
import com.kingdee.eas.hr.ats.sum.service.formula.CalculateDynaCustomerResult;
import com.kingdee.eas.hr.ats.sum.util.AtsResultToSumHelper;
import com.kingdee.eas.hr.ats.sum.util.AtsSumSalaryUtil;
import com.kingdee.eas.hr.ats.util.AtsDateUtils;
import com.kingdee.eas.hr.ats.util.common.MLUtile;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class AtsSumBackCalImpl
implements AtsSumBackCal {
    private AtsSumBackCalService atsSumBackCalService;
    private static Logger logger = Logger.getLogger(AtsSumBackCalImpl.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, Object> sumResult(Context ctx, AtsSumBackCalVO backCalVO) {
        int sumType = this.getSumType(ctx);
        this.initAtsSumBackCalService(sumType);
        backCalVO.setSumType(sumType);
        String tempTableName = null;
        HashMap<String, Object> resultMap = new HashMap();
        try {
            tempTableName = this.atsSumBackCalService.prepareTempTable(ctx, backCalVO);
            resultMap = this.batchSumResult(ctx, backCalVO, tempTableName);
        }
        finally {
            if (!StringUtils.isEmpty((String)tempTableName)) {
                TempTablePool.getInstance((Context)ctx).releaseTable(tempTableName);
            }
        }
        return resultMap;
    }

    @Override
    public Map<String, Object> batchSumResult(Context ctx, AtsSumBackCalVO backCalVO, String tempTableName) {
        Map<String, Object> resultMap;
        block6: {
            int totalCount = AtsResultToSumHelper.getQueryTotalCount(ctx, tempTableName);
            logger.error((Object)("-------------------AtsSumBackCalImpl batchSumResult totalCount: " + totalCount));
            long startTime = System.currentTimeMillis();
            resultMap = new HashMap<String, Object>();
            Map<String, String> columnMap = this.atsSumBackCalService.getColumnMap(ctx, this.atsSumBackCalService.getSelector(ctx, "summaryTitleView"));
            List<String> keyList = this.atsSumBackCalService.getKeyList(ctx, "T_HR_ATS_ATTENDANCESUMBACKCAL", columnMap);
            try {
                if (totalCount < 1000) {
                    int rows = 500;
                    int pages = 0;
                    pages = totalCount % rows == 0 ? totalCount / rows : totalCount / rows + 1;
                    for (int page = 1; page <= pages; ++page) {
                        try {
                            Map<String, Object> batchMsgMap = this.doSumResult(ctx, rows, pages, totalCount, tempTableName, columnMap, keyList, backCalVO);
                            this.atsSumBackCalService.assembleMsg(ctx, batchMsgMap, resultMap);
                        }
                        catch (Exception e1) {
                            e1.printStackTrace();
                        }
                        logger.error((Object)("detail trans gather per page cost: " + (System.currentTimeMillis() - startTime)));
                    }
                    break block6;
                }
                resultMap = this.sumResultByMultiThread(ctx, backCalVO, tempTableName, totalCount, columnMap, keyList);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return resultMap;
    }

    private Map<String, Object> sumResultByMultiThread(Context ctx, AtsSumBackCalVO backCalVO, String tempTableName, int totalCount, Map<String, String> columnMap, List<String> keyList) {
        ArrayList<Future<Object>> futureList = new ArrayList<Future<Object>>();
        ExecutorService fixedThreadPool = Executors.newFixedThreadPool(3);
        int pages = 0;
        int rows = 500;
        pages = totalCount % rows == 0 ? totalCount / rows : totalCount / rows + 1;
        int indexPage = 1;
        boolean out = false;
        while (!out) {
            if (indexPage >= pages) {
                out = true;
            }
            AtsSumBackCalThread callable = new AtsSumBackCalThread(ctx, rows, indexPage, totalCount, tempTableName, columnMap, keyList, backCalVO, this.atsSumBackCalService);
            Future<Object> future = fixedThreadPool.submit(callable);
            futureList.add(future);
            ++indexPage;
        }
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        for (int i = 0; i < futureList.size(); ++i) {
            try {
                Map genResult = (Map)((Future)futureList.get(i)).get();
                this.atsSumBackCalService.assembleMsg(ctx, genResult, resultMap);
                continue;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                continue;
            }
            catch (ExecutionException e) {
                e.printStackTrace();
            }
        }
        fixedThreadPool.shutdown();
        return resultMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, Object> doSumResult(Context ctx, int rows, int pages, int totalCount, String tempTableName, Map<String, String> columnMap, List<String> keyList, AtsSumBackCalVO backCalVO) {
        String sumKeyTmpTable = null;
        Set<String> existSumRecordSet = null;
        Map<String, Object> resultMap = new HashMap<String, Object>();
        List<LinkedHashMap<String, Object>> sumRowLinkedList = null;
        try {
            String sqlt = AtsSumBackCalHelper.getAtsTempTableSql(ctx, totalCount, rows, pages, tempTableName, " * ");
            IRowSet sumKeyRows = DbUtil.executeQuery((Context)ctx, (String)sqlt);
            sumRowLinkedList = this.atsSumBackCalService.getSumRowLinkedList(ctx, backCalVO, sumKeyRows);
            if (null != sumRowLinkedList && sumRowLinkedList.size() > 0) {
                sumKeyTmpTable = this.atsSumBackCalService.prepareSumKeyTmpTable(ctx, sumRowLinkedList);
                existSumRecordSet = this.atsSumBackCalService.getExistedSumRecordSet(ctx, backCalVO, sumRowLinkedList, sumKeyTmpTable);
                this.atsSumBackCalService.setDetailToSumRecord(ctx, sumKeyTmpTable, backCalVO, sumRowLinkedList, columnMap);
                resultMap = this.atsSumBackCalService.sum(ctx, sumRowLinkedList, keyList, existSumRecordSet, backCalVO);
                this.atsSumBackCalService.saveSumRecord(ctx, resultMap, keyList);
            }
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        finally {
            if (!StringUtils.isEmpty(sumKeyTmpTable)) {
                AtsTempTableUtil.dropTable(ctx, sumKeyTmpTable);
            }
        }
        logger.error((Object)("PAGE: RESULTTOSUM total records:" + (null == sumRowLinkedList ? 0 : sumRowLinkedList.size())));
        logger.error((Object)("PAGE: RESULTTOSUM existAttendRecord size:" + (null == existSumRecordSet ? 0 : existSumRecordSet.size())));
        return resultMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, Object> doSumResultBySelected(Context ctx, AtsSumBackCalVO backCalVO, Map<String, String> columnMap, List<String> keyList, List<LinkedHashMap<String, Object>> sumRowLinkedList) {
        String sumKeyTmpTable = null;
        Set<String> existSumRecordSet = null;
        Map<String, Object> resultMap = new HashMap<String, Object>();
        try {
            if (null != sumRowLinkedList && sumRowLinkedList.size() > 0) {
                sumKeyTmpTable = this.atsSumBackCalService.prepareSumKeyTmpTable(ctx, sumRowLinkedList);
                existSumRecordSet = this.atsSumBackCalService.getExistedSumRecordSet(ctx, backCalVO, sumRowLinkedList, sumKeyTmpTable);
                this.atsSumBackCalService.setDetailToSumRecord(ctx, sumKeyTmpTable, backCalVO, sumRowLinkedList, columnMap);
                resultMap = this.atsSumBackCalService.sum(ctx, sumRowLinkedList, keyList, existSumRecordSet, backCalVO);
                this.atsSumBackCalService.saveSumRecord(ctx, resultMap, keyList);
            }
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        finally {
            if (!StringUtils.isEmpty(sumKeyTmpTable)) {
                AtsTempTableUtil.dropTable(ctx, sumKeyTmpTable);
            }
        }
        logger.error((Object)("PAGE: RESULTTOSUM total records:" + (null == sumRowLinkedList ? 0 : sumRowLinkedList.size())));
        logger.error((Object)("PAGE: RESULTTOSUM existAttendRecord size:" + (null == existSumRecordSet ? 0 : existSumRecordSet.size())));
        return resultMap;
    }

    @Override
    public Map<String, Object> sumSelectedResult(Context ctx, AtsSumBackCalVO backCalVO) {
        int sumType = this.getSumType(ctx);
        this.initAtsSumBackCalService(sumType);
        backCalVO.setSumType(sumType);
        Map<String, String> columnMap = this.atsSumBackCalService.getColumnMap(ctx, this.atsSumBackCalService.getSelector(ctx, "summaryTitleView"));
        List<String> keyList = this.atsSumBackCalService.getKeyList(ctx, "T_HR_ATS_ATTENDANCERESULTSUM", columnMap);
        List<LinkedHashMap<String, Object>> sumRowLinkedList = this.atsSumBackCalService.getSumRowLinkedListBySelected(ctx, backCalVO);
        Map<String, Object> resultMap = this.doSumResultBySelected(ctx, backCalVO, columnMap, keyList, sumRowLinkedList);
        return resultMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, Object> sumResultForDynamic(Context ctx, AtsSumBackCalVO backCalVO) {
        int sumType = this.getSumType(ctx);
        this.initAtsSumBackCalService(sumType);
        backCalVO.setSumType(sumType);
        String tempTableName = null;
        HashMap<String, Object> resultMap = new HashMap();
        try {
            tempTableName = AtsSumBackCalHelper.getAttenceResultTempTable(ctx, backCalVO.getSession(), backCalVO.getBackCalDynamicSql());
            resultMap = this.batchSumResult(ctx, backCalVO, tempTableName);
        }
        finally {
            if (!StringUtils.isEmpty((String)tempTableName)) {
                TempTablePool.getInstance((Context)ctx).releaseTable(tempTableName);
            }
        }
        return resultMap;
    }

    @Override
    public Map<String, Object> calCustomerSumResult(Context ctx, AtsSumBackCalVO backCalVO, Map<String, Object> resultMap) {
        try {
            if (null != resultMap && resultMap.size() > 0) {
                String attencePolicyId = backCalVO.getBackCalPeriodId();
                String dynamicSQL = backCalVO.getBackCalDynamicSql();
                boolean calFormula = true;
                if (!StringUtils.isEmpty((String)attencePolicyId)) {
                    ResultCal cal = new ResultCal();
                    cal.setMainTableName("T_HR_ATS_ATTENDANCESUMBACKCAL");
                    cal.setCtx(ctx);
                    IRowSet rowSet = cal.getSchemeFormulas(attencePolicyId);
                    if (rowSet == null || rowSet.size() == 0) {
                        calFormula = false;
                    }
                }
                if (calFormula) {
                    HashMap<String, String> filterItems = new HashMap<String, String>();
                    filterItems.put("beginDate", AtsDateUtils.dateShortToString(backCalVO.getStartDate()));
                    filterItems.put("endDate", AtsDateUtils.dateShortToString(backCalVO.getEndDate()));
                    filterItems.put("attendPeriodId", backCalVO.getBackCalPeriodId());
                    filterItems.put("attendPolicyId", backCalVO.getAttendPolicyId());
                    if (!StringUtils.isEmpty((String)dynamicSQL)) {
                        new CalculateDynaCustomerResult().calculateSumResult(ctx, filterItems, dynamicSQL, "ATS_RESULT");
                    } else {
                        Set sumIdSet = (Set)resultMap.get("SUMID_SET");
                        if (null != sumIdSet && sumIdSet.size() > 0) {
                            dynamicSQL = "SELECT ATS_RESULT.* FROM T_HR_ATS_ATTENDANCESUMBACKCAL ATS_RESULT WHERE FID IN (" + AtsUtil.convertSetToString(sumIdSet) + ") order by ATS_RESULT.FID desc";
                            new CalculateDynaCustomerResult().calculateSumResult(ctx, filterItems, dynamicSQL, "ATS_RESULT");
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)(" result to sum calCustomerSumResult fail," + MLUtile.getRes(AtsFormulaResEnum.CallFail, ctx)));
            e.printStackTrace();
        }
        return resultMap;
    }

    @Override
    public int getSumType(Context ctx) {
        return AtsSumSalaryUtil.getSystemParamIntValue(ctx, "3qBV2X0Zi0KK2Aaru9d9YaiB8+c=");
    }

    public void initAtsSumBackCalService(int sumType) {
        if (this.atsSumBackCalService == null) {
            AtsSumBackCalService atsSumBackCalService = AtsSumFactory.getInstance().createAtsSumBackCalService(sumType);
            this.setAtsSumBackCalService(atsSumBackCalService);
        }
    }

    @Override
    public AtsSumBackCalService getAtsSumBackCalService() {
        return this.atsSumBackCalService;
    }

    @Override
    public void setAtsSumBackCalService(AtsSumBackCalService atsSumBackCalService) {
        this.atsSumBackCalService = atsSumBackCalService;
    }
}

