/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.ats.sum.util;

import com.kingdee.bos.Context;
import com.kingdee.eas.hr.ats.AtsUtil;
import com.kingdee.eas.hr.ats.decimalPlace.util.DecimalPlaceUtil;
import com.kingdee.eas.hr.ats.sum.util.AtsResultToSumHelper;
import com.kingdee.eas.hr.ats.util.AtsServerCalUtils;
import com.kingdee.eas.hr.ats.util.common.MLUtile;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;

public class AtsResultToSumHRPersonAttHelper {
    private static Logger logger = Logger.getLogger(AtsResultToSumHRPersonAttHelper.class);

    public static String createResultToSumTempTableByHRPersonAtt(Context ctx, Map<String, String> filterItems, HttpSession session) throws Exception {
        String sql = AtsResultToSumHRPersonAttHelper.getAttendResultSumSqlByHRPersonAtt(ctx, filterItems);
        String tempTableName = AtsResultToSumHelper.getAttenceResultTempTable(ctx, filterItems, sql);
        filterItems.put("tempTableName", tempTableName);
        filterItems.put("resultToSumSQL", sql);
        AtsResultToSumHelper.setTmpTableToSession(filterItems, session);
        logger.error((Object)("RESULT TO SUM GROUP SQL:getGridResultToSumDataSql resultToSum dynamicSql: " + sql.toString()));
        return tempTableName;
    }

    public static String getAttendResultSumSqlByHRPersonAtt(Context ctx, Map<String, String> filterItems) throws Exception {
        String personJson;
        StringBuffer sumSql = new StringBuffer();
        sumSql.append(" SELECT FHIS.FHrOrgUnitID,FHIS.FATTAdminOrgUnitID FAdminOrgUnitID,FHIS.FProposerID,person.FNumber as personNumber , person.FName" + MLUtile.getMlFlag(ctx) + " as personName ");
        sumSql.append(" FROM T_HR_ATS_AttendanceFileHIS FHIS ");
        sumSql.append(" INNER JOIN T_BD_Person person on FHIS.FProposerID = person.FID ");
        sumSql.append(" WHERE FHIS.FLEFFDT >= {ts '" + filterItems.get("beginDate") + "'}");
        sumSql.append(" AND FHIS.FEFFDT <= {ts '" + filterItems.get("endDate") + "'} ");
        String attendGroupSql = AtsServerCalUtils.getAttenceGroupSql(filterItems);
        if (!StringUtils.isEmpty((String)attendGroupSql)) {
            sumSql.append(attendGroupSql);
        }
        if (!(StringUtils.isEmpty((String)(personJson = filterItems.get("personJson"))) || "\"\"".equals(personJson) || "All".equalsIgnoreCase(personJson))) {
            Set<String> personKeys = AtsResultToSumHelper.getSelectPersonKey(personJson);
            sumSql.append(" and concat(FHIS.fhrOrgUnitId,concat(FHIS.fproposerid,FHIS.FATTAdminOrgUnitID)) in (" + AtsUtil.convertSetToString(personKeys) + ")");
        } else {
            sumSql.append(AtsResultToSumHRPersonAttHelper.getAttendResultSumWhereSqlHRPerson(ctx, filterItems));
            String customFilter = filterItems.get("customFilter");
            if (!StringUtils.isEmpty((String)customFilter)) {
                sumSql.append(customFilter);
            }
        }
        sumSql.append(" GROUP BY FHIS.FHrOrgUnitID,FHIS.FATTAdminOrgUnitID,FHIS.FProposerID,person.FNumber,person.FName" + MLUtile.getMlFlag(ctx));
        return sumSql.toString();
    }

    public static String getAttendResultSumWhereSqlHRPerson(Context ctx, Map<String, String> filterItems) {
        String attenceStatus;
        StringBuffer WhereSql = new StringBuffer();
        String filterItem = filterItems.get("filterItems");
        if (!StringUtils.isEmpty((String)filterItem)) {
            if (filterItem.indexOf("name") != -1) {
                filterItem = filterItem.replaceAll("name", "fname" + MLUtile.getMlFlag(ctx));
            }
            if (filterItem.indexOf("number") != -1) {
                filterItem = filterItem.replaceAll("number", "fnumber");
            }
            WhereSql.append(" and " + filterItem);
        }
        if (!StringUtils.isEmpty((String)(attenceStatus = filterItems.get("attenceStatus")))) {
            if (attenceStatus.equals("0")) {
                WhereSql.append("  AND not exists ");
                WhereSql.append("  ( select 1 from T_HR_ATS_AttendanceResult result ");
                WhereSql.append("     where FHIS.FHrOrgUnitID = result.FATTHrOrgUnitID");
                WhereSql.append("     and FHIS.fproposerid = result.fproposerid");
                WhereSql.append("     and FHIS.FATTADMINORGUNITID = result.FATTADMINORGUNITID");
                WhereSql.append("     and result.FATTENCEDATE >= {ts '" + filterItems.get("beginDate") + "'} ");
                WhereSql.append("     and result.FATTENCEDATE <= {ts '" + filterItems.get("endDate") + "'} ");
                WhereSql.append("  ) ");
            } else if (attenceStatus.equals("1")) {
                WhereSql.append("  AND exists ");
                WhereSql.append("  ( select 1 from T_HR_ATS_AttendanceResult result ");
                WhereSql.append("     where FHIS.FHrOrgUnitID = result.FATTHrOrgUnitID");
                WhereSql.append("     and FHIS.FATTADMINORGUNITID = result.FATTADMINORGUNITID");
                WhereSql.append("     AND FHIS.fproposerid = result.fproposerid");
                WhereSql.append("     and result.fattencestatus in ( 1,4) ");
                WhereSql.append("     and result.FATTENCEDATE >= {ts '" + filterItems.get("beginDate") + "'} ");
                WhereSql.append("     and result.FATTENCEDATE <= {ts '" + filterItems.get("endDate") + "'} ");
                WhereSql.append("  ) ");
            } else if (attenceStatus.equals("2")) {
                WhereSql.append("  AND not exists ");
                WhereSql.append("  ( select 1 from T_HR_ATS_AttendanceResult result ");
                WhereSql.append("     where FHIS.FHrOrgUnitID = result.FATTHrOrgUnitID");
                WhereSql.append("     and FHIS.FATTADMINORGUNITID = result.FATTADMINORGUNITID");
                WhereSql.append("     AND FHIS.fproposerid = result.fproposerid");
                WhereSql.append("     and result.fattencestatus in (1,4) ");
                WhereSql.append("     and result.FATTENCEDATE >= {ts '" + filterItems.get("beginDate") + "'} ");
                WhereSql.append("     and result.FATTENCEDATE <= {ts '" + filterItems.get("endDate") + "'} ");
                WhereSql.append("  ) ");
                WhereSql.append("  AND exists ");
                WhereSql.append("  ( select 1 from T_HR_ATS_AttendanceResult result ");
                WhereSql.append("     where FHIS.FHrOrgUnitID = result.FATTHrOrgUnitID");
                WhereSql.append("     and FHIS.FATTADMINORGUNITID = result.FATTADMINORGUNITID");
                WhereSql.append("     and FHIS.fproposerid = result.fproposerid");
                WhereSql.append("     and result.FATTENCEDATE >= {ts '" + filterItems.get("beginDate") + "'} ");
                WhereSql.append("     and result.FATTENCEDATE <= {ts '" + filterItems.get("endDate") + "'} ");
                WhereSql.append("  ) ");
            } else if (attenceStatus.equals("10")) {
                WhereSql.append("  AND exists ");
                WhereSql.append("  ( select 1 from T_HR_ATS_AttendanceReSumMd atsum ");
                WhereSql.append("     inner join T_HR_ATS_AttendancePeriod attPeriod ");
                WhereSql.append("     on  atsum.FAttendancePeriodID = attPeriod.fid ");
                WhereSql.append("     where atsum.fhrorgunitid = FHIS.fhrorgunitid ");
                WhereSql.append("     and atsum.fproposerid = FHIS.fproposerid");
                WhereSql.append("     and atsum.fadminorgunitid = FHIS.fATTadminorgunitid ");
                WhereSql.append("     and {ts '" + filterItems.get("beginDate") + "'} = attPeriod.Fstartdate");
                WhereSql.append("     and {ts '" + filterItems.get("endDate") + "'} = attPeriod.fendDate ");
                WhereSql.append("  ) ");
            }
        }
        String orgTempTableName = filterItems.get("adminOrgTempTableName");
        String existsSql = AtsResultToSumHelper.getOrgWhereSql(filterItems, orgTempTableName);
        WhereSql.append(existsSql);
        return WhereSql.toString();
    }

    public static void setGridAttendResultSumInfoByHRPersonAtt(Context ctx, String keyTmpTableName, Map<String, Object> params, List<LinkedHashMap<String, Object>> rowList, Map<String, String> columnMap) {
        try {
            Map filterItems = (Map)params.get("sumParams");
            String beginDate = (String)filterItems.get("beginDate");
            String endDate = (String)filterItems.get("endDate");
            String attendPeriodId = (String)filterItems.get("attendPeriodId");
            String attendPeriodName = (String)filterItems.get("attendPeriodName");
            int sumSize = rowList.size();
            int decimalPlacesSystem = DecimalPlaceUtil.getDecimalPlaceSystem(ctx);
            IRowSet rowSet = AtsResultToSumHRPersonAttHelper.getAttendDetailDataGridByHRPersonAtt(ctx, keyTmpTableName, beginDate, endDate, filterItems);
            for (int i = 0; i < sumSize; ++i) {
                Map rowListMap = rowList.get(i);
                String sumKey = (String)rowListMap.get("key");
                rowListMap.put("beginDate", beginDate);
                rowListMap.put("endDate", endDate);
                rowListMap.put("attendPeriodId", attendPeriodId);
                rowListMap.put("attendPeriodName", attendPeriodName);
                while (rowSet.next()) {
                    String positionId = rowSet.getString("fpositionID");
                    String currentKey = rowSet.getString("fatthrorgunitid") + rowSet.getString("fproposerid") + rowSet.getString("fattadminorgunitid");
                    String resultId = rowSet.getString("FID");
                    try {
                        if (!sumKey.equals(currentKey)) continue;
                        rowListMap.put("fpositionID", positionId);
                        rowListMap.put("resultId", resultId);
                        AtsResultToSumHelper.setAttendResultSumData(ctx, rowSet, rowListMap, columnMap, decimalPlacesSystem);
                    }
                    catch (Exception e) {
                        logger.error((Object)("PAGE: RESULTTOSUM call setGridAttendResultSumInfoByPerson error,gather/gather to salary prepare detail data error,sumKey:" + sumKey));
                        e.printStackTrace();
                    }
                }
                rowSet.beforeFirst();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static IRowSet getAttendDetailDataGridByHRPersonAtt(Context ctx, String keyTmpTableName, String beginDate, String endDate, Map<String, String> filterItems) {
        IRowSet rowSet = null;
        StringBuffer sb = new StringBuffer();
        sb.append(" select RESULT.* from T_HR_ATS_AttendanceResult RESULT   ");
        sb.append("  WHERE EXISTS (SELECT 1 FROM  " + keyTmpTableName + " ATS_TMP WHERE ATS_TMP.fproposerid = RESULT.fproposerid ");
        sb.append("  AND ATS_TMP.FHRORGUNITID = RESULT.FATTHRORGUNITID  ");
        sb.append("  AND ATS_TMP.FADMINORGUNITID = RESULT.FATTADMINORGUNITID )");
        sb.append("  AND RESULT.FATTENCEDATE >= {ts '" + beginDate + "' }");
        sb.append("  AND RESULT.FATTENCEDATE <=  {ts '" + endDate + "' }");
        try {
            rowSet = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
        }
        catch (Exception e) {
            logger.error((Object)("PAGE: RESULTTOSUM call getAttendDetailDataGridByHRPersonAtt error: " + sb.toString()));
            e.printStackTrace();
        }
        return rowSet;
    }

    public static IRowSet setDetailDateInfoByHRPersonAtt(Context ctx, String hrOrgUnitId, String adminOrgId, String personId, String beginDate, String endDate, String fields) {
        StringBuffer sb = new StringBuffer();
        sb.append(" select " + fields + " from T_HR_ATS_AttendanceResult resultDetail ");
        sb.append(" where resultDetail.fproposerid='" + personId + "' and ");
        if (!StringUtils.isEmpty((String)hrOrgUnitId)) {
            sb.append(" resultDetail.fatthrOrgUnitId='" + hrOrgUnitId + "' and ");
        }
        sb.append(" resultDetail.FATTADMINORGUNITID ='" + adminOrgId + "' and ");
        sb.append(" resultDetail.FATTENCEDATE  >= {ts '" + beginDate + "'}");
        sb.append(" and resultDetail.FATTENCEDATE <= {ts '" + endDate + "'}");
        sb.append(" order by FATTENCEDATE ");
        IRowSet rowSet = null;
        try {
            rowSet = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return rowSet;
    }

    public static IRowSet getDetailDataGridHRPersonAtt(Context ctx, String keyPerAndOrgTmpTable, String beginDate, String endDate, String summarySql, String detailSql) {
        IRowSet rowSet = null;
        try {
            StringBuffer sb = new StringBuffer();
            sb.append(" select ATS_TMP.fhrorgunitid fhrorgunitid,RESULT.fproposerid,ATS_TMP.fadminorgunitid fadminorgunitid," + detailSql + " ");
            if (!StringUtils.isEmpty((String)summarySql)) {
                sb.append("," + summarySql + "");
            }
            sb.append("  FROM T_HR_ATS_AttendanceResult RESULT ");
            sb.append("  INNER JOIN " + keyPerAndOrgTmpTable + " ATS_TMP ON ATS_TMP.fproposerid = RESULT.fproposerid AND ATS_TMP.fhrorgunitid = RESULT.fATThrorgunitid AND ATS_TMP.fadminorgunitid = RESULT.fattadminorgunitid ");
            sb.append("  WHERE FATTENCEDATE >= {ts'" + beginDate + "'}");
            sb.append("  AND FATTENCEDATE <={ts'" + endDate + "'}");
            rowSet = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return rowSet;
    }
}

