/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.ats.sum.util;

import com.kingdee.bos.Context;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.hr.ats.AtsAttenceCycleResEnum;
import com.kingdee.eas.hr.ats.common.AtsTempTableUtil;
import com.kingdee.eas.hr.ats.decimalPlace.util.DecimalPlaceUtil;
import com.kingdee.eas.hr.ats.sum.util.AtsResultToSumHelper;
import com.kingdee.eas.hr.ats.util.AtsDateUtils;
import com.kingdee.eas.hr.ats.util.common.MLUtile;
import com.kingdee.eas.hr.base.HRCommonException;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONObject;

public class AtsSumMulPozitionUtil {
    private static Logger logger = Logger.getLogger(AtsSumMulPozitionUtil.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String createResultToSumTempTable(Context ctx, Map<String, String> filterItems, HttpSession session) throws Exception {
        String resultItemTempTableName = null;
        String tempTableName = null;
        try {
            StringBuffer sumSql = new StringBuffer();
            String personJson = filterItems.get("personJson");
            if (StringUtils.isEmpty((String)personJson) || "\"\"".equals(personJson) || "All".equalsIgnoreCase(personJson)) {
                String tmpSql = AtsSumMulPozitionUtil.getAttendResultSumSql(ctx, filterItems);
                resultItemTempTableName = TempTablePool.getInstance((Context)ctx).createTempTableName();
                String tempSql = "select * into " + resultItemTempTableName + " from (" + tmpSql + ") T ";
                DbUtil.execute((Context)ctx, (String)tempSql.toString());
                AtsSumMulPozitionUtil.createSumIndex(ctx, resultItemTempTableName);
                logger.error((Object)("RESULTTOSUM MULPOZITION attResultItemSql: " + tmpSql.toString()));
                sumSql.append(" SELECT resultItem.fhrOrgUnitId,resultItem.FAttAdminOrgUnitID,resultItem.FProposerID ");
                sumSql.append(" FROM " + resultItemTempTableName + " resultItem");
                sumSql.append(" GROUP BY resultItem.fhrorgunitid,resultItem.FProposerID,resultItem.FAttAdminOrgUnitID ");
            }
            tempTableName = TempTablePool.getInstance((Context)ctx).createTempTableName();
            DbUtil.execute((Context)ctx, (String)("select * into " + tempTableName + " from (" + sumSql + ") T "));
            AtsSumMulPozitionUtil.createSumIndex(ctx, tempTableName);
            filterItems.put("tempTableName", tempTableName);
            filterItems.put("resultToSumSQL", sumSql.toString());
            AtsSumMulPozitionUtil.setTmpTableToSession(filterItems, session);
            logger.error((Object)("RESULTTOSUM MULPOZITION GROUP SQL:getGridResultToSumDataSql resultToSum dynamicSql: " + sumSql.toString()));
        }
        catch (Throwable throwable) {
            if (StringUtils.isEmpty(resultItemTempTableName)) {
                TempTablePool.getInstance((Context)ctx).releaseTable(resultItemTempTableName);
            }
            throw throwable;
        }
        if (StringUtils.isEmpty((String)resultItemTempTableName)) {
            TempTablePool.getInstance((Context)ctx).releaseTable(resultItemTempTableName);
        }
        return tempTableName;
    }

    public static String getAttendResultSumSql(Context ctx, Map<String, String> filterItems) throws Exception {
        boolean isContainPerson = false;
        String filterItem = filterItems.get("filterItems");
        if (!(StringUtils.isEmpty((String)filterItem) || filterItem.indexOf("name") == -1 && filterItem.indexOf("number") == -1)) {
            isContainPerson = true;
        }
        boolean validBeginDate = AtsDateUtils.isValidShortDate(filterItems.get("beginDate"));
        boolean validEndDate = AtsDateUtils.isValidShortDate(filterItems.get("endDate"));
        if (!validBeginDate || !validEndDate) {
            String res = MLUtile.getRes(AtsAttenceCycleResEnum.IllegalAttendDateFomat, ctx);
            throw new HRCommonException(HRCommonException.EXCEPTION_MSG, new Object[]{res});
        }
        BOSUuid.read((String)filterItems.get("attendPolicyId"));
        StringBuffer sumSql = new StringBuffer();
        sumSql.append(" SELECT resultItem.fatthrOrgUnitId as fhrorgunitid,resultItem.FAttAdminOrgUnitID,resultItem.FAdminOrgUnitId,resultItem.FProposerID ");
        if (isContainPerson) {
            sumSql.append(" ,person.FNumber as personNumber , person.FName" + MLUtile.getMlFlag(ctx) + " as personName ");
        }
        sumSql.append(" FROM T_HR_ATS_AttResultItem resultItem ");
        if (isContainPerson) {
            sumSql.append(" INNER JOIN T_BD_Person person on resultItem.FProposerID = person.FID ");
        }
        sumSql.append(" WHERE resultItem.FAttenceDate >= {ts '" + filterItems.get("beginDate") + "'}");
        sumSql.append(" AND resultItem.FAttenceDate <= {ts '" + filterItems.get("endDate") + "'} ");
        sumSql.append(AtsSumMulPozitionUtil.getAttendResultSumWhereSql(ctx, filterItems));
        String customFilter = filterItems.get("customFilter");
        if (!StringUtils.isEmpty((String)customFilter)) {
            sumSql.append(customFilter);
        }
        return sumSql.toString();
    }

    public static String getAttendResultSumWhereSql(Context ctx, Map<String, String> filterItems) {
        String hrOrgUnitId;
        String attenceStatus;
        StringBuffer WhereSql = new StringBuffer();
        String filterItem = filterItems.get("filterItems");
        if (!StringUtils.isEmpty((String)filterItem)) {
            if (filterItem.indexOf("name") != -1) {
                filterItem = filterItem.replaceAll("name", "fname" + MLUtile.getMlFlag(ctx));
            }
            if (filterItem.indexOf("number") != -1) {
                filterItem = filterItem.replaceAll("number", "fnumber");
            }
            WhereSql.append(" and " + filterItem);
        }
        if (!StringUtils.isEmpty((String)(attenceStatus = filterItems.get("attenceStatus")))) {
            if (attenceStatus.equals("0")) {
                WhereSql.append("  AND not exists ");
                WhereSql.append("  ( select 1 from T_HR_ATS_AttResultItem result ");
                WhereSql.append("     where resultItem.fatthrorgunitid = result.fatthrorgunitid");
                WhereSql.append("     and resultItem.fproposerid = result.fproposerid");
                WhereSql.append("     and resultItem.fattadminorgunitid = result.fattadminorgunitid ");
                WhereSql.append("     and result.FATTENCEDATE >= {ts '" + filterItems.get("beginDate") + "'} ");
                WhereSql.append("     and result.FATTENCEDATE <= {ts '" + filterItems.get("endDate") + "'} ");
                WhereSql.append("  ) ");
            } else if (attenceStatus.equals("1")) {
                WhereSql.append("  AND exists ");
                WhereSql.append("  ( select 1 from T_HR_ATS_AttResultItem result ");
                WhereSql.append("     where resultItem.fatthrorgunitid = result.fatthrorgunitid");
                WhereSql.append("     and resultItem.fproposerid = result.fproposerid");
                WhereSql.append("     and resultItem.fattadminorgunitid = result.fattadminorgunitid ");
                WhereSql.append("     and result.fattencestatus in ( 1,4) ");
                WhereSql.append("     and result.FATTENCEDATE >= {ts '" + filterItems.get("beginDate") + "'} ");
                WhereSql.append("     and result.FATTENCEDATE <= {ts '" + filterItems.get("endDate") + "'} ");
                WhereSql.append("  ) ");
            } else if (attenceStatus.equals("2")) {
                WhereSql.append("  AND not exists ");
                WhereSql.append("  ( select 1 from T_HR_ATS_AttResultItem result ");
                WhereSql.append("     where resultItem.fatthrorgunitid = result.fatthrorgunitid");
                WhereSql.append("     and resultItem.fproposerid = result.fproposerid");
                WhereSql.append("     and resultItem.fattadminorgunitid = result.fattadminorgunitid ");
                WhereSql.append("     and result.fattencestatus in (1,4) ");
                WhereSql.append("     and result.FATTENCEDATE >= {ts '" + filterItems.get("beginDate") + "'} ");
                WhereSql.append("     and result.FATTENCEDATE <= {ts '" + filterItems.get("endDate") + "'} ");
                WhereSql.append("  ) ");
                WhereSql.append("  AND exists ");
                WhereSql.append("  ( select 1 from T_HR_ATS_AttResultItem result ");
                WhereSql.append("     where resultItem.fatthrorgunitid = result.fatthrorgunitid");
                WhereSql.append("     and resultItem.fproposerid = result.fproposerid");
                WhereSql.append("     and resultItem.fattadminorgunitid = result.fattadminorgunitid ");
                WhereSql.append("     and result.FATTENCEDATE >= {ts '" + filterItems.get("beginDate") + "'} ");
                WhereSql.append("     and result.FATTENCEDATE <= {ts '" + filterItems.get("endDate") + "'} ");
                WhereSql.append("  ) ");
            } else if (attenceStatus.equals("10")) {
                WhereSql.append("  AND exists ");
                WhereSql.append("  ( select 1 from T_HR_ATS_AttendanceReSumMd atsum ");
                WhereSql.append("     inner join T_HR_ATS_AttendancePeriod attPeriod ");
                WhereSql.append("     on  atsum.FAttendancePeriodID = attPeriod.fid ");
                WhereSql.append("     where atsum.fhrorgunitid = resultItem.fatthrorgunitid ");
                WhereSql.append("     and atsum.fproposerid = resultItem.fproposerid");
                WhereSql.append("     and atsum.fattadminorgunitid = resultItem.fattadminorgunitid ");
                WhereSql.append("     and {ts '" + filterItems.get("beginDate") + "'} = attPeriod.Fstartdate");
                WhereSql.append("     and {ts '" + filterItems.get("endDate") + "'} = attPeriod.fendDate ");
                WhereSql.append("  ) ");
            } else if (attenceStatus.equals("15")) {
                WhereSql.append("  AND not exists ");
                WhereSql.append("  ( select 1 from T_HR_ATS_AttResultItemSum atsum ");
                WhereSql.append("     inner join T_HR_ATS_AttendancePeriod attPeriod ");
                WhereSql.append("     on  atsum.FAttendancePeriodID = attPeriod.fid ");
                WhereSql.append("     where atsum.fhrorgunitid = resultItem.fatthrorgunitid ");
                WhereSql.append("     and atsum.fproposerid = resultItem.fproposerid");
                WhereSql.append("     and atsum.fattadminorgunitid = resultItem.fattadminorgunitid ");
                WhereSql.append("     and {ts '" + filterItems.get("beginDate") + "'} = attPeriod.Fstartdate");
                WhereSql.append("     and {ts '" + filterItems.get("endDate") + "'} = attPeriod.fendDate ");
                WhereSql.append("  ) ");
            }
        }
        if (!StringUtils.isEmpty((String)(hrOrgUnitId = filterItems.get("hrOrgUnitId")))) {
            WhereSql.append(" and resultItem.fatthrorgunitid in(" + hrOrgUnitId + ") ");
        }
        String adminOrgTempTableName = filterItems.get("adminOrgTempTableName");
        String fileHisSql = AtsSumMulPozitionUtil.getOrgWhereSql(filterItems, adminOrgTempTableName);
        WhereSql.append(fileHisSql.toString());
        return WhereSql.toString();
    }

    private static String getOrgWhereSql(Map<String, String> filterItems, String adminOrgTempTableName) {
        String isDefaultManage = filterItems.get("isDefaultManage");
        StringBuffer fileHisSql = new StringBuffer();
        fileHisSql.append(" and exists ( SELECT 1 FROM T_HR_ATS_ATTENDANCEFILEHIS fileH where fileH.fproposerid = resultItem.fproposerid ");
        fileHisSql.append(" AND fileH.FLEFFDT >= {TS '" + filterItems.get("beginDate") + "'} ");
        fileHisSql.append(" AND fileH.FEFFDT <= {TS '" + filterItems.get("endDate") + "'} ");
        if (!StringUtils.isEmpty((String)filterItems.get("attendPolicyId"))) {
            fileHisSql.append(" AND fileH.FattencePolicyId = '" + filterItems.get("attendPolicyId") + "'");
        }
        if (!StringUtils.isEmpty((String)isDefaultManage) && (isDefaultManage.equalsIgnoreCase("adminOrgInner") || isDefaultManage.equalsIgnoreCase("adminOrgTeam"))) {
            fileHisSql.append(" AND fileH.FisDefaultManage = 1 ");
            fileHisSql.append(" and exists ( (select 1 from " + adminOrgTempTableName + " tmp where tmp.fid = resultItem.fadminorgunitid ) ");
            fileHisSql.append(" union all (select 1 from " + adminOrgTempTableName + " tmp where tmp.fid = resultItem.fattadminorgunitid ))");
        } else if (!StringUtils.isEmpty((String)isDefaultManage) && isDefaultManage.equalsIgnoreCase("adminOrgOuter")) {
            fileHisSql.append(" AND fileH.FisDefaultManage = 0 ");
        } else {
            fileHisSql.append(" and exists ( (select 1 from " + adminOrgTempTableName + " tmp where tmp.fid = resultItem.fadminorgunitid ) ");
            fileHisSql.append(" union all (select 1 from " + adminOrgTempTableName + " tmp where tmp.fid = resultItem.fattadminorgunitid ))");
        }
        fileHisSql.append(" )");
        return fileHisSql.toString();
    }

    public static Set<String> getSelectPersonKey(String personJson) {
        HashSet<String> personKeys = new HashSet<String>();
        try {
            JSONArray myJsonArray = new JSONArray(personJson);
            for (int i = 0; i < myJsonArray.length(); ++i) {
                JSONObject myjObject = myJsonArray.getJSONObject(i);
                String per = myjObject.getString("personId");
                String adminOrgUnitId = myjObject.getString("attadminOrgUnitId");
                String hrOrgUnitId = myjObject.getString("hrOrgUnitId");
                personKeys.add(hrOrgUnitId + per + adminOrgUnitId);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return personKeys;
    }

    public static String getAttenceResultTempTable(Context ctx, Map<String, String> filterItems, String sql) {
        String tempTableName = null;
        try {
            String table_key;
            String staticTable = "PA2AtdcResultToSumQuery";
            if (!StringUtils.isEmpty((String)filterItems.get("SUM_SALARY"))) {
                staticTable = filterItems.get("SUM_SALARY").equals("SUM_CALCULATE") ? "PA2AtdcSumCalculateQuery" : (filterItems.get("SUM_SALARY").equals("SUM_CALCULATE_DYNA") ? "PA2AtdcSumCalculateDynaQuery" : "PA2AtdcResultToSumSalaryQuery");
            } else if (!StringUtils.isEmpty((String)filterItems.get("isAll")) && filterItems.get("isAll").equals("all")) {
                staticTable = "PA2AtdcResultToSumExportTmp";
            }
            String sessionId = filterItems.get("session");
            if (StringUtils.isEmpty((String)sessionId)) {
                sessionId = "backGround";
            }
            if (ctx.get((Object)(table_key = staticTable + "_" + sessionId)) != null) {
                tempTableName = (String)ctx.get((Object)table_key);
            }
            if (filterItems.get("refresh") == null || "true".equals(filterItems.get("refresh"))) {
                if (tempTableName != null) {
                    TempTablePool.getInstance((Context)ctx).releaseTable(tempTableName);
                }
                tempTableName = TempTablePool.getInstance((Context)ctx).createTempTableName();
                String tempSql = "select * into " + tempTableName + " from (" + sql + ") T ";
                DbUtil.execute((Context)ctx, (String)tempSql.toString());
                AtsSumMulPozitionUtil.createSumIndex(ctx, tempTableName);
                ctx.put((Object)table_key, (Object)tempTableName);
            }
        }
        catch (Exception e) {
            AtsTempTableUtil.releaseTable(ctx, tempTableName);
            e.printStackTrace();
        }
        return tempTableName;
    }

    private static void createSumIndex(Context ctx, String tempTableName) {
        try {
            String dbType = ContextUtil.getDbType((Context)ctx);
            if (!StringUtils.isEmpty((String)dbType) && (dbType.equalsIgnoreCase("Oracle") || dbType.startsWith("Oracle"))) {
                DbUtil.execute((Context)ctx, (String)("CREATE  INDEX " + tempTableName + " ON " + tempTableName + " (fhrorgunitid,fproposerid,fattadminorgunitid) ;"));
            } else {
                DbUtil.execute((Context)ctx, (String)("CREATE  INDEX IX" + tempTableName + " ON " + tempTableName + " (fhrorgunitid,fproposerid,fattadminorgunitid) ;"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void setTmpTableToSession(Map<String, String> filterItems, HttpSession session) {
        String sql = filterItems.get("resultToSumSQL");
        if (session != null) {
            String dynamicSql = "SELECT DISTINCT PERSON.FID AS FPROPOSERID " + sql.substring(sql.indexOf("FROM"), sql.indexOf("GROUP BY")) + " order by PERSON.FID asc";
            session.setAttribute("atsResultSumDynamicSql", (Object)dynamicSql.toString());
        }
    }

    public static Map<String, Object> getExistedSumRecordInfo(Context ctx, Map<String, Object> params, List<LinkedHashMap<String, Object>> rowList, String keyTmpTableName) {
        Map filterItems = (Map)params.get("sumParams");
        ArrayList temExistList = new ArrayList();
        HashMap<String, Object> existAttendRecord = new HashMap<String, Object>();
        try {
            String sql = AtsSumMulPozitionUtil.getDynaAttendSumExistsSql((String)filterItems.get("beginDate"), (String)filterItems.get("endDate"), keyTmpTableName);
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
            while (rowSet.next()) {
                LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
                String hrOrgUnitId = rowSet.getString("fhrorgunitid");
                String personId = rowSet.getString("FPROPOSERID");
                String attadminOrgUnitId = rowSet.getString("FAttAdminORGUNITID");
                String adminOrgUnitId = rowSet.getString("FAdminORGUNITID");
                String positionId = rowSet.getString("fpositionID");
                String periodId = rowSet.getString("FSalaryPeriod");
                String salaryStatus = rowSet.getString("FSalaryStatus");
                String fid = rowSet.getString("fid");
                if (periodId != null) {
                    map.put("salaryPeriodId", periodId);
                }
                String key = hrOrgUnitId + personId + attadminOrgUnitId;
                map.put("hrOrgUnitId", hrOrgUnitId);
                map.put("personId", personId);
                map.put("attadminOrgUnitId", attadminOrgUnitId);
                map.put("adminOrgUnitId", adminOrgUnitId);
                map.put("fid", fid);
                map.put("fpositionID", positionId);
                map.put("salaryStatus", salaryStatus);
                map.put("key", key);
                existAttendRecord.put(key, salaryStatus);
                temExistList.add(map);
            }
            int size = rowList.size();
            int tempSize = temExistList.size();
            if (tempSize > 0) {
                block3: for (int i = 0; tempSize > i; ++i) {
                    LinkedHashMap tempexsitMap = (LinkedHashMap)temExistList.get(i);
                    String tempkey = (String)tempexsitMap.get("key");
                    for (int j = 0; size > j; ++j) {
                        Map exsitMap = rowList.get(j);
                        String key = (String)exsitMap.get("key");
                        if (!key.equals(tempkey)) continue;
                        tempexsitMap.put("orgName", exsitMap.get("orgName"));
                        tempexsitMap.put("hrOrgName", exsitMap.get("hrOrgName"));
                        tempexsitMap.put("personNumber", exsitMap.get("personNumber"));
                        tempexsitMap.put("personName", exsitMap.get("personName"));
                        rowList.set(j, tempexsitMap);
                        continue block3;
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return existAttendRecord;
    }

    public static String getDynaAttendSumExistsSql(String beginDate, String endDate, String keyTmpTableName) {
        StringBuffer sb = new StringBuffer();
        sb.append(" select resultSum.FPROPOSERID,resultSum.FATTADMINORGUNITID,resultSum.FAdminORGUNITID");
        sb.append(" ,resultSum.FSalaryStatus,resultSum.fpositionID");
        sb.append(",resultSum.fhrorgunitid,resultSum.FSalaryPeriod,resultSum.fid ");
        sb.append(" from T_HR_ATS_ATTRESULTITEMSUM resultSum ");
        sb.append(" INNER JOIN " + keyTmpTableName + " ATS_TMP ON ATS_TMP.fhrorgunitid = resultSum.fhrorgunitid AND ATS_TMP.fproposerid = resultSum.fproposerid AND ATS_TMP.fattadminorgunitid = resultSum.fattadminorgunitid ");
        sb.append(" inner JOIN T_HR_ATS_AttendancePeriod as period ON period.fid = resultSum.fattendanceperiodid  ");
        sb.append(" where period.FStartDate = {ts '" + beginDate + "'}");
        sb.append(" and period.FEndDate = {ts '" + endDate + "'}");
        return sb.toString();
    }

    public static IRowSet getAttendDetailDataGrid(Context ctx, String keyTmpTableName, String beginDate, String endDate, Map<String, String> filterItems) {
        IRowSet rowSet = null;
        StringBuffer sb = new StringBuffer();
        sb.append(" select RESULT.* from T_HR_ATS_AttResultItem RESULT   ");
        sb.append("  WHERE EXISTS (SELECT 1 FROM  " + keyTmpTableName + " ATS_TMP ");
        sb.append("  WHERE ATS_TMP.FHRORGUNITID = RESULT.FATTHRORGUNITID ");
        sb.append("  AND ATS_TMP.FPROPOSERID = RESULT.FPROPOSERID ");
        sb.append("  AND ATS_TMP.FATTADMINORGUNITID = RESULT.FATTADMINORGUNITID )");
        sb.append("  and RESULT.FATTENCEDATE >= {ts '" + beginDate + "' }");
        sb.append("  and RESULT.FATTENCEDATE <=  {ts '" + endDate + "' }");
        sb.append("  order by RESULT.FATTENCEDATE asc");
        try {
            rowSet = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
        }
        catch (Exception e) {
            logger.error((Object)("PAGE: RESULTTOSUM call getAttendDetailDataGrid error:" + sb.toString()));
            e.printStackTrace();
        }
        return rowSet;
    }

    public static void setGridAttendResultSumInfo(Context ctx, String keyTmpTableName, Map<String, Object> params, List<LinkedHashMap<String, Object>> rowList, Map<String, String> columnMap) {
        try {
            Map filterItems = (Map)params.get("sumParams");
            String beginDate = (String)filterItems.get("beginDate");
            String endDate = (String)filterItems.get("endDate");
            String attendPeriodId = (String)filterItems.get("attendPeriodId");
            String attendPeriodName = (String)filterItems.get("attendPeriodName");
            int sumSize = rowList.size();
            int decimalPlacesSystem = DecimalPlaceUtil.getDecimalPlaceSystem(ctx);
            IRowSet rowSet = AtsSumMulPozitionUtil.getAttendDetailDataGrid(ctx, keyTmpTableName, beginDate, endDate, filterItems);
            for (int i = 0; i < sumSize; ++i) {
                Map rowListMap = rowList.get(i);
                String sumKey = (String)rowListMap.get("key");
                rowListMap.put("beginDate", beginDate);
                rowListMap.put("endDate", endDate);
                rowListMap.put("attendPeriodId", attendPeriodId);
                rowListMap.put("attendPeriodName", attendPeriodName);
                while (rowSet.next()) {
                    String currentKey = rowSet.getString("fatthrorgunitid") + rowSet.getString("fproposerid") + rowSet.getString("fattadminorgunitid");
                    String resultId = rowSet.getString("FID");
                    try {
                        if (!currentKey.equals(sumKey)) continue;
                        String positionId = rowSet.getString("fpositionID");
                        String adminOrgUnitId = rowSet.getString("fadminOrgUnitId");
                        rowListMap.put("adminOrgUnitId", adminOrgUnitId);
                        rowListMap.put("fpositionID", positionId);
                        rowListMap.put("resultId", resultId);
                        AtsSumMulPozitionUtil.setAttendResultSumData(ctx, rowSet, rowListMap, columnMap, decimalPlacesSystem);
                    }
                    catch (Exception e) {
                        logger.error((Object)("PAGE: RESULTTOSUM call setGridAttendResultSumInfo error,gather/gather to salary prepare detail data error,sumKey:" + sumKey));
                        e.printStackTrace();
                    }
                }
                rowSet.beforeFirst();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void setAttendResultSumData(Context ctx, IRowSet rowSet, Map<String, Object> rowListMap, Map<String, String> columnMap, int decimalPlacesSystem) throws SQLException {
        for (String key : columnMap.keySet()) {
            String val = columnMap.get(key);
            if (val.equals("Int")) {
                int value = 0;
                if (rowListMap.get(key) != null) {
                    value = (Integer)rowListMap.get(key);
                }
                int tempVal = rowSet.getInt(key);
                rowListMap.put(key, value + tempVal);
                continue;
            }
            if (!val.equals("Float")) continue;
            float valueF = 0.0f;
            if (rowListMap.get(key) != null) {
                valueF = ((Float)rowListMap.get(key)).floatValue();
            }
            float tempValF = rowSet.getFloat(key);
            float valueRound = BigDecimal.valueOf(valueF + tempValF).setScale(decimalPlacesSystem, RoundingMode.HALF_UP).floatValue();
            rowListMap.put(key, Float.valueOf(valueRound));
        }
    }

    public static String getSumKeyTmpTable(Context ctx, List<LinkedHashMap<String, Object>> rowList) {
        ArrayList<Object[]> perAndOrgs = new ArrayList<Object[]>();
        for (LinkedHashMap<String, Object> mapList : rowList) {
            Object[] param = new Object[]{(String)mapList.get("hrOrgUnitId"), (String)mapList.get("personId"), (String)mapList.get("attadminOrgUnitId")};
            perAndOrgs.add(param);
        }
        String tempTableName = null;
        if (null != perAndOrgs && perAndOrgs.size() > 0) {
            try {
                tempTableName = TempTablePool.getInstance((Context)ctx).createTempTable(" CREATE TABLE T_HR_ATS_RESULTSUM_TEMP (fhrorgunitid VARCHAR(255),fproposerid VARCHAR(255),fattadminorgunitid VARCHAR(255))");
                String tempSql = "insert into " + tempTableName + " values(?,?,?)";
                DbUtil.executeBatch((Context)ctx, (String)tempSql.toString(), perAndOrgs);
                String dbType = ContextUtil.getDbType((Context)ctx);
                if (!StringUtils.isEmpty((String)dbType) && (dbType.equalsIgnoreCase("Oracle") || dbType.startsWith("Oracle"))) {
                    String tmpIndexSql = "CREATE  INDEX " + tempTableName + " ON " + tempTableName + " (fhrorgunitid,fproposerid,fattadminorgunitid ASC) ;";
                    DbUtil.execute((Context)ctx, (String)tmpIndexSql.toString());
                } else {
                    String tmpIndexSql = "CREATE  INDEX IX" + tempTableName + " ON " + tempTableName + " (fhrorgunitid,fproposerid,fattadminorgunitid ASC) ;";
                    DbUtil.execute((Context)ctx, (String)tmpIndexSql.toString());
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return tempTableName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList<LinkedHashMap<String, Object>> getSelectRecordUnLockPersonList(Context ctx, Map<String, Object> sumParams) {
        Map filterItems = (Map)sumParams.get("sumParams");
        String fids = (String)filterItems.get("fids");
        String querySql = "SELECT FPROPOSERID,FHRORGUNITID,FADMINORGUNITID,FATTADMINORGUNITID FROM T_HR_ATS_ATTRESULTITEMSUM WHERE FID IN (" + fids + ")";
        String tempTableName = null;
        ArrayList<LinkedHashMap<String, Object>> dataList = new ArrayList<LinkedHashMap<String, Object>>();
        HashMap<String, Object> lockMessageMap = new HashMap<String, Object>();
        try {
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)querySql);
            ArrayList<Object[]> perAndOrgs = new ArrayList<Object[]>();
            HashSet<String> personIds = new HashSet<String>();
            HashSet<String> hr_person_OrgList = new HashSet<String>();
            while (rowSet.next()) {
                String hrOrgUnitId = rowSet.getString("FHRORGUNITID");
                String personId = rowSet.getString("FPROPOSERID");
                String adminOrgUnit = null;
                try {
                    adminOrgUnit = rowSet.getString("FADMINORGUNITID");
                }
                catch (Exception exception) {
                    // empty catch block
                }
                String attadminOrgUnit = rowSet.getString("FATTADMINORGUNITID");
                if (null == adminOrgUnit) {
                    adminOrgUnit = attadminOrgUnit;
                }
                personIds.add(personId);
                hr_person_OrgList.add(hrOrgUnitId + "_####_" + personId + "_####_" + adminOrgUnit + "_####_" + attadminOrgUnit);
                Object[] param = new Object[]{hrOrgUnitId, personId, attadminOrgUnit};
                perAndOrgs.add(param);
            }
            tempTableName = AtsResultToSumHelper.createResultToSumTmpTable(ctx, perAndOrgs);
            HashMap<String, Object> lockMessage = new HashMap<String, Object>();
            List<String> personList = AtsResultToSumHelper.getSalaryLockStatePersonCol(ctx, filterItems, personIds, lockMessage, tempTableName);
            dataList = AtsResultToSumHelper.setPingPersonArrayList(ctx, personList, hr_person_OrgList, lockMessageMap, lockMessage, (String)filterItems.get("sumType"));
            TempTablePool.getInstance((Context)ctx).releaseTable(tempTableName);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            TempTablePool.getInstance((Context)ctx).releaseTable(tempTableName);
        }
        sumParams.put("LOCK_MAP", lockMessageMap);
        return dataList;
    }
}

