/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.ats.syn;

import com.kingdee.bos.BOSException;
import com.kingdee.shr.base.syssetting.util.SHRCheck;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.input.SAXBuilder;

public class AnalyzePunchCardSrcCfg {
    public static final String dbconnections = "dbconnections";
    public static final String dbconnection = "dbconnection";
    public static final String openapis = "openapis";
    public static final String openapi = "openapi";
    public static final String webservices = "webservices";
    public static final String webservice = "webservice";
    public static final String applicationForPunchCard = "punchCard";
    public static final String applicationForPunchCardNew = "punchCardNew";
    public static final String applicationForCloudAttendPosition = "cloudAttendPosition";

    public static Map<String, List<Map<String, String>>> getPunchCardSrc() throws BOSException {
        HashMap<String, List<Map<String, String>>> srcMap = new HashMap<String, List<Map<String, String>>>();
        try {
            SAXBuilder builder = new SAXBuilder();
            File file = new File(SHRCheck.checkFilePath((String)(System.getProperty("EAS_HOME") + "/server/properties/hr_ats_punchCardSrcCfg.xml")));
            Document doc = builder.build(file);
            Element root = doc.getRootElement();
            List rowList = root.getChildren();
            for (Element row : rowList) {
                if (row.getName().toLowerCase() == dbconnections) {
                    srcMap.put(dbconnections, AnalyzePunchCardSrcCfg.getDbconnection(row));
                    continue;
                }
                if (row.getName().toLowerCase() == openapis) {
                    List<Map<String, String>> openapiList = AnalyzePunchCardSrcCfg.getOpenapiAll(row, applicationForPunchCard);
                    if (openapiList.size() > 0) {
                        srcMap.put(openapis, openapiList);
                        continue;
                    }
                    srcMap.put(openapis, AnalyzePunchCardSrcCfg.getOpenapiAll(row, applicationForPunchCardNew));
                    continue;
                }
                if (row.getName().toLowerCase() != webservices) continue;
                srcMap.put(webservices, AnalyzePunchCardSrcCfg.getWebService(row));
            }
        }
        catch (Exception e) {
            throw new BOSException(e.getMessage());
        }
        return srcMap;
    }

    public static Map<String, List<Map<String, String>>> getCloudAttendPositionSrc() throws BOSException {
        HashMap<String, List<Map<String, String>>> srcMap = new HashMap<String, List<Map<String, String>>>();
        try {
            SAXBuilder builder = new SAXBuilder();
            File file = new File(SHRCheck.checkFilePath((String)(System.getProperty("EAS_HOME") + "/server/properties/hr_ats_punchCardSrcCfg.xml")));
            Document doc = builder.build(file);
            Element root = doc.getRootElement();
            List rowList = root.getChildren();
            for (Element row : rowList) {
                if (row.getName().toLowerCase() != openapis) continue;
                srcMap.put(openapis, AnalyzePunchCardSrcCfg.getOpenapi(row, applicationForCloudAttendPosition));
            }
        }
        catch (Exception e) {
            throw new BOSException(e.getMessage());
        }
        return srcMap;
    }

    private static List<Map<String, String>> getWebService(Element element) {
        List rowList = element.getChildren(webservice);
        ArrayList<Map<String, String>> list = new ArrayList<Map<String, String>>();
        for (Element dbc : rowList) {
            Element params = dbc.getChild("params");
            List paramsList = params.getChildren("param");
            HashMap<String, String> row = new HashMap<String, String>();
            for (Element param : paramsList) {
                row.put(param.getChildText("name"), param.getChildText("value"));
            }
            if ("0".equals(row.get("enablestate"))) continue;
            list.add(row);
        }
        return list;
    }

    private static List<Map<String, String>> getDbconnection(Element element) {
        List rowList = element.getChildren(dbconnection);
        ArrayList<Map<String, String>> list = new ArrayList<Map<String, String>>();
        for (Element dbc : rowList) {
            Element params = dbc.getChild("params");
            List paramsList = params.getChildren("param");
            HashMap<String, String> row = new HashMap<String, String>();
            for (Element param : paramsList) {
                row.put(param.getChildText("name"), param.getChildText("value"));
            }
            if ("0".equals(row.get("enablestate"))) continue;
            list.add(row);
        }
        return list;
    }

    private static List<Map<String, String>> getOpenapi(Element element, String applicationFor) {
        List rowList = element.getChildren(openapi);
        ArrayList<Map<String, String>> list = new ArrayList<Map<String, String>>();
        for (Element opi : rowList) {
            String myApplicationFor = opi.getAttributeValue("applicationFor");
            if (!applicationFor.equals(myApplicationFor)) continue;
            Element params = opi.getChild("params");
            List paramsList = params.getChildren("param");
            HashMap<String, String> row = new HashMap<String, String>();
            row.put("applicationFor", applicationFor);
            for (Element param : paramsList) {
                row.put(param.getChildText("name"), param.getChildText("value"));
            }
            if ("0".equals(row.get("enablestate"))) continue;
            list.add(row);
        }
        return list;
    }

    private static List<Map<String, String>> getOpenapiAll(Element element, String applicationFor) {
        List rowList = element.getChildren(openapi);
        ArrayList<Map<String, String>> list = new ArrayList<Map<String, String>>();
        for (Element opi : rowList) {
            String myApplicationFor = opi.getAttributeValue("applicationFor");
            if (!applicationFor.equals(myApplicationFor)) continue;
            Element params = opi.getChild("params");
            List paramsList = params.getChildren("param");
            HashMap<String, String> row = new HashMap<String, String>();
            row.put("applicationFor", applicationFor);
            for (Element param : paramsList) {
                row.put(param.getChildText("name"), param.getChildText("value"));
            }
            list.add(row);
        }
        return list;
    }

    public static Map<String, List<Map<String, String>>> getPunchCardSrcAll() throws BOSException {
        HashMap<String, List<Map<String, String>>> srcMap = new HashMap<String, List<Map<String, String>>>();
        try {
            SAXBuilder builder = new SAXBuilder();
            File file = new File(SHRCheck.checkFilePath((String)(System.getProperty("EAS_HOME") + "/server/properties/hr_ats_punchCardSrcCfg.xml")));
            Document doc = builder.build(file);
            Element root = doc.getRootElement();
            List rowList = root.getChildren();
            for (Element row : rowList) {
                if (row.getName().toLowerCase() == dbconnections) {
                    srcMap.put(dbconnections, AnalyzePunchCardSrcCfg.getDbconnection(row));
                    continue;
                }
                if (row.getName().toLowerCase() == openapis) {
                    srcMap.put(openapis, AnalyzePunchCardSrcCfg.getOpenapiAll(row, applicationForPunchCardNew));
                    continue;
                }
                if (row.getName().toLowerCase() != webservices) continue;
                srcMap.put(webservices, AnalyzePunchCardSrcCfg.getWebService(row));
            }
        }
        catch (Exception e) {
            throw new BOSException(e.getMessage());
        }
        return srcMap;
    }
}

