/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.ats.syn.punchcard;

import com.alibaba.fastjson.JSON;
import com.kingdee.bos.BOSException;
import com.kingdee.eas.hr.ats.AtsBillResEnum;
import com.kingdee.eas.hr.ats.AtsCludHubBizException;
import com.kingdee.eas.hr.ats.AtsCludHubResEnum;
import com.kingdee.eas.hr.ats.AtsOtherBizException;
import com.kingdee.eas.hr.ats.BizDataOAuthFactory;
import com.kingdee.eas.hr.ats.BizDataOAuthInfo;
import com.kingdee.eas.hr.ats.ResourceEnum;
import com.kingdee.eas.hr.ats.syn.httpclient.MySSLProtocolSocketFactory;
import com.kingdee.eas.hr.ats.syn.punchcard.AbstractHttpProcessor;
import com.kingdee.eas.hr.ats.util.common.AtsCollectionUtile;
import com.kingdee.eas.hr.ats.util.common.AtsLog;
import com.kingdee.eas.hr.ats.util.common.MLUtile;
import com.kingdee.eas.hr.ats.util.common.ParamUtile;
import com.kingdee.portal.biz.common.exception.BizException;
import java.util.ArrayList;
import java.util.Map;
import kdweibo4j.http.AccessToken;
import kdweibo4j.http.OAuth;
import kdweibo4j.http.OAuthToken;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.protocol.Protocol;
import org.apache.commons.httpclient.protocol.ProtocolSocketFactory;
import org.apache.commons.lang.StringUtils;

public class PunchcardHttpExecutor
extends AbstractHttpProcessor {
    private BizDataOAuthInfo bizDataOAuthInfo;
    private com.alibaba.fastjson.JSONObject accessToken;
    private String eid;
    private String baseUrl;
    private String secret;
    private String oauth1SavedKey = "kdweibo";
    private String authenLever = "resGroupSecret";
    private Map<String, Object> params;

    @Override
    public void processRequest() throws BizException {
        this.initConfig();
        super.processRequest();
    }

    private void initConfig() throws BizException {
        if (this.getHttpClient() != null) {
            return;
        }
        if (StringUtils.isBlank((String)this.baseUrl)) {
            this.add(MLUtile.getRes(AtsCludHubResEnum.item17, this.ctx));
            PunchcardHttpExecutor.getLogger().error((Object)"can not find clound url");
            return;
        }
        PunchcardHttpExecutor.setLogger(AtsLog.getPunchcardCloudLog());
        Map<String, String> configMap = null;
        try {
            configMap = ParamUtile.getParamValFuzzy(this.ctx, new String[]{"TIMEOUNT_HTTP_", "punnchcard_cloud_"});
        }
        catch (BOSException e) {
            this.add(MLUtile.getRes((ResourceEnum)AtsCludHubResEnum.item9, this.ctx, e.getMessage()));
            PunchcardHttpExecutor.getLogger().error((Object)("fetch cloud config error,use sys default config,error detail:" + (Object)((Object)e)));
        }
        if (configMap == null) {
            return;
        }
        try {
            this.setMaxConnectCount(Integer.valueOf(configMap.get("punnchcard_cloud_maxConnectCount")));
            this.setConnectCount(Integer.valueOf(configMap.get("TIMEOUNT_HTTP_CONNECT")));
            this.setSocketTimeout(Integer.valueOf(configMap.get("TIMEOUNT_HTTP_SO")));
        }
        catch (Exception e) {
            this.add(MLUtile.getRes((ResourceEnum)AtsBillResEnum.ConfigValueErrorDetail, this.ctx, e.getMessage()));
            PunchcardHttpExecutor.getLogger().error((Object)("config number error,error detail:" + e.getMessage()), (Throwable)e);
        }
        if (StringUtils.isNotBlank((String)configMap.get("punnchcard_cloud_oauth1SavedKey"))) {
            this.setOauth1SavedKey(configMap.get("punnchcard_cloud_oauth1SavedKey"));
        }
        this.setEid(configMap.get("punnchcard_cloud_eid"));
        this.setSecret(configMap.get("punnchcard_cloud_oauth2_secret"));
    }

    @Override
    public void initMethod() {
        if (this.getUrl() != null && this.getUrl().contains("clockInlist")) {
            this.setGetMethod(false);
        }
        super.initMethod();
        PunchcardHttpExecutor.getLogger().info((Object)("PunchcardHttpExecutor params:" + this.params));
        this.addParameters(this.params);
    }

    @Override
    protected void initAuthentication() throws BizException {
        super.initAuthentication();
        if (this.getUrl() != null && this.getUrl().contains("clockInlist")) {
            this.addParameter("accessToken", this.fetchAccessToken().getString("accessToken"));
            this.addParameter("eid", this.eid);
            return;
        }
        if (StringUtils.isBlank((String)this.oauth1SavedKey)) {
            throw new BizException("oauth1SavedKey is null");
        }
        if (this.bizDataOAuthInfo == null) {
            try {
                this.bizDataOAuthInfo = BizDataOAuthFactory.getLocalInstance(this.ctx).getBizDataOAuthInfo(" where key='" + this.oauth1SavedKey + "' ");
            }
            catch (Exception e) {
                throw new BizException((Throwable)((Object)new AtsCludHubBizException(AtsCludHubBizException.FETCHAUTHINFOERROR, e, new Object[]{e.getMessage()})));
            }
        }
        AccessToken accessToken = new AccessToken(this.bizDataOAuthInfo.getAccesstoken(), this.bizDataOAuthInfo.getAccesstokensecret());
        OAuth myouth = new OAuth(this.bizDataOAuthInfo.getConsumerkey(), this.bizDataOAuthInfo.getConsumersecret());
        String outhHead = myouth.generateAuthorizationHeader("GET", this.getUrl() + this.getGetMethoParams().toString(), null, (OAuthToken)accessToken);
        this.getMethod().setRequestHeader("Authorization", outhHead);
    }

    protected com.alibaba.fastjson.JSONObject fetchAccessToken() throws BizException {
        if (StringUtils.isBlank((String)this.eid)) {
            throw new BizException("eid is null");
        }
        if (StringUtils.isBlank((String)this.secret)) {
            throw new BizException("" + (Object)((Object)new AtsCludHubBizException(AtsCludHubBizException.GETACCESSTOKENFAILED)));
        }
        if (this.baseUrl.trim().startsWith("https")) {
            Protocol.registerProtocol((String)"https", (Protocol)new Protocol("https", (ProtocolSocketFactory)new MySSLProtocolSocketFactory(), 443));
        } else {
            Protocol.unregisterProtocol((String)"https");
        }
        this.resteAccessToken();
        return this.accessToken;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void resteAccessToken() throws BizException {
        int fethchTime = 3;
        String response = null;
        long curGenerateTime = 0L;
        AtsCludHubBizException tokenExceptioin = null;
        HttpClient client = this.getHttpClient();
        client.getHttpConnectionManager().getParams().setSoTimeout(this.getSocketTimeout());
        client.getHttpConnectionManager().getParams().setConnectionTimeout(this.getConnectTimeout());
        while (fethchTime > 0) {
            curGenerateTime = System.currentTimeMillis();
            StringBuffer url = new StringBuffer(this.baseUrl).append("/gateway/oauth2/token/");
            if (this.accessToken != null && this.accessToken.containsKey((Object)"generateTime") && curGenerateTime - this.accessToken.getLong("generateTime") + 100000L < this.accessToken.getLongValue("expireIn") * 1000L) {
                url.append("refreshToken?refreshToken=").append(this.accessToken.getString("refreshToken"));
            } else {
                url.append("getAccessToken?secret=").append(this.secret);
            }
            url.append("&eid=").append(this.eid);
            url.append("&timestamp=").append(curGenerateTime);
            url.append("&scope=").append(this.authenLever);
            PunchcardHttpExecutor.getLogger().info((Object)(" fetch accessToken param:" + url.toString() + ";cur accessToken:" + this.accessToken + ";"));
            GetMethod method = new GetMethod(url.toString());
            try {
                client.executeMethod((HttpMethod)method);
                response = method.getResponseBodyAsString();
                PunchcardHttpExecutor.getLogger().info((Object)("accssToken response\uff1a" + response + ";"));
                this.accessToken = JSON.parseObject((String)response).getJSONObject("data");
                if (!JSON.parseObject((String)response).getBooleanValue("success")) {
                    String errorMsg = JSON.parseObject((String)response).getString("error");
                    throw new BizException((Throwable)((Object)new AtsCludHubBizException(AtsCludHubBizException.WHILEFECTHTOKEN, new Object[]{errorMsg})));
                }
                break;
            }
            catch (Exception e) {
                tokenExceptioin = new AtsCludHubBizException(AtsCludHubBizException.GETACCESSTOKENFAILED);
                PunchcardHttpExecutor.getLogger().error((Object)(" fetch accessToken faile \uff0ccur url:" + url + ";exception msg :" + e.getMessage() + ";"), (Throwable)e);
                --fethchTime;
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e1) {
                    PunchcardHttpExecutor.getLogger().error((Object)("sleep failure when get resteAccessToken" + e.getMessage()), (Throwable)e);
                }
            }
            finally {
                method.releaseConnection();
            }
        }
        if (this.accessToken == null) {
            response = response == null ? "accessToken response is null" : response;
            throw new BizException("accssToken response :" + (Object)((Object)new AtsCludHubBizException(AtsCludHubBizException.GETACCESSTOKENFAILED)));
        }
        this.accessToken.put("generateTime", (Object)curGenerateTime);
    }

    @Override
    public boolean validateResult() throws BizException {
        if (this.getUrl().contains("newlist")) {
            return this.validateNewListInterfaceResult();
        }
        com.alibaba.fastjson.JSONObject rootJSONObject = JSON.parseObject((String)AtsCollectionUtile.join(this.getResponseData()));
        if (this.getUrl().contains("clockInlist")) {
            return this.validateClockInListInterfaceResult(rootJSONObject);
        }
        if (!rootJSONObject.containsKey((Object)"data") || "null".equalsIgnoreCase(rootJSONObject.getString("data"))) {
            throw new BizException((Throwable)((Object)new AtsCludHubBizException(AtsCludHubBizException.NOTINCLUDEDATA)));
        }
        return true;
    }

    @Override
    public void printResponse() {
        try {
            if (this.getUrl().contains("newlist")) {
                if (this.getResponseData().size() > 2) {
                    ArrayList<String> response = new ArrayList<String>(this.getResponseData());
                    response.remove(0);
                    response.remove(response.size() - 1);
                    AtsLog.getPunchcardCloudLog().error((Object)("\r\n" + JSONArray.fromObject(response).join("\r\n")));
                    return;
                }
            } else {
                com.alibaba.fastjson.JSONArray response = JSON.parseObject((String)AtsCollectionUtile.join(this.getResponseData())).getJSONArray("data");
                if (response.size() > 0) {
                    AtsLog.getPunchcardCloudLog().error((Object)("\r\n" + AtsCollectionUtile.join(response, "\r\n")));
                    return;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        AtsLog.getPunchcardCloudLog().error(this.getResponseData());
    }

    private boolean validateNewListInterfaceResult() throws BizException {
        if (this.getResponseData().size() < 2) {
            throw new BizException((Throwable)((Object)new AtsCludHubBizException(AtsCludHubBizException.VERIFYNOPASSBYDATAERROR)));
        }
        String count_str = this.getResponseData().remove(0);
        String lastCord = this.getResponseData().remove(this.getResponseData().size() - 1);
        int count = Integer.valueOf(count_str.split("=")[1]);
        if (count != this.getResponseData().size()) {
            throw new BizException((Throwable)((Object)new AtsCludHubBizException(AtsCludHubBizException.VERIFYNOPASSBYTOTALCOUNT)));
        }
        if (!count_str.equals(lastCord)) {
            throw new BizException((Throwable)((Object)new AtsCludHubBizException(AtsCludHubBizException.VERIFYNOPASSBYBEFANDAFTERDATA)));
        }
        return true;
    }

    private boolean validateClockInListInterfaceResult(com.alibaba.fastjson.JSONObject rootJSONObject) throws BizException {
        if (!rootJSONObject.getBoolean("success").booleanValue()) {
            String errorMsg = this.getCloudErrorMsg();
            throw new BizException((Throwable)((Object)new AtsOtherBizException(AtsOtherBizException.RETURNFALSE)));
        }
        return true;
    }

    public JSONArray getResult() throws BizException {
        if (this.getUrl().contains("newlist")) {
            return JSONArray.fromObject(this.getResponseData());
        }
        JSONObject rootJSONObject = JSONObject.fromObject((Object)AtsCollectionUtile.join(this.getResponseData()));
        String errorMsg = this.getCloudErrorMsg();
        if (StringUtils.isNotBlank((String)errorMsg)) {
            this.add(MLUtile.getRes((ResourceEnum)AtsCludHubResEnum.item11, this.ctx, errorMsg, this.getParams()));
        }
        try {
            return rootJSONObject.getJSONArray("data");
        }
        catch (Exception e) {
            throw new BizException((Throwable)((Object)new AtsCludHubBizException(AtsCludHubBizException.CLOUDDATAERROR, e, new Object[]{rootJSONObject})));
        }
    }

    public String getCloudErrorMsg() {
        JSONObject rootJSONObject = JSONObject.fromObject((Object)AtsCollectionUtile.join(this.getResponseData()));
        for (String errorField : new String[]{"errorMsg", "error"}) {
            if (!rootJSONObject.containsKey((Object)errorField) || !StringUtils.isNotBlank((String)rootJSONObject.getString(errorField))) continue;
            return rootJSONObject.getString(errorField);
        }
        return null;
    }

    public BizDataOAuthInfo getBizDataOAuthInfo() {
        return this.bizDataOAuthInfo;
    }

    public void setBizDataOAuthInfo(BizDataOAuthInfo bizDataOAuthInfo) {
        this.bizDataOAuthInfo = bizDataOAuthInfo;
    }

    public Map<String, Object> getParams() {
        return this.params;
    }

    public void setParams(Map<String, Object> params) {
        this.params = params;
    }

    public com.alibaba.fastjson.JSONObject getAccessToken() {
        return this.accessToken;
    }

    public void setAccessToken(com.alibaba.fastjson.JSONObject accessToken) {
        this.accessToken = accessToken;
    }

    public String getEid() {
        return this.eid;
    }

    public void setEid(String eid) {
        this.eid = eid;
    }

    public String getSecret() {
        return this.secret;
    }

    public void setSecret(String secret) {
        this.secret = secret;
    }

    public String getAuthenLever() {
        return this.authenLever;
    }

    public void setAuthenLever(String authenLever) {
        this.authenLever = authenLever;
    }

    public String getOauth1SavedKey() {
        return this.oauth1SavedKey;
    }

    public void setOauth1SavedKey(String oauth1SavedKey) {
        this.oauth1SavedKey = oauth1SavedKey;
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public void setBaseUrl(String baseUrl) {
        this.baseUrl = baseUrl;
    }
}

