/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.ats.syn.punchcard;

import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.eas.base.job.JobStateEnum;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.ats.AtsAttenceResEnum;
import com.kingdee.eas.hr.ats.AtsBillResEnum;
import com.kingdee.eas.hr.ats.AtsCludHubResEnum;
import com.kingdee.eas.hr.ats.AtsCommonResEnum;
import com.kingdee.eas.hr.ats.AtsNounCommonResEnum;
import com.kingdee.eas.hr.ats.AtsPunchCardResEnum;
import com.kingdee.eas.hr.ats.AttendanceLogEntryFactory;
import com.kingdee.eas.hr.ats.AttendanceLogEntryInfo;
import com.kingdee.eas.hr.ats.AttendanceLogFactory;
import com.kingdee.eas.hr.ats.AttendanceLogInfo;
import com.kingdee.eas.hr.ats.CloudHubSignServiceConfigCollection;
import com.kingdee.eas.hr.ats.CloudHubSignServiceConfigFactory;
import com.kingdee.eas.hr.ats.ResourceEnum;
import com.kingdee.eas.hr.ats.atsTimer.AtsTimeTask;
import com.kingdee.eas.hr.ats.atsTimer.AtsTimer;
import com.kingdee.eas.hr.ats.syn.punchcard.PunchCardSynProcessor;
import com.kingdee.eas.hr.ats.syn.punchcard.PunchcardHttpExecutor;
import com.kingdee.eas.hr.ats.syn.punchcard.PunchcardSynValidator;
import com.kingdee.eas.hr.ats.util.AtsDateUtils;
import com.kingdee.eas.hr.ats.util.common.AtsCollectionUtile;
import com.kingdee.eas.hr.ats.util.common.AtsCommonUtile;
import com.kingdee.eas.hr.ats.util.common.AtsLog;
import com.kingdee.eas.hr.ats.util.common.BackJob.BackJobUtile;
import com.kingdee.eas.hr.ats.util.common.ConfigAts;
import com.kingdee.eas.hr.ats.util.common.MLUtile;
import com.kingdee.eas.hr.ats.util.common.ParamUtile;
import com.kingdee.eas.hr.ats.vo.common.AtsErrorMsg;
import com.kingdee.eas.hr.ats.vo.common.RangeDate;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import java.util.TimerTask;
import org.apache.commons.lang.StringUtils;

public class SynPunchcardManager
extends AtsErrorMsg {
    private static final String SYN_BASE_URL = "https://kingdee.yunzhijia.com";
    private static final String SYN_INTERFACE_URL = "/snsapi/attendance/list.json";
    private PunchCardSynProcessor punchCardSynProcessor = new PunchCardSynProcessor();
    private PunchcardSynValidator punchcardSynValidator;
    private AttendanceLogInfo attendanceLog;
    private boolean runningByBackJob;
    private boolean needUpdateLastSynTime = true;
    private String personIds;

    public static SynPunchcardManager getBackJobInstance() {
        SynPunchcardManager synPunchcardManager = new SynPunchcardManager();
        synPunchcardManager.setRunningByBackJob(true);
        return synPunchcardManager;
    }

    public static SynPunchcardManager getInstance(String personIds) {
        SynPunchcardManager synPunchcardManager = new SynPunchcardManager();
        synPunchcardManager.setPersonIds(personIds);
        synPunchcardManager.getPunchCardSynProcessor().setFetchDataDayByDay(false);
        return synPunchcardManager;
    }

    public String synchronize() {
        String startMsg = "";
        ConfigAts.updateConfigAtsFromParam(this.ctx);
        ConfigAts.enableKSQLOutput();
        JSONObject jobParam = BackJobUtile.getJobParam(this.ctx);
        if (this.runningByBackJob && BackJobUtile.hasRunningJob(this.ctx, "com.kingdee.eas.hr.ats.app.AtsAffairBaseFacade", "transmitPunchCardRecordByWebService")) {
            startMsg = MLUtile.getRes(AtsNounCommonResEnum.ExistsRuningMission, this.ctx);
            jobParam.put("exception", (Object)startMsg);
            BackJobUtile.abortJob(this.ctx, jobParam);
        }
        if (!this.runningByBackJob) {
            try {
                String jobInstId = BackJobUtile.inserRunningJob(this.ctx, MLUtile.getRes(AtsCludHubResEnum.item21, this.ctx), "com.kingdee.eas.hr.ats.app.AtsAffairBaseFacade", "transmitPunchCardRecordByWebService");
                this.ctx.put((Object)"jobInstId", (Object)jobInstId);
                jobParam.put("jobInstId", (Object)jobInstId);
            }
            catch (Exception e) {
                startMsg = e.getMessage();
            }
        }
        if (StringUtils.isNotBlank((String)startMsg)) {
            AtsLog.getPunchcardCloudLog().error((Object)startMsg);
            return startMsg;
        }
        return this.doSynchronize(jobParam);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String doSynchronize(JSONObject jobParam) {
        StringBuffer synResult = new StringBuffer();
        try {
            this.init();
            synResult.append(this.punchCardSynProcessor.synchronize());
            if (!this.punchCardSynProcessor.get().contains(MLUtile.getRes(AtsAttenceResEnum.RushHours, this.ctx)) && !this.punchcardSynValidator.validate()) {
                synResult.append("\r\n").append(this.punchcardSynValidator.get().replaceAll("</br>", "\r\n"));
            }
            this.updateBizSynAssistInfo();
            ParamUtile.updateParamItem(this.ctx, "punnchcard_cloud_workDateTo", "");
            jobParam.put("state", (Object)JobStateEnum.COMPLETE);
        }
        catch (Exception e) {
            jobParam.put("state", (Object)JobStateEnum.FAILED);
            synResult.append(AtsCommonUtile.getExciptionInfo(e));
        }
        finally {
            String errorMsg;
            if (synResult.length() == 0) {
                synResult.append(MLUtile.getRes(AtsCommonResEnum.SyncSuccess, this.ctx));
            }
            if (this.punchCardSynProcessor.getGlobalException() != null) {
                jobParam.put("state", (Object)JobStateEnum.FAILED);
            }
            if (StringUtils.isNotBlank((String)(errorMsg = this.punchCardSynProcessor.get()))) {
                synResult.append("\r\n\r\n ").append(MLUtile.getRes(AtsCommonResEnum.SycException, this.ctx)).append(":\r\n").append(errorMsg);
            }
            StringBuffer backJobMsg = new StringBuffer(this.get()).append("\r\n").append(synResult);
            if (this.punchCardSynProcessor.getHttpExecutor() != null) {
                backJobMsg.append("\r\n\r\n").append(this.punchCardSynProcessor.getHttpExecutor().get());
            }
            jobParam.put("exception", (Object)backJobMsg.toString().replaceAll("</br>", "\r\n"));
            this.updateAttendanceLog(backJobMsg.toString());
            AtsLog.getPunchcardCloudLog().error(jobParam.get((Object)"exception"));
            jobParam.put("delayTime", (Object)3000);
            BackJobUtile.updateJobInfo(this.ctx, jobParam);
            ConfigAts.enableKSQLOutput();
        }
        return synResult.toString();
    }

    private void updateBizSynAssistInfo() {
        if (this.needUpdateLastSynTime && this.runningByBackJob) {
            try {
                DbUtil.execute((Context)this.ctx, (String)"update T_HR_ATS_BizDataSynchAssist set FLastsynchtime = ? where fopenapiurlkey= ? ", (Object[])new Object[]{this.punchCardSynProcessor.getTaskRunningTime(), this.punchCardSynProcessor.getOpenapikey()});
                ParamUtile.updateParamItem(this.ctx, "punnchcard_cloud_lastsynchtime", AtsCommonUtile.formateTime(this.punchCardSynProcessor.getTaskRunningTime()));
            }
            catch (Exception e) {
                this.add(MLUtile.getRes((ResourceEnum)AtsBillResEnum.SyncDoneButErrorTimeReason, this.ctx, e.getMessage()));
                AtsLog.getLog().error((Object)("update last updateTime error,detail;" + e.getMessage()), (Throwable)e);
            }
        }
    }

    private void updateAttendanceLog(final String ExceptionMsg) {
        AtsTimer.addTask((TimerTask)new AtsTimeTask<AttendanceLogInfo>(this.ctx, this.attendanceLog){

            @Override
            protected void process() throws Exception {
                ((AttendanceLogInfo)this.dataObj).setRemainTime(BigDecimal.valueOf(0L));
                ((AttendanceLogInfo)this.dataObj).setLastUpdateTime(new Timestamp(System.currentTimeMillis()));
                ((AttendanceLogInfo)this.dataObj).getEntries().clear();
                try {
                    AttendanceLogFactory.getLocalInstance(this.ctx).save((CoreBaseInfo)this.dataObj);
                    AttendanceLogEntryInfo logEntryInfo = new AttendanceLogEntryInfo();
                    logEntryInfo.setExcepMsg(ExceptionMsg == null ? "" : ExceptionMsg.replaceAll("\r\n", "</Br>"));
                    logEntryInfo.setGroup((AttendanceLogInfo)this.dataObj);
                    AttendanceLogEntryFactory.getLocalInstance(this.ctx).save((CoreBaseInfo)logEntryInfo);
                }
                catch (Exception e) {
                    AtsLog.getLog().error((Object)("update synLog error,detail:" + e.getMessage()), (Throwable)e);
                }
            }
        }, 100L);
    }

    private void init() throws BOSException {
        this.attendanceLog = new AttendanceLogInfo();
        this.attendanceLog.setJobid(BackJobUtile.getJobId(this.ctx));
        Map<String, String> configMap = ParamUtile.getParamValFuzzy(this.ctx, "punnchcard_cloud_");
        String baseurl = this.initBaseUrl(configMap);
        String interfaceUrl = this.initInterfaceUrl(configMap);
        this.punchCardSynProcessor.setCtx(this.ctx);
        this.punchCardSynProcessor.setPersonIds(this.personIds);
        this.punchCardSynProcessor.setAttendanceLog(this.attendanceLog);
        this.punchCardSynProcessor.setSyncUrl(baseurl + interfaceUrl);
        PunchcardHttpExecutor httpExecutor = new PunchcardHttpExecutor();
        this.punchCardSynProcessor.setHttpExecutor(httpExecutor);
        httpExecutor.setBaseUrl(baseurl);
        int preminusCount = 1440;
        try {
            this.punchCardSynProcessor.setPunnchcard_cloud_pageLength(Integer.valueOf(configMap.get("punnchcard_cloud_batch_page_limit")));
            this.punchCardSynProcessor.setPunnchcard_cloud_batch_person_size(Integer.valueOf(configMap.get("punnchcard_cloud_batch_person_size")));
            preminusCount = Integer.valueOf(configMap.get("punnchcard_cloud_preminus_count"));
        }
        catch (Exception e) {
            this.add(MLUtile.getRes(AtsPunchCardResEnum.UsePreParamForFailFetchConfig, this.ctx));
            AtsLog.getPunchcardCloudLog().error((Object)"get PunchCardSynProcessor param config error use defaule PunchCardSynProcessor param!", (Throwable)e);
        }
        this.punchCardSynProcessor.setFetchDataWithPersonPage(Boolean.valueOf(configMap.get("punnchcard_cloud_batch_withPersonPage")) != false || !this.isRunningByBackJob());
        this.punchCardSynProcessor.setWorkDateFrom(new Timestamp(this.initLastSynchTime(configMap, preminusCount).getTime()));
        this.punchCardSynProcessor.setWorkDateTo(new Timestamp(this.initWorkDateTo(configMap).getTime()));
        this.punchCardSynProcessor.setOpenapikey(configMap.get("punnchcard_cloud_openapikey"));
        this.punchcardSynValidator = new PunchcardSynValidator();
        this.punchcardSynValidator.setCtx(this.ctx);
        this.punchcardSynValidator.setPersonIds(this.personIds);
    }

    private boolean synYesterday(String dateExpression) {
        if (StringUtils.isBlank((String)dateExpression)) {
            return false;
        }
        Date curTime = Calendar.getInstance().getTime();
        String curTimeStr = AtsCommonUtile.formateDate(curTime) + " ";
        for (String expression : dateExpression.split(",")) {
            String[] expressionTemp = expression.split("-");
            if (expressionTemp.length != 2) continue;
            RangeDate rangeDate = new RangeDate(AtsDateUtils.stringToLongDate(curTimeStr + expressionTemp[0] + "00:00"), AtsDateUtils.stringToLongDate(curTimeStr + expressionTemp[1] + "00:00"));
            if (rangeDate.isValid() && ((Date)rangeDate.getLowBound()).after((Date)rangeDate.getUpBound())) {
                rangeDate = new RangeDate(AtsCommonUtile.getPreDayTime((Date)rangeDate.getLowBound()), rangeDate.getUpBound());
            }
            if (!rangeDate.include(curTime)) continue;
            return true;
        }
        return false;
    }

    private String initBaseUrl(Map<String, String> configMap) {
        if (StringUtils.isNotBlank((String)configMap.get("punnchcard_cloud_private_url"))) {
            this.add(MLUtile.getRes((ResourceEnum)AtsCludHubResEnum.item6, this.ctx, configMap.get("punnchcard_cloud_private_url")));
            return configMap.get("punnchcard_cloud_private_url");
        }
        String sql = "select FSettingMsg from T_XT_SaveSetting ORDER BY FCreateTime DESC";
        try {
            IRowSet rowSet = DbUtil.executeQuery((Context)this.ctx, (String)sql);
            while (rowSet.next()) {
                String[] res;
                int from;
                String subSetting;
                String setting = rowSet.getString("FSettingMsg");
                if (!StringUtils.isNotBlank((String)setting) || !StringUtils.isNotBlank((String)(subSetting = setting.substring(from = setting.lastIndexOf("mCloud"), setting.indexOf(";", from)))) || (res = subSetting.split("==")).length < 2 || !StringUtils.isNotBlank((String)res[1])) continue;
                this.add(MLUtile.getRes((ResourceEnum)AtsPunchCardResEnum.SyncWithPortAddress, this.ctx, res[1]));
                return res[1];
            }
        }
        catch (Exception e) {
            AtsLog.getLog().error((Object)("fetch config cloud url error,detail;" + e.getMessage()), (Throwable)e);
        }
        if (StringUtils.isNotBlank((String)configMap.get("punnchcard_cloud_default_baseUrl"))) {
            this.add(MLUtile.getRes((ResourceEnum)AtsCludHubResEnum.item12, this.ctx, configMap.get("punnchcard_cloud_default_baseUrl")));
            return configMap.get("punnchcard_cloud_default_baseUrl");
        }
        this.add(MLUtile.getRes((ResourceEnum)AtsCludHubResEnum.item13, this.ctx, SYN_BASE_URL));
        return SYN_BASE_URL;
    }

    private String initInterfaceUrl(Map<String, String> configMap) {
        CloudHubSignServiceConfigCollection coll = null;
        try {
            coll = CloudHubSignServiceConfigFactory.getLocalInstance(this.ctx).getCloudHubSignServiceConfigCollection("select detectAddress where state=1 order by number desc");
        }
        catch (BOSException e) {
            AtsLog.getLog().error((Object)"fetch enable interface fail!", (Throwable)e);
        }
        if (!AtsCollectionUtile.isEmpty((IObjectCollection)coll)) {
            for (int i = 0; i < coll.size(); ++i) {
                if (!StringUtils.isNotBlank((String)coll.get(i).getDetectAddress()) || StringUtils.equals((String)coll.get(i).getDetectAddress(), (String)"/snsapi/attendance/attendance-feedback-setting.json")) continue;
                this.add(MLUtile.getRes((ResourceEnum)AtsPunchCardResEnum.SyncWithEnableInterface, this.ctx, coll.get(i).getDetectAddress()));
                return coll.get(i).getDetectAddress();
            }
        }
        if (StringUtils.isNotBlank((String)configMap.get("punnchcard_cloud_default_interfaceUrl"))) {
            this.add(MLUtile.getRes((ResourceEnum)AtsAttenceResEnum.SyncUseDefaultWithoutEnableInterface, this.ctx, "\uff1a" + configMap.get("punnchcard_cloud_default_interfaceUrl")));
            return configMap.get("punnchcard_cloud_default_interfaceUrl");
        }
        this.add(MLUtile.getRes((ResourceEnum)AtsAttenceResEnum.SyncUsePreviousWithoutEnableInterface, this.ctx, ":SYN_INTERFACE_URL"));
        return SYN_INTERFACE_URL;
    }

    private Date initWorkDateTo(Map<String, String> configMap) {
        Object workDateTo = null;
        if (this.ctx.get((Object)"workDateTo") != null) {
            this.add(MLUtile.getRes(AtsPunchCardResEnum.SyncWithCtxAsEndTime, this.ctx));
            workDateTo = this.ctx.get((Object)"workDateTo");
        } else if (StringUtils.isNotBlank((String)configMap.get("punnchcard_cloud_workDateTo"))) {
            this.add(MLUtile.getRes(AtsPunchCardResEnum.SyncWithConfigAsEndTime, this.ctx));
            workDateTo = configMap.get("punnchcard_cloud_workDateTo");
        }
        if (workDateTo == null || workDateTo instanceof String && StringUtils.isBlank((String)((String)workDateTo))) {
            this.add(MLUtile.getRes(AtsAttenceResEnum.SyncUseNowWithoutSyncTime, this.ctx));
            workDateTo = new Timestamp(System.currentTimeMillis());
        } else {
            this.needUpdateLastSynTime = false;
        }
        return AtsCommonUtile.getTime(workDateTo);
    }

    private Date initLastSynchTime(Map<String, String> configMap, int preminusCount) {
        Object lastsynchtime = null;
        if (this.ctx.get((Object)"lastSynTime") != null) {
            this.add(MLUtile.getRes(AtsPunchCardResEnum.SyncWithCtxAsStartTime, this.ctx));
            lastsynchtime = this.ctx.get((Object)"lastSynTime");
        } else if (StringUtils.isNotBlank((String)configMap.get("punnchcard_cloud_lastsynchtime"))) {
            this.add(MLUtile.getRes(AtsPunchCardResEnum.SyncWithConfigAsStartTime, this.ctx));
            lastsynchtime = configMap.get("punnchcard_cloud_lastsynchtime");
        } else {
            String sql = "select flastsynchtime from T_HR_ATS_BizDataSynchAssist where fsynchManager='com.kingdee.eas.hr.ats.syn.datasynch.PunchCardSynchroniztionManager' and fopenapiurlkey='kdcloudpunchcard' order by flastsynchtime desc";
            try {
                IRowSet rowSet = DbUtil.executeQuery((Context)this.ctx, (String)sql);
                while (rowSet.next()) {
                    Timestamp time = rowSet.getTimestamp("flastsynchtime");
                    if (time == null) continue;
                    this.add(MLUtile.getRes(AtsPunchCardResEnum.SyncWithLastTimeAsStartTime, this.ctx));
                    lastsynchtime = time;
                    break;
                }
            }
            catch (Exception e) {
                AtsLog.getLog().error((Object)("fetch config cloud url error,detail;" + e.getMessage()), (Throwable)e);
            }
        }
        if (lastsynchtime == null || lastsynchtime instanceof String && StringUtils.isBlank((String)((String)lastsynchtime))) {
            lastsynchtime = new Timestamp(System.currentTimeMillis());
            this.add(MLUtile.getRes(AtsAttenceResEnum.SyncUsePreTimeWithoutSyncTime, this.ctx));
        }
        Date lastSynTime = AtsCommonUtile.getTime(lastsynchtime);
        if (this.runningByBackJob) {
            if (this.synYesterday(configMap.get("punnchcard_cloud_syn_all_time"))) {
                this.add(MLUtile.getRes((ResourceEnum)AtsBillResEnum.UseWholeSyncTime, this.ctx, "", configMap.get("punnchcard_cloud_syn_all_time")));
                lastSynTime.setTime(AtsCommonUtile.getDayStart(lastSynTime).getTime() - 86400000L);
            } else {
                lastSynTime.setTime(lastSynTime.getTime() - (long)(preminusCount * 60 * 1000));
            }
        }
        return lastSynTime;
    }

    public PunchCardSynProcessor getPunchCardSynProcessor() {
        return this.punchCardSynProcessor;
    }

    public void setPunchCardSynProcessor(PunchCardSynProcessor punchCardSynProcessor) {
        this.punchCardSynProcessor = punchCardSynProcessor;
    }

    public PunchcardSynValidator getPunchcardSynValidator() {
        return this.punchcardSynValidator;
    }

    public void setPunchcardSynValidator(PunchcardSynValidator punchcardSynValidator) {
        this.punchcardSynValidator = punchcardSynValidator;
    }

    public AttendanceLogInfo getAttendanceLog() {
        return this.attendanceLog;
    }

    public void setAttendanceLog(AttendanceLogInfo attendanceLog) {
        this.attendanceLog = attendanceLog;
    }

    public String getPersonIds() {
        return this.personIds;
    }

    public void setPersonIds(String personIds) {
        this.personIds = personIds;
    }

    public boolean isRunningByBackJob() {
        return this.runningByBackJob;
    }

    public void setRunningByBackJob(boolean runningByBackJob) {
        this.runningByBackJob = runningByBackJob;
    }

    public boolean isNeedUpdateLastSynTime() {
        return this.needUpdateLastSynTime;
    }

    public void setNeedUpdateLastSynTime(boolean needUpdateLastSynTime) {
        this.needUpdateLastSynTime = needUpdateLastSynTime;
    }
}

