/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.ats.syn.qyweixin;

import com.alibaba.fastjson.JSON;
import com.kingdee.eas.base.xtsync.trdsync.basesync.util.HttpSendUtil;
import com.kingdee.eas.hr.ats.AtsCludHubResEnum;
import com.kingdee.eas.hr.ats.AtsCommonResEnum;
import com.kingdee.eas.hr.ats.PunchCardRecordFactory;
import com.kingdee.eas.hr.ats.PunchCardRecordInfo;
import com.kingdee.eas.hr.ats.ResourceEnum;
import com.kingdee.eas.hr.ats.SignRecordFactory;
import com.kingdee.eas.hr.ats.SignRecordInfo;
import com.kingdee.eas.hr.ats.syn.OpenApiUrlKeyEnum;
import com.kingdee.eas.hr.ats.syn.punchcard.AbstractPunchCardSynProcessor;
import com.kingdee.eas.hr.ats.syn.qyweixin.QyWeixinHelper;
import com.kingdee.eas.hr.ats.syn.qyweixin.QyWeixinParserHelper;
import com.kingdee.eas.hr.ats.syn.qyweixin.WXSyncURLUtil;
import com.kingdee.eas.hr.ats.syn.synch.ECloudInterface;
import com.kingdee.eas.hr.ats.syn.synch.PunchCardSynEnv;
import com.kingdee.eas.hr.ats.syn.synch.SynHelper;
import com.kingdee.eas.hr.ats.util.common.AtsCollectionUtile;
import com.kingdee.eas.hr.ats.util.common.AtsLog;
import com.kingdee.eas.hr.ats.util.common.MLUtile;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class QyWeixinPunchCardSynProcessor
extends AbstractPunchCardSynProcessor {
    private Logger logger = AtsLog.getPunchcardCloudLog();

    public QyWeixinPunchCardSynProcessor() {
        this.setOpenapikey(OpenApiUrlKeyEnum.QYWEIXIN.getValue());
    }

    @Override
    protected PunchCardSynEnv createPunchCardSynEnv() {
        PunchCardSynEnv punchCardSynEnv = super.createPunchCardSynEnv();
        punchCardSynEnv.setCloudInterface(ECloudInterface.NEWLIST);
        return punchCardSynEnv;
    }

    @Override
    protected JSONArray getOutData(PunchCardSynEnv punchCardSynEnv, Timestamp curSynStartTimeStamp) {
        com.alibaba.fastjson.JSONObject param = new com.alibaba.fastjson.JSONObject();
        String syncUrl = "";
        try {
            syncUrl = WXSyncURLUtil.getSyncUrl(this.getCtx(), "/cgi-bin/checkin/getcheckindata");
            param.put("useridlist", Arrays.asList(punchCardSynEnv.getOpenIds().split(",")));
            if (this.isFetchDataDayByDay()) {
                param.put("starttime", (Object)(curSynStartTimeStamp.getTime() / 1000L));
                param.put("endtime", (Object)((curSynStartTimeStamp.getTime() + 86400000L) / 1000L));
            } else {
                param.put("starttime", (Object)(punchCardSynEnv.getWorkDateFrom().getTime() / 1000L));
                param.put("endtime", (Object)(punchCardSynEnv.getWorkDateTo().getTime() / 1000L));
            }
            param.put("opencheckindatatype", (Object)3);
            com.alibaba.fastjson.JSONObject returnValue = HttpSendUtil.startPost((String)syncUrl, (String)param.toString());
            if (null != returnValue && null != returnValue.get((Object)"checkindata")) {
                AtsLog.getPunchcardCloudLog().error((Object)returnValue.getJSONArray("checkindata").toJSONString());
                return JSONArray.fromObject((Object)returnValue.getJSONArray("checkindata"));
            }
        }
        catch (Exception e) {
            this.setGlobalException(e);
            String s = syncUrl + param.toString();
            this.add(MLUtile.getRes((ResourceEnum)AtsCludHubResEnum.item11, this.ctx, e.getMessage(), s));
            this.logger.error((Object)("fetch cloud data error:" + e.getMessage() + s), (Throwable)e);
        }
        return null;
    }

    @Override
    protected void updatePunchCardSynEnv(JSONArray recordsJsonArr, PunchCardSynEnv punchCardSynEnv, boolean initPersonData) {
        this.logger.info((Object)("dataSize=" + (recordsJsonArr == null ? 0 : recordsJsonArr.size())));
        if (recordsJsonArr == null || recordsJsonArr.size() == 0) {
            return;
        }
        punchCardSynEnv.addCloudTotalSize(recordsJsonArr.size());
        if (initPersonData) {
            try {
                com.alibaba.fastjson.JSONArray array = JSON.parseArray((String)recordsJsonArr.toString());
                String openidField = ((com.alibaba.fastjson.JSONObject)array.get(0)).containsKey((Object)"openId") ? "openId" : "userId";
                this.initPunchcardSynEnv(punchCardSynEnv, AtsCollectionUtile.conectProperty(array, openidField), !initPersonData);
            }
            catch (Exception e) {
                this.add(MLUtile.getRes((ResourceEnum)AtsCommonResEnum.InitFail, this.ctx, "punchCardSynEnv", ":" + e.getMessage()));
                this.logger.error((Object)("punchCardSynEnv init error:" + e.getMessage()), (Throwable)e);
                return;
            }
        }
        for (int i = 0; i < recordsJsonArr.size(); ++i) {
            JSONObject json = recordsJsonArr.getJSONObject(i);
            if (!QyWeixinParserHelper.isValid(json)) continue;
            if ("\u5916\u51fa\u6253\u5361".equals(json.getString("checkin_type")) || null != json.getString("exception_type") && json.getString("exception_type").contains("\u5730\u70b9\u5f02\u5e38")) {
                SignRecordInfo signRecordInfo = QyWeixinParserHelper.assembleSignRecordInfo(json, punchCardSynEnv);
                punchCardSynEnv.addSignRcd(signRecordInfo);
                continue;
            }
            PunchCardRecordInfo crdInfo = QyWeixinParserHelper.assemblePunchCardRecordInfo(json, punchCardSynEnv);
            punchCardSynEnv.addPunchCard(crdInfo);
        }
    }

    @Override
    protected void initPunchcardSynEnv(PunchCardSynEnv punchCardSynEnv, String ids, boolean idIsPersonId) throws Exception {
        if (StringUtils.isEmpty((String)ids)) {
            return;
        }
        Map<String, String> allPerson2OpenIdMap = QyWeixinHelper.GetPerson2OpenId(this.ctx, ids, idIsPersonId);
        StringBuffer openIdsb = this.removeAndGetOpenIds(allPerson2OpenIdMap);
        if (openIdsb.length() == 0) {
            punchCardSynEnv.setOpenIds("");
            return;
        }
        punchCardSynEnv.setOpenIds(openIdsb.substring(0, openIdsb.length() - 1));
        Set<String> personIdSet = allPerson2OpenIdMap.keySet();
        punchCardSynEnv.setpMap(SynHelper.GetAllPersonInfo(this.ctx, personIdSet));
        punchCardSynEnv.setPpMap(SynHelper.GetAllPersonPositionInfo(this.ctx, personIdSet));
        punchCardSynEnv.setAllOpenID2PersonMap(QyWeixinHelper.GetAllOpenID2Person(this.ctx, personIdSet));
        punchCardSynEnv.setAllOpenID2AttFileMap(QyWeixinHelper.GetAllOpenID2AttendanceFile(this.ctx, personIdSet));
        if (punchCardSynEnv.getPunchCardRecord() == null) {
            punchCardSynEnv.setPunchCardRecord(PunchCardRecordFactory.getLocalInstance(this.ctx));
        }
        if (punchCardSynEnv.getSignRecord() == null) {
            punchCardSynEnv.setSignRecord(SignRecordFactory.getLocalInstance(this.ctx));
        }
    }

    private StringBuffer removeAndGetOpenIds(Map<String, String> allPerson2OpenIdMap) {
        StringBuffer retValue = new StringBuffer();
        Iterator<Map.Entry<String, String>> it = allPerson2OpenIdMap.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, String> entry = it.next();
            if (StringUtils.isNotEmpty((String)entry.getValue())) {
                retValue.append(entry.getValue()).append(",");
                continue;
            }
            it.remove();
        }
        return retValue;
    }
}

