/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.ats.takeWorkLimit.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.ats.AtsTakeWorkingInfo;
import com.kingdee.eas.hr.ats.HolidayLimitFactory;
import com.kingdee.eas.hr.ats.HolidayLimitInfo;
import com.kingdee.eas.hr.ats.HolidayPolicyInfo;
import com.kingdee.eas.hr.ats.OTtoTakeWorkDetailFactory;
import com.kingdee.eas.hr.ats.OTtoTakeWorkDetailInfo;
import com.kingdee.eas.hr.ats.TakeWorkUnitConvertRule;
import com.kingdee.eas.hr.ats.takeWorkLimit.ICalTakeWorkLimit;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public abstract class CoreCalTakeWorkLimit
implements ICalTakeWorkLimit {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.hr.ats.takeWorkLimit.impl.CoreCalTakeWorkLimit");
    protected static String genTakeworkLmtInnerJobDefID = "balabalabalabala";
    protected HolidayLimitInfo limitInfo;
    private Context ctx;

    public CoreCalTakeWorkLimit(Context ctx, Map map) {
        this.ctx = ctx;
    }

    @Override
    public void generateTakeWorkLimit(Context ctx, Map param) {
        try {
            this.prepareData(ctx, param);
            this.calTotalLimit(ctx, param);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void calTotalLimit(Context ctx, Map param) throws BOSException {
        this.beforeCal(ctx, param);
        this.doCalTotalLimit(ctx, param);
        this.afterCal(ctx, this.limitInfo);
    }

    protected void prepareData(Context ctx, Map param) throws BOSException {
    }

    protected void beforeCal(Context ctx, Map param) {
        String proposerID = (String)param.get("proposerID");
        HolidayLimitInfo limitInfo = (HolidayLimitInfo)param.get("existedLimit");
        Set detailSet = (Set)param.get("existedDetail");
        String detailIds = "";
        if (detailSet != null && detailSet.size() > 0) {
            for (OTtoTakeWorkDetailInfo info : detailSet) {
                detailIds = detailIds + ",'" + info.getId().toString() + "'";
            }
        }
        if (detailIds.length() > 0) {
            detailIds = detailIds.substring(1);
        }
        AtsTakeWorkingInfo twRule = (AtsTakeWorkingInfo)param.get("twRule");
        HolidayPolicyInfo policyInfo = (HolidayPolicyInfo)param.get("policyInfo");
        Map ruleBasedData = (Map)param.get("ruleBasedData");
        CoreBaseCollection allLimitColl = (CoreBaseCollection)param.get("allLimitColl");
        if (limitInfo != null) {
            allLimitColl.add((CoreBaseInfo)limitInfo);
        }
        if (limitInfo != null && policyInfo.isIsOverAutoSub()) {
            HolidayLimitInfo preLimit = (HolidayLimitInfo)param.get("preLimit");
            if (preLimit != null && preLimit.getRemainLimit().compareTo(BigDecimal.ZERO) <= 0) {
                limitInfo.setPreOverdraftLimit(preLimit.getRemainLimit().abs());
            } else {
                limitInfo.setPreOverdraftLimit(BigDecimal.ZERO);
            }
        }
        if (limitInfo != null) {
            if (detailSet != null && detailSet.size() > 0) {
                for (OTtoTakeWorkDetailInfo detailInfo : detailSet) {
                    if (detailInfo.getLimit().equals(limitInfo.getId().toString())) continue;
                    limitInfo.setStandardLimit(BigDecimal.ZERO);
                    limitInfo.setRealLimit(limitInfo.getAddOrSubLimit());
                    limitInfo.setRemainLimit(limitInfo.getAddOrSubLimit().subtract(limitInfo.getUsedLimit()).subtract(limitInfo.getFreezeLimit()).subtract(limitInfo.getPreOverdraftLimit()));
                    detailSet.clear();
                    break;
                }
            } else {
                limitInfo.setStandardLimit(BigDecimal.ZERO);
                limitInfo.setRealLimit(limitInfo.getAddOrSubLimit());
                limitInfo.setRemainLimit(limitInfo.getAddOrSubLimit().subtract(limitInfo.getUsedLimit()).subtract(limitInfo.getFreezeLimit()).subtract(limitInfo.getPreOverdraftLimit()));
            }
        } else if (detailSet != null) {
            detailSet.clear();
        }
        if (limitInfo != null && detailSet != null && detailSet.size() > 0) {
            for (OTtoTakeWorkDetailInfo detailInfo : detailSet) {
                detailInfo.getLimitUnit();
                if (detailInfo.getSource().equals((Object)twRule.getTakeWorkSource()) && detailInfo.getLimitUnit().equals((Object)policyInfo.getUnit()) && detailInfo.getUnitConvertRule().equals(null == twRule.getUnitConvertRule() ? "" : twRule.getUnitConvertRule()) && (!detailInfo.getUnitConvertRule().equals(null == twRule.getUnitConvertRule() ? "" : twRule.getUnitConvertRule()) || !detailInfo.getUnitConvertRule().equals((Object)TakeWorkUnitConvertRule.fixedHour) || detailInfo.getFixedHour().equals(null == twRule.getFixedHour() ? "" : twRule.getFixedHour())) && detailInfo.isEnableMinAmt() == policyInfo.isEnableMinAmt() && (detailInfo.isEnableMinAmt() != policyInfo.isEnableMinAmt() || (null == detailInfo.getMinAmt() ? "" : detailInfo.getMinAmt()).equals(null == policyInfo.getMinAmt() ? "" : policyInfo.getMinAmt()) && (null == detailInfo.getMinAmtValueMtd() && null == policyInfo.getMinAmtValueMtd() || policyInfo.getMinAmtValueMtd().equals((Object)detailInfo.getMinAmtValueMtd()))) && (detailInfo.getOTType().getValue() != 1 ? (detailInfo.getOTType().getValue() != 2 ? detailInfo.getConvertRate().compareTo(new BigDecimal(twRule.getLegalHolidayRate())) == 0 : detailInfo.getConvertRate().compareTo(new BigDecimal(twRule.getRestDayRate())) == 0) : detailInfo.getConvertRate().compareTo(new BigDecimal(twRule.getWorkDayRate())) == 0)) continue;
                limitInfo.setStandardLimit(BigDecimal.ZERO);
                limitInfo.setRealLimit(limitInfo.getAddOrSubLimit());
                limitInfo.setRemainLimit(limitInfo.getAddOrSubLimit().subtract(limitInfo.getUsedLimit()).subtract(limitInfo.getFreezeLimit()).subtract(limitInfo.getPreOverdraftLimit()));
                limitInfo.setHolidayUnit(policyInfo.getUnit());
                detailSet.clear();
                break;
            }
        }
        if (!detailIds.isEmpty() && detailSet.size() == 0) {
            try {
                OTtoTakeWorkDetailFactory.getLocalInstance(ctx).delete("where id in (" + detailIds + ")");
            }
            catch (BOSException | EASBizException e) {
                e.printStackTrace();
            }
        }
    }

    protected void doCalTotalLimit(Context ctx, Map param) {
    }

    public void afterCal(Context ctx, HolidayLimitInfo limitInfo) {
        if (null != limitInfo) {
            BigDecimal limitvalue = null;
            String sql = "select sum(flimitvalue) flimitvalue  from  t_ats_ottotakeworkdetail where fstate = 0 and FLIMIT = '" + limitInfo.getId().toString() + "'";
            IRowSet rowset = null;
            try {
                rowset = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
                while (rowset.next()) {
                    limitvalue = rowset.getBigDecimal("flimitvalue");
                }
                if (null != limitvalue && limitInfo.getStandardLimit() != null) {
                    limitInfo.setStandardLimit(limitvalue);
                    limitInfo.setRealLimit(limitInfo.getStandardLimit().add(limitInfo.getAddOrSubLimit()));
                    logger.error((Object)("takework HolidayLimit not equals (id:" + limitInfo.getId().toString() + "),HolidayLimit StandardLimit=" + limitInfo.getStandardLimit() + ",takework total limitvalue=" + limitvalue));
                    HolidayLimitFactory.getLocalInstance(ctx).update((IObjectPK)new ObjectUuidPK(limitInfo.getId()), limitInfo);
                }
            }
            catch (BOSException e) {
                logger.error((Object)"update takework HolidayLimit failed!");
                e.printStackTrace();
            }
            catch (SQLException e) {
                logger.error((Object)"update takework HolidayLimit failed!");
                e.printStackTrace();
            }
            catch (Exception e) {
                logger.error((Object)"update takework HolidayLimit failed!");
                e.printStackTrace();
            }
        }
    }
}

