/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.ats.thread.ExecutorService;

import com.kingdee.bos.Context;
import com.kingdee.eas.hr.ats.AtsAttenceResEnum;
import com.kingdee.eas.hr.ats.AtsNounCommonResEnum;
import com.kingdee.eas.hr.ats.thread.ExecutorService.RejectedPolicy;
import com.kingdee.eas.hr.ats.thread.ExecutorService.ThreadFactory;
import com.kingdee.eas.hr.ats.thread.executor.ExecutorUtile;
import com.kingdee.eas.hr.ats.thread.executor.TaskExecutorBase;
import com.kingdee.eas.hr.ats.thread.executor.TaskStatus;
import com.kingdee.eas.hr.ats.util.AtsConstants;
import com.kingdee.eas.hr.ats.util.common.AtsCommonUtile;
import com.kingdee.eas.hr.ats.util.common.AtsLog;
import com.kingdee.eas.hr.ats.util.common.MLUtile;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.commons.lang.StringUtils;

public class ThreadPool
extends ThreadPoolExecutor {
    private int maxTaskCount = 10000;
    private int sameTaskCountLimit = 1;
    private int defaultOutComeHoldTime = 30000;
    private long maxTaskExecuteTime = 10800000L;
    private boolean removeTaskOnReachMaxTaskCount = false;
    private Timestamp createTime = new Timestamp(System.currentTimeMillis());
    private Timestamp lastTaskEndTime;
    private List<TaskExecutorBase<? extends Object>> taskList = new ArrayList<TaskExecutorBase<? extends Object>>();

    public ThreadPool(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue) {
        this(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, null, null);
    }

    public ThreadPool(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, RejectedExecutionHandler handler) {
        this(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, null, handler);
    }

    public ThreadPool(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, java.util.concurrent.ThreadFactory threadFactory) {
        this(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, threadFactory, null);
    }

    public ThreadPool(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, java.util.concurrent.ThreadFactory threadFactory, RejectedExecutionHandler handler) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, threadFactory == null ? ThreadFactory.getInstance() : threadFactory, handler == null ? new RejectedPolicy() : handler);
        AtsLog.getLog().error((Object)("thread_pool_created(" + this.createTime + "):" + this.toString()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void purgeTakList(Context ctx) {
        List<TaskExecutorBase<? extends Object>> list = this.taskList;
        synchronized (list) {
            Iterator<TaskExecutorBase<? extends Object>> it = this.taskList.iterator();
            long currentTime = System.currentTimeMillis();
            while (it.hasNext()) {
                TaskExecutorBase<? extends Object> task = it.next();
                if (task.hasEnd()) {
                    if (currentTime - task.getEndTime().getTime() <= Math.max((long)this.defaultOutComeHoldTime, task.getOutComeHoldTime())) continue;
                    AtsLog.getLog().info((Object)("task reach time setted after complete\uff1a" + task));
                    it.remove();
                    continue;
                }
                if (task.getTaskStatus() != TaskStatus.WAITTING || currentTime - task.getCreateTime().getTime() <= this.maxTaskExecuteTime) continue;
                it.remove();
                task.stopTask(MLUtile.getRes(AtsNounCommonResEnum.RemoveForTimeOut, ctx));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <V> boolean cancelTask(Context ctx, TaskExecutorBase<V> task) {
        if (task == null) {
            return false;
        }
        boolean result = false;
        result = task.stopTask(MLUtile.getRes(AtsAttenceResEnum.RemoveMissionForce, ctx));
        List<TaskExecutorBase<? extends Object>> list = this.taskList;
        synchronized (list) {
            result = result && this.taskList.remove(task);
        }
        return result;
    }

    public <V> boolean cancelTask(Context ctx, String id) {
        return this.cancelTask(ctx, this.getTask(id));
    }

    public TaskExecutorBase<?> getTask(String id) {
        if (StringUtils.isBlank((String)id)) {
            return null;
        }
        for (TaskExecutorBase<? extends Object> task : this.taskList) {
            if (!id.equals(task.getTaskId())) continue;
            return task;
        }
        return null;
    }

    @Override
    protected void beforeExecute(Thread t, Runnable r) {
        super.beforeExecute(t, r);
    }

    @Override
    protected void afterExecute(Runnable r, Throwable t) {
        this.lastTaskEndTime = new Timestamp(System.currentTimeMillis());
        super.afterExecute(r, t);
    }

    @Override
    protected void terminated() {
        super.terminated();
        AtsLog.getLog().error((Object)("thread_pool_terminated(" + this.createTime + "~" + AtsCommonUtile.formateTime(Calendar.getInstance().getTime()) + "):" + this.toString()));
        AtsLog.getLog().error((Object)("uncomplete task:" + this.taskList));
        this.taskList = null;
    }

    @Override
    public Future<?> submit(Runnable task) {
        TaskExecutorBase<Object> task0 = ExecutorUtile.transToTask(task);
        if (!this.beforeSubmitTask(task0)) {
            return null;
        }
        task0.setFuture(super.submit(task0, null));
        return task0.getFuture();
    }

    @Override
    public <T> Future<T> submit(Runnable task, T result) {
        TaskExecutorBase<T> task0 = ExecutorUtile.transToTask(task, result);
        if (!this.beforeSubmitTask(task0)) {
            return null;
        }
        task0.setFuture(super.submit(task0, result));
        return task0.getFuture();
    }

    @Override
    public <T> Future<T> submit(Callable<T> task) {
        TaskExecutorBase<T> task0 = ExecutorUtile.transToTask(task);
        if (!this.beforeSubmitTask(task0)) {
            return null;
        }
        task0.setFuture(super.submit(task));
        return task0.getFuture();
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) throws InterruptedException {
        List<TaskExecutorBase<T>> tasks0 = ExecutorUtile.transToTask(tasks);
        if (!this.beforeSubmitTask(tasks0)) {
            return null;
        }
        List<Future<T>> futures = super.invokeAll(tasks0);
        this.setFutureToTask(tasks0, futures);
        return futures;
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException {
        List<TaskExecutorBase<T>> tasks0 = ExecutorUtile.transToTask(tasks);
        if (!this.beforeSubmitTask(tasks0)) {
            return null;
        }
        List<Future<T>> futures = super.invokeAll(tasks0, timeout, unit);
        this.setFutureToTask(tasks0, futures);
        return futures;
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks) throws InterruptedException, ExecutionException {
        try {
            return this.invokeAny(tasks, 0L, null);
        }
        catch (TimeoutException e) {
            assert (false);
            return null;
        }
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        List tasks0 = ExecutorUtile.transToTask(tasks);
        if (!this.beforeSubmitTask(tasks0)) {
            return null;
        }
        FutureForInvokeAny future = new FutureForInvokeAny(tasks, timeout, unit);
        for (TaskExecutorBase taskTemp : tasks0) {
            taskTemp.setFuture(future);
        }
        super.execute(future);
        return (T)future.get();
    }

    private <T> T invokeAnySuper(Collection<? extends Callable<T>> tasks) throws InterruptedException, ExecutionException, TimeoutException {
        return this.invokeAny(tasks, 0L, TimeUnit.MILLISECONDS);
    }

    private <T> T invokeAnySuper(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return super.invokeAny(tasks, timeout, unit);
    }

    @Override
    public void execute(Runnable command) {
        if (!(command instanceof FutureTask)) {
            TaskExecutorBase<Object> command0 = ExecutorUtile.transToTask(command);
            if (!this.beforeSubmitTask(command0)) {
                return;
            }
            FutureTask futureTask = new FutureTask(command0.toCallable());
            command0.setFuture(futureTask);
            command = command0;
        }
        super.execute(command);
    }

    private <T> void setFutureToTask(List<TaskExecutorBase<T>> tasks, List<Future<T>> futures) {
        if (tasks == null || futures == null) {
            return;
        }
        for (int i = 0; i < tasks.size(); ++i) {
            if (tasks.get(i) == null) continue;
            tasks.get(i).setFuture(futures.get(i));
        }
    }

    private boolean beforeSubmitTask(Object tasks) {
        if (!this.validateTaskAccount(tasks instanceof Collection ? ((Collection)tasks).size() : 1)) {
            throw new RuntimeException("executor_pool_reach_max_size :" + this.getMaxTaskCount());
        }
        boolean executeInCurrentThread = false;
        for (Object task : tasks instanceof Collection ? new ArrayList((Collection)tasks) : Collections.singletonList(tasks)) {
            TaskExecutorBase taskBase = (TaskExecutorBase)task;
            if (!this.validateMutex(taskBase)) {
                throw new RuntimeException("add task failour,exist_same_catalog_task :" + null);
            }
            executeInCurrentThread = taskBase.isNeedExecuteRightNow();
        }
        this.addToTaskList(tasks);
        if (!executeInCurrentThread || this.getActiveCount() <= this.getCorePoolSize()) {
            return true;
        }
        for (Object task : tasks instanceof Collection ? new ArrayList((Collection)tasks) : Collections.singletonList(tasks)) {
            ((TaskExecutorBase)task).execute();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean validateTaskAccount(int needAddedCount) {
        BlockingQueue<Runnable> tasks;
        BlockingQueue<Runnable> blockingQueue = tasks = this.getQueue();
        synchronized (blockingQueue) {
            int currentTaskCount = tasks.size();
            if (currentTaskCount + needAddedCount <= this.maxTaskCount) {
                return true;
            }
            if (!this.removeTaskOnReachMaxTaskCount) {
                return false;
            }
            while (needAddedCount > 0) {
                TaskExecutorBase<? extends Object> task = this.taskList.get(0);
                for (int i = 1; i < currentTaskCount; ++i) {
                    if (task.getStartTime().getTime() <= this.taskList.get(i).getStartTime().getTime()) continue;
                    task = this.taskList.get(i);
                }
                AtsLog.getLog().info((Object)("task removed because over count limit\uff1a" + task));
                this.taskList.remove(task);
                task.stopTask(AtsConstants.REMOVE_FOROVER_LIMIT.getMessage());
                --needAddedCount;
            }
        }
        return true;
    }

    private boolean validateMutex(TaskExecutorBase<?> task) {
        if (StringUtils.isBlank((String)task.getCatalog())) {
            return true;
        }
        int sameTaskCount = 0;
        for (TaskExecutorBase<? extends Object> taskTemp : this.taskList) {
            if (taskTemp.hasEnd() || !StringUtils.equalsIgnoreCase((String)taskTemp.getCatalog(), (String)task.getCatalog())) continue;
            ++sameTaskCount;
        }
        return sameTaskCount < this.sameTaskCountLimit;
    }

    private void addToTaskList(Object tasks) {
        if (tasks == null) {
            return;
        }
        if (tasks instanceof Collection) {
            for (TaskExecutorBase task : (Collection)tasks) {
                if (task.setWaitingstatus().getOutComeHoldTime() <= 0L) continue;
                this.taskList.add(task);
            }
        } else {
            TaskExecutorBase task = (TaskExecutorBase)tasks;
            if (task.setWaitingstatus().getOutComeHoldTime() > 0L) {
                this.taskList.add(task);
            }
        }
    }

    public Timestamp getCreateTime() {
        return this.createTime;
    }

    public ThreadPool setCreateTime(Timestamp createTime) {
        this.createTime = createTime;
        return this;
    }

    public List<TaskExecutorBase<? extends Object>> getTaskList() {
        return this.taskList;
    }

    public ThreadPool setTaskList(List<TaskExecutorBase<? extends Object>> taskList) {
        this.taskList = taskList;
        return this;
    }

    public int getMaxTaskCount() {
        return this.maxTaskCount;
    }

    public void setMaxTaskCount(int maxTaskCount) {
        this.maxTaskCount = maxTaskCount;
    }

    public boolean isRemoveTaskOnReachMaxTaskCount() {
        return this.removeTaskOnReachMaxTaskCount;
    }

    public void setRemoveTaskOnReachMaxTaskCount(boolean removeTaskOnReachMaxTaskCount) {
        this.removeTaskOnReachMaxTaskCount = removeTaskOnReachMaxTaskCount;
    }

    public int getSameTaskCountLimit() {
        return this.sameTaskCountLimit;
    }

    public void setSameTaskCountLimit(int sameTaskCountLimit) {
        this.sameTaskCountLimit = sameTaskCountLimit;
    }

    public int getDefaultOutComeHoldTime() {
        return this.defaultOutComeHoldTime;
    }

    public void setDefaultOutComeHoldTime(int defaultOutComeHoldTime) {
        this.defaultOutComeHoldTime = defaultOutComeHoldTime;
    }

    public long getMaxTaskExecuteTime() {
        return this.maxTaskExecuteTime;
    }

    public void setMaxTaskExecuteTime(long maxTaskExecuteTime) {
        this.maxTaskExecuteTime = maxTaskExecuteTime;
    }

    public Timestamp getLastTaskEndTime() {
        return this.lastTaskEndTime;
    }

    public ThreadPool setLastTaskEndTime(Timestamp lastTaskEndTime) {
        this.lastTaskEndTime = lastTaskEndTime;
        return this;
    }

    private class FutureForInvokeAny<V>
    extends FutureTask<V> {
        public FutureForInvokeAny(final Collection<? extends Callable<V>> tasks, final long timeout, final TimeUnit unit) {
            super(new TaskExecutorBase<V>(){

                @Override
                protected V executeInner() throws Exception {
                    if (unit == null && timeout == 0L) {
                        return ThreadPool.this.invokeAnySuper(tasks);
                    }
                    return ThreadPool.this.invokeAnySuper(tasks, timeout, unit);
                }
            });
        }
    }
}

