/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.ats.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.permission.UserCollection;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.basedata.org.PositionFactory;
import com.kingdee.eas.basedata.org.PositionInfo;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.ats.AtsAcrossStoreResEnum;
import com.kingdee.eas.hr.ats.AtsAcrossStoreSopportCollection;
import com.kingdee.eas.hr.ats.AtsAcrossStoreSopportFactory;
import com.kingdee.eas.hr.ats.AtsAcrossStoreSopportInfo;
import com.kingdee.eas.hr.ats.AtsAcrossStoreSptEntryCollection;
import com.kingdee.eas.hr.ats.AtsAcrossStoreSptEntryInfo;
import com.kingdee.eas.hr.ats.AtsAcrossStoreSptsCollection;
import com.kingdee.eas.hr.ats.AtsAcrossStoreSptsInfo;
import com.kingdee.eas.hr.ats.AtsCommonBizException;
import com.kingdee.eas.hr.ats.AtsNounCommonResEnum;
import com.kingdee.eas.hr.ats.AtsUtil;
import com.kingdee.eas.hr.ats.AttendanceFileHISInfo;
import com.kingdee.eas.hr.ats.AttendanceFileInfo;
import com.kingdee.eas.hr.ats.CollaborativeStateEnum;
import com.kingdee.eas.hr.ats.ResourceEnum;
import com.kingdee.eas.hr.ats.ScheduleShiftCollection;
import com.kingdee.eas.hr.ats.ScheduleShiftInfo;
import com.kingdee.eas.hr.ats.ScheduleShiftItemCollection;
import com.kingdee.eas.hr.ats.ScheduleShiftItemInfo;
import com.kingdee.eas.hr.ats.SegmentUnitEnum;
import com.kingdee.eas.hr.ats.helper.ScheduleShiftItemHelper;
import com.kingdee.eas.hr.ats.lightapp.util.HRTimeWebUtils;
import com.kingdee.eas.hr.ats.lightapp.util.SHRBillUtil;
import com.kingdee.eas.hr.ats.util.AtsDateUtils;
import com.kingdee.eas.hr.ats.util.AtsScheduleShiftUtil;
import com.kingdee.eas.hr.ats.util.AtsServerUtils;
import com.kingdee.eas.hr.ats.util.AtsStoreToScheduleShiftUtil;
import com.kingdee.eas.hr.ats.util.AtsViewUtile;
import com.kingdee.eas.hr.ats.util.common.AtsCollectionUtile;
import com.kingdee.eas.hr.ats.util.common.AtsCommonUtile;
import com.kingdee.eas.hr.ats.util.common.ConfigAts;
import com.kingdee.eas.hr.ats.util.common.CoreBaseUtile;
import com.kingdee.eas.hr.ats.util.common.MLUtile;
import com.kingdee.eas.hr.ats.util.common.YZJMsgPusher;
import com.kingdee.eas.hr.ats.validator.AtsAcrossStoreBillHelper;
import com.kingdee.eas.hr.ats.validator.IValidator;
import com.kingdee.eas.hr.ats.validator.PlateformType;
import com.kingdee.eas.hr.ats.validator.ValidateUtile;
import com.kingdee.eas.hr.base.HRCommonException;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.base.syssetting.api.bean.BatchMessageTipsBody;
import com.kingdee.shr.shareservice.CoActivityExecutorCollection;
import com.kingdee.shr.shareservice.CoActivityExecutorFactory;
import com.kingdee.shr.shareservice.CoActivityJobCollection;
import com.kingdee.shr.shareservice.CoActivityJobFactory;
import com.kingdee.shr.shareservice.CoActivityJobOptFacadeFactory;
import com.kingdee.shr.shareservice.CoActivityState;
import com.kingdee.shr.shareservice.ICoActivityJobOptFacade;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;

public class AtsAcrossStoreRptUtils {
    public static final String DISTRIBUTE_USER = "currentDistributeUser";
    public static final String ID_ACTIVITY_SOPPORT = "SZqtkQA1Q2a/V5JsXBc/T4Is15U=";
    public static final String IS_DISTRIBUTE_TASK = "isDistributeTask";
    public static final String RESOURCE_ML = "com.kingdee.eas.hr.ats.AtsAcrossStoreResEnum";
    public static final String PUSH_CONFIG_SOPPORT = "ATS-AtsAcrossStoreSopport";
    Map<String, AttendanceFileHISInfo> atsFileHisMap = new HashMap<String, AttendanceFileHISInfo>();
    Map<String, List<AtsAcrossStoreSptsInfo>> personSpts = new HashMap<String, List<AtsAcrossStoreSptsInfo>>();
    Map<String, ScheduleShiftCollection> scheduleShiftMap = new HashMap<String, ScheduleShiftCollection>();
    private String sptRepeatSql = "";
    private String scheduleShiftRepeatSql = "";
    private String tripRepeatSql = "";
    private String oTRepeatSql = "";

    public static Map<String, Object> getFildsAndSpts(Context ctx, HashMap param) {
        String entrybill = (String)param.get("EntryBill");
        java.util.Date enddata = (java.util.Date)param.get("enddata");
        java.util.Date statedata = (java.util.Date)param.get("statedata");
        Object postion = param.get("postion");
        HashMap<String, Object> stringObjectHashMap = new HashMap<String, Object>();
        int days = 0;
        for (int i = 0; i < days; ++i) {
            ArrayList spts = new ArrayList();
            spts.add(new HashMap());
            stringObjectHashMap.put(i + "_", spts);
        }
        return stringObjectHashMap;
    }

    public static ArrayList<AtsAcrossStoreSptsInfo> getSptsForSptEntry(Context ctx, AtsAcrossStoreSptEntryInfo info) throws BOSException {
        ArrayList<AtsAcrossStoreSptsInfo> acrossStorelist = new ArrayList<AtsAcrossStoreSptsInfo>();
        for (int i = 0; i < info.getPersonNumber(); ++i) {
            for (int j = 0; j < Integer.parseInt(Long.toString(AtsDateUtils.getDaysBetweenTwoDate(info.getEndDate(), info.getStartDate()))) + 1; ++j) {
                AtsAcrossStoreSptsInfo sptsInfo = new AtsAcrossStoreSptsInfo();
                sptsInfo.setEntryBill(info);
                sptsInfo.setAttPosition(info.getAttPosition());
                sptsInfo.setAttendanceDate(AtsDateUtils.getNextDay(info.getStartDate(), j));
                sptsInfo.setLabelMark(i + "_" + sptsInfo.getEntryBill().getId().toString());
                sptsInfo.setStartTime(info.getOnWorkTime());
                sptsInfo.setEndTime(info.getOffWorkTime());
                acrossStorelist.add(sptsInfo);
            }
        }
        return acrossStorelist;
    }

    public static String verifySupportParameter(Context ctx, AtsAcrossStoreSopportInfo billInfo) {
        HashMap res = new HashMap();
        return "";
    }

    public static Map getWorkTimeByShift(Context ctx, String shiftId) {
        StringBuffer sb = new StringBuffer();
        sb.append(" select * from T_HR_ATS_ShiftItem where FGroupID= ? ");
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            IRowSet iRowSet = DbUtil.executeQuery((Context)ctx, (String)sb.toString(), (Object[])new Object[]{shiftId});
            while (iRowSet.next()) {
                int nextTimeDayType;
                java.util.Date date = new java.util.Date();
                int preTimeDayType = iRowSet.getString("FPreTimeDayType") != null ? Integer.valueOf(iRowSet.getString("FPreTimeDayType")) : 1;
                int n = nextTimeDayType = iRowSet.getString("FNextTimeDayType") != null ? Integer.valueOf(iRowSet.getString("FNextTimeDayType")) : 1;
                if (map.isEmpty()) {
                    map.put("preTime", AtsDateUtils.dateShortToString(AtsDateUtils.getNextDay(date, preTimeDayType - 1)) + " " + iRowSet.getString("FPreTime") + ":00");
                    map.put("nextTime", AtsDateUtils.dateShortToString(AtsDateUtils.getNextDay(date, nextTimeDayType - 1)) + " " + iRowSet.getString("FNextTime") + ":00");
                    map.put("onWorkDayType", String.valueOf(preTimeDayType));
                    map.put("offWorkDayType", String.valueOf(nextTimeDayType));
                    map.put("mOnWorkDayType", (Object)SegmentUnitEnum.getEnum(preTimeDayType));
                    map.put("mOffWorkDayType", (Object)SegmentUnitEnum.getEnum(nextTimeDayType));
                    continue;
                }
                String preTime = (String)map.get("preTime");
                String nextTime = (String)map.get("nextTime");
                String preTimeitem = AtsDateUtils.dateShortToString(AtsDateUtils.getNextDay(date, preTimeDayType - 1)) + " " + iRowSet.getString("FPreTime") + ":00";
                String nextTimeitem = AtsDateUtils.dateShortToString(AtsDateUtils.getNextDay(date, nextTimeDayType - 1)) + " " + iRowSet.getString("FNextTime") + ":00";
                if (AtsDateUtils.stringToLongDate(preTime).after(AtsDateUtils.stringToLongDate(preTimeitem))) {
                    map.put("preTime", preTimeitem);
                    map.put("onWorkDayType", String.valueOf(preTimeDayType));
                    map.put("mOnWorkDayType", (Object)SegmentUnitEnum.getEnum(preTimeDayType));
                }
                if (!AtsDateUtils.stringToLongDate(nextTime).before(AtsDateUtils.stringToLongDate(nextTimeitem))) continue;
                map.put("nextTime", nextTimeitem);
                map.put("offWorkDayType", String.valueOf(nextTimeDayType));
                map.put("mOffWorkDayType", (Object)SegmentUnitEnum.getEnum(nextTimeDayType));
            }
        }
        catch (BOSException | SQLException e) {
            e.printStackTrace();
        }
        return map;
    }

    public static Map getSptParameterSetting(Context ctx) {
        String supportDuration = ConfigAts.getPropertyFromConfig("SupportDuration");
        String supportDays = ConfigAts.getPropertyFromConfig("SupportDays");
        HashMap<String, Integer> sptParameter = new HashMap<String, Integer>();
        Integer supportDurationNum = 30;
        Integer supportDaysNum = 3;
        if (StringUtils.isNotEmpty((CharSequence)supportDuration)) {
            supportDurationNum = Integer.valueOf(supportDuration).compareTo(0) > -1 ? Integer.valueOf(supportDuration) : 0;
        }
        if (StringUtils.isNotEmpty((CharSequence)supportDays)) {
            supportDaysNum = Integer.valueOf(supportDays).compareTo(7) < 1 && Integer.valueOf(supportDays).compareTo(0) > -1 ? Integer.valueOf(supportDays) : 7;
        }
        sptParameter.put("SupportDuration", supportDurationNum);
        sptParameter.put("SupportDays", supportDaysNum);
        return sptParameter;
    }

    public static String checkHasAgainstApproveBill(Context ctx, AtsAcrossStoreSopportInfo billInfo) {
        StringBuilder sql = new StringBuilder();
        HashSet<String> personIds = new HashSet<String>();
        for (int i = 0; i < billInfo.getSpts().size(); ++i) {
            personIds.add(billInfo.getSpts().get(i).getPerson().getId().toString());
        }
        Pair<String, List<String>> pair = AtsCollectionUtile.inSqlMask(AtsUtil.convertSetToString(personIds));
        sql.append("SELECT\n\tsop.fid,\n\tsop.fnumber,\n\tp.fname" + MLUtile.getMlFlag(ctx) + " AS name,\n\tspts.FAttendanceDate,\n\tentry.FOnWorkTime,\n\tentry.FOnWorkDayType,\n\tentry.FOffWorkTime,\n\tentry.FOffWorkDayType,\n\tentry.FworkOnTime,\n\tentry.FworkoffTime ,\n\tsop.FLastUpdateTime\nFROM\n\tT_ATS_AtsAcrossStoreSpts spts\n\tINNER JOIN T_ATS_AtsAcrossStoreSptEntry entry ON entry.fid = spts.FEntryBillID\n\tINNER JOIN T_ATS_AtsAcrossStoreSopport sop ON sop.fid = entry.FBillId\n\tLEFT JOIN T_BD_Person p ON spts.fpersonid= p.fid \nWHERE\n\t sop.fbillState = 3  and  sop.fid <> ? and  \tspts.FPersonID  in ( " + (String)pair.getLeft() + " )  AND ( ( spts.FAttendanceDate >= ? AND spts.FAttendanceDate <=? ) ) \n");
        sql.toString();
        Map<String, java.util.Date> minStartTimeAndMaxEndTime = AtsAcrossStoreRptUtils.getMinStartTimeAndMaxEndTime(ctx, billInfo);
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])AtsCollectionUtile.object2Arr(billInfo.getId().toString(), pair.getRight(), AtsDateUtils.dateToTimestamp(minStartTimeAndMaxEndTime.get("startDate")), AtsDateUtils.dateToTimestamp(minStartTimeAndMaxEndTime.get("endDate"))));
            if (rs != null && rs.size() > 0) {
                while (rs.next()) {
                    if (!billInfo.getLastUpdateTime().before(rs.getTime("FLastUpdateTime"))) continue;
                    for (int i = 0; i < billInfo.getSpts().size(); ++i) {
                        if (!billInfo.getSpts().get(i).getAttendanceDate().equals(rs.getDate("FAttendanceDate"))) continue;
                        if (StringUtils.isEmpty((CharSequence)MLUtile.getRes((ResourceEnum)AtsAcrossStoreResEnum.noAgainstApproveReason, ctx, rs.getString("name"), rs.getString("fnumber")))) {
                            return MLUtile.getRes(AtsAcrossStoreResEnum.CANCERAUDITNOTMATHAUDIT, ctx);
                        }
                        return MLUtile.getRes((ResourceEnum)AtsAcrossStoreResEnum.noAgainstApproveReason, ctx, rs.getString("name"), rs.getString("fnumber"));
                    }
                }
            }
        }
        catch (BOSException | SQLException e) {
            e.printStackTrace();
        }
        return "";
    }

    public String checkscheduIsOFFDay(Context ctx, AtsAcrossStoreSopportInfo billInfo) throws BOSException {
        if (!billInfo.isSupportType()) {
            HashMap<String, AtsAcrossStoreSptEntryInfo> stringAtsAcrossStoreSptEntryInfoHashMap = new HashMap<String, AtsAcrossStoreSptEntryInfo>();
            for (int i = 0; i < billInfo.getEntries().size(); ++i) {
                stringAtsAcrossStoreSptEntryInfoHashMap.put(billInfo.getEntries().get(i).getId().toString(), billInfo.getEntries().get(i));
            }
            HashSet<String> personIds = new HashSet<String>();
            for (int i = 0; i < billInfo.getSpts().size(); ++i) {
                if (null == billInfo.getSpts().get(i).getPerson()) continue;
                personIds.add(billInfo.getSpts().get(i).getPerson().getId().toString());
            }
            if (personIds.isEmpty()) {
                return "";
            }
            HashMap<String, ScheduleShiftInfo> stringScheduleShiftInfoHashMap = new HashMap<String, ScheduleShiftInfo>();
            Map<String, Integer> sortByLableMark = this.getSortByLableMark(ctx, billInfo);
            Map<String, java.util.Date> minStartTimeAndMaxEndTime = AtsAcrossStoreRptUtils.getMinStartTimeAndMaxEndTime(ctx, billInfo);
            Map<String, ScheduleShiftInfo> scheduleShiftForPersonByAttendanceFile = AtsStoreToScheduleShiftUtil.getScheduleShiftForPersonByAttendanceFile(ctx, AtsUtil.convertSetToString(personIds), AtsDateUtils.dateShortToString(minStartTimeAndMaxEndTime.get("startDate")), AtsDateUtils.dateShortToString(minStartTimeAndMaxEndTime.get("endDate")));
            Map<String, ScheduleShiftInfo> existSchedules = AtsScheduleShiftUtil.getScheduleShiftForPersonByOql(ctx, AtsUtil.convertSetToString(personIds), AtsDateUtils.dateShortToString(minStartTimeAndMaxEndTime.get("startDate")), AtsDateUtils.dateShortToString(minStartTimeAndMaxEndTime.get("endDate")));
            for (int i = 0; i < billInfo.getSpts().size(); ++i) {
                ScheduleShiftInfo scheduleShiftInfo;
                if (billInfo.getSpts().get(i).getPerson() == null) continue;
                ScheduleShiftInfo scheduleShiftInfo2 = scheduleShiftInfo = stringScheduleShiftInfoHashMap != null ? (ScheduleShiftInfo)stringScheduleShiftInfoHashMap.get(AtsScheduleShiftUtil.getKey(billInfo.getSpts().get(i).getPerson().getId().toString(), AtsDateUtils.dateShortToString(billInfo.getSpts().get(i).getAttendanceDate()))) : null;
                if (scheduleShiftInfo == null) {
                    ScheduleShiftInfo scheduleShiftInfo3 = scheduleShiftInfo = existSchedules != null ? existSchedules.get(AtsScheduleShiftUtil.getKey(billInfo.getSpts().get(i).getPerson().getId().toString(), AtsDateUtils.dateShortToString(billInfo.getSpts().get(i).getAttendanceDate()))) : null;
                }
                if (scheduleShiftInfo != null) {
                    scheduleShiftInfo = AtsStoreToScheduleShiftUtil.updateScheduleShiftItemBySpts(ctx, billInfo.getSpts().get(i), scheduleShiftInfo, billInfo);
                } else {
                    scheduleShiftInfo = scheduleShiftForPersonByAttendanceFile.get(AtsScheduleShiftUtil.getKey(billInfo.getSpts().get(i).getPerson().getId().toString(), AtsDateUtils.dateShortToString(billInfo.getSpts().get(i).getAttendanceDate())));
                    if (scheduleShiftInfo != null) {
                        scheduleShiftInfo = AtsStoreToScheduleShiftUtil.addNewScheduleShiftItemBySpts(ctx, billInfo.getSpts().get(i), scheduleShiftInfo, billInfo);
                    }
                }
                if (null != scheduleShiftInfo && scheduleShiftInfo.getItems().size() > 3) {
                    return MLUtile.getRes((ResourceEnum)AtsAcrossStoreResEnum.Line, ctx, sortByLableMark.get(billInfo.getSpts().get(i).getLabelMark())) + MLUtile.getRes(AtsAcrossStoreResEnum.OverThanThreeShifts, ctx);
                }
                stringScheduleShiftInfoHashMap.put(AtsScheduleShiftUtil.getKey(billInfo.getSpts().get(i).getPerson().getId().toString(), AtsDateUtils.dateShortToString(billInfo.getSpts().get(i).getAttendanceDate())), scheduleShiftInfo);
            }
        }
        return "";
    }

    private ScheduleShiftInfo getScheduleShiftMergeCollection(ScheduleShiftInfo scheduleShiftInfotemp, ScheduleShiftInfo scheduleShiftInfo) {
        int i;
        ScheduleShiftItemCollection itemsTemp = scheduleShiftInfotemp.getItems();
        ScheduleShiftItemCollection items = scheduleShiftInfo.getItems();
        ScheduleShiftItemCollection scheduleShiftItemCollection = new ScheduleShiftItemCollection();
        for (i = 0; i < items.size(); ++i) {
            scheduleShiftItemCollection.add(items.get(i));
        }
        for (i = 0; i < itemsTemp.size(); ++i) {
            scheduleShiftItemCollection.add(itemsTemp.get(i));
        }
        scheduleShiftInfotemp.getItems().addCollection(scheduleShiftItemCollection);
        return scheduleShiftInfotemp;
    }

    public String validateSSC(Context ctx, AtsAcrossStoreSopportInfo billInfo) throws BOSException {
        if (billInfo.getEntries() == null || billInfo.getEntries().isEmpty()) {
            return MLUtile.getRes(AtsAcrossStoreResEnum.EntriesCanNotBeEmpty, ctx);
        }
        if (billInfo.getSpts() == null || billInfo.getSpts().isEmpty()) {
            return MLUtile.getRes(AtsAcrossStoreResEnum.InformationEntryCanNotBeEmpty, ctx);
        }
        Map<String, Integer> sortByLableMark = this.getSortByLableMark(ctx, billInfo);
        Map<String, Map<String, java.util.Date>> startTimeAndEndTime = this.getStartTimeAndEndTime(ctx, billInfo);
        for (int i = 0; i < billInfo.getSpts().size(); ++i) {
            if (billInfo.getSpts().get(i).getPerson() == null) {
                boolean afterEnd;
                Map<String, java.util.Date> stringDateMap = startTimeAndEndTime.get(billInfo.getSpts().get(i).getEntryBill().getId().toString());
                boolean beforeStart = stringDateMap.get("StartDate").compareTo(billInfo.getSpts().get(i).getAttendanceDate()) != 1;
                boolean bl = afterEnd = stringDateMap.get("EndDate").compareTo(billInfo.getSpts().get(i).getAttendanceDate()) != -1;
                if (beforeStart && afterEnd) {
                    if (billInfo.getSpts().get(i).getPerson() == null && !"submit".equals(billInfo.get("actionSSC"))) {
                        return MLUtile.getRes(AtsNounCommonResEnum.Position, ctx) + billInfo.getSpts().get(i).getAttPosition().getName() + MLUtile.getRes(AtsAcrossStoreResEnum.InformationEntrySupportStaffCanNotBeEmpty, ctx);
                    }
                } else {
                    billInfo.getSpts().removeObject(i);
                    --i;
                    continue;
                }
            }
            if (billInfo.getSpts().get(i).getAttPosition() == null) {
                return MLUtile.getRes((ResourceEnum)AtsAcrossStoreResEnum.Line, ctx, sortByLableMark.get(billInfo.getSpts().get(i).getLabelMark())) + MLUtile.getRes(AtsAcrossStoreResEnum.TheSupportPostCanNotBeEmpty, ctx);
            }
            if (billInfo.getSpts().get(i).getSupportLeader() != null || "submit".equals(billInfo.get("actionSSC"))) continue;
            return MLUtile.getRes(AtsNounCommonResEnum.Position, ctx) + billInfo.getSpts().get(i).getAttPosition().getName() + MLUtile.getRes(AtsAcrossStoreResEnum.TheSupportPartyLeaderCanNotBeEmpty, ctx);
        }
        AtsAcrossStoreSopportInfo storeSopportInfo = new AtsAcrossStoreSopportInfo();
        if (CoreBaseUtile.getId(billInfo) != null) {
            AtsAcrossStoreSopportCollection atsAcrossStoreSopportCollection = AtsAcrossStoreSopportFactory.getLocalInstance(ctx).getAtsAcrossStoreSopportCollection("where id ='" + CoreBaseUtile.getId(billInfo).toString() + "'");
            if (!atsAcrossStoreSopportCollection.isEmpty() && !"submit".equals(billInfo.get("actionSSC"))) {
                storeSopportInfo = atsAcrossStoreSopportCollection.get(0);
                storeSopportInfo.getSpts().addCollection(billInfo.getSpts());
            } else {
                storeSopportInfo = this.getAtsStoreSopportInfoBybillInfo(ctx, storeSopportInfo, billInfo);
            }
        } else {
            storeSopportInfo = this.getAtsStoreSopportInfoBybillInfo(ctx, storeSopportInfo, billInfo);
        }
        AtsAcrossStoreRptUtils atsAcrossStoreRptUtils = new AtsAcrossStoreRptUtils();
        StringBuffer msg = new StringBuffer();
        String errorMsg = atsAcrossStoreRptUtils.validateComplete(ctx, storeSopportInfo);
        if (!StringUtils.isEmpty((CharSequence)errorMsg)) {
            return errorMsg;
        }
        msg.append(AtsAcrossStoreRptUtils.verifySupportParameter(ctx, storeSopportInfo));
        msg.append(atsAcrossStoreRptUtils.checkscheduIsOFFDay(ctx, storeSopportInfo));
        msg.append(atsAcrossStoreRptUtils.checkRepeat(ctx, storeSopportInfo));
        return msg.toString();
    }

    private AtsAcrossStoreSopportInfo getAtsStoreSopportInfoBybillInfo(Context ctx, AtsAcrossStoreSopportInfo storeSopportInfo, AtsAcrossStoreSopportInfo billInfo) {
        if (null == billInfo) {
            return storeSopportInfo;
        }
        storeSopportInfo.getSpts().addCollection(billInfo.getSpts());
        storeSopportInfo.getEntries().addCollection(billInfo.getEntries());
        storeSopportInfo.setCollaborativeState(billInfo.getCollaborativeState());
        storeSopportInfo.setNeedCollaborator(billInfo.isNeedCollaborator());
        storeSopportInfo.setCollaborator(billInfo.getCollaborator());
        storeSopportInfo.setId(billInfo.getId());
        storeSopportInfo.setDocumentType(billInfo.getDocumentType());
        storeSopportInfo.setCcPerson(billInfo.getCcPerson());
        storeSopportInfo.setBillSourceType(billInfo.getBillSourceType());
        storeSopportInfo.setHrOrgUnit(billInfo.getHrOrgUnit());
        storeSopportInfo.setRemark(billInfo.getRemark());
        storeSopportInfo.setSupportType(billInfo.isSupportType());
        return storeSopportInfo;
    }

    public String validateComplete(Context ctx, AtsAcrossStoreSopportInfo billInfo) throws BOSException {
        if (billInfo.getEntries() == null || billInfo.getEntries().isEmpty()) {
            return MLUtile.getRes(AtsAcrossStoreResEnum.EntriesCanNotBeEmpty, ctx);
        }
        if (!(billInfo.getSpts() != null && !billInfo.getSpts().isEmpty() || "submit".equals(billInfo.get("actionSSC")) && billInfo.isNeedCollaborator())) {
            return MLUtile.getRes(AtsAcrossStoreResEnum.InformationEntryCanNotBeEmpty, ctx);
        }
        HashMap<String, AtsAcrossStoreSptEntryInfo> stringAtsAcrossStoreSptEntryInfoHashMap = new HashMap<String, AtsAcrossStoreSptEntryInfo>();
        Map<String, Integer> sortByLableMark = this.getSortByLableMark(ctx, billInfo);
        String errorMsg = "";
        for (int i = 0; i < billInfo.getEntries().size(); ++i) {
            if (billInfo.isSupportType() && billInfo.getEntries().get(i).getScheduleShift() == null) {
                return MLUtile.getRes((ResourceEnum)AtsAcrossStoreResEnum.Line, ctx, i + 1) + MLUtile.getRes(AtsAcrossStoreResEnum.ShiftsCanNotBeEmpty, ctx);
            }
            if (billInfo.getEntries().get(i).getAttPosition() == null) {
                return MLUtile.getRes((ResourceEnum)AtsAcrossStoreResEnum.Line, ctx, i + 1) + MLUtile.getRes(AtsAcrossStoreResEnum.SupportPositionsCanNotBeEmpty, ctx);
            }
            errorMsg = this.checkRestTime(ctx, billInfo.getEntries().get(i), i);
            if (StringUtils.isNotEmpty((CharSequence)errorMsg)) {
                return errorMsg;
            }
            stringAtsAcrossStoreSptEntryInfoHashMap.put(billInfo.getEntries().get(i).getId().toString(), billInfo.getEntries().get(i));
        }
        Map<String, Map<String, java.util.Date>> startTimeAndEndTime = this.getStartTimeAndEndTime(ctx, billInfo);
        HashSet personAndAttendenceDate = new HashSet();
        StringBuffer personAndAttendenceDateMsg = new StringBuffer();
        for (int i = 0; i < billInfo.getSpts().size(); ++i) {
            if (billInfo.getSpts().get(i).getPerson() == null) {
                boolean afterEnd;
                Map<String, java.util.Date> stringDateMap = startTimeAndEndTime.get(billInfo.getSpts().get(i).getEntryBill().getId().toString());
                boolean beforeStart = stringDateMap.get("StartDate").compareTo(billInfo.getSpts().get(i).getAttendanceDate()) != 1;
                boolean bl = afterEnd = stringDateMap.get("EndDate").compareTo(billInfo.getSpts().get(i).getAttendanceDate()) != -1;
                if (beforeStart && afterEnd) {
                    if (billInfo.getSpts().get(i).getPerson() == null && !billInfo.isNeedCollaborator()) {
                        return MLUtile.getRes((ResourceEnum)AtsAcrossStoreResEnum.Line, ctx, sortByLableMark.get(billInfo.getSpts().get(i).getLabelMark())) + MLUtile.getRes(AtsAcrossStoreResEnum.InformationEntrySupportStaffCanNotBeEmpty, ctx);
                    }
                } else {
                    billInfo.getSpts().removeObject(i);
                    --i;
                    continue;
                }
            }
            if (billInfo.getSpts().get(i).getAttPosition() == null) {
                return MLUtile.getRes((ResourceEnum)AtsAcrossStoreResEnum.Line, ctx, sortByLableMark.get(billInfo.getSpts().get(i).getLabelMark())) + MLUtile.getRes(AtsAcrossStoreResEnum.TheSupportPostCanNotBeEmpty, ctx);
            }
            if (billInfo.getSpts().get(i).getSupportLeader() == null && !billInfo.isNeedCollaborator()) {
                return MLUtile.getRes((ResourceEnum)AtsAcrossStoreResEnum.Line, ctx, sortByLableMark.get(billInfo.getSpts().get(i).getLabelMark())) + MLUtile.getRes(AtsAcrossStoreResEnum.TheSupportPartyLeaderCanNotBeEmpty, ctx);
            }
            for (int k = i + 1; k < billInfo.getSpts().size(); ++k) {
                String person1 = CoreBaseUtile.getId(billInfo.getSpts().get(i).getPerson());
                String person2 = CoreBaseUtile.getId(billInfo.getSpts().get(k).getPerson());
                if (StringUtils.isEmpty((CharSequence)person1) || StringUtils.isEmpty((CharSequence)person2)) continue;
                Timestamp startTime1 = billInfo.getSpts().get(i).getStartTime();
                Timestamp endTime1 = billInfo.getSpts().get(i).getEndTime();
                Timestamp startTime2 = billInfo.getSpts().get(k).getStartTime();
                Timestamp endTime2 = billInfo.getSpts().get(k).getEndTime();
                if (!StringUtils.equals((CharSequence)person1, (CharSequence)person2) || startTime1.getTime() >= endTime2.getTime() || endTime1.getTime() <= startTime2.getTime()) continue;
                if (!personAndAttendenceDateMsg.toString().isEmpty()) {
                    return MLUtile.getRes((ResourceEnum)AtsAcrossStoreResEnum.SupportDistributionInfoSupportRepeat, ctx, sortByLableMark.get(billInfo.getSpts().get(k).getLabelMark()));
                }
                return MLUtile.getRes((ResourceEnum)AtsAcrossStoreResEnum.SupportDistributionInfoSupportRepeat, ctx, sortByLableMark.get(billInfo.getSpts().get(k).getLabelMark()));
            }
        }
        return personAndAttendenceDateMsg.toString();
    }

    public String checkRestTime(Context ctx, AtsAcrossStoreSptEntryInfo atsAcrossStoreSptEntryInfo, int i) {
        SegmentUnitEnum offWorkDayType = atsAcrossStoreSptEntryInfo.getOffWorkDayType();
        SegmentUnitEnum onWorkDayType = atsAcrossStoreSptEntryInfo.getOnWorkDayType();
        String workOnTime = atsAcrossStoreSptEntryInfo.getWorkOnTime() + ":00";
        String offWorkTime = atsAcrossStoreSptEntryInfo.getWorkOffTime() + ":00";
        Timestamp restNextDateTime = atsAcrossStoreSptEntryInfo.getRestNextDateTime();
        Timestamp restPreDateTime = atsAcrossStoreSptEntryInfo.getRestPreDateTime();
        if (null == restNextDateTime || null == restPreDateTime) {
            return "";
        }
        String restStartTime = AtsDateUtils.getHourMinFromString(AtsDateUtils.timestampToString(restPreDateTime)) + ":00";
        String restEndTime = AtsDateUtils.getHourMinFromString(AtsDateUtils.timestampToString(restNextDateTime)) + ":00";
        if (onWorkDayType.equals((Object)offWorkDayType)) {
            if (SegmentUnitEnum.preDay.equals((Object)onWorkDayType)) {
                restStartTime = AtsDateUtils.dateShortToString(AtsDateUtils.getPreDay(atsAcrossStoreSptEntryInfo.getStartDate())) + " " + restStartTime;
                restEndTime = AtsDateUtils.dateShortToString(AtsDateUtils.getPreDay(atsAcrossStoreSptEntryInfo.getStartDate())) + " " + restEndTime;
                workOnTime = AtsDateUtils.dateShortToString(AtsDateUtils.getPreDay(atsAcrossStoreSptEntryInfo.getStartDate())) + " " + workOnTime;
                offWorkTime = AtsDateUtils.dateShortToString(AtsDateUtils.getPreDay(atsAcrossStoreSptEntryInfo.getStartDate())) + " " + offWorkTime;
            } else if (SegmentUnitEnum.currentDay.equals((Object)onWorkDayType)) {
                restStartTime = AtsDateUtils.dateShortToString(atsAcrossStoreSptEntryInfo.getStartDate()) + " " + restStartTime;
                restEndTime = AtsDateUtils.dateShortToString(atsAcrossStoreSptEntryInfo.getStartDate()) + " " + restEndTime;
                workOnTime = AtsDateUtils.dateShortToString(atsAcrossStoreSptEntryInfo.getStartDate()) + " " + workOnTime;
                offWorkTime = AtsDateUtils.dateShortToString(atsAcrossStoreSptEntryInfo.getStartDate()) + " " + offWorkTime;
            } else {
                restStartTime = AtsDateUtils.dateShortToString(AtsDateUtils.getNextDay(atsAcrossStoreSptEntryInfo.getStartDate())) + " " + restStartTime;
                restEndTime = AtsDateUtils.dateShortToString(AtsDateUtils.getNextDay(atsAcrossStoreSptEntryInfo.getStartDate())) + " " + restEndTime;
                workOnTime = AtsDateUtils.dateShortToString(AtsDateUtils.getNextDay(atsAcrossStoreSptEntryInfo.getStartDate())) + " " + workOnTime;
                offWorkTime = AtsDateUtils.dateShortToString(AtsDateUtils.getNextDay(atsAcrossStoreSptEntryInfo.getStartDate())) + " " + offWorkTime;
            }
        } else if (SegmentUnitEnum.preDay.equals((Object)onWorkDayType)) {
            restStartTime = AtsDateUtils.dateShortToString(AtsDateUtils.getPreDay(atsAcrossStoreSptEntryInfo.getStartDate())) + " " + restStartTime;
            restEndTime = AtsDateUtils.dateShortToString(AtsDateUtils.getPreDay(atsAcrossStoreSptEntryInfo.getStartDate())) + " " + restEndTime;
            workOnTime = AtsDateUtils.dateShortToString(AtsDateUtils.getPreDay(atsAcrossStoreSptEntryInfo.getStartDate())) + " " + workOnTime;
            offWorkTime = AtsDateUtils.dateShortToString(atsAcrossStoreSptEntryInfo.getStartDate()) + " " + offWorkTime;
            if (AtsDateUtils.stringToLongDate(restEndTime).before(AtsDateUtils.stringToLongDate(restStartTime))) {
                restEndTime = AtsDateUtils.dateShortToString(atsAcrossStoreSptEntryInfo.getStartDate()) + " " + restEndTime;
            }
            if (AtsDateUtils.stringToLongDate(restStartTime).before(AtsDateUtils.stringToLongDate(workOnTime))) {
                restStartTime = AtsDateUtils.dateShortToString(atsAcrossStoreSptEntryInfo.getStartDate()) + " " + restStartTime;
                restEndTime = AtsDateUtils.dateShortToString(atsAcrossStoreSptEntryInfo.getStartDate()) + " " + restEndTime;
            }
        } else if (SegmentUnitEnum.currentDay.equals((Object)onWorkDayType)) {
            restStartTime = AtsDateUtils.dateShortToString(atsAcrossStoreSptEntryInfo.getStartDate()) + " " + restStartTime;
            restEndTime = AtsDateUtils.dateShortToString(atsAcrossStoreSptEntryInfo.getStartDate()) + " " + restEndTime;
            workOnTime = AtsDateUtils.dateShortToString(atsAcrossStoreSptEntryInfo.getStartDate()) + " " + workOnTime;
            offWorkTime = AtsDateUtils.dateShortToString(AtsDateUtils.getNextDay(atsAcrossStoreSptEntryInfo.getStartDate())) + " " + offWorkTime;
            if (AtsDateUtils.stringToLongDate(restEndTime).before(AtsDateUtils.stringToLongDate(restStartTime))) {
                restEndTime = AtsDateUtils.dateShortToString(AtsDateUtils.getNextDay(atsAcrossStoreSptEntryInfo.getStartDate())) + " " + restEndTime;
            }
            if (AtsDateUtils.stringToLongDate(restStartTime).before(AtsDateUtils.stringToLongDate(workOnTime))) {
                restStartTime = AtsDateUtils.dateShortToString(AtsDateUtils.getNextDay(atsAcrossStoreSptEntryInfo.getStartDate())) + " " + restStartTime;
                restEndTime = AtsDateUtils.dateShortToString(AtsDateUtils.getNextDay(atsAcrossStoreSptEntryInfo.getStartDate())) + " " + restEndTime;
            }
        }
        double restTimes = AtsDateUtils.getTwoTimeDiffMinutes(restStartTime, restEndTime);
        if (restTimes < 0.0 || AtsDateUtils.stringToLongDate(restStartTime).before(AtsDateUtils.stringToLongDate(workOnTime)) || AtsDateUtils.stringToLongDate(restStartTime).after(AtsDateUtils.stringToLongDate(offWorkTime)) || AtsDateUtils.stringToLongDate(restEndTime).before(AtsDateUtils.stringToLongDate(workOnTime)) || AtsDateUtils.stringToLongDate(restEndTime).after(AtsDateUtils.stringToLongDate(offWorkTime))) {
            return MLUtile.getRes((ResourceEnum)AtsAcrossStoreResEnum.Line, ctx, i + 1) + MLUtile.getRes((ResourceEnum)AtsAcrossStoreResEnum.timeMessage4, ctx, "");
        }
        return "";
    }

    public Map<String, Integer> getSortByLableMark(Context ctx, AtsAcrossStoreSopportInfo billInfo) {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        if (null == billInfo.getEntries()) {
            return map;
        }
        if (null == billInfo.getSpts()) {
            return map;
        }
        billInfo.getSpts().sort("entrybill");
        int sort = 1;
        for (int i = 0; i < billInfo.getEntries().size(); ++i) {
            String entriesID = billInfo.getEntries().get(i).getId().toString();
            for (int j = 0; j < billInfo.getSpts().size(); ++j) {
                String[] split;
                String labelMark = billInfo.getSpts().get(j).getLabelMark();
                if (null == labelMark || !entriesID.equals((split = labelMark.split("_"))[1].toString()) || map.containsKey(labelMark)) continue;
                map.put(labelMark, sort);
                ++sort;
            }
        }
        return map;
    }

    public Map<String, Map<String, java.util.Date>> getStartTimeAndEndTime(Context ctx, AtsAcrossStoreSopportInfo billInfo) {
        HashMap<String, Map<String, java.util.Date>> entriesDate = new HashMap<String, Map<String, java.util.Date>>();
        if (billInfo.getEntries() == null) {
            return entriesDate;
        }
        for (int i = 0; i < billInfo.getEntries().size(); ++i) {
            HashMap<String, java.util.Date> tempDate = new HashMap<String, java.util.Date>();
            tempDate.put("StartDate", billInfo.getEntries().get(i).getStartDate());
            tempDate.put("EndDate", billInfo.getEntries().get(i).getEndDate());
            entriesDate.put(billInfo.getEntries().get(i).getId().toString(), tempDate);
        }
        return entriesDate;
    }

    public static Map<String, java.util.Date> getMinStartTimeAndMaxEndTime(Context ctx, AtsAcrossStoreSopportInfo billInfo) {
        HashMap<String, java.util.Date> entriesDate = new HashMap<String, java.util.Date>();
        if (billInfo.getEntries() == null) {
            return entriesDate;
        }
        java.util.Date startDate = null;
        java.util.Date endDate = null;
        for (int i = 0; i < billInfo.getEntries().size(); ++i) {
            if (null == startDate) {
                startDate = billInfo.getEntries().get(i).getStartDate();
            }
            if (null == endDate) {
                endDate = billInfo.getEntries().get(i).getStartDate();
            }
            if (null != startDate && startDate.after(billInfo.getEntries().get(i).getStartDate())) {
                startDate = billInfo.getEntries().get(i).getStartDate();
            }
            if (null == endDate || !endDate.before(billInfo.getEntries().get(i).getEndDate())) continue;
            endDate = billInfo.getEntries().get(i).getEndDate();
        }
        entriesDate.put("startDate", startDate);
        entriesDate.put("endDate", endDate);
        return entriesDate;
    }

    private AtsAcrossStoreSptsInfo createSptsInfos(Context ctx, AtsAcrossStoreSopportInfo billInfo, java.util.Date startDate, AtsAcrossStoreSptEntryInfo atsAcrossStoreSptEntryInfo, int i) {
        AtsAcrossStoreSptsInfo atsAcrossStoreSptsInfo = new AtsAcrossStoreSptsInfo();
        atsAcrossStoreSptsInfo.setBill(billInfo);
        atsAcrossStoreSptsInfo.setAttendanceDate(AtsDateUtils.getNextDay(startDate, i));
        atsAcrossStoreSptsInfo.setPosition(atsAcrossStoreSptEntryInfo.getAttPosition());
        return atsAcrossStoreSptsInfo;
    }

    private void addFildsAndSpts(Context ctx, AtsAcrossStoreSopportInfo billInfo) {
        if (billInfo.getApplyDate() == null) {
            billInfo.setApplyDate(new java.util.Date());
        }
        AtsAcrossStoreSptEntryCollection entries = billInfo.getEntries();
        for (int i = 0; i < entries.size(); ++i) {
            AtsAcrossStoreSptEntryInfo atsAcrossStoreSptEntryInfo = entries.get(i);
            int number = atsAcrossStoreSptEntryInfo.getPersonNumber();
            for (int j = 0; j < number; ++j) {
                int len = Integer.parseInt(Long.toString(AtsDateUtils.getDaysBetweenTwoDate(atsAcrossStoreSptEntryInfo.getEndDate(), atsAcrossStoreSptEntryInfo.getStartDate())));
                for (int k = 0; k < len; ++k) {
                    AtsAcrossStoreSptsInfo sptsInfo = this.createSptsInfos(ctx, billInfo, atsAcrossStoreSptEntryInfo.getStartDate(), atsAcrossStoreSptEntryInfo, k + 1);
                    billInfo.getSpts().add(sptsInfo);
                }
            }
        }
        billInfo.getSpts();
    }

    private AttendanceFileHISInfo getFilsFromMap(Context ctx, String personId, java.util.Date date) {
        String otDate = AtsDateUtils.dateShortToString(date);
        AttendanceFileHISInfo hisInfo = this.atsFileHisMap.get(personId + "_" + otDate);
        if (hisInfo == null || hisInfo.isEmpty()) {
            hisInfo = this.getAttendanceFileHISInfoByDate(ctx, date, personId);
            this.atsFileHisMap.put(personId + "_" + otDate, hisInfo);
        }
        return hisInfo;
    }

    private AttendanceFileHISInfo getAttendanceFileHISInfoByDate(Context ctx, java.util.Date date, String personId) {
        return new AttendanceFileHISInfo();
    }

    public void verifyDoubleToList(Context ctx, List<AtsAcrossStoreSptsInfo> atsAcrossStoreSptsInfos, AtsAcrossStoreSptsInfo sptsInfo, PersonInfo person) throws BOSException {
        if (atsAcrossStoreSptsInfos == null || atsAcrossStoreSptsInfos.size() == 0) {
            return;
        }
        for (AtsAcrossStoreSptsInfo verifiedInfo : atsAcrossStoreSptsInfos) {
            if (verifiedInfo.getStartTime().compareTo(sptsInfo.getEndTime()) >= 0 || verifiedInfo.getEndTime().compareTo(sptsInfo.getStartTime()) <= 0) continue;
            throw new BOSException("");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private AtsAcrossStoreSptsInfo createSptsInfo(Context ctx, AtsAcrossStoreSopportInfo entry, AtsAcrossStoreSptEntryInfo entryInfo, java.util.Date calDate) throws BOSException {
        SegmentUnitEnum onWorkDayType = entryInfo.getOnWorkDayType();
        String onWorkTime = AtsDateUtils.getTimeFromLongString(AtsDateUtils.dateLongToString(entryInfo.getOnWorkTime()));
        SegmentUnitEnum offWorkDayType = entryInfo.getOffWorkDayType();
        String offWorkTime = AtsDateUtils.getTimeFromLongString(AtsDateUtils.dateLongToString(entryInfo.getOffWorkTime()));
        if (entryInfo.getWorkTime().compareTo(BigDecimal.ZERO) <= 0) {
            throw new BOSException(MLUtile.getRes((ResourceEnum)AtsAcrossStoreResEnum.workTimeNot0, ctx, ""));
        }
        AtsAcrossStoreSptsInfo storeSptsInfo = new AtsAcrossStoreSptsInfo();
        storeSptsInfo.setAttendanceDate(calDate);
        storeSptsInfo.setWorkTime(entryInfo.getWorkTime());
        storeSptsInfo.setRestTime(entryInfo.getSegmentInRest());
        storeSptsInfo.setEntryBill(entryInfo);
        if (offWorkDayType.getValue() - onWorkDayType.getValue() >= 2) {
            throw new BOSException(MLUtile.getRes((ResourceEnum)AtsAcrossStoreResEnum.timeMessage3, ctx, ""));
        }
        java.util.Date onStartTime = calDate;
        java.util.Date offStartTime = calDate;
        if (onWorkDayType.getValue() == 0) {
            onStartTime = AtsAcrossStoreRptUtils.createPreDate(onStartTime, onWorkTime);
        } else if (onWorkDayType.getValue() == 1) {
            onStartTime = AtsAcrossStoreRptUtils.createNowDate(onStartTime, onWorkTime);
        } else if (onWorkDayType.getValue() == 2) {
            onStartTime = AtsAcrossStoreRptUtils.createNextDate(onStartTime, onWorkTime);
        }
        if (offWorkDayType.getValue() == 0) {
            offStartTime = AtsAcrossStoreRptUtils.createPreDate(offStartTime, offWorkTime);
        } else if (offWorkDayType.getValue() == 1) {
            offStartTime = AtsAcrossStoreRptUtils.createNowDate(offStartTime, offWorkTime);
        } else if (offWorkDayType.getValue() == 2) {
            offStartTime = AtsAcrossStoreRptUtils.createNextDate(offStartTime, offWorkTime);
        }
        long workTimes = offStartTime.getTime() - onStartTime.getTime();
        if (workTimes < 0L) {
            throw new BOSException(MLUtile.getRes((ResourceEnum)AtsAcrossStoreResEnum.timeMessage3, ctx, ""));
        }
        storeSptsInfo.setStartTime(new Timestamp(onStartTime.getTime()));
        storeSptsInfo.setEndTime(new Timestamp(offStartTime.getTime()));
        if (entryInfo.getRestPreDateTime() == null || entryInfo.getRestNextDateTime() == null) {
            return storeSptsInfo;
        }
        String restPreDateTime = AtsDateUtils.getTimeFromLongString(AtsDateUtils.dateLongToString(entryInfo.getRestPreDateTime()));
        String restNextDateTime = AtsDateUtils.getTimeFromLongString(AtsDateUtils.dateLongToString(entryInfo.getRestNextDateTime()));
        java.util.Date restStartTime = calDate;
        java.util.Date restEndTime = calDate;
        if (onWorkDayType == offWorkDayType) {
            if (onWorkDayType.getValue() == 0) {
                restStartTime = AtsAcrossStoreRptUtils.createPreDate(restStartTime, restPreDateTime);
                restEndTime = AtsAcrossStoreRptUtils.createPreDate(restEndTime, restNextDateTime);
            } else if (onWorkDayType.getValue() == 1) {
                restStartTime = AtsAcrossStoreRptUtils.createNowDate(restStartTime, restPreDateTime);
                restEndTime = AtsAcrossStoreRptUtils.createNowDate(restEndTime, restNextDateTime);
            } else {
                restStartTime = AtsAcrossStoreRptUtils.createNextDate(restStartTime, restPreDateTime);
                restEndTime = AtsAcrossStoreRptUtils.createNextDate(restEndTime, restNextDateTime);
            }
        } else {
            java.util.Date restStartTime1 = calDate;
            java.util.Date restEndTime1 = calDate;
            java.util.Date restStartTime2 = calDate;
            java.util.Date restEndTime2 = calDate;
            if (onWorkDayType.getValue() == 0) {
                restStartTime1 = AtsAcrossStoreRptUtils.createPreDate(restStartTime1, restPreDateTime);
                restEndTime1 = AtsAcrossStoreRptUtils.createPreDate(restEndTime1, restNextDateTime);
                restStartTime2 = AtsAcrossStoreRptUtils.createNowDate(restStartTime2, restPreDateTime);
                restEndTime2 = AtsAcrossStoreRptUtils.createNowDate(restEndTime2, restNextDateTime);
                if (restEndTime1.getTime() - restStartTime1.getTime() > 0L && restStartTime1.getTime() >= onStartTime.getTime() && restStartTime1.getTime() <= offStartTime.getTime() && restEndTime1.getTime() >= onStartTime.getTime() && restEndTime1.getTime() <= offStartTime.getTime()) {
                    restStartTime = restStartTime1;
                    restEndTime = restEndTime1;
                } else if (restEndTime2.getTime() - restStartTime2.getTime() > 0L && restStartTime2.getTime() >= onStartTime.getTime() && restStartTime2.getTime() <= offStartTime.getTime() && restEndTime2.getTime() >= onStartTime.getTime() && restEndTime2.getTime() <= offStartTime.getTime()) {
                    restStartTime = restStartTime2;
                    restEndTime = restEndTime2;
                } else {
                    if (restEndTime2.getTime() - restStartTime1.getTime() <= 0L || restStartTime1.getTime() < onStartTime.getTime() || restStartTime1.getTime() > offStartTime.getTime() || restEndTime2.getTime() < onStartTime.getTime() || restEndTime2.getTime() > offStartTime.getTime()) throw new BOSException(MLUtile.getRes((ResourceEnum)AtsAcrossStoreResEnum.timeMessage4, ctx, ""));
                    restStartTime = restStartTime1;
                    restEndTime = restEndTime2;
                }
            } else if (onWorkDayType.getValue() == 1) {
                restStartTime1 = AtsAcrossStoreRptUtils.createNowDate(restStartTime1, restPreDateTime);
                restEndTime1 = AtsAcrossStoreRptUtils.createNowDate(restEndTime1, restNextDateTime);
                restStartTime2 = AtsAcrossStoreRptUtils.createNextDate(restStartTime2, restPreDateTime);
                restEndTime2 = AtsAcrossStoreRptUtils.createNextDate(restEndTime2, restNextDateTime);
                if (restEndTime1.getTime() - restStartTime1.getTime() > 0L && restStartTime1.getTime() >= onStartTime.getTime() && restStartTime1.getTime() <= offStartTime.getTime() && restEndTime1.getTime() >= onStartTime.getTime() && restEndTime1.getTime() <= offStartTime.getTime()) {
                    restStartTime = restStartTime1;
                    restEndTime = restEndTime1;
                } else if (restEndTime2.getTime() - restStartTime2.getTime() > 0L && restStartTime2.getTime() >= onStartTime.getTime() && restStartTime2.getTime() <= offStartTime.getTime() && restEndTime2.getTime() >= onStartTime.getTime() && restEndTime2.getTime() <= offStartTime.getTime()) {
                    restStartTime = restStartTime2;
                    restEndTime = restEndTime2;
                } else {
                    if (restEndTime2.getTime() - restStartTime1.getTime() <= 0L || restStartTime1.getTime() < onStartTime.getTime() || restStartTime1.getTime() > offStartTime.getTime() || restEndTime2.getTime() < onStartTime.getTime() || restEndTime2.getTime() > offStartTime.getTime()) throw new BOSException(MLUtile.getRes((ResourceEnum)AtsAcrossStoreResEnum.timeMessage4, ctx, ""));
                    restStartTime = restStartTime1;
                    restEndTime = restEndTime2;
                }
            }
        }
        long restTimes = restEndTime.getTime() - restStartTime.getTime();
        if (restTimes < 0L || restStartTime.getTime() < onStartTime.getTime() || restStartTime.getTime() > offStartTime.getTime() || restEndTime.getTime() < onStartTime.getTime() || restEndTime.getTime() > offStartTime.getTime()) {
            throw new BOSException(MLUtile.getRes((ResourceEnum)AtsAcrossStoreResEnum.timeMessage4, ctx, ""));
        }
        storeSptsInfo.setBill(entry);
        storeSptsInfo.setRestStartTime(new Timestamp(restStartTime.getTime()));
        storeSptsInfo.setRestEndTime(new Timestamp(restEndTime.getTime()));
        storeSptsInfo.setRealWorkTime(storeSptsInfo.getWorkTime());
        return storeSptsInfo;
    }

    public static java.util.Date createPreDate(java.util.Date calDate, String timeString) {
        return AtsDateUtils.stringToLongDate(AtsDateUtils.dateShortToString(AtsDateUtils.getPreDay(calDate)) + " " + timeString);
    }

    public static java.util.Date createNextDate(java.util.Date calDate, String timeString) {
        return AtsDateUtils.stringToLongDate(AtsDateUtils.dateShortToString(AtsDateUtils.getNextDay(calDate)) + " " + timeString);
    }

    public static java.util.Date createNowDate(java.util.Date calDate, String timeString) {
        return AtsDateUtils.stringToLongDate(AtsDateUtils.dateShortToString(calDate) + " " + timeString);
    }

    private void initSptRepeatSql(Context ctx) {
        StringBuilder sql = new StringBuilder();
        sql.append("select sop.fid, sop.fnumber,p.fname" + MLUtile.getMlFlag(ctx) + " as name,spts.FAttendanceDate,entry.FOnWorkTime,entry.FOnWorkDayType,entry.FOffWorkTime,entry.FOffWorkDayType,entry.FworkOnTime,entry.FworkoffTime \n").append("from T_ATS_AtsAcrossStoreSpts spts inner join T_ATS_AtsAcrossStoreSptEntry entry on entry.fid = spts.FEntryBillID \n").append("inner join T_ATS_AtsAcrossStoreSopport sop on sop.fid = entry.FBillId \n").append("left join T_BD_Person p on spts.fpersonid= p.fid \n").append("where spts.FPersonID = ? and ( \n").append(" (spts.FAttendanceDate >= ? and spts.FAttendanceDate <=? ) \n").append(") \n").append(" and sop.fbillState <> 0  and sop.fbillState <> 4; ");
        this.sptRepeatSql = sql.toString();
    }

    private void initScheduleShiftRepeatSql(Context ctx) {
        StringBuilder sql = new StringBuilder();
        sql.append("select sst.fid, sst.FAttendDate,p.fname" + MLUtile.getMlFlag(ctx) + " as name,item.FPreDateTime,item.FNextDateTime \n").append("from T_HR_ATS_ScheduleShiftItem item inner join T_HR_ATS_ScheduleShift sst on sst.fid = item.FGroupID \n").append("left join T_BD_Person p on sst.fproposerId= p.fid \n").append("where sst.fproposerId = ? and ( \n").append(" (item.FPreDateTime <? and item.FPreDateTime >= ?) \n").append(" or (item.FNextDateTime <= ? and item.FNextDateTime > ?) \n").append(" or (item.FPreDateTime < ? and item.FNextDateTime > ?) \n").append("); ");
        this.scheduleShiftRepeatSql = sql.toString();
    }

    private void initTripRepeatSql(Context ctx) {
        StringBuilder sql = new StringBuilder();
        sql.append("select bill.fid, bill.fnumber,p.fname" + MLUtile.getMlFlag(ctx) + " as name,entry.FRealTripStartTime,entry.FRealTripEndTime \n").append("from T_HR_ATS_TripBillEntry entry inner join T_HR_ATS_TripBill bill on bill.fid = entry.FBillID \n").append("left join T_BD_Person p on entry.fpersonid= p.fid \n").append("where entry.FPersonID = ? and ( \n").append(" (entry.FRealTripStartTime <? and entry.FRealTripStartTime >= ?) \n").append(" or (entry.FRealTripEndTime <= ? and entry.FRealTripEndTime > ?) \n").append(" or (entry.FRealTripStartTime < ? and entry.FRealTripEndTime > ?) \n").append(") \n").append(" and bill.fbillState <> 0; ");
        this.tripRepeatSql = sql.toString();
    }

    private void initOTRepeatSql(Context ctx) {
        StringBuilder sql = new StringBuilder();
        sql.append("select bill.fid, bill.fnumber,p.fname" + MLUtile.getMlFlag(ctx) + " as name,entry.FStartTime,entry.FEndTime \n").append("from T_HR_ATS_OverTimeBillEntry entry inner join T_HR_ATS_OverTimeBill bill on bill.fid = entry.FBillID \n").append("left join T_BD_Person p on entry.fpersonid= p.fid \n").append("where entry.FPersonID = ? and ( \n").append(" (entry.FStartTime <? and entry.FStartTime >= ?) \n").append(" or (entry.FEndTime <= ? and entry.FEndTime > ?) \n").append(" or (entry.FStartTime < ? and entry.FEndTime > ?) \n").append(") \n").append(" and bill.fbillState <> 0; ");
        this.oTRepeatSql = sql.toString();
    }

    public String checkRepeat(Context ctx, AtsAcrossStoreSopportInfo billInfo) {
        this.initSptRepeatSql(ctx);
        this.initScheduleShiftRepeatSql(ctx);
        this.initTripRepeatSql(ctx);
        this.initOTRepeatSql(ctx);
        AtsAcrossStoreSptEntryCollection entries = billInfo.getEntries();
        AtsAcrossStoreSptsCollection spts = billInfo.getSpts();
        String msg = "";
        HashSet<String> personids = new HashSet<String>();
        for (int i = 0; i < billInfo.getSpts().size(); ++i) {
            if (billInfo.getSpts().get(i).getPerson() == null) continue;
            personids.add(billInfo.getSpts().get(i).getPerson().getId().toString());
        }
        Map<String, java.util.Date> minStartTimeAndMaxEndTime = AtsAcrossStoreRptUtils.getMinStartTimeAndMaxEndTime(ctx, billInfo);
        if (null == personids || personids.size() == 0) {
            return msg;
        }
        Map<String, AttendanceFileInfo> atsFileHisMap = AtsServerUtils.getAttendanceFileInfoByPersonId(ctx, AtsUtil.convertSetToString(personids), AtsDateUtils.dateShortToString(minStartTimeAndMaxEndTime.get("startDate")), AtsDateUtils.dateShortToString(minStartTimeAndMaxEndTime.get("endDate")));
        for (int index = 0; index < entries.size(); ++index) {
            AtsAcrossStoreSptEntryInfo entryInfo = entries.get(index);
            for (int num = 0; num < spts.size(); ++num) {
                AtsAcrossStoreSptsInfo storeSptsInfo = spts.get(num);
                if (!StringUtils.equals((CharSequence)CoreBaseUtile.getId(storeSptsInfo.getEntryBill()), (CharSequence)CoreBaseUtile.getId(entryInfo.getId())) || storeSptsInfo.getPerson() == null) continue;
                AttendanceFileInfo hisInfo = atsFileHisMap.get(AtsScheduleShiftUtil.getKey(storeSptsInfo.getPerson().getId().toString(), AtsDateUtils.dateShortToString(storeSptsInfo.getAttendanceDate())));
                if (hisInfo == null) {
                    try {
                        PersonInfo personInfo = PersonFactory.getLocalInstance((Context)ctx).getPersonInfo((IObjectPK)new ObjectUuidPK(storeSptsInfo.getPerson().getId().toString()));
                        return MLUtile.getRes((ResourceEnum)AtsAcrossStoreResEnum.noFile, ctx, personInfo.getName());
                    }
                    catch (BOSException personInfo) {
                    }
                    catch (EASBizException personInfo) {
                        // empty catch block
                    }
                }
                try {
                    msg = msg + this.checkSptParam(ctx, storeSptsInfo, entryInfo, billInfo);
                    msg = msg + this.checkSptRepeat(ctx, storeSptsInfo, entryInfo, billInfo);
                    msg = msg + this.checkTripRepeat(ctx, storeSptsInfo, entryInfo, billInfo);
                    msg = msg + this.checkOTRepeat(ctx, storeSptsInfo, entryInfo, billInfo);
                    continue;
                }
                catch (BOSException e) {
                    e.printStackTrace();
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return new AtsCommonBizException(AtsCommonBizException.SAVEFAIL).toString();
                }
            }
        }
        return msg;
    }

    private String checkSptParam(Context ctx, AtsAcrossStoreSptsInfo storeSptsInfo, AtsAcrossStoreSptEntryInfo entryInfo, AtsAcrossStoreSopportInfo billInfo) {
        return "";
    }

    private String checkSptRepeat(Context ctx, AtsAcrossStoreSptsInfo storeSptsInfo, AtsAcrossStoreSptEntryInfo entryInfo, AtsAcrossStoreSopportInfo billInfo) throws BOSException, SQLException, BOSException {
        java.util.Date attendanceDate = storeSptsInfo.getAttendanceDate();
        Calendar cal = Calendar.getInstance();
        cal.setTime(attendanceDate);
        cal.add(5, -1);
        java.util.Date preDate = cal.getTime();
        cal.setTime(attendanceDate);
        cal.add(5, 1);
        java.util.Date nextDate = cal.getTime();
        Object[] params = new Object[]{storeSptsInfo.getPerson().getId().toString(), new Date(preDate.getTime()), new Date(nextDate.getTime())};
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)this.sptRepeatSql, (Object[])params);
        String msg = "";
        entryInfo.getOffWorkDayType();
        entryInfo.getOffWorkTime();
        Timestamp realOnWorkTime = this.getRealWorkTime(attendanceDate, entryInfo.getOnWorkDayType().getValue(), HRTimeWebUtils.timestampToString(entryInfo.getOnWorkTime()).substring(11, 16));
        Timestamp realOffWorkTime = this.getRealWorkTime(attendanceDate, entryInfo.getOffWorkDayType().getValue(), HRTimeWebUtils.timestampToString(entryInfo.getOffWorkTime()).substring(11, 16));
        if (rs != null && rs.size() > 0) {
            while (rs.next()) {
                String mfid;
                String fidCmpString = rs.getString("fid") == null ? "" : rs.getString("fid");
                if (fidCmpString.equalsIgnoreCase(mfid = billInfo.getId() == null ? "" : billInfo.getId().toString())) continue;
                Date atDate = rs.getDate("FAttendanceDate");
                int onWorkDayType = rs.getInt("FOnWorkDayType");
                Timestamp onWorkTime = rs.getTimestamp("FOnWorkTime");
                int offWorkDayType = rs.getInt("FOffWorkDayType");
                Timestamp offWorkTime = rs.getTimestamp("FOffWorkTime");
                Timestamp realOnWorkTimeData = this.getRealWorkTime(atDate, onWorkDayType, HRTimeWebUtils.timestampToString(onWorkTime).substring(11, 16));
                Timestamp realOffWorkTimeData = this.getRealWorkTime(atDate, offWorkDayType, HRTimeWebUtils.timestampToString(offWorkTime).substring(11, 16));
                if (realOffWorkTime.getTime() <= realOnWorkTimeData.getTime() || realOnWorkTime.getTime() >= realOffWorkTimeData.getTime()) continue;
                String errorMsg = MLUtile.getRes((ResourceEnum)AtsAcrossStoreResEnum.ExistsStore, ctx, rs.getString("fnumber"), rs.getString("name") + "," + AtsDateUtils.dateShortToString(atDate) + "-" + rs.getString("FworkOnTime") + "," + AtsDateUtils.dateShortToString(atDate) + "-" + rs.getString("fworkOffTime")) + "<br/>";
                return errorMsg;
            }
        }
        return msg;
    }

    public Timestamp getRealWorkTime(java.util.Date attendanceDate, int workDayType, String timeStr) {
        String atdtString = HRTimeWebUtils.dateShortToString(attendanceDate);
        Calendar cal = Calendar.getInstance();
        cal.setTime(attendanceDate);
        cal.add(5, -1);
        java.util.Date preDate = cal.getTime();
        cal.setTime(attendanceDate);
        cal.add(5, 1);
        java.util.Date nextDate = cal.getTime();
        String atdtPreDayString = HRTimeWebUtils.dateShortToString(preDate);
        String atdtNextDayString = HRTimeWebUtils.dateShortToString(nextDate);
        String realTime = ScheduleShiftItemHelper.getRealTimeByType(workDayType, atdtString, atdtPreDayString, atdtNextDayString, timeStr);
        return HRTimeWebUtils.stringToTimestamp(realTime);
    }

    public HashMap<String, Timestamp> getRealRestTimeAndWorkTime(Context ctx, java.util.Date attendanceDate, AtsAcrossStoreSptEntryInfo atsAcrossStoreSptEntryInfo) {
        SegmentUnitEnum offWorkDayType = atsAcrossStoreSptEntryInfo.getOffWorkDayType();
        SegmentUnitEnum onWorkDayType = atsAcrossStoreSptEntryInfo.getOnWorkDayType();
        String workOnTime = atsAcrossStoreSptEntryInfo.getWorkOnTime() + ":00";
        String offWorkTime = atsAcrossStoreSptEntryInfo.getWorkOffTime() + ":00";
        Timestamp restNextDateTime = atsAcrossStoreSptEntryInfo.getRestNextDateTime();
        Timestamp restPreDateTime = atsAcrossStoreSptEntryInfo.getRestPreDateTime();
        HashMap<String, Timestamp> endAndStartRestTime = new HashMap<String, Timestamp>();
        if (null == restNextDateTime || null == restPreDateTime) {
            return endAndStartRestTime;
        }
        String restStartTime = AtsDateUtils.getHourMinFromString(AtsDateUtils.timestampToString(restPreDateTime)) + ":00";
        String restEndTime = AtsDateUtils.getHourMinFromString(AtsDateUtils.timestampToString(restNextDateTime)) + ":00";
        if (onWorkDayType.equals((Object)offWorkDayType)) {
            if (SegmentUnitEnum.preDay.equals((Object)onWorkDayType)) {
                restStartTime = AtsDateUtils.dateShortToString(AtsDateUtils.getPreDay(attendanceDate)) + " " + restStartTime;
                restEndTime = AtsDateUtils.dateShortToString(AtsDateUtils.getPreDay(attendanceDate)) + " " + restEndTime;
                workOnTime = AtsDateUtils.dateShortToString(AtsDateUtils.getPreDay(attendanceDate)) + " " + workOnTime;
                offWorkTime = AtsDateUtils.dateShortToString(AtsDateUtils.getPreDay(attendanceDate)) + " " + offWorkTime;
            } else if (SegmentUnitEnum.currentDay.equals((Object)onWorkDayType)) {
                restStartTime = AtsDateUtils.dateShortToString(attendanceDate) + " " + restStartTime;
                restEndTime = AtsDateUtils.dateShortToString(attendanceDate) + " " + restEndTime;
                workOnTime = AtsDateUtils.dateShortToString(attendanceDate) + " " + workOnTime;
                offWorkTime = AtsDateUtils.dateShortToString(attendanceDate) + " " + offWorkTime;
            } else {
                restStartTime = AtsDateUtils.dateShortToString(AtsDateUtils.getNextDay(attendanceDate)) + " " + restStartTime;
                restEndTime = AtsDateUtils.dateShortToString(AtsDateUtils.getNextDay(attendanceDate)) + " " + restEndTime;
                workOnTime = AtsDateUtils.dateShortToString(AtsDateUtils.getNextDay(attendanceDate)) + " " + workOnTime;
                offWorkTime = AtsDateUtils.dateShortToString(AtsDateUtils.getNextDay(attendanceDate)) + " " + offWorkTime;
            }
        } else if (SegmentUnitEnum.preDay.equals((Object)onWorkDayType)) {
            restStartTime = AtsDateUtils.dateShortToString(AtsDateUtils.getPreDay(attendanceDate)) + " " + restStartTime;
            restEndTime = AtsDateUtils.dateShortToString(AtsDateUtils.getPreDay(attendanceDate)) + " " + restEndTime;
            workOnTime = AtsDateUtils.dateShortToString(AtsDateUtils.getPreDay(attendanceDate)) + " " + workOnTime;
            offWorkTime = AtsDateUtils.dateShortToString(attendanceDate) + " " + offWorkTime;
            if (AtsDateUtils.stringToLongDate(restEndTime).before(AtsDateUtils.stringToLongDate(restStartTime))) {
                restEndTime = AtsDateUtils.dateShortToString(attendanceDate) + " " + restEndTime;
            }
            if (AtsDateUtils.stringToLongDate(restStartTime).before(AtsDateUtils.stringToLongDate(workOnTime))) {
                restStartTime = AtsDateUtils.dateShortToString(attendanceDate) + " " + restStartTime;
                restEndTime = AtsDateUtils.dateShortToString(attendanceDate) + " " + restEndTime;
            }
        } else if (SegmentUnitEnum.currentDay.equals((Object)onWorkDayType)) {
            restStartTime = AtsDateUtils.dateShortToString(attendanceDate) + " " + restStartTime;
            restEndTime = AtsDateUtils.dateShortToString(attendanceDate) + " " + restEndTime;
            workOnTime = AtsDateUtils.dateShortToString(attendanceDate) + " " + workOnTime;
            offWorkTime = AtsDateUtils.dateShortToString(AtsDateUtils.getNextDay(attendanceDate)) + " " + offWorkTime;
            if (AtsDateUtils.stringToLongDate(restEndTime).before(AtsDateUtils.stringToLongDate(restStartTime))) {
                restEndTime = AtsDateUtils.dateShortToString(AtsDateUtils.getNextDay(attendanceDate)) + " " + restEndTime;
            }
            if (AtsDateUtils.stringToLongDate(restStartTime).before(AtsDateUtils.stringToLongDate(workOnTime))) {
                restStartTime = AtsDateUtils.dateShortToString(AtsDateUtils.getNextDay(attendanceDate)) + " " + restStartTime;
                restEndTime = AtsDateUtils.dateShortToString(AtsDateUtils.getNextDay(attendanceDate)) + " " + restEndTime;
            }
        }
        endAndStartRestTime.put("restStartTime", AtsDateUtils.stringToTimestamp(restStartTime));
        endAndStartRestTime.put("restEndTime", AtsDateUtils.stringToTimestamp(restEndTime));
        endAndStartRestTime.put("workOnTime", AtsDateUtils.stringToTimestamp(workOnTime));
        endAndStartRestTime.put("offWorkTime", AtsDateUtils.stringToTimestamp(offWorkTime));
        return endAndStartRestTime;
    }

    private void checkScheduleShiftRepeat(Context ctx, AtsAcrossStoreSptsInfo storeSptsInfo, AtsAcrossStoreSptEntryInfo entryInfo, AtsAcrossStoreSopportInfo billInfo) throws BOSException, SQLException, BOSException {
        java.util.Date attendanceDate = storeSptsInfo.getAttendanceDate();
        String personId = storeSptsInfo.getPerson().getId().toString();
        Object[] params = new Object[]{personId, storeSptsInfo.getEndTime(), storeSptsInfo.getStartTime(), storeSptsInfo.getEndTime(), storeSptsInfo.getStartTime(), storeSptsInfo.getStartTime(), storeSptsInfo.getEndTime()};
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)this.scheduleShiftRepeatSql, (Object[])params);
        if (rs != null && rs.size() > 0 && rs.next()) {
            String fAttendDate = rs.getString("FAttendDate");
            if (!StringUtils.isEmpty((CharSequence)fAttendDate)) {
                fAttendDate = fAttendDate.split(" ")[0];
            }
            String errorMsg = MLUtile.getRes((ResourceEnum)AtsAcrossStoreResEnum.ExistsSchedule, ctx, fAttendDate, rs.getString("name") + "," + AtsDateUtils.dateLongToString(rs.getDate("FPreDateTime")) + "," + AtsDateUtils.dateLongToString(rs.getDate("FNextDateTime"))) + "<br/>";
            throw new BOSException(errorMsg);
        }
        AttendanceFileHISInfo fileHISInfo = this.getFilsFromMap(ctx, personId, attendanceDate);
        if (fileHISInfo == null) {
            return;
        }
        if (fileHISInfo.getIsAttendance().getValue().equalsIgnoreCase("1")) {
            return;
        }
        String otDate = AtsDateUtils.dateShortToString(attendanceDate);
        ScheduleShiftCollection coll = this.scheduleShiftMap.get(personId + "_" + otDate);
        String preDay = AtsDateUtils.getPreDay(AtsDateUtils.timestampToShortString(storeSptsInfo.getStartTime()));
        String nextDay = AtsDateUtils.getNextDay(AtsDateUtils.timestampToShortString(storeSptsInfo.getEndTime()));
        if (coll == null) {
            coll = AtsScheduleShiftUtil.getScheduleShiftCollByPriority(ctx, personId, preDay, nextDay);
            if (coll != null && coll.size() > 0) {
                this.scheduleShiftMap.put(personId + "_" + otDate, coll);
            } else if (coll != null && coll.size() > 0) {
                this.scheduleShiftMap.put(personId + "_" + otDate, coll);
            }
        }
        if (coll == null || coll.size() == 0) {
            return;
        }
        for (int m = 0; m < coll.size(); ++m) {
            ScheduleShiftInfo scheduleShiftInfo = coll.get(m);
            ScheduleShiftItemCollection scheduleShiftItemColl = scheduleShiftInfo.getItems();
            int itemsSize = scheduleShiftItemColl.size();
            if (null == scheduleShiftItemColl || itemsSize <= 0) continue;
            scheduleShiftItemColl.sort("segment");
            for (int item_i = 0; item_i < itemsSize; ++item_i) {
                ScheduleShiftItemInfo scheduleShiftItemInfo = scheduleShiftItemColl.get(item_i);
                Timestamp preDateTime = scheduleShiftItemInfo.getPreDateTime();
                Timestamp nextDateTime = scheduleShiftItemInfo.getNextDateTime();
                if (preDateTime.compareTo(storeSptsInfo.getEndTime()) >= 1 || storeSptsInfo.getStartTime().compareTo(nextDateTime) >= 0) continue;
                PersonInfo personInfo = null;
                try {
                    personInfo = PersonFactory.getLocalInstance((Context)ctx).getPersonInfo((IObjectPK)new ObjectUuidPK(personId));
                }
                catch (EASBizException eASBizException) {
                    // empty catch block
                }
                String errorMsg = MLUtile.getRes((ResourceEnum)AtsAcrossStoreResEnum.ExistsSchedule, ctx, AtsDateUtils.dateShortToString(attendanceDate), personInfo == null ? storeSptsInfo.getPerson().getName() : personInfo.getName() + "," + AtsDateUtils.dateLongToString(preDateTime) + ",." + AtsDateUtils.dateLongToString(nextDateTime)) + "<br/>";
                throw new BOSException(errorMsg);
            }
        }
    }

    private String checkTripRepeat(Context ctx, AtsAcrossStoreSptsInfo storeSptsInfo, AtsAcrossStoreSptEntryInfo entryInfo, AtsAcrossStoreSopportInfo billInfo) throws BOSException, SQLException, BOSException {
        Object[] params = new Object[]{storeSptsInfo.getPerson().getId().toString(), storeSptsInfo.getEndTime(), storeSptsInfo.getStartTime(), storeSptsInfo.getEndTime(), storeSptsInfo.getStartTime(), storeSptsInfo.getStartTime(), storeSptsInfo.getEndTime()};
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)this.tripRepeatSql, (Object[])params);
        String msg = "";
        if (rs != null && rs.size() > 0 && rs.next()) {
            String errorMsg = MLUtile.getRes((ResourceEnum)AtsAcrossStoreResEnum.ExistsTrip, ctx, rs.getString("fnumber"), rs.getString("name") + "," + AtsDateUtils.dateLongToString(rs.getDate("FRealTripStartTime")) + "," + AtsDateUtils.dateLongToString(rs.getDate("FRealTripEndTime"))) + "<br/>";
            return errorMsg;
        }
        return msg;
    }

    private String checkOTRepeat(Context ctx, AtsAcrossStoreSptsInfo storeSptsInfo, AtsAcrossStoreSptEntryInfo entryInfo, AtsAcrossStoreSopportInfo billInfo) throws BOSException, SQLException, BOSException {
        Object[] params = new Object[]{storeSptsInfo.getPerson().getId().toString(), storeSptsInfo.getEndTime(), storeSptsInfo.getStartTime(), storeSptsInfo.getEndTime(), storeSptsInfo.getStartTime(), storeSptsInfo.getStartTime(), storeSptsInfo.getEndTime()};
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)this.oTRepeatSql, (Object[])params);
        String msg = "";
        if (rs != null && rs.size() > 0 && rs.next()) {
            String errorMsg = MLUtile.getRes((ResourceEnum)AtsAcrossStoreResEnum.ExistsOT, ctx, rs.getString("fnumber"), rs.getString("name") + "," + AtsDateUtils.dateLongToString(rs.getDate("FStartTime")) + "," + AtsDateUtils.dateLongToString(rs.getDate("FEndTime"))) + "<br/>";
            return errorMsg;
        }
        return msg;
    }

    public String checkPermItem(Context ctx, CoreBaseInfo model, Map<String, Object> initData) {
        try {
            IValidator validator = ValidateUtile.validateWithReturn(ctx, model);
            boolean banEdit = !validator.validate();
            IObjectCollection entries = (IObjectCollection)model.get("entries");
            if (AtsCollectionUtile.isEmpty(entries) || banEdit) {
                if (PlateformType.SELF.equals(validator.getValidateCtx().getPlateformType())) {
                    return MLUtile.getRes("com.kingdee.eas.hr.ats.validatorResEnum", "NOT_SELF", ctx);
                }
                return MLUtile.getRes("com.kingdee.eas.hr.ats.validatorResEnum", "NO_BILL_PERM", ctx);
            }
            if (!validator.validate()) {
                StringBuffer tipBuf = new StringBuffer();
                for (BatchMessageTipsBody tip : validator.getValidateCtx().getBatchMessageTipsHeader().getResult()) {
                    tipBuf.append(tip.getMuitTipsMessage()).append("\r\n");
                }
                initData.put("pageErrorMsg", tipBuf.toString());
            }
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        return null;
    }

    public String checkBeforeSave(Context ctx, CoreBaseInfo model, Map<String, Object> initData) {
        String errorMsg = this.checkPermItem(ctx, model, initData);
        if (!StringUtils.isEmpty((CharSequence)errorMsg)) {
            return errorMsg;
        }
        AtsAcrossStoreSopportInfo billInfo = (AtsAcrossStoreSopportInfo)model;
        this.addFildsAndSpts(ctx, billInfo);
        return null;
    }

    public static Set<String> getCollaborators(AtsAcrossStoreSopportInfo bill) throws EASBizException {
        AtsAcrossStoreSptsCollection spts;
        AtsAcrossStoreSptsCollection atsAcrossStoreSptsCollection = spts = bill == null ? null : bill.getSpts();
        if (AtsCollectionUtile.isEmpty((IObjectCollection)spts)) {
            return Collections.emptySet();
        }
        HashSet<String> taskPersons = new HashSet<String>();
        int size = spts.size();
        for (int i = 0; i < size; ++i) {
            AtsAcrossStoreSptsInfo item = spts.get(i);
            if (item.getSupportLeader() == null) {
                throw new HRCommonException(HRCommonException.EXCEPTION_MSG, new Object[]{"SupportLeader can not be null"});
            }
            taskPersons.add(CoreBaseUtile.getId(item.getSupportLeader()));
        }
        return taskPersons;
    }

    public static Set<String> getCollaboratUsers(Context ctx, AtsAcrossStoreSopportInfo bill) throws EASBizException {
        Set<String> taskPersons = AtsAcrossStoreRptUtils.getCollaborators(bill);
        if (AtsCollectionUtile.isEmpty(taskPersons)) {
            return Collections.emptySet();
        }
        HashSet<String> taskUsers = new HashSet<String>(taskPersons.size());
        EntityViewInfo view = AtsViewUtile.getViewBySelector(new String[]{"id"});
        AtsViewUtile.getViewByFilter("person", taskPersons, CompareType.INCLUDE, view);
        AtsViewUtile.getViewByFilter("isDelete", 0, CompareType.EQUALS, view);
        AtsViewUtile.getViewByFilter("isForbidden", 0, CompareType.EQUALS, view);
        try {
            int size;
            UserCollection users = UserFactory.getLocalInstance((Context)ctx).getUserCollection(view);
            int n = size = users == null ? 0 : users.size();
            for (int i = 0; i < size; ++i) {
                taskUsers.add(CoreBaseUtile.getId(users.get(i)));
            }
        }
        catch (BOSException e) {
            throw new HRCommonException(HRCommonException.EXCEPTION_MSG, (Throwable)e, new Object[]{e.getMessage()});
        }
        return taskUsers;
    }

    public static boolean checkCollaboratLeaderComplete(Context ctx, AtsAcrossStoreSopportInfo bill) throws EASBizException, BOSException {
        AtsAcrossStoreSptsCollection spts;
        AtsAcrossStoreSptsCollection atsAcrossStoreSptsCollection = spts = bill == null ? null : bill.getSpts();
        if (AtsCollectionUtile.isEmpty((IObjectCollection)spts)) {
            return true;
        }
        int size = spts.size();
        for (int i = 0; i < size; ++i) {
            if (spts.get(i).getSupportLeader() != null) continue;
            PositionInfo positionInfo = PositionFactory.getLocalInstance((Context)ctx).getPositionInfo((IObjectPK)new ObjectUuidPK(CoreBaseUtile.getId(spts.get(i).getAttPosition())));
            throw new HRCommonException(HRCommonException.EXCEPTION_MSG, new Object[]{MLUtile.getRes(RESOURCE_ML, "noSupportLeader", ctx, positionInfo.getName())});
        }
        return true;
    }

    public static boolean checkCollaboratComplete(Context ctx, AtsAcrossStoreSopportInfo bill, boolean fromWf) throws EASBizException, BOSException {
        AtsAcrossStoreSptsCollection spts;
        AtsAcrossStoreSptsCollection atsAcrossStoreSptsCollection = spts = bill == null ? null : bill.getSpts();
        if (AtsCollectionUtile.isEmpty((IObjectCollection)spts)) {
            return true;
        }
        String personId = CoreBaseUtile.getId(SHRBillUtil.getCurrPersonInfoNew(ctx));
        int size = spts.size();
        for (int i = 0; i < size; ++i) {
            boolean validate;
            AtsAcrossStoreSptsInfo item = spts.get(i);
            boolean bl = validate = fromWf || StringUtils.equals((CharSequence)personId, (CharSequence)CoreBaseUtile.getId(item.getSupportLeader()));
            if (!validate || item.getPerson() != null) continue;
            PositionInfo positionInfo = PositionFactory.getLocalInstance((Context)ctx).getPositionInfo((IObjectPK)new ObjectUuidPK(CoreBaseUtile.getId(item.getAttPosition())));
            throw new HRCommonException(HRCommonException.EXCEPTION_MSG, new Object[]{MLUtile.getRes(RESOURCE_ML, "noSupportor", ctx, positionInfo.getName(), AtsCommonUtile.formateDate(item.getAttendanceDate()))});
        }
        return true;
    }

    public static boolean validateSupportEntry(Context ctx, AtsAcrossStoreSopportInfo bill) throws EASBizException, BOSException {
        AtsAcrossStoreSptsCollection spts;
        AtsAcrossStoreSptsCollection atsAcrossStoreSptsCollection = spts = bill == null ? null : bill.getSpts();
        if (AtsCollectionUtile.isEmpty((IObjectCollection)spts)) {
            return true;
        }
        String personId = CoreBaseUtile.getId(SHRBillUtil.getCurrPersonInfoNew(ctx));
        return true;
    }

    public static boolean validateCollaborateEntry(Context ctx, AtsAcrossStoreSopportInfo bill, String coActivityJobId) throws EASBizException, BOSException {
        AtsAcrossStoreSptEntryCollection entries;
        AtsAcrossStoreSptsCollection spts;
        AtsAcrossStoreSptsCollection atsAcrossStoreSptsCollection = spts = bill == null ? null : bill.getSpts();
        if (AtsCollectionUtile.isEmpty((IObjectCollection)spts) || StringUtils.isBlank((CharSequence)coActivityJobId) || AtsAcrossStoreRptUtils.isJobFromWF(ctx, coActivityJobId)) {
            return true;
        }
        HashSet<String> entryBills = new HashSet<String>();
        String personId = CoreBaseUtile.getId(SHRBillUtil.getCurrPersonInfoNew(ctx));
        for (int i = 0; i < spts.size(); ++i) {
            if (StringUtils.equals((CharSequence)personId, (CharSequence)CoreBaseUtile.getId(spts.get(i).getSupportLeader()))) {
                entryBills.add(CoreBaseUtile.getId(spts.get(i).getEntryBill()));
                continue;
            }
            spts.removeObject(i);
            --i;
        }
        if (AtsCollectionUtile.isEmpty((IObjectCollection)spts)) {
            throw new HRCommonException(HRCommonException.EXCEPTION_MSG, new Object[]{MLUtile.getRes("com.kingdee.eas.hr.ats.validatorResEnum", "NO_BILL_PERM", ctx)});
        }
        AtsAcrossStoreSptEntryCollection atsAcrossStoreSptEntryCollection = entries = bill == null ? null : bill.getEntries();
        if (entries != null) {
            for (int i = 0; i < entries.size(); ++i) {
                if (entryBills.contains(CoreBaseUtile.getId(entries.get(i)))) continue;
                entries.removeObject(i);
                --i;
            }
        }
        return true;
    }

    public static void distributeTask(Context ctx, AtsAcrossStoreSopportInfo bill) throws EASBizException, BOSException {
        if (!AtsAcrossStoreRptUtils.canDistributing(ctx, CoreBaseUtile.getId(bill))) {
            throw new HRCommonException(HRCommonException.EXCEPTION_MSG, new Object[]{MLUtile.getRes(RESOURCE_ML, "canDistribute", ctx)});
        }
        bill.put("_savePartial", true);
        AtsAcrossStoreRptUtils.checkCollaboratLeaderComplete(ctx, bill);
        Set<String> users = AtsAcrossStoreRptUtils.getCollaboratUsers(ctx, bill);
        bill.setCollaborativeState(CollaborativeStateEnum.AUDITING);
        AtsAcrossStoreSopportFactory.getLocalInstance(ctx).save((CoreBaseInfo)bill);
        if (AtsCollectionUtile.isEmpty(users)) {
            return;
        }
        String billId = CoreBaseUtile.getId(bill);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("priority", "20");
        params.put("model", bill);
        params.put(IS_DISTRIBUTE_TASK, true);
        ICoActivityJobOptFacade iCoActivityJobOptFacade = CoActivityJobOptFacadeFactory.getLocalInstance((Context)ctx);
        for (String user : users) {
            params.put(DISTRIBUTE_USER, Collections.singleton(user));
            iCoActivityJobOptFacade.createJobByActivity(null, "atsAcrossStoreSopport", billId, params);
        }
    }

    public static void sscSave(Context ctx, AtsAcrossStoreSopportInfo bill) throws EASBizException, BOSException {
        bill.put("_savePartial", true);
        AtsAcrossStoreSopportFactory.getLocalInstance(ctx).save((CoreBaseInfo)bill);
    }

    public static void updateDistributeState(Context ctx, AtsAcrossStoreSopportInfo bill, CollaborativeStateEnum state) throws EASBizException, BOSException {
        AtsAcrossStoreSopportInfo newBill = new AtsAcrossStoreSopportInfo();
        newBill.setCollaborativeState(state);
        newBill.setId(bill.getId());
        SelectorItemCollection selectors = AtsViewUtile.getSelectors("collaborativeState");
        AtsAcrossStoreSopportFactory.getLocalInstance(ctx).updatePartial(newBill, selectors);
    }

    public static void dealTask(Context ctx, AtsAcrossStoreSopportInfo bill) throws BOSException, EASBizException {
        CoActivityExecutorCollection executors = AtsAcrossStoreRptUtils.getActExecutors(ctx, CoreBaseUtile.getId(bill), CoreBaseUtile.getId(ContextUtil.getCurrentUserInfo((Context)ctx)), CoActivityState.DEALING);
        if (AtsCollectionUtile.isEmpty((IObjectCollection)executors)) {
            return;
        }
        AtsAcrossStoreRptUtils.dealTask(ctx, bill, CoreBaseUtile.getId(executors.get(0).getCoActivity()));
    }

    public static void dealTask(Context ctx, AtsAcrossStoreSopportInfo bill, String jobId) throws BOSException, EASBizException {
        bill.put("_savePartial", true);
        boolean jobFromWF = AtsAcrossStoreRptUtils.isJobFromWF(ctx, jobId);
        if (StringUtils.isNotBlank((CharSequence)jobId) && jobFromWF) {
            AtsAcrossStoreRptUtils.checkCollaboratLeaderComplete(ctx, bill);
        }
        AtsAcrossStoreBillHelper billHelper = new AtsAcrossStoreBillHelper();
        billHelper.setCtx(ctx);
        String errorMsg = billHelper.validateBill(bill);
        if (StringUtils.isNotBlank((CharSequence)errorMsg)) {
            throw new HRCommonException(HRCommonException.EXCEPTION_MSG, new Object[]{errorMsg});
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("jobId", jobId);
        params.put("billId", CoreBaseUtile.getId(bill));
        params.put("activityId", ID_ACTIVITY_SOPPORT);
        if (!bill.getBoolean("useSSCDeal")) {
            CoActivityJobOptFacadeFactory.getLocalInstance((Context)ctx).pass(params);
        }
        bill.setCollaborativeState(jobFromWF ? CollaborativeStateEnum.AUDITED : CollaborativeStateEnum.AUDITING);
        AtsAcrossStoreSopportFactory.getLocalInstance(ctx).save((CoreBaseInfo)bill);
        CoActivityExecutorCollection executors = jobFromWF ? null : AtsAcrossStoreRptUtils.getActExecutors(ctx, CoreBaseUtile.getId(bill), null, CoActivityState.DEALING);
        HashSet<String> coActivityJobIds = new HashSet<String>();
        if (executors != null && executors.size() > 0) {
            String coActivityJobId;
            for (int i = 0; i < executors.size(); ++i) {
                if (StringUtils.equals((CharSequence)jobId, (CharSequence)CoreBaseUtile.getId(executors.get(i).getCoActivity()))) continue;
                coActivityJobIds.add(CoreBaseUtile.getId(executors.get(i).getCoActivity()));
            }
            String string = coActivityJobId = coActivityJobIds.size() == 1 ? (String)coActivityJobIds.iterator().next() : null;
            if (AtsAcrossStoreRptUtils.isJobFromWF(ctx, coActivityJobId)) {
                params.put("jobId", coActivityJobId);
                params.put("realUser", AtsAcrossStoreRptUtils.getCoJobCreator(ctx, jobId));
                CoActivityJobOptFacadeFactory.getLocalInstance((Context)ctx).pass(params);
                AtsAcrossStoreRptUtils.updateDistributeState(ctx, bill, CollaborativeStateEnum.AUDITED);
            }
        }
    }

    public static String getCoJobCreator(Context ctx, String jobId) throws EASBizException, BOSException {
        EntityViewInfo evi = AtsViewUtile.getViewBySelector(new String[]{"creator"});
        AtsViewUtile.getViewByFilter("id", (Object)jobId, evi);
        CoActivityJobCollection colls = CoActivityJobFactory.getLocalInstance((Context)ctx).getCoActivityJobCollection(evi);
        if (!AtsCollectionUtile.isEmpty((IObjectCollection)colls)) {
            return CoreBaseUtile.getId(colls.get(0).getCreator());
        }
        return null;
    }

    public static CoActivityExecutorCollection getActExecutors(Context ctx, String billId, String userId, CoActivityState state) throws EASBizException, BOSException {
        EntityViewInfo evi = AtsViewUtile.getViewBySelector(new String[]{"coActivity.id"});
        AtsViewUtile.getViewByFilter("coActivity.billID", (Object)billId, evi);
        AtsViewUtile.getViewByFilter("coActivity.jobState", "12", CompareType.NOTEQUALS, evi);
        AtsViewUtile.getViewByFilter("coActivity.bussAttrID", (Object)ID_ACTIVITY_SOPPORT, evi);
        if (state != null) {
            AtsViewUtile.getViewByFilter("state", (Object)state, evi);
        }
        if (StringUtils.isNotBlank((CharSequence)userId)) {
            AtsViewUtile.getViewByFilter("user", (Object)userId, evi);
        }
        CoActivityExecutorCollection executorInfo = CoActivityExecutorFactory.getLocalInstance((Context)ctx).getCoActivityExecutorCollection(evi);
        return executorInfo;
    }

    public static boolean isJobFromWF(Context ctx, String coActivityJobId) throws BOSException {
        if (StringUtils.isBlank((CharSequence)coActivityJobId)) {
            return false;
        }
        String sql = "select top 1 fid from T_SHR_ActivityJobInfo where FJobId=? and FIsCreateByWorkflow=1";
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{coActivityJobId});
        return rowSet.size() > 0;
    }

    public static boolean canDistributing(Context ctx, String billId) throws BOSException, EASBizException {
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)billId));
        filterInfo.getFilterItems().add(new FilterItemInfo("collaborativeState", (Object)0));
        return AtsAcrossStoreSopportFactory.getLocalInstance(ctx).exists(filterInfo);
    }

    public static void pushCollaboratMsg(Context ctx, AtsAcrossStoreSopportInfo bill) throws EASBizException {
        Set<String> persons = AtsAcrossStoreRptUtils.getCollaborators(bill);
        if (AtsCollectionUtile.isEmpty(persons)) {
            return;
        }
        YZJMsgPusher msgPusher = new YZJMsgPusher();
        msgPusher.setCtx(ctx).setPushConfigName(PUSH_CONFIG_SOPPORT);
        msgPusher.setMsgBody("please process bill");
        for (String personId : persons) {
            try {
                msgPusher.setTargetId(personId).postMessage();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static void pushCollaboratMsg(Context ctx, String targetId, String msgBody, Map params) {
        YZJMsgPusher msgPusher = new YZJMsgPusher();
        msgPusher.setCtx(ctx).setPushConfigName(PUSH_CONFIG_SOPPORT);
        msgPusher.setMsgBody(StringUtils.isBlank((CharSequence)msgBody) ? "please process bill" : msgBody);
        try {
            msgPusher.setTargetId(targetId).setParams(params).postMessage();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public AtsAcrossStoreSopportInfo needCollaboratorComplete(Context ctx, AtsAcrossStoreSopportInfo billInfo) {
        if (billInfo.isNeedCollaborator()) {
            for (int i = 0; i < billInfo.getSpts().size(); ++i) {
                billInfo.getSpts().get(i).setPerson(null);
                billInfo.getSpts().get(i).setAdminOrgUnit(null);
                billInfo.getSpts().get(i).setSupportLeader(null);
            }
        }
        return billInfo;
    }
}

