/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.ats.util;

import com.kingdee.bos.Context;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.sql.KSqlUtil;
import com.kingdee.eas.hr.ats.util.AtsDateUtils;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.log4j.Logger;

public class AtsBaseUtils {
    private static Logger logger = Logger.getLogger(AtsBaseUtils.class);
    private static Map<String, Object> sessionMap = new HashMap<String, Object>();
    public static Integer maxPageSize = 8000;
    private static Map<String, Object> DBTypeMap = new ConcurrentHashMap<String, Object>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int getDbType(Context ctx) {
        int dbType = 0;
        Connection cn = null;
        try {
            String dbTypeKey = ctx.getAIS() + ContextUtil.getDbType((Context)ctx);
            if (DBTypeMap.get(dbTypeKey) == null) {
                cn = EJBFactory.getConnection((Context)ctx);
                dbType = KSqlUtil.getDbType((Connection)cn);
                DBTypeMap.put(dbTypeKey, dbType);
            } else {
                dbType = (Integer)DBTypeMap.get(dbTypeKey);
            }
            if (null == cn) return dbType;
        }
        catch (Exception e) {
            e.printStackTrace();
            return dbType;
        }
        finally {
            if (null != cn) {
                SQLUtils.cleanup(cn);
            }
        }
        SQLUtils.cleanup((Connection)cn);
        return dbType;
    }

    public void executeBatch(Context ctx, ArrayList sqlLists) {
        this.executeBatch(ctx, sqlLists.toArray());
    }

    public void executeBatch(Context ctx, Object[] sqlLists) {
        long stime = System.currentTimeMillis();
        if (sqlLists == null || sqlLists.length == 0) {
            return;
        }
        Connection conn = null;
        Statement stmt = null;
        ResultSet rs = null;
        int i = 0;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            stmt = conn.createStatement();
            for (i = 0; i < sqlLists.length; ++i) {
                stmt.addBatch(sqlLists[i].toString());
            }
            stmt.executeBatch();
        }
        catch (Exception e) {
            System.out.println("transaction rollback\u3002\u3002\u3002\u3002\u3002");
            e.printStackTrace();
            if (i < sqlLists.length) {
                logger.error((Object)("error SQL sqlLists[" + i + "]:" + sqlLists[i].toString()));
            }
            throw new RuntimeException(e);
        }
        finally {
            this.closeAllDBSource(conn, stmt, rs);
            long dtime = System.currentTimeMillis();
            long useTime = dtime - stime;
            if (useTime < 1000L) {
                System.out.println("~~~~~~~~~~ Effect: " + sqlLists.length + " Rows; ~~~~~~~~~~ exeQuerySql Time: " + useTime + " ms.");
            } else {
                String timeStr = AtsDateUtils.formatLongToTimeStr(useTime);
                System.out.println("~~~~~~~~~~ Effect: " + sqlLists.length + " Rows; ~~~~~~~~~~ exeQuerySql Time: " + timeStr);
            }
        }
    }

    public void closeAllDBSource(Connection conn, Statement stmt, ResultSet rs) {
        try {
            if (rs != null) {
                rs.close();
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
            e.printStackTrace();
        }
        try {
            if (stmt != null) {
                stmt.close();
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
            e.printStackTrace();
        }
        try {
            if (conn != null) {
                conn.close();
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
            e.printStackTrace();
        }
    }
}

