/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.ats.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.workflow.engine.core.Mutex;
import com.kingdee.bos.workflow.exception.AlreadyInProcessQueueException;
import com.kingdee.eas.basedata.org.HROrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.ats.AtsLeaveBillEntryCollection;
import com.kingdee.eas.hr.ats.AtsLeaveBillEntryFactory;
import com.kingdee.eas.hr.ats.AtsLeaveBillEntryInfo;
import com.kingdee.eas.hr.ats.AtsLeaveBillFactory;
import com.kingdee.eas.hr.ats.AtsLeaveBillInfo;
import com.kingdee.eas.hr.ats.AttendanceCenterInfo;
import com.kingdee.eas.hr.ats.CancelLeaveBillFactory;
import com.kingdee.eas.hr.ats.CancelLeaveBillInfo;
import com.kingdee.eas.hr.ats.ChangeTypeEnum;
import com.kingdee.eas.hr.ats.HolidayLimitBillTypeEnum;
import com.kingdee.eas.hr.ats.HolidayLimitChangeType;
import com.kingdee.eas.hr.ats.HolidayLimitCollection;
import com.kingdee.eas.hr.ats.HolidayLimitDetailCollection;
import com.kingdee.eas.hr.ats.HolidayLimitDetailFactory;
import com.kingdee.eas.hr.ats.HolidayLimitDetailInfo;
import com.kingdee.eas.hr.ats.HolidayLimitDetailStatusEnum;
import com.kingdee.eas.hr.ats.HolidayLimitFactory;
import com.kingdee.eas.hr.ats.HolidayLimitInfo;
import com.kingdee.eas.hr.ats.HolidayPolicyFactory;
import com.kingdee.eas.hr.ats.HolidayPolicyInfo;
import com.kingdee.eas.hr.ats.HolidayTypeUnitEnum;
import com.kingdee.eas.hr.ats.IHolidayLimit;
import com.kingdee.eas.hr.ats.IHolidayLimitDetail;
import com.kingdee.eas.hr.ats.OperActionEnum;
import com.kingdee.eas.hr.ats.OperTypeEnum;
import com.kingdee.eas.hr.ats.app.AtsLeaveBillControllerBean;
import com.kingdee.eas.hr.ats.app.HolidayLimitDetailControllerBean;
import com.kingdee.eas.hr.ats.dataLog.control.LogControlCenter;
import com.kingdee.eas.hr.ats.dataLog.factory.DataLogControlFactory;
import com.kingdee.eas.hr.ats.dataLog.observer.impl.AtsLimitDataLogObserver;
import com.kingdee.eas.hr.ats.decimalPlace.strategy.IDecimalPlaceStrategy;
import com.kingdee.eas.hr.ats.decimalPlace.strategy.impl.DecimalPlaceOperationSystem;
import com.kingdee.eas.hr.ats.holidayLimit.generate.manager.GenHolidayLimitManager;
import com.kingdee.eas.hr.ats.lightapp.util.AtsLeaveBillLimit;
import com.kingdee.eas.hr.ats.util.AtsServerUtils;
import com.kingdee.eas.hr.ats.util.SHRBillServerUtil;
import com.kingdee.eas.hr.emp.PersonPositionInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class AtsLeaveBillLimitServer {
    private IDecimalPlaceStrategy decimalPlacesSystem = new DecimalPlaceOperationSystem();
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.hr.ats.util.AtsLeaveBillLimitServer");

    public AtsLeaveBillLimitServer() {
        if (null == this.decimalPlacesSystem) {
            this.decimalPlacesSystem = new DecimalPlaceOperationSystem();
        }
    }

    public int operatorYearVacationLimit(Context ctx, BOSUuid billId) throws EASBizException, BOSException {
        AtsLeaveBillInfo billInfo = AtsLeaveBillFactory.getLocalInstance(ctx).getAtsLeaveBillInfo((IObjectPK)new ObjectUuidPK(billId.toString()));
        AtsLeaveBillEntryCollection entryCollection = billInfo.getEntries();
        BigDecimal leavelengthSum = BigDecimal.valueOf(0L);
        int size = entryCollection.size();
        for (int i = 0; i < size; ++i) {
            BigDecimal leavelength = entryCollection.get(i).getLeaveLength();
            leavelengthSum = leavelengthSum.add(leavelength);
        }
        AtsLeaveBillEntryInfo atsLeaveBillEntryInfo = billInfo.getEntries().get(0);
        String personId = atsLeaveBillEntryInfo.getPerson().getId().toString();
        AttendanceCenterInfo centerInfo = AtsServerUtils.getAttendanceCenterByPersonId(ctx, personId);
        HolidayPolicyInfo holidayPolicyInfo = AtsServerUtils.getHolidayPolicyByHolidayTypeId(ctx, "3T54RtSQRIqAL6cffMh60P0tUpg=");
        HolidayLimitInfo holidayLimitInfo = AtsServerUtils.getMinHolidayLimitInfoByPersonId(ctx, personId);
        HashMap<String, Object> mapBalance = new HashMap<String, Object>();
        leavelengthSum = this.decimalPlacesSystem.precisionConvert(ctx, leavelengthSum, RoundingMode.HALF_UP);
        mapBalance.put("usedLimit", leavelengthSum);
        mapBalance.put("personId", personId);
        mapBalance.put("attendanceCenterId", centerInfo.getId().toString());
        mapBalance.put("holidayPolicyId", holidayPolicyInfo.getId().toString());
        mapBalance.put("holidayPolicyUnit", (Object)holidayPolicyInfo.getUnit());
        mapBalance.put("changeValue", leavelengthSum);
        String holidayLimitId = "";
        if (holidayLimitInfo != null) {
            holidayLimitId = holidayLimitInfo.getId().toString();
        }
        mapBalance.put("holidayLimitId", holidayLimitId);
        try {
            logger.info((Object)"leave bill audited and reduct annual limit start to that person... ");
            this.updateFreezeUsedLimitNew(ctx, mapBalance, billInfo, atsLeaveBillEntryInfo);
            logger.info((Object)"leave bill audited and reduct annual limit sucess to that person... ");
            this.insertDataInfoToHolildayLimitDetail(ctx, mapBalance, billInfo.getId().toString(), HolidayLimitChangeType.deduction);
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return 0;
    }

    protected void deleteDataInfoFromHolildayLimitDetail(Context ctx, Map<String, Object> mapBalance) throws BOSException, EASBizException {
        try {
            HolidayLimitChangeType holidayLimitChangeType = (HolidayLimitChangeType)((Object)mapBalance.get("holidayLimitChangeType"));
            String leaveBillID = (String)mapBalance.get("leaveBillID");
            String personId = (String)mapBalance.get("personId");
            String sql = "  delete  from T_HR_ATS_HolidayLimitDetail where FLeaveBillID='" + leaveBillID + "'  and   FChangeType='" + holidayLimitChangeType.getValue() + "' and fproposerid='" + personId + "'";
            DbUtil.execute((Context)ctx, (String)sql);
        }
        catch (Exception e) {
            logger.info((Object)"del holiday limit detail faile\u3002");
            throw new BOSException((Throwable)e);
        }
    }

    protected void deleteDataInfoFromHolildayLimitDetailByLimitIdAndchangeType(Context ctx, Map<String, Object> mapBalance) throws BOSException, EASBizException {
        try {
            HolidayLimitChangeType holidayLimitChangeType = (HolidayLimitChangeType)((Object)mapBalance.get("holidayLimitChangeType"));
            String holidayLimitId = (String)mapBalance.get("holidayLimitId");
            String sql = "  delete  from T_HR_ATS_HolidayLimitDetail where FHolidayLimitID='" + holidayLimitId + "'  and   FChangeType='" + holidayLimitChangeType.getValue() + "' ";
            DbUtil.execute((Context)ctx, (String)sql);
        }
        catch (Exception e) {
            logger.info((Object)"del holiday limit detail faile\u3002");
            throw new BOSException((Throwable)e);
        }
    }

    protected int insertDataInfoToHolildayLimitDetail(Context ctx, Map<String, Object> mapBalance, String billId, HolidayLimitChangeType holidayLimitChangeType) {
        logger.info((Object)"record detail table start...");
        int res = 0;
        AtsLeaveBillInfo billInfo = new AtsLeaveBillInfo();
        try {
            billInfo = AtsLeaveBillFactory.getLocalInstance(ctx).getAtsLeaveBillInfo(" where id='" + billId + "'");
        }
        catch (EASBizException e1) {
            e1.printStackTrace();
        }
        catch (BOSException e1) {
            e1.printStackTrace();
        }
        HolidayLimitDetailControllerBean holidayLimitDetailControllerBean = new HolidayLimitDetailControllerBean();
        CoreBaseCollection colls = new CoreBaseCollection();
        HolidayLimitDetailInfo detailInfo = new HolidayLimitDetailInfo();
        if (mapBalance.containsKey("atsLeaveBillEntryInfo")) {
            detailInfo.setLeaveBillEntry((AtsLeaveBillEntryInfo)mapBalance.get("atsLeaveBillEntryInfo"));
        }
        String personId = (String)mapBalance.get("personId");
        PersonPositionInfo personPositionInfo = SHRBillServerUtil.getAdminOrgUnit(ctx, personId);
        detailInfo.setProposer(personPositionInfo.getPerson());
        detailInfo.setAdminOrgUnit(personPositionInfo.getPersonDep());
        detailInfo.setPosition(personPositionInfo.getPrimaryPosition());
        PersonPositionInfo position = SHRBillServerUtil.getAdminOrgUnitAndHrOrgUnit(ctx, personId);
        HROrgUnitInfo hrInfo = null;
        hrInfo = position.getHrOrgUnit();
        detailInfo.setHrOrgUnit(hrInfo);
        Calendar cal = Calendar.getInstance();
        detailInfo.setYear(cal.get(1));
        detailInfo.setChangeDate(AtsLeaveBillLimitServer.dateToTimestamp(new Date()));
        detailInfo.setCreateTime(AtsLeaveBillLimitServer.dateToTimestamp(new Date()));
        detailInfo.setChangeType(holidayLimitChangeType);
        detailInfo.setBillType(HolidayLimitBillTypeEnum.leaveBill);
        detailInfo.setLeaveBill(billInfo);
        detailInfo.setLeaveBillNumber(billInfo.getNumber());
        detailInfo.setChangeValue((BigDecimal)mapBalance.get("changeValue"));
        detailInfo.setChangeUnit((HolidayTypeUnitEnum)((Object)mapBalance.get("holidayPolicyUnit")));
        String holidayLimitId = (String)mapBalance.get("holidayLimitId");
        if (holidayLimitId != null) {
            HolidayLimitInfo limitInfo = new HolidayLimitInfo();
            limitInfo.setId(BOSUuid.read((String)holidayLimitId));
            detailInfo.setHolidayLimit(limitInfo);
        }
        detailInfo.setStatus(HolidayLimitDetailStatusEnum.valid);
        colls.add((CoreBaseInfo)detailInfo);
        try {
            if (billInfo.getId() == null) {
                AtsLeaveBillControllerBean AtsLeaveBillControllerBean2 = new AtsLeaveBillControllerBean();
                AtsLeaveBillControllerBean2.save(ctx, (CoreBaseInfo)billInfo);
            }
            holidayLimitDetailControllerBean.addnewBatchData(ctx, colls);
            res = 1;
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        logger.info((Object)"record detail table end...");
        return res;
    }

    protected int insertDataInfoToHolildayLimitDetailNew(Context ctx, Map<String, Object> mapBalance, String billId, HolidayLimitChangeType holidayLimitChangeType, AtsLeaveBillEntryInfo atsLeaveBillEntryInfo) {
        logger.info((Object)"record detail table start...");
        int res = 0;
        AtsLeaveBillInfo billInfo = new AtsLeaveBillInfo();
        try {
            billInfo = AtsLeaveBillFactory.getLocalInstance(ctx).getAtsLeaveBillInfo(" where id='" + billId + "'");
        }
        catch (EASBizException e1) {
            e1.printStackTrace();
        }
        catch (BOSException e1) {
            e1.printStackTrace();
        }
        HolidayLimitDetailControllerBean holidayLimitDetailControllerBean = new HolidayLimitDetailControllerBean();
        CoreBaseCollection colls = new CoreBaseCollection();
        HolidayLimitDetailInfo detailInfo = new HolidayLimitDetailInfo();
        String personId = (String)mapBalance.get("personId");
        PersonPositionInfo personPositionInfo = SHRBillServerUtil.getAdminOrgUnit(ctx, personId);
        detailInfo.setProposer(personPositionInfo.getPerson());
        detailInfo.setAdminOrgUnit(personPositionInfo.getPersonDep());
        detailInfo.setPosition(personPositionInfo.getPrimaryPosition());
        PersonPositionInfo position = SHRBillServerUtil.getAdminOrgUnitAndHrOrgUnit(ctx, personId);
        HROrgUnitInfo hrInfo = null;
        hrInfo = position.getHrOrgUnit();
        detailInfo.setHrOrgUnit(hrInfo);
        detailInfo.setLeaveBillEntry(atsLeaveBillEntryInfo);
        Calendar cal = Calendar.getInstance();
        detailInfo.setYear(cal.get(1));
        detailInfo.setChangeDate(AtsLeaveBillLimitServer.dateToTimestamp(new Date()));
        detailInfo.setCreateTime(AtsLeaveBillLimitServer.dateToTimestamp(new Date()));
        detailInfo.setChangeType(holidayLimitChangeType);
        detailInfo.setBillType(HolidayLimitBillTypeEnum.leaveBill);
        detailInfo.setLeaveBill(billInfo);
        detailInfo.setLeaveBillNumber(billInfo.getNumber());
        detailInfo.setChangeValue((BigDecimal)mapBalance.get("changeValue"));
        detailInfo.setChangeUnit((HolidayTypeUnitEnum)((Object)mapBalance.get("holidayPolicyUnit")));
        String holidayLimitId = (String)mapBalance.get("holidayLimitId");
        if (holidayLimitId != null) {
            HolidayLimitInfo limitInfo = new HolidayLimitInfo();
            limitInfo.setId(BOSUuid.read((String)holidayLimitId));
            detailInfo.setHolidayLimit(limitInfo);
        }
        detailInfo.setStatus(HolidayLimitDetailStatusEnum.valid);
        colls.add((CoreBaseInfo)detailInfo);
        try {
            if (billInfo.getId() == null) {
                AtsLeaveBillControllerBean AtsLeaveBillControllerBean2 = new AtsLeaveBillControllerBean();
                AtsLeaveBillControllerBean2.save(ctx, (CoreBaseInfo)billInfo);
            }
            holidayLimitDetailControllerBean.addnewBatchData(ctx, colls);
            res = 1;
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        logger.info((Object)"record detail table end...");
        return res;
    }

    protected int updateDataInfoToHolildayLimitDetail(Context ctx, Map<String, Object> mapBalance, String billId, HolidayLimitChangeType holidayLimitChangeType) {
        int res = 0;
        String holidayLimitId = (String)mapBalance.get("holidayLimitId");
        CoreBaseCollection colls = new CoreBaseCollection();
        HolidayLimitDetailCollection holidayLimitDetailCollection = new HolidayLimitDetailCollection();
        try {
            holidayLimitDetailCollection = HolidayLimitDetailFactory.getLocalInstance(ctx).getHolidayLimitDetailCollection(" where holidayLimit='" + holidayLimitId + "' and changeType='" + holidayLimitChangeType.getValue() + "' and changeValue != '" + BigDecimal.valueOf(0L) + "' ");
        }
        catch (BOSException e1) {
            e1.printStackTrace();
        }
        if (holidayLimitDetailCollection != null && holidayLimitDetailCollection.size() > 0) {
            holidayLimitDetailCollection.sort("createTime");
            HolidayLimitDetailInfo detailInfo = holidayLimitDetailCollection.get(0);
            detailInfo.setChangeDate(AtsLeaveBillLimitServer.dateToTimestamp(new Date()));
            detailInfo.setChangeValue(detailInfo.getChangeValue().subtract((BigDecimal)mapBalance.get("changeValue")));
            colls.add((CoreBaseInfo)detailInfo);
            try {
                HolidayLimitDetailControllerBean holidayLimitDetailControllerBean = new HolidayLimitDetailControllerBean();
                holidayLimitDetailControllerBean.update(ctx, colls);
                res = 1;
            }
            catch (EASBizException e) {
                e.printStackTrace();
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
        }
        return res;
    }

    public static Timestamp dateToTimestamp(Date date) {
        Timestamp ts = new Timestamp(date.getTime());
        return ts;
    }

    public int rollBackLimitBysubmitEffect(Context ctx, BOSUuid billId) throws EASBizException, BOSException, SQLException {
        AtsLeaveBillInfo billInfo = AtsLeaveBillFactory.getLocalInstance(ctx).getAtsLeaveBillInfo((IObjectPK)new ObjectUuidPK(billId.toString()));
        AtsLeaveBillEntryInfo atsLeaveBillEntryInfo = billInfo.getEntries().get(0);
        String personId = atsLeaveBillEntryInfo.getPerson().getId().toString();
        HolidayLimitDetailCollection holidayDetailCollTemp = HolidayLimitDetailFactory.getLocalInstance(ctx).getHolidayLimitDetailCollection(" select holidaylimit where LeaveBill ='" + billId.toString() + "' and changeType='" + 4 + "' and holidaylimit != null ");
        String holidayPolicyId = atsLeaveBillEntryInfo.getPolicy().getId().toString();
        HolidayPolicyInfo holidayPolicyInfo = AtsServerUtils.getHolidayPolicyInfoById(ctx, holidayPolicyId);
        String holidayTypeId = null;
        if (holidayPolicyInfo != null) {
            holidayTypeId = holidayPolicyInfo.getHolidayType().getId().toString();
        }
        HolidayLimitDetailCollection holidayLimitDetailCollection = HolidayLimitDetailFactory.getLocalInstance(ctx).getHolidayLimitDetailCollection(" where LeaveBill='" + billId.toString() + "' and changeType='" + 4 + "'");
        String holidayLimitId = null;
        for (int i = 0; i < holidayLimitDetailCollection.size(); ++i) {
            BigDecimal usedLength = holidayLimitDetailCollection.get(i).getChangeValue();
            HashMap<String, Object> mapBalance = new HashMap<String, Object>();
            usedLength = this.decimalPlacesSystem.precisionConvert(ctx, usedLength, RoundingMode.HALF_UP);
            mapBalance.put("usedLimit", usedLength);
            if (holidayLimitDetailCollection.get(i).getHolidayLimit() != null) {
                holidayLimitId = holidayLimitDetailCollection.get(i).getHolidayLimit().getId().toString();
                mapBalance.put("holidayLimitId", holidayLimitId);
            }
            mapBalance.put("leaveBillID", billId.toString());
            mapBalance.put("holidayLimitChangeType", (Object)HolidayLimitChangeType.deduction);
            try {
                if (holidayLimitId != null) {
                    logger.info((Object)"restore used limit start... ");
                    this.rollBackUsedRemainLimitNew(ctx, mapBalance, billInfo, atsLeaveBillEntryInfo);
                }
                this.deleteDataInfoFromHolildayLimitDetail(ctx, mapBalance);
                logger.info((Object)"restore used limit start... ");
                continue;
            }
            catch (EASBizException e) {
                e.printStackTrace();
                continue;
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
        }
        HolidayLimitInfo holidayLimitInfo = null;
        HolidayLimitDetailCollection holidayLimitDetailColl = new HolidayLimitDetailCollection();
        AtsLeaveBillEntryCollection atsBillEntryColl = new AtsLeaveBillEntryCollection();
        AtsLeaveBillEntryCollection atsLeaveBillEntryColl = AtsLeaveBillEntryFactory.getLocalInstance(ctx).getAtsLeaveBillEntryCollection(" where bill='" + billId.toString() + "'");
        Timestamp leaveBillStartTime = atsLeaveBillEntryColl.get(0).getBeginTime();
        Timestamp leaveBillEndTime = atsLeaveBillEntryColl.get(0).getEndTime();
        HashSet<String> holidayLimitSet = new HashSet<String>();
        for (int i = 0; i < holidayDetailCollTemp.size(); ++i) {
            holidayLimitSet.add(holidayDetailCollTemp.get(i).getHolidayLimit().getId().toString());
        }
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("id", holidayLimitSet, CompareType.INCLUDE));
        evi.setFilter(fi);
        HolidayLimitCollection holidayLimitCollection = HolidayLimitFactory.getLocalInstance(ctx).getHolidayLimitCollection(evi);
        if (holidayLimitCollection != null && holidayLimitCollection.size() > 0) {
            holidayLimitCollection.sort("cyclebegindate");
            holidayLimitCollection.sort("delaydate");
            holidayLimitInfo = holidayLimitCollection.get(0);
            Date startDate = holidayLimitInfo.getCycleBeginDate();
            Date delayDate = holidayLimitInfo.getDelayDate();
            Timestamp startTimestamp = new Timestamp(startDate.getTime());
            Timestamp delayTimestamp = new Timestamp(delayDate.getTime() + 86400000L - 1L);
            atsBillEntryColl = AtsLeaveBillEntryFactory.getLocalInstance(ctx).getAtsLeaveBillEntryCollection(" where beginTime >= '" + startTimestamp + "' and endTime <='" + delayTimestamp + "' order by beginTime");
            for (int i = 0; i < atsBillEntryColl.size(); ++i) {
                HolidayLimitDetailCollection overdraftHolidayLimitDetailColl = HolidayLimitDetailFactory.getLocalInstance(ctx).getHolidayLimitDetailCollection(" where LeaveBill ='" + atsBillEntryColl.get(i).getBill().getId().toString() + "' and changeType='" + 7 + "' and changeValue !=0 and proposer='" + personId + "' and holidayLimit !='" + holidayLimitInfo.getId().toString() + "'");
                if (overdraftHolidayLimitDetailColl.size() <= 0) continue;
                holidayLimitDetailColl.add(overdraftHolidayLimitDetailColl.get(0));
            }
        }
        AtsLeaveBillEntryInfo atsLeaveBillInfo = AtsLeaveBillEntryFactory.getLocalInstance(ctx).getAtsLeaveBillEntryInfo(" where bill='" + billId.toString() + "'");
        BigDecimal changeValue = atsLeaveBillInfo.getLeaveLength().subtract(atsLeaveBillInfo.getRealLeaveLength());
        if (holidayLimitDetailColl != null && holidayLimitDetailColl.size() > 0) {
            holidayLimitDetailColl.sort("createTime");
        }
        for (int i = 0; i < holidayLimitDetailColl.size(); ++i) {
            if (changeValue.compareTo(BigDecimal.ZERO) != 1) continue;
            BigDecimal preOverdraftLimit = holidayLimitDetailColl.get(i).getChangeValue();
            HashMap<String, Object> mapBalance = new HashMap<String, Object>();
            preOverdraftLimit = this.decimalPlacesSystem.precisionConvert(ctx, preOverdraftLimit, RoundingMode.HALF_UP);
            String nextholidayLimitId = holidayLimitDetailColl.get(i).getHolidayLimit().getId().toString();
            mapBalance.put("holidayLimitId", nextholidayLimitId);
            mapBalance.put("holidayLimitChangeType", (Object)HolidayLimitChangeType.overdraft);
            mapBalance.put("leaveBillID", holidayLimitDetailColl.get(i).getLeaveBill().getId().toString());
            try {
                if (changeValue.compareTo(preOverdraftLimit) != -1) {
                    mapBalance.put("preOverdraftLimit", preOverdraftLimit);
                    if (holidayPolicyInfo.isIsOverAutoSub()) {
                        this.rollBackOverDraftRemainLimitNew(ctx, mapBalance, billInfo, atsLeaveBillEntryInfo);
                    }
                    this.deleteDataInfoFromHolildayLimitDetail(ctx, mapBalance);
                    changeValue = changeValue.subtract(preOverdraftLimit);
                    continue;
                }
                if (changeValue.compareTo(preOverdraftLimit) != -1) continue;
                mapBalance.put("preOverdraftLimit", changeValue);
                mapBalance.put("changeValue", changeValue);
                if (holidayPolicyInfo.isIsOverAutoSub()) {
                    this.rollBackOverDraftRemainLimitNew(ctx, mapBalance, billInfo, atsLeaveBillEntryInfo);
                }
                this.updateDataInfoToHolildayLimitDetail(ctx, mapBalance, billId.toString(), HolidayLimitChangeType.overdraft);
                changeValue = changeValue.subtract(preOverdraftLimit);
                continue;
            }
            catch (EASBizException e) {
                e.printStackTrace();
                continue;
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
        }
        return 0;
    }

    public int reduceYearVacationLimit(Context ctx, BOSUuid billId) throws EASBizException, BOSException, SQLException {
        AtsLeaveBillInfo billInfo = AtsLeaveBillFactory.getLocalInstance(ctx).getAtsLeaveBillInfo("where id='" + billId.toString() + "'");
        int size = billInfo.getEntries().size();
        for (int j = 0; j < size; ++j) {
            AtsLeaveBillEntryInfo atsLeaveBillEntryInfo = billInfo.getEntries().get(j);
            String personId = atsLeaveBillEntryInfo.getPerson().getId().toString();
            String oqlTemp = " select holidaylimit  where LeaveBill ='" + billId.toString() + "' and changeType='" + 6 + "' and holidaylimit != null and proposer='" + personId + "'";
            HolidayLimitDetailCollection holidayDetailCollTemp = HolidayLimitDetailFactory.getLocalInstance(ctx).getHolidayLimitDetailCollection(oqlTemp);
            String holidayPolicyId = atsLeaveBillEntryInfo.getPolicy().getId().toString();
            HolidayPolicyInfo holidayPolicyInfo = AtsServerUtils.getHolidayPolicyInfoById(ctx, holidayPolicyId);
            String holidayTypeId = null;
            if (holidayPolicyInfo != null) {
                holidayTypeId = holidayPolicyInfo.getHolidayType().getId().toString();
            }
            BigDecimal changeValue = atsLeaveBillEntryInfo.getLeaveLength();
            BigDecimal dedChangeValue = atsLeaveBillEntryInfo.getLeaveLength();
            String oql = " where LeaveBill='" + billId.toString() + "' and changeType='" + 6 + "' and proposer='" + personId + "'";
            HolidayLimitDetailCollection holidayLimitDetailCollection = HolidayLimitDetailFactory.getLocalInstance(ctx).getHolidayLimitDetailCollection(oql);
            String holidayLimitId = null;
            for (int i = 0; i < holidayLimitDetailCollection.size(); ++i) {
                if (dedChangeValue.compareTo(BigDecimal.ZERO) != 1) continue;
                BigDecimal freezeLength = holidayLimitDetailCollection.get(i).getChangeValue();
                HashMap<String, Object> mapBalance = new HashMap<String, Object>();
                freezeLength = this.decimalPlacesSystem.precisionConvert(ctx, freezeLength, RoundingMode.HALF_UP);
                if (holidayLimitDetailCollection.get(i).getHolidayLimit() != null) {
                    holidayLimitId = holidayLimitDetailCollection.get(i).getHolidayLimit().getId().toString();
                    mapBalance.put("holidayLimitId", holidayLimitId);
                }
                mapBalance.put("changeValue", freezeLength);
                mapBalance.put("personId", personId);
                mapBalance.put("holidayPolicyUnit", (Object)holidayPolicyInfo.getUnit());
                mapBalance.put("leaveBillID", billId.toString());
                mapBalance.put("holidayLimitChangeType", (Object)HolidayLimitChangeType.freeze);
                if (dedChangeValue.compareTo(freezeLength) != -1) {
                    mapBalance.put("freezeLimit", freezeLength);
                    if (holidayLimitId != null) {
                        logger.info((Object)"restore frozen limit start... ");
                        this.rollBackFreezeRemainLimitNew(ctx, mapBalance, billInfo, atsLeaveBillEntryInfo);
                    }
                    this.deleteDataInfoFromHolildayLimitDetail(ctx, mapBalance);
                    logger.info((Object)"restore frozen limit end... ");
                    dedChangeValue = dedChangeValue.subtract(freezeLength);
                    continue;
                }
                if (dedChangeValue.compareTo(freezeLength) != -1) continue;
                mapBalance.put("freezeLimit", dedChangeValue);
                mapBalance.put("changeValue", changeValue);
                if (holidayLimitId != null) {
                    logger.info((Object)"restore frozen limit start... ");
                    this.rollBackFreezeRemainLimitNew(ctx, mapBalance, billInfo, atsLeaveBillEntryInfo);
                }
                this.updateDataInfoToHolildayLimitDetail(ctx, mapBalance, billId.toString(), HolidayLimitChangeType.freeze);
                logger.info((Object)"restore frozen limit end... ");
                dedChangeValue = dedChangeValue.subtract(freezeLength);
            }
            HolidayLimitInfo holidayLimitInfo = null;
            HolidayLimitDetailCollection holidayLimitDetailColl = new HolidayLimitDetailCollection();
            AtsLeaveBillEntryCollection atsBillEntryColl = new AtsLeaveBillEntryCollection();
            AtsLeaveBillEntryCollection atsLeaveBillEntryColl = AtsLeaveBillEntryFactory.getLocalInstance(ctx).getAtsLeaveBillEntryCollection(" where bill='" + billId.toString() + "'");
            Timestamp leaveBillStartTime = atsLeaveBillEntryColl.get(0).getBeginTime();
            Timestamp leaveBillEndTime = atsLeaveBillEntryColl.get(0).getEndTime();
            HashSet<String> holidayLimitSet = new HashSet<String>();
            for (int i = 0; i < holidayDetailCollTemp.size(); ++i) {
                holidayLimitSet.add(holidayDetailCollTemp.get(i).getHolidayLimit().getId().toString());
            }
            EntityViewInfo evi = new EntityViewInfo();
            FilterInfo fi = new FilterInfo();
            fi.getFilterItems().add(new FilterItemInfo("id", holidayLimitSet, CompareType.INCLUDE));
            evi.setFilter(fi);
            HolidayLimitCollection holidayLimitCollection = HolidayLimitFactory.getLocalInstance(ctx).getHolidayLimitCollection(evi);
            if (holidayLimitCollection != null && holidayLimitCollection.size() > 0) {
                holidayLimitCollection.sort("cyclebegindate");
                holidayLimitCollection.sort("delaydate");
                holidayLimitInfo = holidayLimitCollection.get(0);
                Date startDate = holidayLimitInfo.getCycleBeginDate();
                Date delayDate = holidayLimitInfo.getDelayDate();
                Timestamp startTimestamp = new Timestamp(startDate.getTime());
                Timestamp delayTimestamp = new Timestamp(delayDate.getTime());
                atsBillEntryColl = AtsLeaveBillEntryFactory.getLocalInstance(ctx).getAtsLeaveBillEntryCollection(" where beginTime >= '" + startTimestamp + "' and endTime <='" + delayTimestamp + "' order by beginTime");
                for (int i = 0; i < atsBillEntryColl.size(); ++i) {
                    HolidayLimitDetailCollection overdraftHolidayLimitDetailColl = HolidayLimitDetailFactory.getLocalInstance(ctx).getHolidayLimitDetailCollection(" where LeaveBill ='" + atsBillEntryColl.get(i).getBill().getId().toString() + "' and changeType='" + 7 + "' and changeValue !=0 and proposer='" + personId + "' and holidayLimit !='" + holidayLimitInfo.getId().toString() + "'");
                    if (overdraftHolidayLimitDetailColl.size() <= 0) continue;
                    holidayLimitDetailColl.add(overdraftHolidayLimitDetailColl.get(0));
                }
            }
            for (int i = 0; i < holidayLimitDetailColl.size(); ++i) {
                if (changeValue.compareTo(BigDecimal.ZERO) != 1) continue;
                BigDecimal preOverdraftLimit = holidayLimitDetailColl.get(i).getChangeValue();
                HashMap<String, Object> mapBalance = new HashMap<String, Object>();
                preOverdraftLimit = this.decimalPlacesSystem.precisionConvert(ctx, preOverdraftLimit, RoundingMode.HALF_UP);
                String nextholidayLimitId = holidayLimitDetailColl.get(i).getHolidayLimit().getId().toString();
                mapBalance.put("holidayLimitId", nextholidayLimitId);
                if (changeValue.compareTo(preOverdraftLimit) != -1) {
                    mapBalance.put("holidayLimitChangeType", (Object)HolidayLimitChangeType.overdraft);
                    mapBalance.put("leaveBillID", holidayLimitDetailColl.get(i).getLeaveBill().getId().toString());
                    mapBalance.put("preOverdraftLimit", preOverdraftLimit);
                    if (holidayPolicyInfo.isIsOverAutoSub()) {
                        this.rollBackOverDraftRemainLimitNew(ctx, mapBalance, billInfo, atsLeaveBillEntryInfo);
                    }
                    this.deleteDataInfoFromHolildayLimitDetail(ctx, mapBalance);
                    changeValue = changeValue.subtract(preOverdraftLimit);
                    continue;
                }
                if (changeValue.compareTo(preOverdraftLimit) != -1) continue;
                mapBalance.put("preOverdraftLimit", changeValue);
                mapBalance.put("changeValue", changeValue);
                if (holidayPolicyInfo.isIsOverAutoSub()) {
                    this.rollBackOverDraftRemainLimitNew(ctx, mapBalance, billInfo, atsLeaveBillEntryInfo);
                }
                this.updateDataInfoToHolildayLimitDetail(ctx, mapBalance, billId.toString(), HolidayLimitChangeType.overdraft);
                changeValue = changeValue.subtract(preOverdraftLimit);
            }
        }
        return 0;
    }

    protected void updateFreezeLimitNotPass(Context ctx, BigDecimal freezeLimit, String holidaylimitId) throws BOSException, EASBizException {
        try {
            float freezelimit = freezeLimit.floatValue();
            String sql_update = "  update  t_hr_ats_holidaylimit set  FreezeLimit='" + freezelimit + "'     where fid='" + holidaylimitId + "' ";
            DbUtil.execute((Context)ctx, (String)sql_update);
        }
        catch (Exception e) {
            logger.info((Object)"bill auditEnd end,update frozen limit fail");
            throw new BOSException((Throwable)e);
        }
    }

    public int updateYearVacationLimit(Context ctx, BOSUuid billId, Map<String, Object> billInfoMap) throws EASBizException, BOSException {
        AtsLeaveBillEntryInfo atsLeaveBillEntryInfo = (AtsLeaveBillEntryInfo)billInfoMap.get("atsLeaveBillEntryInfo");
        AtsLeaveBillInfo billInfo = (AtsLeaveBillInfo)billInfoMap.get("billInfo");
        String holidayPolicyId = atsLeaveBillEntryInfo.getPolicy().getId().toString();
        HolidayPolicyInfo holidayPolicyInfo = AtsServerUtils.getHolidayPolicyInfoById(ctx, holidayPolicyId);
        String personId = atsLeaveBillEntryInfo.getPerson().getId().toString();
        String oql = " where LeaveBill='" + billId.toString() + "' and changeType='" + 6 + "' and proposer ='" + personId + "'";
        HolidayLimitDetailCollection holidayLimitDetailCollection = HolidayLimitDetailFactory.getLocalInstance(ctx).getHolidayLimitDetailCollection(oql);
        for (int i = 0; i < holidayLimitDetailCollection.size(); ++i) {
            BigDecimal freezeLength = holidayLimitDetailCollection.get(i).getChangeValue();
            HashMap<String, Object> mapBalance = new HashMap<String, Object>();
            freezeLength = this.decimalPlacesSystem.precisionConvert(ctx, freezeLength, RoundingMode.HALF_UP);
            String holidayLimitId = null;
            if (holidayLimitDetailCollection.get(i).getHolidayLimit() != null) {
                holidayLimitId = holidayLimitDetailCollection.get(i).getHolidayLimit().getId().toString();
                mapBalance.put("holidayLimitId", holidayLimitId);
            }
            mapBalance.put("usedLimit", freezeLength);
            mapBalance.put("freezeLimit", freezeLength);
            mapBalance.put("changeValue", freezeLength);
            mapBalance.put("personId", personId);
            mapBalance.put("holidayPolicyUnit", (Object)holidayPolicyInfo.getUnit());
            mapBalance.put("holidayLimitChangeType", (Object)HolidayLimitChangeType.freeze);
            mapBalance.put("leaveBillID", billInfo.getId().toString());
            try {
                if (holidayLimitId != null) {
                    logger.info((Object)"leave bill audited and reduct annual limit start to that person... ");
                    this.updateFreezeUsedLimitNew(ctx, mapBalance, billInfo, atsLeaveBillEntryInfo);
                    logger.info((Object)"leave bill audited and reduct annual limit sucess to that person... ");
                }
                this.deleteDataInfoFromHolildayLimitDetail(ctx, mapBalance);
                this.insertDataInfoToHolildayLimitDetail(ctx, mapBalance, billInfo.getId().toString(), HolidayLimitChangeType.deduction);
                continue;
            }
            catch (EASBizException e) {
                e.printStackTrace();
                continue;
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
        }
        return 0;
    }

    public void operatorPreOverdraftLimit(Context ctx, Map mapBalance) throws BOSException, EASBizException {
        HashMap<String, Object> nextmapBalance;
        BigDecimal preOverdraftLimit;
        BigDecimal temp;
        logger.info((Object)"next cycle limit deduct start... ");
        String billId = (String)mapBalance.get("billId");
        String holidayLimitId = (String)mapBalance.get("holidayLimitId");
        BigDecimal changeValue = (BigDecimal)mapBalance.get("changeValue");
        AtsLeaveBillInfo atsLeaveBillInfo = AtsLeaveBillFactory.getLocalInstance(ctx).getAtsLeaveBillInfo(" where id='" + billId.toString() + "'");
        AtsLeaveBillEntryInfo atsLeaveBillEntryInfo = atsLeaveBillInfo.getEntries().get(0);
        HolidayLimitInfo holidayLimitInfo = HolidayLimitFactory.getLocalInstance(ctx).getHolidayLimitInfo(" where id='" + holidayLimitId + "'");
        String personId = holidayLimitInfo.getProposer().getId().toString();
        HolidayLimitCollection holidayLimitCollectionAll = AtsServerUtils.getHolidayLimitCollectionByPersonId(ctx, personId);
        holidayLimitCollectionAll.sort("cyclebegindate");
        holidayLimitCollectionAll.sort("delaydate");
        HolidayLimitInfo nextholidayLimitInfo = null;
        for (int i = 0; i < holidayLimitCollectionAll.size(); ++i) {
            if (!holidayLimitInfo.getId().equals((Object)holidayLimitCollectionAll.get(i).getId())) continue;
            nextholidayLimitInfo = holidayLimitCollectionAll.get(i + 1);
        }
        HolidayPolicyInfo holidayPolicyInfo = AtsServerUtils.getHolidayPolicyInfoByPersonIdAndHolidayType(ctx, personId, "3T54RtSQRIqAL6cffMh60P0tUpg=");
        if (holidayPolicyInfo != null && nextholidayLimitInfo == null && holidayPolicyInfo.isIsOver() && holidayLimitInfo.getRemainLimit().compareTo(BigDecimal.ZERO) == -1) {
            temp = BigDecimal.valueOf(-1L);
            preOverdraftLimit = holidayLimitInfo.getRemainLimit().multiply(temp);
            if (preOverdraftLimit.compareTo(changeValue) == 1) {
                preOverdraftLimit = changeValue;
            }
            nextmapBalance = new HashMap<String, Object>();
            preOverdraftLimit = this.decimalPlacesSystem.precisionConvert(ctx, preOverdraftLimit, RoundingMode.HALF_UP);
            nextmapBalance.put("holidayLimitId", holidayLimitId);
            nextmapBalance.put("changeValue", preOverdraftLimit);
            nextmapBalance.put("personId", personId);
            nextmapBalance.put("holidayPolicyUnit", (Object)holidayPolicyInfo.getUnit());
            this.insertDataInfoToHolildayLimitDetail(ctx, nextmapBalance, atsLeaveBillInfo.getId().toString(), HolidayLimitChangeType.overdraft);
        }
        if (holidayPolicyInfo != null && nextholidayLimitInfo != null && holidayPolicyInfo.isIsOver()) {
            if (holidayLimitInfo.getRemainLimit().compareTo(BigDecimal.ZERO) == -1) {
                temp = BigDecimal.valueOf(-1L);
                preOverdraftLimit = holidayLimitInfo.getRemainLimit().multiply(temp);
                if (preOverdraftLimit.compareTo(changeValue) == 1) {
                    preOverdraftLimit = changeValue;
                }
                nextmapBalance = new HashMap();
                String nextholidayLimitId = nextholidayLimitInfo.getId().toString();
                nextmapBalance.put("preOverdraftLimit", preOverdraftLimit);
                nextmapBalance.put("remainLimit", preOverdraftLimit);
                preOverdraftLimit = this.decimalPlacesSystem.precisionConvert(ctx, preOverdraftLimit, RoundingMode.HALF_UP);
                nextmapBalance.put("holidayLimitId", nextholidayLimitId);
                nextmapBalance.put("changeValue", preOverdraftLimit);
                nextmapBalance.put("personId", personId);
                nextmapBalance.put("holidayPolicyUnit", (Object)holidayPolicyInfo.getUnit());
                if (holidayPolicyInfo.isIsOverAutoSub()) {
                    this.updateOverDraftRemainLimitNew(ctx, nextmapBalance, atsLeaveBillInfo, atsLeaveBillEntryInfo);
                }
                this.insertDataInfoToHolildayLimitDetail(ctx, nextmapBalance, billId, HolidayLimitChangeType.overdraft);
            } else {
                BigDecimal preOverdraftLimit2 = BigDecimal.valueOf(0L);
                HashMap<String, Object> nextmapBalance2 = new HashMap<String, Object>();
                String nextholidayLimitId = nextholidayLimitInfo.getId().toString();
                nextmapBalance2.put("preOverdraftLimit", preOverdraftLimit2);
                nextmapBalance2.put("remainLimit", preOverdraftLimit2);
                preOverdraftLimit2 = this.decimalPlacesSystem.precisionConvert(ctx, preOverdraftLimit2, RoundingMode.HALF_UP);
                nextmapBalance2.put("holidayLimitId", nextholidayLimitId);
                nextmapBalance2.put("changeValue", preOverdraftLimit2);
                nextmapBalance2.put("personId", personId);
                nextmapBalance2.put("holidayPolicyUnit", (Object)holidayPolicyInfo.getUnit());
                if (holidayPolicyInfo.isIsOverAutoSub()) {
                    this.updateOverDraftRemainLimitNew(ctx, nextmapBalance2, atsLeaveBillInfo, atsLeaveBillEntryInfo);
                    this.updateDataInfoToHolildayLimitDetail(ctx, nextmapBalance2, billId, HolidayLimitChangeType.overdraft);
                }
            }
        }
        logger.info((Object)"next cycle limit deduct end... ");
    }

    protected void updateNextRemainLimit(Context ctx, Map<String, Object> mapBalance) throws BOSException, EASBizException {
        try {
            BigDecimal remainLimit_bill = (BigDecimal)mapBalance.get("remainLimit");
            String holidayLimitId = (String)mapBalance.get("holidayLimitId");
            String sqlquery = "select  holiday_limit.*  from t_hr_ats_holidaylimit holiday_limit  where fid='" + holidayLimitId + "'  ";
            IRowSet row = null;
            row = DbUtil.executeQuery((Context)ctx, (String)sqlquery);
            BigDecimal remainLimit_His = BigDecimal.valueOf(0L);
            while (row.next()) {
                remainLimit_His = row.getBigDecimal("FremainLimit");
            }
            BigDecimal remainLimit_bg = remainLimit_His.subtract(remainLimit_bill);
            remainLimit_bg = this.decimalPlacesSystem.precisionConvert(ctx, remainLimit_bg, RoundingMode.HALF_UP);
            float remainLimit = remainLimit_bg.floatValue();
            String sql = " update  t_hr_ats_holidaylimit set FRemainLimit='" + remainLimit + "' where fid='" + holidayLimitId + "'";
            DbUtil.execute((Context)ctx, (String)sql);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }

    public int rollBackYearVacationLimit(Context ctx, BOSUuid billId) throws EASBizException, BOSException {
        AtsLeaveBillInfo billInfo = AtsLeaveBillFactory.getLocalInstance(ctx).getAtsLeaveBillInfo((IObjectPK)new ObjectUuidPK(billId.toString()));
        AtsLeaveBillEntryCollection entryCollection = billInfo.getEntries();
        BigDecimal leavelengthSum = BigDecimal.valueOf(0L);
        int size = entryCollection.size();
        for (int i = 0; i < size; ++i) {
            BigDecimal leavelength = entryCollection.get(i).getLeaveLength();
            leavelengthSum = leavelengthSum.add(leavelength);
        }
        AtsLeaveBillEntryInfo atsLeaveBillEntryInfo = billInfo.getEntries().get(0);
        String personId = atsLeaveBillEntryInfo.getPerson().getId().toString();
        HolidayLimitCollection holidayLimitCollection = AtsServerUtils.getHolidayLimitCollInfoByPersonId(ctx, personId);
        long leaveBillStartTime = atsLeaveBillEntryInfo.getBeginTime().getTime();
        long leaveBillEndTime = atsLeaveBillEntryInfo.getEndTime().getTime();
        long b1 = 0L;
        long e1 = 0L;
        long b2 = 0L;
        long e2 = 0L;
        HolidayLimitInfo holidayLimitInfo = new HolidayLimitInfo();
        HolidayLimitInfo nextholidayLimitInfo = new HolidayLimitInfo();
        for (int i = 0; i < holidayLimitCollection.size(); ++i) {
            b1 = leaveBillStartTime;
            e1 = leaveBillEndTime;
            b2 = holidayLimitCollection.get(i).getCycleBeginDate().getTime();
            e2 = holidayLimitCollection.get(i).getDelayDate().getTime();
            if (b1 < b2 || e1 >= e2) continue;
            holidayLimitInfo = holidayLimitCollection.get(i);
            if (i <= 0 || holidayLimitCollection.get(i).getCycleBeginDate().getTime() >= holidayLimitCollection.get(i - 1).getCycleBeginDate().getTime()) continue;
            holidayLimitInfo = holidayLimitCollection.get(i);
            nextholidayLimitInfo = holidayLimitCollection.get(i - 1);
        }
        HolidayPolicyInfo holidayPolicyInfo = HolidayPolicyFactory.getLocalInstance(ctx).getHolidayPolicyInfo(" where id= '" + holidayLimitInfo.getHolidayPolicy().getId().toString() + "'");
        HashMap<String, Object> mapBalance = new HashMap<String, Object>();
        leavelengthSum = this.decimalPlacesSystem.precisionConvert(ctx, leavelengthSum, RoundingMode.HALF_UP);
        mapBalance.put("freezeLimit", leavelengthSum);
        mapBalance.put("personId", personId);
        mapBalance.put("holidayPolicyId", holidayPolicyInfo.getId().toString());
        mapBalance.put("holidayPolicyUnit", (Object)holidayPolicyInfo.getUnit());
        mapBalance.put("changeValue", leavelengthSum);
        String holidayLimitId = "";
        if (holidayLimitInfo != null) {
            holidayLimitId = holidayLimitInfo.getId().toString();
        }
        mapBalance.put("holidayLimitId", holidayLimitId);
        try {
            logger.info((Object)"del leave bill,frozen limit ,crestore rest limit start to that person... ");
            this.rollBackFreezeRemainLimitNew(ctx, mapBalance, billInfo, atsLeaveBillEntryInfo);
            logger.info((Object)"del leave bill,frozen limit ,crestore rest limit success to that person... ");
            this.insertDataInfoToHolildayLimitDetail(ctx, mapBalance, billInfo.getId().toString(), HolidayLimitChangeType.deduction);
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return 0;
    }

    public int updateYearVacationLimitBysubmitEffect(Context ctx, BOSUuid billId, Map<String, Object> billInfoMap) throws EASBizException, BOSException {
        AtsLeaveBillInfo billInfo = (AtsLeaveBillInfo)billInfoMap.get("billInfo");
        AtsLeaveBillEntryInfo atsLeaveBillEntryInfo = (AtsLeaveBillEntryInfo)billInfoMap.get("atsLeaveBillEntryInfo");
        BigDecimal leaveLength = atsLeaveBillEntryInfo.getLeaveLength();
        BigDecimal billLeaveLength = atsLeaveBillEntryInfo.getRealLeaveLength();
        String personId = atsLeaveBillEntryInfo.getPerson().getId().toString();
        Timestamp startTime = atsLeaveBillEntryInfo.getBeginTime();
        Timestamp endTime = atsLeaveBillEntryInfo.getEndTime();
        String hrOrgUnitId = billInfo.getHrOrgUnit().getId().toString();
        String holidayPolicyId = atsLeaveBillEntryInfo.getPolicy().getId().toString();
        HolidayPolicyInfo holidayPolicyInfo = AtsServerUtils.getHolidayPolicyInfoById(ctx, holidayPolicyId);
        String holidayTypeId = null;
        if (holidayPolicyInfo != null) {
            holidayTypeId = holidayPolicyInfo.getHolidayType().getId().toString();
        }
        HolidayLimitCollection allHolidayLimitCollection = HolidayLimitFactory.getLocalInstance(ctx).getHolidayLimitCollection(" where proposer='" + personId + "' and   holidayPolicy.holidayType='" + holidayTypeId + "'");
        Map holidayLimitCollresMap = new HashMap();
        List<Object> holidayLimitCollresMapList = new ArrayList();
        try {
            boolean isElasticCalLen = atsLeaveBillEntryInfo.isIsElasticCalLen();
            holidayLimitCollresMapList = AtsServerUtils.getfiterHolidayLimitCollByLeavebillTimeNew(ctx, allHolidayLimitCollection, startTime, endTime, hrOrgUnitId, personId, holidayTypeId, holidayPolicyInfo, isElasticCalLen, leaveLength, 0.0);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        for (int resMapListIndex = 0; resMapListIndex < holidayLimitCollresMapList.size(); ++resMapListIndex) {
            holidayLimitCollresMap = (Map)holidayLimitCollresMapList.get(resMapListIndex);
            HolidayLimitCollection holidayLimitCollection = null;
            holidayLimitCollection = (HolidayLimitCollection)((Object)holidayLimitCollresMap.get("holidayLimitCollectionSplit"));
            leaveLength = BigDecimal.valueOf((Double)holidayLimitCollresMap.get("leaveLengthWhole"));
            if (billLeaveLength.compareTo(BigDecimal.ZERO) <= 0) continue;
            if (leaveLength.compareTo(billLeaveLength) > 0) {
                leaveLength = billLeaveLength;
                billLeaveLength = new BigDecimal(0);
            } else {
                billLeaveLength = billLeaveLength.subtract(leaveLength);
            }
            if (holidayLimitCollection == null) {
                HashMap<String, Object> mapBalance = new HashMap<String, Object>();
                mapBalance.put("changeValue", leaveLength);
                mapBalance.put("personId", personId);
                mapBalance.put("holidayPolicyUnit", (Object)holidayPolicyInfo.getUnit());
                this.insertDataInfoToHolildayLimitDetail(ctx, mapBalance, billInfo.getId().toString(), HolidayLimitChangeType.deduction);
                return 0;
            }
            holidayLimitCollection.sort("cyclebegindate");
            holidayLimitCollection.sort("delaydate");
            for (int i = 0; i < holidayLimitCollection.size(); ++i) {
                HashMap<String, Object> mapBalance;
                String holidayLimitId;
                BigDecimal leaveLengthTemp;
                if (leaveLength.compareTo(BigDecimal.ZERO) == -1) continue;
                if (i == holidayLimitCollection.size() - 1) {
                    leaveLengthTemp = leaveLength;
                    holidayLimitId = holidayLimitCollection.get(i).getId().toString();
                    mapBalance = new HashMap<String, Object>();
                    leaveLengthTemp = this.decimalPlacesSystem.precisionConvert(ctx, leaveLengthTemp, RoundingMode.HALF_UP);
                    mapBalance.put("usedLimit", leaveLengthTemp);
                    mapBalance.put("holidayLimitId", holidayLimitId);
                    mapBalance.put("changeValue", leaveLengthTemp);
                    mapBalance.put("personId", personId);
                    mapBalance.put("holidayPolicyUnit", (Object)holidayPolicyInfo.getUnit());
                    mapBalance.put("billId", billInfo.getId().toString());
                    logger.info((Object)"leave bill commit direct and reduct annual limit start to that person... ");
                    this.updateUsedRemainLimitNew(ctx, mapBalance, billInfo, atsLeaveBillEntryInfo, holidayLimitCollection.get(i));
                    this.insertDataInfoToHolildayLimitDetail(ctx, mapBalance, billInfo.getId().toString(), HolidayLimitChangeType.deduction);
                    this.operatorPreOverdraftLimit(ctx, mapBalance);
                    logger.info((Object)"leave bill commit direct and reduct annual limit end to that person... ");
                    leaveLength = leaveLength.subtract(leaveLengthTemp);
                    continue;
                }
                if (leaveLength.compareTo(holidayLimitCollection.get(i).getRemainLimit()) == 1) {
                    if (holidayLimitCollection.get(i).getRemainLimit().compareTo(BigDecimal.ZERO) != 1) continue;
                    leaveLengthTemp = holidayLimitCollection.get(i).getRemainLimit();
                    holidayLimitId = holidayLimitCollection.get(i).getId().toString();
                    mapBalance = new HashMap();
                    leaveLengthTemp = this.decimalPlacesSystem.precisionConvert(ctx, leaveLengthTemp, RoundingMode.HALF_UP);
                    mapBalance.put("usedLimit", leaveLengthTemp);
                    mapBalance.put("holidayLimitId", holidayLimitId);
                    mapBalance.put("changeValue", leaveLengthTemp);
                    mapBalance.put("personId", personId);
                    mapBalance.put("holidayPolicyUnit", (Object)holidayPolicyInfo.getUnit());
                    mapBalance.put("billId", billInfo.getId().toString());
                    logger.info((Object)"leave bill commit direct and reduct annual limit start to that person... ");
                    this.updateUsedRemainLimitNew(ctx, mapBalance, billInfo, atsLeaveBillEntryInfo, holidayLimitCollection.get(i));
                    this.insertDataInfoToHolildayLimitDetail(ctx, mapBalance, billInfo.getId().toString(), HolidayLimitChangeType.deduction);
                    this.operatorPreOverdraftLimit(ctx, mapBalance);
                    logger.info((Object)"leave bill commit direct and reduct annual limit end to that person... ");
                    leaveLength = leaveLength.subtract(leaveLengthTemp);
                    continue;
                }
                leaveLengthTemp = leaveLength;
                holidayLimitId = holidayLimitCollection.get(i).getId().toString();
                mapBalance = new HashMap();
                leaveLengthTemp = this.decimalPlacesSystem.precisionConvert(ctx, leaveLengthTemp, RoundingMode.HALF_UP);
                mapBalance.put("usedLimit", leaveLengthTemp);
                mapBalance.put("holidayLimitId", holidayLimitId);
                mapBalance.put("changeValue", leaveLengthTemp);
                mapBalance.put("personId", personId);
                mapBalance.put("holidayPolicyUnit", (Object)holidayPolicyInfo.getUnit());
                mapBalance.put("billId", billInfo.getId().toString());
                logger.info((Object)"leave bill commit direct and reduct annual limit start to that person... ");
                this.updateUsedRemainLimitNew(ctx, mapBalance, billInfo, atsLeaveBillEntryInfo, holidayLimitCollection.get(i));
                this.insertDataInfoToHolildayLimitDetail(ctx, mapBalance, billInfo.getId().toString(), HolidayLimitChangeType.deduction);
                this.operatorPreOverdraftLimit(ctx, mapBalance);
                logger.info((Object)"leave bill commit direct and reduct annual limit end to that person... ");
                leaveLength = leaveLength.subtract(leaveLengthTemp);
            }
        }
        return 0;
    }

    public int updateYearVacationLimitBysubmitEffectNew(Context ctx, BOSUuid billEntryId, Map<String, Object> billInfoMap) throws EASBizException, BOSException {
        AtsLeaveBillInfo billInfos = (AtsLeaveBillInfo)billInfoMap.get("billInfo");
        AtsLeaveBillEntryInfo atsLeaveBillEntryInfo = (AtsLeaveBillEntryInfo)billInfoMap.get("atsLeaveBillEntryInfo");
        BigDecimal leaveLength = atsLeaveBillEntryInfo.getLeaveLength();
        BigDecimal billLeaveLength = atsLeaveBillEntryInfo.getLeaveLength();
        String personId = atsLeaveBillEntryInfo.getPerson().getId().toString();
        Timestamp startTime = atsLeaveBillEntryInfo.getBeginTime();
        Timestamp endTime = atsLeaveBillEntryInfo.getEndTime();
        String hrOrgUnitId = billInfos.getHrOrgUnit().getId().toString();
        String holidayPolicyId = atsLeaveBillEntryInfo.getPolicy().getId().toString();
        HolidayPolicyInfo holidayPolicyInfo = AtsServerUtils.getHolidayPolicyInfoById(ctx, holidayPolicyId);
        String holidayTypeId = null;
        if (holidayPolicyInfo != null) {
            holidayTypeId = holidayPolicyInfo.getHolidayType().getId().toString();
        }
        HolidayLimitCollection allHolidayLimitCollection = HolidayLimitFactory.getLocalInstance(ctx).getHolidayLimitCollection(" where proposer='" + personId + "' and   holidayPolicy.holidayType='" + holidayTypeId + "'");
        Map holidayLimitCollresMap = new HashMap();
        List<Object> holidayLimitCollresMapList = new ArrayList();
        try {
            boolean isElasticCalLen = atsLeaveBillEntryInfo.isIsElasticCalLen();
            holidayLimitCollresMapList = AtsServerUtils.getfiterHolidayLimitCollByLeavebillTimeNew(ctx, allHolidayLimitCollection, startTime, endTime, hrOrgUnitId, personId, holidayTypeId, holidayPolicyInfo, isElasticCalLen, leaveLength, 0.0);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        for (int resMapListIndex = 0; resMapListIndex < holidayLimitCollresMapList.size(); ++resMapListIndex) {
            holidayLimitCollresMap = (Map)holidayLimitCollresMapList.get(resMapListIndex);
            HolidayLimitCollection holidayLimitCollection = null;
            holidayLimitCollection = (HolidayLimitCollection)((Object)holidayLimitCollresMap.get("holidayLimitCollectionSplit"));
            leaveLength = BigDecimal.valueOf((Double)holidayLimitCollresMap.get("leaveLengthWhole"));
            if (billLeaveLength.compareTo(BigDecimal.ZERO) <= 0) continue;
            if (leaveLength.compareTo(billLeaveLength) > 0) {
                leaveLength = billLeaveLength;
                billLeaveLength = new BigDecimal(0);
            } else {
                billLeaveLength = billLeaveLength.subtract(leaveLength);
            }
            if (holidayLimitCollection == null) {
                HashMap<String, Object> mapBalance = new HashMap<String, Object>();
                mapBalance.put("changeValue", leaveLength);
                mapBalance.put("personId", personId);
                mapBalance.put("holidayPolicyUnit", (Object)holidayPolicyInfo.getUnit());
                this.insertDataInfoToHolildayLimitDetailNew(ctx, mapBalance, billInfos.getId().toString(), HolidayLimitChangeType.deduction, atsLeaveBillEntryInfo);
                return 0;
            }
            holidayLimitCollection.sort("cyclebegindate");
            holidayLimitCollection.sort("delaydate");
            for (int i = 0; i < holidayLimitCollection.size(); ++i) {
                HashMap<String, Object> mapBalance;
                String holidayLimitId;
                BigDecimal leaveLengthTemp;
                if (leaveLength.compareTo(BigDecimal.ZERO) == -1) continue;
                if (i == holidayLimitCollection.size() - 1) {
                    leaveLengthTemp = leaveLength;
                    holidayLimitId = holidayLimitCollection.get(i).getId().toString();
                    mapBalance = new HashMap<String, Object>();
                    leaveLengthTemp = this.decimalPlacesSystem.precisionConvert(ctx, leaveLengthTemp, RoundingMode.HALF_UP);
                    mapBalance.put("usedLimit", leaveLengthTemp);
                    mapBalance.put("holidayLimitId", holidayLimitId);
                    mapBalance.put("changeValue", leaveLengthTemp);
                    mapBalance.put("personId", personId);
                    mapBalance.put("holidayPolicyUnit", (Object)holidayPolicyInfo.getUnit());
                    mapBalance.put("billId", billInfos.getId().toString());
                    logger.info((Object)"leave bill commit direct and reduct annual limit start to that person... ");
                    this.updateUsedRemainLimitNew(ctx, mapBalance, billInfos, atsLeaveBillEntryInfo, holidayLimitCollection.get(i));
                    this.insertDataInfoToHolildayLimitDetailNew(ctx, mapBalance, billInfos.getId().toString(), HolidayLimitChangeType.deduction, atsLeaveBillEntryInfo);
                    this.operatorPreOverdraftLimit(ctx, mapBalance);
                    logger.info((Object)"leave bill commit direct and reduct annual limit end to that person... ");
                    leaveLength = leaveLength.subtract(leaveLengthTemp);
                    continue;
                }
                if (leaveLength.compareTo(holidayLimitCollection.get(i).getRemainLimit()) == 1) {
                    if (holidayLimitCollection.get(i).getRemainLimit().compareTo(BigDecimal.ZERO) != 1) continue;
                    leaveLengthTemp = holidayLimitCollection.get(i).getRemainLimit();
                    holidayLimitId = holidayLimitCollection.get(i).getId().toString();
                    mapBalance = new HashMap();
                    leaveLengthTemp = this.decimalPlacesSystem.precisionConvert(ctx, leaveLengthTemp, RoundingMode.HALF_UP);
                    mapBalance.put("usedLimit", leaveLengthTemp);
                    mapBalance.put("holidayLimitId", holidayLimitId);
                    mapBalance.put("changeValue", leaveLengthTemp);
                    mapBalance.put("personId", personId);
                    mapBalance.put("holidayPolicyUnit", (Object)holidayPolicyInfo.getUnit());
                    mapBalance.put("billId", billInfos.getId().toString());
                    logger.info((Object)"leave bill commit direct and reduct annual limit start to that person... ");
                    this.updateUsedRemainLimitNew(ctx, mapBalance, billInfos, atsLeaveBillEntryInfo, holidayLimitCollection.get(i));
                    this.insertDataInfoToHolildayLimitDetailNew(ctx, mapBalance, billInfos.getId().toString(), HolidayLimitChangeType.deduction, atsLeaveBillEntryInfo);
                    this.operatorPreOverdraftLimit(ctx, mapBalance);
                    logger.info((Object)"leave bill commit direct and reduct annual limit end to that person... ");
                    leaveLength = leaveLength.subtract(leaveLengthTemp);
                    continue;
                }
                leaveLengthTemp = leaveLength;
                holidayLimitId = holidayLimitCollection.get(i).getId().toString();
                mapBalance = new HashMap();
                leaveLengthTemp = this.decimalPlacesSystem.precisionConvert(ctx, leaveLengthTemp, RoundingMode.HALF_UP);
                mapBalance.put("usedLimit", leaveLengthTemp);
                mapBalance.put("holidayLimitId", holidayLimitId);
                mapBalance.put("changeValue", leaveLengthTemp);
                mapBalance.put("personId", personId);
                mapBalance.put("holidayPolicyUnit", (Object)holidayPolicyInfo.getUnit());
                mapBalance.put("billId", billInfos.getId().toString());
                logger.info((Object)"leave bill commit direct and reduct annual limit start to that person... ");
                this.updateUsedRemainLimitNew(ctx, mapBalance, billInfos, atsLeaveBillEntryInfo, holidayLimitCollection.get(i));
                this.insertDataInfoToHolildayLimitDetailNew(ctx, mapBalance, billInfos.getId().toString(), HolidayLimitChangeType.deduction, atsLeaveBillEntryInfo);
                this.operatorPreOverdraftLimit(ctx, mapBalance);
                logger.info((Object)"leave bill commit direct and reduct annual limit end to that person... ");
                leaveLength = leaveLength.subtract(leaveLengthTemp);
            }
        }
        return 0;
    }

    public int updateLimitFromCancelLeaveBillBysubmitEffect(Context ctx, BOSUuid cancelLeaveBillId) throws EASBizException, BOSException {
        CancelLeaveBillInfo cancelLeaveBillInfo = CancelLeaveBillFactory.getLocalInstance(ctx).getCancelLeaveBillInfo(" where id='" + cancelLeaveBillId.toString() + "'");
        AtsLeaveBillEntryInfo atsLeaveBillEntryInfo = AtsLeaveBillEntryFactory.getLocalInstance(ctx).getAtsLeaveBillEntryInfo(" where id='" + cancelLeaveBillInfo.getEntries().get(0).getLeaveEntryBill().getId().toString() + "'");
        AtsLeaveBillInfo atsLeaveBillInfo = AtsLeaveBillFactory.getLocalInstance(ctx).getAtsLeaveBillInfo(" where id='" + atsLeaveBillEntryInfo.getBill().getId().toString() + "'");
        String personId = atsLeaveBillEntryInfo.getPerson().getId().toString();
        String holidayPolicyId = atsLeaveBillEntryInfo.getPolicy().getId().toString();
        HolidayPolicyInfo holidayPolicyInfo = AtsServerUtils.getHolidayPolicyInfoById(ctx, holidayPolicyId);
        String holidayTypeId = null;
        if (holidayPolicyInfo != null) {
            holidayTypeId = holidayPolicyInfo.getHolidayType().getId().toString();
        }
        BigDecimal leaveLength = cancelLeaveBillInfo.getEntries().get(0).getRealLeaLength();
        BigDecimal billLeaveLength = cancelLeaveBillInfo.getEntries().get(0).getRealLeaLength();
        Timestamp startTime = cancelLeaveBillInfo.getEntries().get(0).getRealLeaBeginTime();
        Timestamp endTime = cancelLeaveBillInfo.getEntries().get(0).getRealLeaEndTime();
        HolidayLimitCollection allHolidayLimitCollection = HolidayLimitFactory.getLocalInstance(ctx).getHolidayLimitCollection(" where proposer='" + personId + "' and   holidayPolicy.holidayType='" + holidayTypeId + "'");
        String hrOrgUnitId = atsLeaveBillInfo.getHrOrgUnit().getId().toString();
        Map holidayLimitCollresMap = new HashMap();
        List<Object> holidayLimitCollresMapList = new ArrayList();
        try {
            boolean isElasticCalLen = atsLeaveBillEntryInfo.isIsElasticCalLen();
            holidayLimitCollresMapList = AtsServerUtils.getfiterHolidayLimitCollByLeavebillTimeNew(ctx, allHolidayLimitCollection, startTime, endTime, hrOrgUnitId, personId, holidayTypeId, holidayPolicyInfo, isElasticCalLen, leaveLength, 0.0);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        for (int resMapListIndex = 0; resMapListIndex < holidayLimitCollresMapList.size(); ++resMapListIndex) {
            holidayLimitCollresMap = (Map)holidayLimitCollresMapList.get(resMapListIndex);
            HolidayLimitCollection holidayLimitCollection = null;
            holidayLimitCollection = (HolidayLimitCollection)((Object)holidayLimitCollresMap.get("holidayLimitCollectionSplit"));
            leaveLength = BigDecimal.valueOf((Double)holidayLimitCollresMap.get("leaveLengthWhole"));
            if (billLeaveLength.compareTo(BigDecimal.ZERO) <= 0) continue;
            if (leaveLength.compareTo(billLeaveLength) > 0) {
                leaveLength = billLeaveLength;
                billLeaveLength = new BigDecimal(0);
            } else {
                billLeaveLength = billLeaveLength.subtract(leaveLength);
            }
            if (holidayLimitCollection == null) {
                HashMap<String, Object> mapBalance = new HashMap<String, Object>();
                mapBalance.put("changeValue", leaveLength);
                mapBalance.put("personId", personId);
                mapBalance.put("holidayPolicyUnit", (Object)holidayPolicyInfo.getUnit());
                this.insertDataInfoToHolildayLimitDetail(ctx, mapBalance, atsLeaveBillInfo.getId().toString(), HolidayLimitChangeType.deduction);
                return 0;
            }
            holidayLimitCollection.sort("cyclebegindate");
            holidayLimitCollection.sort("delaydate");
            for (int i = 0; i < holidayLimitCollection.size(); ++i) {
                HashMap<String, Object> mapBalance;
                String holidayLimitId;
                BigDecimal leaveLengthTemp;
                if (leaveLength.compareTo(BigDecimal.ZERO) == -1) continue;
                if (i == holidayLimitCollection.size() - 1) {
                    leaveLengthTemp = leaveLength;
                    holidayLimitId = holidayLimitCollection.get(i).getId().toString();
                    mapBalance = new HashMap<String, Object>();
                    leaveLengthTemp = this.decimalPlacesSystem.precisionConvert(ctx, leaveLengthTemp, RoundingMode.HALF_UP);
                    mapBalance.put("usedLimit", leaveLengthTemp);
                    mapBalance.put("holidayLimitId", holidayLimitId);
                    mapBalance.put("changeValue", leaveLengthTemp);
                    mapBalance.put("personId", personId);
                    mapBalance.put("holidayPolicyUnit", (Object)holidayPolicyInfo.getUnit());
                    mapBalance.put("billId", atsLeaveBillInfo.getId().toString());
                    logger.info((Object)"cance leave bill and update used limit start.. ");
                    mapBalance.put("atsLeaveBillEntryInfo", atsLeaveBillEntryInfo);
                    this.updateUsedRemainLimitNew(ctx, mapBalance, atsLeaveBillInfo, atsLeaveBillEntryInfo, holidayLimitCollection.get(i));
                    this.insertDataInfoToHolildayLimitDetail(ctx, mapBalance, atsLeaveBillInfo.getId().toString(), HolidayLimitChangeType.deduction);
                    this.operatorPreOverdraftLimit(ctx, mapBalance);
                    logger.info((Object)"cance leave bill and update used limit end... ");
                    leaveLength = leaveLength.subtract(leaveLengthTemp);
                    continue;
                }
                if (leaveLength.compareTo(holidayLimitCollection.get(i).getRemainLimit()) == 1) {
                    if (holidayLimitCollection.get(i).getRemainLimit().compareTo(BigDecimal.ZERO) != 1) continue;
                    leaveLengthTemp = holidayLimitCollection.get(i).getRemainLimit();
                    holidayLimitId = holidayLimitCollection.get(i).getId().toString();
                    mapBalance = new HashMap();
                    leaveLengthTemp = this.decimalPlacesSystem.precisionConvert(ctx, leaveLengthTemp, RoundingMode.HALF_UP);
                    mapBalance.put("usedLimit", leaveLengthTemp);
                    mapBalance.put("holidayLimitId", holidayLimitId);
                    mapBalance.put("atsLeaveBillEntryInfo", atsLeaveBillEntryInfo);
                    mapBalance.put("changeValue", leaveLengthTemp);
                    mapBalance.put("personId", personId);
                    mapBalance.put("holidayPolicyUnit", (Object)holidayPolicyInfo.getUnit());
                    mapBalance.put("billId", atsLeaveBillInfo.getId().toString());
                    logger.info((Object)"cance leave bill and update used limit start.. ");
                    this.updateUsedRemainLimitNew(ctx, mapBalance, atsLeaveBillInfo, atsLeaveBillEntryInfo, holidayLimitCollection.get(i));
                    this.insertDataInfoToHolildayLimitDetail(ctx, mapBalance, atsLeaveBillInfo.getId().toString(), HolidayLimitChangeType.deduction);
                    logger.info((Object)"cance leave bill and update used limit end... ");
                    leaveLength = leaveLength.subtract(leaveLengthTemp);
                    continue;
                }
                leaveLengthTemp = leaveLength;
                holidayLimitId = holidayLimitCollection.get(i).getId().toString();
                mapBalance = new HashMap();
                leaveLengthTemp = this.decimalPlacesSystem.precisionConvert(ctx, leaveLengthTemp, RoundingMode.HALF_UP);
                mapBalance.put("usedLimit", leaveLengthTemp);
                mapBalance.put("holidayLimitId", holidayLimitId);
                mapBalance.put("atsLeaveBillEntryInfo", atsLeaveBillEntryInfo);
                mapBalance.put("changeValue", leaveLengthTemp);
                mapBalance.put("personId", personId);
                mapBalance.put("holidayPolicyUnit", (Object)holidayPolicyInfo.getUnit());
                mapBalance.put("billId", atsLeaveBillInfo.getId().toString());
                logger.info((Object)"cance leave bill and update used limit start.. ");
                this.updateUsedRemainLimitNew(ctx, mapBalance, atsLeaveBillInfo, atsLeaveBillEntryInfo, holidayLimitCollection.get(i));
                this.insertDataInfoToHolildayLimitDetail(ctx, mapBalance, atsLeaveBillInfo.getId().toString(), HolidayLimitChangeType.deduction);
                logger.info((Object)"cance leave bill and update used limit end... ");
                leaveLength = leaveLength.subtract(leaveLengthTemp);
            }
        }
        return 0;
    }

    public static void main(String[] args) {
        System.out.println("");
    }

    public void updateHolidayLimitBysubmitEffect(Context ctx, Map<String, Object> billInfoMap) throws EASBizException, BOSException {
        logger.info((Object)"leave bill commit direct and reduct annual limit start to that person... ");
        AtsLeaveBillInfo billInfo = (AtsLeaveBillInfo)billInfoMap.get("billInfo");
        AtsLeaveBillEntryInfo atsLeaveBillEntryInfo = (AtsLeaveBillEntryInfo)billInfoMap.get("atsLeaveBillEntryInfo");
        HolidayPolicyInfo holidayPolicyInfo = (HolidayPolicyInfo)billInfoMap.get("policyInfo");
        BigDecimal leaveLength = atsLeaveBillEntryInfo.getLeaveLength();
        String personId = atsLeaveBillEntryInfo.getPerson().getId().toString();
        Timestamp startTime = atsLeaveBillEntryInfo.getBeginTime();
        Timestamp endTime = atsLeaveBillEntryInfo.getEndTime();
        String holidayTypeId = holidayPolicyInfo.getHolidayType().getId().toString();
        HolidayLimitCollection allHolidayLimitCollection = HolidayLimitFactory.getLocalInstance(ctx).getHolidayLimitCollection(" where proposer='" + personId + "' and   holidayPolicy.holidayType='" + holidayTypeId + "'");
        HolidayLimitCollection holidayLimitCollection = AtsServerUtils.getfiterHolidayLimitCollByLeavebillTime(ctx, allHolidayLimitCollection, startTime, endTime);
        PersonPositionInfo personPositionInfo = SHRBillServerUtil.getAdminOrgUnit(ctx, personId);
        CoreBaseCollection holidayLimitcolls = new CoreBaseCollection();
        CoreBaseCollection holidayLimitDetailcolls = new CoreBaseCollection();
        if (holidayLimitCollection == null || holidayLimitCollection.isEmpty()) {
            HashMap<String, Object> mapBalance = new HashMap<String, Object>();
            mapBalance.put("changeValue", leaveLength);
            mapBalance.put("personId", personId);
            mapBalance.put("holidayPolicyUnit", (Object)holidayPolicyInfo.getUnit());
            HolidayLimitDetailInfo detailInfo = this.generateHolildayLimitDetail(ctx, billInfo, mapBalance, HolidayLimitChangeType.deduction, personPositionInfo);
            holidayLimitDetailcolls.add((CoreBaseInfo)detailInfo);
            return;
        }
        holidayLimitCollection.sort("cyclebegindate");
        holidayLimitCollection.sort("delaydate");
        for (int i = 0; i < holidayLimitCollection.size(); ++i) {
            HolidayLimitInfo holidayLimitInfo = holidayLimitCollection.get(i);
            String holidayLimitId = holidayLimitInfo.getId().toString();
            BigDecimal leaveLengthTemp = new BigDecimal(0);
            if (leaveLength.compareTo(BigDecimal.ZERO) != -1) {
                if (i == holidayLimitCollection.size() - 1) {
                    leaveLengthTemp = leaveLength;
                } else if (leaveLength.compareTo(holidayLimitInfo.getRemainLimit()) == 1) {
                    if (holidayLimitInfo.getRemainLimit().compareTo(BigDecimal.ZERO) == 1) {
                        leaveLengthTemp = holidayLimitInfo.getRemainLimit();
                    }
                } else {
                    leaveLengthTemp = leaveLength;
                }
                if (leaveLengthTemp.compareTo(BigDecimal.ZERO) == 1) {
                    HashMap<String, Object> mapBalance = new HashMap<String, Object>();
                    leaveLengthTemp = this.decimalPlacesSystem.precisionConvert(ctx, leaveLengthTemp, RoundingMode.HALF_UP);
                    mapBalance.put("usedLimit", leaveLengthTemp);
                    mapBalance.put("holidayLimitId", holidayLimitId);
                    mapBalance.put("changeValue", leaveLengthTemp);
                    mapBalance.put("personId", personId);
                    mapBalance.put("holidayPolicyUnit", (Object)holidayPolicyInfo.getUnit());
                    mapBalance.put("billId", billInfo.getId().toString());
                    BigDecimal usedLimit_bg = holidayLimitInfo.getUsedLimit().add(leaveLengthTemp);
                    holidayLimitInfo.setUsedLimit(usedLimit_bg);
                    BigDecimal remainLimit_bg = holidayLimitInfo.getRealLimit().subtract(holidayLimitInfo.getUsedLimit()).subtract(holidayLimitInfo.getFreezeLimit()).subtract(holidayLimitInfo.getPreOverdraftLimit());
                    remainLimit_bg = this.decimalPlacesSystem.precisionConvert(ctx, remainLimit_bg, RoundingMode.HALF_UP);
                    holidayLimitInfo.setRemainLimit(remainLimit_bg);
                    HolidayLimitDetailInfo detailInfo = this.generateHolildayLimitDetail(ctx, billInfo, mapBalance, HolidayLimitChangeType.deduction, personPositionInfo);
                    holidayLimitDetailcolls.add((CoreBaseInfo)detailInfo);
                    this.operatorPreOverdraftLimit(ctx, billInfo, holidayPolicyInfo, holidayLimitInfo, mapBalance, allHolidayLimitCollection, personId, holidayLimitcolls, holidayLimitDetailcolls);
                    leaveLength = leaveLength.subtract(leaveLengthTemp);
                }
            }
            holidayLimitcolls.add((CoreBaseInfo)holidayLimitInfo);
        }
        if (holidayLimitcolls.size() > 0) {
            IHolidayLimit iHolidayLimit = HolidayLimitFactory.getLocalInstance(ctx);
            iHolidayLimit.update(holidayLimitcolls);
        }
        if (holidayLimitDetailcolls.size() > 0) {
            IHolidayLimitDetail iHolidayLimitDetail = HolidayLimitDetailFactory.getLocalInstance(ctx);
            iHolidayLimitDetail.addnew(holidayLimitDetailcolls);
        }
        logger.info((Object)"leave bill commit direct and reduct annual limit end to that person... ");
    }

    protected HolidayLimitDetailInfo generateHolildayLimitDetail(Context ctx, AtsLeaveBillInfo billInfo, Map<String, Object> mapBalance, HolidayLimitChangeType holidayLimitChangeType, PersonPositionInfo personPositionInfo) {
        logger.info((Object)"record detail table start...");
        HolidayLimitDetailInfo detailInfo = new HolidayLimitDetailInfo();
        String personId = (String)mapBalance.get("personId");
        detailInfo.setProposer(personPositionInfo.getPerson());
        detailInfo.setAdminOrgUnit(personPositionInfo.getPersonDep());
        detailInfo.setPosition(personPositionInfo.getPrimaryPosition());
        detailInfo.setHrOrgUnit(personPositionInfo.getHrOrgUnit());
        Calendar cal = Calendar.getInstance();
        detailInfo.setYear(cal.get(1));
        detailInfo.setChangeDate(AtsLeaveBillLimitServer.dateToTimestamp(new Date()));
        detailInfo.setCreateTime(AtsLeaveBillLimitServer.dateToTimestamp(new Date()));
        detailInfo.setChangeType(holidayLimitChangeType);
        detailInfo.setBillType(HolidayLimitBillTypeEnum.leaveBill);
        detailInfo.setLeaveBill(billInfo);
        detailInfo.setLeaveBillNumber(billInfo.getNumber());
        detailInfo.setChangeValue((BigDecimal)mapBalance.get("changeValue"));
        detailInfo.setChangeUnit((HolidayTypeUnitEnum)((Object)mapBalance.get("holidayPolicyUnit")));
        String holidayLimitId = (String)mapBalance.get("holidayLimitId");
        if (holidayLimitId != null) {
            HolidayLimitInfo limitInfo = new HolidayLimitInfo();
            limitInfo.setId(BOSUuid.read((String)holidayLimitId));
            detailInfo.setHolidayLimit(limitInfo);
        }
        detailInfo.setStatus(HolidayLimitDetailStatusEnum.valid);
        logger.info((Object)"record detail table end...");
        return detailInfo;
    }

    public void operatorPreOverdraftLimit(Context ctx, AtsLeaveBillInfo atsLeaveBillInfo, HolidayPolicyInfo holidayPolicyInfo, HolidayLimitInfo holidayLimitInfo, Map mapBalance, HolidayLimitCollection allHolidayLimitCollection, String personId, CoreBaseCollection holidayLimitcolls, CoreBaseCollection holidayLimitDetailcolls) throws BOSException, EASBizException {
        HashMap<String, Object> nextmapBalance;
        BigDecimal preOverdraftLimit;
        logger.info((Object)"next cycle limit deduct start... ");
        String billId = (String)mapBalance.get("billId");
        String holidayLimitId = (String)mapBalance.get("holidayLimitId");
        BigDecimal changeValue = (BigDecimal)mapBalance.get("changeValue");
        allHolidayLimitCollection.sort("cyclebegindate");
        allHolidayLimitCollection.sort("delaydate");
        HolidayLimitInfo nextholidayLimitInfo = null;
        PersonPositionInfo personPositionInfo = SHRBillServerUtil.getAdminOrgUnit(ctx, personId);
        for (int i = 0; i < allHolidayLimitCollection.size(); ++i) {
            if (!holidayLimitInfo.getId().equals((Object)allHolidayLimitCollection.get(i).getId()) || i == allHolidayLimitCollection.size() - 1) continue;
            nextholidayLimitInfo = allHolidayLimitCollection.get(i + 1);
        }
        if (holidayPolicyInfo != null && nextholidayLimitInfo == null && holidayPolicyInfo.isIsOver() && holidayLimitInfo.getRemainLimit().compareTo(BigDecimal.ZERO) == -1) {
            BigDecimal temp = BigDecimal.valueOf(-1L);
            preOverdraftLimit = holidayLimitInfo.getRemainLimit().multiply(temp);
            if (preOverdraftLimit.compareTo(changeValue) == 1) {
                preOverdraftLimit = changeValue;
            }
            nextmapBalance = new HashMap<String, Object>();
            preOverdraftLimit = this.decimalPlacesSystem.precisionConvert(ctx, preOverdraftLimit, RoundingMode.HALF_UP);
            nextmapBalance.put("holidayLimitId", holidayLimitId);
            nextmapBalance.put("changeValue", preOverdraftLimit);
            nextmapBalance.put("personId", personId);
            nextmapBalance.put("holidayPolicyUnit", (Object)holidayPolicyInfo.getUnit());
            HolidayLimitDetailInfo detailInfo = this.generateHolildayLimitDetail(ctx, atsLeaveBillInfo, nextmapBalance, HolidayLimitChangeType.overdraft, personPositionInfo);
            holidayLimitDetailcolls.add((CoreBaseInfo)detailInfo);
        }
        if (holidayPolicyInfo != null && nextholidayLimitInfo != null && holidayPolicyInfo.isIsOver()) {
            if (holidayLimitInfo.getRemainLimit().compareTo(BigDecimal.ZERO) == -1) {
                BigDecimal temp = BigDecimal.valueOf(-1L);
                preOverdraftLimit = holidayLimitInfo.getRemainLimit().multiply(temp);
                if (preOverdraftLimit.compareTo(changeValue) == 1) {
                    preOverdraftLimit = changeValue;
                }
                nextmapBalance = new HashMap();
                String nextholidayLimitId = nextholidayLimitInfo.getId().toString();
                nextmapBalance.put("preOverdraftLimit", preOverdraftLimit);
                nextmapBalance.put("remainLimit", preOverdraftLimit);
                preOverdraftLimit = this.decimalPlacesSystem.precisionConvert(ctx, preOverdraftLimit, RoundingMode.HALF_UP);
                nextmapBalance.put("holidayLimitId", nextholidayLimitId);
                nextmapBalance.put("changeValue", preOverdraftLimit);
                nextmapBalance.put("personId", personId);
                nextmapBalance.put("holidayPolicyUnit", (Object)holidayPolicyInfo.getUnit());
                if (holidayPolicyInfo.isIsOverAutoSub()) {
                    BigDecimal overdraftLimit_bg = nextholidayLimitInfo.getPreOverdraftLimit().add(preOverdraftLimit);
                    nextholidayLimitInfo.setPreOverdraftLimit(overdraftLimit_bg);
                    BigDecimal remainLimit_bg = nextholidayLimitInfo.getRealLimit().subtract(nextholidayLimitInfo.getUsedLimit()).subtract(nextholidayLimitInfo.getFreezeLimit()).subtract(nextholidayLimitInfo.getPreOverdraftLimit());
                    remainLimit_bg = this.decimalPlacesSystem.precisionConvert(ctx, remainLimit_bg, RoundingMode.HALF_UP);
                    nextholidayLimitInfo.setRemainLimit(remainLimit_bg);
                    holidayLimitcolls.add((CoreBaseInfo)nextholidayLimitInfo);
                }
                HolidayLimitDetailInfo detailInfo = this.generateHolildayLimitDetail(ctx, atsLeaveBillInfo, mapBalance, HolidayLimitChangeType.overdraft, personPositionInfo);
                holidayLimitDetailcolls.add((CoreBaseInfo)detailInfo);
            } else {
                BigDecimal preOverdraftLimit2 = BigDecimal.valueOf(0L);
                HashMap<String, Object> nextmapBalance2 = new HashMap<String, Object>();
                String nextholidayLimitId = nextholidayLimitInfo.getId().toString();
                nextmapBalance2.put("preOverdraftLimit", preOverdraftLimit2);
                nextmapBalance2.put("remainLimit", preOverdraftLimit2);
                preOverdraftLimit2 = this.decimalPlacesSystem.precisionConvert(ctx, preOverdraftLimit2, RoundingMode.HALF_UP);
                nextmapBalance2.put("holidayLimitId", nextholidayLimitId);
                nextmapBalance2.put("changeValue", preOverdraftLimit2);
                nextmapBalance2.put("personId", personId);
                nextmapBalance2.put("holidayPolicyUnit", (Object)holidayPolicyInfo.getUnit());
                if (holidayPolicyInfo.isIsOverAutoSub()) {
                    BigDecimal overdraftLimit_bg = nextholidayLimitInfo.getPreOverdraftLimit().add(preOverdraftLimit2);
                    nextholidayLimitInfo.setPreOverdraftLimit(overdraftLimit_bg);
                    BigDecimal remainLimit_bg = nextholidayLimitInfo.getRealLimit().subtract(nextholidayLimitInfo.getUsedLimit()).subtract(nextholidayLimitInfo.getFreezeLimit()).subtract(nextholidayLimitInfo.getPreOverdraftLimit());
                    remainLimit_bg = this.decimalPlacesSystem.precisionConvert(ctx, remainLimit_bg, RoundingMode.HALF_UP);
                    nextholidayLimitInfo.setRemainLimit(remainLimit_bg);
                    holidayLimitcolls.add((CoreBaseInfo)nextholidayLimitInfo);
                    this.updateDataInfoToHolildayLimitDetail(ctx, nextmapBalance2, billId, HolidayLimitChangeType.overdraft);
                }
            }
        }
        logger.info((Object)"next cycle limit deduct end... ");
    }

    public void updateFreezeRemainLimitNew(Context ctx, Map<String, Object> mapBalance, AtsLeaveBillInfo billInfo, AtsLeaveBillEntryInfo entryInfo, HolidayLimitInfo holidayLimitInfoMemory) throws BOSException, EASBizException {
        try {
            AtsLeaveBillLimit limit = new AtsLeaveBillLimit();
            BigDecimal freezeLimit_bill = null == mapBalance.get("freezeLimit") ? BigDecimal.ZERO : (BigDecimal)mapBalance.get("freezeLimit");
            String holidayLimitId = (String)mapBalance.get("holidayLimitId");
            HolidayLimitInfo holidayLimitInfo = HolidayLimitFactory.getLocalInstance(ctx).getHolidayLimitInfo("select *,holidayPolicy.holidayType.id where id='" + holidayLimitId + "'");
            BigDecimal realLimit = holidayLimitInfo.getRealLimit() == null ? BigDecimal.ZERO : holidayLimitInfo.getRealLimit();
            BigDecimal usedLimit = holidayLimitInfo.getUsedLimit() == null ? BigDecimal.ZERO : holidayLimitInfo.getUsedLimit();
            BigDecimal freezeLimit = holidayLimitInfo.getFreezeLimit() == null ? BigDecimal.ZERO : holidayLimitInfo.getFreezeLimit();
            BigDecimal preOverdraftLimit = holidayLimitInfo.getPreOverdraftLimit() == null ? BigDecimal.ZERO : holidayLimitInfo.getPreOverdraftLimit();
            freezeLimit = this.decimalPlacesSystem.precisionConvert(ctx, freezeLimit.add(freezeLimit_bill), RoundingMode.HALF_UP);
            BigDecimal remainLimit_bg = this.decimalPlacesSystem.precisionConvert(ctx, realLimit.subtract(usedLimit).subtract(freezeLimit).subtract(preOverdraftLimit), RoundingMode.HALF_UP);
            HolidayLimitInfo info = holidayLimitInfo;
            info.setRemainLimit(remainLimit_bg);
            info.setFreezeLimit(freezeLimit);
            CoreBaseCollection collection = new CoreBaseCollection();
            collection.add((CoreBaseInfo)info);
            limit.recordHolidayLimit(ctx, collection, ChangeTypeEnum.billUpdate, billInfo.getNumber());
            DbUtil.execute((Context)ctx, (String)"update  t_hr_ats_holidaylimit set FRemainLimit=?,FreezeLimit=? where fid=?", (Object[])new Object[]{remainLimit_bg, freezeLimit, holidayLimitId});
            LogControlCenter logControlCenter = DataLogControlFactory.getInstance().createLogControlCenter(OperTypeEnum.holidayLimit);
            AtsLimitDataLogObserver observer = AtsLeaveBillLimitServer.assembleDataLogObserver(ctx, billInfo, entryInfo, (HolidayLimitInfo)holidayLimitInfo.clone(), false);
            logControlCenter.addObserver(observer);
            holidayLimitInfo.setRemainLimit(remainLimit_bg);
            holidayLimitInfo.setFreezeLimit(freezeLimit);
            holidayLimitInfoMemory.setRemainLimit(remainLimit_bg);
            holidayLimitInfoMemory.setUsedLimit(usedLimit);
            AtsLimitDataLogObserver newObserver = AtsLeaveBillLimitServer.assembleDataLogObserver(ctx, billInfo, entryInfo, holidayLimitInfo, true);
            logControlCenter.addObserver(newObserver);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }

    public void updateOverDraftRemainLimitNew(Context ctx, Map<String, Object> mapBalance, AtsLeaveBillInfo billInfo, AtsLeaveBillEntryInfo entryInfo) throws BOSException, EASBizException {
        try {
            BigDecimal preOverdraftLimit_bill = mapBalance.get("preOverdraftLimit") == null ? BigDecimal.ZERO : (BigDecimal)mapBalance.get("preOverdraftLimit");
            String holidayLimitId = (String)mapBalance.get("holidayLimitId");
            HolidayLimitInfo holidayLimitInfo = HolidayLimitFactory.getLocalInstance(ctx).getHolidayLimitInfo("select *,holidayPolicy.holidayType.id where id='" + holidayLimitId + "'");
            BigDecimal realLimit = holidayLimitInfo.getRealLimit() == null ? BigDecimal.ZERO : holidayLimitInfo.getRealLimit();
            BigDecimal usedLimit = holidayLimitInfo.getUsedLimit() == null ? BigDecimal.ZERO : holidayLimitInfo.getUsedLimit();
            BigDecimal freezeLimit = holidayLimitInfo.getFreezeLimit() == null ? BigDecimal.ZERO : holidayLimitInfo.getFreezeLimit();
            BigDecimal preOverdraftLimit = holidayLimitInfo.getPreOverdraftLimit() == null ? BigDecimal.ZERO : holidayLimitInfo.getPreOverdraftLimit();
            preOverdraftLimit = this.decimalPlacesSystem.precisionConvert(ctx, preOverdraftLimit.add(preOverdraftLimit_bill), RoundingMode.HALF_UP);
            BigDecimal remainLimit_bg = this.decimalPlacesSystem.precisionConvert(ctx, realLimit.subtract(usedLimit).subtract(freezeLimit).subtract(preOverdraftLimit), RoundingMode.HALF_UP);
            DbUtil.execute((Context)ctx, (String)"update  t_hr_ats_holidaylimit set FRemainLimit=?,FpreOverdraftLimit=? where fid=?", (Object[])new Object[]{remainLimit_bg, preOverdraftLimit, holidayLimitId});
            LogControlCenter logControlCenter = DataLogControlFactory.getInstance().createLogControlCenter(OperTypeEnum.holidayLimit);
            AtsLimitDataLogObserver observer = AtsLeaveBillLimitServer.assembleDataLogObserver(ctx, billInfo, entryInfo, (HolidayLimitInfo)holidayLimitInfo.clone(), false);
            logControlCenter.addObserver(observer);
            holidayLimitInfo.setRemainLimit(remainLimit_bg);
            holidayLimitInfo.setPreOverdraftLimit(preOverdraftLimit);
            AtsLimitDataLogObserver newObserver = AtsLeaveBillLimitServer.assembleDataLogObserver(ctx, billInfo, entryInfo, holidayLimitInfo, true);
            logControlCenter.addObserver(newObserver);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }

    public void updateUsedRemainLimitNew(Context ctx, Map<String, Object> mapBalance, AtsLeaveBillInfo billInfo, AtsLeaveBillEntryInfo entryInfo, HolidayLimitInfo holidayLimitInfoMemory) throws BOSException, EASBizException {
        try {
            BigDecimal usedLimit_bill = null == mapBalance.get("usedLimit") ? BigDecimal.ZERO : (BigDecimal)mapBalance.get("usedLimit");
            String holidayLimitId = (String)mapBalance.get("holidayLimitId");
            HolidayLimitInfo holidayLimitInfo = HolidayLimitFactory.getLocalInstance(ctx).getHolidayLimitInfo("select *,holidayPolicy.holidayType.id where id='" + holidayLimitId + "'");
            BigDecimal realLimit = holidayLimitInfo.getRealLimit() == null ? BigDecimal.ZERO : holidayLimitInfo.getRealLimit();
            BigDecimal usedLimit = holidayLimitInfo.getUsedLimit() == null ? BigDecimal.ZERO : holidayLimitInfo.getUsedLimit();
            BigDecimal freezeLimit = holidayLimitInfo.getFreezeLimit() == null ? BigDecimal.ZERO : holidayLimitInfo.getFreezeLimit();
            BigDecimal preOverdraftLimit = holidayLimitInfo.getPreOverdraftLimit() == null ? BigDecimal.ZERO : holidayLimitInfo.getPreOverdraftLimit();
            usedLimit = this.decimalPlacesSystem.precisionConvert(ctx, usedLimit.add(usedLimit_bill), RoundingMode.HALF_UP);
            BigDecimal remainLimit_bg = this.decimalPlacesSystem.precisionConvert(ctx, realLimit.subtract(usedLimit).subtract(freezeLimit).subtract(preOverdraftLimit), RoundingMode.HALF_UP);
            AtsLeaveBillLimit limit = new AtsLeaveBillLimit();
            CoreBaseCollection collection = new CoreBaseCollection();
            HolidayLimitInfo info = holidayLimitInfo;
            info.setRemainLimit(remainLimit_bg);
            info.setUsedLimit(usedLimit);
            collection.add((CoreBaseInfo)info);
            limit.recordHolidayLimit(ctx, collection, ChangeTypeEnum.billUpdate, billInfo.getNumber());
            DbUtil.execute((Context)ctx, (String)"update  t_hr_ats_holidaylimit set FRemainLimit=?, FUsedLimit=? where fid=?", (Object[])new Object[]{remainLimit_bg, usedLimit, holidayLimitId});
            LogControlCenter logControlCenter = DataLogControlFactory.getInstance().createLogControlCenter(OperTypeEnum.holidayLimit);
            logControlCenter.addObserver(AtsLeaveBillLimitServer.assembleDataLogObserver(ctx, billInfo, entryInfo, (HolidayLimitInfo)holidayLimitInfo.clone(), false));
            holidayLimitInfo.setRemainLimit(remainLimit_bg);
            holidayLimitInfo.setUsedLimit(usedLimit);
            logControlCenter.addObserver(AtsLeaveBillLimitServer.assembleDataLogObserver(ctx, billInfo, entryInfo, holidayLimitInfo, true));
            GenHolidayLimitManager genHolidayLimitManager = new GenHolidayLimitManager();
            HolidayLimitCollection holidayLimitCollection = new HolidayLimitCollection();
            holidayLimitCollection.add(holidayLimitInfo);
            genHolidayLimitManager.addShiftTotalRemainLimit(holidayLimitCollection, (boolean)Boolean.TRUE, ctx);
            holidayLimitInfoMemory.setRemainLimit(remainLimit_bg);
            holidayLimitInfoMemory.setUsedLimit(usedLimit);
            logControlCenter.addObserver(AtsLeaveBillLimitServer.assembleDataLogObserver(ctx, billInfo, entryInfo, holidayLimitInfo, true));
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }

    public void rollBackFreezeRemainLimitNew(Context ctx, Map<String, Object> mapBalance, AtsLeaveBillInfo billInfo, AtsLeaveBillEntryInfo entryInfo) throws BOSException, EASBizException {
        try {
            BigDecimal freezeLimit_bill = null == mapBalance.get("freezeLimit") ? BigDecimal.ZERO : (BigDecimal)mapBalance.get("freezeLimit");
            String holidayLimitId = (String)mapBalance.get("holidayLimitId");
            HolidayLimitInfo holidayLimitInfo = HolidayLimitFactory.getLocalInstance(ctx).getHolidayLimitInfo("select *,holidayPolicy.holidayType.id where id='" + holidayLimitId + "'");
            BigDecimal realLimit = holidayLimitInfo.getRealLimit() == null ? BigDecimal.ZERO : holidayLimitInfo.getRealLimit();
            BigDecimal usedLimit = holidayLimitInfo.getUsedLimit() == null ? BigDecimal.ZERO : holidayLimitInfo.getUsedLimit();
            BigDecimal freezeLimit = holidayLimitInfo.getFreezeLimit() == null ? BigDecimal.ZERO : holidayLimitInfo.getFreezeLimit();
            BigDecimal preOverdraftLimit = holidayLimitInfo.getPreOverdraftLimit() == null ? BigDecimal.ZERO : holidayLimitInfo.getPreOverdraftLimit();
            freezeLimit = this.decimalPlacesSystem.precisionConvert(ctx, freezeLimit.subtract(freezeLimit_bill), RoundingMode.HALF_UP);
            BigDecimal remainLimit_bg = this.decimalPlacesSystem.precisionConvert(ctx, realLimit.subtract(usedLimit).subtract(freezeLimit).subtract(preOverdraftLimit), RoundingMode.HALF_UP);
            DbUtil.execute((Context)ctx, (String)"update  t_hr_ats_holidaylimit set FRemainLimit=?,FreezeLimit=? where fid=?", (Object[])new Object[]{remainLimit_bg, freezeLimit, holidayLimitId});
            LogControlCenter logControlCenter = DataLogControlFactory.getInstance().createLogControlCenter(OperTypeEnum.holidayLimit);
            logControlCenter.addObserver(AtsLeaveBillLimitServer.assembleDataLogObserver(ctx, billInfo, entryInfo, (HolidayLimitInfo)holidayLimitInfo.clone(), false));
            holidayLimitInfo.setRemainLimit(remainLimit_bg);
            holidayLimitInfo.setFreezeLimit(freezeLimit);
            logControlCenter.addObserver(AtsLeaveBillLimitServer.assembleDataLogObserver(ctx, billInfo, entryInfo, holidayLimitInfo, true));
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }

    public void rollBackUsedRemainLimitNew(Context ctx, Map<String, Object> mapBalance, AtsLeaveBillInfo billInfo, AtsLeaveBillEntryInfo entryInfo) throws BOSException, EASBizException {
        try {
            BigDecimal usedLimit_bill = null == mapBalance.get("usedLimit") ? BigDecimal.ZERO : (BigDecimal)mapBalance.get("usedLimit");
            String holidayLimitId = (String)mapBalance.get("holidayLimitId");
            HolidayLimitInfo holidayLimitInfo = HolidayLimitFactory.getLocalInstance(ctx).getHolidayLimitInfo("select *,holidayPolicy.holidayType.id where id='" + holidayLimitId + "'");
            BigDecimal realLimit = holidayLimitInfo.getRealLimit() == null ? BigDecimal.ZERO : holidayLimitInfo.getRealLimit();
            BigDecimal usedLimit = holidayLimitInfo.getUsedLimit() == null ? BigDecimal.ZERO : holidayLimitInfo.getUsedLimit();
            BigDecimal freezeLimit = holidayLimitInfo.getFreezeLimit() == null ? BigDecimal.ZERO : holidayLimitInfo.getFreezeLimit();
            BigDecimal preOverdraftLimit = holidayLimitInfo.getPreOverdraftLimit() == null ? BigDecimal.ZERO : holidayLimitInfo.getPreOverdraftLimit();
            usedLimit = this.decimalPlacesSystem.precisionConvert(ctx, usedLimit.subtract(usedLimit_bill), RoundingMode.HALF_UP);
            BigDecimal remainLimit_bg = this.decimalPlacesSystem.precisionConvert(ctx, realLimit.subtract(usedLimit).subtract(freezeLimit).subtract(preOverdraftLimit), RoundingMode.HALF_UP);
            DbUtil.execute((Context)ctx, (String)"update  t_hr_ats_holidaylimit set FRemainLimit=?,FUsedLimit=? where fid=?", (Object[])new Object[]{remainLimit_bg, usedLimit, holidayLimitId});
            LogControlCenter logControlCenter = DataLogControlFactory.getInstance().createLogControlCenter(OperTypeEnum.holidayLimit);
            logControlCenter.addObserver(AtsLeaveBillLimitServer.assembleDataLogObserver(ctx, billInfo, entryInfo, (HolidayLimitInfo)holidayLimitInfo.clone(), false));
            holidayLimitInfo.setRemainLimit(remainLimit_bg);
            holidayLimitInfo.setUsedLimit(usedLimit);
            logControlCenter.addObserver(AtsLeaveBillLimitServer.assembleDataLogObserver(ctx, billInfo, entryInfo, holidayLimitInfo, true));
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }

    public void rollBackOverDraftRemainLimitNew(Context ctx, Map<String, Object> mapBalance, AtsLeaveBillInfo billInfo, AtsLeaveBillEntryInfo entryInfo) throws BOSException, EASBizException {
        try {
            BigDecimal preOverdraftLimit_bill = null == mapBalance.get("preOverdraftLimit") ? BigDecimal.ZERO : (BigDecimal)mapBalance.get("preOverdraftLimit");
            String holidayLimitId = (String)mapBalance.get("holidayLimitId");
            HolidayLimitInfo holidayLimitInfo = HolidayLimitFactory.getLocalInstance(ctx).getHolidayLimitInfo("select *,holidayPolicy.holidayType.id where id='" + holidayLimitId + "'");
            BigDecimal realLimit = holidayLimitInfo.getRealLimit() == null ? BigDecimal.ZERO : holidayLimitInfo.getRealLimit();
            BigDecimal usedLimit = holidayLimitInfo.getUsedLimit() == null ? BigDecimal.ZERO : holidayLimitInfo.getUsedLimit();
            BigDecimal freezeLimit = holidayLimitInfo.getFreezeLimit() == null ? BigDecimal.ZERO : holidayLimitInfo.getFreezeLimit();
            BigDecimal preOverdraftLimit = holidayLimitInfo.getPreOverdraftLimit() == null ? BigDecimal.ZERO : holidayLimitInfo.getPreOverdraftLimit();
            preOverdraftLimit = this.decimalPlacesSystem.precisionConvert(ctx, preOverdraftLimit.subtract(preOverdraftLimit_bill), RoundingMode.HALF_UP);
            BigDecimal remainLimit_bg = this.decimalPlacesSystem.precisionConvert(ctx, realLimit.subtract(usedLimit).subtract(freezeLimit).subtract(preOverdraftLimit), RoundingMode.HALF_UP);
            DbUtil.execute((Context)ctx, (String)"update  t_hr_ats_holidaylimit set FRemainLimit=?,FpreOverdraftLimit=? where fid=?", (Object[])new Object[]{remainLimit_bg, preOverdraftLimit, holidayLimitId});
            LogControlCenter logControlCenter = DataLogControlFactory.getInstance().createLogControlCenter(OperTypeEnum.holidayLimit);
            logControlCenter.addObserver(AtsLeaveBillLimitServer.assembleDataLogObserver(ctx, billInfo, entryInfo, (HolidayLimitInfo)holidayLimitInfo.clone(), false));
            holidayLimitInfo.setRemainLimit(remainLimit_bg);
            holidayLimitInfo.setPreOverdraftLimit(preOverdraftLimit);
            logControlCenter.addObserver(AtsLeaveBillLimitServer.assembleDataLogObserver(ctx, billInfo, entryInfo, holidayLimitInfo, true));
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }

    protected void updateFreezeUsedLimitNew(Context ctx, Map<String, Object> mapBalance, AtsLeaveBillInfo billInfo, AtsLeaveBillEntryInfo entryInfo) throws BOSException, EASBizException {
        try {
            BigDecimal usedLimit_bill = null == mapBalance.get("usedLimit") ? BigDecimal.ZERO : (BigDecimal)mapBalance.get("usedLimit");
            String holidayLimitId = (String)mapBalance.get("holidayLimitId");
            HolidayLimitInfo holidayLimitInfo = HolidayLimitFactory.getLocalInstance(ctx).getHolidayLimitInfo("select *,holidayPolicy.holidayType.id where id='" + holidayLimitId + "'");
            BigDecimal realLimit = holidayLimitInfo.getRealLimit() == null ? BigDecimal.ZERO : holidayLimitInfo.getRealLimit();
            BigDecimal fusedLimit = holidayLimitInfo.getUsedLimit() == null ? BigDecimal.ZERO : holidayLimitInfo.getUsedLimit();
            BigDecimal freezeLimit = holidayLimitInfo.getFreezeLimit() == null ? BigDecimal.ZERO : holidayLimitInfo.getFreezeLimit();
            BigDecimal preOverdraftLimit = holidayLimitInfo.getPreOverdraftLimit() == null ? BigDecimal.ZERO : holidayLimitInfo.getPreOverdraftLimit();
            BigDecimal freezeLimit_res = this.decimalPlacesSystem.precisionConvert(ctx, freezeLimit.subtract(usedLimit_bill), RoundingMode.HALF_UP);
            BigDecimal usedLimit_res = this.decimalPlacesSystem.precisionConvert(ctx, fusedLimit.add(usedLimit_bill), RoundingMode.HALF_UP);
            BigDecimal remainLimit_bg = this.decimalPlacesSystem.precisionConvert(ctx, realLimit.subtract(usedLimit_res).subtract(freezeLimit_res).subtract(preOverdraftLimit), RoundingMode.HALF_UP);
            DbUtil.execute((Context)ctx, (String)" update  t_hr_ats_holidaylimit set FreezeLimit=? ,FUsedLimit=?,FRemainLimit=? where fid=? ", (Object[])new Object[]{freezeLimit_res, usedLimit_res, remainLimit_bg, holidayLimitId});
            LogControlCenter logControlCenter = DataLogControlFactory.getInstance().createLogControlCenter(OperTypeEnum.holidayLimit);
            logControlCenter.addObserver(AtsLeaveBillLimitServer.assembleDataLogObserver(ctx, billInfo, entryInfo, (HolidayLimitInfo)holidayLimitInfo.clone(), false));
            holidayLimitInfo.setRemainLimit(remainLimit_bg);
            holidayLimitInfo.setUsedLimit(usedLimit_res);
            holidayLimitInfo.setRealLimit(remainLimit_bg);
            logControlCenter.addObserver(AtsLeaveBillLimitServer.assembleDataLogObserver(ctx, billInfo, entryInfo, holidayLimitInfo, true));
        }
        catch (Exception e) {
            logger.info((Object)"update frozen limit and used limit failed,possible reson:attence center is not exist or unavaliable or holiday type not exist in holiday policy");
            throw new BOSException((Throwable)e);
        }
    }

    public static void acquireLock(Context ctx, Set<String> objectIds) {
        HashSet<String> hasLocked = new HashSet<String>();
        boolean acquireLock = true;
        while (acquireLock) {
            for (String id : objectIds) {
                try {
                    if (!Mutex.lock((Context)ctx, (String)id)) continue;
                    hasLocked.add(id);
                }
                catch (AlreadyInProcessQueueException e) {
                    for (String lockId : hasLocked) {
                        Mutex.unlock((Context)ctx, (String)lockId);
                    }
                    try {
                        Thread.sleep(2000L);
                    }
                    catch (InterruptedException e1) {
                        e1.printStackTrace();
                    }
                    break;
                }
            }
            if (hasLocked.size() != objectIds.size()) continue;
            acquireLock = false;
            break;
        }
    }

    private static AtsLimitDataLogObserver assembleDataLogObserver(Context ctx, AtsLeaveBillInfo billInfo, AtsLeaveBillEntryInfo entryInfo, HolidayLimitInfo holidayLimitInfo, boolean isNeedCheck) {
        AtsLimitDataLogObserver observer = new AtsLimitDataLogObserver();
        observer.setObjectId(holidayLimitInfo.getId().toString());
        observer.setBillId(billInfo.getId().toString());
        observer.setBillNum(billInfo.getNumber());
        observer.setEntryId(entryInfo.getId().toString());
        observer.setPersonId(entryInfo.getPerson().getId().toString());
        observer.setOperType(OperTypeEnum.leaveBill);
        observer.setOperAction(OperActionEnum.submit);
        observer.setHolidayPolicyId(holidayLimitInfo.getHolidayPolicy().getId().toString());
        observer.setCoreBaseInfo((CoreBaseInfo)holidayLimitInfo);
        observer.setNeedCheck(isNeedCheck);
        observer.setCtx(ctx);
        return observer;
    }
}

