/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.ats.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.HROrgUnitInfo;
import com.kingdee.eas.basedata.org.PositionInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.hr.ats.AtsShiftInfo;
import com.kingdee.eas.hr.ats.AttencePolicyInfo;
import com.kingdee.eas.hr.ats.AttendanceFileCollection;
import com.kingdee.eas.hr.ats.AttendanceFileFactory;
import com.kingdee.eas.hr.ats.AttendanceFileInfo;
import com.kingdee.eas.hr.ats.CardRuleInfo;
import com.kingdee.eas.hr.ats.PunchCardRecordInfo;
import com.kingdee.eas.hr.ats.PunchCardSourceEnum;
import com.kingdee.eas.hr.ats.ScheduleShiftCollection;
import com.kingdee.eas.hr.ats.ScheduleShiftFactory;
import com.kingdee.eas.hr.ats.ScheduleShiftInfo;
import com.kingdee.eas.hr.ats.ScheduleShiftItemInfo;
import com.kingdee.eas.hr.ats.util.AtsDateUtils;
import com.kingdee.eas.hr.ats.util.AtsScheduleShiftUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.UuidException;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class AtsServerCardRuleUtils {
    public static Map<String, AttendanceFileInfo> getAttendanceFileInfoByPersonIds(Context ctx, String personIds) throws BOSException, UuidException, SQLException {
        HashMap<String, AttendanceFileInfo> attendanceFileInfoMap = new HashMap<String, AttendanceFileInfo>();
        String oql = " select *     where proposer in(" + personIds + ") and attendFileState = '" + "1" + "' order by  attendanceNum ";
        AttendanceFileCollection fileColl = AttendanceFileFactory.getLocalInstance(ctx).getAttendanceFileCollection(oql);
        int size = fileColl.size();
        for (int i = 0; i < size; ++i) {
            String key = fileColl.get(i).getId().toString();
            attendanceFileInfoMap.put(key, fileColl.get(i));
        }
        return attendanceFileInfoMap;
    }

    public static Map<String, List<ScheduleShiftInfo>> getScheduleShiftInfos(Context ctx, String personIds, String beginDate, String endDate, Map<String, AtsShiftInfo> atsShiftInfoMap) {
        HashMap<String, List<ScheduleShiftInfo>> resInfoMap = new HashMap<String, List<ScheduleShiftInfo>>();
        try {
            Map<String, AttendanceFileInfo> attendanceFileInfoMap = AtsServerCardRuleUtils.getAttendanceFileInfoByPersonIds(ctx, personIds);
            String sql = "select  scheduleshift.*  from  t_hr_ats_scheduleshift  scheduleshift  where scheduleshift.FattendDate >= {ts '" + beginDate + "'}  and   scheduleshift.FattendDate <= {ts '" + endDate + "'}  and   fproposerid in (" + personIds + ")   order by scheduleshift.FattendDate,scheduleshift.FProposerID asc ";
            IRowSet row = null;
            row = DbUtil.executeQuery((Context)ctx, (String)sql);
            while (row.next()) {
                ScheduleShiftInfo info = new ScheduleShiftInfo();
                info.setId(BOSUuid.read((String)row.getString("Fid")));
                info.setAttendDate(row.getDate("FAttendDate"));
                String attendFileID = row.getString("FAttendFileID");
                AttendanceFileInfo fileinfo = attendanceFileInfoMap.get(attendFileID);
                if (fileinfo == null || fileinfo.getAtsShift() == null) continue;
                String defaultShiftID = fileinfo.getAtsShift().getId().toString();
                AtsShiftInfo shiftInfo = new AtsShiftInfo();
                if (StringUtils.isNotBlank((String)row.getString("FDefaultShiftID"))) {
                    String FDefaultShiftID = row.getString("FDefaultShiftID");
                    shiftInfo.setId(BOSUuid.read((String)FDefaultShiftID));
                } else {
                    shiftInfo.setId(BOSUuid.read((String)defaultShiftID));
                }
                info.setDefaultShift(shiftInfo);
                if (StringUtils.isBlank((String)row.getString("FCardRuleID"))) {
                    AtsShiftInfo shiftinfo = atsShiftInfoMap.get(defaultShiftID);
                    String cardRuleID = shiftinfo.getCardRule().getId().toString();
                    CardRuleInfo ruleInfo = new CardRuleInfo();
                    ruleInfo.setId(BOSUuid.read((String)cardRuleID));
                    info.setCardRule(ruleInfo);
                } else {
                    CardRuleInfo cardRuleInfo = new CardRuleInfo();
                    if (StringUtils.isNotBlank((String)row.getString("FCardRuleID"))) {
                        String FCardRuleID = row.getString("FCardRuleID");
                        cardRuleInfo.setId(BOSUuid.read((String)FCardRuleID));
                    }
                    info.setCardRule(cardRuleInfo);
                }
                AttencePolicyInfo policyInfo = new AttencePolicyInfo();
                if (StringUtils.isNotBlank((String)row.getString("FAttendPolicyID"))) {
                    String policyid = row.getString("FAttendPolicyID");
                    policyInfo.setId(BOSUuid.read((String)policyid));
                } else {
                    policyInfo.setId(null);
                }
                info.setAttendPolicy(policyInfo);
                String personid = row.getString("FProposerID");
                PersonInfo personInfo = new PersonInfo();
                personInfo.setId(BOSUuid.read((String)personid));
                info.setProposer(personInfo);
                ArrayList<ScheduleShiftInfo> scheduleInfoList = new ArrayList<ScheduleShiftInfo>();
                String datestr = AtsDateUtils.dateShortToString(row.getDate("FAttendDate"));
                String key = personid + "_" + datestr;
                if (resInfoMap.containsKey(key)) {
                    ((List)resInfoMap.get(key)).add(info);
                    continue;
                }
                scheduleInfoList.add(info);
                resInfoMap.put(key, scheduleInfoList);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return resInfoMap;
    }

    public static List<ScheduleShiftInfo> getScheduleShiftMainInfoByPersonAndDate(Context ctx, String personIds, String beginDate, String endDate) throws BOSException, UuidException, SQLException {
        StringBuffer sqlBuffer = new StringBuffer();
        sqlBuffer.append(" select  shift.*  from  t_hr_ats_scheduleshift  shift  where shift.FattendDate >= {ts '" + beginDate + "'}  and   shift.FattendDate <= {ts '" + endDate + "'} ");
        sqlBuffer.append(" and  shift.fproposerid  in(" + personIds + ") ");
        sqlBuffer.append(" order by shift.FattendDate,shift.FProposerID asc");
        IRowSet row = null;
        row = DbUtil.executeQuery((Context)ctx, (String)sqlBuffer.toString());
        ArrayList<ScheduleShiftInfo> scheduleShiftInfoList = new ArrayList<ScheduleShiftInfo>();
        while (row.next()) {
            ScheduleShiftInfo info = new ScheduleShiftInfo();
            info.setId(BOSUuid.read((String)row.getString("FID")));
            info.setAttendDate(row.getDate("FAttendDate"));
            AtsShiftInfo shiftInfo = new AtsShiftInfo();
            if (StringUtils.isNotBlank((String)row.getString("FDefaultShiftID"))) {
                shiftInfo.setId(BOSUuid.read((String)row.getString("FDefaultShiftID")));
            }
            info.setDefaultShift(shiftInfo);
            CardRuleInfo cardRuleInfo = new CardRuleInfo();
            if (StringUtils.isNotBlank((String)row.getString("FCardRuleID"))) {
                cardRuleInfo.setId(BOSUuid.read((String)row.getString("FCardRuleID")));
            }
            info.setCardRule(cardRuleInfo);
            AttencePolicyInfo policyInfo = new AttencePolicyInfo();
            if (StringUtils.isNotBlank((String)row.getString("FAttendPolicyID"))) {
                String policyid = row.getString("FAttendPolicyID");
                policyInfo.setId(BOSUuid.read((String)policyid));
            } else {
                policyInfo.setId(null);
            }
            info.setAttendPolicy(policyInfo);
            PersonInfo personInfo = new PersonInfo();
            personInfo.setId(BOSUuid.read((String)row.getString("FProposerID")));
            info.setProposer(personInfo);
            AdminOrgUnitInfo org = new AdminOrgUnitInfo();
            PositionInfo positionInfo = new PositionInfo();
            HROrgUnitInfo hrinfo = new HROrgUnitInfo();
            if (StringUtils.isNotBlank((String)row.getString("FAdminOrgUnitID"))) {
                org.setId(BOSUuid.read((String)row.getString("FAdminOrgUnitID")));
            }
            if (StringUtils.isNotBlank((String)row.getString("FPositionID"))) {
                positionInfo.setId(BOSUuid.read((String)row.getString("FPositionID")));
            }
            if (StringUtils.isNotBlank((String)row.getString("FHrOrgUnitID"))) {
                hrinfo.setId(BOSUuid.read((String)row.getString("FHrOrgUnitID")));
            }
            info.setAdminOrgUnit(org);
            info.setPosition(positionInfo);
            info.setHrOrgUnit(hrinfo);
            ScheduleShiftItemInfo item = new ScheduleShiftItemInfo();
            scheduleShiftInfoList.add(info);
            info = null;
        }
        return scheduleShiftInfoList;
    }

    public static Map<String, List<ScheduleShiftInfo>> getScheduleShiftMainInfos(Context ctx, String personIds, String beginDate, String endDate) throws BOSException, UuidException, SQLException {
        String oql = " select *,items.*  where  proposer in (" + personIds + ")  and attendDate >='" + beginDate + "'  and  attendDate <='" + endDate + "'  order by\t attendDate, items.segment asc ";
        ScheduleShiftCollection scheduleShiftColl = ScheduleShiftFactory.getLocalInstance(ctx).getScheduleShiftCollection(oql);
        HashMap<String, List<ScheduleShiftInfo>> scheduleShiftInfoMap = new HashMap<String, List<ScheduleShiftInfo>>();
        List<String> daysList = AtsDateUtils.getDateList(beginDate, endDate);
        List personDaysList = AtsDateUtils.getPersonAndDateList(daysList, personIds);
        for (Object dayList : personDaysList) {
            String person_date = (String)dayList;
            String[] personDateArr = person_date.split("_");
            Timestamp compareDate = AtsDateUtils.stringShortToTimestamp(personDateArr[1]);
            ArrayList<ScheduleShiftInfo> scheduleShifInfoList = new ArrayList<ScheduleShiftInfo>();
            int size = scheduleShiftColl.size();
            for (int j = 0; j < size; ++j) {
                ScheduleShiftInfo shiftInfo = scheduleShiftColl.get(j);
                Date attDate = shiftInfo.getAttendDate();
                Timestamp entryDate = AtsDateUtils.dateToTimestamp(attDate);
                String key = shiftInfo.getProposer().getId().toString() + "_" + AtsDateUtils.dateShortToString(attDate);
                if (key.equals(person_date)) {
                    scheduleShifInfoList.add(shiftInfo);
                }
                if (entryDate.getTime() > compareDate.getTime()) break;
            }
            scheduleShiftInfoMap.put(person_date, scheduleShifInfoList);
        }
        return scheduleShiftInfoMap;
    }

    public static Map<String, List<ScheduleShiftInfo>> getScheduleShiftMainInfosForCardRuleV2(Context ctx, String personIds, String beginDate, String endDate) throws BOSException, UuidException, SQLException {
        Map<String, List<ScheduleShiftInfo>> resMap = AtsScheduleShiftUtil.getScheduleShiftMapByPriority(ctx, personIds, beginDate, endDate);
        return resMap;
    }

    public static Map<String, List<PunchCardRecordInfo>> getPunchCardRecordInfos(Context ctx, String personIds, String beginDate, String endDate) throws BOSException, UuidException, SQLException {
        String beginDatestr = AtsDateUtils.getPreDay(beginDate, 2);
        String endDatestr = AtsDateUtils.getNextDay(endDate, 2);
        String resBeginTime = beginDatestr + " " + "00:00:00";
        String resEndTime = endDatestr + " " + "23:59:59";
        String sql_query = "select  pd.FID,pd.FProposerID,pd.FPunchCardDate,pd.FPunchCardTime,pd.FPunchCardSource,pd.FAttendanceNum  from  T_HR_ATS_PunchCardRecord  pd  where pd.FPunchCardTime >= {ts '" + resBeginTime + "'}  and   pd.FPunchCardTime <= {ts '" + resEndTime + "'}   and   pd.FProposerID in (" + personIds + ")  and   pd.FPunchCardState is null  order by pd.FPunchCardDate, pd.FPunchCardTime ";
        IRowSet row_query = null;
        row_query = DbUtil.executeQuery((Context)ctx, (String)sql_query);
        HashMap<String, List<PunchCardRecordInfo>> resMap = new HashMap<String, List<PunchCardRecordInfo>>();
        while (row_query.next()) {
            PunchCardRecordInfo info = new PunchCardRecordInfo();
            info.setId(BOSUuid.read((String)row_query.getString("FID")));
            String personid = row_query.getString("FProposerID");
            PersonInfo pInfo = new PersonInfo();
            pInfo.setId(BOSUuid.read((String)personid));
            info.setProposer(pInfo);
            info.setPunchCardDate(row_query.getDate("FPunchCardDate"));
            info.setPunchCardTime(row_query.getTimestamp("FPunchCardTime"));
            if (row_query.getInt("FPunchCardSource") == 0) {
                info.setPunchCardSource(PunchCardSourceEnum.attenceMachine);
            } else if (row_query.getInt("FPunchCardSource") == 1) {
                info.setPunchCardSource(PunchCardSourceEnum.mobileRegistration);
            } else if (row_query.getInt("FPunchCardSource") == 2) {
                info.setPunchCardSource(PunchCardSourceEnum.fillCard);
            } else if (row_query.getInt("FPunchCardSource") == 3) {
                info.setPunchCardSource(PunchCardSourceEnum.signCard);
            }
            String datestr = AtsDateUtils.dateShortToString(row_query.getDate("FPunchCardDate"));
            String key = personid + "_" + datestr;
            ArrayList<PunchCardRecordInfo> pRecordList = new ArrayList<PunchCardRecordInfo>();
            if (resMap.containsKey(key)) {
                ((List)resMap.get(key)).add(info);
            } else {
                pRecordList.add(info);
                resMap.put(key, pRecordList);
            }
            info = null;
        }
        return resMap;
    }

    public static void main(String[] args) {
        System.out.println("AtsServerCardRuleUtils");
    }
}

