/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.ats.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.base.permission.api.auth.SHRUserOrgPermissionApi;
import com.kingdee.shr.base.syssetting.app.filter.HRFilterUtils;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang.StringUtils;

public class AtsTeamPermServerUtils {
    private static final String LAST_ORG_RELATION_DATE_CONDITION = "{ts'2199-12-31'}";

    private AtsTeamPermServerUtils() {
    }

    public static String getTeamAdminOrgRangeSQL(Context ctx, String currentRequestPermItemId) {
        String userId = HRFilterUtils.getCurrentUserId((Context)ctx);
        return SHRUserOrgPermissionApi.getUserHeadOfDepartmentAdminRangeSQL((Context)ctx, (String)userId, (String)currentRequestPermItemId);
    }

    public static Set<String> getTeamAdminOrgRangeIdSet(Context ctx, String currentRequestPermItemId) {
        String userId = HRFilterUtils.getCurrentUserId((Context)ctx);
        return SHRUserOrgPermissionApi.getUserHeadOfDepartmentAdminRangeSet((Context)ctx, (String)userId, (String)currentRequestPermItemId);
    }

    public static Set<String> getCurrentRequestLeaderAdminOrgRangeIdSet(Context ctx, String userId) {
        HashSet<String> results = new HashSet<String>();
        String adminSql1 = AtsTeamPermServerUtils.getPersonPositionResponseAdminSql(userId);
        try {
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)adminSql1);
            while (rowSet.next()) {
                String forgId = rowSet.getString("forgId");
                if (!StringUtils.isNotEmpty((String)forgId)) continue;
                results.add(forgId);
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return results;
    }

    public static String getAdminRangeSql(Context ctx, String userId, String permItemId) {
        return "select adminOrg.fid as forgId from t_org_admin adminOrg where fid in (" + SHRUserOrgPermissionApi.getUserAdminRangeSQL((Context)ctx, (String)userId, (String)permItemId) + ")";
    }

    public static boolean isLeader(Context ctx, String personId) {
        StringBuffer sql = new StringBuffer();
        sql.append("select fpersonid ").append("from T_HR_PersonPositionExtend ").append(" where fpersonid = ?").append(" and fisleader=1 ");
        IRowSet rs = null;
        try {
            rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{personId});
        }
        catch (BOSException var5) {
            var5.printStackTrace();
            return false;
        }
        return rs.size() > 0;
    }

    private static String getPersonPositionResponseAdminSql(String userId) {
        return new StringBuffer("select child.fid as forgId").append(" from T_HR_EmpOrgRelation emprelation").append(" inner join T_PM_User pmuser on pmuser.fpersonid = emprelation.fpersonid").append(" inner join T_ORG_Position position on position.fid= emprelation.fpositionid").append(" inner join T_ORG_Admin adcount on position.fadminorgunitid = adcount.fid").append(" left join T_ORG_Admin child on (charindex(concat(adcount.flongnumber,'!'),child.flongnumber) = 1 or adcount.flongnumber = child.flongnumber)").append(" where pmuser.fid = '").append(userId).append("'").append(" and emprelation.fleffdt = ").append(LAST_ORG_RELATION_DATE_CONDITION).append(" and emprelation.FIsLatestInAday = 1").append(" and position.fisrespposition = 1").append(" and child.fissealup = 0").append(" and child.fisstartshr = 1").toString();
    }

    private static String getSinglePersonPositionResponseAdminSql(String userId) {
        return "select adcount.fid as forgId from T_HR_EmpOrgRelation emprelation inner join T_PM_User pmuser on pmuser.fpersonid = emprelation.fpersonid inner join T_ORG_Position position on position.fid= emprelation.fpositionid inner join T_ORG_Admin adcount on position.fadminorgunitid = adcount.fid where pmuser.fid = '" + userId + "' and emprelation.fleffdt = " + LAST_ORG_RELATION_DATE_CONDITION + " and emprelation.FIsLatestInAday = 1 and position.fisrespposition = 1 and adcount.fissealup = 0 and adcount.fisstartshr = 1";
    }
}

