/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.ats.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.hr.ats.AtsOtherBizException;
import com.kingdee.eas.hr.ats.util.common.AtsCollectionUtile;
import com.kingdee.eas.hr.ats.util.common.AtsCommonUtile;
import com.kingdee.eas.hr.ats.util.common.AtsLog;
import com.kingdee.portal.biz.common.exception.BizException;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.jdom2.Element;
import org.jdom2.input.SAXBuilder;

public class AtsViewUtile {
    public static SelectorItemCollection getSelectors(String ... selectors) {
        SelectorItemCollection items = new SelectorItemCollection();
        if (!AtsCollectionUtile.isEmpty(selectors)) {
            for (String selector : selectors) {
                items.add(selector);
            }
        }
        return items;
    }

    public static EntityViewInfo getViewBySelector(List<String> selectors) {
        return AtsViewUtile.getViewBySelector(selectors, null);
    }

    public static EntityViewInfo getViewBySelector(String[] selectors) {
        return AtsViewUtile.getViewBySelector(selectors, null);
    }

    public static EntityViewInfo getViewBySelector(List<String> selectors, EntityViewInfo entityViewInfo) {
        return AtsViewUtile.getViewBySelector(selectors.toArray(new String[selectors.size()]), entityViewInfo);
    }

    public static EntityViewInfo getViewBySelector(String[] selectors, EntityViewInfo entityViewInfo) {
        EntityViewInfo returnViewInfo = entityViewInfo == null ? new EntityViewInfo() : entityViewInfo;
        SelectorItemCollection sic = returnViewInfo.getSelector();
        for (String selector : selectors) {
            sic.add(new SelectorItemInfo(selector));
        }
        return returnViewInfo;
    }

    public static EntityViewInfo getViewByFilter(String compareExpr, Object compareValue, CompareType compareType) {
        return AtsViewUtile.getViewByFilter(compareExpr, compareValue, compareType, null);
    }

    public static EntityViewInfo getViewByFilter(String compareExpr, Object compareValue, CompareType compareType, EntityViewInfo entityViewInfo) {
        EntityViewInfo returnViewInfo = entityViewInfo == null ? new EntityViewInfo() : entityViewInfo;
        FilterInfo addedFilterInfo = new FilterInfo();
        if (compareType == CompareType.INCLUDE && compareValue instanceof Collection && !(compareValue instanceof Set)) {
            compareValue = new HashSet(compareValue);
        }
        addedFilterInfo.getFilterItems().add(new FilterItemInfo(compareExpr, (Object)compareValue, compareType));
        if (returnViewInfo.getFilter() == null) {
            returnViewInfo.setFilter(addedFilterInfo);
        } else {
            FilterInfo filterInfo = new FilterInfo();
            try {
                filterInfo.mergeFilter(returnViewInfo.getFilter(), "AND");
                filterInfo.mergeFilter(addedFilterInfo, "AND");
            }
            catch (BOSException e) {
                AtsLog.getLog().error((Object)"filer_combine_error", (Throwable)e);
            }
            returnViewInfo.setFilter(filterInfo);
        }
        return returnViewInfo;
    }

    public static EntityViewInfo getViewByFilter(String property, Object value, EntityViewInfo entityViewInfo) {
        EntityViewInfo returnViewInfo = entityViewInfo == null ? new EntityViewInfo() : entityViewInfo;
        FilterInfo addedFilterInfo = new FilterInfo();
        addedFilterInfo.getFilterItems().add(new FilterItemInfo(property, value));
        if (returnViewInfo.getFilter() == null) {
            returnViewInfo.setFilter(addedFilterInfo);
        } else {
            FilterInfo filterInfo = new FilterInfo();
            try {
                filterInfo.mergeFilter(returnViewInfo.getFilter(), "AND");
                filterInfo.mergeFilter(addedFilterInfo, "AND");
            }
            catch (BOSException e) {
                AtsLog.getLog().error((Object)"filer_combine_error", (Throwable)e);
            }
            returnViewInfo.setFilter(filterInfo);
        }
        return returnViewInfo;
    }

    public static EntityViewInfo getViewByFilters(String[][] filters, EntityViewInfo entityViewInfo) {
        EntityViewInfo returnViewInfo = entityViewInfo == null ? new EntityViewInfo() : entityViewInfo;
        FilterInfo filterInfo = returnViewInfo.getFilter();
        filterInfo = filterInfo == null ? new FilterInfo() : filterInfo;
        for (String[] filter : filters) {
            filterInfo.getFilterItems().add(new FilterItemInfo(filter[0], (Object)filter[1]));
        }
        returnViewInfo.setFilter(filterInfo);
        return returnViewInfo;
    }

    public static EntityViewInfo getViewByExistFilterInfo(FilterInfo filterInfo, EntityViewInfo entityViewInfo) {
        EntityViewInfo returnViewInfo = entityViewInfo == null ? new EntityViewInfo() : entityViewInfo;
        returnViewInfo.setFilter(filterInfo);
        return returnViewInfo;
    }

    public static EntityViewInfo addSorter(String sorterField, SortType sortType) {
        return AtsViewUtile.addSorter(sorterField, sortType, null);
    }

    public static EntityViewInfo addSorter(String sorterField, SortType sortType, EntityViewInfo entityViewInfo) {
        EntityViewInfo returnViewInfo = entityViewInfo == null ? new EntityViewInfo() : entityViewInfo;
        SorterItemInfo sorterItem = new SorterItemInfo(sorterField);
        sorterItem.setSortType(sortType == null ? SortType.ASCEND : sortType);
        returnViewInfo.getSorter().add(sorterItem);
        return returnViewInfo;
    }

    public static FilterInfo getAllowNullFilter(CompareType compareType, Collection<CompareType> allowNullType, String field, Object value, FilterInfo filterInfo) {
        filterInfo = filterInfo == null ? new FilterInfo() : filterInfo;
        boolean isLike = CompareType.LIKE.equals((Object)compareType) || CompareType.NOTLIKE.equals((Object)compareType);
        Object object = value = isLike ? "%" + AtsCommonUtile.correctStr(value) + "%" : value;
        if (allowNullType.size() > 0 && allowNullType.contains(compareType)) {
            try {
                FilterInfo nullFilter = new FilterInfo();
                nullFilter.getFilterItems().add(new FilterItemInfo(field, null, CompareType.EQUALS));
                FilterInfo originfiler = new FilterInfo();
                originfiler.getFilterItems().add(new FilterItemInfo(field, value, compareType));
                originfiler.mergeFilter(nullFilter, "OR");
                filterInfo.mergeFilter(originfiler, "AND");
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
        } else {
            FilterInfo thisFilter = new FilterInfo();
            thisFilter.getFilterItems().add(new FilterItemInfo(field, value, compareType));
            try {
                filterInfo.mergeFilter(thisFilter, "AND");
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
        }
        return filterInfo;
    }

    public static FilterInfo getAllowNullFilter(CompareType compareType, CompareType allowNullType, String field, Object value, FilterInfo filterInfo) {
        return AtsViewUtile.getAllowNullFilter(compareType, com.kingdee.bos.util.backport.Collections.singletonList((Object)allowNullType), field, value, filterInfo);
    }

    public static FilterInfo assembleFilter(CompareType compareType, Collection<Object> filterValeus, String field, FilterInfo filterInfo) {
        FilterInfo filterInfo2 = filterInfo = filterInfo == null ? new FilterInfo() : filterInfo;
        if (AtsCollectionUtile.isEmpty(filterValeus)) {
            return filterInfo;
        }
        boolean isLike = CompareType.LIKE.equals((Object)compareType) || CompareType.NOTLIKE.equals((Object)compareType);
        FilterInfo thisFilter = new FilterInfo();
        try {
            for (Object fieldVal : filterValeus) {
                FilterInfo currentFileter = new FilterInfo();
                fieldVal = isLike ? "%" + AtsCommonUtile.correctStr(fieldVal) + "%" : fieldVal;
                currentFileter.getFilterItems().add(new FilterItemInfo(field, fieldVal, compareType));
                thisFilter.mergeFilter(currentFileter, compareType == CompareType.NOTLIKE ? "and" : "OR");
            }
            filterInfo.mergeFilter(thisFilter, "AND");
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return filterInfo;
    }

    public static FilterInfo assembleFilter(CompareType compareType, String field, Object filterValue, FilterInfo filterInfo) {
        filterInfo = filterInfo == null ? new FilterInfo() : filterInfo;
        boolean isLike = CompareType.LIKE.equals((Object)compareType) || CompareType.NOTLIKE.equals((Object)compareType);
        filterValue = isLike ? "%" + AtsCommonUtile.correctStr(filterValue) + "%" : filterValue;
        FilterInfo thisFilter = new FilterInfo();
        thisFilter.getFilterItems().add(new FilterItemInfo(field, filterValue, compareType));
        try {
            filterInfo.mergeFilter(thisFilter, "AND");
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return filterInfo;
    }

    public static Object convertDataByType(String value, String dataType) {
        if (StringUtils.isEmpty((String)value)) {
            return value;
        }
        if (value.indexOf(",") > -1 || value.indexOf("\uff0c") > -1) {
            HashSet set = new HashSet();
            Collections.addAll(set, value.split(",|\uff0c"));
            return set;
        }
        if ("String".equalsIgnoreCase(dataType) || "StringEnum".equalsIgnoreCase(dataType)) {
            return value;
        }
        if ("Date".equalsIgnoreCase(dataType)) {
            return AtsCommonUtile.getDate(value);
        }
        if ("Boolean".equalsIgnoreCase(dataType)) {
            return Integer.parseInt(value);
        }
        if ("Integer".equalsIgnoreCase(dataType) || "IntEnum".equalsIgnoreCase(dataType)) {
            return Integer.parseInt(value);
        }
        if ("BigDecimal".equalsIgnoreCase(dataType)) {
            return new BigDecimal(value);
        }
        return value;
    }

    public static Map<String, Element> parseUiview(String uiViewContent, List<String> fields) throws BizException {
        Element root;
        if (StringUtils.isBlank((String)uiViewContent)) {
            return null;
        }
        SAXBuilder builder = new SAXBuilder();
        try {
            root = builder.build((InputStream)new ByteArrayInputStream(uiViewContent.getBytes("utf-8"))).getRootElement();
        }
        catch (Exception e) {
            throw new BizException((Throwable)((Object)new AtsOtherBizException(AtsOtherBizException.FETCHROOTELEERROR, e)));
        }
        HashMap<String, Element> returnData = new HashMap<String, Element>();
        AtsViewUtile.findEle(root, returnData, new ArrayList<String>(fields));
        return returnData;
    }

    public static void findEle(Element root, Map<String, Element> eleMap, List<String> fields) {
        if (AtsCollectionUtile.isEmpty(fields)) {
            return;
        }
        for (Object child : root.getChildren()) {
            if (!(child instanceof Element)) continue;
            Element ele = (Element)child;
            for (int i = 0; i < fields.size(); ++i) {
                if (!StringUtils.equalsIgnoreCase((String)ele.getAttributeValue("name"), (String)fields.get(i))) continue;
                eleMap.put(fields.get(i), ele);
                fields.remove(i);
                --i;
                break;
            }
            AtsViewUtile.findEle(ele, eleMap, fields);
        }
    }
}

