/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.ats.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.hr.ats.util.AtsDateUtils;
import com.kingdee.eas.util.app.DbUtil;
import java.sql.Date;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class AtsWaitCalBatchThread
implements Runnable {
    private static Logger logger = Logger.getLogger(AtsWaitCalBatchThread.class);
    private Map<String, List<String>> personsAndDates;
    private Context ctx;

    public AtsWaitCalBatchThread(Context ctx, Map<String, List<String>> personsAndDates) {
        this.personsAndDates = personsAndDates;
        this.ctx = ctx;
    }

    @Override
    public void run() {
        String sql = "update  T_HR_ATS_AttendanceResult set FAttenceStatus ='4' where FProposerID= ? and FAttenceDate= ?and FAttenceStatus ='1'";
        ArrayList<Object[]> params = new ArrayList<Object[]>();
        Object[] param = null;
        for (Map.Entry<String, List<String>> entry : this.personsAndDates.entrySet()) {
            String personId = entry.getKey();
            List<String> dateList = entry.getValue();
            for (String date : dateList) {
                param = new Object[]{personId, new Date(AtsDateUtils.stringToShortDate(date).getTime())};
                params.add(param);
            }
        }
        long startTime = System.currentTimeMillis();
        try {
            DbUtil.executeBatch((Context)this.ctx, (String)sql, params);
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        long endTime = System.currentTimeMillis();
        logger.error((Object)("SetWaitCal:end,num :" + params.size() + "," + (endTime - startTime) + " ms."));
    }
}

