/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.ats.util.common;

import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.ats.AtsResEnum;
import com.kingdee.eas.hr.ats.util.common.AtsCommonUtile;
import com.kingdee.eas.hr.ats.util.common.AtsContextUtile;
import com.kingdee.eas.hr.ats.util.common.AtsEntityUtile;
import com.kingdee.eas.hr.ats.util.common.MLUtile;
import com.kingdee.eas.hr.base.HRCommonException;
import com.kingdee.util.enums.Enum;
import java.util.Iterator;
import org.apache.commons.collections4.IteratorUtils;
import org.apache.commons.collections4.ResettableIterator;
import org.apache.commons.lang3.StringUtils;

public class Assert
extends org.springframework.util.Assert {
    public static void fieldNotNull(CoreBaseInfo coreBase, String ... fields) throws EASBizException {
        if (fields == null) {
            return;
        }
        for (String field : fields) {
            Assert.fieldNotNull(coreBase, field);
        }
    }

    public static void fieldNotNull(CoreBaseInfo coreBase, String field) throws EASBizException {
        ResettableIterator iterator;
        if (StringUtils.isBlank((CharSequence)field)) {
            return;
        }
        Object fieldVal = coreBase == null ? null : coreBase.get(StringUtils.substringBefore((String)field, (String)"."));
        boolean isNull = fieldVal == null || fieldVal instanceof String && StringUtils.isBlank((CharSequence)fieldVal.toString());
        boolean isLinkField = StringUtils.contains((CharSequence)field, (CharSequence)".");
        Object object = iterator = isNull || !isLinkField ? IteratorUtils.emptyIterator() : IteratorUtils.getIterator((Object)fieldVal);
        while (iterator.hasNext()) {
            Object item = iterator.next();
            boolean bl = isNull = isNull || !(item instanceof CoreBaseInfo);
            if (isNull) break;
            Assert.fieldNotNull((CoreBaseInfo)item, StringUtils.substringAfter((String)field, (String)"."));
        }
        if (isNull) {
            Context ctx = AtsContextUtile.getCtx();
            String msg = MLUtile.getRes((Enum)AtsResEnum.notEmpty, ctx, AtsEntityUtile.getFieldAlias(ctx, coreBase, field));
            throw new HRCommonException(HRCommonException.EXCEPTION_MSG, new Object[]{msg});
        }
    }

    public static void fieldNotBe(CoreBaseInfo coreBase, Object canNotBeVal, String ... fields) throws EASBizException {
        if (fields == null) {
            return;
        }
        for (String field : fields) {
            Assert.fieldNotBe(coreBase, canNotBeVal, field);
        }
    }

    public static void fieldNotBe(CoreBaseInfo coreBase, Object canNotBeVal, String field) throws EASBizException {
        Object actVal;
        if (canNotBeVal == null) {
            Assert.fieldNotNull(coreBase, field);
            return;
        }
        if (coreBase == null || StringUtils.isBlank((CharSequence)field)) {
            return;
        }
        Object fieldVal = coreBase.get(StringUtils.substringBefore((String)field, (String)"."));
        if (StringUtils.contains((CharSequence)field, (CharSequence)".")) {
            Iterator iterator = IteratorUtils.getIterator((Object)fieldVal);
            while (iterator.hasNext()) {
                Object item = iterator.next();
                if (!(item instanceof CoreBaseInfo)) continue;
                Assert.fieldNotBe((CoreBaseInfo)item, canNotBeVal, StringUtils.substringAfter((String)field, (String)"."));
            }
        }
        if ((actVal = coreBase.get(field)) instanceof Number && canNotBeVal instanceof Number) {
            actVal = Double.parseDouble(actVal.toString());
            canNotBeVal = Double.parseDouble(canNotBeVal.toString());
        }
        if (AtsCommonUtile.equals(canNotBeVal, actVal)) {
            Context ctx = AtsContextUtile.getCtx();
            String msg = MLUtile.getRes((Enum)AtsResEnum.canNotBe, ctx, AtsEntityUtile.getFieldAlias(ctx, coreBase, field), canNotBeVal);
            throw new HRCommonException(HRCommonException.EXCEPTION_MSG, new Object[]{msg});
        }
    }

    public static void fieldNotEqual(CoreBaseInfo coreBase, String firstField, String secondField) throws EASBizException {
        Assert.fieldCompare(coreBase, firstField, secondField, 0);
    }

    public static void fieldNotLarge(CoreBaseInfo coreBase, String firstField, String secondField) throws EASBizException {
        Assert.fieldCompare(coreBase, firstField, secondField, 1);
    }

    public static void fieldNotLess(CoreBaseInfo coreBase, String firstField, String secondField) throws EASBizException {
        Assert.fieldCompare(coreBase, firstField, secondField, -1);
    }

    public static void fieldCompare(CoreBaseInfo coreBase, String firstField, String secondField, int expectCompareResult) throws EASBizException {
        if (coreBase == null || StringUtils.isBlank((CharSequence)firstField) || StringUtils.isBlank((CharSequence)secondField)) {
            return;
        }
        Object firstVal = coreBase.get(firstField);
        Object secondVal = coreBase.get(secondField);
        if (firstVal instanceof Number && secondVal instanceof Number) {
            firstVal = Double.parseDouble(firstVal.toString());
            secondVal = Double.parseDouble(secondVal.toString());
        }
        AtsResEnum msgEnum = null;
        if (expectCompareResult == 0) {
            msgEnum = AtsCommonUtile.equals(firstVal, secondVal) ? AtsResEnum.notEqual : null;
        } else if (firstVal instanceof Comparable && secondVal instanceof Comparable) {
            int compareRes = ((Comparable)firstVal).compareTo(secondVal);
            msgEnum = expectCompareResult > 0 ? (compareRes > 0 ? AtsResEnum.notLarge : null) : (compareRes < 0 ? AtsResEnum.notLess : null);
        } else {
            String msg = String.format("%s can not compare with %s!", firstVal, secondVal);
            throw new HRCommonException(HRCommonException.EXCEPTION_MSG, new Object[]{msg});
        }
        if (msgEnum != null) {
            Context ctx = AtsContextUtile.getCtx();
            String msg = MLUtile.getRes((Enum)msgEnum, ctx, AtsEntityUtile.getFieldAlias(ctx, coreBase, firstField), AtsEntityUtile.getFieldAlias(ctx, coreBase, secondField));
            throw new HRCommonException(HRCommonException.EXCEPTION_MSG, new Object[]{msg});
        }
    }

    public static void throwMsg(String msg) throws EASBizException {
        if (StringUtils.isNotBlank((CharSequence)msg)) {
            throw new HRCommonException(HRCommonException.EXCEPTION_MSG, new Object[]{msg});
        }
    }
}

