/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.ats.util.common;

import com.kingdee.eas.hr.ats.util.common.AtsCommonUtile;
import com.kingdee.eas.hr.ats.util.common.ConfigAts;
import com.kingdee.eas.hr.ats.util.common.LoggerFactory;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Appender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.RollingFileAppender;

public class AtsLog {
    private static LoggerFactory loggerFactory = new LoggerFactory();
    public static final Map<String, Logger> logContainer = new HashMap<String, Logger>();
    public static final String FILE_DEFAULT = "ats";
    public static String conversionPattern = "%n[%d{MMdd HH:mm:ss} %p %t %F %M %L]%m";
    public static final String PATH_DEFAULT = System.getProperty("EAS_HOME") + "/server/shr_ats_log";

    public static Logger getLogger(String filePath, String fileName, Map<String, String> configMap) {
        filePath = PATH_DEFAULT + (StringUtils.isEmpty((String)filePath) ? "" : "/" + filePath);
        fileName = StringUtils.isEmpty((String)fileName) ? FILE_DEFAULT : fileName;
        configMap = configMap == null ? new HashMap(0) : configMap;
        String file = filePath + "/" + fileName;
        Level level = Level.toLevel((String)((String)configMap.get("level")), (Level)Level.ERROR);
        Logger logger = logContainer.get(file);
        if (logger != null) {
            logger.setLevel(level);
            return logger;
        }
        RollingFileAppender appender = new RollingFileAppender();
        logger = Logger.getLogger((String)file, (org.apache.log4j.spi.LoggerFactory)loggerFactory);
        logger.removeAllAppenders();
        logger.addAppender((Appender)appender);
        logger.setLevel(level);
        logger.setAdditivity(Boolean.valueOf(AtsCommonUtile.getFromMap(configMap, (Object)"additivity", "true")).booleanValue());
        PatternLayout layout = new PatternLayout();
        layout.setConversionPattern(AtsCommonUtile.getFromMap(configMap, (Object)"conversionPattern", conversionPattern));
        int maxBackupIndex = 20;
        try {
            maxBackupIndex = Integer.valueOf(AtsCommonUtile.getFromMap(configMap, "maxBackupIndex"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        appender.setMaxBackupIndex(maxBackupIndex);
        appender.setLayout((Layout)layout);
        appender.setFile(file + ".log");
        appender.setEncoding(AtsCommonUtile.getFromMap(configMap, (Object)"encoding", "UTF-8"));
        appender.setAppend(Boolean.valueOf(AtsCommonUtile.getFromMap(configMap, (Object)"append", "true")).booleanValue());
        appender.setMaxFileSize(AtsCommonUtile.getFromMap(configMap, (Object)"maxFileSize", "5MB"));
        appender.activateOptions();
        logContainer.put(file, logger);
        return logger;
    }

    public static Logger getWSLog() {
        return AtsLog.getLogger("workShift", "workShift", Collections.singletonMap("level", ConfigAts.LOG_LEVEL_SCHEDULEL.toString()));
    }

    public static Logger getAttendanceFileLog() {
        return AtsLog.getLogger("attendance", "attendanceFile", Collections.singletonMap("level", Level.ERROR.toString()));
    }

    public static Logger getPunchcardCloudLog() {
        HashMap<String, String> map = new HashMap<String, String>(2);
        map.put("level", ConfigAts.LOG_LEVEL_PUNCHCARD_SYN.toString());
        map.put("additivity", "false");
        return AtsLog.getLogger("shr_ats_punchcard_log", "getkdcloudpunchcard", map);
    }

    public static Logger getDataDumpLog() {
        HashMap<String, String> map = new HashMap<String, String>(2);
        map.put("level", Level.INFO.toString());
        map.put("additivity", "false");
        return AtsLog.getLogger("shr_ats_datadump_log", "datadump", map);
    }

    public static Logger getLog() {
        return AtsLog.getLogger(null, null, Collections.singletonMap("level", ConfigAts.LOG_LEVEL_COMMON.toString()));
    }
}

