/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.ats.util.common;

import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.sql.DbType;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.hr.ats.util.AtsViewUtile;
import com.kingdee.eas.hr.ats.util.common.AtsCollectionUtile;
import com.kingdee.eas.hr.ats.util.common.AtsConstants;
import com.kingdee.eas.hr.ats.util.common.AtsEntityUtile;
import com.kingdee.eas.hr.ats.util.common.AtsLog;
import com.kingdee.eas.hr.ats.util.common.OneFieldProcessor;
import com.kingdee.eas.hr.ats.util.common.TwoFieldProcessor;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.lang.reflect.Array;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;

public class AtsSqlUtile {
    private static final Pattern PATTERN_INSQL = Pattern.compile(" in\\s*\\(\\s*\\?\\s*\\)", 2);

    public static int getTotalCount(Context ctx, String sql) {
        if (StringUtils.isNotEmpty((String)sql)) {
            StringBuffer sb = new StringBuffer(sql);
            StringBuffer lowSb = new StringBuffer(sql.toLowerCase());
            int orderInd = 0;
            int brackedInd = 0;
            while (lowSb.indexOf(" order ") != -1) {
                orderInd = lowSb.indexOf(" order ");
                brackedInd = lowSb.indexOf(")", orderInd);
                if (brackedInd < 0) {
                    brackedInd = lowSb.length();
                }
                lowSb.replace(orderInd, brackedInd, " ");
                sb.replace(orderInd, brackedInd, " ");
            }
            try {
                IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)("select count(*) from (" + sb.toString() + ") atsTemp"));
                if (rs.next()) {
                    return rs.getInt(1);
                }
            }
            catch (Exception e) {
                AtsLog.getLog().error((Object)"", (Throwable)e);
                return 0;
            }
        }
        return 0;
    }

    public static int getDbType(Context ctx) {
        return DbType.getValue((String)ContextUtil.getDbType((Context)ctx));
    }

    public static String getDbTypeName(Context ctx) {
        return ContextUtil.getDbType((Context)ctx);
    }

    public static String getSortExpression(String sql) {
        if (StringUtils.isBlank((String)sql)) {
            return "";
        }
        String originSql = sql;
        int orderIndex = (sql = sql.toLowerCase()).lastIndexOf(" order by ");
        if (orderIndex != -1 && orderIndex > sql.lastIndexOf(")")) {
            return originSql.substring(orderIndex);
        }
        String firstField = AtsSqlUtile.getFirstSelectField(sql);
        if (firstField == null) {
            return " order by fid";
        }
        return " order by " + firstField;
    }

    public static String getFirstSelectField(String sql) {
        String selectFields = AtsSqlUtile.getSelectExpression(sql);
        String[] fisrtFields = selectFields.split(",");
        int start = 0;
        String firstField = fisrtFields[start];
        while (firstField.contains("(") && !firstField.contains(")") && fisrtFields.length > start) {
            firstField = firstField + fisrtFields[++start];
        }
        fisrtFields = firstField.split("\\s+");
        if ((firstField = fisrtFields[fisrtFields.length - 1].trim()).equals("*")) {
            return null;
        }
        return firstField;
    }

    public static boolean hasSortExpression(String sql) {
        if (StringUtils.isBlank((String)sql)) {
            return false;
        }
        int orderIndex = (sql = sql.toLowerCase()).lastIndexOf(" order by ");
        return orderIndex != -1 && orderIndex > sql.lastIndexOf(")");
    }

    public static String getSelectExpression(String sqlSelect) {
        String selectFields = "*";
        if (!AtsSqlUtile.validateSelectSql(sqlSelect)) {
            throw new IllegalArgumentException("sqlSelect:" + sqlSelect);
        }
        String originSql = sqlSelect.trim();
        String sql = sqlSelect.toLowerCase().trim();
        String[] sqlArr = sql.split("from");
        for (int i = 0; i < sqlArr.length; ++i) {
            int ind = sqlArr[i].indexOf("select");
            if (ind <= -1 || "*".equals(selectFields = sqlArr[i].substring(ind + 6).trim())) continue;
            int index = sql.indexOf(selectFields);
            return originSql.substring(index, index + selectFields.length() + 1);
        }
        return selectFields;
    }

    public static boolean validateSelectSql(String sqlSelect) {
        if (sqlSelect == null) {
            return false;
        }
        String sql = sqlSelect.toLowerCase().trim();
        return sql.length() >= "select * from ".length() && sql.contains("select") && sql.contains("from");
    }

    public static Set<String> getOneField(Context ctx, String sql) {
        OneFieldProcessor process = new OneFieldProcessor(sql, ctx);
        process.setCollectAllData(true).process();
        return process.getNoRepeatAllPageData();
    }

    public static LinkedHashSet<Object> getOneField(IRowSet rowSet) {
        return AtsSqlUtile.getOneField(rowSet, 1);
    }

    public static LinkedHashSet<Object> getOneField(IRowSet rowSet, String column) {
        LinkedHashSet<Object> resu = new LinkedHashSet<Object>();
        try {
            while (rowSet != null && rowSet.next()) {
                resu.add(rowSet.getObject(column));
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return resu;
    }

    public static LinkedHashSet<Object> getOneField(IRowSet rowSet, int column) {
        LinkedHashSet<Object> resu = new LinkedHashSet<Object>();
        try {
            while (rowSet != null && rowSet.next()) {
                resu.add(rowSet.getObject(column));
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return resu;
    }

    public static JSONObject getOneFieldVal(Context ctx, String sql) throws BOSException {
        JSONObject json = new JSONObject(1);
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
            while (rs.next()) {
                json.put("data", rs.getObject(1));
            }
        }
        catch (Exception e) {
            throw new BOSException("getOneFieldVal failure", (Throwable)e);
        }
        if (json.get((Object)"data") == null) {
            throw new BOSException("getOneFieldVal is null");
        }
        return json;
    }

    public static Map<String, String> getTwoField(Context ctx, String sql) {
        TwoFieldProcessor process = new TwoFieldProcessor(sql, ctx);
        ((TwoFieldProcessor)process.setCollectAllData(true)).process();
        return process.getAllPageDataForTwoField();
    }

    public static Map<String, Set<String>> getTwoFieldMultiModel(Context ctx, String sql) {
        TwoFieldProcessor process = new TwoFieldProcessor(sql, ctx);
        ((TwoFieldProcessor)process.setMutiModel(true).setCollectAllData(true)).process();
        return process.getAllPageDataForTwoField();
    }

    public static <T extends CoreBaseInfo> List<T> getList(Context ctx, Object sqlOrEvi, Class<T> objClass) throws BOSException {
        Object colls;
        try {
            colls = AtsEntityUtile.getDatas(ctx, sqlOrEvi, AtsEntityUtile.getEntityObj(ctx, objClass).getObjectCollectionClazzRuntime());
        }
        catch (ClassNotFoundException e) {
            throw new BOSException("get collection class failure,please try again!");
        }
        if (AtsCollectionUtile.isEmpty(colls)) {
            return new ArrayList(0);
        }
        ArrayList<CoreBaseInfo> returnList = new ArrayList<CoreBaseInfo>(colls.size());
        int total = colls.size();
        for (int i = 0; i < total; ++i) {
            returnList.add((CoreBaseInfo)colls.getObject(i));
        }
        return returnList;
    }

    public static void deleteByIds(Context ctx, String tableName, String fieldName, Collection<String> deleteIds) throws BOSException {
        if (StringUtils.isBlank((String)tableName) || StringUtils.isBlank((String)fieldName) || AtsCollectionUtile.isEmpty(deleteIds)) {
            return;
        }
        List<List<String>> groupIds = AtsCollectionUtile.group(deleteIds, AtsConstants.SIZE_COMMON_BATCH);
        Iterator<List<String>> groupIdsIterator = groupIds.iterator();
        StringBuffer insertSql = new StringBuffer();
        insertSql.append("delete from ").append(tableName).append(" where ").append(fieldName).append(" in (?)");
        while (groupIdsIterator.hasNext()) {
            Object[] temp = groupIdsIterator.next().toArray();
            DbUtil.execute((Context)ctx, (String)AtsSqlUtile.processSqlInParam(insertSql.toString(), temp), (Object[])temp);
        }
    }

    public static String processSqlInParam(String sql, Object params) throws BOSException {
        int size = 1;
        if (params == null) {
            size = 1;
        } else if (params instanceof Collection) {
            size = ((Collection)params).size();
        } else if (params instanceof IObjectCollection) {
            size = ((IObjectCollection)params).size();
        } else if (params.getClass().isArray()) {
            size = Array.getLength(params);
        }
        StringBuffer questionParam = new StringBuffer(" in (");
        while (size-- > 0) {
            questionParam.append('?').append(',');
        }
        questionParam.setCharAt(questionParam.length() - 1, ')');
        if (StringUtils.isBlank((String)sql)) {
            return questionParam.toString();
        }
        Matcher matcher = PATTERN_INSQL.matcher(sql);
        return matcher.replaceAll(questionParam.toString());
    }

    public static List<JSONObject> getResultFromRowSet(IRowSet rowSet, String[] columns) throws SQLException {
        ArrayList<JSONObject> returnData = new ArrayList<JSONObject>(rowSet == null ? 0 : rowSet.size());
        if (columns == null) {
            columns = AtsSqlUtile.getColumn(rowSet);
        }
        while (rowSet != null && rowSet.next()) {
            returnData.add(AtsSqlUtile.assembleRow(rowSet, columns, new JSONObject()));
        }
        return returnData;
    }

    public static List<Object> getResultFromRowSet(IRowSet iRowSet, String column) {
        ArrayList<Object> result = new ArrayList<Object>();
        if (iRowSet != null && StringUtils.isNotBlank((String)column)) {
            try {
                while (iRowSet.next()) {
                    result.add(iRowSet.getObject(column));
                }
                iRowSet.beforeFirst();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    public static List<Object> getResultFromRowSetByFirstCol(IRowSet iRowSet) {
        ArrayList<Object> result = new ArrayList<Object>();
        if (iRowSet != null) {
            try {
                while (iRowSet.next()) {
                    result.add(iRowSet.getObject(1));
                }
                iRowSet.beforeFirst();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    public static JSONObject assembleRow(IRowSet rowSet, String[] columns, JSONObject row) throws SQLException {
        if (columns == null) {
            columns = AtsSqlUtile.getColumn(rowSet);
        }
        if (row == null) {
            row = new JSONObject(columns.length);
        }
        if (rowSet == null) {
            return row;
        }
        for (String column : columns) {
            row.put(column, rowSet.getObject(column));
        }
        return row;
    }

    public static String[] getColumn(IRowSet rowSet) throws SQLException {
        if (rowSet == null) {
            return new String[0];
        }
        ResultSetMetaData allColumn = rowSet.getMetaData();
        int columnCount = allColumn.getColumnCount();
        String[] columns = new String[columnCount];
        for (int i = 1; i <= columnCount; ++i) {
            if (StringUtils.isNotEmpty((String)allColumn.getColumnLabel(i))) {
                columns[i - 1] = allColumn.getColumnLabel(i);
                continue;
            }
            columns[i] = allColumn.getColumnName(i);
        }
        return columns;
    }

    public static Map<String, String> getColumnAlias(IRowSet rowSet) throws SQLException {
        if (rowSet == null) {
            return AtsCollectionUtile.emptyMap();
        }
        ResultSetMetaData allColumn = rowSet.getMetaData();
        int columnCount = allColumn.getColumnCount();
        HashMap<String, String> columnAlias = new HashMap<String, String>(columnCount);
        for (int i = 1; i <= columnCount; ++i) {
            columnAlias.put(allColumn.getColumnName(i), allColumn.getColumnLabel(i));
        }
        return columnAlias;
    }

    public static <V extends CoreBaseInfo> Map<String, V> getBaseInfoMap(Context ctx, String fieldName, Object fieldVal, Class<V> classObj) {
        HashSet<Object> fieldVals;
        if (fieldVal instanceof Set) {
            fieldVals = (HashSet)fieldVal;
        } else if (fieldVal instanceof Collection) {
            fieldVals = new HashSet((Collection)fieldVal);
        } else if (fieldVal instanceof String) {
            fieldVals = new HashSet<String>(Arrays.asList(fieldVal.toString().split(",")));
        } else {
            AtsLog.getLog().error((Object)("fieldVal error: " + fieldVal));
            return new HashMap();
        }
        String[] selectors = new String[]{"id", "name", "number"};
        EntityViewInfo evi = AtsViewUtile.getViewBySelector(selectors);
        String string = fieldName = fieldName == null ? "id" : fieldName;
        if (!Arrays.asList(selectors).contains(fieldName)) {
            AtsViewUtile.getViewBySelector(new String[]{fieldName}, evi);
        }
        AtsViewUtile.getViewByFilter(fieldName, fieldVals, CompareType.INCLUDE, evi);
        CoreBaseCollection coll = null;
        ICoreBase iCoreBase = null;
        try {
            iCoreBase = AtsEntityUtile.getBizInterface(ctx, classObj);
        }
        catch (BOSException e1) {
            e1.printStackTrace();
        }
        try {
            if (iCoreBase != null) {
                coll = iCoreBase.getCollection(evi);
            }
        }
        catch (BOSException e) {
            AtsLog.getLog().error((Object)e.getMessage(), (Throwable)e);
        }
        if (AtsCollectionUtile.isEmpty(coll)) {
            return new HashMap();
        }
        return AtsCollectionUtile.toMap((IObjectCollection)coll, fieldName, classObj);
    }

    public static <V extends CoreBaseInfo> Map<String, JSONObject> getBaseInfoJsMap(Context ctx, String fieldName, Object fieldVal, Class<V> classObj) {
        Map<String, V> infoMap = AtsSqlUtile.getBaseInfoMap(ctx, fieldName, fieldVal, classObj);
        HashMap<String, JSONObject> returnMap = new HashMap<String, JSONObject>(infoMap.size());
        Iterator<Map.Entry<String, V>> it = infoMap.entrySet().iterator();
        while (it.hasNext()) {
            JSONObject jsonObj = new JSONObject();
            Map.Entry<String, V> baseInfo = it.next();
            jsonObj.put("name", ((CoreBaseInfo)baseInfo.getValue()).get("name"));
            jsonObj.put("id", (Object)((CoreBaseInfo)baseInfo.getValue()).get("id").toString());
            jsonObj.put("number", ((CoreBaseInfo)baseInfo.getValue()).get("number"));
            Object fieldNameVal = ((CoreBaseInfo)baseInfo.getValue()).get(fieldName);
            jsonObj.put(fieldName, (Object)(fieldNameVal == null ? "" : fieldNameVal.toString()));
            returnMap.put(((CoreBaseInfo)baseInfo.getValue()).get(fieldName).toString(), jsonObj);
        }
        return returnMap;
    }
}

