/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.ats.util.common;

import com.alibaba.fastjson.JSONObject;
import com.kingdee.eas.hr.ats.util.common.AtsCollectionUtile;
import com.kingdee.shr.base.syssetting.util.SHRCheck;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;

public abstract class AtsXmlUtile {
    public static final int ANCHOR_TYPE_ELE = 1;
    public static final int ANCHOR_TYPE_ATTR = 2;
    public static final int ANCHOR_TYPE_VAL = 3;
    public static final String ANCHOR_TYPE = "anchorType";
    public static final String ANCHOR_NAME = "anchorName";
    public static final String ANCHOR_VALUE = "anchorValue";
    public static final String ANCHOR_MODEL = "anchorModel";
    public static final int ANCHOR_Model_ADD = 1;
    public static final int ANCHOR_Model_UPDATE = 2;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Document updateFile(String filePath, List<? extends Object> elementAnchorList, Object updateAnchor) throws DocumentException, IOException {
        try (FileInputStream fileInputStream = null;){
            fileInputStream = new FileInputStream(filePath);
            Document document = AtsXmlUtile.update((InputStream)fileInputStream, elementAnchorList, updateAnchor);
            return document;
        }
    }

    public static Document updateFile(String filePath, String elementAnchors, Object updateAnchor) throws DocumentException, IOException {
        return AtsXmlUtile.updateFile(filePath, Collections.singletonList(elementAnchors), updateAnchor);
    }

    public static void updateAndWrite(String filePath, List<? extends Object> elementAnchorList, Object updateAnchor) throws DocumentException, IOException {
        Document doc = AtsXmlUtile.updateFile(filePath, elementAnchorList, updateAnchor);
        AtsXmlUtile.writeFile(doc, filePath);
    }

    public static void updateAndWrite(String filePath, String elementAnchors, Object updateAnchor) throws DocumentException, IOException {
        Document doc = AtsXmlUtile.updateFile(filePath, elementAnchors, updateAnchor);
        AtsXmlUtile.writeFile(doc, filePath);
    }

    public static String updateContent(String contens, String elementAnchors, Object updateAnchor) throws DocumentException, IOException {
        List<JSONObject> elementAnchorList = AtsXmlUtile.formatAnchor(Collections.singletonList(elementAnchors));
        return AtsXmlUtile.updateContent(contens, elementAnchorList, updateAnchor);
    }

    public static String updateContent(String contens, List<? extends Object> elementAnchorList, Object updateAnchor) throws DocumentException, IOException {
        if (StringUtils.isBlank((String)contens)) {
            return contens;
        }
        ByteArrayInputStream byteInputStream = new ByteArrayInputStream(contens.getBytes());
        Document doc = AtsXmlUtile.update((InputStream)byteInputStream, elementAnchorList, updateAnchor);
        return doc.asXML();
    }

    public static Document update(InputStream inputStream, String elementAnchors, Object updateAnchor) throws DocumentException {
        List<JSONObject> elementAnchorList = AtsXmlUtile.formatAnchor(Collections.singletonList(elementAnchors));
        return AtsXmlUtile.update(inputStream, elementAnchorList, updateAnchor);
    }

    public static Document update(InputStream inputStream, List<? extends Object> elementAnchorList, Object updateAnchor) throws DocumentException {
        if (inputStream == null) {
            return null;
        }
        Element updateEle = AtsXmlUtile.find(inputStream, AtsXmlUtile.formatAnchor(elementAnchorList));
        Document doc = AtsXmlUtile.update(updateEle, updateAnchor);
        return doc == null ? new SAXReader().read(inputStream) : doc;
    }

    public static Document update(Element element, Object updateAnchor) {
        boolean isAddModel;
        if (element == null) {
            return null;
        }
        JSONObject curAnchor = null;
        if (updateAnchor instanceof String && StringUtils.isNotBlank((String)((String)updateAnchor))) {
            curAnchor = new JSONObject();
            curAnchor.put(ANCHOR_TYPE, (Object)3);
            curAnchor.put(ANCHOR_VALUE, (Object)((String)updateAnchor));
        } else if (updateAnchor instanceof JSONObject) {
            curAnchor = (JSONObject)updateAnchor;
        }
        if (curAnchor == null) {
            throw new IllegalArgumentException("updateAnchor:" + updateAnchor);
        }
        boolean bl = isAddModel = curAnchor.getIntValue(ANCHOR_MODEL) == 1;
        if (1 == curAnchor.getIntValue(ANCHOR_TYPE)) {
            element.setName((isAddModel ? element.getName() : "") + curAnchor.getString(ANCHOR_VALUE));
        } else if (2 == curAnchor.getIntValue(ANCHOR_TYPE)) {
            Attribute attribute = element.attribute(curAnchor.getString(ANCHOR_NAME));
            if (attribute != null) {
                attribute.setValue((isAddModel ? attribute.getValue() : "") + curAnchor.getString(ANCHOR_VALUE));
            }
        } else if (3 == curAnchor.getIntValue(ANCHOR_TYPE)) {
            element.setText((isAddModel ? element.getText() : "") + curAnchor.getString(ANCHOR_VALUE));
        }
        return element.getDocument();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Element getRootElement(String file) throws DocumentException, FileNotFoundException {
        if (StringUtils.isBlank((String)file)) {
            return null;
        }
        SAXReader reader = new SAXReader();
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(SHRCheck.checkFilePath((String)file));
            Document doc = reader.read((InputStream)fileInputStream);
            Element element = doc.getRootElement();
            return element;
        }
        finally {
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static Element getRootElement(InputStream inputStream) throws DocumentException {
        if (inputStream == null) {
            return null;
        }
        SAXReader reader = new SAXReader();
        Document doc = reader.read(inputStream);
        return doc.getRootElement();
    }

    public static Element getRootElementFromContent(String contens) throws DocumentException, FileNotFoundException {
        if (StringUtils.isBlank((String)contens)) {
            return null;
        }
        SAXReader reader = new SAXReader();
        Document doc = reader.read((InputStream)new ByteArrayInputStream(contens.getBytes()));
        return doc.getRootElement();
    }

    public static JSONObject getValue(InputStream inputStream, List<? extends Object> elementAnchorList, Object getAnchor) throws DocumentException {
        Element targetEle = AtsXmlUtile.find(AtsXmlUtile.getRootElement(inputStream), AtsXmlUtile.formatAnchor(elementAnchorList));
        return AtsXmlUtile.getValue(targetEle, getAnchor);
    }

    public static JSONObject getValue(String file, List<? extends Object> elementAnchorList, Object getAnchor) throws DocumentException, FileNotFoundException {
        Element targetEle = AtsXmlUtile.find(AtsXmlUtile.getRootElement(file), AtsXmlUtile.formatAnchor(elementAnchorList));
        return AtsXmlUtile.getValue(targetEle, getAnchor);
    }

    public static JSONObject getValueFromContent(String contents, List<? extends Object> elementAnchorList, Object getAnchor) throws DocumentException, FileNotFoundException {
        Element targetEle = AtsXmlUtile.find(AtsXmlUtile.getRootElementFromContent(contents), AtsXmlUtile.formatAnchor(elementAnchorList));
        return AtsXmlUtile.getValue(targetEle, getAnchor);
    }

    public static JSONObject getValue(Element element, Object getAnchor) {
        if (element == null) {
            return AtsCollectionUtile.emptyJsonObj();
        }
        if (getAnchor == null || getAnchor instanceof String) {
            return AtsCollectionUtile.sigleTon("value", element.getText());
        }
        if (getAnchor instanceof JSONObject) {
            JSONObject anchor = (JSONObject)getAnchor;
            if (1 == anchor.getIntValue(ANCHOR_TYPE)) {
                return AtsCollectionUtile.sigleTon("value", element.getName());
            }
            if (2 == anchor.getIntValue(ANCHOR_TYPE)) {
                Attribute attr = element.attribute(anchor.getString(ANCHOR_VALUE));
                if (attr != null) {
                    return AtsCollectionUtile.sigleTon("value", attr.getValue());
                }
            } else if (3 == anchor.getIntValue(ANCHOR_TYPE)) {
                return AtsCollectionUtile.sigleTon("value", element.getText());
            }
        }
        return AtsCollectionUtile.emptyJsonObj();
    }

    public static Element find(InputStream inputStream, List<? extends Object> elementAnchorList) throws DocumentException {
        return AtsXmlUtile.find(AtsXmlUtile.getRootElement(inputStream), AtsXmlUtile.formatAnchor(elementAnchorList));
    }

    public static Element find(String file, List<? extends Object> elementAnchorList) throws DocumentException, FileNotFoundException {
        return AtsXmlUtile.find(AtsXmlUtile.getRootElement(file), AtsXmlUtile.formatAnchor(elementAnchorList));
    }

    public static Element findFromContent(String contents, List<? extends Object> elementAnchorList) throws DocumentException, FileNotFoundException {
        return AtsXmlUtile.find(AtsXmlUtile.getRootElementFromContent(contents), AtsXmlUtile.formatAnchor(elementAnchorList));
    }

    public static Element findPre(Element element) {
        return AtsXmlUtile.findByIndexDiff(element, -1);
    }

    public static Element findNext(Element element) {
        return AtsXmlUtile.findByIndexDiff(element, 1);
    }

    public static Element findByIndexDiff(Element element, int indexDiffWithElement) {
        Element parent;
        Element element2 = parent = element == null ? null : element.getParent();
        if (parent != null) {
            int count = parent.elements().size();
            for (int i = 0; i < count; ++i) {
                if (parent.elements().get(i) != element || i + indexDiffWithElement <= -1 || i + indexDiffWithElement >= count) continue;
                return (Element)parent.elements().get(i + indexDiffWithElement);
            }
        }
        return null;
    }

    public static Element findSibling(Element element, Object anchor) {
        if (element == null) {
            return null;
        }
        Element parent = element.getParent();
        if (parent != null && anchor != null) {
            JSONObject curAnchor = null;
            if (anchor instanceof String && StringUtils.isNotBlank((String)((String)anchor))) {
                curAnchor = new JSONObject();
                curAnchor.put(ANCHOR_TYPE, (Object)3);
                curAnchor.put(ANCHOR_VALUE, (Object)((String)anchor));
            } else if (anchor instanceof JSONObject) {
                curAnchor = (JSONObject)anchor;
            }
            int count = parent.elements().size();
            for (int i = 0; i < count; ++i) {
                if (!AtsXmlUtile.satisfyAnchor((Element)parent.elements().get(i), curAnchor)) continue;
                return (Element)parent.elements().get(i);
            }
        }
        return null;
    }

    public static Element find(Element root, List<JSONObject> elementAnchorList) {
        Element returnEle = null;
        if (AtsCollectionUtile.isEmpty(elementAnchorList) || root == null) {
            return returnEle;
        }
        int anchorCount = elementAnchorList.size();
        for (int i = 0; i < anchorCount; ++i) {
            if (AtsXmlUtile.satisfyAnchor(root, elementAnchorList.get(i))) {
                if (elementAnchorList.size() == 1) {
                    return root;
                }
                returnEle = AtsXmlUtile.find(root, elementAnchorList.subList(1, anchorCount));
            }
            if (returnEle != null) break;
            for (Object ele : root.elements()) {
                if (((Element)ele).getNodeType() == 2 || ((Element)ele).getNodeType() == 3 || (returnEle = AtsXmlUtile.find((Element)ele, elementAnchorList)) == null) continue;
                return returnEle;
            }
        }
        return returnEle;
    }

    public static List<JSONObject> formatAnchor(List<? extends Object> elementAnchorList) {
        if (AtsCollectionUtile.isEmpty(elementAnchorList)) {
            return Collections.emptyList();
        }
        ArrayList<JSONObject> curAnchorList = new ArrayList<JSONObject>();
        for (int i = 0; i < elementAnchorList.size(); ++i) {
            if (elementAnchorList.get(i) instanceof String && StringUtils.isNotBlank((String)((String)elementAnchorList.get(i)))) {
                for (String anchorString : elementAnchorList.get(i).toString().split("/")) {
                    JSONObject anchor = new JSONObject();
                    anchor.put(ANCHOR_TYPE, (Object)1);
                    anchor.put(ANCHOR_VALUE, (Object)anchorString);
                    curAnchorList.add(anchor);
                }
                continue;
            }
            if (!(elementAnchorList.get(i) instanceof JSONObject)) continue;
            curAnchorList.add((JSONObject)elementAnchorList.get(i));
        }
        return curAnchorList;
    }

    public static boolean satisfyAnchor(Element element, JSONObject elementAnchor) {
        Attribute attribute;
        if (element == null) {
            return false;
        }
        return 1 == elementAnchor.getIntValue(ANCHOR_TYPE) ? element.getName().equals(elementAnchor.getString(ANCHOR_VALUE)) : (2 == elementAnchor.getIntValue(ANCHOR_TYPE) ? (attribute = element.attribute(elementAnchor.getString(ANCHOR_NAME))) != null && attribute.getValue() != null && attribute.getValue().equals(elementAnchor.getString(ANCHOR_VALUE)) : 3 == elementAnchor.getIntValue(ANCHOR_TYPE) && StringUtils.equals((String)element.getText(), (String)elementAnchor.getString(ANCHOR_VALUE)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeFile(Document doc, String filePath) throws IOException, DocumentException {
        if (doc == null || StringUtils.isBlank((String)filePath)) {
            return;
        }
        OutputFormat outputFormat = OutputFormat.createCompactFormat();
        outputFormat.setEncoding("UTF-8");
        outputFormat.setNewlines(true);
        outputFormat.setIndent("   ");
        FileWriter fileWriter = null;
        XMLWriter write = null;
        try {
            fileWriter = new FileWriter(filePath);
            write = new XMLWriter((Writer)fileWriter, outputFormat);
            write.write(doc);
        }
        finally {
            if (write != null) {
                write.close();
            }
            if (fileWriter != null) {
                fileWriter.close();
            }
        }
    }

    public static JSONObject createValueAnchor(Object value) {
        JSONObject anchor = new JSONObject();
        anchor.put(ANCHOR_TYPE, (Object)3);
        anchor.put(ANCHOR_VALUE, (Object)(value == null ? "" : value.toString()));
        return anchor;
    }

    public static JSONObject createAttributeAnchor(Object value) {
        JSONObject anchor = new JSONObject();
        anchor.put(ANCHOR_TYPE, (Object)2);
        anchor.put(ANCHOR_VALUE, (Object)(value == null ? "" : value.toString()));
        return anchor;
    }

    public static JSONObject createEleNameAnchor(Object value) {
        JSONObject anchor = new JSONObject();
        anchor.put(ANCHOR_TYPE, (Object)1);
        anchor.put(ANCHOR_VALUE, (Object)(value == null ? "" : value.toString()));
        return anchor;
    }

    public static List<JSONObject> createEleNameAnchor(String value) {
        return AtsXmlUtile.formatAnchor(Collections.singletonList(value));
    }

    public static List<JSONObject> createEleValueAnchor(String value) {
        if (StringUtils.isBlank((String)value)) {
            return null;
        }
        value = value.trim();
        int ind = value.lastIndexOf("/");
        ArrayList<JSONObject> anchor = new ArrayList(1);
        if (ind > -1) {
            anchor = AtsXmlUtile.createEleNameAnchor(value.substring(0, ind));
        }
        if (ind < value.length() - 1) {
            anchor.add(AtsXmlUtile.createValueAnchor(value.substring(ind + 1)));
        }
        return anchor;
    }

    public static List<JSONObject> createEleAttrAnchor(String value) {
        if (StringUtils.isBlank((String)value)) {
            return null;
        }
        value = value.trim();
        int ind = value.lastIndexOf("/");
        ArrayList<JSONObject> anchor = new ArrayList(1);
        if (ind > -1) {
            anchor = AtsXmlUtile.createEleNameAnchor(value.substring(0, ind));
        }
        if (ind < value.length() - 1) {
            anchor.add(AtsXmlUtile.createAttributeAnchor(value.substring(ind + 1)));
        }
        return anchor;
    }

    public static JSONObject createUpdateAnchor(String anchor) {
        JSONObject updateAnchor = AtsXmlUtile.createValueAnchor(anchor);
        updateAnchor.put(ANCHOR_MODEL, (Object)2);
        return updateAnchor;
    }

    public static JSONObject createUpdateAnchor(JSONObject anchor) {
        if (anchor == null || anchor.isEmpty()) {
            return null;
        }
        anchor.put(ANCHOR_MODEL, (Object)2);
        return anchor;
    }
}

