/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.ats.util.common;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.configure.ConfigMDUtil;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.ats.AtsShiftInfo;
import com.kingdee.eas.hr.ats.AtsTakeWorkingInfo;
import com.kingdee.eas.hr.ats.AtsTurnShiftInfo;
import com.kingdee.eas.hr.ats.AttenceGroupInfo;
import com.kingdee.eas.hr.ats.AttencePolicyInfo;
import com.kingdee.eas.hr.ats.HolidayPolicySetInfo;
import com.kingdee.eas.hr.ats.util.common.AtsEntityUtile;
import com.kingdee.eas.hr.ats.vo.common.AtsCtx;
import com.kingdee.shr.base.syssetting.SHRBasicItemFactory;
import com.kingdee.shr.base.syssetting.SHRBasicItemInfo;
import com.kingdee.shr.base.syssetting.util.BaseMetaDataUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class AvailableBaseInofUtile {
    private static final Map<Class<? extends CoreBaseInfo>, AvailabelBaseInfo> AVAILABLE_MAP = new HashMap<Class<? extends CoreBaseInfo>, AvailabelBaseInfo>();

    private static void initSystemBaseInfo() {
        AvailableBaseInofUtile.addBaseInfo(AtsShiftInfo.class, true);
        AvailableBaseInofUtile.addBaseInfo(AttencePolicyInfo.class, true);
        AvailableBaseInofUtile.addBaseInfo(HolidayPolicySetInfo.class, true);
        AvailableBaseInofUtile.addBaseInfo(AtsTakeWorkingInfo.class, true);
        AvailableBaseInofUtile.addBaseInfo(AttenceGroupInfo.class, true);
        AvailableBaseInofUtile.addBaseInfo(AtsTurnShiftInfo.class, true);
    }

    private static void addBaseInfo(Class<? extends CoreBaseInfo> baseInfoClass, boolean bindAdmin) {
        AVAILABLE_MAP.put(baseInfoClass, new AvailabelBaseInfo(baseInfoClass, bindAdmin));
    }

    public static AvailabelBaseInfo get(Class<? extends CoreBaseInfo> baseInfoClass) {
        AvailabelBaseInfo res = AVAILABLE_MAP.get(baseInfoClass);
        return res == null ? new AvailabelBaseInfo(baseInfoClass, false) : res;
    }

    static {
        AvailableBaseInofUtile.initSystemBaseInfo();
    }

    public static class AvailabelBaseInfo
    extends AtsCtx {
        Class<? extends CoreBaseInfo> baseInfoClass;
        Class<? extends CoreBaseInfo> availableInfoClass;
        boolean bindAdmin;
        String baseTable;
        String availableTable;

        public AvailabelBaseInfo(Class<? extends CoreBaseInfo> baseInfoClass, boolean bindAdmin) {
            this.baseInfoClass = baseInfoClass;
            this.availableInfoClass = this.availableInfoClass;
            this.bindAdmin = bindAdmin;
        }

        public Class<? extends CoreBaseInfo> getBaseInfoClass() {
            return this.baseInfoClass;
        }

        public Class<? extends CoreBaseInfo> getAvailableInfoClass() {
            if (this.availableInfoClass == null) {
                this.initAvaiableInfo();
            }
            return this.availableInfoClass;
        }

        public boolean isBindAdmin() {
            return this.bindAdmin;
        }

        public String getBaseTable() {
            if (this.baseTable == null && this.baseInfoClass != null) {
                this.initAvaiableInfo();
            }
            return this.baseTable;
        }

        public String getAvailableTable() {
            if (this.availableTable == null && this.availableInfoClass != null) {
                this.initAvaiableInfo();
            }
            return this.availableTable;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof AvailabelBaseInfo)) {
                return false;
            }
            AvailabelBaseInfo that = (AvailabelBaseInfo)o;
            return this.bindAdmin == that.bindAdmin && Objects.equals(this.baseInfoClass, that.baseInfoClass) && Objects.equals(this.availableInfoClass, that.availableInfoClass) && Objects.equals(this.baseTable, that.baseTable) && Objects.equals(this.availableTable, that.availableTable);
        }

        public int hashCode() {
            return Objects.hash(this.baseInfoClass, this.availableInfoClass, this.bindAdmin, this.baseTable, this.availableTable);
        }

        protected void initAvaiableInfo() {
            EntityObjectInfo baseEntityInfo = AtsEntityUtile.getEntityObj(this.ctx, this.baseInfoClass);
            EntityViewInfo evi = new EntityViewInfo();
            evi.getSelector().add("entityName");
            evi.getSelector().add("relationHREntity");
            FilterInfo fileFilter = new FilterInfo();
            fileFilter.getFilterItems().add(new FilterItemInfo("entityName", (Object)baseEntityInfo.getFullName(), CompareType.INCLUDE));
            evi.setFilter(fileFilter);
            this.ctx = this.ctx == null ? ConfigMDUtil.getContext() : this.ctx;
            try {
                SHRBasicItemInfo basicItemInfo = SHRBasicItemFactory.getLocalInstance((Context)this.ctx).getSHRBasicItemInfo(evi.toString());
                String relationHREntity = basicItemInfo.getRelationHREntity();
                EntityObjectInfo relationEntity = BaseMetaDataUtil.getEntityObjectByEntityName((Context)this.ctx, (String)relationHREntity);
                this.availableInfoClass = Class.forName(relationEntity.getObjectValueClassRuntime(), true, this.baseInfoClass.getClassLoader());
                this.availableTable = AtsEntityUtile.getTableName(relationEntity);
                this.baseTable = AtsEntityUtile.getTableName(this.ctx, this.baseInfoClass);
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
            catch (EASBizException e) {
                e.printStackTrace();
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
            AVAILABLE_MAP.put(this.baseInfoClass, this);
        }

        public String toString() {
            return "AvailabelBaseIno [baseInfoClass=" + this.baseInfoClass + ", availableInfoClass=" + this.availableInfoClass + "]";
        }
    }
}

