/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.ats.util.common.BackJob;

import com.kingdee.eas.hr.ats.AtsNounCommonResEnum;
import com.kingdee.eas.hr.ats.util.common.AtsLog;
import com.kingdee.eas.hr.ats.util.common.BackJob.BackJobUtile;
import com.kingdee.eas.hr.ats.util.common.BackJob.IBackJobExecutor;
import com.kingdee.eas.hr.ats.util.common.ConfigAts;
import com.kingdee.eas.hr.ats.util.common.MLUtile;
import com.kingdee.eas.hr.ats.vo.common.AtsErrorMsg;
import java.util.Calendar;

public abstract class AbstractBackJobExecutor
extends AtsErrorMsg
implements IBackJobExecutor {
    private boolean canOnlyExecuteOneBackJob;
    private Calendar executeStartTime;

    @Override
    public void beforeExecute() throws Exception {
        ConfigAts.updateConfigAtsFromParam(this.ctx);
        ConfigAts.enableKSQLOutput();
        if (this.canOnlyExecuteOneBackJob && BackJobUtile.hasRunningJobById(this.ctx)) {
            String msg = MLUtile.getRes(AtsNounCommonResEnum.WaitForRuningMission, this.ctx);
            this.ctx.put((Object)"exception", (Object)msg);
            BackJobUtile.reStartJob(this.ctx, BackJobUtile.getJobParam(this.ctx), 5000L);
            AtsLog.getWSLog().error((Object)msg);
            throw new RuntimeException(msg);
        }
        this.executeStartTime = Calendar.getInstance();
    }

    @Override
    public void afterExecute() throws Exception {
        ConfigAts.enableKSQLOutput();
    }

    @Override
    public final void execute() throws Exception {
        try {
            AtsLog.getLog().error((Object)"strart execute backJob...");
            this.beforeExecute();
            AtsLog.getLog().error((Object)" backJob executing...");
            this.executeInner();
        }
        catch (Exception e) {
            this.handleException(e);
        }
        finally {
            AtsLog.getLog().error((Object)"backJob execute complete!");
            this.afterExecute();
        }
    }

    public void handleException(Exception e) throws Exception {
        throw new Exception(e);
    }

    protected void executeInner() throws Exception {
    }

    public final Calendar getExecuteStartTime() {
        return this.executeStartTime;
    }

    public final void setExecuteStartTime(Calendar executeStartTime) {
        this.executeStartTime = executeStartTime;
    }

    public boolean isCanOnlyExecuteOneBackJob() {
        return this.canOnlyExecuteOneBackJob;
    }

    public void setCanOnlyExecuteOneBackJob(boolean canOnlyExecuteOneBackJob) {
        this.canOnlyExecuteOneBackJob = canOnlyExecuteOneBackJob;
    }
}

