/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.ats.util.common.BackJob;

import com.kingdee.bos.Context;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.ats.util.common.AtsCollectionUtile;
import com.kingdee.eas.hr.ats.util.common.AtsLog;
import com.kingdee.eas.hr.ats.util.common.BackJob.AbstractBackJobExecutor;
import com.kingdee.eas.hr.ats.util.common.OneFieldProcessor;
import java.lang.reflect.ParameterizedType;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public abstract class AbstractPlanExecutor<T extends CoreBaseInfo>
extends AbstractBackJobExecutor {
    private String planIds;
    private String mainTable;
    private String entryTable;
    protected Class<T> parameterizedClass;

    @Override
    public void beforeExecute() throws Exception {
        super.beforeExecute();
        this.parameterizedClass = (Class)((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[0];
    }

    @Override
    protected void executeInner() throws Exception {
        if (this.ctx == null) {
            AtsLog.getLog().error((Object)"please set context!");
            return;
        }
        String planItemSql = this.getPlanIdsSql();
        if (StringUtils.isEmpty((String)planItemSql)) {
            AtsLog.getLog().error((Object)"the sql to fech plan is null!");
            return;
        }
        new OneFieldProcessor<String>(planItemSql, this.ctx){

            @Override
            protected void afterGetAllRow(Context ctx, List<String> rows) {
                try {
                    AbstractPlanExecutor.this.innerExecutePlanes(AbstractPlanExecutor.this.getPlans(ctx, rows, this.outData));
                }
                catch (Exception e) {
                    AtsLog.getLog().error((Object)e);
                }
            }
        }.process();
    }

    protected void innerExecutePlanes(List<T> planItems) throws Exception {
        if (AtsCollectionUtile.isEmpty(planItems)) {
            AtsLog.getLog().error((Object)"plans is null!");
            return;
        }
        try {
            this.beforeExecutePlans(planItems);
            this.executePlanes(planItems);
        }
        finally {
            this.afterExecutePlans(planItems);
        }
    }

    protected void beforeExecutePlans(List<T> plans) {
    }

    protected void afterExecutePlans(List<T> plans) {
    }

    protected void beforeExecutePlan(T plan) {
    }

    protected void afterExecutePlan(T plan) {
    }

    protected String getPlanIdsSql() {
        StringBuffer sql = new StringBuffer();
        sql.append(" select entryTable.fid fid from ").append(this.mainTable).append(" mainTale ");
        sql.append(" inner join ").append(this.entryTable).append(" entryTable  on mainTale.fid = entryTable.fgroupId");
        sql.append(" where 1=1");
        if (StringUtils.isNotEmpty((String)this.planIds)) {
            String appointedSet = AtsCollectionUtile.joinForSqlWithBrackets(Arrays.asList(this.planIds.split(",|\uff0c")));
            sql.append(" and ( mainTale.fid in ").append(appointedSet);
            sql.append(" or mainTale.fnumber in ").append(appointedSet).append(")");
        } else {
            sql.append(" and mainTale.fautoRun = 1 and mainTale.fstate = 1");
        }
        sql.append(" order by mainTale.fnumber,entryTable.fid");
        return sql.toString();
    }

    protected abstract List<T> getPlans(Context var1, Collection<String> var2, Object var3);

    protected void executePlanes(List<T> planItems) {
        for (CoreBaseInfo planItem : planItems) {
            this.beforeExecutePlan(planItem);
            this.executePlane(planItem);
            this.afterExecutePlan(planItem);
        }
    }

    protected abstract void executePlane(T var1);

    public String getPlanIds() {
        return this.planIds;
    }

    public void setPlanIds(String planIds) {
        this.planIds = planIds;
    }

    public final String getMainTable() {
        return this.mainTable;
    }

    public final void setMainTable(String mainTable) {
        this.mainTable = mainTable;
    }

    public final String getEntryTable() {
        return this.entryTable;
    }

    public final void setEntryTable(String entryTable) {
        this.entryTable = entryTable;
    }

    public final Class<T> getParameterizedClass() {
        return this.parameterizedClass;
    }

    public final void setParameterizedClass(Class<T> parameterRizedClass) {
        this.parameterizedClass = parameterRizedClass;
    }
}

