/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.ats.util.common.BackJob;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.metadata.bo.ParameterCollection;
import com.kingdee.bos.service.job.JobServiceFactory;
import com.kingdee.bos.service.job.core.Configuration;
import com.kingdee.bos.service.job.core.JobDef;
import com.kingdee.bos.service.job.core.Wrapper;
import com.kingdee.bos.service.job.wrapper.FunctionWrapper;
import com.kingdee.eas.base.job.JobDefCategoryCollection;
import com.kingdee.eas.base.job.JobDefCategoryInfo;
import com.kingdee.eas.hr.ats.AtsCommonBizException;
import com.kingdee.eas.hr.ats.AtsCommonResEnum;
import com.kingdee.eas.hr.ats.util.common.AtsCollectionUtile;
import com.kingdee.eas.hr.ats.util.common.AtsLog;
import com.kingdee.eas.hr.ats.util.common.BackJob.BackJobUtile;
import com.kingdee.eas.hr.ats.util.common.MLUtile;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.util.Uuid;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class BaseBackJob {
    private Context ctx;
    private String jobDefId = Uuid.randomUUID().toString() + "BGJOBDEF";
    private String title;
    private String facade;
    private String operation;
    private JobDefCategoryInfo categrory;
    private String mutex;
    private String innerMutex;
    private String categoryNum;
    private FunctionWrapper.Parameter[] params;
    private Map<String, Object> parameterValues;
    private JobDef jobDef;
    private boolean titleMutex = false;

    public BaseBackJob() {
    }

    public BaseBackJob(Context ctx) {
        this.ctx = ctx;
    }

    public BaseBackJob(Context ctx, String facade, String operation, String categoryNum) throws Exception {
        this.ctx = ctx;
        this.facade = facade;
        this.operation = operation;
        this.categoryNum = categoryNum;
        this.init();
    }

    public BaseBackJob(Context ctx, String facade, String operation, String categoryNum, Map<String, Object> parameterValues) throws Exception {
        this.ctx = ctx;
        this.facade = facade;
        this.operation = operation;
        this.categoryNum = categoryNum;
        this.parameterValues = parameterValues;
        this.init();
    }

    public final void init() throws Exception {
        this.initCategrory();
        this.initTitle();
        this.initParameters();
        String[] paramTypes = new String[this.params.length];
        for (int i = 0; i < this.params.length; ++i) {
            paramTypes[i] = this.params[i] == null ? "" : this.params[i].type;
        }
        if (this.titleMutex && BackJobUtile.hasRunningJob(this.ctx, this.facade, this.operation, paramTypes)) {
            throw new AtsCommonBizException(AtsCommonBizException.REPEATTASKANDSEE);
        }
        this.initMutex();
        this.initInnerMutex();
        this.mutex = this.innerMutex + this.mutex;
        this.jobDef = this.createJobDefInstance();
        this.createAndSaveJobInstance(this.jobDefId);
    }

    protected JobDef createJobDefInstance() throws Exception {
        FunctionWrapper wrapper = new FunctionWrapper(this.facade, this.operation, this.params);
        JobDef jobDef = new JobDef(this.jobDefId, this.ctx, null, this.title, null, null, null, true, (Wrapper)wrapper, false, this.mutex, 500, -1, Configuration.defaultJobIsolationLevel(), null);
        jobDef.setCategoryId(this.categrory == null ? "" : this.categrory.getId().toString());
        JobServiceFactory.getLocalInstance((Context)this.ctx).createJobDef(jobDef);
        return jobDef;
    }

    public void createAndSaveJobInstance(String jobDefId) throws BOSException {
        JobServiceFactory.getLocalInstance((Context)this.ctx).createJobInstance(jobDefId, null, null);
    }

    protected void initParameters() throws Exception {
        if (this.params != null) {
            return;
        }
        ParameterCollection parameters = BackJobUtile.getParameters(this.ctx, this.facade, this.operation);
        if (AtsCollectionUtile.isEmpty((IObjectCollection)parameters)) {
            return;
        }
        this.params = new FunctionWrapper.Parameter[parameters.size()];
        this.parameterValues = this.parameterValues == null ? new HashMap() : this.parameterValues;
        for (int i = 0; i < parameters.size(); ++i) {
            String name = parameters.get(i).getName();
            String value = this.parameterValues.get(name) == null ? "" : String.valueOf(this.parameterValues.get(name));
            String type = parameters.get(i).getDataType().toUpperCase();
            type = type.equals("DATE") ? "DATETIME" : type;
            this.params[i] = new FunctionWrapper.Parameter(name, "", type, "", value, "");
        }
    }

    protected void initTitle() {
        if (StringUtils.isEmpty((String)this.title)) {
            this.title = this.categrory == null ? "RANDOM" : this.categrory.getName();
        }
        this.title = this.title + "(" + MLUtile.getRes(AtsCommonResEnum.NonautoCreate, this.ctx) + ")";
    }

    protected void initMutex() {
        if (StringUtils.isEmpty((String)this.mutex)) {
            this.mutex = ContextUtil.getCurrentUserInfo((Context)this.ctx).getPerson().getName();
        }
    }

    protected void initInnerMutex() {
        this.innerMutex = StringUtils.isNotEmpty((String)this.facade) && this.facade.contains(".") ? "G::" + this.facade.substring(this.facade.lastIndexOf(".")) : "G::";
    }

    protected void initCategrory() throws Exception {
        if (this.categrory == null && StringUtils.isNotBlank((String)this.categoryNum)) {
            JobDefCategoryCollection categoryColls = BackJobUtile.getJobDefCategory(this.ctx, this.categoryNum);
            if (AtsCollectionUtile.isEmpty((IObjectCollection)categoryColls)) {
                AtsLog.getLog().error((Object)("the number to define backJob is error!  the number is\uff1a" + this.categoryNum));
            } else {
                this.categrory = categoryColls.get(0);
            }
        }
    }

    public Context getCtx() {
        return this.ctx;
    }

    public void setCtx(Context ctx) {
        this.ctx = ctx;
    }

    public String getJobDefId() {
        return this.jobDefId;
    }

    public void setJobDefId(String jobDefId) {
        this.jobDefId = jobDefId;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getFacade() {
        return this.facade;
    }

    public void setFacade(String facade) {
        this.facade = facade;
    }

    public String getOperation() {
        return this.operation;
    }

    public void setOperation(String operation) {
        this.operation = operation;
    }

    public JobDefCategoryInfo getCategrory() {
        return this.categrory;
    }

    public void setCategrory(JobDefCategoryInfo categrory) {
        this.categrory = categrory;
    }

    public String getMutex() {
        return this.mutex;
    }

    public void setMutex(String mutex) {
        this.mutex = mutex;
    }

    public String getInnerMutex() {
        return this.innerMutex;
    }

    public void setInnerMutex(String innerMutex) {
        this.innerMutex = innerMutex;
    }

    public String getCategoryNum() {
        return this.categoryNum;
    }

    public void setCategoryNum(String categoryNum) {
        this.categoryNum = categoryNum;
    }

    public FunctionWrapper.Parameter[] getParams() {
        return this.params;
    }

    public void setParams(FunctionWrapper.Parameter[] params) {
        this.params = params;
    }

    public Map<String, Object> getParameterValues() {
        return this.parameterValues;
    }

    public void setParameterValues(Map<String, Object> parameterValues) {
        this.parameterValues = parameterValues;
    }

    public JobDef getJobDef() {
        return this.jobDef;
    }

    public void setJobDef(JobDef jobDef) {
        this.jobDef = jobDef;
    }

    public boolean isTitleMutex() {
        return this.titleMutex;
    }

    public void setTitleMutex(boolean titleMutex) {
        this.titleMutex = titleMutex;
    }
}

