/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.ats.util.common;

import com.kingdee.bos.Context;
import com.kingdee.eas.basedata.org.HROrgUnitInfo;
import com.kingdee.eas.hr.ats.util.AtsDateUtils;
import com.kingdee.eas.hr.ats.util.common.AtsArrayUtil;
import com.kingdee.eas.hr.ats.util.common.AtsCollectionUtile;
import com.kingdee.eas.hr.ats.util.common.AtsLog;
import com.kingdee.eas.hr.ats.util.common.AtsSqlUtile;
import com.kingdee.eas.hr.ats.util.common.PersonCombineInfoAnalysor;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;

public class BaseRangeSettingAnalysor {
    protected Context ctx;
    private boolean analyzeToPerson = false;
    private boolean analyseNumber = true;
    private boolean useAttFile = false;
    private String beginDate;
    private String endDate;
    private HROrgUnitInfo hrOrgUnit;
    private boolean requireHrOrgUnit = true;
    private String attenceGroups;
    private String adminOrgUnits;
    private boolean includeSub = false;
    private boolean includeEscrow = false;
    private boolean selectedPersonsAttFileModel = false;
    private String selectedPersons;
    private List<String> rangeOthers;
    protected StringBuilder rangeSettingSql = new StringBuilder();
    protected Set<String> analyResults = new HashSet<String>();

    public BaseRangeSettingAnalysor() {
    }

    public BaseRangeSettingAnalysor(Context ctx) {
        this.ctx = ctx;
    }

    public void analyze() {
        this.completeRangeSql();
        if (this.requireHrOrgUnit && (this.hrOrgUnit == null || this.hrOrgUnit.getId() == null)) {
            this.rangeSettingSql = null;
            AtsLog.getWSLog().error((Object)"hrOrgUnit is required!");
        }
        if (this.analyzeToPerson) {
            this.findRangeTarget();
        }
    }

    protected void completeRangeSql() {
        String personField = this.analyseNumber ? "personNum" : "id";
        this.rangeSettingSql.append(" select attPerson.").append(this.analyseNumber ? "fNumber personNum  " : "fid id").append(" from T_HR_ATS_AttendanceFile").append(this.useAttFile ? "" : "HIS").append(" attFileHis ").append(" join T_BD_PERSON attPerson on attFileHis.fProposerID=attPerson.fid");
        this.mergeCustomTable();
        StringBuilder whereSql = new StringBuilder(" where 1=1 ");
        this.mergeCustomWhereSql(whereSql);
        this.mergeDateToWhereSql(whereSql);
        StringBuilder escrowSql = null;
        if (this.includeEscrow) {
            escrowSql = new StringBuilder().append(" union all ").append((CharSequence)this.rangeSettingSql).append((CharSequence)whereSql).append(" and attFileHis.FIsDefaultManage=0");
        }
        this.assembleAdminOrgUnitFilter(whereSql);
        if (StringUtils.isNotEmpty((String)this.selectedPersons)) {
            whereSql.append(" and attFileHis.").append(this.selectedPersonsAttFileModel ? "fid" : "fProposerID").append(" in ").append(AtsArrayUtil.joinForSqlWithBrackets(this.selectedPersons.split(",")));
        }
        this.assembleAttGroupFilter(whereSql);
        this.assembleConditionFilter(whereSql);
        this.rangeSettingSql.insert(0, "select distinct " + personField + " from ( ");
        this.rangeSettingSql.append((CharSequence)whereSql).append(escrowSql == null ? "" : escrowSql);
        this.rangeSettingSql.append(" ) rangeSql order by ").append(personField);
        AtsLog.getLog().info((Object)("rangeSetting sql : " + this.rangeSettingSql));
    }

    protected void mergeDateToWhereSql(StringBuilder whereSql) {
        if (StringUtils.isNotEmpty((String)this.endDate) && StringUtils.isNotEmpty((String)this.beginDate)) {
            whereSql.append(" and attFileHis.feffdt <= {ts '").append(this.endDate).append("'}");
            whereSql.append(" and attFileHis.fleffdt >= {ts '").append(this.beginDate).append("'}");
            return;
        }
        if (StringUtils.isNotEmpty((String)this.beginDate)) {
            whereSql.append(" and attFileHis.feffdt >= {ts '").append(this.beginDate).append("'}");
        }
        if (StringUtils.isNotEmpty((String)this.endDate)) {
            whereSql.append(" and attFileHis.fleffdt <= {ts '").append(this.endDate).append("'}");
        }
    }

    protected void mergeCustomTable() {
    }

    protected void mergeCustomWhereSql(StringBuilder whereSql) {
        whereSql.append(" and attFileHis.FAttendFileState='1' ");
        if (this.hrOrgUnit != null && this.hrOrgUnit.getId() != null) {
            whereSql.append(" and attFileHis.FHrOrgUnitID='").append(this.hrOrgUnit.getId().toString()).append("'");
        } else {
            AtsLog.getWSLog().error((Object)"hrOrgUnit is null!");
        }
    }

    protected void assembleAdminOrgUnitFilter(StringBuilder whereSql) {
        if (StringUtils.isNotEmpty((String)this.adminOrgUnits)) {
            String[] numbers = this.adminOrgUnits.split(",");
            this.rangeSettingSql.append(" join T_ORG_Admin attAdmin on attAdmin.fid=attfileHis.fAdminOrgUnitID");
            whereSql.append(" and ( attAdmin.fLongNumber in ").append(AtsArrayUtil.joinForSqlWithBrackets(numbers));
            if (this.includeSub) {
                whereSql.append(" or ").append(AtsCollectionUtile.join(Arrays.asList(numbers), " or ", "attAdmin.fLongNumber like '", "!%'"));
            }
            whereSql.append(")");
        }
    }

    protected void assembleAttGroupFilter(StringBuilder whereSql) {
        if (StringUtils.isNotEmpty((String)this.attenceGroups)) {
            String curDate = AtsDateUtils.dateLongToString(new Date());
            List<String> groupIds = Arrays.asList(this.attenceGroups.split(","));
            this.rangeSettingSql.append(" join T_HR_ATS_AttenceGroupItem attGroupItem on attPerson.fid=attGroupItem.fProposerID");
            this.rangeSettingSql.append(" join T_HR_ATS_AttenceGroup attGroup on attGroup.fid=attGroupItem.fGroupID");
            whereSql.append(" and attGroup.fid in ").append(AtsCollectionUtile.joinForSqlWithBrackets(groupIds));
            whereSql.append(" and attGroupItem.fendtime >= {ts'" + curDate + "'} and attGroupItem.fstarttime <= {ts'" + curDate + "'}");
        }
    }

    protected void assembleConditionFilter(StringBuilder whereSql) {
        PersonCombineInfoAnalysor personCombineInfoAnalysor;
        String personSql;
        if (!AtsCollectionUtile.isEmpty(this.rangeOthers) && StringUtils.isNotEmpty((String)(personSql = (personCombineInfoAnalysor = new PersonCombineInfoAnalysor(this.rangeOthers)).analyzeToSql(this.ctx, null)))) {
            this.rangeSettingSql.append(" join (").append(personCombineInfoAnalysor.analyzeToSql(this.ctx, null)).append(") conditionTable").append(" on attPerson.fid=conditionTable.\"PERSON.ID\"");
        }
    }

    public Set<String> findRangeTarget() {
        if (this.rangeSettingSql.length() > 0) {
            this.analyResults = AtsSqlUtile.getOneField(this.ctx, this.rangeSettingSql.toString());
        }
        return this.analyResults;
    }

    public StringBuilder getRangeSettingSql() {
        return this.rangeSettingSql;
    }

    public void setRangeSettingSql(StringBuilder rangeSettingSql) {
        this.rangeSettingSql = rangeSettingSql;
    }

    public Set<String> getAnalyResults() {
        return this.analyResults;
    }

    public void setAnalyResults(Set<String> analyResults) {
        this.analyResults = analyResults;
    }

    public Context getCtx() {
        return this.ctx;
    }

    public void setCtx(Context ctx) {
        this.ctx = ctx;
    }

    public String getBeginDate() {
        return this.beginDate;
    }

    public void setBeginDate(String beginDate) {
        this.beginDate = beginDate;
    }

    public String getEndDate() {
        return this.endDate;
    }

    public void setEndDate(String endDate) {
        this.endDate = endDate;
    }

    public String getAttenceGroups() {
        return this.attenceGroups;
    }

    public void setAttenceGroups(String attenceGroups) {
        this.attenceGroups = attenceGroups;
    }

    public String getAdminOrgUnits() {
        return this.adminOrgUnits;
    }

    public void setAdminOrgUnits(String adminOrgUnits) {
        this.adminOrgUnits = adminOrgUnits;
    }

    public boolean isIncludeSub() {
        return this.includeSub;
    }

    public void setIncludeSub(boolean includeSub) {
        this.includeSub = includeSub;
    }

    public boolean isIncludeEscrow() {
        return this.includeEscrow;
    }

    public void setIncludeEscrow(boolean includeEscrow) {
        this.includeEscrow = includeEscrow;
    }

    public String getSelectedPersons() {
        return this.selectedPersons;
    }

    public void setSelectedPersons(String selectedPersons) {
        this.selectedPersons = selectedPersons;
    }

    public HROrgUnitInfo getHrOrgUnit() {
        return this.hrOrgUnit;
    }

    public void setHrOrgUnit(HROrgUnitInfo hrOrgUnit) {
        this.hrOrgUnit = hrOrgUnit;
    }

    public boolean isAnalyzeToPerson() {
        return this.analyzeToPerson;
    }

    public void setAnalyzeToPerson(boolean analyzeToPerson) {
        this.analyzeToPerson = analyzeToPerson;
    }

    public boolean isUseAttFile() {
        return this.useAttFile;
    }

    public void setUseAttFile(boolean useAttFile) {
        this.useAttFile = useAttFile;
    }

    public List<String> getRangeOthers() {
        return this.rangeOthers;
    }

    public void setRangeOthers(List<String> rangeOthers) {
        this.rangeOthers = rangeOthers;
    }

    public boolean isRequireHrOrgUnit() {
        return this.requireHrOrgUnit;
    }

    public void setRequireHrOrgUnit(boolean requireHrOrgUnit) {
        this.requireHrOrgUnit = requireHrOrgUnit;
    }

    public final boolean isAnalyseNumber() {
        return this.analyseNumber;
    }

    public final void setAnalyseNumber(boolean analyseNumber) {
        this.analyseNumber = analyseNumber;
    }

    public boolean isSelectedPersonsAttFileModel() {
        return this.selectedPersonsAttFileModel;
    }

    public void setSelectedPersonsAttFileModel(boolean selectedPersonsAttFileModel) {
        this.selectedPersonsAttFileModel = selectedPersonsAttFileModel;
    }

    public String toString() {
        return "BaseRangeSettingAnalysor [ctx=" + this.ctx + ", analyzeToPerson=" + this.analyzeToPerson + ", useAttFile=" + this.useAttFile + ", beginDate=" + this.beginDate + ", endDate=" + this.endDate + ", hrOrgUnit=" + this.hrOrgUnit + ", requireHrOrgUnit=" + this.requireHrOrgUnit + ", attenceGroups=" + this.attenceGroups + ", adminOrgUnits=" + this.adminOrgUnits + ", includeSub=" + this.includeSub + ", includeEscrow=" + this.includeEscrow + ", selectedPersons=" + this.selectedPersons + ", rangeOthers=" + this.rangeOthers + ", rangeSettingSql=" + this.rangeSettingSql + ", analyResults=" + this.analyResults + "]";
    }
}

