/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.ats.util.common;

import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.bsf.service.classloader.MsfClassLoaderFactory;
import com.kingdee.bos.sql.shell.trace.ConnectionLogger;
import com.kingdee.bos.util.backport.TreeSet;
import com.kingdee.eas.hr.ats.AtsCommonResEnum;
import com.kingdee.eas.hr.ats.util.common.AtsLog;
import com.kingdee.eas.hr.ats.util.common.MLUtile;
import com.kingdee.eas.hr.ats.util.common.ParamUtile;
import com.kingdee.shr.base.syssetting.util.SHRCheck;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Level;

public class ConfigAts {
    public static final String CONFIG_ATS_ADDRESS = "/server/properties/atsConfig";
    public static Level LOG_LEVEL_COMMON = Level.ERROR;
    public static Level LOG_LEVEL_SCHEDULEL = Level.ERROR;
    public static Level LOG_LEVEL_PUNCHCARD_SYN = Level.INFO;
    public static boolean KSQL_OPEN = false;
    public static long KSQL_TIME_THRESHOLD = 0L;
    private static long configLastUpdateTime = 0L;
    private static Map<String, String> staticConfigMap = new TreeMap<String, String>(){
        private static final long serialVersionUID = 1L;
        {
            this.put("LOG_LEVEL_COMMON", "error");
            this.put("LOG_LEVEL_SCHEDULEL", "error");
            this.put("LOG_LEVEL_PUNCHCARD_SYN", "info");
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String updateConfigFile(Map<String, String> properties) {
        Properties config = new Properties(){
            private static final long serialVersionUID = 1L;

            @Override
            public synchronized Enumeration<Object> keys() {
                Enumeration<Object> enumO = super.keys();
                TreeSet keys = new TreeSet();
                while (enumO.hasMoreElements()) {
                    keys.add(enumO.nextElement());
                }
                return Collections.enumeration(keys);
            }
        };
        FileOutputStream fileOutputStream = null;
        try {
            File configFile = new File(SHRCheck.checkFilePath((String)(System.getProperty("EAS_HOME") + CONFIG_ATS_ADDRESS)));
            if (!configFile.exists()) {
                configFile.createNewFile();
            }
            FileInputStream fileInputStream = null;
            try {
                fileInputStream = new FileInputStream(configFile);
                config.load(fileInputStream);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                if (fileInputStream != null) {
                    try {
                        fileInputStream.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
            TreeMap<String, String> configMap = new TreeMap<String, String>(staticConfigMap);
            for (Object object : config.keySet()) {
                configMap.put((String)object, String.valueOf(config.get(object)));
            }
            if (properties != null && properties.size() > 0) {
                configMap.putAll(properties);
            }
            config.clear();
            for (String string : configMap.keySet()) {
                config.put(string, configMap.get(string));
            }
            fileOutputStream = new FileOutputStream(configFile);
            config.store(fileOutputStream, new SimpleDateFormat("YYYY-MM-DD HH:mm:ss").format(Calendar.getInstance().getTime()));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            String string = e.getMessage();
            return string;
        }
        catch (IOException e) {
            String string = e.getMessage();
            return string;
        }
        finally {
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return "operate success";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String updateConfigAts() {
        File configFile = new File(SHRCheck.checkFilePath((String)(System.getProperty("EAS_HOME") + CONFIG_ATS_ADDRESS)));
        if (!configFile.exists() || configFile.lastModified() <= configLastUpdateTime) {
            return "latest version config to refresh";
        }
        Properties config = new Properties();
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(configFile);
            config.load(fileInputStream);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        configLastUpdateTime = configFile.lastModified();
        Set<String> errorMsg = ConfigAts.setStaticParamAction(ConfigAts.getclassParams(config));
        if (errorMsg == null || errorMsg.size() == 0) {
            return "operate success";
        }
        StringBuffer returnMsg = new StringBuffer();
        for (String msg : errorMsg) {
            returnMsg.append(msg).append("<br/>");
        }
        return returnMsg.toString();
    }

    public static String updateConfigAtsFromParam(Context ctx) {
        Set<String> errorMsg;
        try {
            errorMsg = ConfigAts.setStaticParamAction(ConfigAts.getclassParams(ParamUtile.getParamValFuzzy(ctx, "ALL")));
        }
        catch (BOSException e) {
            errorMsg = Collections.singleton("update configAts failure from param,cause : " + e.getMessage());
            AtsLog.getLog().error((Object)e);
        }
        if (errorMsg == null || errorMsg.size() == 0) {
            return MLUtile.getRes(AtsCommonResEnum.UpdateSucc, ctx) + "!";
        }
        StringBuffer returnMsg = new StringBuffer();
        for (String msg : errorMsg) {
            returnMsg.append(msg).append("<br/>");
        }
        return returnMsg.toString();
    }

    public static List<JSONObject> getclassParams(Map config) {
        ArrayList<JSONObject> classParams = new ArrayList<JSONObject>(config.size());
        for (Map.Entry entry : config.entrySet()) {
            String key = entry.getKey().toString();
            JSONObject param = new JSONObject();
            if (!key.contains(".")) {
                param.put("field", (Object)key);
                param.put("class", (Object)ConfigAts.class.getName());
            } else {
                int fieldInd = key.lastIndexOf(".");
                param.put("field", (Object)key.substring(fieldInd + 1));
                param.put("class", (Object)key.substring(0, fieldInd));
            }
            param.put("value", (Object)(entry.getValue() == null ? "" : entry.getValue().toString()));
            classParams.add(param);
        }
        return classParams;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getPropertyFromConfig(String key) {
        Properties config = new Properties();
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(SHRCheck.checkFilePath((String)(System.getProperty("EAS_HOME") + CONFIG_ATS_ADDRESS)));
            config.load(fileInputStream);
            String string = config.getProperty(key);
            return string;
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, String> getPropertyFromConfigs(String[] keys) {
        Properties config = new Properties();
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(SHRCheck.checkFilePath((String)(System.getProperty("EAS_HOME") + CONFIG_ATS_ADDRESS)));
            config.load(fileInputStream);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        if (keys == null || keys.length == 0) {
            return config;
        }
        HashMap<String, String> returMap = new HashMap<String, String>();
        for (String key : keys) {
            if (!config.containsKey(key)) continue;
            returMap.put(key, config.get(key).toString());
        }
        return returMap;
    }

    public static void enableKSQLOutput() {
        ConnectionLogger.setOutput((boolean)KSQL_OPEN);
        ConnectionLogger.setFilterTime((boolean)true);
        ConnectionLogger.setFilterTimeThreshold((long)KSQL_TIME_THRESHOLD);
        KSQL_OPEN = false;
    }

    public static Set<String> setStaticParamAction(List<JSONObject> classParams) {
        HashSet<String> errorMsg = new HashSet<String>();
        if (classParams != null) {
            block2: for (JSONObject classParam : classParams) {
                try {
                    Method[] methods;
                    Class curClass = MsfClassLoaderFactory.getInstance().loadClass(classParam.getString("class"));
                    if (curClass == null) {
                        errorMsg.add("can not find class:" + curClass);
                        continue;
                    }
                    if (classParam.containsKey((Object)"field")) {
                        Field field = curClass.getField(classParam.getString("field"));
                        if (field == null) continue;
                        field.setAccessible(true);
                        Class<?> type = field.getType();
                        if (type.isPrimitive()) {
                            field.set(null, ConfigAts.getPrimitiveObjVal(type, classParam.getString("value")));
                            continue;
                        }
                        if (Level.class.isAssignableFrom(type)) {
                            field.set(null, Level.toLevel((String)classParam.getString("value"), (Level)Level.ERROR));
                            continue;
                        }
                        field.set(null, classParam.getObject("value", type));
                        continue;
                    }
                    if (!classParam.containsKey((Object)"method")) continue;
                    for (Method method : methods = curClass.getMethods()) {
                        if (!method.getName().equals(classParam.getString("method"))) continue;
                        method.invoke(null, ConfigAts.getMethodParam(method, classParam.getString("value")));
                        continue block2;
                    }
                }
                catch (Exception e) {
                    errorMsg.add("call " + classParam + "fail! cause\uff1a" + e.getMessage());
                }
            }
        } else {
            errorMsg.add("null param");
        }
        return errorMsg;
    }

    private static Object[] getMethodParam(Method method, String values) {
        Class<?>[] paramType = method.getParameterTypes();
        if (paramType.length == 0) {
            return null;
        }
        Object[] returnData = new Object[paramType.length];
        for (int i = 0; i < paramType.length; ++i) {
            returnData[i] = paramType[i].isPrimitive() ? Integer.valueOf(0) : (Level.class.isAssignableFrom(paramType[i]) ? paramType[i] : null);
        }
        if (StringUtils.isBlank((String)values)) {
            return returnData;
        }
        String[] args = values.split("@#@");
        for (int i = 0; i < args.length; ++i) {
            returnData[i] = paramType[i].isPrimitive() ? ConfigAts.getPrimitiveObjVal(paramType[i], args[i]) : (Level.class.isAssignableFrom(paramType[i]) ? Level.toLevel((String)args[i], (Level)Level.ERROR) : args[i]);
        }
        return returnData;
    }

    public static Object getPrimitiveObjVal(Class<?> type, String val) {
        if (type == Integer.TYPE) {
            return new Integer(val);
        }
        if (type == Float.TYPE) {
            return new Float(val);
        }
        if (type == Double.TYPE) {
            return new Double(val);
        }
        if (type == Long.TYPE) {
            return new Long(val);
        }
        if (type == Character.TYPE) {
            return new Integer(val);
        }
        if (type == Boolean.TYPE) {
            return new Boolean(val);
        }
        if (type == Short.TYPE) {
            return new Short(val);
        }
        if (type == Byte.TYPE) {
            return new Byte(val);
        }
        return val;
    }

    static {
        try {
            ConfigAts.updateConfigFile(null);
            ConfigAts.updateConfigAts();
        }
        catch (Exception e) {
            AtsLog.getLog().error((Object)e);
        }
    }
}

